<?php
/**
 * Copyright 2003 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_select
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","select");
 loadlayout();

 /**
  * display a task selection form
  */
 class task_select extends layout {
   /**
    *
    */
   Function info() {
     global $lang , $tutos;

     echo "<br><br><center>\n";
     echo "<form name=\"tasksearch\" action=\"task_overview.php\" method=\"get\">\n";
     DoubleTableStart();

     echo "<tr>\n";
     if ( $this->ext == 0 ) {
       echo "<th colspan=\"3\">". $lang['SearchForTask'] ."</th>\n";
       echo "</tr><tr>\n";

       echo $this->showfieldc($lang['AdrName']);
       echo " <td align=\"center\">&nbsp;<input type=\"text\" value=\"\" name=\"name\"></td>\n";
       echo " <td align=\"center\">\n";
       echo " <input type=\"submit\" value=\"". $lang['Search'] ."\" title=\"". $lang['SearchForTask'] ."\"></td>\n";
       echo "</tr><tr>\n";
       echo " <td colspan=\"2\" align=\"center\"><font size=\"-1\">&nbsp;</font></td>\n";
       echo " <td align=\"center\">". makelink("task_select.php?ext=1",$lang['extended']) ."</td>\n";
     } else {
       echo "<th colspan=\"3\">". $lang['SearchForTaskExt'] ."</th>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['AdrName']);
       echo " <td>&nbsp;<input type=\"text\" value=\"\" name=\"name\">";
       echo " </td>\n";
       echo " <td align=\"center\"><input type=\"submit\" value=\"". $lang['Search'] ."\" title=\"". $lang['SearchForTaskExt'] ."\"></td>\n";

       echo "</tr><tr>\n";
       echo " <td rowspan=\"2\" class=\"desc\">". $lang['TaskBetween'] ."</td>\n";
       echo " <td colspan=\"2\">&nbsp;";
       $this->fd->EnterDate("start",1);
       echo "&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo " <td colspan=\"2\">&nbsp;";
       $this->td->EnterDate("end",1);
       echo "&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['TaskState']);
       echo " <td colspan=\"2\"><select name=\"state\">";
       echo "   <option value=\"-2\">". $lang['any'] ."</option>\n";
       foreach ($lang['TaskStates'] as $s => $x) {
         echo "   <option value=\"". $s ."\"". ($this->state == $s ? " selected" : "") .">". $lang['TaskStates'][$s] ."</option>\n";
       }
       echo "</select></td>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['TaskWorker']);
       echo " <td colspan=\"2\">\n";
       echo $this->user->askPeople("worker",$this->user->id,0);
       echo " </td>\n";
     }
     echo "</tr>\n";
     DoubleTableEnd();
     hiddenFormElements();
     echo "</form>\n";
     echo "</center>\n";
     echo $this->setfocus("tasksearch.name");
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['TaskSearch'];
     if ( ! $this->user->feature_ok(usetaskmanagement,PERM_SEL) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     # Defaults for search
     $this->fd = new DateTime(0);
     $this->td = new DateTime(0);
     if ( isset($_SESSION['tasksearchfrom']) ) {
       $this->fd->setDateTime($_SESSION['tasksearchfrom']);
     }
     if ( isset($_SESSION['tasksearchto']) ) {
       $this->td->setDateTime($_SESSION['tasksearchto']);
     }
     if ( isset($_SESSION['tasksearchstate']) ) {
       $this->state = $_SESSION['tasksearchstate'];
     } else {
       $this->state = -2;
     }

     if ( isset($_GET['ext']) ) {
       $this->ext = $_GET['ext'];
     } else {
       $this->ext = 0;
     }
   }
 }

 $l = new task_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: task_select.php,v 1.1 2003/12/28 17:08:40 gokohnert Exp $
    $Author: gokohnert $
-->
