<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_show
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","show");

 /**
  * show a task
  */
 class task_show extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $title = $lang['TaskDetail'].": ". myentities($this->obj->getFullName());
     $this->assign('title', $title);

     $this->assign('creation', sprintf($lang['TaskCreation'],
				       $this->obj->creator->getLink(),
				       $this->obj->creation->getDateTime()));

     $this->assign('name',
		   array('label' => $lang['TaskName'],
			 'value' => $this->obj->name));

     $this->assign('logical', 
		   array('label' => $lang['TaskLogical'],
			 'value' => $this->obj->logical));

     $this->assign('milestone', 
		   array('label' => $lang['TaskMilestone'],
			 'value' => $this->obj->milestone));

     $this->assign('state',
		   array('label' => $lang['TaskState'],
			 'value' =>
			 $lang['TaskStates'][$this->obj->get_state()]));

     $workers = array();
     foreach ($this->obj->worker as $i => $x) {
       $workers[] = array('label' => $this->obj->worker[$i]->getFullName(),
			  'title' => $this->obj->worker[$i]->getFullName(),
			  'link'  => $this->obj->worker[$i]->getUrl());
     }
     $this->assign('workers', 
		   array('label'   => $lang['TaskWorker'],
			 'workers' => $workers));

     if( ($this->obj->parent != -1)
	  && ($this->obj->parent->gettype() != "address") ) {

       $parents = array();
       $x = $this->obj->parent;
       while ( isset ( $x ) ) {
         // echo $pre . $lang[$x->gettype()] . "&nbsp;" . $x->getLink();
	 $parents[] = array('label' => $x->getFullName(),
			    'title' => $x->getFullName(),
			    'link'  => $x->getUrl(),
			    'type'  => $lang[$x->gettype()]);

         if( isset($x->parent) && $x->parent != -1 )
           $x = $x->parent;
         else
           unset($x);
       }
       $this->assign('parents',
		     array('label'   => $lang['TaskSubTask'],
			   'parents' => $parents));
     }

     $desc = wordwrap(urlReplace($this->obj->desc), 80);
     $this->assign('desc',
		   array('label' => $lang['TaskDesc'],
			 'value' => $desc));

     $this->assign('DateTimeFrom', $lang['DateTimeFrom']);
     $this->assign('DateTimeTill', $lang['DateTimeTill']);

     $s = $this->obj->get_s_start();
     $e = $this->obj->get_s_end();

     $this->assign('sched',
		   array('label' => $lang['TaskSched'],
			 'start' => $s->getDate(),
			 'end'   => $e->getDate()));

     $this->assign('real',
		   array('label' => $lang['TaskReal'],
			 'start' => $this->obj->r_start->getDate(),
			 'end'   => $this->obj->r_end->getDate()));

     $this->assign('hours', $lang['hours']);
     $this->assign('volume',
		   array('label' => $lang['TaskVolumeFull'],
			 'value' =>
			 number_format($this->obj->get_volume(), 2)));

     $ttlink = "timetrack_overview.php?link_id=".$this->obj->id;
     if( $this->obj->logical )
       $ttlink .= "&show=all";
     
     $this->assign('volume_done',
		   array('label' => $lang['TaskVolumeDone'],
			 'link'  => $ttlink,
			 'title' => $lang['TimetrackOverview'],
			 'value' =>
			 number_format($this->obj->get_volume_done(), 2)));

     if( $this->obj->volume_todo != -1 ) {
       $this->assign('volume_todo',
		     array('label' => $lang['TaskVolumeTodo'],
			   'value' =>
			   number_format($this->obj->get_volume_todo(), 2)));
     }
     
     // Pseudo graphic representation
     $w = 400;
     $c = $this->obj->getcompletion();
     $start = $this->obj->s_start->ts;
     $end   = $this->obj->s_end->ts;

     $green = round($w * $c / 100.0);
     $red   = $w - $green;

     $this->assign('completion',
		   array('label' => sprintf($lang['TaskCompleted'], $c),
			 'w'     => $w,
			 'green' => $green,
			 'red'   => $red));

     /**
      * Get the task list
      */
     $tasklist = array();
     if ( $this->user->feature_ok(usetaskmanagement, PERM_SEE) ) {
       $this->obj->readTasks();

       foreach( $this->obj->tasklist as $i => $f ) {
	 $tmp = $this->obj->tasklist[$i]->printRow($this->obj);
	 if( count($tmp) > 0 )
	   $tasklist[] = $tmp;
       }
     }
     $this->assign('tasklist',
		   array('label'  =>
			 $lang['TaskSubTask']." ".$this->obj->getFullName(),
			 'llabel' => $lang['TaskOverview'],
			 'link'   => "task_overview.php?id=".$this->obj->id,
			 'ltitle' => sprintf($lang['TaskOverviewInfo'],
					     $this->obj->getFullName()),
			 'image'  => 'folder',
			 'value'  => task::flatten_tasks($tasklist)));

     $infos = show_module_infolists($this->user,$this->obj,4,$this->format);
     // $this->debug($infos);
     $this->assign('modules', $infos);

     $this->template('task_show');
   }

   /**
    * navigate
    */
   Function navigate() {
     global $lang;
     // menu
     $x = task::getaddlink($this->user,$this->obj->parent,$lang['NewEntry']);
     $x['image'] = 'new';
     $this->addMenu($x);

     $x = task::getaddlink($this->user, $this->obj, $lang['TaskNewSubtask']);
     $x['image'] = 'new';
     $this->addMenu($x);

     if( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array('url'   => $this->obj->getModURL(),
                  'text'  => $lang['Modify'],
		  'image' => 'modify',
                  'info'  => sprintf($lang['TaskModify'],
				     $this->obj->getFullname()),
                  'category' => array("task","mod","obj")
                 );
       $this->addMenu($x);

       $x = array( 'url'   => "acl_show.php?id=".$this->obj->id,
                   'text'  => $lang['AclDetail'],
		   'image' => 'acls',
                   'info'  => sprintf($lang['AclDetailI'],
				      $this->obj->getFullname()),
                   'category' => array("acl","obj")
                 );
       $this->addMenu($x);
     }

     if( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array('url'   => $this->obj->getDelURL(),
                  'text'  => $lang['Delete'],
		  'image' => 'delete',
                  'info'  => sprintf($lang['TaskDelete'],
				     $this->obj->getFullname()),
                  'category' => array("task","del","obj"),
                  'confirm' => true
                 );
       $this->addMenu($x);
     }

     if( ! $this->obj->logical ) {
       $x = timetrack::getaddlink($this->user,$this->obj);
       $this->addMenu($x);
     }

     $x = array('url'   =>
		'timetrack_overview.php?link_id='.$this->obj->id.'&show=all',
		'text'  => $lang['TimetrackOverview'],
		'image' => 'timetrack',
		'info'  => sprintf($lang['TimetrackBookedI'],
				   $this->obj->getFullname()),
		'category' => array('timetrack'));
     $this->addMenu($x);

     $x = array('url'   => "bugtracking/bug_overview.php?pid=".$this->obj->id,
		'text'  => $lang['BugsOverview'],
		'image' => 'bugs',
		'info'  => $lang['BugsOverview'],
		'category' => array("bug")
		);
     $this->addMenu($x);
 
     $this->menuprint('bug');
     $this->menuPrint('timetrack');
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['TaskDetail'];

     $this->obj = new task($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     }

     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name .=": ". myentities($this->obj->getFullName());
     }

     if ($this->stop) {
       return;
     }

     add_module_addlinks($this, $this->obj);

     // add this page to the browsehistory of the users session
     // $this->addtohistory();
     web_StackStartLayoutObj($this);
   }
 }

 $l = new task_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: task_show.php,v 1.66.2.15 2005/04/12 10:29:57 tapoueh Exp $
    $Author: tapoueh $
-->