{* BugTracking Overview TUTOS template *}
{* $Id: bug_overview.tpl,v 1.1.2.15 2005/03/02 10:29:46 tapoueh Exp $ *}

<!-- bug_overview start -->
{include file="classic/js/mass_update.tpl"}

<form name="actionform" method="GET" action="{$action}">
{if $solverid != ""}
<input type="hidden" name="solverid" value="{$solverid}">
{/if}
{* We add the current search filter as hidden input *}
{foreach from=$search key=k item=v}
<input type="hidden" name="{$k}" value="{$v}">
{/foreach}

<table class="overview" style="margin-left: 0px;">
<thead>
<tr>
{foreach from=$headers item=h}
 {* If we show bugs from project X, don't show it on every line *}
 {if not ( $h.name == 'ref' and $search.pid != "" ) }
  <th>
  {* The 'ref' column should not allow re ordering *}
  {if $h.name != "" and $h.name != "ref" }
   {include file="mklink.tpl"
            label_src_ok="$base/html/classic/down.png"
            label_src_ko="$base/html/classic/no-down.png"
	    label_alt="down" current_xf=$xf current_xo=$xo
	    search=$search start=$astart xf=$h.name xo=1}
   {$h.label}
   {include file="mklink.tpl"
            label_src_ok="$base/html/classic/up.png"
            label_src_ko="$base/html/classic/no-up.png"
	    label_alt="up" current_xf=$xf current_xo=$xo
	    search=$search start=$astart xf=$h.name xo=2}
  {else}
    {$h.label}
  {/if}
  </th>

 {/if}
{/foreach}
  <th><input type="checkbox" name="checkit" onclick="CheckAll2();"/></th>
</tr>
</thead>

<tfoot>
<tr>
  <td colspan="{$inner_cols}" align="center">
   {include file="classic/navbar.tpl"}
  </td>
  <td colspan="2" align="right">
    {$astart} - {$aend} /&nbsp;{$nb}
  </td>
</tr>
</tfoot>

<tbody>
{section name=b loop=$bugs}
<tr>
 <td class="data">
  <a href="{$base}/php/{$bugs[b].link}" title="{$bugs[b].title}">
   {$bugs[b].name}
  </a>
 </td>

 <td class="data">{$bugs[b].creation}</td>
 <td class="data">{$bugs[b].lasth}</td>

 {if $search.pid == "" }
 <td style="white-space: nowrap;">
   <a href="{$base}/php/{$bugs[b].parent.link}"
     title="{$bugs[b].parent.title}">{$bugs[b].parent.label}</a></td>
 {/if}

 <td class="data" style="text-align: left;">{$bugs[b].desc}</td>

 <td class="data">
  <span class="bugstate{$bugs[b].state.value}">{$bugs[b].state.label}</span>
 </td>

 <td class="data">
  <span class="bugclass{$bugs[b].class.value}">{$bugs[b].class.label}</span>
 </td>

 <td><a href="{$base}/php/{$bugs[b].creator.link}"
        title="{$bugs[b].creator.title}">{$bugs[b].creator.label}</a></td>

 <td><a href="{$base}/php/{$bugs[b].solver.link}"
        title="{$bugs[b].solver.title}">{$bugs[b].solver.label}</a></td>

 <td align="center">
  <input name="mark[]" type="checkbox" value="{$bugs[b].id}">
 </td>
</tr>
{/section}
</tbody>

</table>

<table class="summary">
<tr>

<td>
<table>
<tr>
 <td align="right">{$marked}</td>
 <td>
 <select name="action">
 {foreach from=$actions key=value item=option}
 <option value="{$value}">{$option}</option>
 {/foreach}
 </td>
</tr>

<tr>
<td align="right">{$solver.label}</td>
<td>
<select name="{$solver.name}" id="{$solver.id}">
<optgroup label="{$solver.options.roles.label}">
{html_options options=$solver.options.roles.list
             selected=$solver.options.roles.selected}
</optgroup>
<optgroup label="{$solver.options.people.label}">
{html_options options=$solver.options.people.list
             selected=$solver.options.people.selected}
</optgroup>
<optgroup label="{$solver.options.teams.label}">
{html_options options=$solver.options.teams.list 
             selected=$solver.options.teams.selected}
</optgroup>
</select>
</td>
</tr>
</table>
</td>

<td>
<table>
 <td><input type="submit" value="{$Enter}"></td>
</table>
</td>
</tr>
</table>

</form>

<!-- bug_overview stop -->