/*
 * twclock:  A world clock implemented with Motif widgets
 * Copyright (C) 1997 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139, USA.
 * See COPYING file in this directory.
 *
 * Version: 2.1 - Mar 2003
 */

/*
 * BUILD TWCLOCK WIDGETS
 */

#include "twclock.h"

void  build_widgets ()
{
   Widget form, separator, popup_menu;

   XmString pop_label, local_label, local_acc_label, gmt_label, gmt_acc_label,
       others_label, others_acc_label, timer_label, timer_acc_label;

   /*
    * This section creates all of the widgets for the main
    * interface.  Nothing very interesting here - mostly just
    * creates and setting attachment resources.
    */

   /*
    * Create form
    */
   form = XtVaCreateWidget ("form", xmFormWidgetClass, clock_shell,
      NULL);

   /*
    * Create date_label
    */
   date_label = XtVaCreateManagedWidget ("date_label",
      xmLabelWidgetClass, form,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_NONE,
      NULL);

   /*
    * Create separator
    */
   separator = XtVaCreateManagedWidget ("separator",
      xmSeparatorWidgetClass, form,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, date_label,
      XmNrightAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNshadowThickness, 8,
      XmNseparatorType, XmSHADOW_ETCHED_OUT,
      NULL);

   /*
    * Create call_toggleB
    */
   call_toggleB = XtVaCreateManagedWidget ("call_toggleB",
      xmToggleButtonWidgetClass, form,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_FORM,
      XmNhighlightThickness, 0,
      XmNshadowThickness, 3,
      XmNindicatorOn, False,   /* make it look like a push button */
      XmNfillOnSelect, True,
      NULL);

   /*
    * Create hr_scale
    */
   hr_scale = XtVaCreateManagedWidget ("hr_scale",
      xmScaleWidgetClass, form,
      XmNnavigationType, XmNONE,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, separator,
      XmNrightAttachment, XmATTACH_POSITION,
      XmNrightPosition, 30,
      XmNleftAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, call_toggleB,
      XmNmaximum, 23,
      XmNshowValue, TRUE,
      NULL);

   /*
    * Create min_scale
    */
   min_scale = XtVaCreateManagedWidget ("min_scale",
      xmScaleWidgetClass, form,
      XmNnavigationType, XmNONE,
      XmNrightOffset, 5,
      XmNleftOffset, 5,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, separator,
      XmNleftAttachment, XmATTACH_POSITION,
      XmNleftPosition, 35,
      XmNrightAttachment, XmATTACH_POSITION,
      XmNrightPosition, 65,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, call_toggleB,
      XmNmaximum, 59,
      XmNshowValue, TRUE,
      NULL);

   /*
    * Create sec_scale
    */
   sec_scale = XtVaCreateManagedWidget ("sec_scale",
      xmScaleWidgetClass, form,
      XmNnavigationType, XmNONE,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, separator,
      XmNleftAttachment, XmATTACH_POSITION,
      XmNleftPosition, 70,
      XmNrightAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, call_toggleB,
      XmNmaximum, 59,
      XmNshowValue, TRUE,
      NULL);

   /*
    * Next, we create the popup menu.  All buttons call the
    * function popup_cb.
    */

   /*
    * Create the XmStrings for the push buttons
    */
   pop_label = XmStringCreateLocalized ("Time Zone");
   local_label = XmStringCreateLocalized ("Local");
   local_acc_label = XmStringCreateLocalized ("Ctrl-L");
   gmt_label = XmStringCreateLocalized ("GMT");
   gmt_acc_label = XmStringCreateLocalized ("Ctrl-G");
   others_label = XmStringCreateLocalized ("Others");
   others_acc_label = XmStringCreateLocalized ("Ctrl-O");
   timer_label = XmStringCreateLocalized ("Set Timer");
   timer_acc_label= XmStringCreateLocalized ("Ctrl-S");

   /*
    * Create popup_menu
    */
   popup_menu = XmVaCreateSimplePopupMenu (form, "popup_menu", popup_cb,
      XmVaTITLE, pop_label,
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, local_label, 'L', "Ctrl<Key>L", local_acc_label,
      XmVaPUSHBUTTON, gmt_label, 'G', "Ctrl<Key>G", gmt_acc_label,
      XmVaPUSHBUTTON, others_label, 'O', "Ctrl<Key>O", others_acc_label,
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, timer_label, 'S', "Ctrl<Key>S", timer_acc_label,
      NULL);

   /*
    * Prevent memory leaks 
    */
   XmStringFree(pop_label);
   XmStringFree(local_label);
   XmStringFree(local_acc_label);
   XmStringFree(gmt_label);
   XmStringFree(gmt_acc_label);
   XmStringFree(others_label);
   XmStringFree(others_acc_label);
   XmStringFree(timer_label);
   XmStringFree(timer_acc_label);

/*
 * Here the event handler is registered. The default timezone value is
 * grabbed and a call to popup_cb() is made.  This gets the path variable
 * to the start up time zone.  Then gettime() sets TZ and initializes
 * the scales.
 */
   XtAddEventHandler (form,ButtonPressMask,False,input_event,popup_menu);

   /*
    * This is a hack to make the right mouse event be recognized on all the
    * children.  Well, all but the slider control in the scale
    */
#ifdef LESSTIF_VERSION 
   printf ("doing hack for lesstif\n");
   XtAddEventHandler (date_label,ButtonPressMask,False,input_event,popup_menu);
   XtAddEventHandler (separator,ButtonPressMask,False,input_event,popup_menu);
   XtAddEventHandler (call_toggleB,ButtonPressMask,False,input_event,popup_menu);
   XtAddEventHandler (hr_scale,ButtonPressMask,False,input_event,popup_menu);
   XtAddEventHandler (min_scale,ButtonPressMask,False,input_event,popup_menu);
   XtAddEventHandler (sec_scale,ButtonPressMask,False,input_event,popup_menu);
#endif

   popup_cb (form, (XtPointer)(appRes.tzone), (XtPointer)NULL);
   gettime ();

   XtManageChild(form);

   XtAddCallback(call_toggleB, XmNvalueChangedCallback,
                 TBchangeCB, (XtPointer)NULL);

   return;
}
