/*
 * include file for libCW.h
 */
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/kd.h>
#include <sys/msg.h>
#include <sys/ioctl.h>
#include <linux/rtc.h>
#include <sys/soundcard.h>

#define MAX_LETTERS 512
#define MAX_WORD_LENGTH  100L    /* Maximum length of a word */
#define PI 3.1415926    /* Indiana residents, feel free to change it to 3.2 */

#define SAMPLERATE 44100 //8192  

/*defaults*/
#define DEFAULT_SC_DEVICE   "/dev/dsp"
#define DEFAULT_MIX_DEVICE  "/dev/mixer"
#define DEFAULT_RTS_DEVICE  "/dev/ttyS0"

#define DEFAULT_VOL   40
#define DEFAULT_WPM   10.0
#define DEFAULT_FARNS 4.0
#define RISE 2.0
#define FALL 2.0

#define TRUE 1
#define FALSE ! TRUE

#define DIT '.'
#define DAH '-'

#define FARNS_OFF  4             /* minimum farnsworth speed */

#ifndef SENT_MSG
#define SENT_MSG 7L              /* as defined in common.h */
#endif

/* keying modes - select the devices you want to key.  These values  */
/* can be OR's together as the arg for cw_set_key_modes function etc */
#define RTS   0x01               /* RTS for rig */
#define SC    0x02               /* Soundcard */
#define IRC   0x04               /* key cwirc program */


/*
 * CWirc stuff
 */
#define AUDIOBUF_SIZE		22050   /* Samples */

struct cwirc_extension_api {
        int semid;
        signed short int out_audiobuf[AUDIOBUF_SIZE];
        int out_audiobuf_start;
        int out_audiobuf_end;
        int in_key;
        int pid;
};


/*
 * cw_func calls
 */
int  cw_init (char *dsp, char *ser, char *mix);

int  cw_set_reply_msg (int mode);
int  cw_get_reply_msg (void);

int  cw_set_wpm (int new_wpm);
int  cw_get_wpm (void);

int  cw_set_fwpm (int new_fwpm);
int  cw_get_fwpm (void);

int  cw_set_freq (int new_freq);
int  cw_get_freq (void);

int  cw_send_str  (char *str);
int  cw_send_word (char *str);
int  cw_send_char (char str);

int  cw_set_send_volume (int new_vol);

int  cw_set_key_modes (int mode);
int  cw_get_key_modes (void);
int  cw_clear_key_modes (int mode);

/************** end sendCW.h **************/
