/*
    Copyright (C) 2005-2006  Michel de Boer <michelboer@xs4all.nl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "definitions.h"
#include "hdr_priority.h"

t_hdr_priority::t_hdr_priority() : t_header() {};

void t_hdr_priority::set_priority(const string &p) {
	populated = true;
	priority = p;
}

string t_hdr_priority::encode(void) const {
	string s;

	if (!populated) return s;

	s = "Priority: ";
	s += encode_value();
	s += CRLF;
	
	return s;
}

string t_hdr_priority::encode_value(void) const {
	if (!populated) return "";

	return priority;
}

string t_hdr_priority::encode_env(void) const {
	string s;
	
	s = "SIP_PRIORITY=";
	s += encode_value();
	
	return s;
}
