<?php

class user_test_library_class {
	var $cObj;	// reference to the calling object.
	var $conf;	// Set to the TypoScript config array passed
	
	function init($content,$conf)	{
		global $TSFE;
		$TSFE->set_no_cache();	// Turning caching off - good while developing.
		
			// Setting internal variable $conf so TS is available from all methods
		$this->conf = $conf;

			// Main body section rendered and returned
		return $this->getMainBody();
	}

	/**
	 * Renders and returns the main body section
	 */
	function getMainBody()	{
		ob_start();		// Start output buffering
	?>
<table border="1">
	<tr>
		<td nowrap="nowrap" valign="top"><?php echo $this->insertMenu();?></td>
		<td><img src="clear.gif" width="10" height="1" alt="" /></td>
		<td><?php echo $this->insertContent();?></td>
	</tr>
</table>
	<?php
		$outputString = ob_get_contents();
		ob_end_clean();
		return $outputString;
	}

	/**
	 * Renders and returns main menu
	 */
	function insertMenu()	{
		return $this->cObj->cObjGetSingle(
			$this->conf['cObj_main_menu'],
			$this->conf['cObj_main_menu.'],
			'cObj_main_menu'
		);
	}

	/**
	 * Renders and returns content for normal column
	 */
	function insertContent()	{
		return $this->cObj->cObjGetSingle(
			$this->conf['cObj_normal_content'],
			$this->conf['cObj_normal_content.'],
			'cObj_normal_content'
		);
	}
}

?>