-- MySQL dump 9.11
--
-- Host: localhost    Database: dbupdater_temp
-- ------------------------------------------------------
-- Server version	4.0.21-log

--
-- Table structure for table `be_groups`
--

CREATE TABLE `be_groups` (
  `uid` int(11) unsigned NOT NULL auto_increment,
  `pid` int(11) unsigned NOT NULL default '0',
  `tstamp` int(11) unsigned NOT NULL default '0',
  `title` varchar(20) NOT NULL default '',
  `non_exclude_fields` blob NOT NULL,
  `db_mountpoints` varchar(40) NOT NULL default '',
  `pagetypes_select` tinyblob NOT NULL,
  `tables_select` blob NOT NULL,
  `tables_modify` blob NOT NULL,
  `crdate` int(11) unsigned NOT NULL default '0',
  `cruser_id` int(11) unsigned NOT NULL default '0',
  `groupMods` tinyblob NOT NULL,
  `file_mountpoints` varchar(40) NOT NULL default '',
  `hidden` tinyint(3) unsigned NOT NULL default '0',
  `inc_access_lists` tinyint(3) unsigned NOT NULL default '0',
  `description` text NOT NULL,
  `lockToDomain` varchar(50) NOT NULL default '',
  `deleted` tinyint(3) unsigned NOT NULL default '0',
  `TSconfig` blob NOT NULL,
  `subgroup` tinyblob NOT NULL,
  `hide_in_lists` tinyint(4) NOT NULL default '0',
  `explicit_allowdeny` blob NOT NULL,
  `allowed_languages` tinyblob NOT NULL,
  `custom_options` blob NOT NULL,
  PRIMARY KEY  (`uid`),
  KEY `parent` (`pid`)
) TYPE=MyISAM;

--
-- Dumping data for table `be_groups`
--

INSERT INTO `be_groups` VALUES (1,0,1016616639,'be_testgroup','pages:hidden','10','1,2,3,4,5','','pages,tt_content',972400074,1,'web,web_perm,user,user_task,doc,web_layout,web_view','',0,1,'This usergroup enables members to edit the pages on \"Another site...\"','',0,'','5',0,'','','');
INSERT INTO `be_groups` VALUES (2,0,1022140620,'News Writers','tt_news:image,tt_news:imagecaption,tt_news:author,tt_news:author_email','158','','','tt_news',1008084613,1,'web_modules,user,user_task,user_setup','',0,1,'News Writers.\r\nJust like article writers members of this group are supposed to write new news-items.','',0,'','5',0,'','','');
INSERT INTO `be_groups` VALUES (3,0,1008141316,'Editor','pages:hidden,pages:starttime,pages:endtime,tt_news:hidden,tt_news:endtime,tt_news:starttime','','','','',1008085074,1,'','',0,1,'This group is for editors. They are allowed to assign workflows to the Article and News groups (this is configured inside each workflow item).\r\nThis group includes the News Writers and Article Writers groups as subgroups. This provides an easy way to make sure to pick up all rights from those groups. This includes the \"upload_dir\" group which both the News and Article group includes.\r\nNotice that extra fields are included here: The \"hide\" field for both pages and news items are available for the Editor so he/she can control the publication. Basically this is not needed because unhiding the articles/news items are a part of what you can control through the workflow item. But anyway it\'s a service for the Editors so they can control this in special situations.','',0,'','2,4',0,'','','');
INSERT INTO `be_groups` VALUES (4,0,1021501871,'Article Writers','','159','1,2','','tt_content,pages',1008085152,1,'user_task,web_layout,web,user_setup,user','',0,1,'Members of this group will be allowed create articles (pages with content) in a special area on the website assigned by a workflow passed by an \"Editor\" user.','',0,'','5',0,'','','');
INSERT INTO `be_groups` VALUES (5,0,1008147309,'upload_dir','','','','','',1008086640,1,'','1',0,0,'This group is meant to be shared by almost every other group. The point is to assign every group a shared upload directory for temporary files.\r\nNotice that the \"Don\'t list...\"-flags are set. This is important because this group is shared by all users but you DON\'T want all users to be able to send messages to each other. Rather users in the same \'main group\' (eg. \"Editor\" og \"be_testgroup\") should be able to do so.','',0,'','',1,'','','');
INSERT INTO `be_groups` VALUES (6,0,1010772267,'Common editor group','','','','','',1010772267,1,'','',0,0,'','',0,'','',0,'','','');

--
-- Table structure for table `be_sessions`
--

CREATE TABLE `be_sessions` (
  `ses_id` varchar(32) NOT NULL default '',
  `ses_name` varchar(32) NOT NULL default '',
  `ses_userid` int(11) unsigned NOT NULL default '0',
  `ses_tstamp` int(11) unsigned NOT NULL default '0',
  `ses_data` mediumblob NOT NULL,
  `ses_iplock` varchar(15) NOT NULL default '',
  `ses_hashlock` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ses_id`,`ses_name`)
) TYPE=MyISAM;

--
-- Dumping data for table `be_sessions`
--


--
-- Table structure for table `be_users`
--

CREATE TABLE `be_users` (
  `uid` int(11) unsigned NOT NULL auto_increment,
  `pid` int(11) unsigned NOT NULL default '0',
  `tstamp` int(11) unsigned NOT NULL default '0',
  `username` varchar(20) NOT NULL default '',
  `password` varchar(40) NOT NULL default '',
  `admin` tinyint(4) unsigned NOT NULL default '0',
  `usergroup` tinyblob NOT NULL,
  `disable` tinyint(4) unsigned NOT NULL default '0',
  `starttime` int(11) unsigned NOT NULL default '0',
  `endtime` int(11) unsigned NOT NULL default '0',
  `lang` char(2) NOT NULL default '',
  `email` varchar(80) NOT NULL default '',
  `db_mountpoints` varchar(40) NOT NULL default '',
  `options` tinyint(4) unsigned NOT NULL default '0',
  `crdate` int(11) unsigned NOT NULL default '0',
  `cruser_id` int(11) unsigned NOT NULL default '0',
  `realName` varchar(80) NOT NULL default '',
  `userMods` tinyblob NOT NULL,
  `uc` blob NOT NULL,
  `file_mountpoints` varchar(40) NOT NULL default '',
  `fileoper_perms` tinyint(4) NOT NULL default '0',
  `lockToDomain` varchar(50) NOT NULL default '',
  `deleted` tinyint(3) unsigned NOT NULL default '0',
  `TSconfig` blob NOT NULL,
  `lastlogin` int(10) unsigned NOT NULL default '0',
  `createdByAction` int(11) NOT NULL default '0',
  `usergroup_cached_list` tinytext NOT NULL,
  `disableIPlock` tinyint(3) unsigned NOT NULL default '0',
  `allowed_languages` tinyblob NOT NULL,
  PRIMARY KEY  (`uid`),
  KEY `parent` (`pid`),
  KEY `username` (`username`)
) TYPE=MyISAM;

--
-- Dumping data for table `be_users`
--

INSERT INTO `be_users` VALUES (1,0,1033381889,'admin','5f4dcc3b5aa765d61d8327deb882cf99',1,'',0,0,0,'','admin@email.test','',0,0,0,'Administrator','','','',7,'',0,'options.contextMenu.options.alwaysShowClickMenuInTopFrame=1\r\nsetup.override {\r\n  dontEditInPageModule=0\r\n  JSwindowParams = screenX=1, screenY=1, left=1, top=1\r\n  JSwindowParams =\r\n  navFrameWidth = 300\r\n  noMenuMode=\r\n  classicPageEditMode = 1\r\n  noOnChangeAlertInTypeFields = 0\r\n  dontShowPalettesOnFocusInAB=0\r\n}\r\nadmPanel.module.edit.forceNoPopup = 0\r\noptions.shortcutFrame = 1\r\n\r\nmod.tools_em.allowTVlisting=1',1099350494,0,'',0,'');
INSERT INTO `be_users` VALUES (2,0,1010772324,'template_be_test','f561aaf6ef0bf14d4208bb46a4ccb3ad',0,'1',0,0,0,'','xxx','',3,972400056,1,'xxx','','','',7,'',0,'',1008087805,0,'5,1',0,'');
INSERT INTO `be_users` VALUES (4,0,1010772324,'news_editor','722ce9eb6a23698c183cbb605c2c49fc',0,'6,3',0,0,0,'','editor@email.test','',3,1008085024,1,'Mr. Editor','web_info','','',7,'',0,'',1010795255,0,'6,5,2,4,3',0,'');
INSERT INTO `be_users` VALUES (6,0,1022140704,'reviewer','7ba917e4e5158c8a9ed6eda08a6ec572',0,'6,2,4',0,0,0,'','reviewer@email.test','',1,1008085792,1,'Mr. Reviewer','user,user_task,user_setup,web_layout','','',7,'',0,'',1010761240,0,'6,2,5,4',0,'');
INSERT INTO `be_users` VALUES (7,0,1010772324,'template_news','f561aaf6ef0bf14d4208bb46a4ccb3ad',0,'',0,0,0,'de','xxx','',3,1008086685,1,'xxx','','','',7,'',0,'',0,0,'',0,'');
INSERT INTO `be_users` VALUES (8,0,1010772324,'news_news','77b8554db8c0a8575f83b9ad5e91a454',0,'6,2',0,0,0,'de','news@email.test','',3,1008088752,4,'Mr. News','','','',7,'',0,'',1010757777,3,'6,5,2',0,'');
INSERT INTO `be_users` VALUES (10,0,1032972140,'be_test','3eb496d59bb1bf52e7f42c3fcef7a73d',0,'1',0,0,0,'','be_test@email.test','18',3,1008089424,1,'Backend Test User1','web_list','','',7,'',0,'admPanel {\r\n  enable.edit = 1\r\n  module.edit.forceNoPopup = 1\r\n  module.edit.forceDisplayFieldIcons = 1\r\n  module.edit.forceDisplayIcons = 0\r\n  hide = 1\r\n}\r\n\r\noptions.shortcutFrame = 1\r\n',1071765753,1,'5,1',0,'');
INSERT INTO `be_users` VALUES (11,0,1010772324,'news_article','b0cea4ca0b8d659875b4e691ebd57924',0,'6,4',0,0,0,'de','article@email.test','',3,1008176008,4,'Mr. Article','','','',7,'',0,'',1010794947,3,'6,5,4',0,'');

--
-- Table structure for table `cache_hash`
--

CREATE TABLE `cache_hash` (
  `hash` varchar(32) NOT NULL default '',
  `content` mediumblob NOT NULL,
  `tstamp` int(11) unsigned NOT NULL default '0',
  `ident` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`hash`)
) TYPE=MyISAM;

--
-- Dumping data for table `cache_hash`
--


--
-- Table structure for table `cache_imagesizes`
--

CREATE TABLE `cache_imagesizes` (
  `md5hash` varchar(32) NOT NULL default '',
  `md5filename` varchar(32) NOT NULL default '',
  `tstamp` int(11) NOT NULL default '0',
  `filename` tinytext NOT NULL,
  `imagewidth` mediumint(11) unsigned NOT NULL default '0',
  `imageheight` mediumint(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`md5filename`)
) TYPE=MyISAM;

--
-- Dumping data for table `cache_imagesizes`
--


--
-- Table structure for table `cache_md5params`
--

CREATE TABLE `cache_md5params` (
  `md5hash` varchar(20) NOT NULL default '',
  `tstamp` int(11) NOT NULL default '0',
  `type` tinyint(3) NOT NULL default '0',
  `params` text NOT NULL,
  PRIMARY KEY  (`md5hash`)
) TYPE=MyISAM;

--
-- Dumping data for table `cache_md5params`
--


--
-- Table structure for table `cache_pages`
--

CREATE TABLE `cache_pages` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `hash` varchar(32) NOT NULL default '',
  `page_id` int(11) unsigned NOT NULL default '0',
  `reg1` int(11) unsigned NOT NULL default '0',
  `HTML` mediumblob NOT NULL,
  `tstamp` int(11) unsigned NOT NULL default '0',
  `expires` int(10) unsigned NOT NULL default '0',
  `cache_data` mediumblob NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `page_id` (`page_id`),
  KEY `sel` (`hash`,`page_id`)
) TYPE=MyISAM;

--
-- Dumping data for table `cache_pages`
--


--
-- Table structure for table `cache_pagesection`
--

CREATE TABLE `cache_pagesection` (
  `page_id` int(11) unsigned NOT NULL default '0',
  `content` blob NOT NULL,
  `tstamp` int(11) unsigned NOT NULL default '0',
  `mpvar_hash` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`page_id`,`mpvar_hash`)
) TYPE=MyISAM;

--
-- Dumping data for table `cache_pagesection`
--


--
-- Table structure for table `cache_sys_dmail_stat`
--

CREATE TABLE `cache_sys_dmail_stat` (
  `mid` int(11) NOT NULL default '0',
  `rid` int(11) NOT NULL default '0',
  `rtbl` char(1) NOT NULL default '',
  `pings` tinyint(3) unsigned NOT NULL default '0',
  `plain_links` tinyint(3) unsigned NOT NULL default '0',
  `html_links` tinyint(3) unsigned NOT NULL default '0',
  `links` tinyint(3) unsigned NOT NULL default '0',
  `recieved_html` tinyint(3) unsigned NOT NULL default '0',
  `recieved_plain` tinyint(3) unsigned NOT NULL default '0',
  `size` int(11) NOT NULL default '0',
  `tstamp` int(11) NOT NULL default '0',
  `pings_first` int(11) NOT NULL default '0',
  `pings_last` int(11) NOT NULL default '0',
  `html_links_first` int(11) NOT NULL default '0',
  `html_links_last` int(11) NOT NULL default '0',
  `plain_links_first` int(11) NOT NULL default '0',
  `plain_links_last` int(11) NOT NULL default '0',
  `links_first` int(11) NOT NULL default '0',
  `links_last` int(11) NOT NULL default '0',
  `response_first` int(11) NOT NULL default '0',
  `response_last` int(11) NOT NULL default '0',
  `response` tinyint(3) unsigned NOT NULL default '0',
  `time_firstping` int(11) NOT NULL default '0',
  `time_lastping` int(11) NOT NULL default '0',
  `time_first_link` int(11) NOT NULL default '0',
  `time_last_link` int(11) NOT NULL default '0',
  `firstlink` tinyint(4) NOT NULL default '0',
  `firstlink_time` int(11) NOT NULL default '0',
  `secondlink` tinyint(4) NOT NULL default '0',
  `secondlink_time` int(11) NOT NULL default '0',
  `thirdlink` tinyint(4) NOT NULL default '0',
  `thirdlink_time` int(11) NOT NULL default '0',
  KEY `mid` (`mid`)
) TYPE=MyISAM;

--
-- Dumping data for table `cache_sys_dmail_stat`
--


--
-- Table structure for table `cache_typo3temp_log`
--

CREATE TABLE `cache_typo3temp_log` (
  `md5hash` varchar(32) NOT NULL default '',
  `tstamp` int(11) NOT NULL default '0',
  `filename` tinytext NOT NULL,
  `orig_filename` tinytext NOT NULL,
  PRIMARY KEY  (`md5hash`)
) TYPE=MyISAM;

--
-- Dumping data for table `cache_typo3temp_log`
--


--
-- Table structure for table `fe_groups`
--

CREATE TABLE `fe_groups` (
  `uid` int(11) unsigned NOT NULL auto_increment,
  `pid` int(11) unsigned NOT NULL default '0',
  `tstamp` int(11) unsigned NOT NULL default '0',
  `title` varchar(20) NOT NULL default '',
  `hidden` tinyint(3) unsigned NOT NULL default '0',
  `lockToDomain` varchar(50) NOT NULL default '',
  `deleted` tinyint(3) unsigned NOT NULL default '0',
  `description` text NOT NULL,
  `TSconfig` blob NOT NULL,
  PRIMARY KEY  (`uid`),
  KEY `parent` (`pid`)
) TYPE=MyISAM;

--
-- Dumping data for table `fe_groups`
--

INSERT INTO `fe_groups` VALUES (1,7,1018357063,'testgroup',0,'',0,'','');
INSERT INTO `fe_groups` VALUES (2,131,1002630143,'PM Landscape',0,'',0,'This user groups is for people participating in the Photo Marathon kategory \"Landscapes\".','');
INSERT INTO `fe_groups` VALUES (3,131,1002630174,'PM Portrait',0,'',0,'This user groups is for people participating in the Photo Marathon kategory \"Portrait\".','');
INSERT INTO `fe_groups` VALUES (4,131,1002630240,'PM Citylife',0,'',0,'This user groups is for people participating in the Photo Marathon kategory \"Citylife\".','');
INSERT INTO `fe_groups` VALUES (5,131,1002644631,'Common group',0,'',0,'All users are a member of this group','');

--
-- Table structure for table `fe_session_data`
--

CREATE TABLE `fe_session_data` (
  `hash` varchar(32) NOT NULL default '',
  `content` blob NOT NULL,
  `tstamp` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`hash`)
) TYPE=MyISAM;

--
-- Dumping data for table `fe_session_data`
--


--
-- Table structure for table `fe_sessions`
--

CREATE TABLE `fe_sessions` (
  `ses_id` varchar(32) NOT NULL default '',
  `ses_name` varchar(32) NOT NULL default '',
  `ses_userid` int(11) unsigned NOT NULL default '0',
  `ses_tstamp` int(11) unsigned NOT NULL default '0',
  `ses_data` blob NOT NULL,
  `ses_iplock` varchar(15) NOT NULL default '',
  `ses_hashlock` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ses_id`,`ses_name`)
) TYPE=MyISAM;

--
-- Dumping data for table `fe_sessions`
--


--
-- Table structure for table `fe_users`
--

CREATE TABLE `fe_users` (
  `uid` int(11) unsigned NOT NULL auto_increment,
  `pid` int(11) unsigned NOT NULL default '0',
  `tstamp` int(11) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `password` varchar(40) NOT NULL default '',
  `usergroup` tinyblob NOT NULL,
  `disable` tinyint(4) unsigned NOT NULL default '0',
  `starttime` int(11) unsigned NOT NULL default '0',
  `endtime` int(11) unsigned NOT NULL default '0',
  `name` varchar(80) NOT NULL default '',
  `address` tinytext NOT NULL,
  `telephone` varchar(20) NOT NULL default '',
  `fax` varchar(20) NOT NULL default '',
  `email` varchar(80) NOT NULL default '',
  `crdate` int(11) unsigned NOT NULL default '0',
  `cruser_id` int(11) unsigned NOT NULL default '0',
  `lockToDomain` varchar(50) NOT NULL default '',
  `deleted` tinyint(3) unsigned NOT NULL default '0',
  `uc` blob NOT NULL,
  `title` varchar(40) NOT NULL default '',
  `zip` varchar(10) NOT NULL default '',
  `city` varchar(50) NOT NULL default '',
  `country` varchar(40) NOT NULL default '',
  `www` varchar(80) NOT NULL default '',
  `company` varchar(80) NOT NULL default '',
  `image` tinyblob NOT NULL,
  `TSconfig` blob NOT NULL,
  `module_sys_dmail_category` int(10) unsigned NOT NULL default '0',
  `module_sys_dmail_html` tinyint(3) unsigned NOT NULL default '0',
  `fe_cruser_id` int(10) unsigned NOT NULL default '0',
  `lastlogin` int(10) unsigned NOT NULL default '0',
  `is_online` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  KEY `parent` (`pid`),
  KEY `username` (`username`),
  KEY `is_online` (`is_online`),
  KEY `pid` (`pid`,`username`)
) TYPE=MyISAM;

--
-- Dumping data for table `fe_users`
--

INSERT INTO `fe_users` VALUES (1,7,1033383261,'test','test','1',0,0,0,'Test name','','','','test@email.email',1033383261,1,'',0,'','','','','','','','','',0,0,0,1071746256,1071746256);

--
-- Table structure for table `index_fulltext`
--

CREATE TABLE `index_fulltext` (
  `phash` int(11) NOT NULL default '0',
  `fulltextdata` mediumtext NOT NULL,
  PRIMARY KEY  (`phash`)
) TYPE=MyISAM;

--
-- Dumping data for table `index_fulltext`
--


--
-- Table structure for table `index_grlist`
--

CREATE TABLE `index_grlist` (
  `phash` int(11) NOT NULL default '0',
  `phash_x` int(11) NOT NULL default '0',
  `hash_gr_list` int(11) NOT NULL default '0',
  `gr_list` tinytext NOT NULL,
  `uniqid` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`uniqid`),
  KEY `joinkey` (`phash`,`hash_gr_list`),
  KEY `phash_grouping` (`phash_x`,`hash_gr_list`)
) TYPE=MyISAM;

--
-- Dumping data for table `index_grlist`
--


--
-- Table structure for table `index_phash`
--

CREATE TABLE `index_phash` (
  `phash` int(11) NOT NULL default '0',
  `phash_grouping` int(11) NOT NULL default '0',
  `cHashParams` tinyblob NOT NULL,
  `data_filename` tinytext NOT NULL,
  `data_page_id` int(11) unsigned NOT NULL default '0',
  `data_page_reg1` int(11) unsigned NOT NULL default '0',
  `data_page_type` tinyint(3) unsigned NOT NULL default '0',
  `data_page_mp` tinytext NOT NULL,
  `gr_list` tinytext NOT NULL,
  `item_type` tinyint(4) NOT NULL default '0',
  `item_title` tinytext NOT NULL,
  `item_description` tinytext NOT NULL,
  `item_mtime` int(11) NOT NULL default '0',
  `tstamp` int(11) unsigned NOT NULL default '0',
  `item_size` int(11) NOT NULL default '0',
  `contentHash` int(11) NOT NULL default '0',
  `crdate` int(11) NOT NULL default '0',
  `parsetime` int(11) NOT NULL default '0',
  `sys_language_uid` int(11) NOT NULL default '0',
  `item_crdate` int(11) NOT NULL default '0',
  PRIMARY KEY  (`phash`),
  KEY `phash_grouping` (`phash_grouping`)
) TYPE=MyISAM;

--
-- Dumping data for table `index_phash`
--


--
-- Table structure for table `index_rel`
--

CREATE TABLE `index_rel` (
  `phash` int(11) NOT NULL default '0',
  `wid` int(11) NOT NULL default '0',
  `count` tinyint(3) unsigned NOT NULL default '0',
  `first` tinyint(3) unsigned NOT NULL default '0',
  `freq` smallint(5) unsigned NOT NULL default '0',
  `flags` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`phash`,`wid`),
  KEY `wid` (`wid`,`phash`)
) TYPE=MyISAM;

--
-- Dumping data for table `index_rel`
--


--
-- Table structure for table `index_section`
--

CREATE TABLE `index_section` (
  `phash` int(11) NOT NULL default '0',
  `phash_t3` int(11) NOT NULL default '0',
  `rl0` int(11) unsigned NOT NULL default '0',
  `rl1` int(11) unsigned NOT NULL default '0',
  `rl2` int(11) unsigned NOT NULL default '0',
  `page_id` int(11) NOT NULL default '0',
  `uniqid` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`uniqid`),
  KEY `joinkey` (`phash`,`rl0`),
  KEY `page_id` (`page_id`),
  KEY `rl0` (`rl0`,`rl1`,`phash`),
  KEY `rl0_2` (`rl0`,`phash`)
) TYPE=MyISAM;

--
-- Dumping data for table `index_section`
--


--
-- Table structure for table `index_stat_search`
--

CREATE TABLE `index_stat_search` (
  `uid` int(11) NOT NULL auto_increment,
  `searchstring` tinytext NOT NULL,
  `searchoptions` blob NOT NULL,
  `tstamp` int(11) NOT NULL default '0',
  `feuser_id` int(11) unsigned NOT NULL default '0',
  `cookie` varchar(10) NOT NULL default '',
  `IP` tinytext NOT NULL,
  `hits` int(11) NOT NULL default '0',
  PRIMARY KEY  (`uid`)
) TYPE=MyISAM;

--
-- Dumping data for table `index_stat_search`
--


--
-- Table structure for table `index_stat_word`
--

CREATE TABLE `index_stat_word` (
  `uid` int(11) NOT NULL auto_increment,
  `word` varchar(30) NOT NULL default '',
  `index_stat_search_id` int(11) NOT NULL default '0',
  `tstamp` int(11) NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  KEY `tstamp` (`tstamp`,`word`)
) TYPE=MyISAM;

--
-- Dumping data for table `index_stat_word`
--


--
-- Table structure for table `index_words`
--

CREATE TABLE `index_words` (
  `wid` int(11) NOT NULL default '0',
  `baseword` varchar(30) NOT NULL default '',
  `metaphone` int(11) NOT NULL default '0',
  PRIMARY KEY  (`wid`),
  KEY `baseword` (`baseword`,`wid`),
  KEY `metaphone` (`metaphone`,`wid`)
) TYPE=MyISAM;

--
-- Dumping data for table `index_words`
--


--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `uid` int(11) NOT NULL auto_increment,
  `pid` int(11) NOT NULL default '0',
  `tstamp` int(11) unsigned NOT NULL default '0',
  `sorting` int(11) unsigned NOT NULL default '0',
  `deleted` tinyint(4) unsigned NOT NULL default '0',
  `perms_userid` int(11) unsigned NOT NULL default '0',
  `perms_groupid` int(11) unsigned NOT NULL default '0',
  `perms_user` tinyint(4) unsigned NOT NULL default '0',
  `perms_group` tinyint(4) unsigned NOT NULL default '0',
  `perms_everybody` tinyint(4) unsigned NOT NULL default '0',
  `crdate` int(11) unsigned NOT NULL default '0',
  `cruser_id` int(11) unsigned NOT NULL default '0',
  `title` tinytext NOT NULL,
  `alias` varchar(20) NOT NULL default '',
  `doktype` tinyint(3) unsigned NOT NULL default '0',
  `url` tinytext NOT NULL,
  `hidden` tinyint(4) unsigned NOT NULL default '0',
  `starttime` int(11) unsigned NOT NULL default '0',
  `endtime` int(11) unsigned NOT NULL default '0',
  `urltype` tinyint(4) unsigned NOT NULL default '0',
  `shortcut` int(10) unsigned NOT NULL default '0',
  `no_cache` int(10) unsigned NOT NULL default '0',
  `fe_group` int(11) NOT NULL default '0',
  `subtitle` tinytext NOT NULL,
  `layout` tinyint(3) unsigned NOT NULL default '0',
  `target` varchar(20) NOT NULL default '',
  `media` blob NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL default '0',
  `keywords` text NOT NULL,
  `cache_timeout` int(10) unsigned NOT NULL default '0',
  `newUntil` int(10) unsigned NOT NULL default '0',
  `description` text NOT NULL,
  `no_search` tinyint(3) unsigned NOT NULL default '0',
  `SYS_LASTCHANGED` int(10) unsigned NOT NULL default '0',
  `abstract` text NOT NULL,
  `module` varchar(10) NOT NULL default '',
  `extendToSubpages` tinyint(3) unsigned NOT NULL default '0',
  `TSconfig` blob NOT NULL,
  `author` tinytext NOT NULL,
  `author_email` varchar(80) NOT NULL default '',
  `nav_title` tinytext NOT NULL,
  `storage_pid` int(11) NOT NULL default '0',
  `is_siteroot` tinyint(4) NOT NULL default '0',
  `php_tree_stop` tinyint(4) NOT NULL default '0',
  `shortcut_mode` int(10) unsigned NOT NULL default '0',
  `content_from_pid` int(10) unsigned NOT NULL default '0',
  `mount_pid` int(10) unsigned NOT NULL default '0',
  `tx_impexp_origuid` int(11) NOT NULL default '0',
  `nav_hide` tinyint(4) NOT NULL default '0',
  `mount_pid_ol` tinyint(4) NOT NULL default '0',
  `t3ver_oid` int(11) unsigned NOT NULL default '0',
  `t3ver_id` int(11) unsigned NOT NULL default '0',
  `t3ver_label` varchar(30) NOT NULL default '',
  `editlock` tinyint(4) unsigned NOT NULL default '0',
  `l18n_cfg` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  KEY `parent` (`pid`),
  KEY `alias` (`alias`),
  KEY `t3ver_oid` (`t3ver_oid`)
) TYPE=MyISAM;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` VALUES (1,50,1071595042,256,0,1,0,31,27,0,962459310,1,'Startpage','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071595042,'','',0,'->PROC.=1\r\n# Setting general display of columns to Normal column ONLY! \r\n# We don\'t need the other columns because this template offers display of the Normal content only.\r\nmod.SHARED.colPos_list = 0,0\r\n\r\n# Setting the default font face in the RTE. This only affects the backend display.\r\nRTE.default >\r\nRTE.default {\r\n  mainStyle_font = Arial, sans-serif\r\n  mainStyle_size = 12\r\n  mainStyle_color = black\r\n  classesParagraph = redText\r\n  classesCharacter = redText\r\n  showButtons = cut,copy,fontstyle,fontsize, textcolor,table,bgcolor\r\n  proc.preserveTables = 1\r\n\r\n  proc.entryHTMLparser_db = 1\r\n  proc.entryHTMLparser_db {\r\n    keepNonMatchedTags = 1\r\n    xhtml_cleaning = 1\r\n  }\r\n\r\n  mainStyleOverride_add {\r\n    P =  font-family:Arial, sans-serif; font-size:12;\r\n    H1 =  font-family:Arial, sans-serif; font-size:16;  font-weight:bold; margin-top:0;margin-bottom:10;\r\n    H2 =  font-family:Arial, sans-serif; font-size:12;  font-weight:bold; color:navy; margin-top:0;margin-bottom:10;\r\n    H3 =  font-family:Arial, sans-serif; font-size:18;  font-weight:bold;\r\n    H4 =  font-family:Arial, sans-serif; font-size:24; \r\n    H5 =  font-family:Arial, sans-serif; font-size:20;  color:navy; font-weight:normal;  margin-top:0;margin-bottom:10;\r\n    H6 =  font-family:Arial, sans-serif; font-size:16;  font-weight:bold;\r\n  }\r\n  disablePCexamples = 0\r\n} \r\nRTE.classes {\r\n  redText {\r\n    name = Red text |Rd tekst\r\n    value = color:red;\r\n  }\r\n}\r\n\r\n# Setting the width of the fullscreen RTE window. Approx. same width as the webpage:\r\nTCEFORM.tt_content.bodytext.RTEfullScreenWidth = 430\r\n','','','',0,1,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (2,1,1071979802,176,0,1,0,31,27,0,962459388,1,'Content elements','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071979802,'','',0,'\r\n','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (3,1,1015968408,352,0,1,0,31,27,0,962459408,1,'Images','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071593797,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (4,1,1017249354,448,0,1,0,31,27,0,962459472,1,'USER','',1,'',0,0,0,1,0,0,1,'',0,'','',0,'',0,0,'',0,1071586726,'','',1,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (5,2,1071589603,256,0,1,0,31,27,0,962459477,1,'Insert content','insertcontent',2,'',0,0,0,1,0,0,0,'',0,'','',0,'content elements',0,0,'Description of the simple content elements in TYPO3',0,1071589603,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (6,2,1029307395,512,0,1,0,31,27,0,962459484,1,'Special content','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'This is about filelinks, emailforms and searching',0,1071588934,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (7,0,1008321933,512,0,1,0,31,27,0,972332355,1,'General User Storage','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','fe_users',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (8,4,1029354509,1000000000,0,1,0,31,27,0,972333310,1,'Welcome!','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1029354509,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (9,1,972333687,640,0,1,0,31,27,0,972333669,1,'Back to Startpage','',4,'',0,0,0,1,1,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (10,50,1020808129,512,0,1,1,31,17,0,972399874,1,'Another site in the same database!','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071662531,'','',0,'# Setting listing of columns in the Page Layout module to Normal and Left only.\r\n# (example only, we could do fine with the Normal column only as the template does not include the \"Left\" content anywhere anyway)\r\nmod.SHARED.colPos_list  = 0,1\r\n\r\n# Make sure that the webpage is shown with &type=1\r\nmod.web_view.type=1\r\n\r\n# Setting the default font face in the RTE. This only affects the backend display.\r\nRTE.default >\r\nRTE.default {\r\n  mainStyle_font = Arial, sans-serif\r\n  mainStyle_size = 12\r\n  mainStyle_color = #003300\r\n  mainStyle_bgcolor = #EFEFE7\r\n} \r\n\r\n# Setting the width of the fullscreen RTE window. Approx. same width as the webpage:\r\nTCEFORM.tt_content.bodytext.RTEfullScreenWidth = 530\r\n','','','',0,1,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (11,10,1029349441,256,0,2,0,31,27,0,972399978,1,'Lists','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071663967,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (12,10,1010480340,512,0,1,1,31,19,0,972399999,1,'Backend user','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071664460,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (13,11,1010796779,352,0,1,0,31,27,0,972400307,1,'Addresses','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1099346643,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (15,11,1008079658,768,0,1,0,31,27,0,972400320,1,'Guestbook','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1008079658,'','approve',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (16,1,972401898,1024,0,1,0,31,27,0,972401882,1,'Another site...','',3,'?10',0,0,0,0,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (17,10,972403713,768,0,2,1,31,27,0,972401978,1,'Default site','',4,'',0,0,0,1,1,0,0,'',0,'_top','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (18,10,1070922191,640,0,10,1,31,27,0,972402000,1,'Cool example','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071664512,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (20,2,985266629,768,0,1,0,31,27,0,985008485,1,'Search','',2,'',0,0,0,1,0,0,0,'Search the site from here!',0,'','',0,'',0,0,'',0,1014653925,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (21,2,985008552,1024,0,1,0,31,27,0,985008552,1,'Thanks for your mail!','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071593901,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (22,2,985266555,640,0,1,0,31,27,0,985009066,1,'Multimedia','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'Simpsons videoclip in Windows Media Audio/Video format',0,1021508726,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (24,11,1008344913,960,0,1,0,31,27,0,985011118,1,'Board','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1008344913,'','board',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (25,11,1008342279,1724,0,1,0,31,27,0,985011130,1,'Calendar','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1008342279,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (26,11,1008342283,1008,0,1,0,31,27,0,985011143,1,'Products','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1008342283,'','shop',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (28,0,985012650,768,0,1,1,31,1,0,985012461,1,'Categories','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (29,2,985268909,576,0,1,0,31,27,0,985258872,1,'Advanced','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'menu, sitemap',0,0,'A description of the \"Advanced\" type content elements',0,1071589422,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (30,2,985266555,896,0,1,0,31,27,0,985260952,1,'Your own scripts','',2,'',0,0,0,1,0,0,0,'How to include your own PHP-scripts',0,'','',0,'',0,0,'A page about the process of including your own PHP-scripts on pages',0,1071748503,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (31,2,999611568,608,0,1,0,31,27,0,985267522,1,'Menu/Sitemap','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'menu, sitemap, demonstration, content elements',0,0,'Demonstration of the \"Menu/Sitemap\" content element possibilities',0,1071589571,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (32,26,985276312,256,0,1,0,31,27,0,985276312,1,'Cameras','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000211859,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (33,26,985276333,512,0,1,0,31,27,0,985276333,1,'Video','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000212192,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (34,26,985276352,768,0,1,0,31,27,0,985276352,1,'Film','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000212352,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (35,26,985277048,1024,0,1,0,31,27,0,985276367,1,'Single display','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000212379,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (36,26,985276386,1280,0,1,0,31,27,0,985276386,1,'Search for product','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,985358608,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (37,26,985276403,1536,0,1,0,31,27,0,985276403,1,'Payment','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,985355741,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (38,10,985387864,384,0,1,0,31,27,0,985347490,1,'More lists and records','',4,'',0,0,0,1,39,0,0,'',0,'','',0,'',0,0,'',0,985347490,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (39,38,1021311951,256,0,10,1,31,27,0,985347508,1,'Lists','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071664150,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (40,38,985347531,512,0,1,0,31,27,0,985347531,1,'Records','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1024881335,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (41,0,985349107,1024,0,1,0,31,27,0,985349107,1,'Various items','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (42,10,985353928,752,0,1,0,31,27,0,985353928,1,'Sitemap','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1011447874,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (43,24,1070879370,768,0,1,0,31,27,0,985361345,1,'Sourcream and Onion Chips (list)','',1,'',0,0,0,1,0,0,0,'Discussions about the amount of fat in Sourcream and Onion Chips. ',0,'','',0,'',0,0,'',0,1070879370,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (44,24,1029328763,512,0,1,0,31,27,0,985367584,1,'Sourcream and Onion Chips (tree)','',1,'',0,0,0,1,0,0,0,'Discussions about the amount of fat in Sourcream and Onion Chips. This board has the tree-like layout, because \"Layout1\" is chosen.',0,'','',0,'',0,0,'',0,1029328763,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (45,0,998436285,1280,0,1,0,31,27,0,998436285,1,'Direct Mail Example','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (46,45,998436381,256,0,1,0,31,27,0,998436381,1,'Mail user administration','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1002549303,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (47,45,1011634595,512,0,1,0,31,27,0,998436436,1,'Direct Mail module','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','dmail',0,'## CONFIGURATION of the direct mail module:\r\n\r\nmod.web_modules.dmail {\r\n  from_name = John Spam Doe\r\n  from_email= john.doe@nothing.test\r\n  organisation = John Does Testsite\r\n  replyto_email =\r\n  replyto_name =\r\n\r\n  plainParams = &type=99\r\n  HTMLParams = \r\n\r\n    # UID\'s of the tt_address records to use for test-sending:\r\n  test_tt_address_uids = 13,14\r\n\r\n    # table name of a userdefined table similar to tt_address (same fields) which may be used for distribution also.\r\n  userTable = \r\n\r\n  enablePlain = 1\r\n  enableHTML = 1\r\n\r\n  http_username = \r\n  http_password = \r\n  sendOptions=3\r\n\r\n  categories {\r\n    1 = Food\r\n    2 = Books\r\n    3 = Sport\r\n    4 = Religion\r\n  }\r\n}\r\n\r\n\r\nmod.web_dmail.categories.0=Religion\r\nmod.web_dmail.categories.4=\r\nmod.web_dmail.test_dmail_group_uids=1,2\nmod.web_modules.dmail.categories.0=Food\nmod.web_modules.dmail.categories.1=Books\nmod.web_modules.dmail.categories.2=Sport\nmod.web_modules.dmail.categories.3=Religion\nmod.web_modules.dmail.categories.4=\nmod.web_modules.dmail.long_link_rdct_url=http://barneguiden.typo3.com/\nmod.web_modules.dmail.long_link_mode=1','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (48,47,998436488,256,0,1,0,31,27,0,998436488,1,'Newsletter #1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071668406,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (49,50,1020795942,768,0,1,0,31,27,0,998436665,1,'TypoScript examples','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1020795942,'','',0,'# Reset all former RTE settings for this subsection:\r\nRTE >\r\nRTE.default.disabled = 1','','','',0,1,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (50,0,1032956660,256,0,1,0,31,27,0,999600419,1,'Intro','intro',2,'',0,0,0,1,0,0,0,'The Introduction page of the testsite.',0,'','',0,'',0,0,'',0,1071669485,'','',0,'# Setting general display of columns to Normal column ONLY! \r\nmod.SHARED.colPos_list = 0\r\n\r\n# Setting the default font face in the RTE. This only affects the backend display.\r\n# These settings match the ones used in the frontend stylesheet so the text appears much the same\r\nRTE.default {\r\n  mainStyle_font = Verdana, sans-serif\r\n  mainStyle_size = 11\r\n  mainStyle_color = #333333\r\n  mainStyleOverride_add.P = line-height : 180%; text-indent : 20px;\r\n  mainStyleOverride_add.DIV < .mainStyleOverride_add.P\r\n} \r\n\r\n# Setting the width of the fullscreen RTE window. \r\nTCEFORM.tt_content.bodytext.RTEfullScreenWidth = 450\r\n','Kasper Skrhj','kasper2004@typo3.com','',0,1,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (51,112,1001321770,16,0,1,0,31,27,0,999607124,1,'DHTML pop-up menu (GMENU_LAYERS)','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321770,'Demonstrates the GMENU_LAYERS TypoScript object. \r\nThis object generates a graphical menu where a mouseover event will display a DHTML layer with submenu items. This is also layerbased and should work in all modern browsers.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (52,112,1001321784,8,0,1,0,31,27,0,999607186,1,'Menu of selector boxes (JSMENU)','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321784,'Demonstrates the use of the JSMENU TypoScript object. In short, this object generates a menu of page-titles with one or more selectorboxes. If more than one selectorbox is used, the secondary selector box is dynamically filled with the correct sublevel elements when a selection is made in the primary selector.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (53,112,1001321770,32,0,1,0,31,27,0,999607215,1,'DHTML fold out menu (GMENU_FOLDOUT)','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321770,'Demonstrates the GMENU_FOLDOUT object. This is also a multilevel menu there the toplevel items \"folds out\" the sublevel items. This is also layerbased and should work in all modern browsers.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (54,113,1001321807,16,0,1,0,31,27,0,999697811,1,'Calling a method in a custom class (USER cObject).','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321807,'Demonstrates how you can call a method in a class you\'ve written and included from TypoScript. This example calls the method \'listContentRecordsOnPage\' in the class \'user_various\' in the script media/scripts/example_callfunction.php. Please examine this script to see the PHP-code there.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (55,113,1001321807,32,0,1,0,31,27,0,999698386,1,'Passing a string through a custom function (USER cObject).','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321807,'The .stdWrap property is widely used in TypoScript. But if the native properties of stdWrap is not enough, you can write your own function to proces the content. This page shows an example where the string HELLO WORLD is reversed by a custom function \'user_reverseString\' from the included script \'media/scripts/example_callfunction.php\'. Please examine this script to see the PHP-code there.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (56,113,1001321807,128,0,1,0,31,27,0,999698769,1,'Mixing cached and dynamic content (USER_INT cObject).','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321807,'Demonstrates how you can include dynamic content on a page which is otherwise cached. The example uses the content element type \"Script\" to insert the dynamic data on the page. The evidence that the page is cached is best seen if you inspect the rendering by the TypoScript debugger in the admin panel.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (57,113,1001321807,256,0,1,0,31,27,0,999699982,1,'Inserting a totally plain PHP script on a page (PHP_SCRIPT_EXT cObject).','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321807,'This demonstrates how to include the content of ANY ordinary PHP-script somewhere on a page mixed with regular cached content. The testscript is \'media/scripts/testscript_EXT.php\'.  Please make sure to examine this script.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (58,11,1008079658,1184,0,1,0,31,27,0,999771152,1,'News','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1008082485,'','news',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (59,2,1032949427,960,0,1,0,31,27,0,999784672,1,'XML / WAP / PDA','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071765922,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (60,49,999807646,1792,0,1,0,31,27,0,999807646,1,'WAP test','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,999807646,'This page is a very simple WAP page which tests that you can send a WAP header instead of normal HTML.\r\nGo to http://wapsilon.com/ to test.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (61,26,1000214182,1792,0,1,0,31,27,0,1000214173,1,'Tracking','trackpage',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000214182,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (62,10,1000225763,760,0,1,0,31,27,0,1000225717,1,'www.typo3.com','',3,'www.typo3.com',0,0,0,1,0,0,0,'',0,'_top','',0,'',0,0,'',0,1000225763,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (63,52,1000232748,256,0,1,0,31,27,0,1000232748,1,'First page in menu','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (64,52,1000232804,512,0,1,0,31,27,0,1000232758,1,'Second page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (65,52,1000232823,768,0,1,0,31,27,0,1000232761,1,'Third page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000232823,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (66,63,1000232864,256,0,1,0,31,27,0,1000232764,1,'A subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000232864,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (67,63,1000232864,512,0,1,0,31,27,0,1000232769,1,'The third subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000232864,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (68,64,1000232864,256,0,1,0,31,27,0,1000232777,1,'A very lonely subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000232864,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (69,63,1000232864,384,0,1,0,31,27,0,1000232783,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000232864,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (70,51,1000237203,256,0,1,0,31,27,0,1000237168,1,'Third page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237203,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (71,51,1000237203,128,0,1,0,31,27,0,1000237168,1,'Second page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237203,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (72,71,1000237168,256,0,1,0,31,27,0,1000237168,1,'A very lonely subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237168,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (73,51,1000237203,64,0,1,0,31,27,0,1000237168,1,'First page in menu','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237203,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (74,73,1000237168,256,0,1,0,31,27,0,1000237168,1,'The third subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237168,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (75,73,1000237169,128,0,1,0,31,27,0,1000237169,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237169,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (76,73,1000237169,64,0,1,0,31,27,0,1000237169,1,'A subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237169,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (77,53,1000804515,384,0,1,0,31,27,0,1000237175,1,'Third page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000804515,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (78,53,1000237203,128,0,1,0,31,27,0,1000237175,1,'Second page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237203,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (79,78,1000237175,256,0,1,0,31,27,0,1000237175,1,'A very lonely subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237175,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (80,53,1000237203,64,0,1,0,31,27,0,1000237175,1,'First page in menu','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237203,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (81,80,1000237175,256,0,1,0,31,27,0,1000237175,1,'The third subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237175,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (82,80,1000237176,128,0,1,0,31,27,0,1000237176,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237176,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (83,80,1000237176,64,0,1,0,31,27,0,1000237176,1,'A subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000237176,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (84,112,1071668981,64,0,1,0,31,27,0,1000286120,1,'Custom images menu','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071668981,'Demonstrates how to make a menu, where the item images are media-files attached to the page record and thereby not auto-generated by TYPO3. The image files were made with Adobe ImageReady.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (85,84,1000802925,256,0,1,0,31,27,0,1000286120,1,'Third page','',2,'',0,0,0,1,0,0,0,'',0,'','menu_03.gif,menu_03-over.gif',0,'',0,0,'',0,1000802925,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (86,84,1000802925,128,0,1,0,31,27,0,1000286120,1,'Second page','',2,'',0,0,0,1,0,0,0,'',0,'','menu_02.gif,menu_02-over.gif',0,'',0,0,'',0,1000802925,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (87,84,1000802925,64,0,1,0,31,27,0,1000286120,1,'First page in menu','',2,'',0,0,0,1,0,0,0,'',0,'','menu_01.gif,menu_01-over.gif',0,'',0,0,'',0,1000802925,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (88,112,1001321770,128,0,1,0,31,27,0,1000742747,1,'Fake menu items','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321770,'This demonstrates a powerful way to manipulate the content of a menu. You can pass the internal menu item array to a userdefined PHP-function before the menu items are physically generated and thus you\'re for instance able to add \"non-existing\" items as if they were real pages in the tree!','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (89,88,1000742820,256,0,1,0,31,27,0,1000742795,1,'Third page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000742820,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (90,88,1000742820,128,0,1,0,31,27,0,1000742796,1,'Second page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000742820,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (91,88,1000742820,64,0,1,0,31,27,0,1000742796,1,'First page in menu','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000742820,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (92,91,1000742834,256,0,1,0,31,27,0,1000742834,1,'A subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000742834,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (93,52,1000801831,1024,0,1,0,31,27,0,1000801831,1,'Back to front page','',4,'',0,0,0,1,52,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (94,84,1000804700,96,0,1,0,31,27,0,1000804700,1,'Page with no items...','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1000804700,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (95,70,1001063157,256,0,1,0,31,27,0,1001063153,1,'Dummy not-in-menu','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001063157,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (96,114,1001322057,256,0,1,0,31,27,0,1001088165,1,'Making Pop-up links','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1020795347,'This template displays how to setup the <link> typotag to display the internal links in a JavaScript popup window.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (97,112,1016635749,256,0,1,0,31,27,0,1001159483,1,'Menu state test','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031822245,'This tests all the menu states NO, ACT, IFSUB, CUR, USR, SPC, USERDEF1 and USERDEF2.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (98,97,1001159500,256,0,1,0,31,27,0,1001159500,1,'Page 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1016634682,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (99,97,1001159623,512,0,1,0,31,27,0,1001159517,1,'Page 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1016634682,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (100,97,1001159623,768,0,1,0,31,27,0,1001159520,1,'Page 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1016634682,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (101,97,1001159623,1024,0,1,0,31,27,0,1001159523,1,'Page 4','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1016634682,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (102,97,1001159623,1280,0,1,0,31,27,0,1001159526,1,'Page 5','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1016634682,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (103,97,1001159623,1536,0,1,0,31,27,0,1001159529,1,'Page 6','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001172740,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (104,97,1001159623,1792,0,1,0,31,27,0,1001159532,1,'Page 7','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001172740,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (105,97,1001159623,2048,0,1,0,31,27,0,1001159544,1,'Page 8','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001172740,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (106,99,1001159663,256,0,1,0,31,27,0,1001159551,1,'Subpage 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1016634682,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (107,99,1001159663,512,0,1,0,31,27,0,1001159555,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001172740,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (108,106,1001159663,256,0,1,0,31,27,0,1001159558,1,'Sub-subpage 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1016634682,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (109,97,1001160897,1408,0,1,0,31,27,0,1001160897,1,'Spacer!','',199,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001172740,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (110,97,1001160923,1664,0,1,0,31,27,0,1001160923,1,'Access restricted','',1,'',0,0,0,1,0,0,1,'',0,'','',0,'',0,0,'',0,1001172740,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (111,109,1001172464,256,0,1,0,31,27,0,1001172464,1,'Subpage?','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (112,49,1001321610,64,0,1,0,31,27,0,1001321610,1,'Menu object examples','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321908,'A lot of examples of how to create navigation with TMENU, GMENU and IMGMENU. It includes extensive examples of GMENU_LAYERS and GMENU_FOLDOUT as well.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (113,49,1001321716,96,0,1,0,31,27,0,1001321628,1,'Custom Dynamic Content and Processing','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001321974,'Examples of how to integrate content from your own PHP-scripts, functions and classes. It also shows how you can pass internal content to your own functions for pre-processing.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (114,49,1001322045,944,0,1,0,31,27,0,1001322045,1,'Small Tricks','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001322148,'Examples of various small enhancements you could do. ','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (115,112,1001325246,512,0,1,0,31,27,0,1001325246,1,'Loading multiple frames by JavaScript','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001325246,'Demonstrates how to make a GMENU load the content in multiple frames without reloading the frameset itself. It also demonstrates how to keep the rollover state of the clicked menu item as \'active\' indication.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (116,115,1001325701,256,0,1,0,31,27,0,1001325611,1,'Back to front page','',4,'',0,0,0,1,115,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (117,115,1001325675,128,0,1,0,31,27,0,1001325611,1,'Third page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001325675,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (118,115,1001325675,64,0,1,0,31,27,0,1001325611,1,'Second page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001325675,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (119,115,1001325675,32,0,1,0,31,27,0,1001325611,1,'First page in menu','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001325675,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (120,119,1001325675,256,0,1,0,31,27,0,1001325626,1,'The third subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001325675,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (121,119,1001325675,128,0,1,0,31,27,0,1001325626,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001325675,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (122,119,1001333329,64,0,1,0,31,27,0,1001325626,1,'A subpage (with target)','',1,'',0,0,0,1,0,0,0,'',0,'_top','',0,'',0,0,'',0,1001333329,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (123,118,1001325675,256,0,1,0,31,27,0,1001325639,1,'A very lonely subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1001325675,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (125,11,1001581630,1200,0,1,0,31,27,0,1001581630,1,'Rating','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1008339341,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (126,58,1003499551,256,0,1,0,31,27,0,1002050156,1,'Other news here','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1003499551,'','',0,'','John Doe','john@doe.doe','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (127,58,1002196291,512,0,1,0,31,27,0,1002196291,1,'Single news display','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1002211230,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (128,58,1002209459,768,0,1,0,31,27,0,1002209459,1,'Tip a friend','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1002210327,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (129,1,1002541577,1536,0,1,0,31,27,0,1002541577,1,'User registration','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1002549270,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (130,50,1020807146,640,0,1,0,31,27,0,1002629784,1,'Photo marathon (Example)','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1099343808,'','',0,'# Setting the default font face in the RTE. This only affects the backend display.\r\n# These settings match the ones used in the frontend stylesheet so the text appears much the same\r\nRTE.default {\r\n  mainStyle_font = Verdana, sans-serif\r\n  mainStyle_size = 12\r\n  mainStyle_color = black\r\n  mainStyleOverride_add.P = line-height : 180%; \r\n  mainStyleOverride_add.DIV < .mainStyleOverride_add.P\r\n} \r\n\r\n# Setting the width of the fullscreen RTE window. \r\nTCEFORM.tt_content.bodytext.RTEfullScreenWidth = 400\r\n','','','',0,1,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (131,130,1011275959,256,0,1,0,31,27,0,1002629811,1,'Photo Marathon User Storage','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','fe_users',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (132,130,1011275959,208,0,1,0,31,27,0,1002629966,1,'Registration','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1020807618,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (133,130,1024512378,192,0,1,0,31,27,0,1002632086,1,'Images','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1024512378,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (134,133,1002632950,256,0,1,0,31,27,0,1002632110,1,'Citylife','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1002640795,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (135,133,1002632126,512,0,1,0,31,27,0,1002632126,1,'Landscape','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1002714647,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (136,133,1002632140,768,0,1,0,31,27,0,1002632140,1,'Portrait','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1002714660,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (137,130,1011928684,224,0,1,0,31,27,0,1002632163,1,'Upload','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1011928684,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (138,137,1002632184,256,0,1,0,31,27,0,1002632180,1,'Portrait','',1,'',0,0,0,1,0,0,3,'',0,'','',0,'',0,0,'',0,1021900918,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (139,137,1011928693,512,0,1,0,31,27,0,1002632193,1,'Landscape','',2,'',0,0,0,1,0,0,2,'',0,'','',0,'',0,0,'',0,1011928693,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (140,137,1002632239,768,0,1,0,31,27,0,1002632195,1,'Citylife','',1,'',0,0,0,1,0,0,4,'',0,'','',0,'',0,0,'',0,1002722277,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (141,130,1011275959,240,0,1,0,31,27,0,1002632262,1,'Frontpage','',4,'',0,0,0,1,130,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (146,143,1020942602,3456,0,1,0,31,27,0,1003499704,1,'Addresses','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (143,0,1020939712,640,0,1,0,31,27,0,1003499623,1,'Garbage','',255,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (317,292,1031919621,512,0,1,0,31,27,0,1031919602,1,'Subpage 3 (copy 1)','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (147,11,1004098408,1208,0,1,0,31,27,0,1004098329,1,'Poll','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1024881354,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (148,147,1004099938,256,0,1,0,31,27,0,1004099938,1,'Poll Result','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1024881354,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (149,49,1005744691,2048,0,1,0,31,27,0,1005744691,1,'PATH_INFO test','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1010065525,'This is an example how you can use PATH_INFO with the Apache webserver to make search engine friendly sites. Will work ONLY with a webserver that returns PATH_INFO.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (150,149,1005744733,256,0,1,0,31,27,0,1005744733,1,'Page 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1005745630,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (151,149,1005744761,512,0,1,0,31,27,0,1005744750,1,'Page 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1005745630,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (152,149,1005744770,768,0,1,0,31,27,0,1005744753,1,'Page 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1005745630,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (312,293,1031917069,512,0,1,0,31,27,0,1031917069,1,'Subpage 4','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031917069,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (313,292,1031919560,256,0,1,0,31,27,0,1031919552,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031919560,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (314,313,1031919592,256,0,1,0,31,27,0,1031919553,1,'III / Third level - 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (315,313,1031919584,128,0,1,0,31,27,0,1031919553,1,'III / Third level - 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (316,313,1031919577,64,0,1,0,31,27,0,1031919553,1,'III / Third level - 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (154,114,1006880568,512,0,1,0,31,27,0,1006880568,1,'Custom browser window title','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1006880568,'Demonstrates how to put a custom page title in the <title>-tags of the page.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (155,114,1006900728,768,0,1,0,31,27,0,1006893287,1,'Greek?','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1006900728,'Test of Greek Character sets','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (156,155,1006893334,256,0,1,0,31,27,0,1006893307,1,'Greek char-set','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071676151,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (157,155,1006893324,512,0,1,0,31,27,0,1006893324,1,'non-Greek char set','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071591526,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (158,58,1010769487,1024,0,0,2,31,17,0,1008080085,1,'News draft page','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1008083691,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (159,58,1010420668,1280,0,1,4,31,9,0,1008084854,1,'Articles','',6,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1010420668,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (311,297,1031917025,64,0,1,0,31,27,0,1031917025,1,'Subpage 2 / Third level - 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031917025,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (310,297,1031917025,128,0,1,0,31,27,0,1031917025,1,'Subpage 2 / Third level - 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (309,297,1031917025,256,0,1,0,31,27,0,1031917025,1,'Subpage 2 / Third level - 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (308,302,1031904505,256,0,1,0,31,27,0,1031904505,1,'Forth level 6','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031904505,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (307,298,1031904490,128,0,1,0,31,27,0,1031904490,1,'Forth level 4','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (169,143,1014983665,896,0,1,0,31,27,0,1008242335,1,'oooooooo','asdfasdf',1,'',1,1014937200,1015110000,1,0,0,1,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (306,298,1031904490,256,0,1,0,31,27,0,1031904490,1,'Forth level 5','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031904490,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (173,10,1008256594,696,0,1,0,31,27,0,1008256166,1,'Other languages','',2,'',0,0,0,1,0,0,0,'TYPO3 handles many languages per page',0,'','',0,'Languages, english',0,0,'Explanation of how to implement other languages',0,1071664604,'This page contains a description of, how other languages works.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (305,299,1031904479,64,0,1,0,31,27,0,1031904479,1,'Forth level 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031904479,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (304,299,1031904479,128,0,1,0,31,27,0,1031904479,1,'Forth level 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031904479,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (302,295,1031829266,128,0,1,0,31,27,0,1031829266,1,'third level11','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031829266,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (303,299,1031904479,256,0,1,0,31,27,0,1031904479,1,'Forth level 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031904479,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (301,295,1031829266,256,0,1,0,31,27,0,1031829266,1,'third level22','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031829266,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (298,296,1031829256,256,0,1,0,31,27,0,1031829256,1,'third level3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031829256,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (299,296,1031829256,128,0,1,0,31,27,0,1031829256,1,'third level2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031829256,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (300,296,1031829256,64,0,1,0,31,27,0,1031829256,1,'third level1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031829256,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (228,225,1015238037,64,0,1,0,31,27,0,1015238037,1,'Page 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032523235,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (297,293,1031823027,256,0,1,0,31,27,0,1031823027,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031823027,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (296,294,1031823044,256,0,1,0,31,27,0,1031823017,1,'Subpage 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031823044,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (209,58,1010760010,1536,0,1,0,31,27,0,1010759986,1,'Published articles','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1010760010,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (227,225,1015238037,128,0,1,0,31,27,0,1015238037,1,'Page 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1015238037,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (226,225,1015238037,256,0,1,0,31,27,0,1015238037,1,'Page 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1015238037,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (295,294,1031823052,512,0,1,0,31,27,0,1031823017,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031823052,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (225,49,1071668958,2176,0,1,0,31,27,0,1015237991,1,'Simulate Static Documents','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071668958,'This demonstrates how TYPO3 can be configured to simulate static HTML documents. You must enable mod_rewrite and change the name of the sample mod_rewrite.htaccess file in the rootfolder to .htaccess','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (222,114,1071677378,1024,0,1,0,31,27,0,1011450606,1,'Static files edit','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071677434,'This demonstrates how to link to and directly edit static HTML files in TYPO3.','',0,'RTE.default.disabled = 0','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (223,222,1011450657,256,0,1,0,31,27,0,1011450650,1,'Static file placeholders','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (292,291,1031924452,256,0,1,0,31,27,0,1031823005,1,'Page 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031924452,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (293,291,1031924445,128,0,1,0,31,27,0,1031823005,1,'Page 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031924445,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (294,291,1031823005,64,0,1,0,31,27,0,1031823005,1,'Page 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031823005,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (291,112,1032248527,48,0,1,0,31,27,0,1031822991,1,'DHTML multiple/cascaded xMENU_LAYERS','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032248527,'Demonstrates that more than one GMENU_LAYERS can exist on a page and that you can cascade them if you like.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (290,102,1031822090,256,0,1,0,31,27,0,1031822079,1,'Subpage','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031822090,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (289,101,1031821254,256,0,1,0,31,27,0,1031821254,1,'Subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031821254,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (286,2,1033778358,1280,0,1,0,31,27,0,1029159153,1,'Indexed Search','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1033778447,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (280,277,1022828829,64,0,1,0,31,27,0,1022828829,1,'A subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (279,277,1022828829,128,0,1,0,31,27,0,1022828829,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1022828829,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (278,277,1022828829,256,0,1,0,31,27,0,1022828829,1,'The third subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (277,272,1022828833,64,0,1,0,31,27,0,1022828828,1,'First page in menu','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1022828833,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (268,2,1020972330,992,0,1,0,31,27,0,1020965432,1,'Rich Text Editor show-off','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1071748848,'','',0,'','','','RTE show-off',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (276,275,1022828828,256,0,1,0,31,27,0,1022828828,1,'A very lonely subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (275,272,1022828835,128,0,1,0,31,27,0,1022828828,1,'Second page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (273,272,1022828839,256,0,1,0,31,27,0,1022828828,1,'Third page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (274,273,1022828828,256,0,1,0,31,27,0,1022828828,1,'Dummy not-in-menu','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (272,112,1022828993,768,0,1,0,31,27,0,1022828420,1,'Keywords-Updated','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1022828993,'This demonstrates how to compile a set of pages for a menu through an external PHP-script. In this case the script generating the menu is media/scripts/makeMenu_keywords_updated.inc and it is based on a concept of combining keywords/updated date for the menu. It\'s made by Stephan Niebrgge [stephan.niebruegge@[REMOVE_ME]gmx.de]','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (318,317,1031919602,256,0,1,0,31,27,0,1031919602,1,'III / Third level - 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (319,321,1031919617,96,0,1,0,31,27,0,1031919602,1,'III / Third level - 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (320,317,1031919602,64,0,1,0,31,27,0,1031919602,1,'III / Third level - 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (321,292,1031919624,768,0,1,0,31,27,0,1031919606,1,'Subpage 3 (copy 2)','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031919624,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (322,321,1031919606,256,0,1,0,31,27,0,1031919606,1,'III / Third level - 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (323,321,1031919607,128,0,1,0,31,27,0,1031919607,1,'III / Third level - 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (324,321,1031919607,64,0,1,0,31,27,0,1031919607,1,'III / Third level - 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031919607,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (325,313,1031922050,32,0,1,0,31,27,0,1031922045,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031922050,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (326,325,1031922046,256,0,1,0,31,27,0,1031922046,1,'III / Third level - 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031922046,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (327,325,1031922046,128,0,1,0,31,27,0,1031922046,1,'III / Third level - 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031922046,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (328,325,1031922046,64,0,1,0,31,27,0,1031922046,1,'III / Third level - 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (329,295,1031922067,512,0,1,0,31,27,0,1031922061,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (330,329,1031922061,256,0,1,0,31,27,0,1031922061,1,'III / Third level - 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031922061,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (331,329,1031922061,128,0,1,0,31,27,0,1031922061,1,'III / Third level - 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031922061,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (332,329,1031922061,64,0,1,0,31,27,0,1031922061,1,'III / Third level - 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (333,329,1031922061,32,0,1,0,31,27,0,1031922061,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (334,317,1031922550,32,0,1,0,31,27,0,1031922534,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (335,334,1031922535,256,0,1,0,31,27,0,1031922535,1,'III / Third level - 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031922535,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (336,334,1031922535,128,0,1,0,31,27,0,1031922535,1,'III / Third level - 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (337,334,1031922535,64,0,1,0,31,27,0,1031922535,1,'III / Third level - 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (338,321,1031922546,112,0,1,0,31,27,0,1031922542,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031922546,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (339,338,1031922542,256,0,1,0,31,27,0,1031922542,1,'III / Third level - 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1031922542,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (340,338,1031922542,128,0,1,0,31,27,0,1031922542,1,'III / Third level - 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (341,338,1031922542,64,0,1,0,31,27,0,1031922542,1,'III / Third level - 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (342,112,1032010683,24,0,1,0,31,27,0,1032010637,1,'DHTML pop-up menu (TMENU_LAYERS)','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032010683,'Demonstrates the TMENU_LAYERS TypoScript object. \r\nThis object generates a textual menu where a mouseover event will display a DHTML layer with submenu items. This is also layerbased and should work in all modern browsers.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (343,342,1032010637,256,0,1,0,31,27,0,1032010637,1,'Third page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (344,343,1032010638,256,0,1,0,31,27,0,1032010638,1,'Dummy not-in-menu','',5,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (345,342,1032010638,128,0,1,0,31,27,0,1032010638,1,'Second page','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032010638,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (346,345,1032010638,256,0,1,0,31,27,0,1032010638,1,'A very lonely subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032010638,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (347,342,1032010638,64,0,1,0,31,27,0,1032010638,1,'First page in menu','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032010638,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (348,347,1032010638,256,0,1,0,31,27,0,1032010638,1,'The third subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032010638,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (349,347,1032010638,128,0,1,0,31,27,0,1032010638,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032010638,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (350,347,1032010638,64,0,1,0,31,27,0,1032010638,1,'A subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032010638,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (351,112,1032166479,56,0,1,0,31,27,0,1032166479,1,'Change table cell color on mouse over','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032166479,'Demonstrates a TMENU which will animate the color of the table cell it is put into.','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (352,351,1032166496,256,0,1,0,31,27,0,1032166496,1,'Page 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (353,351,1032166496,128,0,1,0,31,27,0,1032166496,1,'Page 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (354,351,1032166496,64,0,1,0,31,27,0,1032166496,1,'Page 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (355,354,1032166511,256,0,1,0,31,27,0,1032166511,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (356,354,1032166511,128,0,1,0,31,27,0,1032166511,1,'Subpage 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032166511,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (357,353,1032166520,256,0,1,0,31,27,0,1032166520,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (362,11,1032383616,1980,0,1,0,31,27,0,1032383616,1,'MiniNews','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032383637,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (363,114,1032503263,1536,0,1,0,31,27,0,1032500664,1,'Shortcut to first subpage','',4,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'Tests how shortcuts can be set to point to a subpage of the selected page. Also a set of how to display content from another page on the current page.','',0,'','','','',0,0,0,1,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (364,363,1032503225,256,0,1,0,31,27,0,1032500724,1,'Page 3 (content from page 1)','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032510156,'','',0,'','','','',0,0,0,0,366,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (365,363,1032503353,128,0,1,0,31,27,0,1032500724,1,'Page 2 (random subpage in \"Page 1\")','',4,'',0,0,0,1,366,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,2,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (366,363,1032507950,64,0,1,0,31,27,0,1032500724,1,'Page 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032510156,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (367,114,1032505053,1792,0,1,0,31,27,0,1032502866,1,'Mount point test','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032505053,'Tests the mountpoint feature. A mountpoint works like a symbolic link on Linux: It \"mounts\" another directory (here: page id) on the server at a certain position. This has effect in the front-end only!','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (368,367,1032503183,256,0,1,0,31,27,0,1032502948,1,'Page 3 (page mount)','',7,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032503183,'','',0,'','','','',0,0,0,0,0,371,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (369,367,1032502948,128,0,1,0,31,27,0,1032502948,1,'Page 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032502948,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (370,367,1032502948,64,0,1,0,31,27,0,1032502948,1,'Page 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032502948,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (371,367,1032502970,32,0,1,0,31,27,0,1032502961,1,'Mounted pages','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (372,371,1032515186,256,0,1,0,31,27,0,1032502987,1,'Subpage 3 (MOUNT)','',7,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032515186,'','',0,'','','','',0,0,0,0,0,383,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (373,371,1032502987,128,0,1,0,31,27,0,1032502987,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032502987,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (374,371,1032502987,64,0,1,0,31,27,0,1032502987,1,'Subpage 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032502987,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (375,374,1032503003,256,0,1,0,31,27,0,1032503003,1,'Sub-subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032503003,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (376,374,1032515167,128,0,1,0,31,27,0,1032503003,1,'Sub-subpage (MOUNT)','',7,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032515167,'','',0,'','','','',0,0,0,0,0,383,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (377,370,1032503132,256,0,1,0,31,27,0,1032503132,1,'Subpage 22','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032503132,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (378,370,1032503132,128,0,1,0,31,27,0,1032503132,1,'Subpage 11','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032503132,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (379,366,1032503283,256,0,1,0,31,27,0,1032503283,1,'Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032510268,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (380,366,1032503283,128,0,1,0,31,27,0,1032503283,1,'Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032510183,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (381,366,1032503283,64,0,1,0,31,27,0,1032503283,1,'Subpage 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032510173,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (382,363,1032510336,512,0,1,0,31,27,0,1032510290,1,'Page 4 (content from page 2 -> content from random subpage!)','',2,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032510336,'','',0,'','','','',0,0,0,0,365,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (383,367,1032515108,48,0,1,0,31,27,0,1032515068,1,'Mounted pages 2','',254,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (384,383,1032515128,256,0,1,0,31,27,0,1032515069,1,'2 - Subpage 3','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,0,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (385,383,1032515128,128,0,1,0,31,27,0,1032515069,1,'2 - Subpage 2','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032515128,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (386,383,1032515128,64,0,1,0,31,27,0,1032515069,1,'2 - Subpage 1','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032515128,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (387,386,1032515128,256,0,1,0,31,27,0,1032515069,1,'2 - Sub-subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032515128,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (388,386,1032515128,128,0,1,0,31,27,0,1032515069,1,'2 - Sub-subpage','',1,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032515128,'','',0,'','','','',0,0,0,0,0,0,0,0,0,0,0,'',0,0);
INSERT INTO `pages` VALUES (389,371,1032517771,512,0,1,0,31,27,0,1032517741,1,'Subpage 4 (MOUNT - self!)','',7,'',0,0,0,1,0,0,0,'',0,'','',0,'',0,0,'',0,1032517771,'','',0,'','','','',0,0,0,0,0,371,0,0,0,0,0,'',0,0);

--
-- Table structure for table `pages_language_overlay`
--

CREATE TABLE `pages_language_overlay` (
  `uid` int(11) NOT NULL auto_increment,
  `pid` int(11) NOT NULL default '0',
  `tstamp` int(11) unsigned NOT NULL default '0',
  `crdate` int(11) unsigned NOT NULL default '0',
  `cruser_id` int(11) unsigned NOT NULL default '0',
  `sys_language_uid` int(11) unsigned NOT NULL default '0',
  `title` tinytext NOT NULL,
  `hidden` tinyint(4) unsigned NOT NULL default '0',
  `starttime` int(11) unsigned NOT NULL default '0',
  `endtime` int(11) unsigned NOT NULL default '0',
  `subtitle` tinytext NOT NULL,
  `media` tinyblob NOT NULL,
  `keywords` text NOT NULL,
  `description` text NOT NULL,
  `abstract` text NOT NULL,
  `author` tinytext NOT NULL,
  `author_email` varchar(80) NOT NULL default '',
  `tx_impexp_origuid` int(11) NOT NULL default '0',
  `nav_title` tinytext NOT NULL,
  `t3ver_oid` int(11) unsigned NOT NULL default '0',
  `t3ver_id` int(11) unsigned NOT NULL default '0',
  `t3ver_label` varchar(30) NOT NULL default '',
  `l18n_diffsource` mediumblob NOT NULL,
  PRIMARY KEY  (`uid`),
  KEY `parent` (`pid`),
  KEY `t3ver_oid` (`t3ver_oid`)
) TYPE=MyISAM;

--
-- Dumping data for table `pages_language_overlay`
--

INSERT INTO `pages_language_overlay` VALUES (1,173,1008256434,1008256368,1,1,'Andre sprog',0,0,0,'TYPO3 kan hndtere flere sprog pr. side','','Sprog, dansk','Forklaring til, hvordan andre sprog fungerer.','Denne side indeholder en beskrivelse af, hvordan andre sprog fungerer.','','',0,'',0,0,'','');
INSERT INTO `pages_language_overlay` VALUES (2,173,1010509811,1008256443,1,2,'Andere Sprachen',0,0,0,'[in german...] TYPO3 handles many languages per page','','Sprache, Deutsch','[in german...] Explanation of how to implement other languages','[in german...] This page contains a description of, how other languages works.','','',0,'',0,0,'','');

--
-- Table structure for table `static_template`
--

CREATE TABLE `static_template` (
  `uid` int(11) unsigned NOT NULL auto_increment,
  `pid` int(11) unsigned NOT NULL default '0',
  `tstamp` int(11) unsigned NOT NULL default '0',
  `crdate` int(11) unsigned NOT NULL default '0',
  `title` tinytext NOT NULL,
  `include_static` tinyblob NOT NULL,
  `constants` blob NOT NULL,
  `config` blob NOT NULL,
  `description` text NOT NULL,
  `editorcfg` blob NOT NULL,
  PRIMARY KEY  (`uid`),
  KEY `parent` (`pid`)
) TYPE=MyISAM;

--
-- Dumping data for table `static_template`
--

INSERT INTO `static_template` VALUES (7,0,1054752613,938564296,'frameset; top-left-page','','  # cat=basic/dims; type=small; label=Top Frame: The height of the topframe\r\ntopFrameHeight = 150\r\n  # cat=basic/dims; type=small; label=Left Frame: The width of the left frame\r\nleftFrameWidth = 150\r\n','frameset = PAGE\r\npage = PAGE\r\nleft = PAGE\r\ntop = PAGE\r\nframeset.typeNum = 0\r\npage.typeNum = 1\r\nleft.typeNum = 2\r\ntop.typeNum = 3\r\n\r\nframeset.frameSet.rows = {$topFrameHeight},*\r\nframeset.frameSet.params = {$_stdFramesetParams}\r\nframeset.frameSet.1 = FRAME\r\nframeset.frameSet.1.obj = top\r\nframeset.frameSet.1.params = {$_stdFrameParams} scrolling=\"no\"\r\nframeset.frameSet.2 = FRAMESET\r\nframeset.frameSet.2 {\r\n  params = {$_stdFramesetParams}\r\n  cols = {$leftFrameWidth},*\r\n  1 = FRAME\r\n  1.obj = left\r\n  1.params = {$_stdFrameParams} scrolling=\"no\"\r\n  2 = FRAME\r\n  2.obj = page\r\n  2.params = {$_stdFrameParams} scrolling=\"auto\"\r\n}\r\n','','');
INSERT INTO `static_template` VALUES (13,0,1054752637,941993948,'frameset; top-page','','  # cat=basic/dims; type=small; label=Top Frame: The height of the topframe\r\ntopFrameHeight = 150','frameset = PAGE\r\npage = PAGE\r\ntop = PAGE\r\nframeset.typeNum = 0\r\npage.typeNum = 1\r\ntop.typeNum = 3\r\n\r\nframeset.frameSet.rows = {$topFrameHeight},*\r\nframeset.frameSet.params = {$_stdFramesetParams}\r\nframeset.frameSet {\r\n  1 = FRAME\r\n  1.obj = top\r\n  1.params = {$_stdFrameParams} scrolling=\"no\"\r\n  2 = FRAME\r\n  2.obj = page\r\n  2.params = {$_stdFrameParams} scrolling=\"auto\"\r\n}\r\n','','');
INSERT INTO `static_template` VALUES (17,0,1054752662,941996666,'frameset; top-page-right','','  # cat=basic/dims; type=small; label=Top Frame: The height of the topframe\r\ntopFrameHeight = 150\r\n  # cat=basic/dims; type=small; label=Page Frame: The width of the pageframe \r\npageFrameWidth = 450\r\n','frameset = PAGE\r\npage = PAGE\r\nright = PAGE\r\ntop = PAGE\r\nframeset.typeNum = 0\r\npage.typeNum = 1\r\nright.typeNum = 2\r\ntop.typeNum = 3\r\n\r\nframeset.frameSet.rows = {$topFrameHeight},*\r\nframeset.frameSet.params = {$_stdFramesetParams}\r\nframeset.frameSet.1 = FRAME\r\nframeset.frameSet.1.obj = top\r\nframeset.frameSet.1.params = {$_stdFrameParams} scrolling=\"no\"\r\nframeset.frameSet.2 = FRAMESET\r\nframeset.frameSet.2 {\r\n  params = {$_stdFramesetParams}\r\n  cols = {$pageFrameWidth},*\r\n  1 = FRAME\r\n  1.obj = page\r\n  1.params = {$_stdFrameParams} scrolling=\"auto\"\r\n  2 = FRAME\r\n  2.obj = right\r\n  2.params = {$_stdFrameParams} scrolling=\"no\"\r\n}\r\n','','');
INSERT INTO `static_template` VALUES (19,0,1054752589,942004100,'frameset; top / left-page','','  # cat=basic/dims; type=small; label=Top Frame: The height of the topframe\r\ntopFrameHeight = 150\r\n  # cat=basic/dims; type=small; label=Left Frame: The width of the left frame\r\nleftFrameWidth = 150\r\n','frameset = PAGE\r\nframeset2 = PAGE\r\npage = PAGE\r\nleft = PAGE\r\ntop = PAGE\r\nframeset.typeNum = 0\r\nframeset2.typeNum = 4\r\npage.typeNum = 1\r\nleft.typeNum = 2\r\ntop.typeNum = 3\r\n\r\nframeset.frameSet {\r\n  rows = {$topFrameHeight},*\r\n  params = {$_stdFramesetParams}\r\n  1 = FRAME\r\n  1.obj = top\r\n  1.params = {$_stdFrameParams} scrolling=\"no\"\r\n  2 = FRAME\r\n  2.obj = frameset2\r\n  2.params = {$_stdFrameParams} scrolling=\"no\"\r\n}\r\n\r\nframeset2.frameSet  {\r\n  params = {$_stdFramesetParams}\r\n  cols = {$leftFrameWidth},*\r\n  1 = FRAME\r\n  1.obj = left\r\n  1.params = {$_stdFrameParams} scrolling=\"no\"\r\n  2 = FRAME\r\n  2.obj = page\r\n  2.params = {$_stdFrameParams} scrolling=\"auto\"\r\n}\r\n','','');
INSERT INTO `static_template` VALUES (23,0,1054752536,942090884,'frameset; left-page','','  # cat=basic/dims; type=small; label=Left Frame: The width of the left frame\r\nleftFrameWidth = 150\r\n','frameset = PAGE\r\npage = PAGE\r\nleft = PAGE\r\nframeset.typeNum = 0\r\npage.typeNum = 1\r\nleft.typeNum = 2\r\n\r\nframeset.frameSet {\r\n  params = {$_stdFramesetParams}\r\n  cols = {$leftFrameWidth},*\r\n  1 = FRAME\r\n  1.obj = left\r\n  1.params = {$_stdFrameParams} scrolling=\"no\"\r\n  2 = FRAME\r\n  2.obj = page\r\n  2.params = {$_stdFrameParams} scrolling=\"auto\"\r\n}\r\n','','');
INSERT INTO `static_template` VALUES (24,0,1054752517,942101940,'frameset (+); top / left-adr-page','19','  # cat=basic/dims; type=small; label=Top Frame: The height of the topframe\r\ntopFrameHeight = 150\r\n  # cat=basic/dims; type=small; label=Left Frame: The width of the left frame\r\nleftFrameWidth = 150\r\n  # cat=basic/dims; type=small; label=\"Address Frame\": The height of the addressframe\r\nadrFrameHeight = 100\r\n','# PLEASE NOTE, this is an extension to the \r\n# static template  \"frameset; top / left-page\"\r\n\r\n\r\nadr = PAGE\r\nadr.typeNum = 10\r\n\r\nframeset2.frameSet.cols = {$leftFrameWidth},*\r\nframeset2.frameSet.params = {$_stdFramesetParams}\r\nframeset2.frameSet.1 = FRAMESET\r\nframeset2.frameSet.1 {\r\n  params = {$_stdFramesetParams}\r\n  rows = *,{$adrFrameHeight}\r\n  1 = FRAME\r\n  1.obj = left\r\n  1.params = {$_stdFrameParams} scrolling=\"no\"\r\n  2 = FRAME\r\n  2.obj = adr\r\n  2.params = {$_stdFrameParams} scrolling=\"no\"\r\n}\r\nframeset2.frameSet.2 = FRAME\r\nframeset2.frameSet.2.obj = page\r\nframeset2.frameSet.2.params = {$_stdFrameParams} scrolling=\"auto\" \r\n\r\n\r\n','PLEASE NOTE, this is an extension to the static template  \"frameset; top / left-page\"','');
INSERT INTO `static_template` VALUES (27,0,1054752559,942108726,'frameset; page-bottom','','  # cat=basic/dims; type=small; label=Bottom Frame: The height of the bottom frame\r\nbottomFrameHeight = 65\r\n','frameset = PAGE\r\npage = PAGE\r\nbottom = PAGE\r\nframeset.typeNum = 0\r\npage.typeNum = 1\r\nbottom.typeNum = 3\r\n\r\nframeset.frameSet.rows = *,{$bottomFrameHeight}\r\nframeset.frameSet.params = {$_stdFramesetParams}\r\nframeset.frameSet {\r\n  1 = FRAME\r\n  1.obj = page\r\n  1.params = {$_stdFrameParams} scrolling=\"auto\"\r\n  2 = FRAME\r\n  2.obj = bottom\r\n  2.params = {$_stdFrameParams} scrolling=\"no\"\r\n}\r\n\r\n','','');
INSERT INTO `static_template` VALUES (49,0,1054753725,956910541,'template; FIRST','50,43,68','frame {\r\n    # cat=basic/dims; type=int+; label=Frame, \"page\" width: Enter the width of the frame with the page content (name=\"page\"). This also applies to the \"top\" and \"bottom\" frame\r\n  pageW = 700\r\n    # cat=basic/dims; type=int+; label=Frame, \"page+top\" height: Enter the total height of the \"page\" and \"top\" frames\r\n  pageH = 380\r\n    # cat=basic/dims; type=int+; label=Frame, \"top\" height: Enter the height of the \"top\" frame (menu)\r\n  menuH = 70\r\n    # cat=basic/dims; type=int+; label=Frame, \"bottom\" height: Enter the height of the \"bottom\" frame\r\n  bottomH = 20\r\n}\r\n\r\n\r\n// This is backGround colors defined:\r\n  # cat=basic/color/a; type=color; label=Background color, page frame: Background color of the page in the right frame.\r\nbgCol = white\r\nbgCol {\r\n    # cat=basic/color/b; type=color; label=Background color, outer frames: Background color of the blank pages in the outer frames that surround the content and menu frames in the center.\r\n  outer = #62748e\r\n    # cat=basic/color/b; type=color; label=Background color, bottom frame: Background color of the bottom frame with the special menu.\r\n  bottom = #7b8ca5\r\n    # cat=basic/color/b; type=color; label=Background color, top frame: Background color of the top frame with the main menu and site logo.\r\n  top = #7b8ca5\r\n}\r\n\r\n\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = \r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = \r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = \r\n\r\nfile {\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Logo image, top frame: Logo image above the menu in the top frame.\r\n  toplogo = \r\n   # cat=basic/file; type=file[IMAGE_EXT]; label=Background image, page frame\r\n  bgImg_page = \r\n   # cat=basic/file; type=file[IMAGE_EXT]; label=Background image, top frame\r\n  bgImg_top = \r\n   # cat=basic/file; type=file[IMAGE_EXT]; label=Background image, bottom frame\r\n  bgImg_bottom = \r\n   # cat=basic/file; type=file[IMAGE_EXT]; label=Background image, outer frames\r\n  bgImg_outer = \r\n}\r\n\r\n  # cat=basic/color; type=color; label=Top frame, line color: Color of the separator line between the level-1 and level-2 menu in the top frame.\r\nsepLineColor = black\r\n  # cat=basic/dims; type=int[1-1000]; label=Top frame, left margin: The distance in pixels from left edge to the menu and logo image in the top frame. 2-3 pixels are added for the table-borders.\r\nleftMarginTop = 20\r\n\r\nrightCol {\r\n    #cat=right/enable; type=options[getNews,getBorder]; label=Column content: Choose \"getNews\" to select content from a specific page (defined below here) or \"getBorder\" to display the \"Border\"-content of the current page.\r\n  borderContent = getNews\r\n    #cat=right/dims; type=int+; label=Max Image Width: This indicates that maximum number of pixels (width) a block of images inserted as content is allowed to consume. NOTE: This is specific for the right column!\r\n  maxImageWidth = 150\r\n    #cat=right/typo; type=small; label=Bodytext font face\r\n  textStyle_face =\r\n    #cat=right/typo; type=int[1-5]; label=Bodytext font size\r\n  textStyle_size =\r\n    #cat=right/typo; type=small; label=Bodytext font color\r\n  textStyle_color =\r\n    #cat=right/typo; type=int[1-5]; label=Default Header type: Enter the number of the header layout to be used by default. \r\n  defaultHeaderType =\r\n}\r\n\r\n// PID\'s...\r\n  # cat=right/enable/z2; type=int+; label=News Content PID: If you selected \"getNews\" above, this is where you enter the page-id of the page from which to fetch the \"news\" content for the column.\r\nstyles.content.getNews.newsPid = \r\n\r\n  # cat=basic//a; type=int+; label=Bottom menu PID: Enter the page-id of the page that holds the pages, that should appear as a menu in the bottom frame\r\nbottomMenuPid = \r\n\r\n  # cat=basic/dims/a; type=int+; label=Width, main content: Width of the main content on the page.\r\nwidth.content = 400\r\n  # cat=basic,right/dims/a; type=int+; label=Width, border content: Width of the border content cell to the right on the page. NOTE: This option also appears in the category RIGHT, that specifically deals with the characteristics of the border-frame to the right on the page.\r\nwidth.rightCol = 160\r\n  # cat=basic/dims/a; type=int+; label=Width, gap: The gap is the distance between the main- and border-content in the page frame.\r\nwidth.gap = 105\r\n\r\n\r\nstyles.content.imgtext.maxW = 400\r\n\r\nPAGE_TARGET = page\r\ncontent.pageFrameObj = page\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"FIRST\"\r\n  description = FIRST is a frame-based template where the menu, bottom and pageframe is encasulated in another frameset that centers the page in the browser. // The menus are graphical and in two levels with a separate general menu in the bottom-frame. You can also define content for the second column to the right on the page. \r\n  bulletlist = Image in the top. (9) // 2-level graphical menu: Select TrueType-font, color, size, optional bullet, letter-spacing. (14) // 1-level graphical menu for general pages: Select TrueType-font, color, size, optional bullet, letter-spacing. (14) // Frameset: Select background-color and dimensions of the page-frame, bottom-frame and topframe. (11,12,13) // Optional static column with news from a page, you define. (2)\r\n  image = gfx/FIRST_basic.gif\r\n  1=width.content,styles.content.imgtext.maxW\r\n  2=width.rightCol\r\n  3=width.gap\r\n  4=frame.pageW\r\n  5=frame.pageH\r\n  6=frame.menuH\r\n  7=frame.bottomH\r\n  8=leftMarginTop\r\n  9=file.toplogo\r\n  10=bgCol,file.bgImg_page\r\n  11=bgCol.outer,file.bgImg_outer\r\n  12=bgCol.bottom,file.bgImg_bottom\r\n  13=bgCol.top,file.bgImg_top\r\n  14=sepLineColor\r\n  15=bottomMenuPid\r\n}\r\n\r\n\r\n','# ****************************\r\n# Definition of the menus\r\n# ****************************\r\n\r\ntemp.topMenu = HMENU\r\ntemp.topMenu {\r\n  1 < styles.gmenu.first\r\n  1.target = frameset2\r\n}\r\n\r\ntemp.topSubmenu = HMENU\r\ntemp.topSubmenu {\r\n  entryLevel = 1\r\n  1 < styles.gmenu.first\r\n  1.target = page\r\n}\r\n\r\ntemp.bottomSubmenu = HMENU\r\ntemp.bottomSubmenu {\r\n  special = directory\r\n  special.value = {$bottomMenuPid}\r\n  1 < styles.gmenu.first\r\n  1.target = page\r\n}\r\n\r\n\r\n# ****************************\r\n# Definition of the framesets\r\n# ****************************\r\n\r\nframeset = PAGE\r\nframeset2 = PAGE\r\npage = PAGE\r\nbottom = PAGE\r\ntop = PAGE\r\nback = PAGE\r\n\r\nframeset.typeNum = 0\r\nframeset2.typeNum = 5\r\npage.typeNum = 1\r\nbottom.typeNum = 2\r\ntop.typeNum = 3\r\nback.typeNum = 4\r\n\r\nframeset.frameSet.cols = *,{$frame.pageW},*\r\nframeset.frameSet.params = {$_stdFramesetParams}\r\nframeset.frameSet.1 = FRAME\r\nframeset.frameSet.1.obj = back\r\nframeset.frameSet.1.params = {$_stdFrameParams} scrolling=\"no\"\r\nframeset.frameSet.3 < frameset.frameSet.1\r\nframeset.frameSet.2 = FRAMESET\r\nframeset.frameSet.2 {\r\n  params = {$_stdFramesetParams}\r\n  rows = *,{$frame.pageH},{$frame.bottomH},*\r\n  1 = FRAME\r\n  1.obj = back\r\n  1.params = {$_stdFrameParams} scrolling=\"no\"\r\n\r\n  2 = FRAME\r\n  2.obj = frameset2\r\n  2.params = {$_stdFrameParams} scrolling=\"no\"\r\n  \r\n  3 = FRAME\r\n  3.obj = bottom\r\n  3.params = {$_stdFrameParams} scrolling=\"no\"\r\n\r\n  4 < .1\r\n}\r\n\r\nframeset2.frameSet {\r\n  params = {$_stdFramesetParams}\r\n  rows = {$frame.menuH},*\r\n\r\n  1 = FRAME\r\n  1.obj = top\r\n  1.params = {$_stdFrameParams} scrolling=\"no\"\r\n\r\n  2 = FRAME\r\n  2.obj = page\r\n  2.params = {$_stdFrameParams} scrolling=\"auto\" \r\n}\r\n\r\n\r\n# ****************************\r\n# Definition of the pages\r\n# ****************************\r\n\r\nback.bodyTag = <body bgcolor=\"{$bgCol.outer}\">\r\nback.bgImg = {$file.bgImg_outer}\r\n\r\n\r\ntop.bodyTag = <body bgcolor=\"{$bgCol.top}\">\r\ntop.bodyTagMargins = 0\r\ntop.bgImg = {$file.bgImg_top}\r\ntop {\r\n  wrap = <table border=\"0\" cellspacing=\"2\" cellpadding=\"0\"> | </table>\r\n  10 = IMAGE\r\n  10.file = {$file.toplogo}\r\n  10.wrap = <tr><td><img src=\"clear.gif\" width=\"{$leftMarginTop}\" height=\"1\" alt=\"\" /></td><td>|</td></tr>\r\n  20 < temp.topMenu\r\n  20.wrap = <tr><td></td><td>|</td></tr>\r\n  30 = TEXT\r\n  30.value = <tr><td></td><td bgcolor=\"{$sepLineColor}\">{$_clear}</td></tr>\r\n  40 < temp.topSubmenu\r\n  40.wrap = <tr><td></td><td>|</td></tr>\r\n}\r\n\r\n\r\nbottom.bodyTag = <body bgcolor=\"{$bgCol.bottom}\">\r\nbottom.bodyTagMargins = 0\r\nbottom.bgImg = {$file.bgImg_bottom}\r\nbottom {\r\n  wrap = <div align=\"right\"><table border=\"0\" cellspacing=\"2\" cellpadding=\"0\" align=\"right\"> | </table></div>\r\n  40 < temp.bottomSubmenu\r\n  40.wrap = <tr><td></td><td>|</td></tr>\r\n}\r\n\r\npage.bodyTag < styles.content.bodyTag\r\npage.bodyTagMargins = 0\r\npage.bgImg = {$file.bgImg_page}\r\npage.10 = CTABLE\r\npage.10 {\r\n  offset = 20,20\r\n  tableParams = border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"400\"\r\n  cWidth = {$width.content}\r\n  cMargins = 0,0,{$width.gap},0\r\n  c.5 < styles.content.editPanelPage\r\n  c.10 < styles.insertContent\r\n  c.20  < styles.content.lastUpdate\r\n  c.30  < styles.content.typo3_powered\r\n  c.TDParams = valign=\"top\"\r\n\r\n  rm.9 = LOAD_REGISTER\r\n  rm.9.maxImageWidth = {$rightCol.maxImageWidth}\r\n  rm.9.textStyle_face = {$rightCol.textStyle_face}\r\n  rm.9.textStyle_size = {$rightCol.textStyle_size}\r\n  rm.9.textStyle_color = {$rightCol.textStyle_color}\r\n  rm.9.defaultHeaderType = {$rightCol.defaultHeaderType}\r\n\r\n  rm.10 < styles.content.{$rightCol.borderContent}\r\n  rm.20 = CLEARGIF\r\n  rm.20.width={$width.rightCol}\r\n  rm.30 = RESTORE_REGISTER\r\n  rm.TDParams = valign=\"top\"\r\n}\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\nframeset.headerData.999 < plugin.meta\r\n\r\n\r\n','Standard-template\r\n\r\nPage-centeret Frames-based template with a logoimage in the top connected to a 2-level graphical menu below. \r\nContent is in two columns.','');
INSERT INTO `static_template` VALUES (40,0,1054753285,955295691,'styles.gmenu.bug','','styles.gmenu.bug >\r\nstyles.gmenu.bug {\r\n  pageFrameObj = page\r\n  menuFrameObj = left\r\n\r\n    # cat=menu/color; type=color; label=Menu background color\r\n  bgCol = #cccccc\r\n\r\n    # cat=menu/dims; type=int+; label=Height of menu items (pixels)\r\n  itemH = 20\r\n    # cat=menu/dims; type=int+; label=Width of menu items/menu (pixels)\r\n  itemW = 180\r\n    # cat=menu/dims; type=int+; label=Lenght of total menu: Enter the total lenght of the menu (pixels). This should be the same as the height of any background image under the total menu. (See styles.gmenu.bug.bgImg !)\r\n  length = 300\r\n\r\n    # cat=menu/typo; type=file[ttf]; label=Font file: TrueType (ttf) font for the menu.\r\n  file.fontFile = \r\n    # cat=menu/typo; type=int[1-40]; label=Font size: Font size on menu items\r\n  fontSize = 15\r\n    # cat=menu/typo; type=color; label=Font color: Font color on menu items\r\n  fontColor = white\r\n    # cat=menu/typo; type=offset; label=Text offset: Enter the offset of the text from the upper-left corner on the menu items\r\n  fontOffset = 20,15\r\n    # cat=menu/typo; type=options[,upper,lower]; label=Text case: You can force the text on the menu items to be either lowercase or uppercase.\r\n  case =\r\n\r\n    # cat=menu/typo; type=boolean[SHADOW]; label=Drop Shadow: Click this option if you want a drop shadow from the text on the menu items.\r\n  shadow = \r\n    # cat=menu/typo; type=int[1-100]; label=Drop Shadow opacity: If you enabled the Drop Shadow, you can adjust the opacity of the shadow to make it more or less dominant.\r\n  shadow.opacity = 100\r\n\r\n    # cat=menu/typo; type=boolean; label=Rollover: Click this option if you want a rollover (mouseover) effect on the menu items.\r\n  RO = 0\r\n    # cat=menu/typo; type=color; label=Rollover, font color: Enter the rollover font color of the text on the menu item.\r\n  RO.fontColor =\r\n\r\n\r\n    # cat=menu/file/n_bgimg; type=boolean[IMAGE]; label=Background image: By enabling this option, you can choose a background image for the whole menu. The image will expand downwards over the background of all the items!\r\n  bgImg = \r\n    # cat=menu/file/n_bgimg; type=file[IMAGE_EXT]; label=Background image, file: Choose the background image. NOTE: You should probably set the value of \".length\" to the height in pixels of this image!\r\n  bgImg.file.image = \r\n    # cat=menu/file/n_bgimg; type=file[IMAGE_EXT]; label=Background image, mask: Choose an optional mask for the background image. By this mask, the background image is \"superimposed\" onto the background color of the menu. White areas make the image visible, dark areas hide the image.\r\n  bgImg.file.mask = \r\n\r\n\r\n\r\n    # cat=menu/file/o_impose; type=boolean[IMAGE]; label=Color impose: You can impose a color through a mask on every single menu item. The color is imposed underneath the text but on top of the background image, if any.\r\n  maskImg = \r\n    # cat=menu/file/o_impose; type=color; label=Color impose, color: Enter the color\r\n  maskImg.imposeCol = #165D89\r\n    # cat=menu/file/o_impose; type=file[IMAGE_EXT]; label=Color impose, mask: Grayscale imagefile to mask the color through. White areas make the color visible, dark areas hide the color\r\n  maskImg.file.mask = \r\n\r\n\r\n    # cat=menu/file/p_rimpose; type=boolean[IMAGE]; label=Rollover, impose: You can impose a color through a mask on every single rollover menu item, if you like. The color is imposed just underneath the text. NOTE: You must select the rollover-option in the Typography-section!\r\n  RO.imposeImg = IMAGE\r\n    # cat=menu/file/p_rimpose; type=color; label=Rollover, impose color: In addition to changing the color of the text on the menu item, you can also impose a color through a mask. You could use this to make a line or box appear on the menu item when the mouse cursor moves over it.\r\n  RO.imposeCol = white\r\n    # cat=menu/file/p_rimpose; type=file[IMAGE_EXT]; label=Rollover, mask: Grayscale imagefile to mask the impose color through. White areas make the color visible, dark areas hide the color.\r\n  RO.file.mask = \r\n\r\n\r\n\r\n    # cat=menu//a; type=wrap; label=Wrap, menu items: This HTML-code is wrapped around every item in the menu. Normally you would use a <br />-tag here.\r\n  itemWrap = | <br />\r\n\r\n    # cat=menu//x; type=int[0-256]; label=Reduce colors: Number of indexed colors on menu items. If your menu items end up with weird colors, you can try to enter a higher number of colors. But the graphics-files will also increase their filesize.\r\n  reduceColors = 16\r\n\r\n}\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.menu {\r\n  header = styles.gmenu.bug\r\n  description = This graphical menu is powerful in many aspects. Especially because you can put a background image in the menu which will expand over all the items. See the image below.\r\n  bulletlist = Background image for the whole menu (4) // Dropshadow on Truetype font page titles (5) // Rollover (mouseover) color (6) // You can use grayscale masks to mask (impose) a color onto the menu item. Use this to generate geometric icons and alike on the items. (7)\r\n  image = gfx/BUG_menu.gif\r\n  1=styles.gmenu.bug.itemH\r\n  2=styles.gmenu.bug.itemW\r\n  3=styles.gmenu.bug.length\r\n  4=styles.gmenu.bug.bgImg\r\n  5=styles.gmenu.bug.shadow,styles.gmenu.bug.file.fontFile,styles.gmenu.bug.fontSize,styles.gmenu.bug.fontColor,styles.gmenu.bug.fontOffset,styles.gmenu.bug.case\r\n  6=styles.gmenu.bug.RO,styles.gmenu.bug.RO.fontColor\r\n  7=styles.gmenu.bug.RO.imposeImg\r\n}\r\n\r\n','styles.gmenu.bug >\r\nstyles.gmenu.bug = HMENU\r\nstyles.gmenu.bug {\r\n  1 = GMENU\r\n  1.target = {$styles.gmenu.bug.pageFrameObj}\r\n  1.applyTotalH = 10\r\n  1.removeObjectsOfDummy = 20,23\r\n  1.min = ,{$styles.gmenu.bug.length}\r\n  1.max = ,{$styles.gmenu.bug.length}\r\n  1.NO {\r\n    wrap = {$styles.gmenu.bug.itemWrap}\r\n    XY = {$styles.gmenu.bug.itemW},{$styles.gmenu.bug.itemH}\r\n    backColor = {$styles.gmenu.bug.bgCol}\r\n    reduceColors={$styles.gmenu.bug.reduceColors}\r\n\r\n    10 = {$styles.gmenu.bug.bgImg}\r\n    10.file = {$styles.gmenu.bug.bgImg.file.image}\r\n    10.mask = {$styles.gmenu.bug.bgImg.file.mask}\r\n\r\n    20 = {$styles.gmenu.bug.maskImg}\r\n    20.file = GIFBUILDER\r\n    20.file {\r\n      XY = {$styles.gmenu.bug.itemW},{$styles.gmenu.bug.length}\r\n      backColor = {$styles.gmenu.bug.maskImg.imposeCol}\r\n    }\r\n    20.mask = {$styles.gmenu.bug.maskImg.file.mask}\r\n\r\n    25 = {$styles.gmenu.bug.shadow}\r\n    25 {\r\n      textObjNum = 30\r\n      offset = 1,1\r\n      color = black\r\n      blur = 60\r\n      opacity = {$styles.gmenu.bug.shadow.opacity}\r\n    }\r\n\r\n    30 = TEXT\r\n    30.text.field = nav_title // title\r\n    30.text.case = {$styles.gmenu.bug.case}\r\n    30.offset = {$styles.gmenu.bug.fontOffset}\r\n    30.fontFile = {$styles.gmenu.bug.file.fontFile}\r\n    30.fontSize = {$styles.gmenu.bug.fontSize}\r\n    30.fontColor = {$styles.gmenu.bug.fontColor}\r\n    30.niceText = 1.5\r\n  }\r\n  1.RO < .1.NO\r\n  1.RO = {$styles.gmenu.bug.RO}\r\n  1.RO {\r\n    23 = {$styles.gmenu.bug.RO.imposeImg}\r\n    23.file = GIFBUILDER\r\n    23.file {\r\n      XY = {$styles.gmenu.bug.itemW},{$styles.gmenu.bug.itemH}\r\n      backColor = {$styles.gmenu.bug.RO.imposeCol}\r\n    }\r\n    23.mask = {$styles.gmenu.bug.RO.file.mask}\r\n    30.fontColor = {$styles.gmenu.bug.RO.fontColor}\r\n  }\r\n}\r\n','Graphical menu, one level.\r\n\r\nFeatures a background image expanding over all items plus rollover fontcolor and normal + rollover color overlay.\r\n\r\nUsed with template BUG','');
INSERT INTO `static_template` VALUES (41,0,1054753583,955297796,'template: BUG','7,51,40,43,68','  # cat=basic/color/a; type=color; label=Background color, all frames: This is the background color of all frames.\r\nbgCol = #eeeeff\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = \r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = \r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = \r\n\r\n\r\ntop {\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Top frame image: This image is put into the top frame of the site. The images is linked to the frontpage by default.\r\n  file.image =\r\n    # cat=basic/file/t; type=string; label=Top frame image, parameters: This is <img>-tag parameters for the top frame image. \"width\", \"height\" and \"src\" is already inserted, any others may be entered here.\r\n  imgParams = hspace=\"5\" vspace=\"5\"\r\n}\r\n\r\n  # cat=basic; type=comment; label=Text menu, page frame: Click this option to enable the text-based menu in the top of the page frame.\r\ncomment_textMenu = \r\n\r\n\r\n// Dimensions\r\ntopFrameHeight = 107\r\nleftFrameWidth = 200\r\nstyles.content.imgtext.maxW = 400\r\n\r\n  # cat=basic/dims; type=int+; label=Content width: This value defines the width in pixels of the table where the content is displayed in the page-frame\r\ncontentWidth = 400\r\n\r\n// Targets\r\nstyles.tmenu.pagetop.target = page\r\nPAGE_TARGET = page\r\ncontent.pageFrameObj = page\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"BUG\"\r\n  description = BUG is a frame-based template. There are 3 frames; a topframe, leftframe (menu) and a page-frame. You can define an image for the topframe and setup the layout of the menu in the leftframe. //The menu lets you define a background-image and rollover-effects. \r\n  bulletlist = Topframe image // Leftframe graphical menu of gif-images: Select TrueType-font, color, size, shadow-opacity, offset. Optional backgroundimage of the menuitems. Optional mouseover-effekt with changed font-color and/or image-overlay (like an arrow).  //  Define size and background-color of the 3 frames, top, left and page. \r\n  image = gfx/BUG_basic.gif\r\n  1=topFrameHeight,bgCol\r\n  2=leftFrameWidth,bgCol\r\n  3=contentWidth,bgCol,styles.content.imgtext.maxW\r\n  4=top.file.image,top.imgParams\r\n  5=comment_textMenu\r\n}\r\n\r\n','# Top frame is defined. Content is an image.\r\n\r\ntop.bodyTag = <body bgcolor=\"{$bgCol}\">\r\ntop.10 = IMAGE\r\ntop.10.linkWrap = <a href=\"index.php?{0}\" target=\"_top\"> | </a>\r\ntop.10.params = {$top.imgParams}\r\ntop.10.file = {$top.file.image}\r\n\r\n\r\n# Left frame is defined. Content is a menu\r\n\r\nleft.bodyTag = <body bgcolor=\"{$bgCol}\">\r\nleft.10 < styles.gmenu.bug\r\n\r\n\r\n# Page frame is defined. Content is a menu\r\n\r\npage.bodyTag < styles.content.bodyTag\r\npage.noLinkUnderline = 0\r\npage.bodyTagMargins = 0\r\n\r\npage.10 = CTABLE\r\npage.10 {\r\n  offset = 5, 0\r\n  tableParams = border=\"0\" width=\"{$contentWidth}\"\r\n  cWidth={$contentWidth}\r\n  c.5 < styles.content.editPanelPage\r\n  c.10 < styles.insertContent\r\n  c.20 < styles.content.lastUpdate\r\n  c.30 < styles.content.typo3_powered\r\n\r\n\r\n{$comment_textMenu}  tm.10 < styles.tmenu.pagetop\r\n{$comment_textMenu}  tm.TDParams = valign=\"top\"\r\n}\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\nframeset.headerData.999 < plugin.meta\r\n\r\n','Standard-template\r\n\r\nThis template is a frame-based template with a graphical menu (1 level) to the left. \r\nIn the topframe you can place a picture/logo.\r\nContent may be displayed in one column in the page-frame. \r\n\r\n\"styles.gmenu.bug\": menu in the left frame\r\n','');
INSERT INTO `static_template` VALUES (51,0,1054753538,958662553,'styles.tmenu.pagetop','','styles.tmenu.pagetop >\r\nstyles.tmenu.pagetop {\r\n    # cat=menu-2; type=int[0-5]; label=Advanced, entry level: This number defines which level in the pagetree is reflected as the first level in the menu. When this number is 1 (one), the menu will display pages on the second level in the pagetree.\r\n  entryLevel = 1\r\n    # cat=menu-2/typo; type=wrap; label=Wrap, items: This HTML-code is wrapped around every single menu item.\r\n  fontWrap =\r\n    # cat=menu-2/typo; type=wrap; label=Wrap, active items: This HTML-code is wrapped around the \"active\" menu item, if any.\r\n  ACT.fontWrap =\r\n    # cat=menu-2/; type=wrap; label=Wrap, whole menu: This HTML-code is finally wrapped around all the elements (the whole menu)\r\n  wrap =\r\n    # cat=menu-2/links; type=small; label=Target: Enter the link target for the menu. If your site is using frames, \"page\" would probably be correct. If not, leave blank (or \"_top\")\r\n  target = \r\n}\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.menu-2 {\r\n  header = styles.tmenu.pagetop\r\n  description = This is a little, simple menu of text-links. It\'s designed to be included in the top of pages thus working as a level-2 menu.\r\n  image = gfx/BUG_menu2.gif\r\n  1=styles.tmenu.pagetop.fontWrap\r\n  2=styles.tmenu.pagetop.ACT.fontWrap\r\n}\r\n\r\n','styles.tmenu.pagetop >\r\nstyles.tmenu.pagetop = HMENU\r\nstyles.tmenu.pagetop.stdWrap.required = 1\r\nstyles.tmenu.pagetop.stdWrap.wrap = {$styles.tmenu.pagetop.wrap}\r\nstyles.tmenu.pagetop.entryLevel = {$styles.tmenu.pagetop.entryLevel}\r\nstyles.tmenu.pagetop.1 = TMENU\r\nstyles.tmenu.pagetop.1 {\r\n  target = {$styles.tmenu.pagetop.target}\r\n  NO.afterImg = media/bullets/dots2.gif |*||*| _\r\n  NO.afterImgTagParams = hspace=\"4\"\r\n  NO.linkWrap = {$styles.tmenu.pagetop.fontWrap}\r\n  NO.ATagBeforeWrap = 1\r\n\r\n  ACT < .NO\r\n  ACT = 1\r\n  ACT.linkWrap = {$styles.tmenu.pagetop.ACT.fontWrap}\r\n}\r\n\r\n','Textmenu\r\n\r\nThis is a simple horizontal level-2 textmenu that\'s used in the top of pages.\r\n\r\nUsed with template BUG (in pageframe)','');
INSERT INTO `static_template` VALUES (42,0,1054753473,955318074,'styles.img.logo','','styles.img.logo >\r\nstyles.img.logo {\r\n    # cat=logo/dims; type=int[1-1000]; label=Pixeldimensions, X: Pixeldimensions of topframe image (pixels)\r\n  X = 625\r\n    # cat=logo/dims; type=int[1-300]; label=Pixeldimensions, Y: Pixeldimensions of topframe image (pixels)\r\n  Y = 92\r\n\r\n    # cat=logo/color; type=color; label=Image background color\r\n  bgCol = #CBB99C\r\n    # cat=logo/color; type=color; label=Logo color\r\n  logoCol = #165D89\r\n    # cat=logo/color; type=color; label=Image border color: Color of the image-border\r\n  boxColor = black\r\n\r\n    # cat=logo/dims; type=int[0-20]; label=Thickness of border\r\n  boxThickness = 2\r\n\r\n    # cat=logo/dims; type=offset; label=Logo offset: Offset of logo from upper-left corner of the image.\r\n  logoOffset = 10,5\r\n\r\n    # cat=logo; type=options[gif,jpg]; label=Image file format\r\n  format = gif\r\n\r\n    # cat=logo/file; type=file[IMAGE_EXT]; label=Imagefile\r\n  file.image = media/uploads/topimage.jpg\r\n    # cat=logo/file; type=file[IMAGE_EXT]; label=Imagefile Mask; Grayscale mask used to mask the Imagefile onto the colored background of the image. White areas make the image visible, dark areas hide the image.\r\n  file.mask = media/uploads/topmask.jpg\r\n    # cat=logo/file; type=file[IMAGE_EXT]; label=Imagefile, Logo mask: Grayscale mask used to impose the logo-colors onto the image. NOTE: The mask is inverted here!: DARK areas make the color visible, WHITE areas hide the color.\r\n  file.logo = media/uploads/toplogo.jpg\r\n}\r\n\r\n\r\n','styles.img.logo >\r\nstyles.img.logo = GIFBUILDER\r\nstyles.img.logo {\r\n  XY = {$styles.img.logo.X},{$styles.img.logo.Y}\r\n  format = {$styles.img.logo.format}\r\n  quality = 85\r\n  reduceColors = 65\r\n  backColor = {$styles.img.logo.bgCol}\r\n  10 = IMAGE\r\n  10.file = {$styles.img.logo.file.image}\r\n  10.mask = {$styles.img.logo.file.mask}\r\n\r\n  20 = IMAGE\r\n  20.file = GIFBUILDER\r\n  20.file {\r\n    XY = {$styles.img.logo.X},{$styles.img.logo.Y}\r\n    backColor = {$styles.img.logo.logoCol}\r\n  }\r\n  20.mask = GIFBUILDER\r\n  20.mask {\r\n    XY = {$styles.img.logo.X},{$styles.img.logo.Y}\r\n    backColor = white\r\n    10 = IMAGE\r\n    10.file = {$styles.img.logo.file.logo}\r\n    10.offset = {$styles.img.logo.logoOffset}\r\n    20 = EFFECT\r\n    20.value = invert\r\n  }\r\n\r\n  100 = BOX\r\n  100.dimensions = 0,0,{$styles.img.logo.X},{$styles.img.logo.boxThickness}\r\n  100.color = {$styles.img.logo.boxColor}\r\n  110 < .100\r\n  110.align = ,b \r\n \r\n  120 = BOX\r\n  120.dimensions = 0,0,{$styles.img.logo.boxThickness},{$styles.img.logo.Y}\r\n  120.color = {$styles.img.logo.boxColor}\r\n  130 < .120\r\n  130.align = r\r\n}\r\n\r\n\r\n\r\n\r\n','imgResource (using GIFBUILDER)\r\nThe images has a background color onto which \"image\" is overlayed through \"mask\". On top of this some color is masked by \"logo\"\r\n','');
INSERT INTO `static_template` VALUES (43,0,1071668142,955393897,'content (default)','45,46,44','  # cat=advanced/enable; type=boolean; label=Render content RTE compliant?: When this is set, the content will be rendered with each line wrapped in <p>-tags regardless of using stylesheets or not. This is necessary in order to make the content compliant with the Rich Text Editors align-ment functions.\r\ncontent.RTE_compliant = 1\r\ncontent.RTE_compliant.mode = fontwrap\r\n\r\ncontent {\r\n    # cat=content/cHeader/h0; type=int[1-5]; label=Default Header type: Enter the number of the header layout to be used by default. \r\n  defaultHeaderType = 1\r\n    # cat=content/cHeader/a; type=wrap; label=Header wrap: This is the wrap around the headers regardless of individual wraps.\r\n  wrap.header = |<br />\r\n    # cat=content/cHeader/h1; type=wrap; label=Header \"Layout1\" \r\n  wrap.header1 = <font face=\"verdana\" size=\"3\"><b> | </b></font>\r\n    # cat=content/cHeader/h2; type=wrap; label=Header \"Layout2\"\r\n  wrap.header2 = <font face=\"verdana\" size=\"2\" color=\"red\"><b> | </b></font>\r\n    # cat=content/cHeader/h3; type=wrap; label=Header \"Layout3\"\r\n  wrap.header3 = <font face=\"verdana\" size=\"4\"><b> | </b></font>\r\n    # cat=content/cHeader/h4; type=wrap; label=Header \"Layout4\"\r\n  wrap.header4 = <font face=\"verdana\" size=\"5\"><b> | </b></font>\r\n\r\n  case.header1 = \r\n  case.header2 = \r\n\r\n  wrap2.header1 = \r\n  wrap2.header2 = \r\n  wrap2.header3 = \r\n\r\n    # cat=content/cHeader/x; type=wrap; label=Headerdate: The optional date shown above the header\r\n  wrap.headerDate = <font face=\"verdana\" size=\"1\">|:</font><br />\r\n\r\n    # cat=content/cHeader/s0; type=int[1-3]; label=Default Subheader type: Enter the number of the subheader layout to be used by default.\r\n  defaultSubHeaderType = 3\r\n    # cat=content/cHeader/s1; type=wrap; label=Subheader \"Layout 1\"\r\n  wrap.subheader1 = <font face=\"verdana\" size=\"2\"> | </font>\r\n    # cat=content/cHeader/s2; type=wrap; label=Subheader \"Layout 2\"\r\n  wrap.subheader2 = <font face=\"verdana\" size=\"1\"><b> | </b></font>\r\n    # cat=content/cHeader/s3; type=wrap; label=Subheader \"Layout 3\"\r\n  wrap.subheader3 = <font face=\"verdana\" size=\"1\" color=\"navy\"><b> | </b></font>\r\n\r\n    # cat=content/cBullets; type=; label=Bulletlist \"Layout 2\"\r\n  bulletImages.2 = <img src=\"media/bullets/mark.gif\" vspace=\"2\" hspace=\"2\" border=\"0\" alt=\"\" />\r\n    # cat=content/cBullets; type=; label=Bulletlist \"Layout 3\"\r\n  bulletImages.3 = <img src=\"media/bullets/bullet1_n.gif\" vspace=\"2\" hspace=\"2\" border=\"0\" alt=\"\" />\r\n\r\n  headerSpace = 0|5\r\n  space = 0|10\r\n\r\n    # cat=content/cText/b; type=wrap; label=Bodytext wrap: This is the wrap around the whole bodytext part of a content element\r\n  wrap.bodytext = |<br />\r\n    # cat=content/cText/a; type=small; label=Bodytext linebreak: This is the tag used for linebreaks at the end of every paragraph in the bodytext.\r\n  break.bodytext = <br />\r\n    # An alternative body text linebreak code, because this will substitue nl-chars ONLY in the plain bodytext whereas the above will substituted it in all content including the returned content from any typo-tags.\r\n  break.bodytext_parseFunc = \r\n\r\n    # cat=content/cTable; type=color; label=Tables Cellcolor: The color of the tablecells of ordinary tables\r\n  tableCellColor = silver\r\n  tableCellWrap = \r\n    # cat=content/cSplash; type=color; label=\"Textbox\" Background color: This is the background color of the graphical elements in the \"Textbox\" content element. Normally set this to the color of the page background\r\n  splash.bgCol = white\r\n    # cat=content/cMenu; type=wrap; label=\"Menu\" content element: Elementwrap for the items in the content element type \"Menu\"\r\n  menuWrap = <b> | </b>\r\n    # cat=content/cMenu; type=wrap; label=\"Menu\" content element, sub: Elementwrap for the subitems in the content element type \"Menu\". Used by the links to page-sections.\r\n  subMenuWrap = <b> | </b>\r\n  menuAllWrap = <b> | </b><br />\r\n  menuATagBeforeWrap = 1\r\n\r\n    # cat=content/language; type=; label=\"To top\" Link: HTML-code used to create a link to the top of the page, if that is enabled for a content element\r\n  linkToTop = <a href=\"#top\">To top</a><br />\r\n\r\n    # cat=advanced/links; type=small; label=Pageframe object: The name of the \"contentframe\". Normally set to \"page\" if the site has a frameset. Otherwise it should be an empty value. This is important, as it determines the target of internal links!\r\n  pageFrameObj = page\r\n\r\n  shortcut.tables = tt_content,tt_address,tt_links,tt_guest,tt_board,tt_calender,tt_products,tt_news,tt_rating,tt_poll\r\n}\r\n\r\n\r\n','#\r\n# Object preserved from unsetting after template parsing\r\n# These are meant for referencing\r\n#\r\n\r\nlib.stdheader = COA\r\nlib.stdheader {\r\n  stdWrap.wrapAlign.field = header_position\r\n  stdWrap.typolink.parameter.field = header_link\r\n  stdWrap.fieldRequired = header\r\n  stdWrap.editIcons = tt_content : header, [header_layout | header_position], [header_link|date]\r\n  stdWrap.editIcons.beforeLastTag=1\r\n  stdWrap.editIcons.iconTitle=Edit header\r\n\r\n  stdWrap.if {\r\n    equals.field = header_layout\r\n    value = 100\r\n    negate = 1\r\n  }\r\n\r\n  5 = TEXT\r\n  5.field = date\r\n  5.if.isTrue.field = date\r\n  5.date = d/m Y\r\n  5.wrap = {$content.wrap.headerDate}\r\n  \r\n  10 = CASE\r\n  10.setCurrent {\r\n    field = header\r\n    parseFunc < styles.content.parseFunc\r\n    parseFunc.if.value = 5\r\n    parseFunc.if.equals {\r\n      field = header_layout\r\n      ifEmpty = {$content.defaultHeaderType}\r\n      ifEmpty.override.data = register: defaultHeaderType\r\n    }\r\n    parseFunc.if.negate = 1\r\n  }\r\n  10.key.field = header_layout\r\n  10.key.ifEmpty = {$content.defaultHeaderType}\r\n  10.key.ifEmpty.override.data = register: defaultHeaderType\r\n  10.stdWrap.wrap = {$content.wrap.header}\r\n\r\n  10.1 = TEXT\r\n  10.1.current = 1\r\n  10.1.fontTag = {$content.wrap.header1}\r\n  10.1.case = {$content.case.header1}\r\n  10.1.wrap2 = {$content.wrap2.header1}\r\n\r\n  10.2 = TEXT\r\n  10.2.current = 1\r\n  10.2.fontTag = {$content.wrap.header2}\r\n  10.2.case = {$content.case.header2}\r\n  10.2.wrap2 = {$content.wrap2.header2}\r\n\r\n  10.3 = TEXT\r\n  10.3.current = 1\r\n  10.3.fontTag = {$content.wrap.header3}\r\n  10.3.wrap2 = {$content.wrap2.header3}\r\n\r\n  10.4 = TEXT\r\n  10.4.current = 1\r\n  10.4.fontTag = {$content.wrap.header4}\r\n\r\n  10.5 < styles.header.gfx1\r\n\r\n  stdWrap.space = {$content.headerSpace}\r\n}\r\n\r\n# \r\n# Configuring of language for backwards compatibility\r\n# \r\n{$comment_DK} config.language = dk\r\n\r\n\r\n\r\n#\r\n# tt_content is started\r\n# \r\ntt_content >\r\ntt_content = CASE\r\ntt_content.stdWrap {\r\n  spaceBefore.field = spaceBefore\r\n  spaceAfter.field = spaceAfter\r\n  space = {$content.space}\r\n  innerWrap.cObject < styles.content.frames\r\n  innerWrap2 = | {$content.linkToTop}\r\n  innerWrap2.fieldRequired = linkToTop\r\n  dataWrap = <a name=\"{field:uid}\"></a>\r\n  editPanel = 1\r\n  editPanel {\r\n    allow = move,new,edit,hide,delete\r\n    line=5\r\n    label = %s\r\n    onlyCurrentPid = 1\r\n    previewBorder=4\r\n    edit.displayRecord = 1\r\n  }\r\n}\r\ntt_content.key.field = CType\r\n\r\n\r\n# CType: header\r\ntt_content.header = COA\r\ntt_content.header {\r\n  10 = < lib.stdheader\r\n  \r\n  20 = CASE\r\n  20.stdWrap.fieldRequired = subheader\r\n  20.stdWrap.parseFunc < styles.content.parseFunc\r\n  20.key.field = layout\r\n  20.stdWrap.wrap = | <br />\r\n  20.stdWrap.editIcons = tt_content:subheader,layout\r\n  20.stdWrap.editIcons.beforeLastTag=1\r\n  20.stdWrap.editIcons.iconTitle=Edit subheader\r\n\r\n  20.1 = TEXT\r\n  20.1.field = subheader\r\n  20.1.fontTag = {$content.wrap.subheader1}\r\n  20.2 = TEXT\r\n  20.2.field = subheader\r\n  20.2.fontTag = {$content.wrap.subheader2}\r\n  20.3 = TEXT\r\n  20.3.field = subheader\r\n  20.3.fontTag = {$content.wrap.subheader3}\r\n\r\n  20.default < .20.{$content.defaultSubHeaderType}\r\n}\r\n\r\n\r\n\r\n\r\n# CType: bullet\r\ntt_content.bullets = COA\r\ntt_content.bullets {\r\n  10 = < lib.stdheader\r\n  20 = CASE\r\n  20.setCurrent.field = bodytext\r\n  20.key.field = layout\r\n  20 {\r\n    default < styles.content.bulletlist_gr\r\n    1 < styles.content.bulletlist\r\n\r\n    2 < styles.content.bulletlist_gr\r\n    2.split.1.wrap = <tr><td valign=\"top\">{$content.bulletImages.2}</td><td valign=\"top\"> | </td></tr>\r\n\r\n    3 < styles.content.bulletlist_gr\r\n    3.split.1.wrap = <tr><td valign=\"top\">{$content.bulletImages.3}</td><td valign=\"top\"> | </td></tr>\r\n  }\r\n\r\n  20.stdWrap.editIcons = tt_content:layout, bodytext [text_align | text_face | text_size | text_color],[text_properties]\r\n  20.stdWrap.editIcons.beforeLastTag=1\r\n  20.stdWrap.editIcons.iconTitle=Edit bulletlist\r\n}\r\n\r\n\r\n\r\n\r\n# CType: table\r\ntt_content.table = COA\r\ntt_content.table {\r\n  10 = < lib.stdheader\r\n  20 = CASE\r\n  20.setCurrent.field = bodytext\r\n  20.key.field = layout\r\n  20 {\r\n    default < styles.content.table\r\n    1 < styles.content.table\r\n    1.split.1.split.1.wrap = <td valign=\"top\" bgcolor=\"{$content.tableCellColor}\">|</td>\r\n    1.split.1.split.1.innerWrap = {$content.tableCellWrap}\r\n    1.split.1.split.2.wrap = <td valign=\"top\" bgcolor=\"{$content.tableCellColor}\">|</td>\r\n    1.split.1.split.2.innerWrap = {$content.tableCellWrap}\r\n\r\n    2 < styles.content.table\r\n    2.split.1.split.1.wrap = <td valign=\"top\" bgcolor=\"{$content.tableCellColor}\">|</td>\r\n    2.split.1.split.1.innerWrap = {$content.tableCellWrap}\r\n    2.split.2.split.1.wrap = <td valign=\"top\" bgcolor=\"{$content.tableCellColor}\">|</td>\r\n    2.split.2.split.1.innerWrap = {$content.tableCellWrap}\r\n\r\n    3 < .1\r\n    3.split.2.split.1.wrap = <td valign=\"top\" bgcolor=\"{$content.tableCellColor}\">|</td>\r\n    3.split.2.split.1.innerWrap = {$content.tableCellWrap}\r\n  }\r\n\r\n  20.stdWrap.editIcons = tt_content:layout [cols|table_bgColor|table_border|table_cellspacing|table_cellpadding], bodytext [text_align | text_face | text_size | text_color],[text_properties]\r\n  20.stdWrap.editIcons.beforeLastTag=1\r\n  20.stdWrap.editIcons.iconTitle=Edit table\r\n}\r\n\r\n\r\n\r\n# CType: text\r\ntt_content.text = COA\r\ntt_content.text {\r\n  10 = < lib.stdheader\r\n  20 = TEXT\r\n  20 {\r\n#debugFunc = 2\r\n    fieldRequired = bodytext\r\n    wrap = {$content.wrap.bodytext}\r\n    brTag = {$content.break.bodytext}\r\n    field = bodytext\r\n    textStyle < styles.content.textStyle\r\n    parseFunc < styles.content.parseFunc\r\n    parseFunc.nonTypoTagStdWrap.brTag = {$content.break.bodytext_parseFunc}\r\n    editIcons = tt_content:bodytext [text_align | text_face | text_size | text_color],[text_properties], rte_enabled\r\n    editIcons.beforeLastTag=1\r\n    editIcons.iconTitle=Edit bodytext\r\n  }\r\n  20.parseFunc.tags {\r\n    typolist < tt_content.bullets.20\r\n    typolist.stripNL = 1\r\n    typolist {\r\n        // Overriding values:\r\n      key.field >\r\n      key.data = parameters : type\r\n      setCurrent >\r\n      stdWrap.if.isTrue.current = 1\r\n    }\r\n    typohead < lib.stdheader\r\n    typohead.stripNL = 1\r\n    typohead {\r\n      stdWrap.wrapAlign.field >\r\n      stdWrap.wrapAlign.data = parameters : align\r\n      stdWrap.typolink.parameter.field >\r\n      stdWrap.typolink.parameter.data = parameters : link\r\n      stdWrap.fieldRequired >\r\n      stdWrap.if >\r\n      stdWrap.if.isTrue.current = 1\r\n      stdWrap.wrap = <br /> |\r\n      stdWrap.editIcons >\r\n      10.key.field >\r\n      10.key.data = parameters : type\r\n      10.setCurrent.field >\r\n      10.setCurrent.current = 1\r\n    }\r\n    typocode = TEXT\r\n    typocode.current = 1\r\n    typocode.htmlSpecialChars = 1\r\n    typocode.br = 1\r\n  }\r\n}\r\n\r\n# Configures the content for compliancy with the RTE\r\n[globalVar=LIT:0<{$content.RTE_compliant}]\r\n  # Make sure nonTypoTagStdWrap operates on content outside <typolist> and <typohead> only:\r\n  tt_content.text.20.parseFunc.tags {\r\n    typolist.breakoutTypoTagContent = 1\r\n    typohead.breakoutTypoTagContent = 1\r\n    typohead.stdWrap.wrap >\r\n  }\r\n\r\n  # Processing <table> and <blockquote> blocks separately\r\n  tt_content.text.20.parseFunc.externalBlocks = table, blockquote\r\n  tt_content.text.20.parseFunc.externalBlocks {\r\n      # The blockquote content is passed into parseFunc again...\r\n    blockquote.callRecursive=1\r\n    blockquote.callRecursive.tagStdWrap.HTMLparser = 1\r\n    blockquote.callRecursive.tagStdWrap.HTMLparser.tags.blockquote.overrideAttribs = style=\"margin-bottom:0;margin-top:0;\"\r\n    blockquote.stripNL=1\r\n    table.stripNL=1\r\n    table.HTMLtableCells=1\r\n    table.HTMLtableCells {\r\n      default.callRecursive=1\r\n      addChr10BetweenParagraphs=1\r\n    }\r\n  }\r\n\r\n    # Setting up nonTypoTagStdWrap to wrap the text with P-tags\r\n  tt_content.text.20.parseFunc.nonTypoTagStdWrap >\r\n  tt_content.text.20.parseFunc.nonTypoTagStdWrap.encapsLines < styles.content.RTE_encaps_{$content.RTE_compliant.mode}\r\n\r\n    # finally removing the old textstyle formatting on the whole bodytext part.\r\n  tt_content.text.20.textStyle >\r\n  tt_content.text.20.wrap >\r\n  tt_content.text.20.brTag >\r\n[global]\r\n\r\n\r\n\r\n# CType: image\r\ntt_content.image = COA\r\ntt_content.image {\r\n  10 = < lib.stdheader\r\n  20  < styles.content.imgtext\r\n}\r\n\r\n\r\n\r\n\r\n# CType: textpic\r\ntt_content.textpic = COA\r\ntt_content.textpic {\r\n  10 = COA  \r\n  10.if.value = 25\r\n  10.if.isLessThan.field = imageorient\r\n  10.10 = < lib.stdheader\r\n    \r\n  20  < styles.content.imgtext\r\n  20.text.10 = COA\r\n  20.text.10 {\r\n    if.value = 24\r\n    if.isGreaterThan.field = imageorient\r\n    10 = < lib.stdheader\r\n  }\r\n  20.text.20 = < tt_content.text.20\r\n}\r\n\r\n\r\n# CType: rte\r\ntt_content.rte = COA\r\ntt_content.rte {\r\n  10 = < lib.stdheader\r\n  20 = TEXT\r\n  20.field = bodytext\r\n\r\n  20.editIcons = tt_content:bodytext\r\n  20.editIcons.beforeLastTag=1\r\n  20.editIcons.iconTitle=Edit Rich Text content\r\n}\r\n\r\n\r\n# CType: uploads\r\ntt_content.uploads = COA\r\ntt_content.uploads {\r\n  10 = < lib.stdheader\r\n  20 = CASE\r\n  20 {\r\n    setCurrent.field = media\r\n    key.field = layout\r\n    default < styles.content.uploads\r\n    1 < styles.content.uploads_icons\r\n    2 < styles.content.uploads_imgicons\r\n    3 < styles.content.uploads_imgicons\r\n    3.split.1.filelink.icon.wrap >\r\n  }\r\n\r\n  20.stdWrap.editIcons = tt_content:media, layout [table_bgColor|table_border|table_cellspacing|table_cellpadding],filelink_size,imagecaption\r\n  20.stdWrap.editIcons.iconTitle=Edit filelist\r\n}\r\n\r\n\r\n\r\n\r\n# CType: menu\r\ntt_content.menu = COA\r\ntt_content.menu {\r\n  10 = < lib.stdheader\r\n  20 = CASE\r\n  20 {\r\n    key.field = menu_type\r\n\r\n    default = HMENU\r\n    default {\r\n      special = list\r\n      special.value.field = pages\r\n      1 = TMENU\r\n      1.NO.linkWrap =  {$content.menuWrap}\r\n      1.NO.allWrap = {$content.menuAllWrap}\r\n      1.NO.ATagBeforeWrap = {$content.menuATagBeforeWrap}\r\n      1.target = {$content.pageFrameObj}\r\n    }\r\n\r\n    1 < .default\r\n    1.special = directory\r\n\r\n    2 < styles.sitemap.text\r\n\r\n    3 < styles.insertContent\r\n    3.select.andWhere = sectionIndex!=0\r\n    3.select.pidInList.override.field = pages\r\n    3.renderObj = TEXT\r\n    3.renderObj {\r\n      fieldRequired = header\r\n      trim=1\r\n      field = header\r\n      wrap = {$content.menuWrap}\r\n      typolink.parameter.field = pid\r\n      typolink.section.field = uid\r\n      wrap2 = |<br />\r\n    }\r\n\r\n    4 < .1\r\n    4.1.NO {\r\n      after.data = field : abstract // field : description // field : subtitle\r\n      after.htmlSpecialChars = 1\r\n      afterWrap = <br />{$content.subMenuWrap}\r\n    }\r\n\r\n    5 < .default\r\n    5.special = updated\r\n    5.special {\r\n      maxAge = 3600*24*7\r\n      excludeNoSearchPages = 1\r\n    }\r\n\r\n    6 < .default\r\n    6.special = keywords\r\n    6.special {\r\n      excludeNoSearchPages = 1\r\n    }\r\n\r\n    7 < .1\r\n    7.1.expAll = 1\r\n    7.1.wrap = |<br />\r\n    7.2 < .7.1\r\n    7.2.sectionIndex = 1\r\n    7.2.sectionIndex.type = header\r\n    7.2.NO.linkWrap =  {$content.subMenuWrap}\r\n  }\r\n\r\n  20.stdWrap.editIcons = tt_content: menu_type,pages\r\n  20.stdWrap.editIcons.iconTitle=Edit linkmenu\r\n}\r\n\r\n\r\n\r\n\r\n# CType: shortcut\r\ntt_content.shortcut = COA\r\ntt_content.shortcut {\r\n#  10 = < lib.stdheader\r\n  20 = CASE\r\n  20.key.field = layout\r\n  20.0= RECORDS\r\n  20.0 {\r\n    source.field = records\r\n    tables = {$content.shortcut.tables}\r\n    conf.tt_content = < tt_content\r\n    conf.tt_address = < tt_address\r\n    conf.tt_links = < tt_links\r\n    conf.tt_guest = < tt_guest\r\n    conf.tt_board = < tt_board\r\n    conf.tt_calender = < tt_calender\r\n    conf.tt_rating < tt_rating\r\n    conf.tt_products = < tt_products\r\n    conf.tt_news = < tt_news\r\n    conf.tt_poll = < plugin.tt_poll\r\n  }\r\n  20.1= RECORDS\r\n  20.1 {\r\n    source.field = records\r\n    tables = {$content.shortcut.tables}\r\n    conf.tt_poll = < plugin.tt_poll\r\n    conf.tt_poll.code = RESULT,SUBMITTEDVOTE\r\n  }\r\n\r\n  20.stdWrap.editIcons = tt_content: records\r\n  20.stdWrap.editIcons.iconTitle=Edit recordlist\r\n}\r\n\r\n\r\n\r\n\r\n# CType: list\r\n# The keys for the CASE-cObject is supplied by including static_templates which is configured to fill out these positions. Examples are \"content.tt_products\" and \"content.tt_calendar\"\r\ntt_content.list = COA\r\ntt_content.list.10 = < lib.stdheader\r\ntt_content.list.20 = CASE\r\ntt_content.list.20.key.field = list_type\r\ntt_content.list.20 {\r\n  # LIST element references (NOT copy of objects!)\r\n  3 = CASE\r\n  3.key.field = layout\r\n  3.0 = < plugin.tt_guest\r\n\r\n  4 = CASE\r\n  4.key.field = layout\r\n  4.0 = < plugin.tt_board_list\r\n  4.1 = < plugin.tt_board_tree\r\n\r\n  2 = CASE\r\n  2.key.field = layout\r\n  2.0 = < plugin.tt_board_tree\r\n\r\n  5 = CASE\r\n  5.key.field = layout\r\n  5.0 = < plugin.tt_products\r\n\r\n  7 = CASE\r\n  7.key.field = layout\r\n  7.0 = < plugin.tt_calender\r\n\r\n  8 = CASE\r\n  8.key.field = layout\r\n  8.0 = < plugin.tt_rating\r\n\r\n  9 = CASE\r\n  9.key.field = layout\r\n  9.0 = < plugin.tt_news\r\n\r\n  11 = CASE\r\n  11.key.field = layout\r\n  11.0 = < plugin.tipafriend\r\n\r\n  20 = CASE\r\n  20.key.field = layout\r\n  20.0 = < plugin.feadmin.fe_users\r\n\r\n  21 = CASE\r\n  21.key.field = layout\r\n  21.0 = < plugin.feadmin.dmailsubscription\r\n}\r\ntt_content.list {\r\n  20.stdWrap.editIcons = tt_content: list_type, layout, select_key, pages [recursive]\r\n  20.stdWrap.editIcons.iconTitle=Edit recordlist\r\n}\r\n\r\n\r\n# CType: multimedia\r\ntt_content.multimedia = COA\r\ntt_content.multimedia {\r\n  10 = < lib.stdheader\r\n  20 = MULTIMEDIA\r\n  20.file.field = multimedia\r\n  20.file.wrap = uploads/media/\r\n  20.file.listNum = 0\r\n  20.params.field = bodytext\r\n}\r\n\r\n\r\n\r\n\r\n# CType: splash\r\ntt_content.splash = CASE\r\ntt_content.splash.key.field = splash_layout\r\n\r\ntt_content.splash.default = COA\r\ntt_content.splash.default {\r\n  20 = CTABLE\r\n  20 {\r\n    c.1 = < tt_content.text\r\n    lm.1 = IMAGE\r\n    lm.1.file {\r\n      import = uploads/pics/\r\n      import.field = image\r\n      import.listNum = 0\r\n      maxW.field = imagewidth\r\n      maxW.ifEmpty = 200\r\n    }\r\n    cMargins = 30,0,0,0\r\n  }\r\n}\r\ntt_content.splash.1 < tt_content.splash.default\r\ntt_content.splash.1.20.lm.1.file >\r\ntt_content.splash.1.20.lm.1.file = GIFBUILDER\r\ntt_content.splash.1.20.lm.1.file {\r\n  XY = [10.w]+10,[10.h]+10\r\n  backColor = {$content.splash.bgCol}\r\n  backColor.override.data = register:pageColor\r\n  format = jpg\r\n  5 = BOX\r\n  5.dimensions = 3,3,[10.w],[10.h]\r\n  5.color = #333333\r\n  7 = EFFECT\r\n  7.value = blur=99|blur=99|blur=99|blur=99|blur=99|blur=99|blur=99\r\n  10 = IMAGE\r\n  10.file {\r\n    import = uploads/pics/\r\n    import.field = image\r\n    import.listNum = 0\r\n    maxW.field = imagewidth\r\n    maxW.ifEmpty = 200\r\n  }\r\n}\r\ntt_content.splash.2 < tt_content.splash.default\r\ntt_content.splash.2.20.lm.1.file.m < styles.content.imgFrames.1\r\ntt_content.splash.3 < tt_content.splash.default\r\ntt_content.splash.3.20.lm.1.file.m < styles.content.imgFrames.2\r\n  // From plugin.postit1, if included:\r\ntt_content.splash.20 = < plugin.postit1\r\n\r\n# CType: mailform\r\ntt_content.mailform = COA\r\ntt_content.mailform {\r\n  10 = < lib.stdheader\r\n  20 < styles.content.mailform\r\n\r\n  20.stdWrap.editIcons = tt_content: bodytext,pages,subheader\r\n  20.stdWrap.editIcons.iconTitle=Edit multimedia element\r\n}\r\n\r\n\r\n\r\n\r\n# CType: search\r\ntt_content.search = COA\r\ntt_content.search {\r\n  10 = < lib.stdheader\r\n  20 < styles.content.searchresult\r\n  30 < styles.content.searchform\r\n\r\n  30.stdWrap.editIcons = tt_content: pages\r\n  30.stdWrap.editIcons.iconTitle=Edit search element\r\n}\r\n\r\n\r\n\r\n\r\n# CType: login\r\ntt_content.login = COA\r\ntt_content.login {\r\n  10 = < lib.stdheader\r\n  20 < styles.content.loginform\r\n\r\n  20.stdWrap.editIcons = tt_content: pages\r\n  20.stdWrap.editIcons.iconTitle=Edit login element\r\n}\r\n\r\n\r\n\r\n\r\n# CType: html\r\ntt_content.html = TEXT\r\ntt_content.html.field = bodytext\r\ntt_content.html.editIcons = tt_content: pages\r\ntt_content.html.editIcons.iconTitle=Edit pure HTML content\r\n\r\n# CType: script\r\ntt_content.script = TEXT\r\ntt_content.script.value =\r\n\r\n# CType: script\r\ntt_content.div = TEXT\r\ntt_content.div.value =\r\n\r\n# Default error msg:\r\ntt_content.default = TEXT\r\ntt_content.default.field = CType\r\ntt_content.default.wrap = <b>CTYPE \"|\" not defined! </b>\r\n\r\n\r\n','Content-rendering:\r\n\r\nContains configuration for default content-rendering for the table \"tt_content\"\r\nIs included by the standard-templates. \r\nNotice this template includes other static templates, especially \"styles.content (default)\"\r\n\r\nStatus:\r\nChanged 28-06-2000','\r\n# Setting up the CSS Editor\r\nCSS_editor = Template Styles\r\nCSS_editor.ch {\r\n  BODY = General\r\n  BODY.selector = BODY\r\n  BODY.attribs = font-family, background-color\r\n  BODY.example = Plan text outside of any tags written in the page-body.\r\n\r\n  A = Links\r\n  A.selector = A\r\n  A.attribs = LINKS,font-weight\r\n  A.example = This is <A href=\"#\">a link to</A> the page top.\r\n  A.exampleStop=1\r\n  A.ch {\r\n	hover = Mouseover links\r\n	hover.selector = + :hover\r\n	hover.attribs = LINKS\r\n\r\n	active = Active links\r\n	active.selector = + :active\r\n	active.attribs = LINKS\r\n\r\n	visited = Visited links\r\n	visited.selector = + :visited\r\n	visited.attribs = LINKS\r\n  }\r\n  \r\n  content = < tt_content.CSS_editor\r\n}\r\ntt_content.CSS_editor = General content\r\ntt_content.CSS_editor {\r\n	title.dk = Generelt Indhold\r\n}');
INSERT INTO `static_template` VALUES (44,0,1054753381,955394546,'styles.header.gfx1','','styles.header.gfx1 >\r\nstyles.header.gfx1 {\r\n    # cat=content/cHeader_g/h5; type=color; label=Header \"Layout5\", Backgr. color: Color of the background of the header-items. This should be the same as the page background color.\r\n  bgCol = white\r\n\r\n    # cat=content/cHeader_g/h5; type=file[ttf]; label=Header \"Layout5\", Font file: TrueType (ttf) font\r\n  file.fontFile = \r\n    # cat=content/cHeader_g/h5; type=int[1-40]; label=Header \"Layout5\", Font size: Font size of the TrueType font\r\n  fontSize = 20\r\n    # cat=content/cHeader_g/h5; type=color; label=Header \"Layout5\", Font color: Font color of the TrueType font\r\n  fontColor = black\r\n    # cat=content/cHeader_g/h5; type=offset; label=Header \"Layout5\", Font offset: Enter the offset of the text from the upper-left corner on the header items\r\n  fontOffset = 2,20\r\n    # cat=content/cHeader_g/h5; type=boolean; label=Header \"Layout5\", Nicetext: If the text is jagged on the edges, you may try to eliminate it with this option. But it will also slow down the rendering process.\r\n  niceText = \r\n\r\n    # cat=content/cHeader_g/h5; type=int[1-200]; label=Header \"Layout5\", height: Height (pixels) of the header-items\r\n  itemH = 30\r\n    # cat=content/cHeader_g/h5; type=int+; label=Header \"Layout5\", Max width: Maximum width (pixels) of the header-items. Use this to ensure that the headers will never get wider than your page design for the content allows. Use the same value as for \"Max Image Width\".\r\n  maxWidth = \r\n    # cat=content/cHeader_g/h5; type=int+; label=Header \"Layout5\", Max chars: Maximum number of text characters allowed in the header items. Use this as a way to limit the physical width of the headers. Similar in concept to \".maxWidth\" \r\n  maxChars = 35\r\n\r\n    # cat=content/cHeader_g/h5; type=int[1-256]; label=Header \"Layout5\", Reduce colors: Number of indexed colors on header items. If your headers end up with weird colors, you can try to enter a higher number of colors. But the graphics-files will also increase their filesize.\r\n  reduceColors = 16\r\n    # cat=content/cHeader_g/h5; type=wrap; label=Header \"Layout5\", Wrap: Wrap HTML-code for the header item\r\n  wrap = \r\n}\r\n\r\n','styles.header.gfx1 >\r\nstyles.header.gfx1 = IMAGE\r\nstyles.header.gfx1 {\r\n  wrap = {$styles.header.gfx1.wrap}\r\n  alttext.current = 1\r\n  file = GIFBUILDER\r\n  file {\r\n    XY = [10.w]+10 ,{$styles.header.gfx1.itemH}\r\n    maxWidth = {$styles.header.gfx1.maxWidth}\r\n    backColor = {$styles.header.gfx1.bgCol}\r\n    reduceColors = {$styles.header.gfx1.reduceColors}\r\n    10 = TEXT\r\n    10 {\r\n      text.current = 1\r\n      text.crop = {$styles.header.gfx1.maxChars}\r\n      fontSize = {$styles.header.gfx1.fontSize}\r\n      fontFile = {$styles.header.gfx1.file.fontFile}\r\n      fontColor = {$styles.header.gfx1.fontColor}\r\n      offset = {$styles.header.gfx1.fontOffset}\r\n      niceText = {$styles.header.gfx1.niceText}\r\n    }\r\n  }\r\n}\r\n','Header graphics.\r\n\r\nUsed as Header Layout 5 in the \"content (default)\" template','');
INSERT INTO `static_template` VALUES (45,0,1093529300,955520868,'styles.content (default)','','  # Clear out any constants in this reserved room!\r\nstyles.content >\r\n\r\n    # cat=advanced; type=int+; label= News Content PID: If your template has a column with \"news\"-content fetched from another page-id, this is where you enter the id-number of that page!\r\nstyles.content.getNews.newsPid = 0\r\n\r\nstyles.content.lastUpdate {\r\n  format = H:i d/m Y\r\n    # cat=page//lastupdate; type=; label= Label for \"Last update\": Last update is shown in the bottom of the page if the \"Last update\" date entry is set for the page record.\r\n  label = Last update:\r\n    # cat=page//lastupdate; type=wrap; label= Wrap for \"Last update\"\r\n  wrap = <br /><font size=\"1\" face=\"arial,helvetica\">|</font><br />\r\n    # cat=page//lastupdate; type=comment; label= Automatic \"Last update\": Click this option, if you want to automatically show \"Last update\" on the page.\r\n  comment_auto = #\r\n}\r\n\r\nstyles.content.typo3_powered {\r\n    #cat=advanced; type=options[,1,2]; label=\"TYPO3 Powered By\" Logo: Select which - if any - TYPO3 logo will be displayed in the bottom of the page.\r\n  number = 2\r\n}\r\n\r\nstyles.content.textStyle {\r\n    # cat=content/cText/f1; type=small; label= Bodytext font\r\n  face = \r\n    # cat=content/cText/f2; type=int[1-5]; label= Bodytext size\r\n  size = \r\n    # cat=content/cText/f3; type=color; label= Bodytext color\r\n  color = \r\n  color1 =\r\n  color2 =\r\n  properties =\r\n    # cat=content/cText/f4; type=wrap; label= Alternative wrap: This could be used to wrap the bodytext in <div>-tags if you would like to use a stylesheet instead\r\n  altWrap =\r\n}\r\nstyles.content.tableStyle {\r\n    # cat=content/cTable; type=color; label= Tables background color\r\n  color = \r\n  color1 =\r\n  color2 =\r\n  alignField =\r\n}\r\nstyles.content {\r\n    # cat=content/cTable; type=wrap; label= Alternative wrap: This could be used to wrap the table content in <div>-tags if you would like to use a stylesheet instead\r\n  table.altWrap =\r\n    # cat=content/cBullets; type=wrap; label= Alternative wrap: This could be used to wrap the bullet list items in <div>-tags if you would like to use a stylesheet instead\r\n  bulletlist.altWrap =\r\n}\r\n\r\nstyles.content.links {\r\n  keep = path\r\n    # cat=content/links; type=small; label= Target for external links\r\n  extTarget = _blank\r\n  target = {$PAGE_TARGET}\r\n    # cat=content/links; type=wrap; label= Wrap for links in text\r\n  wrap = \r\n  allowTags = b,i,u,a,img,br,div,center,pre,font,hr,sub,sup,p,strong,em,li,ul,ol,blockquote,strike,span\r\n    # cat=content/cSearch; type=wrap; label= Searchwords markup: Wrap for markup of search-words in text upon a search.\r\n  sword = <font color=\"red\"><b>|</b></font>\r\n}\r\nstyles.content.uploads {\r\n  # cat=content/cUploads; type=wrap; label= Wrap: Wrap for content element \"Filelinks\"\r\n  wrap = <b> | </b>\r\n  labelWrap = \r\n  sizeWrap = \r\n  tdWrap = <td> |</td>\r\n  # cat=content/cUploads; type=wrap; label= Wrap, description: Wrap for the description of content element \"Filelinks\". If this is NOT set, the description will not shown up.\r\n  descriptionWrap = \r\n  jumpurl_secure = \r\n  jumpurl_secure_mimeTypes = pdf=application/pdf, doc=application/msword\r\n  jumpurl = \r\n}\r\n\r\nstyles.content.frames {\r\n  ruler.lineColor = black\r\n  ruler.lineThickness = 1\r\n  ruler.before = 10\r\n  ruler.after = 10\r\n  padding = 10\r\n  indent = 30\r\n    # cat=content//; type=color; label= Frame 1 background color: Set the background color of the content element frame \"frame1\".\r\n  1.bgCol = silver\r\n    # cat=content//; type=color; label= Frame 2 background color: Set the background color of the content element frame \"frame2\".\r\n  2.bgCol = silver\r\n    # cat=content//; type=color; label= Frame 2 border color: Set the border color of the content element frame \"frame2\".\r\n  2.borderCol = black\r\n  2.borderThickness = 2\r\n\r\n  33_66cell = <td width=\"33%\"><img src=\"clear.gif\" width=\"1\" height=\"1\" alt=\"\" /></td>\r\n}\r\nstyles.content.imgFrames {\r\n    # cat=advanced; type=color; label= Image Frame BgColor: Set the background color of the image frames. Should match the background of the page.\r\n  bgCol = white\r\n  bottomCol = black\r\n    # cat=advanced; type=options[darkroom,artist]; label= Image Frame Collection: Sets which framecollection is used to frame images.\r\n  frameCollection = darkroom\r\n    # cat=advanced; type=comment; label= Image Frame underlay: Set this flag to disable the black frame underlay.\r\n  comment_bottom =\r\n  path = media/frames/\r\n}\r\nstyles.content.imgtext {\r\n    # TIP! if register[maxImageWidth] is set, this will override maxW\r\n    # cat=content,basic/cImage/a_maxw1; type=int+; label= Max Image Width: This indicates that maximum number of pixels (width) a block of images inserted as content is allowed to consume.\r\n  maxW = 600\r\n    # cat=content/cImage/a_maxw2; type=int+; label= Max Image Width (Text): Same as above, but this is the maximum width when text is wrapped around an imageblock. Default is 50% of the normal Max Image Width\r\n  maxWInText =\r\n    # cat=content/cImage/b; type=color; label= Image border color: Bordercolor of images in content elements when \"Border\"-option for element is set.\r\n  borderColor = black\r\n    # cat=content/cImage/b; type=int[0-100]; label= Image border thickness: Thickness of border around images in content elements when \"Border\"-option for element is set.\r\n  borderThick = 2\r\n    # cat=content/cImage/x; type=int[0-100]; label= Advanced, Column space: Horizontal distance between images in a block in content elements of type \"Image\" or \"Text w/Image\".\r\n  colSpace = 10\r\n    # cat=content/cImage/x; type=int[0-100]; label= Advanced, Row space: Vertical distance between images in a block in content elements of type \"Image\" or \"Text w/Image\".\r\n  rowSpace = 10\r\n    # cat=content/cImage/x; type=int[0-100]; label= Advanced, Margin to text: Horizontal distance between an imageblock and text in content elements of type \"Image\" or \"Text w/Image\".\r\n  textMargin = 10\r\n  linkWrap.width = 800m\r\n  linkWrap.height = 600m\r\n  linkWrap.effects = \r\n    # cat=content/cImage/x; type=boolean; label= Advanced, New window: If set, every click-enlarged image will open in it\'s own popup window and not the current popup window (which may have a wrong size for the image to fit in)\r\n  linkWrap.newWindow = 0\r\n    # cat=content/cImage/c; type=wrap; label= Images, caption: Wrap around the caption of imageblocks.\r\n  captionWrap = <font face=\"verdana\" size=\"1\"><b> | </b></font>\r\n    # cat=content/cImage/c; type=boolean; label= Images, caption split: If this is checked, then the image caption will be split by each line and they will appear underneath the corresponding image in the imagelist.\r\n  captionSplit = 0\r\n  target = {$PAGE_TARGET}\r\n  comment_CSL-LinkList = #\r\n}\r\nstyles.content.mailform {\r\n  fieldWrap = \r\n  labelWrap =\r\n  commentWrap =\r\n  radioWrap =\r\n  REQ.labelWrap =\r\n  border = 5\r\n  target = {$PAGE_TARGET}\r\n    # cat=content/cMailform; type=; label= Message, Formmail OK: This is the message (if any) that is popped-up (JavaScript) when a user clicks \"send\" with an email-form\r\n  goodMess =\r\n    # cat=content/cMailform; type=; label= Message, Formmail Missing: This is the message that is popped-up when a user has NOT filled required fields in an email-form\r\n  badMess =\r\n  comment_type2 = #\r\n}\r\nstyles.content.loginform {\r\n  target = _top\r\n    # cat=content/cLogin; type=int+; label= PID of user archive: Enter the page-uid number (PID) of the sysFolder where you keep your fe_users that are supposed to login on this site. This setting is necessary, if login is going to work!\r\n  pid = \r\n    # cat=content/cLogin; type=; label= Message, Login: This is the message (if any) that is popped-up when a user logs in as a front-end user\r\n  goodMess =\r\n}\r\nstyles.content.searchform {\r\n    # cat=content/cSearch; type=; label= Message, Searchform: This is the message (if any) that is popped-up when a user performs a search\r\n  goodMess =\r\n}\r\nstyles.content.columns {\r\n  totalWidth = \r\n  gapWidth = 10\r\n  gapLineThickness = 1\r\n}\r\nstyles.content.searchresult {\r\n  face = Verdana\r\n  size = 1\r\n  color = navy\r\n  head.face = Verdana\r\n  head.size = 2\r\n  head.color = black\r\n  target = {$PAGE_TARGET}\r\n  resultTarget = {$PAGE_TARGET}\r\n  header.wrap = <font face=\"verdana\" size=\"2\"><b> | </b></font>\r\n  header.bgCol = silver\r\n}\r\nstyles.content.meta {\r\n  # cat=page; type=; label= META-tag description: Enter a general description for the site. Will appear on all pages in addition to page-specific descriptions.\r\n  site_description =\r\n  # cat=page; type=; label= META-tag keywords: Enter general keywords for the site. Will appear on all pages in addition to page-specific keywords.\r\n  site_keywords =\r\n}\r\n\r\n  # cat=page/language; type=comment; label= DK language: Set this value to enable Danish labels on Form- and Search-objects. \"\" = Danish, \"#\" = (Default)\r\n  # cat=\r\ncomment_DK = #\r\n\r\n  # cat=advanced/links; type=small; label= Target for internal links: Should match the name of the content PAGE-object in TypoScript when used with frames. Most cases: Set to \"page\" if you have frames in the template. If not, set to \"\" (empty)\r\nPAGE_TARGET = page\r\n\r\n','  # Clear out any constants in this reserved room!\r\nstyles.content >\r\n\r\n  # get content\r\nstyles.content.get = CONTENT\r\nstyles.content.get {\r\n  table = tt_content\r\n  select.orderBy = sorting\r\n  select.where = colPos=0\r\n  select.languageField = sys_language_uid\r\n}\r\n\r\n  # get content, left\r\nstyles.content.getLeft < styles.content.get\r\nstyles.content.getLeft.select.where = colPos=1\r\n\r\n  # get content, right\r\nstyles.content.getRight < styles.content.get\r\nstyles.content.getRight.select.where = colPos=2\r\n\r\n  # get content, margin\r\nstyles.content.getBorder < styles.content.get\r\nstyles.content.getBorder.select.where = colPos=3\r\n\r\n  # get news\r\nstyles.content.getNews < styles.content.get\r\nstyles.content.getNews.select.pidInList = {$styles.content.getNews.newsPid}\r\n\r\n  # std bodyTag. \r\n  # NOTE: These constants inserted are NOT defined in the constants-field of this template!!\r\nstyles.content.bodyTag = <body bgcolor=\"{$bgCol}\" link=\"{$link}\" vlink=\"{$vlink}\" alink=\"{$alink}\">\r\n\r\n  # std metaTag\r\nstyles.content.meta {\r\n  KEYWORDS.data = page: keywords\r\n  KEYWORDS.keywords = 1\r\n  KEYWORDS.wrap = |,{$styles.content.meta.site_keywords}\r\n  KEYWORDS.htmlSpecialChars = 1\r\n  DESCRIPTION.data = page: description\r\n  DESCRIPTION.trim = 1\r\n  DESCRIPTION.wrap = |. {$styles.content.meta.site_description}\r\n  DESCRIPTION.htmlSpecialChars = 1\r\n}\r\n\r\n  # std last updated\r\nstyles.content.lastUpdate = TEXT\r\nstyles.content.lastUpdate {\r\n  data = page:lastUpdated\r\n  if.isTrue.data = page:lastUpdated\r\n  date = {$styles.content.lastUpdate.format}\r\n  wrap = {$styles.content.lastUpdate.label}&nbsp;&nbsp;|\r\n  wrap2 = {$styles.content.lastUpdate.wrap}\r\n  {$styles.content.lastUpdate.comment_auto}  data = register : SYS_LASTCHANGED\r\n  {$styles.content.lastUpdate.comment_auto}  if >\r\n}\r\n\r\n\r\nstyles.content.typo3_credit = TEXT\r\nstyles.content.typo3_credit {\r\n  value = This site is dynamicly generated by TYPO3 CMS - freely available from <a href=\"http://www.typo3.com\" target=\"_blank\">www.typo3.com</a>!\r\n  lang.dk = Dette website er dynamisk genereret af TYPO3 CMS - frit tilg�ngeligt fra <a href=\"http://www.typo3.dk\" target=\"_blank\">www.typo3.dk</a>!\r\n  wrap = <br /><br /><font face=\"arial\" size=\"1\" color=\"black\"> | </font><br /><br />\r\n}\r\nstyles.content.typo3_powered = IMAGE\r\nstyles.content.typo3_powered{\r\n  file = media/uploads/typo3power{$styles.content.typo3_powered.number}.gif\r\n  linkWrap = <a href=\"http://www.typo3.com/\" target=\"_blank\">|</a>\r\n  wrap = <br />|<br /><br />\r\n}\r\n\r\n  # parsefunc\r\nstyles.content.parseFunc {\r\n  makelinks = 1\r\n  makelinks.http.keep = {$styles.content.links.keep}\r\n  makelinks.http.extTarget = {$styles.content.links.extTarget}\r\n  makelinks.http.wrap = {$styles.content.links.wrap}\r\n  makelinks.mailto.keep = path\r\n  makelinks.mailto.wrap = {$styles.content.links.wrap}\r\n  tags {\r\n    link = TEXT\r\n    link {\r\n      current = 1\r\n      typolink.parameter.data = parameters : allParams\r\n      typolink.extTarget = {$styles.content.links.extTarget}\r\n      typolink.target = {$styles.content.links.target}\r\n      typolink.wrap = {$styles.content.links.wrap}\r\n      parseFunc.constants =1\r\n    }\r\n  }\r\n  allowTags = {$styles.content.links.allowTags}\r\n  denyTags = *\r\n  sword = {$styles.content.links.sword}\r\n  constants = 1\r\n}\r\n\r\n  # textstyle\r\nstyles.content.textStyle {\r\n  align.field = text_align\r\n  face.field = text_face\r\n  size.field = text_size\r\n  color.field = text_color\r\n  properties.field = text_properties\r\n\r\n  face.default = {$styles.content.textStyle.face}\r\n  face.default.override.data = register: textStyle_face\r\n\r\n  size.default = {$styles.content.textStyle.size}\r\n  size.default.override.data = register: textStyle_size\r\n\r\n  color.default = {$styles.content.textStyle.color}\r\n  color.default.override.data = register: textStyle_color\r\n  \r\n  properties.default = {$styles.content.textStyle.properties}\r\n  properties.default.override.data = register: textStyle_properties\r\n\r\n  color.1 = {$styles.content.textStyle.color1}\r\n  color.2 = {$styles.content.textStyle.color2}\r\n\r\n  altWrap = {$styles.content.textStyle.altWrap}\r\n}\r\n\r\n  # tablestyle\r\nstyles.content.tableStyle {\r\n  align.field = {$styles.content.tableStyle.alignField}\r\n  border.field = table_border\r\n  cellspacing.field = table_cellspacing\r\n  cellpadding = 1\r\n  cellpadding.override.field = table_cellpadding\r\n\r\n  color.field = table_bgColor\r\n  color.default = {$styles.content.tableStyle.color}\r\n  color.1 = {$styles.content.tableStyle.color1}\r\n  color.2 = {$styles.content.tableStyle.color2}\r\n}\r\n\r\n  # pageframes\r\nstyles.content.frames = CASE\r\nstyles.content.frames {\r\n  key.field = section_frame\r\n  1 = TEXT\r\n  1.value = <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td> | </td></tr></table>\r\n\r\n  5 = HRULER\r\n  5.lineThickness = {$styles.content.frames.ruler.lineThickness}\r\n  5.lineColor = {$styles.content.frames.ruler.lineColor}\r\n  5.stdWrap.spaceBefore = {$styles.content.frames.ruler.before}\r\n  5.stdWrap.spaceAfter = {$styles.content.frames.ruler.after}\r\n  \r\n  6 = COA\r\n  6.1 = TEXT\r\n  6.1.value = |\r\n  6.2 < .5\r\n \r\n  10 = TEXT\r\n  10.value = <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td><img src=\"clear.gif\" width=\"{$styles.content.frames.indent}\" height=\"1\" alt=\"\" /></td><td> | </td></tr></table>\r\n  11 = TEXT\r\n  11.value = <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>{$styles.content.frames.33_66cell}<td> | </td></tr></table>\r\n  12 = TEXT\r\n  12.value = <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td> | </td>{$styles.content.frames.33_66cell}</tr></table>\r\n\r\n  20 = TEXT\r\n  20.value = <table border=\"0\" bgcolor=\"{$styles.content.frames.1.bgCol}\" cellspacing=\"0\" cellpadding=\"{$styles.content.frames.padding}\"><tr><td> | </td></tr></table>\r\n  21 = TEXT\r\n  21.value = <table border=\"0\" bgcolor=\"{$styles.content.frames.2.bgCol}\" cellspacing=\"0\" cellpadding=\"{$styles.content.frames.padding}\"><tr><td> | </td></tr></table>\r\n  21.wrap = <table border=\"0\" bgcolor=\"{$styles.content.frames.2.borderCol}\" cellspacing=\"0\" cellpadding=\"{$styles.content.frames.2.borderThickness}\"><tr><td> | </td></tr></table>\r\n}\r\n\r\n  # image Frames\r\nstyles.content.imgFrames.1 {\r\n  bgImg = GIFBUILDER\r\n  bgImg {\r\n    XY = 100,100\r\n    backColor = {$styles.content.imgFrames.bgCol}\r\n    backColor.override.data = register:pageColor\r\n  }\r\n{$styles.content.imgFrames.comment_bottom}  bottomImg = GIFBUILDER\r\n  bottomImg {\r\n    XY = 100,100\r\n    backColor = {$styles.content.imgFrames.bottomCol}\r\n  }\r\n  bottomImg_mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}1_bottom.jpg\r\n  mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}1_mask.jpg\r\n}\r\nstyles.content.imgFrames.2 < styles.content.imgFrames.1\r\nstyles.content.imgFrames.2 {\r\n  bottomImg_mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}2_bottom.jpg\r\n  mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}2_mask.jpg\r\n}\r\nstyles.content.imgFrames.3 < styles.content.imgFrames.1\r\nstyles.content.imgFrames.3 {\r\n  bottomImg_mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}3_bottom.jpg\r\n  mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}3_mask.jpg\r\n}\r\nstyles.content.imgFrames.4 < styles.content.imgFrames.1\r\nstyles.content.imgFrames.4 {\r\n  bottomImg_mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}4_bottom.jpg\r\n  mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}4_mask.jpg\r\n}\r\nstyles.content.imgFrames.5 < styles.content.imgFrames.1\r\nstyles.content.imgFrames.5 {\r\n  bottomImg_mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}5_bottom.jpg\r\n  mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}5_mask.jpg\r\n}\r\nstyles.content.imgFrames.6 < styles.content.imgFrames.1\r\nstyles.content.imgFrames.6 {\r\n  bottomImg_mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}6_bottom.jpg\r\n  mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}6_mask.jpg\r\n}\r\nstyles.content.imgFrames.7 < styles.content.imgFrames.1\r\nstyles.content.imgFrames.7 {\r\n  bottomImg_mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}7_bottom.jpg\r\n  mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}7_mask.jpg\r\n}\r\nstyles.content.imgFrames.8 < styles.content.imgFrames.1\r\nstyles.content.imgFrames.8 {\r\n  bottomImg_mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}8_bottom.jpg\r\n  mask = {$styles.content.imgFrames.path}{$styles.content.imgFrames.frameCollection}8_mask.jpg\r\n}\r\n\r\n\r\n\r\n  # imgtext\r\nstyles.content.imgtext = IMGTEXT\r\nstyles.content.imgtext {\r\n  imgList.field = image\r\n  textPos.field = imageorient\r\n  imgPath = uploads/pics/\r\n  imgObjNum = 1\r\n  1 {\r\n     file.import.current = 1\r\n     file.width.field = imagewidth\r\n     params = align=\"top\"\r\n     imageLinkWrap = 1\r\n     imageLinkWrap {\r\n       bodyTag = <body bgcolor=\"black\">\r\n       wrap = <a href=\"javascript:close();\"> | </a>\r\n       width = {$styles.content.imgtext.linkWrap.width}\r\n       height = {$styles.content.imgtext.linkWrap.height}\r\n       effects = {$styles.content.imgtext.linkWrap.effects}\r\n       JSwindow = 1\r\n       JSwindow.newWindow = {$styles.content.imgtext.linkWrap.newWindow}\r\n       JSwindow.expand = 17,20\r\n       enable.field = image_zoom\r\n       enable.ifEmpty.field = image_link\r\n       typolink.parameter.field = image_link\r\n{$styles.content.imgtext.comment_CSL-LinkList}     typolink.parameter.listNum.stdWrap.data = register : IMAGE_NUM\r\n       typolink.target = {$styles.content.links.target}\r\n       typolink.extTarget = {$styles.content.links.extTarget}\r\n     }\r\n  }\r\n  maxW = {$styles.content.imgtext.maxW}\r\n  maxW.override.data = register:maxImageWidth\r\n  maxWInText = {$styles.content.imgtext.maxWInText}\r\n  equalH.field = imageheight\r\n  image_compression.field = image_compression\r\n  image_effects.field = image_effects\r\n  spaceBelowAbove = 6\r\n\r\n  image_frames.key.field = image_frames\r\n  image_frames.1 < styles.content.imgFrames.1\r\n  image_frames.2 < styles.content.imgFrames.2\r\n  image_frames.3 < styles.content.imgFrames.3\r\n  image_frames.4 < styles.content.imgFrames.4\r\n  image_frames.5 < styles.content.imgFrames.5\r\n  image_frames.6 < styles.content.imgFrames.6\r\n  image_frames.7 < styles.content.imgFrames.7\r\n  image_frames.8 < styles.content.imgFrames.8\r\n\r\n  noRows.field = image_noRows\r\n\r\n  cols.field = imagecols\r\n  border.field = imageborder\r\n  caption {\r\n    1 = TEXT\r\n    1.if.isFalse = {$styles.content.imgtext.captionSplit}\r\n    1.field = imagecaption\r\n    1.parseFunc < styles.content.parseFunc\r\n    1.required = 1\r\n    1.fontTag = {$styles.content.imgtext.captionWrap}\r\n    1.wrapAlign.field = imagecaption_position\r\n    1.wrap = | <br />\r\n    1.spaceBefore = 5\r\n    1.br = 1\r\n  }\r\n  captionSplit = {$styles.content.imgtext.captionSplit}\r\n  captionSplit.cObject = TEXT\r\n  captionSplit.cObject.field = imagecaption\r\n  captionSplit.stdWrap < .caption.1\r\n  captionSplit.stdWrap {\r\n    field >\r\n    if >\r\n  }\r\n\r\n  borderCol = {$styles.content.imgtext.borderColor}\r\n  borderThick = {$styles.content.imgtext.borderThick}\r\n  colSpace = {$styles.content.imgtext.colSpace}\r\n  rowSpace = {$styles.content.imgtext.rowSpace}\r\n  textMargin = {$styles.content.imgtext.textMargin}\r\n\r\n  editIcons = tt_content : image [imageorient|imagewidth|imageheight], [imagecols|image_noRows|imageborder],[image_link|image_zoom],[image_compression|image_effects|image_frames],imagecaption[imagecaption_position]\r\n  editIcons.iconTitle=Edit images\r\n  caption.editIcons = tt_content : imagecaption[imagecaption_position]\r\n  caption.editIcons.beforeLastTag=1\r\n  caption.editIcons.iconTitle = Edit image caption\r\n}\r\n\r\n\r\n\r\n\r\n\r\n# NOTE: Based on \"current\" to be set to the bulletlist content on beforehand!\r\nstyles.content.bulletlist = TEXT\r\nstyles.content.bulletlist {\r\n  current = 1\r\n  trim = 1\r\n  if.isTrue.current = 1\r\n  parseFunc < styles.content.parseFunc\r\n  split {\r\n    token.char = 10\r\n    cObjNum = 1\r\n    1.current = 1\r\n    1.wrap = <li>|</li>\r\n  }\r\n  fontTag = <ol> | </ol>\r\n  textStyle < styles.content.textStyle\r\n  textStyle.altWrap = {$styles.content.bulletlist.altWrap}\r\n}\r\n\r\n# NOTE: Based on \"current\" to be set to the bulletlist content on beforehand!\r\nstyles.content.bulletlist_gr < styles.content.bulletlist\r\nstyles.content.bulletlist_gr {\r\n  split {\r\n    1.wrap = <tr><td valign=\"top\"><img src=\"media/bullets/dot.gif\" vspace=\"4\" hspace=\"4\" alt=\"\" /></td><td valign=\"top\"> | </td></tr>\r\n    1.textStyle < styles.content.textStyle\r\n    1.textStyle.altWrap = {$styles.content.bulletlist.altWrap}\r\n  }\r\n  wrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"2\"> | </table>\r\n  fontTag >\r\n  textStyle >\r\n}\r\n\r\n# NOTE: Based on \"current\" to be set to the table content on beforehand!\r\nstyles.content.table  = TEXT\r\nstyles.content.table {\r\n  current = 1\r\n  if.isTrue.current = 1\r\n  trim = 1\r\n  parseFunc < styles.content.parseFunc\r\n  split {\r\n    token.char = 10\r\n    cObjNum = 1 || 2\r\n    1.current = 1\r\n    1.trim =1\r\n    1.required = 1\r\n    1.split {\r\n      token = |\r\n      max.field = cols\r\n      min.field = cols\r\n      cObjNum = 1 || 2\r\n      1.current = 1\r\n      1.fontTag = |&nbsp;\r\n      1.textStyle < styles.content.textStyle\r\n      1.textStyle.altWrap = {$styles.content.table.altWrap}\r\n      1.wrap = <td valign=\"top\">|</td>\r\n      2 < .1\r\n    }\r\n    2 < .1\r\n    wrap = <tr>|</tr>\r\n  }\r\n  tableStyle < styles.content.tableStyle\r\n}\r\n\r\n\r\n\r\n  # uploads\r\nstyles.content.uploads = TEXT\r\nstyles.content.uploads {\r\n  current = 1\r\n  override.filelist.field = select_key\r\n  trim = 1\r\n  required = 1\r\n  split {\r\n    token = ,\r\n    cObjNum = 1\r\n    1.current = 1\r\n    1.trim =1\r\n    1.filelink {\r\n      path = uploads/media/\r\n      path.override.field  = select_key\r\n      path.override.listNum = 0\r\n      path.override.listNum.splitChar = |\r\n      size = 1\r\n      size.wrap = {$styles.content.uploads.tdWrap}\r\n      size.innerWrap = &nbsp;&nbsp;&nbsp;\r\n      size.innerWrap2 = {$styles.content.uploads.sizeWrap}\r\n      size.fontTag = {$styles.content.uploads.wrap}\r\n      size.bytes = 1\r\n      size.if.isTrue.field = filelink_size\r\n      labelStdWrap.fontTag = {$styles.content.uploads.labelWrap}\r\n      file.fontTag = {$styles.content.uploads.wrap}\r\n      file.wrap = {$styles.content.uploads.tdWrap}\r\n      file.postCObject = TEXT\r\n      file.postCObject {\r\n        field = imagecaption\r\n        required = 1\r\n        if.directReturn = {$styles.content.uploads.descriptionWrap}\r\n        wrap = <br />{$styles.content.uploads.descriptionWrap}\r\n        listNum.stdWrap.data = register : SPLIT_COUNT\r\n        listNum.splitChar = 10\r\n      }\r\n      stdWrap.wrap = <tr><td><img src=\"clear.gif\" width=\"4\" height=\"1\" alt=\"\" /></td> | </tr>\r\n      target = _blank\r\n      jumpurl = {$styles.content.uploads.jumpurl}\r\n      jumpurl.secure = {$styles.content.uploads.jumpurl_secure}\r\n      jumpurl.secure.mimeTypes = {$styles.content.uploads.jumpurl_secure_mimeTypes}\r\n      removePrependedNumbers = 1\r\n    }\r\n  }\r\n  tableStyle < styles.content.tableStyle\r\n\r\n}\r\nstyles.content.uploads_icons < styles.content.uploads\r\nstyles.content.uploads_icons.split.1.filelink {\r\n  icon = 1\r\n  icon.wrap2 = <td align=\"center\"> | </td>\r\n  icon_link = 1\r\n}\r\nstyles.content.uploads_imgicons < styles.content.uploads_icons\r\nstyles.content.uploads_imgicons.split.1.filelink {\r\n  icon_image_ext_list.data = global: TYPO3_CONF_VARS|GFX|imagefile_ext\r\n  icon.wrap = {$_blackBorderWrap}\r\n}\r\n\r\n\r\n  # columns\r\nstyles.content.columns = COLUMNS\r\nstyles.content.columns {\r\n  1 = CONTENT\r\n  1 {\r\n    table = tt_content\r\n    select.orderBy = sorting\r\n    select.where = colPos=1\r\n    select.languageField = sys_language_uid\r\n  }\r\n  2 < .1\r\n  2.select.where = colPos=2\r\n\r\n  gapWidth = {$styles.content.columns.gapWidth}\r\n  gapLineThickness = {$styles.content.columns.gapLineThickness}\r\n  if.isTrue.numRows < .1\r\n  if.isTrue.ifEmpty.numRows < .2\r\n  totalWidth = {$styles.content.columns.totalWidth}\r\n}\r\n\r\n  # mailform\r\nstyles.content.mailform = FORM\r\nstyles.content.mailform {\r\n  layout = <tr><td align=\"right\">###LABEL###</td><td><img src=\"clear.gif\" width=\"{$styles.content.mailform.border}\" alt=\"\" /></td><td>###FIELD###</td></tr>\r\n  labelWrap.wrap = {$styles.content.mailform.labelWrap}\r\n  fieldWrap.wrap = {$styles.content.mailform.fieldWrap}\r\n  commentWrap.wrap = {$styles.content.mailform.commentWrap}\r\n  radioWrap.wrap = {$styles.content.mailform.radioWrap}\r\n  REQ = 1\r\n  REQ.labelWrap.wrap = {$styles.content.mailform.REQ.labelWrap}\r\n  COMMENT.layout = <tr><td colspan=\"3\" align=\"center\">###LABEL###</td></tr>\r\n  stdWrap.wrap = <table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">  | </table>\r\n  target = {$styles.content.mailform.target}\r\n  goodMess = {$styles.content.mailform.goodMess}\r\n  badMess = {$styles.content.mailform.badMess}\r\n  redirect.field = pages\r\n  redirect.listNum = 0\r\n  recipient.field = subheader\r\n  data.field = bodytext\r\n#  type.field = form_type\r\n  type > \r\n  locationData = 1\r\n}\r\n\r\n{$styles.content.mailform.comment_type2} styles.content.mailform.layout = <tr><td><img src=\"clear.gif\" width=\"{$styles.content.mailform.border}\" alt=\"\" /></td><td>###LABEL###<br />###FIELD###</td></tr>\r\n{$styles.content.mailform.comment_type2} styles.content.mailform.COMMENT.layout = <tr><td></td><td>###LABEL###</td></tr>\r\n\r\n\r\n\r\n  # loginform\r\nstyles.content.loginform < styles.content.mailform\r\nstyles.content.loginform {\r\n  goodMess = {$styles.content.loginform.goodMess}\r\n  redirect >  \r\n  recipient > \r\n  data >\r\n  dataArray {\r\n    10.label = Username:\r\n    10.type = *user=input\r\n    20.label = Password:\r\n    20.type = *pass=password\r\n    30.type = logintype=hidden\r\n    30.value = login\r\n    40.type = submit=submit\r\n    40.value = Login\r\n  }\r\n  type.field = pages\r\n  type.listNum = 0\r\n  target = {$styles.content.loginform.target}\r\n  locationData = 0\r\n  hiddenFields.pid = TEXT\r\n  hiddenFields.pid {\r\n    value = {$styles.content.loginform.pid}\r\n    override.field = pages\r\n    override.listNum = 1\r\n  }\r\n}\r\n\r\n[loginUser = *]\r\nstyles.content.loginform {\r\n  dataArray >\r\n  dataArray {\r\n    10.label = Username: <!--###USERNAME###--> \r\n    20 >\r\n    30.type = logintype=hidden\r\n    30.value = logout\r\n    40.type = submit=submit\r\n    40.value = Logout\r\n  }\r\n}\r\n[global]\r\n\r\n  # searchform\r\nstyles.content.searchform < styles.content.mailform\r\nstyles.content.searchform {\r\n  goodMess = {$styles.content.searchform.goodMess}\r\n  redirect >  \r\n  recipient > \r\n  data >\r\n  dataArray {\r\n    10.label = Searchword:\r\n    10.type = sword=input\r\n    20.label = Search in:\r\n    20.type = scols=select\r\n    20.valueArray {\r\n      10.label = Headers and keywords\r\n      10.value = pages.title-subtitle-keywords-description:tt_content.header\r\n      20.label = Pagecontent\r\n      20.value = tt_content.header-bodytext-imagecaption\r\n    }\r\n    30.type = stype=hidden\r\n    30.value = L0\r\n    40.type = submit=submit\r\n    40.value = Search now!\r\n  }\r\n  type.field = pages\r\n  type.listNum = 0\r\n  locationData = HTTP_POST_VARS\r\n  no_cache = 1\r\n}\r\n\r\n  # searchresult\r\nstyles.content.searchresult = SEARCHRESULT\r\nstyles.content.searchresult {\r\n  allowedCols = pages.title-subtitle-keywords-description : tt_content.header-bodytext-imagecaption : tt_address.name-title-address-email-company-city-country : tt_links.title-note-note2-url : tt_board.subject-message-author-email : tt_calender.title-note : tt_products.title-note-itemnumber\r\n  languageField.tt_content = sys_language_uid\r\n  renderObj = COA\r\n  renderObj {\r\n    10 = TEXT\r\n    10.field = pages_title\r\n    10.htmlSpecialChars = 1\r\n    10.textStyle {\r\n      face.default = {$styles.content.searchresult.head.face}\r\n      size.default = {$styles.content.searchresult.head.size}\r\n      color.default = {$styles.content.searchresult.head.color}\r\n    }\r\n    10.fontTag = <b> | </b>\r\n    10.typolink.parameter.field = uid\r\n    10.typolink.target = {$styles.content.searchresult.resultTarget}\r\n    10.typolink.additionalParams.data = register:SWORD_PARAMS\r\n    10.typolink.additionalParams.required = 1\r\n    10.typolink.additionalParams.wrap = &no_cache=1\r\n    10.wrap = <tr><td>|</td></tr>\r\n    10.spaceBefore = 6\r\n    20 = COA\r\n    20 {\r\n      10 = TEXT\r\n      10.field = tt_content_bodytext\r\n      10.htmlSpecialChars = 1\r\n      10.stripHtml = 1\r\n    }\r\n    20.stdWrap.crop = 200 | ...\r\n    20.stdWrap.wrap = <tr><td>|</td></tr>\r\n    20.stdWrap.textStyle {\r\n      face.default = {$styles.content.searchresult.face}\r\n      size.default = {$styles.content.searchresult.size}\r\n      color.default = {$styles.content.searchresult.color}\r\n    }\r\n  }\r\n  renderWrap = <table border=\"0\" cellspacing=\"3\"> | </table>\r\n  layout = COA\r\n  layout {\r\n    wrap = <table border=\"0\" cellspacing=\"0\" cellpadding=\"2\"><tr> | </tr></table> ###RESULT###\r\n    10 = TEXT\r\n    10.value = Searchresult: ###RANGELOW###-###RANGEHIGH### of ###TOTAL###\r\n    10.fontTag = {$styles.content.searchresult.header.wrap}\r\n    10.wrap = <td width=\"95%\" bgcolor=\"{$styles.content.searchresult.header.bgCol}\"> | </td>\r\n    20 = TEXT\r\n    20.value = ###PREV###&nbsp;&nbsp;&nbsp;###NEXT###\r\n    20.fontTag = {$styles.content.searchresult.header.wrap}\r\n    20.wrap = <td bgcolor=\"{$styles.content.searchresult.header.bgCol}\">|</td>\r\n  }\r\n  noResultObj = COA\r\n  noResultObj {\r\n    wrap = <table border=\"0\" cellspacing=\"0\" cellpadding=\"2\"><tr> | </tr></table>\r\n    10 = TEXT\r\n    10.value = Sorry, your search was empty!\r\n    10.fontTag = {$styles.content.searchresult.header.wrap}\r\n    10.wrap = <td width=\"95%\" bgcolor=\"{$styles.content.searchresult.header.bgCol}\"> | </td>\r\n  }\r\n  next = TEXT\r\n  next.value = Next\r\n  prev = TEXT\r\n  prev.value = Prev\r\n  target = {$styles.content.searchresult.target}\r\n  range = 20\r\n}\r\n\r\n\r\nstyles.content.editPanelPage = COA\r\nstyles.content.editPanelPage {\r\n  10 = EDITPANEL\r\n  10 {\r\n# move,new,edit,hide\r\n    allow = toolbar,move,hide\r\n    label = Page: <b>%s</b>\r\n  }\r\n/*\r\n  20 = EDITPANEL\r\n  20 {\r\n    newRecordFromTable = tt_content\r\n    line = 5\r\n    label = New content...\r\n  }\r\n*/\r\n}\r\n\r\n\r\nstyles.content.RTE_encaps_stylesheets {\r\n  encapsTagList = div,p,pre\r\n  remapTag.DIV = P\r\n  nonWrappedTag = P\r\n  innerStdWrap_all.ifEmpty = &nbsp;\r\n  defaultAlign.field = text_align\r\n}\r\n\r\nstyles.content.RTE_encaps_fontwrap < styles.content.RTE_encaps_stylesheets\r\nstyles.content.RTE_encaps_fontwrap {\r\n    # Forcing these attributes onto the encapsulation-tags if any\r\n  addAttributes.P.style=margin:0 0 0 0;\r\n  addAttributes.PRE.style=margin:0 0 0 0; color:navy;\r\n  encapsLinesStdWrap.P.textStyle < styles.content.textStyle\r\n  encapsLinesStdWrap.P.textStyle.align>\r\n}\r\n','This is a \"library\" of standard-objects commonly used - at least in the standard-templates and \"Content (default)\".\r\n','');
INSERT INTO `static_template` VALUES (76,0,1054752719,997664283,'language.dk (danish) [DEPRECIATED]','','# ***********************\r\n#  Newsletter subscription\r\n# ***********************\r\nplugin.feadmin.dmailsubscription.file.templateFile = media/scripts/fe_admin_dmailsubscrip_dk.tmpl','## Setting the TypoScript language to danish:\r\nconfig.language = dk\r\n\r\n\r\n# ***********************************\r\n#  Login form as used in \'content (default)\'\r\n# ***********************************\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.dk = Brugernavn:\r\n    20.label.lang.dk = Password:\r\n    40.value.lang.dk = Login\r\n}\r\n\r\n[usergroup = *]\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.dk = Brugernavn: <!--###USERNAME###--> \r\n    20 >\r\n    40.value.lang.dk = Logout\r\n}\r\n[global]\r\n\r\n\r\n\r\n\r\n# ***********************\r\n#  Search dialog object\r\n# ***********************\r\n\r\ntt_content.search.30.dataArray {\r\n    10.label.lang.dk = Sgeord:\r\n    20.label.lang.dk = Sg i:\r\n    20.valueArray {\r\n      10.label.lang.dk = Overskrifter og ngleord\r\n      20.label.lang.dk = Sideindhold\r\n    }\r\n    40.value.lang.dk = Start sgning!\r\n}\r\n\r\n\r\n\r\n# ***********************\r\n#  Search result page object\r\n# ***********************\r\ntt_content.search.20 {\r\n  layout.10.lang.dk = Sgeresultat: ###RANGELOW###-###RANGEHIGH### ud af ###TOTAL###\r\n  noResultObj.10.lang.dk = Beklager, din sgning var tom!\r\n  next.lang.dk = Nste\r\n  prev.lang.dk = Forrige\r\n}\r\n\r\n\r\n\r\n# ***********************\r\n#  Default Guestbook form\r\n# ***********************\r\nplugin.tt_guest.postform.dataArray {\r\n  10.label.lang.dk = Oversk:\r\n  20.label.lang.dk = Din kommentar:\r\n  30.label.lang.dk = Navn:\r\n  40.label.lang.dk = Email:\r\n  50.label.lang.dk = Hjemmeside:\r\n  60.value.lang.dk = Tilfj dig selv\r\n}\r\n\r\n\r\n# ***********************\r\n#  Default List Board form\r\n# ***********************\r\nplugin.tt_board_list.postform.dataArray {\r\n  10.label.lang.dk = Emne:\r\n  20.label.lang.dk = Tekst:\r\n  30.label.lang.dk = Navn:\r\n  40.label.lang.dk = Email:\r\n  50.label.lang.dk = Send email<br />ved svar: \r\n  60.value.lang.dk = Send svar\r\n}\r\nplugin.tt_board_list.postform_newThread.dataArray {\r\n  10.label.lang.dk = Emne:\r\n  20.label.lang.dk = Tekst:\r\n  30.label.lang.dk = Navn:\r\n  40.label.lang.dk = Email:\r\n  50.label.lang.dk = Send email<br />ved svar: \r\n  60.value.lang.dk = Opret ny trd\r\n}\r\nplugin.tt_board_list.postform.badMess = Du skal udfylde disse felter:\r\nplugin.tt_board_list.postform_newThread.badMess = Du skal udfylde disse felter:\r\n\r\n# ***********************\r\n#  Default Tree Board form\r\n# ***********************\r\nplugin.tt_board_tree.postform.dataArray {\r\n  10.label.lang.dk = Emne:\r\n  20.label.lang.dk = Tekst:\r\n  30.label.lang.dk = Navn:\r\n  40.label.lang.dk = Email:\r\n  50.label.lang.dk = Send email<br />ved svar: \r\n  60.value.lang.dk = Send svar\r\n}\r\nplugin.tt_board_tree.postform_newThread.dataArray {\r\n  10.label.lang.dk = Emne:\r\n  20.label.lang.dk = Tekst:\r\n  30.label.lang.dk = Navn:\r\n  40.label.lang.dk = Email:\r\n  50.label.lang.dk = Send email<br />ved svar: \r\n  60.value.lang.dk = Opret ny trd\r\n}\r\nplugin.tt_board_tree.postform.badMess = Du skal udfylde disse felter:\r\nplugin.tt_board_tree.postform_newThread.badMess = Du skal udfylde disse felter:\r\n\r\n\r\n\r\n# ***********************\r\n#  Newsletter subscription\r\n# ***********************\r\nplugin.feadmin.dmailsubscription.evalErrors.email {\r\n  uniqueLocal = Tilsyneladende er du allerede registreret med denne email adresse!\r\n  email = Dette er ikke en korrekt email adresse!\r\n}\r\n\r\n','This implements danish labels on these standard elements \r\n\r\nFrom \'content (default)\':\r\n\r\n- login form \r\n- search form\r\n- search result\r\n\r\nFrom \'tt_guest\':\r\n\r\n- submit form.\r\n\r\n\r\nFrom \'tt_board\':\r\n\r\n- submit forms.\r\n\r\n\r\n','');
INSERT INTO `static_template` VALUES (62,0,1054753090,983439200,'plugin.tt_calender [DEPRECIATED]','','plugin.tt_calender >\r\nplugin.tt_calender {\r\n    # cat=plugin.calendar/file; type=file[html,htm,tmpl,txt]; label= Template File: This is a simple htmlfile where each part of the calendar is defined with HTML-code. To see an example with explanations, take a look at media/scripts/calender_template.tmpl which is the default.\r\n  file.templateFile = media/scripts/calendar_template.tmpl\r\n    # cat=plugin.calendar/typo; type=short; label=Font face\r\n  fontFace = verdana\r\n    # cat=plugin.calendar//; type=int+; label=Max age (days): If set, the items will automatically disappear from the calendar after this number of days.\r\n  maxAge =\r\n}','\r\n## Rendering of calenders\r\n## See TSref and/or tslib/media/scripts/calendar.inc for details about the TypoScript config. \r\nplugin.tt_calender >\r\nplugin.tt_calender = PHP_SCRIPT\r\nplugin.tt_calender {\r\n  file = media/scripts/calendar.inc\r\n  templateFile = {$plugin.tt_calender.file.templateFile}\r\n  pid_list.field = pages\r\n  recursive.field = recursive\r\n  fontFace = {$plugin.tt_calender.fontFace}\r\n  maxAge = {$plugin.tt_calender.maxAge}\r\n  parseFunc < styles.content.parseFunc\r\n}\r\n\r\n\r\n## This enables the record item to display calendar items\r\ntt_calender >\r\ntt_calender < plugin.tt_calender\r\ntt_calender.displayCurrentRecord = 1\r\n\r\n','PLUGIN: Calendar\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\nHow to activate this:\r\n- Include this static template in your template.','');
INSERT INTO `static_template` VALUES (46,0,1054753516,956069576,'styles.sitemap.text','','styles.sitemap.text >\r\nstyles.sitemap.text {\r\n    # cat=content/cMenu/sitemap; type=wrap; label=Sitemap, Item Wrap: This wrap is placed around the every item in the sitemap.\r\n  itemWrap = \r\n    # cat=content/cMenu/sitemap; type=wrap; label=Sitemap, Total Wrap: This wrap is placed around the whole sitemap.\r\n  totalWrap = <font face=\"verdana\" size=\"1\"> | </font>\r\n    # cat=content/cMenu/sitemap; type=small; label=Sitemap, Target: The target of the links in the sitemap. \r\n  target = _top\r\n}\r\n\r\n','styles.sitemap.text >\r\nstyles.sitemap.text = HMENU\r\nstyles.sitemap.text.stdWrap.wrap = {$styles.sitemap.text.totalWrap}\r\nstyles.sitemap.text {\r\n  1 = TMENU\r\n  1.NO.allWrap = |<br />\r\n  1.NO.linkWrap = {$styles.sitemap.text.itemWrap}\r\n  1.NO.ATagBeforeWrap = 1\r\n  1.target = {$styles.sitemap.text.target}\r\n  1.expAll = 1\r\n  2 = TMENU\r\n  2.NO.allWrap = &nbsp;&nbsp;&nbsp;&nbsp;|<br />\r\n  2.NO.linkWrap = {$styles.sitemap.text.itemWrap}\r\n  2.NO.ATagBeforeWrap = 1\r\n  2.target = {$styles.sitemap.text.target}\r\n  2.expAll = 1\r\n  3 = TMENU\r\n  3.NO.allWrap = &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|<br />\r\n  3.NO.linkWrap = {$styles.sitemap.text.itemWrap}\r\n  3.NO.ATagBeforeWrap = 1\r\n  3.target = {$styles.sitemap.text.target}\r\n  3.expAll = 1\r\n  4 = TMENU\r\n  4.NO.allWrap = &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|<br />\r\n  4.NO.linkWrap = {$styles.sitemap.text.itemWrap}\r\n  4.NO.ATagBeforeWrap = 1\r\n  4.target = {$styles.sitemap.text.target}\r\n  4.expAll = 1\r\n}\r\n\r\n\r\n','Sitemap object.\r\n\r\nHMENU textbased, used to render a kind of treelike sitemap. \r\n\r\nUsed with \"content (default)\" for the sitemap-feature.','');
INSERT INTO `static_template` VALUES (47,0,1054753226,956072821,'records (example)','','','tt_address >\r\ntt_address = COA\r\ntt_address {\r\n  10 = TEXT\r\n  10.field = name\r\n  10.wrap = ADDRESS: | <br />\r\n\r\n  20 = TEXT\r\n  20.field = email\r\n  20.wrap = | <br />\r\n\r\n  30 = TEXT\r\n  30.field = address\r\n  30.wrap = | <br />\r\n}\r\n\r\n\r\ntt_links >\r\ntt_links = COA\r\ntt_links {\r\n  10 = TEXT\r\n  10.field = title\r\n  10.wrap = LINKS: | <br />\r\n}\r\n\r\n\r\ntt_guest >\r\ntt_guest = CASE\r\ntt_guest.key.field = type\r\ntt_guest.1 = COA\r\ntt_guest.1 {\r\n  10 = TEXT\r\n  10.field = title\r\n  10.wrap = | <br />\r\n\r\n  20 = TEXT\r\n  20.value = Nummer 1\r\n  20.wrap = | <br />\r\n}\r\n\r\n\r\ntt_calender >\r\ntt_calender = COA\r\ntt_calender {\r\n  10 = TEXT\r\n  10.field = title\r\n  10.wrap = | <br />\r\n}\r\n\r\n\r\ntt_products >\r\ntt_products = COA\r\ntt_products {\r\n  10 = TEXT\r\n  10.field = title\r\n  10.wrap = | <br />\r\n}\r\n\r\ntt_news >\r\ntt_news = COA\r\ntt_news {\r\n  10 = TEXT\r\n  10.field = title\r\n  10.wrap = | <br />\r\n}\r\n\r\n\r\n','Provides a very primitive example of how to make render code for tt_* tables. It should only inspire you to get started coding your own content rendering.','');
INSERT INTO `static_template` VALUES (48,0,1054753612,956688832,'template: MM','43,68','  #cat=basic/enable; type=boolean; label=Gap 1, left: Check this option to enable the gap on the left side of the page table\r\nenableGap1 = 1\r\n  #cat=basic/enable; type=boolean; label=Gap 2, between: Check this option to enable the gap between the page- and news-content columns in the page table\r\nenableGap2 = 1\r\n  #cat=basic/enable; type=boolean; label=Gap 3, right: Check this option to enable the gap on the right side of the page table\r\nenableGap3 = 1\r\n\r\n// This excludes the constant \"styles.content.imgtext.maxW\" from being displayed in the constant editor. The reason why this is desirable is that the REGISTER is used to override this value in this template.\r\n  # cat=\r\nstyles.content.imgtext.maxW =\r\n\r\npageCol {\r\n    #cat=basic/color; type=color; label=Content column bgColor: This is the background color of the table cell where the content is displayed. You would normally regard this as being the \"page color\".\r\n  bgColor = #cccccc\r\n    # cat=content,basic/cImage/a_maxw1; type=int+; label=Max Image Width: This indicates that maximum number of pixels (width) a block of images inserted as content is allowed to consume.\r\n  maxImageWidth = 450\r\n    #cat=page/dims; type=small; label=Content table width: This is the \'width=\' parameter in the table that holds the content in the content cell of the page table.\r\n  contentTableWidth = 95%\r\n    #cat=page/dims; type=offset; label=Content table offset: This is the offset of the content from the upper-left corner of the content cell of the page table.\r\n  offset = 15,8\r\n}\r\n\r\nrightCol {\r\n    #cat=right,basic/enable; type=boolean; label=Enable right column: Click this option to enable the right column in the page table. This column can be used for \"news\" from a certain page, but inserted on all pages. You can also configure the column to hold \"secondary\" content specific for each page. Then content of the column-type \"Border\" is inserted. NOTE: This option is also found in the dedicated category \"RIGHT\" that configures the characteristics of this column.\r\n  enable = 1\r\n    #cat=right/enable; type=options[getNews,getBorder]; label=Column content: Choose \"getNews\" to select content from a specific page (defined below here) or \"getBorder\" to display the \"Border\"-content of the current page.\r\n  borderContent = getNews\r\n    #cat=right/color; type=color; label=Right column bgColor: This is the background color of content in the right column.\r\n  bgColor = white\r\n    #cat=right/dims; type=int+; label=Max Image Width: This indicates that maximum number of pixels (width) a block of images inserted as content is allowed to consume. NOTE: This is specific for the right column! The figure should approx. match the width of the image in the top of this column!\r\n  maxImageWidth = 150\r\n    #cat=right/dims; type=offset; label=Content offset: This is the offset of the content from the upper-left corner of the table cell.\r\n  offset = 5,8\r\n    #cat=right/typo; type=small; label=Bodytext font face\r\n  textStyle_face =\r\n    #cat=right/typo; type=int[1-5]; label=Bodytext font size\r\n  textStyle_size =\r\n    #cat=right/typo; type=color; label=Bodytext font color\r\n  textStyle_color =\r\n    #cat=right/typo; type=int[1-5]; label=Default Header type: Enter the number of the header layout to be used by default. \r\n  defaultHeaderType =\r\n}\r\n  # cat=right/enable/zz; type=int+; label=News Content PID: If you selected \"getNews\" above, this is where you enter the page-id of the page from which to fetch the \"news\" content for the column.\r\nstyles.content.getNews.newsPid = 0\r\n\r\n\r\n  # cat=basic/color; type=color; label=<body>-tag, Background color: This is the <body>-tag bgColor of the page. NOTE: It\'s not behind the content IN the table, but behind the table that makes up the page in this template. Just like \"file.background\"\r\nbgCol = black\r\n  # cat=basic/color; type=color; label=Gap, Background color: If there is no background image in the gaps, this color will appear\r\ngapColor = olive\r\n  # cat=basic/color; type=color; label=Border, Color: Color of the border between areas\r\nborderColor = #cccccc\r\n\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = \r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = \r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = \r\n\r\nfile {\r\n    #cat=basic/file; type=file[IMAGE_EXT]; label=Background Image: This is the body-tag background image of the page. NOTE: It\'s not behind the content in the table, but behind the table that makes up the page in this template.\r\n  background = \r\n    #cat=basic,menu/file; type=file[IMAGE_EXT]; label=Menu imagemap Image: This is the image onto which the menu rendered. NOTE: This image also appears in the MENU-category.\r\n  menuimage = \r\n    #cat=basic,right/file; type=file[IMAGE_EXT]; label=Right Column Image: This is the image in the top-right corner of the page table. NOTE: This image is displayed only if the right column of the template is enabled! NOTE: This image can also be selected in the dedicated RIGHT-category.\r\n  sideimage = \r\n    #cat=basic/file; type=file[IMAGE_EXT]; label=Gap image: Image in the gap between columns.\r\n  gapIcon = \r\n}\r\n\r\n  # cat=basic/dims; type=int+; label=Minimum pageheight: If there is no content on the page to expand it\'s length, this ensures that the page table doesn\'t collapse totally but will always be at least this long (pixels).\r\nminPageH = 100\r\n  # cat=basic/dims; type=int+; label=Gap Width: Width of gaps on the page\r\ngapIcon_width = 10\r\n  # cat=basic/dims; type=int+; label=Border, Thickness: Thickness of the border between areas\r\nborderThickness = 1\r\n\r\n  # cat=basic; type=options[,left,right,center]; label=Alignment of the page: Alignment of the page-table\r\npageAlign = center\r\n\r\nimageMap {\r\n    #cat=menu/typo; type=file[ttf]; label=Font file for the menu\r\n  file.fontFile =\r\n    #cat=menu/typo; type=int[1-50]; label=Font size for the menu\r\n  fontSize = 11\r\n    #cat=menu/typo; type=color; label=Font color for the menu\r\n  fontColor = black\r\n    #cat=menu/dims; type=offset; label=Text offset: Text offset from upper-left corner of the image\r\n  dWorkArea = 7,68\r\n    #cat=menu//x; type=int[1-256]; label=Reduce colors: Number of indexed colors in the menuimage. If your imagemap image ends up with weird colors, you can try to enter a higher number of colors. But the file will also increase in filesize.\r\n  colors = 16\r\n    #cat=menu; type=int[1-15]; label=Max items: Enter the maximum number of menu items in the image map. If there are many items to generate, the server will take a lot of time to generate the menu image. So keep this number low. Recommended: 6-10\r\n  maxItems=\r\n}\r\n\r\nPAGE_TARGET =\r\ncontent.pageFrameObj = \r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"MM\"\r\n  description = MM is a single-page template with a imagemap-based menu in the top. You can select background-images, colors, borderwidths and colors and so on. Furthermore you can define content in a second column. \r\n  bulletlist = Optional right column: Select background color, other standard header- and text-properties. (4) // Background color or optional background image. (6) // Image as background for the image-map menu: Select TrueType-font, color, size, offset on the image (7) // Optional image in the right column (8) // Optional gap between the two columns. Define background color OR background image for the gap. (1,2,3)\r\n\r\n  image = gfx/MM_basic.gif\r\n  1=enableGap1,gapIcon_width,file.gapIcon,gapColor\r\n  2=enableGap2,gapIcon_width,file.gapIcon,gapColor\r\n  3=enableGap3,gapIcon_width,file.gapIcon,gapColor\r\n  4=rightCol.enable\r\n  5=borderThickness,borderColor\r\n  6=file.background,bgCol\r\n  7=file.menuimage\r\n  8=file.sideimage\r\n  9=pageCol.bgColor\r\n}\r\nTSConstantEditor.right {\r\n  description = \r\n  image = gfx/MM_right.gif\r\n  1=rightCol.maxImageWidth\r\n  2=rightCol.offset\r\n  3=file.sideimage\r\n  4=rightCol.borderContent,rightCol.textStyle_face,rightCol.textStyle_size,rightCol.textStyle_color\r\n  5=rightCol.borderContent,rightCol.defaultHeaderType\r\n  6=rightCol.bgColor\r\n}\r\nTSConstantEditor.menu {\r\n  description = \r\n  image = gfx/MM_menu.gif\r\n  1=imageMap.dWorkArea\r\n  2=file.menuimage,imageMap.colors\r\n  3=imageMap.file.fontFile,imageMap.fontSize,imageMap.fontColor,imageMap.maxItems\r\n}\r\n\r\n','# border:\r\ntemp.gap = CLEARGIF\r\ntemp.gap.width = {$gapIcon_width}\r\ntemp.gap.height = {$minPageH}\r\ntemp.gap.wrap = <td bgcolor=\"{$gapColor}\" background=\"{$file.gapIcon}\"> | </td>\r\n\r\n# Menu:\r\ntemp.topmenu = HMENU\r\ntemp.topmenu.maxItems = {$imageMap.maxItems}\r\ntemp.topmenu.entryLevel = 0\r\ntemp.topmenu.1 = IMGMENU\r\ntemp.topmenu.1 {\r\n  wrap = |<br />\r\n  main.XY = [10.w] , [10.h]\r\n  main.10 = IMAGE\r\n  main.10.file = {$file.menuimage}\r\n  main.reduceColors = {$imageMap.colors}\r\n\r\n  dWorkArea = {$imageMap.dWorkArea}\r\n\r\n  NO.distrib = textX+10, 0, textX+10, textY+5\r\n  NO.10 = TEXT\r\n  NO.10 {\r\n    text.field = nav_title // title\r\n    fontFile = {$imageMap.file.fontFile}\r\n    fontSize = {$imageMap.fontSize}\r\n    fontColor = {$imageMap.fontColor}\r\n    niceText = 1\r\n    offset = 4,9\r\n    imgMap.explode = 3,2\r\n  }\r\n}\r\n\r\n\r\n\r\n\r\n# ******************\r\n# *** Page Setup ***\r\n# ******************\r\n\r\npage = PAGE\r\npage.typeNum = 0\r\npage.bodyTag < styles.content.bodyTag\r\npage.bgImg = {$file.background}\r\npage.wrap = <div align=\"{$pageAlign}\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"1%\"><tr bgcolor=\"{$borderColor}\"><td> <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"{$borderThickness}\"><tr> | </tr></table> </td></tr></table></div>\r\n\r\npage.10 < temp.gap\r\npage.10.stdWrap.if.isTrue = {$enableGap1}\r\n\r\npage.20 = COA\r\npage.20.wrap = <td bgcolor=\"{$pageCol.bgColor}\" valign=\"top\"> | </td>\r\npage.20 {\r\n  10 < temp.topmenu \r\n  20 = OTABLE\r\n  20.offset = {$pageCol.offset}\r\n  20.tableParams = border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"{$pageCol.contentTableWidth}\"\r\n  20.5 <  styles.content.editPanelPage\r\n  20.9 = LOAD_REGISTER\r\n  20.9.maxImageWidth = {$pageCol.maxImageWidth}\r\n  20.10 < styles.content.get \r\n  20.20  < styles.content.lastUpdate\r\n  20.30 < styles.content.typo3_powered\r\n  20.40 = RESTORE_REGISTER\r\n}\r\n\r\npage.25 < temp.gap\r\npage.25.stdWrap.if.isTrue = {$enableGap2}\r\n\r\npage.30 = COA\r\npage.30.if.isTrue = {$rightCol.enable}\r\npage.30.wrap = <td bgcolor=\"{$rightCol.bgColor}\" valign=\"top\"> | </td>\r\npage.30 {\r\n  10 = IMAGE\r\n  10.file = {$file.sideimage}\r\n  10.wrap = | <br />\r\n  20 = OTABLE\r\n  20.offset = {$rightCol.offset}\r\n  20.tableParams = border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"95%\"\r\n  20.9 = LOAD_REGISTER\r\n  20.9.maxImageWidth = {$rightCol.maxImageWidth}\r\n  20.9.textStyle_face = {$rightCol.textStyle_face}\r\n  20.9.textStyle_size = {$rightCol.textStyle_size}\r\n  20.9.textStyle_color = {$rightCol.textStyle_color}\r\n  20.9.defaultHeaderType = {$rightCol.defaultHeaderType}\r\n  20.9.pageColor = {$rightCol.bgColor}\r\n\r\n  20.10 < styles.content.{$rightCol.borderContent}\r\n  20.11 = RESTORE_REGISTER\r\n}\r\n\r\npage.35 < temp.gap\r\npage.35.stdWrap.if.isTrue = {$enableGap3}\r\n\r\n\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\n\r\n\r\n','Standard-template\r\n\r\nThis template is a no-frame-template with a image-map menu in the top. \r\nContent may be displayed in a main column and a right column optionally. \r\nYou can define background-images and images in the border between columns.\r\n\r\nBest viewed in 4+ browsers.\r\n\r\n\r\n\r\n\r\n\r\n','');
INSERT INTO `static_template` VALUES (50,0,1054753309,956915453,'styles.gmenu.first','','styles.gmenu.first >\r\nstyles.gmenu.first {\r\n    # cat=menu/color; type=color; label=Menu background color1: (See below)\r\n  bgCol = #7b8ca5\r\n    # cat=menu/color; type=color; label=Menu background color2: You can define two background colors for this simple graphical menu. The menu items will be alternating between Color1 and Color2 as background color. But if these colors are the same, all menu items will have the same background of course.\r\n  bgCol2 < .bgCol\r\n\r\n    # cat=menu/typo; type=file[ttf]; label=Font file: TrueType (ttf) font for the menu.\r\n  file.fontFile = \r\n    # cat=menu/typo; type=int[1-40]; label=Font size: Font size on menu items\r\n  fontSize = 12\r\n    # cat=menu/typo; type=color; label=Font color: Font color on menu items\r\n  fontColor = white\r\n    # cat=menu/typo; type=offset; label=Text offset: Enter the offset of the text from the upper-left corner on the menu items\r\n  offset = 6,10\r\n    # cat=menu/typo; type=int[0-20]; label=Letter spacing: Enter the spacing between characters\r\n  spacing=1\r\n\r\n    # cat=menu/typo; type=boolean; label=Rollover: Click this option if you want a rollover (mouseover) effect on the menu items.\r\n  RO = 0\r\n    # cat=menu/typo; type=color; label=Rollover, font color: Enter the rollover font color of the text on the menu item.\r\n  RO.fontColor =\r\n    # cat=menu/color; type=color; label=Rollover, Menu background color: Background color of the menu-items when the mouse cursor moves over the item.\r\n  RO.bgCol = #608ca5\r\n\r\n    # cat=menu/typo; type=boolean; label=Active: Click this option if you want a \'Active\' effect on the menu items. \'Active\' means how the item looks when you\'re on that page or a subpage to that page.\r\n  ACT = 0\r\n    # cat=menu/typo; type=color; label=Active, font color: Enter the \'Active\' font color of the text on the menu item.\r\n  ACT.fontColor =\r\n    # cat=menu/color; type=color; label=Active, Menu background color:  Background color of the menu-items when \'Active\'.\r\n  ACT.bgCol = #7b7392\r\n\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Bullet image: You can define an imagefile to use as a bullet aligned to the right/top of all menu items except from the last item. This image should probably be a little gif-file with dimensions less than 20 pixels.\r\n  file.bullet =\r\n\r\n    # cat=menu//x; type=int[1-256]; label=Reduce colors: Number of indexed colors on menu items. If your menu items end up with weird colors, you can try to enter a higher number of colors. But the graphics-files will also increase their filesize.\r\n  reduceColors = 64\r\n    # cat=menu/dims; type=int+; label=Item Height: The height in pixels of the menu items\r\n  height = 14\r\n}\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.menu {\r\n  header = styles.gmenu.first\r\n  description = This is a simple GMENU object with a background color and some text on it. In addition you can add a bullet-image to the right of all items, except the last one.\r\n  image = gfx/FIRST_menu.gif\r\n  1=styles.gmenu.first.bgCol\r\n  2=styles.gmenu.first.bgCol2\r\n  3=styles.gmenu.first.file.bullet\r\n}\r\n\r\n','styles.gmenu.first >\r\nstyles.gmenu.first = GMENU\r\nstyles.gmenu.first.NO {\r\n  XY = [10.w]+[20.w]+12 , {$styles.gmenu.first.height}\r\n  backColor = |*| {$styles.gmenu.first.bgCol} || {$styles.gmenu.first.bgCol2} |*| \r\n  reduceColors = {$styles.gmenu.first.reduceColors}\r\n  10 = TEXT\r\n  10.text.field = nav_title // title\r\n  10.offset = {$styles.gmenu.first.offset} \r\n  10.fontColor = {$styles.gmenu.first.fontColor}\r\n  10.niceText = 1\r\n  10.fontSize = {$styles.gmenu.first.fontSize}\r\n  10.spacing = {$styles.gmenu.first.spacing}\r\n  10.fontFile = {$styles.gmenu.first.file.fontFile}\r\n\r\n  20 = IMAGE |*||*| _x_\r\n  20.file = {$styles.gmenu.first.file.bullet}\r\n  20.align = r,t\r\n}\r\n\r\nstyles.gmenu.first.RO < styles.gmenu.first.NO\r\nstyles.gmenu.first.RO = {$styles.gmenu.first.RO}\r\nstyles.gmenu.first.RO {\r\n  backColor = {$styles.gmenu.first.RO.bgCol}\r\n  10.fontColor = {$styles.gmenu.first.RO.fontColor}\r\n}\r\n\r\nstyles.gmenu.first.ACT < styles.gmenu.first.NO\r\nstyles.gmenu.first.ACT = {$styles.gmenu.first.ACT}\r\nstyles.gmenu.first.ACT {\r\n  backColor = {$styles.gmenu.first.ACT.bgCol}\r\n  10.fontColor = {$styles.gmenu.first.ACT.fontColor}\r\n}\r\n\r\n\r\n','This is a GMENU object. \r\nIt features the ability to add a bullet to the right side of the items, except the last item.\r\n\r\nUsed with template FIRST','');
INSERT INTO `static_template` VALUES (52,0,1054753896,960231290,'template; TU','53,43,68','  # cat=basic/file; type=file[IMAGE_EXT]; label=Top image: An image is placed as a banner all the way across the page in the top.\r\nfile.topImage = \r\n\r\n  # cat=basic/color/a; type=color; label=Background color: This is the <body>-tag background color of the page.\r\nbgCol = white\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = \r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = \r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = \r\n\r\n  # cat=basic/dims; type=offset; label= Page offset: Offset of the whole page-table from upper-left corner of the browser-window\r\npage.offset = 5,5\r\n  # cat=basic/dims; type=int+; label= Page content X-offset: Distance between the menu and the content\r\npage.contentOffset.X = 15\r\n  # cat=basic/dims; type=int+; label= Page content Y-offset: Distance between the top image and the content\r\npage.contentOffset.Y = 10\r\n  # cat=basic/dims; type=int+; label=Content width: This value defines the width in pixels of the table cell where the content is displayed\r\npage.contentWidth = 430\r\n\r\n\r\nPAGE_TARGET = \r\ncontent.pageFrameObj = \r\nstyles.content.imgtext.maxW = 400\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"TU\"\r\n  description = TU is a single-page template. You can define a topimage and background-images for the 2-level graphical menu to the left on the page. \r\n  bulletlist = Topimage (4) // Define the background-color of the page. (5)\r\n  image = gfx/TU_basic.gif\r\n\r\n  1=page.offset\r\n  2=page.contentOffset.X,page.contentOffset.Y\r\n  3=page.contentWidth,styles.content.imgtext.maxW\r\n  4=file.topImage\r\n  5=bgCol\r\n}\r\n\r\n','\r\npage = PAGE\r\npage.typeNum = 0\r\npage.bodyTagMargins = 0\r\npage.bodyTag < styles.content.bodyTag\r\n\r\npage.10 = OTABLE\r\npage.10 {\r\n  offset = {$page.offset}\r\n  10 = HTML\r\n  10.value = <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"1\"><tr><td colspan=\"3\">\r\n  20 = IMAGE\r\n  20.file = {$file.topImage}\r\n  20.linkWrap = <a href=\"index.php?{0}\"> |</a>\r\n  30 = HTML\r\n  30.value = </td></tr><tr><td width=\"1\" valign=\"top\" align=\"left\">\r\n\r\n  40 < styles.hmenu.tu\r\n\r\n  45 = HTML\r\n  45.value = </td><td width=\"1\" align=\"left\">\r\n\r\n  47 = CLEARGIF\r\n  47.width = {$page.contentOffset.X}\r\n\r\n  50 = HTML\r\n  50.value = </td><td valign=\"top\">\r\n\r\n  55 = CLEARGIF\r\n  55.height = {$page.contentOffset.Y}\r\n  55.wrap = | <br />\r\n\r\n  59 < styles.content.editPanelPage\r\n  60 < styles.content.get\r\n  65  < styles.content.lastUpdate\r\n  67  < styles.content.typo3_powered\r\n\r\n  70 = HTML\r\n  70.value = </td></tr>\r\n\r\n\r\n  75 = CLEARGIF\r\n  75.width = {$page.contentWidth}\r\n  75.wrap = <tr><td></td><td></td><td> | </td></tr></table>\r\n\r\n}\r\n\r\n\r\n\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\n\r\n\r\n\r\n\r\n\r\n','Standard-template\r\n\r\nNo-frames template with a logoimage in the top connected to a 2-level graphical menu to the left. \r\nContent is in one column only.\r\nBackground-images of each menu item - one for each level - can be defined as well as images in the top and bottom of the menubar.','');
INSERT INTO `static_template` VALUES (53,0,1054753410,960231947,'styles.hmenu.tu','','styles.hmenu.tu >\r\nstyles.hmenu.tu {\r\n    # cat=menu; type=int[0-5]; label=Advanced, entry level: This number defines which level in the pagetree is reflected as the first level in the menu. If 0 (zero) the menu will start with pages from the root of the website.\r\n  entryLevel = 0\r\n    # cat=menu/file/3; type=file[IMAGE_EXT]; label=Image before: The imagefile inserted before the items of the menu.\r\n  file.top = media/buttons/menutop.gif\r\n    # cat=menu/file/4; type=file[IMAGE_EXT]; label=Image after: The imagefile inserted after the items of the menu.\r\n  file.bottom = media/buttons/menubottom.gif\r\n\r\n    # cat=menu//x; type=int[0-256]; label=Reduce colors: Number of indexed colors on menu items. If your menu items end up with weird colors, you can try to enter a higher number of colors. But the graphics-files will also increase their filesize.\r\n  reduceColors = 64\r\n}\r\n\r\nstyles.hmenu.tu.L1 {\r\n    # cat=menu/file/1; type=file[IMAGE_EXT]; label=Level-1, Background image\r\n  file.bgImg = media/buttons/menulevel1.gif\r\n    # cat=menu/typo/1; type=file[ttf]; label=Level-1, Font file\r\n  file.fontFile =\r\n    # cat=menu/typo/1; type=color; label=Level-1, Font color\r\n  fontColor = black\r\n    # cat=menu/typo/1; type=int[1-40]; label=Level-1, Font size\r\n  fontSize = 12\r\n    # cat=menu/typo/1; type=offset; label=Level-1, Text offset: Enter the offset of the text from the upper-left corner of the menu items\r\n  offset = 15,15\r\n    # cat=menu/typo/1; type=color; label=Level-1, Rollover/Active: Enter the color of the text on the menu item when mouseover OR when the item is \"active\".\r\n  RO.fontColor = navy\r\n}\r\n\r\nstyles.hmenu.tu.L2 {\r\n    # cat=menu/file/2; type=file[IMAGE_EXT]; label=Level-2, Background image\r\n  file.bgImg = media/buttons/menulevel2.gif\r\n    # cat=menu/typo/2; type=file[ttf]; label=Level-2, Font file\r\n  file.fontFile =\r\n    # cat=menu/typo/2; type=color; label=Level-2, Font color\r\n  fontColor = black\r\n    # cat=menu/typo/2; type=int[1-40]; label=Level-2, Font size\r\n  fontSize = 10\r\n    # cat=menu/typo/2; type=offset; label=Level-2, Text offset: Enter the offset of the text from the upper-left corner of the menu items\r\n  offset = 30,8\r\n    # cat=menu/typo/2; type=color; label=Level-2, Rollover/Active: Enter the color of the text on the menu item when mouseover OR when the item is \"active\".\r\n  RO.fontColor = navy\r\n}\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.menu {\r\n  header= styles.hmenu.tu\r\n  description = The graphical menu has two levels with support for shifting font color when the mouse is rolled over the item. The rollover color is also used for the text on the item, when the page is \"active\" (you\'re on the page).\r\n  bulletlist = Background image for the 1st-level menuitems. Select Truetype-font, color, size and offset. Optionally select Rollover color. (1,5) // Background image for the 2nd-level menuitems. Select Truetype-font, color, size and offset. Optionally select Rollover color. (2,6) // Image in the top of the menu. This adds space from the topimage to the first menuitems. (3) // Image in the bottom of the menu. This ends the menu. (4)\r\n  image = gfx/TU_menu.gif\r\n  1=styles.hmenu.tu.L1.file.bgImg\r\n  2=styles.hmenu.tu.L2.file.bgImg\r\n  3=styles.hmenu.tu.file.top\r\n  4=styles.hmenu.tu.file.bottom\r\n  5=styles.hmenu.tu.L1.file.fontFile,styles.hmenu.tu.L1.fontColor,styles.hmenu.tu.L1.fontSize,styles.hmenu.tu.L1.offset,styles.hmenu.tu.L1.RO.fontColor\r\n  6=styles.hmenu.tu.L2.file.fontFile,styles.hmenu.tu.L2.fontColor,styles.hmenu.tu.L2.fontSize,styles.hmenu.tu.L2.offset,styles.hmenu.tu.L2.RO.fontColor\r\n}\r\n\r\n','\r\nstyles.hmenu.tu >\r\n\r\n# LEVEL 1:\r\nstyles.hmenu.tu = HMENU\r\nstyles.hmenu.tu.entryLevel = {$styles.hmenu.tu.entryLevel}\r\nstyles.hmenu.tu.1 = GMENU\r\nstyles.hmenu.tu.1.NO {\r\n  wrap = |<br />\r\n  XY = [10.w],[10.h]\r\n  reduceColors = {$styles.hmenu.tu.reduceColors}\r\n  10 = IMAGE\r\n  10.file = {$styles.hmenu.tu.L1.file.bgImg}\r\n  20 = TEXT\r\n  20 {\r\n    text.field = nav_title // title\r\n    fontFile = {$styles.hmenu.tu.L1.file.fontFile}\r\n    fontColor = {$styles.hmenu.tu.L1.fontColor}\r\n    fontSize = {$styles.hmenu.tu.L1.fontSize}\r\n    offset = {$styles.hmenu.tu.L1.offset}\r\n    niceText = 1\r\n  }\r\n}\r\nstyles.hmenu.tu.1.RO < styles.hmenu.tu.1.NO\r\nstyles.hmenu.tu.1.RO = 1\r\nstyles.hmenu.tu.1.RO.20.fontColor = {$styles.hmenu.tu.L1.RO.fontColor}\r\nstyles.hmenu.tu.1.ACT < styles.hmenu.tu.1.RO\r\nstyles.hmenu.tu.1.ACT = 1\r\n\r\n# LEVEL 2:\r\nstyles.hmenu.tu.2 = GMENU\r\nstyles.hmenu.tu.2.NO {\r\n  wrap = |<br />\r\n  XY = [10.w],[10.h]\r\n  reduceColors = {$styles.hmenu.tu.reduceColors}\r\n  10 = IMAGE\r\n  10.file = {$styles.hmenu.tu.L2.file.bgImg}\r\n  20 = TEXT\r\n  20 {\r\n    text.field = nav_title // title\r\n    fontFile = {$styles.hmenu.tu.L2.file.fontFile}\r\n    fontColor = {$styles.hmenu.tu.L2.fontColor}\r\n    fontSize = {$styles.hmenu.tu.L2.fontSize}\r\n    offset = {$styles.hmenu.tu.L2.offset}\r\n    niceText = 1\r\n  }\r\n}\r\nstyles.hmenu.tu.2.RO < styles.hmenu.tu.2.NO\r\nstyles.hmenu.tu.2.RO = 1\r\nstyles.hmenu.tu.2.RO.20.fontColor = {$styles.hmenu.tu.L2.RO.fontColor}\r\nstyles.hmenu.tu.2.ACT < styles.hmenu.tu.2.RO\r\nstyles.hmenu.tu.2.ACT = 1\r\n\r\n# Wrapping:\r\nstyles.hmenu.tu.stdWrap.innerWrap {\r\n  cObject = COA\r\n  cObject {\r\n    10 = IMAGE\r\n    10.file = {$styles.hmenu.tu.file.top}\r\n    10.wrap = |<br />\r\n    20 = TEXT\r\n    20.value = |\r\n    30 = IMAGE\r\n    30.file = {$styles.hmenu.tu.file.bottom}\r\n    30.wrap = |<br />\r\n  }\r\n}\r\n\r\n','Graphical menu, two levels.\r\n\r\nFeatures a simple menu with a rollover font color change and background image for each menu item on both levels.\r\n\r\nUsed with template TU','');
INSERT INTO `static_template` VALUES (54,0,1071663096,960237041,'template; BUSINESS','23,43,68','leftFrameWidth = 150\r\n\r\n  # cat=basic/color/a; type=color; label=Background color, page frame: This is the background color of the page in the right frame.\r\nbgCol = #dddddd\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = black\r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = gray\r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = black\r\n\r\nmenu {\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Background image, left frame:  Background image of the page in the left frame (menu frame)\r\n  file.bgImg = \r\n    # cat=basic/color/a; type=color; label=Background color, menu frame: This is the background color of the page in the left frame (menu frame).\r\n  bgCol = #c0c0c0\r\n\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Bullet on level-2\r\n  file.bullet = media/bullets/bullet1_n.gif\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Bullet on level-2, Rollover\r\n  file.bullet_RO = media/bullets/bullet1_h.gif\r\n\r\n    # cat=menu/typo; type=wrap; label=Wrap, level-1: This is the wrap-code around the menu page-titles on level-1\r\n  L0.fontWrap = <font face=\"Arial\" size=\"2\" color=\"black\"><b> |</b></font>\r\n    # cat=menu/typo; type=wrap; label=Wrap, level-2: This is the wrap-code around the menu page-titles on level-2\r\n  L1.fontWrap = <font face=\"Verdana\" size=\"1\" color=\"black\"> | </font>\r\n    # cat=menu/links; type=boolean; label=Link level-1?: You can enable links on the level-1 menu items, if you want these links to show a page. By default they don\'t.\r\n  L0.noLink = 0\r\n}\r\n\r\npage {\r\n   # cat=basic/file; type=file[IMAGE_EXT]; label=Background image, page frame\r\n  file.bgImg  =\r\n   # cat=basic/color; type=color; label=Color of horizontal line\r\n  lineCol = #666666\r\n   # cat=basic/typo; type=wrap; label=Wrap, Level-1 title: In the top of the page, the title of Level-1 in the menu is always shown. This is the wrap around that title.\r\n  L0.titleWrap = <b><font face=\"Verdana\" size=\"5\" color=\"#000066\"><i> | </i></font></b>\r\n   # cat=basic/typo; type=wrap; label=Wrap, Level-2 title: In the top of the page, the title of Level-2 in the menu is always shown. This is the wrap around that title.\r\n  L1.titleWrap = <font face=\"Verdana\" size=\"2\" color=\"#000066\"><b> | </b></font>\r\n   # cat=basic/dims/z1; type=int+; label=Thickness of horizontal line: Pixels\r\n  lineHeight = 2\r\n   # cat=basic/dims/z2; type=int[1-1000]; label=Menu, X-offset: Space between menu and left border of browserwindow\r\n  menuXDistance = 5\r\n   # cat=basic/dims/z2; type=int+; label=Menu, Y-offset: Space between menu and logo in left frame\r\n  menuYDistance = 0\r\n}\r\n\r\n # cat=basic/file; type=file[IMAGE_EXT]; label=Logo-file, menu frame: This is the logo-file inserted in the top of the menu frame.\r\nfile.logo = media/uploads/typologo.gif\r\n # cat=advanced; type=boolean; label=Logo-file, GIFBUILDER-obj: If this flag is true, the logo is rendered as a GIFBUILDER-gif and is fixed at 150x80 pixels. Else the image is just inserted (must be 150x80 pixels in order to fit nicely). Although the default value is \"true\" you probably want to disable this and make sure yourself that the logofile keeps the dimensions.\r\nGIFBUILDER_logo = 1\r\n\r\n # cat=basic/dims; type=int+; label=Content width: Enter the width of the table where the content is put. This should approx. be that same (little less) as the Max Image Width!\r\ncontentWidth = 500\r\n # cat=basic/dims; type=offset; label=Content Offset: Enter the offset in pixels by which the content is offset from top-left. \r\ncontentOffset = 10,10\r\n\r\nstyles.content.imgtext.maxW = 500\r\nstyles.content.typo3_powered.number=1\r\n\r\nPAGE_TARGET = page\r\ncontent.pageFrameObj = page\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"BUSINESS\"\r\n  description = BUSINESS is a framebased template in a very simple layout, based on text. There are 2 frames; a menuframe (to the left) and a page-frame.   \r\n  bulletlist = Left-frame image in the top. The dimensions are fixed to 150 x 80 pixels (normally you are free to choose the dimensions yourself!) (4) //2-level textual menu. Select: font-teg-properties like face, size and color for each level. Select: graphical bullet for the 2nd level and optionally a mouseover-bullet. //The pagetitles of the 1st and 2nd level for a given page is displayed in the top. Select font-tag-properties for each title (like with the menus)  (5 and 6) //Define background-images of each frame, the left and page frame. Also select the width of the left frame. (1) //Optional ruler across the page. Select the color. (8)\r\n  image = gfx/BUSINESS_basic.gif\r\n  1=leftFrameWidth,menu.file.bgImg,menu.bgCol\r\n  2=page.file.bgImg,bgCol\r\n  3=contentOffset\r\n  4=file.logo\r\n  5=page.L0.titleWrap\r\n  6=page.L1.titleWrap\r\n  7=contentWidth,styles.content.imgtext.maxW\r\n  8=page.lineCol\r\n}\r\nTSConstantEditor.menu {\r\n  description = \r\n  image = gfx/BUSINESS_menu.gif\r\n  1=menu.L0.fontWrap,menu.L0.noLink\r\n  2=menu.L1.fontWrap\r\n  3=menu.file.bullet\r\n  4=menu.file.bullet_RO\r\n}\r\n\r\n','temp.leftmenu = HMENU\r\ntemp.leftmenu.1 = TMENU\r\ntemp.leftmenu.1.target = page\r\ntemp.leftmenu.1 {\r\n  expAll = 1\r\n  wrap = <table width=\"300\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td><img src=\"clear.gif\" width=\"1\" hspace=\"200\" height=\"1\" vspace=\"3\" border=\"0\" alt=\"\" /></td></tr> | </table>\r\n  NO.linkWrap = {$menu.L0.fontWrap}\r\n  NO.doNotLinkIt = {$menu.L0.noLink}\r\n  NO.allWrap = <tr><td><img src=\"clear.gif\" width=\"1\" height=\"1\" vspace=\"3\" border=\"0\" alt=\"\" /><br /> | </td></tr>\r\n}\r\ntemp.leftmenu.2 = TMENU\r\ntemp.leftmenu.2 {\r\n  wrap = <tr><td nowrap=\"nowrap\"> | </td></tr>\r\n  target = page\r\n  NO {\r\n    beforeImg =  {$menu.file.bullet}\r\n    beforeROImg = {$menu.file.bullet_RO}\r\n    beforeImgTagParams = hspace=\"2\"\r\n    RO = 1\r\n    after = <br />\r\n    ATagBeforeWrap = 1\r\n    linkWrap= {$menu.L1.fontWrap}\r\n  }\r\n}\r\n\r\n\r\n\r\nleft.bgImg = {$menu.file.bgImg}\r\nleft.bodyTag = <body bgcolor=\"{$menu.bgCol}\" alink=\"{$alink}\" vlink=\"{$vlink}\" link=\"{$link}\">\r\nleft.noLinkUnderline = 1\r\n\r\nleft.70.if.isTrue = {$GIFBUILDER_logo}\r\nleft.70 = IMAGE\r\nleft.70.file = GIFBUILDER\r\nleft.70.file {\r\n  XY = 150,80\r\n  backColor = {$menu.bgCol} \r\n  10 = IMAGE\r\n  10.file = {$file.logo}\r\n}\r\nleft.70.params = \r\nleft.70.wrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td colspan=\"2\"> | </td></tr>\r\nleft.70.linkWrap = <a href=\"index.php?{0}\" target=\"_top\"> | </a>\r\n\r\nleft.75.if.isTrue = {$GIFBUILDER_logo}\r\nleft.75.if.negate = 1\r\nleft.75 = IMAGE\r\nleft.75.file = {$file.logo}\r\nleft.75.params = \r\nleft.75.wrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td colspan=\"2\"> | </td></tr>\r\nleft.75.linkWrap = <a href=\"index.php?{0}\" target=\"_top\"> | </a>\r\n\r\nleft.80 = HTML\r\nleft.80.value = <tr><td></td><td bgcolor=\"{$page.lineCol}\"><img src=\"clear.gif\" width=\"1\" height=\"{$page.lineHeight}\" border=\"0\" alt=\"\" /></td></tr>    \r\nleft.80.value.if.isTrue = {$page.lineHeight}\r\n\r\nleft.90 = HTML\r\nleft.90.value = <tr><td><img src=\"clear.gif\" width=\"{$page.menuXDistance}\" height=\"1\" border=\"0\" alt=\"\" /></td><td>\r\nleft.95 = CLEARGIF\r\nleft.95.height={$page.menuYDistance}\r\nleft.100 < temp.leftmenu\r\nleft.110 = HTML\r\nleft.110.value = </td></tr></table>\r\n\r\n\r\npage.bgImg = {$page.file.bgImg}\r\npage.bodyTag < styles.content.bodyTag\r\npage.10 = COBJ_ARRAY\r\npage.10 {\r\n  wrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"2\"><tr><td><img src=\"clear.gif\" width=\"1\" height=\"1\" border=\"0\" alt=\"\" /></td><td><img src=\"clear.gif\" hspace=\"200\" width=\"1\" height=\"1\" border=\"0\" alt=\"\" /></td></tr> | </table>\r\n  1 = COBJ_ARRAY\r\n  1 {\r\n    wrap = <tr><td><img src=\"clear.gif\" width=\"1\" vspace=\"39\" height=\"1\" border=\"0\" alt=\"\" /></td><td valign=\"top\"> | </td></tr>\r\n    1 = HTML\r\n    1.value = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td><img src=\"clear.gif\" width=\"1\" hspace=\"10\" vspace=\"7\" height=\"1\" border=\"0\" alt=\"\" /></td><td><img src=\"clear.gif\" width=\"1\" hspace=\"40\" height=\"1\" border=\"0\" alt=\"\" /></td><td><img src=\"clear.gif\" width=\"1\" height=\"1\" border=\"0\" alt=\"\" /></td></tr><tr><td></td><td colspan=\"2\">\r\n\r\n    5 = TEXT\r\n    5.data = levelTitle:1\r\n    5.wrap = {$page.L0.titleWrap}\r\n\r\n    10 = HTML\r\n    10.value = </td></tr><tr><td></td><td></td><td>\r\n\r\n    15 = TEXT\r\n    15.data = levelTitle:2\r\n    15.wrap = {$page.L1.titleWrap}\r\n    20 = HTML\r\n    20.value = </td></tr></table>\r\n  }\r\n\r\n  10 = HTML\r\n  10.value = <tr><td colspan=\"2\" bgcolor=\"{$page.lineCol}\"><img src=\"clear.gif\" width=\"1\" height=\"2\" border=\"0\" alt=\"\" /></td></tr>\r\n  10.value.if.isTrue = {$page.lineHeight}\r\n\r\n  15 = TEXT\r\n  15.value = <tr><td colspan=\"2\" valign=\"top\">\r\n\r\n  20 = CTABLE\r\n  20.c.5 < styles.content.editPanelPage\r\n  20.c.10 < styles.content.get\r\n  20.c.20  < styles.content.lastUpdate\r\n  20.c.30  < styles.content.typo3_powered\r\n  20.cWidth={$contentWidth}\r\n  20.offset = {$contentOffset}\r\n  \r\n  30 = TEXT\r\n  30.value = </td></tr>\r\n}\r\n\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\nframeset.headerData.999 < plugin.meta\r\n\r\n','Standard-template\r\n\r\nThis template is a frame-based template with a textbased menu (2 levels) in the left frame. \r\nIn the top of the left frame you can place a logo. The top of the page-frame displays the title of the current page.\r\n\r\nContent is displayed in only one column.\r\nYou can define background-images in the frames.\r\n','');
INSERT INTO `static_template` VALUES (57,0,1054752459,961515307,'cSet (default)','','# *******************************\r\n# *** Overriding constants\r\n# *******************************\r\n\r\n\r\ncontent {\r\n  defaultHeaderType = 1\r\n  wrap.header1 = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size3}\" color=\"{$cSet.color}\"><b> | </b></font>\r\n  wrap.header2 = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size2}\" color=\"{$cSet.color1}\"><b> | </b></font>\r\n  wrap.header3 = <font face=\"{$cSet.fontFace}\" size=\"4\" color=\"{$cSet.color}\"><b> | </b></font>\r\n  wrap.header4 = <font face=\"{$cSet.fontFace}\" size=\"5\" color=\"{$cSet.color}\"><b> | </b></font>\r\n\r\n  case.header1 = \r\n  case.header2 = \r\n\r\n  wrap2.header1 = \r\n  wrap2.header2 = \r\n  wrap2.header3 = \r\n\r\n  wrap.headerDate = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size1}\" color=\"{$cSet.color2}\"><b>|:</b></font><br />\r\n\r\n  defaultSubHeaderType = 3\r\n  wrap.subheader1 = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size2}\" color=\"{$cSet.color}\"> | </font>\r\n  wrap.subheader2 = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size1}\" color=\"{$cSet.color}\"><b> | </b></font>\r\n  wrap.subheader3 = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size1}\" color=\"{$cSet.color2}\"><b> | </b></font>\r\n\r\n  headerSpace = 0|5\r\n  space = 0|10\r\n  wrap.bodytext = |<br />\r\n  linkToTop = <div align=\"right\"><a href=\"#top\"><font color=\"{$cSet.color2}\" face=\"{$cSet.fontFace}\" size=\"{$cSet.size1}\"><b>To top</b></font></a></div><br />\r\n  menuWrap = <b><font color=\"{$cSet.color2}\" face=\"{$cSet.fontFace}\" size=\"{$cSet.size2}\"> | </font></b>\r\n  subMenuWrap = <b><font color=\"{$cSet.color1}\" face=\"{$cSet.fontFace}\" size=\"{$cSet.size1}\"> | </font></b>\r\n  tableCellColor = {$cSet.tableCellColor}\r\n  tableCellWrap = <b>|</b>\r\n  splash.bgCol = {$cSet.pageColor}\r\n}\r\n\r\n\r\nstyles.content.textStyle {\r\n  face = {$cSet.fontFace.text}\r\n  size = {$cSet.size2}\r\n  color =  {$cSet.color}\r\n  color1 = {$cSet.color1}\r\n  color2 = {$cSet.color2}\r\n}\r\n\r\nstyles.content.tableStyle {\r\n  color1 = {$cSet.color1}\r\n  color2 = {$cSet.color2}\r\n}\r\n\r\nstyles.content.links.wrap = <b>|</b>\r\nstyles.content.links.sword = <font color=\"red\"><b>|</b></font>\r\n\r\nstyles.content.uploads.wrap  < content.menuWrap\r\n\r\nstyles.content.frames {\r\n  1.bgCol = {$cSet.tableCellColor}\r\n  2.bgCol = {$cSet.tableCellColor}\r\n  2.borderCol = {$cSet.color}\r\n  2.borderThickness = 1\r\n  ruler.lineColor = {$cSet.color}\r\n}\r\n\r\nstyles.content.imgFrames {\r\n  bgCol = {$cSet.pageColor}\r\n  bottomCol = black\r\n}\r\n\r\nstyles.content.imgtext {\r\n  captionWrap = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size1}\" color=\"{$cSet.color1}\"><b> | </b></font>\r\n}\r\n\r\nstyles.content.mailform {\r\n  fieldWrap = \r\n  labelWrap = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size2}\" color=\"{$cSet.color}\"><b> | </b></font>\r\n  radioWrap = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size1}\" color=\"{$cSet.color}\"><b> | </b></font>\r\n  REQ.labelWrap = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size2}\" color=\"{$cSet.color2}\"><b> | </b></font>\r\n  border = 5\r\n}\r\n\r\nstyles.content.searchresult {\r\n  face = {$cSet.fontFace}\r\n  size = {$cSet.size2}\r\n  color = {$cSet.color2}\r\n  head.face = {$cSet.fontFace}\r\n  head.size = {$cSet.size3}\r\n  header.wrap = <font face=\"{$cSet.fontFace}\" size=\"{$cSet.size3}\" color=\"{$cSet.color2}\"><b> | </b></font>\r\n  header.bgCol = {$cSet.tableCellColor}\r\n}\r\n\r\nstyles.sitemap.text {\r\n  target = \r\n  itemWrap < content.menuWrap\r\n}\r\n\r\n\r\nstyles.header.gfx1 {\r\n  bgCol = {$cSet.pageColor}\r\n  fontColor = {$cSet.color1}\r\n}\r\n\r\n\r\n\r\n\r\n## Main configuration:\r\n\r\n  # cat=cSet/color/1; type=color; label=Background color of page: This also affects the background color of graphical headers and frames on images.\r\ncSet.pageColor = white\r\n # cat=cSet/color/2; type=color; label=Tablecells: Color of tablecells in content element \"Tables\", Background color for the frameoption of content elements, Searchresult header background color\r\ncSet.tableCellColor = yellow\r\n # cat=cSet/color/3; type=color; label= \"black\"-color: Defines the color of all kinds of things, that normally have a dark color. Like headers, borderlines and such. Should be a dark color.\r\ncSet.color = black\r\n # cat=cSet/color/4; type=color; label= Primary alternative color: Used for eg. header layout 2 and 5, Image captions and as \"Color 1\" in color selectors\r\ncSet.color1 = green\r\n # cat=cSet/color/5; type=color; label= Secondary alternative color: Used for searchresults, \"To top\"-link, Headerdate, Subheader 3, content element \"Menu\", \"Required\" color in forms, and as \"Color 2\" in color selectors\r\ncSet.color2 = red\r\n # cat=cSet/typo/1; type=small; label= Primary FontFace: The fontface used almost everywhere in <font>-tags. Exceptions are bodytext. Examples: \"Times\", \"Verdana\", \"Arial\"\r\ncSet.fontFace = Arial\r\n # cat=cSet/typo/2; type=small; label= Text FontFace: Used for the content bodytext\r\ncSet.fontFace.text = Arial\r\n\r\n # cat=cSet/typo/3; type=int[1-5]; label= Fontsize 1: Used for Headerdate, Subheader 2 and 3, \"Link to top\", Image captions and text for radiobuttons in forms\r\ncSet.size1 = 1\r\n # cat=cSet/typo/4; type=int[1-5]; label= Fontsize 2: Used for Bodytext, Header 2, Subheader 1, content element \"Menu\", Labels for forms and searchresults.\r\ncSet.size2 = 2\r\n # cat=cSet/typo/5; type=int[1-5]; label= Fontsize 3: Used for Header 1 and headers in search-results.\r\ncSet.size3 = 3\r\n\r\n\r\n\r\nTSConstantEditor.cset {\r\n  header = Constant definitions\r\n  description = CSET is a small collection of constants that substitutes other constants throughout the templates. // When you include the \"cSet\" static_template, you can focus on a few major configurations like the general colors and font faces used. These values are then globally substituted by the \"cSet\"-constants.// //\"cSet\" Contains ONLY definition of constants and is meant to be included in templates AFTER the content-rendering-template (eg. \"Content (default)\") is included. Often it\'s included in the final template after inclusion of the standard template. These constants overrides constants in static template \"content (default)\" and the included templates of this template. // The point of this template is to simplify configuration of content-rendering by providing a collection of constants which is used in other constants. Makes it easy to choose the same color or font throughout a template.\r\n}\r\n','','Constant definitions\r\n\r\nContains ONLY definition of constants and is meant to be included in templates AFTER the content-rendering-template (eg. \"Content (default)\") is included. Often it\'s included in the final template after inclusion of the standard template.\r\n\r\nThese constants overrides constants in static template \"content (default)\" and the included templates of this template.\r\n\r\nThe point of this template is to simplify configuration of content-rendering by providing a collection of constants which is used in other constants. Makes it easy to chose the same color or font throughout a template\r\n\r\nSee the constants present AFTER  \"## Main configuration:\" in the constants-field!\r\n\r\nStatus:\r\nChanged 28-06-2000\r\n','');
INSERT INTO `static_template` VALUES (58,0,1054753334,983214718,'styles.gmenu.first (EXT1)','','styles.gmenu.first.button.file {\r\n    # cat=menu/file/x1; type=file[IMAGE_EXT]; label=EXTENSION, Left image: This image is placed to the left on the menu items. NOTE: This image decides the height of the menu items!\r\n  left = media/buttons/left.gif\r\n    # cat=menu/file/x1; type=file[IMAGE_EXT]; label=EXTENSION, Tiled image: This image is tiled horizontally over the background on the menu items.\r\n  middle = media/buttons/middle.gif\r\n    # cat=menu/file/x1; type=file[IMAGE_EXT]; label=EXTENSION, Right image: This image is placed to the right on the menu items.\r\n  right = media/buttons/right.gif\r\n}\r\n\r\nstyles.gmenu.first.RO.button.file {\r\n    # cat=menu/file/x2; type=file[IMAGE_EXT]; label=EXTENSION, Rollover, Left image: This image is placed to the left on the menu items. NOTE: This image decides the height of the menu items!\r\n  left = media/buttons/left_ro.gif\r\n    # cat=menu/file/x2; type=file[IMAGE_EXT]; label=EXTENSION, Rollover, Tiled image: This image is tiled horizontally over the background on the menu items.\r\n  middle = media/buttons/middle_ro.gif\r\n    # cat=menu/file/x2; type=file[IMAGE_EXT]; label=EXTENSION, Rollover, Right image: This image is placed to the right on the menu items.\r\n  right = media/buttons/right_ro.gif\r\n}\r\n\r\nstyles.gmenu.first.ACT.button.file {\r\n    # cat=menu/file/x3; type=file[IMAGE_EXT]; label=EXTENSION, Active, Left image: This image is placed to the left on the menu items. NOTE: This image decides the height of the menu items!\r\n  left = media/buttons/left_ro.gif\r\n    # cat=menu/file/x3; type=file[IMAGE_EXT]; label=EXTENSION, Active, Tiled image: This image is tiled horizontally over the background on the menu items.\r\n  middle = media/buttons/middle_ro.gif\r\n    # cat=menu/file/x3; type=file[IMAGE_EXT]; label=EXTENSION, Active, Right image: This image is placed to the right on the menu items.\r\n  right = media/buttons/right_ro.gif\r\n}\r\n\r\n    # cat=\r\nstyles.gmenu.first.height = \r\n\r\n\r\n  # cat=basic/enable; type=comment; label=[FIRST-template] GMENU EXTENSION: Click this to enable the gmenu-extension for the \"FIRST\" static template. Only do this, if you have included \"styles.gmenu.first (EXT1)\" with the FIRST template!\r\npage.first_gmenu_extension = #\r\n','styles.gmenu.first = GMENU\r\nstyles.gmenu.first.NO {\r\n  XY = [10.w]+[20.w]+[5.w]+[6.w] , [5.h]\r\n\r\n  4 = IMAGE\r\n  4.file = {$styles.gmenu.first.button.file.middle}\r\n  4.tile = 10,1\r\n  5 = IMAGE\r\n  5.file = {$styles.gmenu.first.button.file.left}\r\n  6 = IMAGE\r\n  6.file = {$styles.gmenu.first.button.file.right}\r\n  6.align = r,t\r\n  6.offset = -[20.w]\r\n}\r\n\r\nstyles.gmenu.first.RO {\r\n  XY = [10.w]+[20.w]+[5.w]+[6.w] , [5.h]\r\n\r\n  4 = IMAGE\r\n  4.file = {$styles.gmenu.first.RO.button.file.middle}\r\n  4.tile = 10,1\r\n  5 = IMAGE\r\n  5.file = {$styles.gmenu.first.RO.button.file.left}\r\n  6 = IMAGE\r\n  6.file = {$styles.gmenu.first.RO.button.file.right}\r\n  6.align = r,t\r\n  6.offset = -[20.w]\r\n}\r\n\r\nstyles.gmenu.first.ACT {\r\n  XY = [10.w]+[20.w]+[5.w]+[6.w] , [5.h]\r\n\r\n  4 = IMAGE\r\n  4.file = {$styles.gmenu.first.ACT.button.file.middle}\r\n  4.tile = 10,1\r\n  5 = IMAGE\r\n  5.file = {$styles.gmenu.first.ACT.button.file.left}\r\n  6 = IMAGE\r\n  6.file = {$styles.gmenu.first.ACT.button.file.right}\r\n  6.align = r,t\r\n  6.offset = -[20.w]\r\n}\r\n\r\n\r\n\r\n{$page.first_gmenu_extension} top.20.1 < styles.gmenu.first\r\n{$page.first_gmenu_extension} top.40.1 < styles.gmenu.first\r\n{$page.first_gmenu_extension} bottom.40.1 < styles.gmenu.first\r\n\r\n','styles.gmenu.first - extension:\r\n\r\nThis modification adds support for a graphics in the back of the buttons. This works by incorporating 3 gif-files. One for the left end, one for the right end and finally one for the background. The background gif MUST be tileable in the horizontal direction.\r\n\r\nCHANGES:\r\n- the height of the buttons is now defined by the height of the gif-file at the left-end.\r\n- before the button had an extra 12 pixels width in addition to the width of the text and end-bullet. This is discarded. This just means, that you should probably adjust the offset of the text again.\r\n- You may need to re-create the end-bullet because the tiled background may appear \"below\" it.\r\n\r\nHOW-TO:\r\n- create 3 gif-files, one for left, right and middle. Upload them as resources to the template and enter their filenames as the constants you see above.\r\n- remember that the \"middle\"-file is tiled 10 times in the horizontal direction!\r\n\r\n\r\nUSE THE NEW GMENU-object with the FIRST template:\r\n\r\nIf you want to use this with the standard template FIRST, you should put this in the \"Setup\" field of your template. These will copy the new styles.gmenu.first-object into the right positions in the object-tree of the template:\r\n\r\n\r\n','');
INSERT INTO `static_template` VALUES (59,0,1054753433,983217378,'styles.hmenu.tu (EXT1)','','styles.hmenu.tu.L3 {\r\n    # cat=menu/file/3; type=file[IMAGE_EXT]; label=Level-3, Background image\r\n  file.bgImg = media/buttons/menulevel2.gif\r\n    # cat=menu/typo/3; type=file[ttf]; label=Level-3, Font file\r\n  file.fontFile =\r\n    # cat=menu/typo/3; type=color; label=Level-3, Font color\r\n  fontColor = black\r\n    # cat=menu/typo/3; type=int[1-40]; label=Level-3, Font size\r\n  fontSize = 10\r\n    # cat=menu/typo/3; type=offset; label=Level-3, Text offset: Enter the offset of the text from the upper-left corner of the menu items\r\n  offset = 40,8\r\n    # cat=menu/typo/3; type=color; label=Level-3, Rollover/Active: Enter the color of the text on the menu item when mouseover OR when the item is \"active\".\r\n  RO.fontColor = navy\r\n}\r\n\r\n  # cat=basic/enable; type=comment; label=[TU-template] 3rd LEVEL EXTENSION: Click this to enable the 3rd level extension for the \"TU\" static template. Only do this, if you have included \"styles.hmenu.tu (EXT1)\" with the TU template!\r\npage.tu_thirdLevel_extension = #\r\n','# LEVEL 3:\r\nstyles.hmenu.tu.3 = GMENU\r\nstyles.hmenu.tu.3.NO {\r\n  wrap = |<br />\r\n  XY = [10.w],[10.h]\r\n  reduceColors = {$styles.hmenu.tu.reduceColors}\r\n  10 = IMAGE\r\n  10.file = {$styles.hmenu.tu.L3.file.bgImg}\r\n  20 = TEXT\r\n  20 {\r\n    text.field = nav_title // title\r\n    fontFile = {$styles.hmenu.tu.L3.file.fontFile}\r\n    fontColor = {$styles.hmenu.tu.L3.fontColor}\r\n    fontSize = {$styles.hmenu.tu.L3.fontSize}\r\n    offset = {$styles.hmenu.tu.L3.offset}\r\n    niceText = 1\r\n  }\r\n}\r\nstyles.hmenu.tu.3.RO < styles.hmenu.tu.3.NO\r\nstyles.hmenu.tu.3.RO = 1\r\nstyles.hmenu.tu.3.RO.20.fontColor = {$styles.hmenu.tu.L3.RO.fontColor}\r\nstyles.hmenu.tu.3.ACT < styles.hmenu.tu.3.RO\r\nstyles.hmenu.tu.3.ACT = 1\r\n\r\n\r\n\r\n\r\n{$page.tu_thirdLevel_extension} page.10.40 < styles.hmenu.tu\r\n\r\n','This is an extension to styles.hmenu.tu. This extension includes a third level on the menu. Normally there are only two levels.\r\n','');
INSERT INTO `static_template` VALUES (60,0,1054753001,983227081,'plugin.postit1','','','## POST-IT\r\nplugin.postit1 >\r\nplugin.postit1 = PHP_SCRIPT\r\nplugin.postit1 {\r\n  file = media/scripts/postit.inc\r\n  data.field = bodytext\r\n  images.1 = IMAGE\r\n  images.1.file = GIFBUILDER\r\n  images.1.file {\r\n    XY = [5.w],[5.h]\r\n    5 = IMAGE\r\n    5.file = media/uploads/postit_1.gif\r\n    100 = TEXT\r\n    100.text = Testing\r\n    100.offset = -5,60\r\n    100.fontFile = fileadmin/fonts/arial_bold.ttf\r\n    100.fontSize = 15\r\n    100.align=center\r\n  }\r\n  images.2 < .images.1\r\n  images.2.file.5.file = media/uploads/postit_2.gif\r\n  images.2.file.100.angle = 11\r\n  images.2.file.100.offset = -2,79\r\n  images.3 < .images.1\r\n  images.3.file.5.file = media/uploads/postit_3.gif\r\n  images.3.file.100.angle = -13\r\n  images.3.file.100.offset = -7,81\r\n\r\n  cols = 3\r\n  textBox {\r\n    chars = 16\r\n    lineDist = 18\r\n    tmplObjNumber = 100\r\n    Valign = center\r\n    maxLines = 5\r\n  }\r\n  typolink {\r\n    parameter.current = 1\r\n    extTarget = {$styles.content.links.extTarget}\r\n    target = {$styles.content.links.target}\r\n  }\r\n}\r\n','PLUGIN: Post-it notes\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n\r\nHow to activate this:\r\n- Just include this static template in your template provided that the static template \"content (default)\" is already included ranging higher in the list. That\'s all.\r\n\r\nHow to put a post-it note on a page:\r\n- Create a content element of the type \"Textbox\"\r\n- Select \"the other\" type to be \"postit 1\"\r\n- Now, every line in the bodytext-field represents a postit note.\r\n- The lines are splitted by a \"|\" (like tablecells are); The first part is the text, the second part is the kind (1-3) and the last part is the link (typolink).\r\n\r\nExample:\r\n\r\nThis is a postit note! | 2 | 77\r\n\r\n... this line would create a postit note of type 2 (rotated left), write the text \"This is a postit note\" on it and let it be a link to the page with id=77.','');
INSERT INTO `static_template` VALUES (61,0,1054753188,983438903,'plugin.tt_products [DEPRECIATED]','','plugin.tt_products {\r\n    # cat=plugin.products/file; type=file[html,htm,tmpl,txt]; label= Template File: This is a simple textfile where each part of the shopping basket is defined with HTML-code. To see an example with explanations, take a look at media/scripts/products_template.tmpl which is the default.\r\n  file.templateFile = media/scripts/products_template.tmpl\r\n    # cat=plugin.products/file; type=file[IMAGE_EXT]; label= Alternative Image: This image is used if there is no image present for the product\r\n  file.noImageAvailable =\r\n\r\n    # cat=plugin.products/typo; type=wrap; label= Wrap 1: This wrap is used in the template-file.\r\n  wrap1 = <font face=\"verdana\" size=\"2\" color=\"black\"> | </font>\r\n    # cat=plugin.products/typo; type=wrap; label= Wrap 2: This wrap is used in the template-file.\r\n  wrap2 = <font face=\"verdana\" size=\"1\" color=\"black\"> | </font>\r\n\r\n    # cat=plugin.products/color; type=color; label= Color 1: This bgcolor is used in the template-file.\r\n  color1 = #cccccc\r\n    # cat=plugin.products/color; type=color; label= Color 2: This bgcolor is used in the template-file.\r\n  color2 = #999999\r\n    # cat=plugin.products/color; type=color; label= Color 3: This bgcolor is used in the template-file.\r\n  color3 = #333333\r\n\r\n    # cat=plugin.products//; type=boolean; label= Click Enlarge, Single display: If this option is set, users can click the image of a product and it\'ll pop-up in a separate window at a larger size.\r\n  clickEnlarge = 1\r\n    # cat=plugin.products//; type=boolean; label= Click Enlarge, List display: As above, but for the images in the product-lists and search-results\r\n  clickEnlarge_list = 1\r\n    # cat=plugin.products//; type=boolean; label= Click Enlarge, Basket display: As above, but for the images in the basket\r\n  clickEnlarge_basket = 1\r\n\r\n    # cat=plugin.products//; type=boolean; label= Display Category Header in list: If this option is set, the category headers (page titles) will automatically be displayed in the product lists. This is not always convenient because you might have chosen a header-title for the \"list\" content element.\r\n  displayListCatHeader = 1\r\n    # cat=plugin.products//; type=boolean; label= Display Category Header in basket: If this option is set, the category headers (page titles) will automatically be displayed in the basket lists.\r\n  displayBasketCatHeader = 0\r\n\r\n    # cat=plugin.products//; type=int+; label= Max items displayed: The maximum number of items displayed on one page. \r\n  limit = 50\r\n\r\n    # cat=plugin.products/dims; type=int+; label= Max image width, single display: The maximum width in pixels of an image when displayed with a single product.\r\n  maxW_single = 200\r\n    # cat=plugin.products/dims; type=int+; label= Max image width, list display: The maximum width in pixels of an image when displayed in lists and searchresults.\r\n  maxW_list = 50\r\n    # cat=plugin.products/dims; type=int+; label= Max image width, basket display: The maximum width in pixels of an image when displayed in the shopping-basket.\r\n  maxW_basket = 100\r\n\r\n    # cat=plugin.products//; type=int+; label=PID for single item display: If you want a certain page to be used for display of item details, please enter the PID (page-uid) here.\r\n  PIDitemDisplay =\r\n    # cat=plugin.products//; type=int+; label=PID for search page: If you want all product searches to go to a specific page, enter the PID it here! NOTE: If you set this PID, all searchqueries will (must) be handled with a list content element with the code \"search\" on that page.\r\n  PIDsearch =\r\n    # cat=plugin.products//; type=int+; label=PID for basket page: If you want every change in the number of items anywhere to go to a specific page (eg. the shopping basket page), enter the PID here.\r\n  PIDbasket =\r\n    # cat=plugin.products//; type=int+; label=PID for store root: This is the PID of the rootPage of the store. If not set the store will operate over all pages from the root of the site. But if the site has many pages, performance may improve\r\n  PIDstoreRoot = \r\n\r\n    # cat=plugin.products//; type=small; label=TAX percentage: Type= Double (means, \"use . as decimal point\")\r\n  TAXpercentage = 25\r\n\r\n    # TAX included in database prices?\r\n  TAXincluded = 1\r\n    # Price decimals\r\n  priceDec = 2\r\n\r\n    # cat=plugin.products//; type=small; label=Price decimal point\r\n  priceDecPoint = .\r\n    # cat=plugin.products//; type=small; label=Price Thousand point\r\n  priceThousandPoint = \r\n}\r\n\r\n','## Includes the productsLib:\r\nincludeLibs.ts_products = media/scripts/productsLib.inc\r\n\r\n\r\n## This enables the tt_content.list item to display the guestbook:\r\nplugin.tt_products >\r\nplugin.tt_products = USER\r\nplugin.tt_products {\r\n  userFunc = user_products->main_products\r\n\r\n  templateFile = {$plugin.tt_products.file.templateFile}\r\n  pid_list.field = pages\r\n  recursive.field = recursive\r\n  code.field = select_key\r\n\r\n  limit = {$plugin.tt_products.limit}\r\n  image {\r\n    file.maxW = {$plugin.tt_products.maxW_single}\r\n    imageLinkWrap = {$plugin.tt_products.clickEnlarge}\r\n    imageLinkWrap {\r\n      enable = 1\r\n      bodyTag = <body bgcolor=\"black\">\r\n      wrap = <a href=\"javascript:close();\"> | </a>\r\n      width = 400m\r\n      height = 400\r\n\r\n      JSwindow = 1\r\n      JSwindow.newWindow = 1\r\n      JSwindow.expand = 17,20\r\n    }\r\n  }\r\n  listImage < .image\r\n  listImage.file.maxW = {$plugin.tt_products.maxW_list}\r\n  listImage.imageLinkWrap = {$plugin.tt_products.clickEnlarge_list}\r\n\r\n  basketImage < .image\r\n  basketImage.file.maxW = {$plugin.tt_products.maxW_basket}\r\n  basketImage.imageLinkWrap = {$plugin.tt_products.clickEnlarge_basket}\r\n\r\n  image.wrap = | <br />\r\n\r\n  noImageAvailable = {$plugin.tt_products.file.noImageAvailable}\r\n\r\n  wrap1.wrap = {$plugin.tt_products.wrap1}\r\n  wrap2.wrap = {$plugin.tt_products.wrap2}\r\n  color1.wrap = {$plugin.tt_products.color1}\r\n  color2.wrap = {$plugin.tt_products.color2}\r\n  color3.wrap = {$plugin.tt_products.color3}\r\n\r\n  displayListCatHeader = {$plugin.tt_products.displayListCatHeader}\r\n  displayBasketCatHeader = {$plugin.tt_products.displayBasketCatHeader}\r\n\r\n  PIDitemDisplay = {$plugin.tt_products.PIDitemDisplay}\r\n  PIDsearch = {$plugin.tt_products.PIDsearch}\r\n  PIDbasket = {$plugin.tt_products.PIDbasket}\r\n  PIDstoreRoot = {$plugin.tt_products.PIDstoreRoot}\r\n  PID_sys_products_orders = 0\r\n#  PIDinfo = 209\r\n#  PIDfinalize = 210\r\n#  PIDthanks = 211\r\n\r\n  parseFunc < styles.content.parseFunc\r\n  categoryHeader = TEXT\r\n  categoryHeader.current = 1\r\n\r\n  priceDec = {$plugin.tt_products.priceDec}\r\n  priceDecPoint = {$plugin.tt_products.priceDecPoint}\r\n  priceThousandPoint = {$plugin.tt_products.priceThousandPoint}\r\n  currencySymbol = USD\r\n\r\n  TAXpercentage = {$plugin.tt_products.TAXpercentage}\r\n  TAXincluded = {$plugin.tt_products.TAXincluded}\r\n\r\n  lockLoginUserInfo = 1\r\n  requiredInfoFields = name, address, telephone\r\n  orderNumberPrefix = order_\r\n  orderEmail_from = shop@myTypo3Shop.com\r\n  orderEmail_fromName = My TYPO3 Shop\r\n  orderEmail_to = shop@myTypo3Shop.com\r\n  orderEmail_htmlmail = 0\r\n  email_notify_default = 1\r\n  statusCodes {\r\n    1 = Order submitted by user\r\n    2 = Order is recieved and accepted by store\r\n    10 = Shop is awaiting goods from third-party\r\n    11 = Shop is awaiting customer payment\r\n    12 = Shop is awaiting material from customer\r\n    20 = Goods shipped to customer\r\n    30 = Other message from store\r\n    50 = Customer request for cancelling\r\n    51 = Message from customer to shop\r\n    100 = Order shipped and closed\r\n    101 = Order closed\r\n    200 = Ordre cancelled\r\n  }\r\n  update_code = password\r\n  statusDate_stdWrap.strftime= %e-%m-%y %H:%M\r\n  orderDate_stdWrap.strftime= %e-%m-%y\r\n}\r\n\r\n## EXAMPLE payment config:\r\nplugin.tt_products.payment {\r\n  radio = 1\r\n  10.title = MasterCard\r\n  10.image.file = media/logos/mastercard.gif\r\n  10.priceTax = \r\n  10.priceNoTax =  \r\n  10.calculationScript = media/scripts/products_comp_calcScript.inc\r\n\r\n  40.title = Money transfer\r\n  40.image.file = media/logos/money.gif\r\n  40.priceTax = \r\n  40.priceNoTax = \r\n  40.percentOfGoodstotal = 1.45\r\n\r\n  50.title = Credit in-store\r\n  50.image.file = \r\n  50.priceTax = \r\n  50.priceNoTax = \r\n}\r\n\r\n## EXAMPLE shipping config:\r\nplugin.tt_products.shipping {\r\n  10.title = Ground\r\n  10.image.file = media/logos/pakketrans.gif\r\n  10.image.params = align=\"absmiddle\"\r\n  10.priceTax = 40\r\n  10.priceNoTax = 32\r\n\r\n  20.title = Airmail\r\n  20.image.file = media/logos/postdanmark.gif\r\n  10.image.params = align=\"absmiddle\"\r\n  20.priceTax = 120\r\n  20.priceNoTax = 120\r\n\r\n  40.title = Pick up in store\r\n  40.excludePayment = 10,40\r\n}\r\n\r\n\r\n\r\n## This enables the record item to display product items\r\ntt_products >\r\ntt_products = < plugin.tt_products\r\ntt_products.displayCurrentRecord = 1\r\n\r\n','PLUGIN: Shopping module, Products\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n','');
INSERT INTO `static_template` VALUES (65,0,1054752436,985276040,'content.tt_address [DEPRECIATED]','','content.tt_address {\r\n    # cat=address/typo; type=wrap; label=Wrap, name\r\n  name.wrap = <h3> |</h3>\r\n    # cat=address/typo; type=options[,upper,lower]; label=Case, name\r\n  name.case = upper\r\n    # cat=address/typo; type=wrap; label=Wrap, address information\r\n  info.wrap = <font color=\"maroon\"> |</font>\r\n    # cat=address/dims; type=int+; label=Width, information field\r\n  info.width = 300\r\n    # cat=address/dims; type=int+; label=Width, image\r\n  image.width = 120\r\n    # cat=address//; type=options[name,company,phone,city]; label=SQL \"ORDER BY\"\r\n  orderBy = name\r\n    # cat=address//; type=options[,DESC]; label=Reverse order (DESC)?\r\n  desc = \r\n}\r\n','## Introducing rendering information for tt_address:\r\ntt_address = COA\r\ntt_address {\r\n  wrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td valign=\"top\"> | </tr></table><br />\r\n\r\n  10 = TEXT\r\n  10.field = name\r\n  10.case = {$content.tt_address.name.case}\r\n  10.wrap = {$content.tt_address.name.wrap}\r\n\r\n  20 = COA\r\n  20.wrap = {$content.tt_address.info.wrap}\r\n  20 {\r\n    20 = TEXT\r\n    20.if.isTrue.field = company\r\n    20.dataWrap = Company: {field:company}<br />\r\n\r\n    21 = TEXT\r\n    21.dataWrap = {field:address}<br />{field:zip} {field:city}\r\n\r\n    22 = TEXT\r\n    22.if.isTrue.field = phone\r\n    22.dataWrap = <br />Phone: {field:phone}\r\n\r\n    23 = TEXT\r\n    23.if.isTrue.field = fax\r\n    23.dataWrap = <br />Fax: {field:fax}\r\n\r\n    25 = TEXT\r\n    25.if.isTrue.field = email\r\n    25.dataWrap = <br /><a href=\"mailto:{field:email}\">{field:email}</a>\r\n\r\n    27 = TEXT\r\n    27.if.isTrue.field = www\r\n    27.dataWrap = <br /><a href=\"{field:www}\" target=\"_top\">Hjemmeside</a>\r\n  }\r\n\r\n  40 = TEXT\r\n  40.value = <br /><img src=\"clear.gif\" width=\"{$content.tt_address.info.width}\" height=\"1\" alt=\"\" /></td><td>&nbsp;</td>\r\n\r\n  60 = IMAGE\r\n  60.file.import = uploads/pics/\r\n  60.file.import.field = image\r\n  60.file.import.listNum = 0\r\n  60.file.width = {$content.tt_address.image.width}\r\n  60.wrap = <td valign=\"top\">|</td>\r\n}\r\n\r\n\r\n## Transfering to the tt_content.list object:\r\ntt_content.list.20.0 >\r\ntt_content.list.20.0 = CASE\r\ntt_content.list.20.0.key.field = layout\r\ntt_content.list.20.0.0 = CONTENT\r\ntt_content.list.20.0.0 {\r\n  table = tt_address\r\n  select.pidInList.field = pages\r\n  select.orderBy = {$content.tt_address.orderBy} {$content.tt_address.desc}\r\n}\r\n\r\n\r\n\r\n','Introduces rendering code for tt_address records. \r\n\r\nHow to activate this:\r\n- Just include this static template in your template provided that the static template \"content (default)\" is already included ranging higher in the list. \r\n\r\nCreates a toplevel TS object, tt_address.\r\nConstants are in \'content.tt_address\'\r\nSets up \'tt_content.list.20.0.0\' to render the address-items\r\n','');
INSERT INTO `static_template` VALUES (66,0,1054753042,985276070,'plugin.tt_board_list [DEPRECIATED]','81','plugin.tt_board_list{\r\n    # cat=plugin.board/file; type=file[html,htm,tmpl,txt]; label= Template File, list style: This is a simple textfile where the board is defined with HTML-code. To see an example with explanations, take a look at media/scripts/board_template.tmpl which is the default.\r\n  file.templateFile = media/scripts/board_template1.tmpl\r\n\r\n    # cat=plugin.board/typo; type=wrap; label= List-style, Wrap 1: This wrap is used in the template-file.\r\n  wrap1 = <font face=\"verdana\" size=\"2\" color=\"black\"> | </font>\r\n    # cat=plugin.board/typo; type=wrap; label= List-style, Wrap 2: This wrap is used in the template-file.\r\n  wrap2 = <font face=\"verdana\" size=\"1\" color=\"black\"> | </font>\r\n    # cat=plugin.board/typo; type=wrap; label= List-style, Wrap 3: This wrap is used in the template-file.\r\n  wrap3 = <font face=\"verdana\" size=\"2\" color=\"white\"> | </font>\r\n\r\n    # cat=plugin.board/color; type=color; label= List-style, Color 1: This bgcolor is used in the template-file.\r\n  color1 = #cccccc\r\n    # cat=plugin.board/color; type=color; label= List-style, Color 2: This bgcolor is used in the template-file.\r\n  color2 = #999999\r\n    # cat=plugin.board/color; type=color; label= List-style, Color 3: This bgcolor is used in the template-file.\r\n  color3 = #333333\r\n    # cat=plugin.board/color; type=color; label= List-style, Color 4: This bgcolor is used in the template-file.\r\n  color4 = #333366\r\n}\r\n\r\n\r\n','\r\n## This enables the tt_content.list item to display the forum, list style:\r\nplugin.tt_board_list < temp.tt_board.shared\r\nplugin.tt_board_list {\r\n  templateFile = {$plugin.tt_board_list.file.templateFile}\r\n\r\n  # Global wraps\r\n  wrap1.wrap = {$plugin.tt_board_list.wrap1}\r\n  wrap2.wrap = {$plugin.tt_board_list.wrap2}\r\n  wrap3.wrap = {$plugin.tt_board_list.wrap3}\r\n  color1.wrap = {$plugin.tt_board_list.color1}\r\n  color2.wrap = {$plugin.tt_board_list.color2}\r\n  color3.wrap = {$plugin.tt_board_list.color3}\r\n  color4.wrap = {$plugin.tt_board_list.color4}\r\n}\r\n\r\n\r\n## This enables the record item to display guestbook items\r\ntt_board >\r\ntt_board = < plugin.tt_board_list\r\ntt_board.displayCurrentRecord = 1\r\n\r\n','PLUGIN: Board/Forum List style\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n','');
INSERT INTO `static_template` VALUES (82,0,1054752829,999775222,'plugin.alt.plaintext (99)','','plugin.alt.plaintext {\r\n    # cat=plugin.plaintext/file; type=file[html,htm,tmpl,txt]; label= Template File for plaintext version: &type=99 defines a printer friendly design for page content. This template file lets you define the position of page titles and the content.\r\n  file.template = media/scripts/plaintext_content.tmpl\r\n\r\n  siteUrl = http://www.example.com.test/example/\r\n}','lib.alt_plaintext.renderObj = USER\r\nlib.alt_plaintext.renderObj.userFunc = user_plaintext->main_plaintext\r\nlib.alt_plaintext.renderObj {\r\n  header.defaultType = 1\r\n  header.date = D-m-Y\r\n  header.datePrefix = |Date: |\r\n  header.linkPrefix = | - Headerlink: |\r\n  header.1.preLineLen = 76\r\n  header.1.postLineLen = 76\r\n  header.1.preBlanks=1\r\n  header.1.stdWrap.case = upper\r\n\r\n  header.2 < .header.1\r\n  header.2.preLineChar=*\r\n  header.2.postLineChar=*\r\n\r\n  header.3.preBlanks=2\r\n  header.3.postBlanks=1\r\n  header.3.stdWrap.case = upper\r\n  \r\n  header.4 < .header.1\r\n  header.4.preLineChar= =\r\n  header.4.postLineChar= =\r\n  header.4.preLineBlanks= 1\r\n  header.4.postLineBlanks= 1\r\n\r\n  header.5.preBlanks=1\r\n  header.5.autonumber=1\r\n  header.5.prefix = |: >> |\r\n\r\n\r\n  siteUrl = {$plugin.alt.plaintext.siteUrl}\r\n  defaultOutput (\r\n|\r\n[Unrendered Content Element; ###CType### ]\r\n|\r\n  )\r\n\r\n  uploads.header = |DOWNLOADS:|\r\n\r\n  images.header = |IMAGES:|\r\n  images.linkPrefix = | - Imagelink: |\r\n  images.captionHeader = |CAPTION:|\r\n\r\n  bulletlist.0.bullet = |*  |\r\n\r\n  bulletlist.1.bullet = |#  |\r\n\r\n  bulletlist.2.bullet = | - |\r\n\r\n  bulletlist.3.bullet = |>  |\r\n  bulletlist.3.secondRow = |.  |\r\n  bulletlist.3.blanks = 1\r\n\r\n  menu = <tt_content.menu.20\r\n  shortcut = <tt_content.shortcut.20\r\n  shortcut.0.conf.tt_content = <lib.alt_plaintext.renderObj\r\n  shortcut.0.tables = tt_content\r\n\r\n  bodytext.stdWrap.parseFunc.tags {\r\n    link < styles.content.parseFunc.tags.link\r\n    typolist = USER\r\n    typolist.userFunc = user_plaintext->typolist\r\n    typolist.siteUrl = {$plugin.alt.plaintext.siteUrl} \r\n    typolist.bulletlist =< lib.alt_plaintext.renderObj.bulletlist\r\n    typohead = USER\r\n    typohead.userFunc = user_plaintext->typohead\r\n    typohead.siteUrl = {$plugin.alt.plaintext.siteUrl}\r\n    typohead.header =< lib.alt_plaintext.renderObj.header\r\n    typocode = USER\r\n    typocode.userFunc = user_plaintext->typocode\r\n    typocode.siteUrl = {$plugin.alt.plaintext.siteUrl}\r\n  }\r\n}\r\n\r\n\r\n\r\n## Insert DMailer Boundaries for all elements.\r\nconfig.insertDmailerBoundaries = 1\r\n\r\nincludeLibs.plaintextLib = media/scripts/plaintextLib.inc\r\n\r\n## Set up page/type number:\r\nalt_plaintext >\r\nalt_plaintext = PAGE\r\nalt_plaintext.typeNum=99\r\n\r\nalt_plaintext.config.disableAllHeaderCode = 1\r\nalt_plaintext.10 = TEMPLATE\r\nalt_plaintext.10 {\r\n  template = FILE\r\n  template.file = {$plugin.alt.plaintext.file.template}\r\n  marks.CONTENT < styles.content.get\r\n  marks.CONTENT.renderObj = < lib.alt_plaintext.renderObj\r\n  marks.DATE = TEXT\r\n  marks.DATE.data = date:U\r\n  marks.DATE.strftime = %e. %B %Y\r\n}\r\n\r\n## Setting up a testpage at type 199\r\nalt_plaintext_test < alt_plaintext\r\nalt_plaintext_test {\r\n  wrap = <pre>|</pre>\r\n  typeNum=199\r\n  config.no_cache=1\r\n}\r\n\r\n','Creates a PAGE object, alt_plaintext, with typeNum = 99. This page displays the page content in plain text layout designed for Direct Mail purposes.\r\n\r\nJust include this static template directly in your template, and you\'re up\'n\'running.','');
INSERT INTO `static_template` VALUES (83,0,1054752886,999781305,'plugin.alt.xml (96)','','plugin.alt.xml >\r\nplugin.alt.xml {\r\n\r\n}\r\n','## Set up page/type number:\r\nalt_xml >\r\nalt_xml = PAGE\r\nalt_xml {\r\n  typeNum=96\r\n  config.disableAllHeaderCode = 1\r\n  config.additionalHeaders = Content-type: text/xml\r\n\r\n  ## Includes the newsLib:\r\n  includeLibs.alt_xml = media/scripts/xmlversionLib.inc\r\n\r\n  ## Inserting the USER cObject for XML rendering\r\n  10 = USER\r\n  10 {\r\n    userFunc = user_xmlversion->main_xmlversion\r\n  }\r\n}','Creates a PAGE object, alt_xml, with typeNum = 96. This page displays the \'normal\' page content along with trivial page information in XML format.\r\n\r\nStill experimental.\r\n\r\nJust include this static template directly in your template, and you\'re up\'n\'running.','');
INSERT INTO `static_template` VALUES (86,0,1054752801,999808177,'plugin.alt.pda (95)','','plugin.alt.pda >\r\nplugin.alt.pda {\r\n    # cat=plugin.pda/file; type=file[html,htm,tmpl,txt]; label= Template File for PDA version: &type=95 defines a PDA friendly design for page content. \r\n  file.template = media/scripts/pdaversion_content.tmpl\r\n}','## Defining temporary object:\r\ntemp.alt_pda.mainMenu = HMENU\r\ntemp.alt_pda.mainMenu {\r\n  1 = TMENU\r\n  1 {\r\n    expAll = 1\r\n    target = \r\n    NO.allWrap = <h3>|</h3>\r\n  }\r\n  2 < .1\r\n  2.NO.allWrap = &nbsp;&nbsp;<b>|</b><br />\r\n  3 < .1\r\n  3.NO.allWrap = &nbsp;&nbsp;&nbsp;&nbsp;|<br />\r\n}\r\n\r\n\r\ntemp.alt_pda.pageNav = HMENU\r\ntemp.alt_pda.pageNav {\r\n  special = browse\r\n  special {\r\n    items = prev | up | next\r\n    items.prevnextToSection = 1\r\n    up.fields.title = UP\r\n    prev.fields.title = &lt; PREV\r\n    next.fields.title = NEXT &gt;\r\n  }\r\n  1 = TMENU\r\n  1.target = \r\n  1.NO {\r\n    linkWrap = [ | ]\r\n  }\r\n}\r\n\r\n\r\ntemp.alt_pda.rootLine = HMENU\r\ntemp.alt_pda.rootLine {\r\n  special = rootline\r\n  1 = TMENU\r\n  1.target = \r\n  1.wrap =  | <br />\r\n  1.NO {\r\n    linkWrap = | &nbsp;&gt;&nbsp; |*||*|   |\r\n  }\r\n}\r\n\r\n\r\n\r\n\r\n## Set up page\r\nalt_pda >\r\nalt_pda = PAGE\r\nalt_pda.typeNum=95\r\nalt_pda.config.forceTypeValue=95\r\n\r\nalt_pda.10 = TEMPLATE\r\nalt_pda.10 {\r\n  template = FILE\r\n  template.file = {$plugin.alt.pda.file.template}\r\n  marks {\r\n    PAGE_TITLE = TEXT\r\n    PAGE_TITLE.field = title\r\n    PAGE_SUBTITLE = TEXT\r\n    PAGE_SUBTITLE.field = subtitle\r\n    PAGE_AUTHOR = TEXT\r\n    PAGE_AUTHOR.field = author\r\n    PAGE_AUTHOR.required=1\r\n    PAGE_AUTHOR.typolink.parameter.field = author_email\r\n    PAGE_UID = TEXT\r\n    PAGE_UID.field = uid\r\n    CONTENT < styles.content.get\r\n\r\n    MAIN_MENU = TEXT\r\n    MAIN_MENU.value =\r\n    NAVIGATION = TEXT\r\n    NAVIGATION.value =\r\n  }\r\n  workOnSubpart = DOCUMENT_BODY\r\n}\r\n\r\n\r\n## Inserting the temporary objects:\r\n[treeLevel = 0]\r\nalt_pda.10.marks.MAIN_MENU < temp.alt_pda.mainMenu\r\n[global]\r\n\r\n[treeLevel = 1,2,3,4,5]\r\nalt_pda.10.marks.NAVIGATION = COA \r\nalt_pda.10.marks.NAVIGATION {\r\n  10 < temp.alt_pda.rootLine\r\n  20 < temp.alt_pda.pageNav\r\n}\r\n[global]\r\n\r\n\r\n## If the browser is a PDA-device, eg. AvantGo\r\n[device=pda]\r\n\r\nalt_pda.typeNum=0\r\nalt_pda.config.forceTypeValue=0\r\n\r\n[global]\r\n\r\n','Creates a PAGE object, alt_pda, with typeNum = 95. \r\n\r\nJust include this static template directly in your template, and you\'re up\'n\'running.\r\n\r\nDepends on \'content (default)\' or similar to be already included.','');
INSERT INTO `static_template` VALUES (67,0,1054753495,985353522,'styles.sitemap.gs','','styles.sitemap.gs >\r\nstyles.sitemap.gs {\r\n  entryLevel = 0\r\n    # cat=gs-sitemap; type=small; label=exclude PID: If there\'s certain page-id number you would like to exclude from the sitemap (eg. the sitemap-page itself), then enter it here (comma-list)\r\n  excludeUids =\r\n\r\n    # cat=gs-sitemap/links; type=small; label=Target: The target of the links in the sitemap. \r\n  target = _top\r\n    # cat=gs-sitemap/color; type=color; label=Background color, headers\r\n  color = olive\r\n\r\n    # cat=gs-sitemap/typo; type=wrap; label=Sitemap, Header Wrap: This wrap is placed around the header of the sitemap.\r\n  headerWrap = <div align=\"center\"><b><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\" color=\"white\"> | </font></b></div>\r\n    # cat=gs-sitemap/typo; type=options[,upper,lower]; label=Header case\r\n  headerCase = upper\r\n\r\n    # cat=gs-sitemap/typo; type=wrap; label=Sitemap, Head Wrap 1: This wrap is placed around the every head item in the sitemap.\r\n  wrap1 = <b><font size=\"1\" face=\"Verdana, Arial, Helvetica, sans-serif\" color=\"white\"> | </font></b>\r\n    # cat=gs-sitemap/typo; type=wrap; label=Sitemap, Second Wrap 2: This wrap is placed around the every second-level item in the sitemap.\r\n  wrap2 = <font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">|</font>\r\n    # cat=gs-sitemap/typo; type=wrap; label=Sitemap, Third Wrap 3: This wrap is placed around the every third-level item in the sitemap.\r\n  wrap3 = <font face=\"Verdana, Arial, Helvetica, sans-serif\" size=\"1\">|</font>\r\n\r\n    # cat=gs-sitemap/; type=string; label=Bullet, Second Level\r\n  bullet2 = <img src=\"media/bullets/blackdot.gif\" width=\"5\" height=\"9\" alt=\"\" />\r\n    # cat=gs-sitemap/; type=string; label=Bullet, Third Level\r\n  bullet3 = <img src=\"media/bullets/blackdot.gif\" width=\"3\" height=\"6\" hspace=\"4\" vspace=\"2\" alt=\"\" />\r\n\r\n    # cat=gs-sitemap; type=boolean; label=Level 3?: If you would like the sitemap to render only two levels, un-check this option\r\n  level3 = 1\r\n}\r\n\r\n\r\n','\r\n# SITE MAP\r\n\r\nstyles.sitemap.gs >\r\nstyles.sitemap.gs = COA\r\nstyles.sitemap.gs.wrap = <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\"> | </table>\r\nstyles.sitemap.gs {\r\n  10 = TEXT\r\n  10.data = leveltitle : {$styles.sitemap.gs.entryLevel}\r\n  10.case = {$styles.sitemap.gs.headerCase}\r\n  10.wrap = {$styles.sitemap.gs.headerWrap}\r\n  10.wrap2 = <tr><td><table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" align=\"center\"><tr bgcolor=\"{$styles.sitemap.gs.color}\"><td> | </td></tr></table></td></tr>\r\n  15 = TEXT\r\n  15.value = <tr align=\"center\" valign=\"middle\"><td><img src=\"media/bullets/blackclear.gif\" width=\"1\" height=\"10\" alt=\"\" /></td></tr><tr bgcolor=\"{$styles.sitemap.gs.color}\"><td><img src=\"clear.gif\" width=\"1\" height=\"1\" alt=\"\" /></td></tr>\r\n  19 = TEXT\r\n  19.value = <tr><td>\r\n\r\n  # Here comes the sitemap below...\r\n  \r\n  21 = TEXT\r\n  21.value =  </td></tr>\r\n}\r\n\r\n\r\n# The sitemap itself:\r\nstyles.sitemap.gs.20 = COA\r\nstyles.sitemap.gs.20.wrap = <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\"> | </table>\r\nstyles.sitemap.gs.20.10 = HMENU\r\nstyles.sitemap.gs.20.10 {\r\n  entryLevel = {$styles.sitemap.gs.entryLevel}\r\n  excludeUidList = {$styles.sitemap.gs.excludeUids}\r\n  wrap = <tr align=\"center\" valign=\"middle\"> |</tr>\r\n  1 = TMENU\r\n  1.NO {\r\n    doNotShowLink = 1\r\n    before = <td><img src=\"media/bullets/blackclear.gif\" width=\"1\" height=\"10\" alt=\"\" /></td>\r\n  }\r\n}\r\nstyles.sitemap.gs.20.20 = HMENU\r\nstyles.sitemap.gs.20.20 {\r\n  excludeUidList = {$styles.sitemap.gs.excludeUids}\r\n  entryLevel = {$styles.sitemap.gs.entryLevel}\r\n  wrap = <tr align=\"left\" valign=\"top\"> |</tr>\r\n  1 = TMENU\r\n  1.target = {$styles.sitemap.gs.target}\r\n  1.expAll = 1\r\n  1.NO {\r\n    wrapItemAndSub = <td><table border=\"0\" cellpadding=\"1\" cellspacing=\"1\">|</table></td>\r\n    allWrap = <tr><td bgcolor=\"{$styles.sitemap.gs.color}\" colspan=\"3\"><div align=\"center\">|</div></td></tr>\r\n    linkWrap = {$styles.sitemap.gs.wrap1}\r\n    ATagBeforeWrap = 1\r\n  }\r\n  2 = TMENU\r\n  2.expAll = {$styles.sitemap.gs.level3}\r\n  2.target = {$styles.sitemap.gs.target}\r\n  2.NO {\r\n    allWrap = <tr><td align=\"center\" valign=\"top\">{$styles.sitemap.gs.bullet2}</td><td align=\"left\" valign=\"top\" colspan=\"2\">|</td></tr>\r\n    linkWrap = {$styles.sitemap.gs.wrap2}\r\n    ATagBeforeWrap = 1\r\n  }\r\n  3 = TMENU\r\n  3.target = {$styles.sitemap.gs.target}\r\n  3.NO {\r\n    allWrap = <tr><td></td><td align=\"center\" valign=\"top\">{$styles.sitemap.gs.bullet3}</td><td align=\"left\" valign=\"top\">|</td></tr>\r\n    linkWrap = {$styles.sitemap.gs.wrap3}\r\n    ATagBeforeWrap = 1\r\n  }\r\n}\r\n','','');
INSERT INTO `static_template` VALUES (64,0,1054753114,985004512,'plugin.tt_guest [DEPRECIATED]','','plugin.tt_guest >\r\nplugin.tt_guest {\r\n    # cat=plugin.guestbook/file; type=file[html,htm,tmpl,txt]; label= Template File: This is a simple textfile where the guestbook is defined with HTML-code. To see an example with explanations, take a look at media/scripts/guest_template1.tmpl which provides a good example\r\n  file.templateFile = media/scripts/guest_template1.tmpl\r\n  notifyEmail = \r\n\r\n    # cat=plugin.guestbook/typo; type=wrap; label= Wrap 1: This wrap is used in the template-file.\r\n  wrap1 = <font face=\"verdana\" size=\"2\" color=\"black\"> | </font>\r\n    # cat=plugin.guestbook/typo; type=wrap; label= Wrap 2: This wrap is used in the template-file.\r\n  wrap2 = <font face=\"verdana\" size=\"1\" color=\"black\"> | </font>\r\n\r\n    # cat=plugin.guestbook/color; type=color; label= Color 1: This bgcolor is used in the template-file.\r\n  color1 = #cccccc\r\n    # cat=plugin.guestbook/color; type=color; label= Color 2: This bgcolor is used in the template-file.\r\n  color2 = #999999\r\n    # cat=plugin.guestbook/color; type=color; label= Color 3: This bgcolor is used in the template-file.\r\n  color3 = #333333\r\n}\r\n\r\n','## Includes the guestLib:\r\nincludeLibs.ts_guest = media/scripts/guestLib.inc\r\n\r\n\r\n## Sets up the fields, that may be submitted in order to create items. Mandatory!\r\nFEData.tt_guest >\r\nFEData.tt_guest {\r\n  processScript = media/scripts/guest_submit.inc\r\n  processScript.notifyEmail = {$plugin.tt_guest.notifyEmail}\r\n  default {\r\n    hidden = 0\r\n  }\r\n  allowNew {\r\n    title = 1\r\n    note = 1\r\n    cr_name=1\r\n    cr_email=1\r\n    www=1\r\n  }\r\n  autoInsertPID = 1\r\n  doublePostCheck = doublePostCheck\r\n}\r\n\r\n\r\n\r\n## This enables the tt_content.list item to display the guestbook:\r\nplugin.tt_guest >\r\nplugin.tt_guest = USER\r\nplugin.tt_guest {\r\n  userFunc = user_guest->main_guestbook\r\n\r\n  templateFile = {$plugin.tt_guest.file.templateFile}\r\n  pid_list.field = pages\r\n  code.field = select_key\r\n\r\n  # Global wraps\r\n  wrap1.wrap = {$plugin.tt_guest.wrap1}\r\n  wrap2.wrap = {$plugin.tt_guest.wrap2}\r\n  color1.wrap = {$plugin.tt_guest.color1}\r\n  color2.wrap = {$plugin.tt_guest.color2}\r\n  color3.wrap = {$plugin.tt_guest.color3}\r\n\r\n  # Change/add to format the content:\r\n  age_stdWrap.age = 1\r\n  date_stdWrap.strftime= %e-%m-%y\r\n  time_stdWrap.strftime= %H:%M:%S\r\n  author_stdWrap.case = upper\r\n  www_stdWrap.typolink.parameter.field = www\r\n  email_stdWrap.typolink.parameter.field = cr_email\r\n  requireRecords = 1\r\n\r\n  	# Change/add to format the submit-form\r\n  postform < styles.content.mailform\r\n  postform.data >\r\n  postform.dataArray {\r\n    10.label = Header:\r\n    10.type = *data[tt_guest][NEW][title]=input \r\n    20.label = Your comment:\r\n    20.type = *data[tt_guest][NEW][note]=textarea\r\n    30.label = Name:\r\n    30.type = *data[tt_guest][NEW][cr_name]=input \r\n    40.label = Email:\r\n    40.type = *data[tt_guest][NEW][cr_email]=input\r\n    50.label = Homepage:\r\n    50.type = *data[tt_guest][NEW][www]=input \r\n    60.type = formtype_db=submit\r\n    60.value = Add yourself\r\n  }\r\n  postform.no_cache=1\r\n}\r\n\r\n## This enables the tt_content.record item to display guestbook items:\r\ntt_guest >\r\ntt_guest = < plugin.tt_guest\r\ntt_guest.displayCurrentRecord = 1\r\n\r\n','PLUGIN: Guestbook\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n\r\nHow to activate this:\r\n- Include this static template in your template.\r\n\r\nExpects static template \'styles.content (default)\' to be included.','');
INSERT INTO `static_template` VALUES (68,0,1054752983,988325351,'plugin.meta [DEPRECIATED]','','plugin.meta >\r\nplugin.meta {\r\n    # cat=plugin.meta; type=string; label= Description: Write a short abstract for your website.\r\n  description = \r\n    # cat=plugin.meta; type=string; label= Keywords: Enter a comma separated list of keywords.\r\n  keywords = \r\n    # cat=plugin.meta; type=string; label= Robots: Use for instance these codes: Index all pages: \"all\".  Index no pages: \"none\". Only this page: \"index,nofollow\".  Only subpages: \"noindex,follow\"\r\n  robots = \r\n    # cat=plugin.meta; type=string; label= Copyright info: Enter copyright information, eg. \"Me Myself and I, 2001. All rights reserved.\"\r\n  copyright = \r\n    # cat=plugin.meta; type=string; label= Reply-to email\r\n  email = \r\n    # cat=plugin.meta; type=string; label= Author: Enter name of author.\r\n  author = \r\n    # cat=plugin.meta; type=options[,Arabic=ar,Chinese=zh,Danish=dk,Dutch=nl,English=en,Finnish=fi,French=fr,German=de,Greek=el,Hebrew=he,Icelandic=is,Italian=it,Japanese=ja,Norwegian=no,Polish=pl,Portuguese=pt,Russian=ru,Spanish=es,Swedish=sv,Turkish=tr,Multi language=mul]; label= Language: Select language of the content.\r\n  language = \r\n    # cat=plugin.meta; type=string; label= Distribution\r\n  distribution = \r\n    # cat=plugin.meta; type=options[,General,Mature,14 years,Restricted]; label= Rating\r\n  rating = \r\n    # cat=plugin.meta; type=int+; label= Revisit after: Number of days between search engine visits.\r\n  revisit = \r\n    # cat=plugin.meta; type=boolean; label= Always include global: \r\n  includeGlobal = 0\r\n}\r\n\r\n','plugin.meta >\r\nplugin.meta = PHP_SCRIPT\r\nplugin.meta {\r\n  file = media/scripts/meta.php\r\n  global {\r\n    description = {$plugin.meta.description}\r\n    description_2 = {$styles.content.meta.site_description}\r\n    keywords = {$plugin.meta.keywords}\r\n    keywords_2 = {$styles.content.meta.site_keywords}\r\n    robots = {$plugin.meta.robots}\r\n    copyright = {$plugin.meta.copyright}\r\n    email = {$plugin.meta.email}\r\n    author = {$plugin.meta.author}\r\n    language = {$plugin.meta.language}\r\n    distribution = {$plugin.meta.distribution}\r\n    rating = {$plugin.meta.rating}\r\n    revisit = {$plugin.meta.revisit}\r\n  }\r\n  local {\r\n      // stdWrap, \"loads\" the local description (if any) for the page\r\n    description.field = description\r\n      // stdWrap, \"loads\" the local keywords (if any) for the page\r\n    keywords.field = keywords\r\n  }\r\n  flags {\r\n     // Boolean, This includes the keywords/description set in styles.content (default) for backwards compatibility (if not set, keywords_2/description_2 is simply unset). \r\n    useSecondaryDescKey = 1\r\n     // Boolean, This includes the global description (from above), even if local description is found for a page\r\n    alwaysGlobalDescription = {$plugin.meta.includeGlobal}\r\n     // Boolean, This includes the global keywords (from above), even if local keywords are found for a page\r\n    alwaysGlobalKeywords = {$plugin.meta.includeGlobal}\r\n     // Boolean, This enables the \"Dublin Core\" standard meta-tags.\r\n    DC =1\r\n  }\r\n}\r\n\r\n','PLUGIN: plugin.meta\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n\r\nThis template is used to include an extended set of META-tags on your pages. By using this, you should disable the default meta-tags used.\r\n\r\nUse:\r\nIf your PAGE object is \"page\" then simply make a reference to the object from the .headerData CARRAY of the PAGE object.\r\n\r\nExample, (in Setup-field of you template, provided that PAGE object is \"page\"):\r\n\r\npage.headerData.10 =  <plugin.meta\r\npage.meta >','');
INSERT INTO `static_template` VALUES (69,0,1054753669,994368675,'template; CANDIDATE','43,68','# Template specific\r\nfile {\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Top image, left:  Image in the top of the content column. Page title may be printed on this image.\r\n  left_bar = media/uploads/candidate/bar_left.gif\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Top image, right:  Image in the top of the right column.\r\n  right_bar = media/uploads/candidate/bar_right.gif\r\n    # cat=basic/typo; type=file[ttf]; label=Top image, Font file: TrueType (ttf) font for printing the page title on the top image (left).\r\n  left_bar_fontFile = \r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Background image: Background image of the page.\r\n  background = \r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Right column bar: If you enter an image here, it will substitute the \'titlefield\' below the right column top image\r\n  right_subbar = \r\n}\r\n\r\n  # cat=basic/dims; type=offset; label=Page offset: This value defines the margin in pixels from the left and top of the browser window\r\npage.offset = ,20\r\n  # cat=basic; type=options[left,right,center]; label=Alignment of the page: Alignment of the page-table\r\npage.align = center\r\n  # cat=basic/dims; type=int+; label=Content width: This value defines the width in pixels of the table cell where the content is displayed\r\npage.width = 400\r\n  # cat=basic/dims; type=offset; label=Content offset: This value defines the margin in pixels from the left and top of main content table cell\r\npage.contentOffset = 0,0\r\n\r\npagetitle {\r\n    #cat=page/h; type=boolean; label=Page Title, enable: If you set this option, the page title (overruled by the subtitle if present) will be printed right after the menu\r\n  enable = 0\r\n    #cat=page/h; type=wrap; label=Page Title, wrap: Wrapping for the page title after menu\r\n  wrap = <font face=\"arial,helvetica\" size=\"4\" color=\"#000099\"><b>|</b></font><br />\r\n    #cat=page/h; type=int+; label=Page Title, Space before:\r\n  spaceBefore = 7\r\n    #cat=page/h; type=int+; label=Page Title, Space after:\r\n  spaceAfter = 20\r\n}\r\n\r\n\r\nleftBar {\r\n    #cat=basic/typo; type=boolean; label=Enable title on Left Image: If you set this option, the page title (overruled by the subtitle if present) will be printed on the Left Image\r\n  enable = 1\r\n    #cat=basic/typo; type=int+; label=Top image, font size: \r\n  fontSize = 34\r\n    #cat=basic/typo; type=color; label=Top image, font color: \r\n  fontColor = white\r\n    #cat=basic/typo; type=offset; label=Top image, font offset:\r\n  offset = 0,33\r\n    # cat=basic/typo; type=options[left,right,center]; label=Top image, font alignment: \r\n  align = center\r\n}\r\n\r\n  # cat=page/d; type=string; label=Right column title: This is the text string shown in the field right below the top image in the right column\r\npage.titleValue = Link to Typo3.com\r\n  # cat=page/d; type=wrap; label=Right column title, wrap: This is the wrap around the right column title\r\npage.titleWrap = <a href=\"http://www.typo3.com\" target=\"_top\"><font size=\"1\" face=\"verdana,arial\" color=\"white\"><b> | </b></font></a>\r\n\r\n  #cat=page/color; type=color; label=Background color, content frame: \r\npage.contentBgColor = \r\n\r\n  #cat=page/enable; type=boolean; label=Expand Left Image: If you set this option, the left image will expand all over the two columns and the right image will not appear\r\npage.leftImageExpand = 0\r\n\r\n  #cat=page/e; type=color; label=Gap, line color: \r\ngap.linecolor = #000033\r\ngap.width {\r\n    #cat=page/e; type=int+; label=Gap, line width: \r\n  line = 1\r\n    #cat=page/e; type=int+; label=Gap, right space: \r\n  right = 18\r\n    #cat=page/e; type=int+; label=Gap, left space: \r\n  left = 18\r\n}\r\n\r\n\r\nmenu {\r\n    #cat=menu/enable; type=boolean; label=Enable the menu: If you set this option, the menu will appear\r\n  enable = 1\r\n    #cat=menu/color; type=color; label=Background color:\r\n  bgcolor = #000099\r\n    #cat=menu/dims; type=int+; label=Gap between elements: The gap between the menu elements.\r\n  gapwidth=9\r\n    #cat=menu/dims; type=int+; label=Height of each item: The height in pixels of each menu item. This includes the header field in the right column so it follows the menu height!\r\n  itemHeight=1\r\n    #cat=menu/dims; type=int+; label=Space before menu:\r\n  spaceBefore = 7\r\n    #cat=menu/dims; type=int+; label=Space after menu:\r\n  spaceAfter = 20\r\n    #cat=menu/typo; type=wrap; label=Menu item wrap:\r\n  wrap = <font size=\"1\" face=\"verdana,arial\" color=\"white\"><b> | </b></font>\r\n}\r\n\r\n\r\nrightCol {\r\n    #cat=right; type=boolean; label=Enable Right Column: Check this option to enable the right column\r\n  enable = 1\r\n    #cat=right/color; type=color; label=Right column bgColor: This is the background color of content in the right column.\r\n  bgColor = \r\n    #cat=right/dims; type=int+; label=Max Image Width: This indicates that maximum number of pixels (width) a block of images inserted as content is allowed to consume. NOTE: This is specific for the right column! The figure should approx. match the width of the image in the top of this column!\r\n  maxImageWidth = 200\r\n    #cat=right/typo; type=small; label=Bodytext font face\r\n  textStyle_face = Verdana\r\n    #cat=right/typo; type=int[1-5]; label=Bodytext font size\r\n  textStyle_size = 1\r\n    #cat=right/typo; type=color; label=Bodytext font color\r\n  textStyle_color = black\r\n    #cat=right/typo; type=int[1-5]; label=Default Header type: Enter the number of the header layout to be used by default. \r\n  defaultHeaderType = 2\r\n    # cat=right; type=comment; label= Left instead of right?: Click this option, if you want the right column to appear to the left instead.\r\n  leftComment = #\r\n    # cat=right; type=int+; label=Content width: This value defines the width in pixels of the table cell where the content is displayed\r\n  width = 200\r\n}\r\n\r\n# General:\r\n\r\ncontent.wrap.header1 = <div align=\"center\"><font face=\"verdana\" size=\"4\" color=\"#000099\"><b> | </b></font></div>\r\ncontent.wrap.header2 = <font face=\"verdana\" size=\"4\" color=\"#000099\"><b> | </b></font>\r\ncontent.wrap.header3 = <div align=\"center\"><font face=\"verdana\" size=\"5\" color=\"#000099\"><b> | </b></font></div>\r\nstyles.content.imgtext {\r\n  borderColor = #000099\r\n  borderThick = 4\r\n}\r\ncontent.bulletImages.default = <img src=\"media/uploads/candidate/dot_round.gif\" alt=\"\" />\r\nstyles.content.links.wrap = <b> | </b>\r\n\r\n\r\n# THIS IS NORMALLY SET IN STANDARD TEMLATES:\r\n\r\n# Image widths (remember contentwidth!)\r\nstyles.content.imgtext.maxW = 400\r\n\r\n\r\n# Targets\r\nPAGE_TARGET =\r\ncontent.pageFrameObj = \r\n\r\n  # cat=basic/color/a; type=color; label=Background color: This is the <body>-tag background color of the page.\r\nbgCol = white\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = #000099\r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = #000099\r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = red\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"CANDIDATE\"\r\n  description = CANDIDATE is a single-page template with two content columns and a text-based level 1 menu below the top image in the main column.\r\n  bulletlist = Right column: You can disable this column or choose to display it on the left instead. // Right column bar: Text or image. The height is depending on the menu height in the main column. (6) // Top image: The page title (or subtitle if present) is printed on this image. You can disable that. Also you can choose to let the top image expand over both the right column and the main column. In addition the image may vary from section to section on the site as the first image attached to a page on the first menulevel will be used instead. (4,7)// Gap between columns: You can disable it, control the widths and color used. // Right column top image: You can define an image to be shown in the top of the right column. (5) // Text menu: You can disable it and choose to display the page title below it. \r\n  image = gfx/CANDIDATE_basic.gif\r\n  1=page.offset\r\n  2=page.contentOffset\r\n  3=page.width,styles.content.imgtext.maxW\r\n  4=file.left_bar\r\n  5=file.right_bar\r\n  6=file.right_subbar\r\n  7=file.left_bar_fontFile,leftBar.enable,leftBar.fontSize,leftBar.fontColor,leftBar.offset,leftBar.align\r\n  8=file.background,bgCol\r\n}\r\nTSConstantEditor.page {\r\n  header = Standard Template \"CANDIDATE\"\r\n  image = gfx/CANDIDATE_page.gif\r\n  1=page.leftImageExpand\r\n  2=page.contentBgColor\r\n  3=page.titleValue,page.titleWrap\r\n  4=pagetitle.enable,pagetitle.wrap,pagetitle.spaceBefore,pagetitle.spaceAfter\r\n  5=gap.linecolor,gap.width.line,gap.width.right,gap.width.left\r\n}\r\nTSConstantEditor.menu {\r\n  header = Standard Template \"CANDIDATE\"\r\n  description = Text based, horizontal menu\r\n  bulletlist = \r\n  image = gfx/CANDIDATE_menu.gif\r\n  1=menu.gapwidth\r\n  2=menu.itemHeight\r\n  3=menu.spaceBefore\r\n  4=menu.spaceAfter\r\n}\r\n','\r\n# Page title\r\ntemp.pageTitle = TEXT\r\ntemp.pageTitle {\r\n  if.isTrue = {$pagetitle.enable}\r\n  field = title\r\n  override.field = subtitle\r\n  fontTag = {$pagetitle.wrap}\r\n  space = {$pagetitle.spaceBefore} | {$pagetitle.spaceAfter}\r\n}\r\n\r\n\r\n## The header:\r\ntemp.header = IMAGE\r\ntemp.header.wrap = |<br />\r\ntemp.header.file = GIFBUILDER\r\ntemp.header.file {\r\n  XY = [5.w], [5.h]\r\n  5 = IMAGE\r\n\r\n  5.file = {$file.left_bar}\r\n  5.file.import = uploads/media/\r\n  5.file.import.data = levelmedia : 1\r\n  5.file.import.listNum=0\r\n\r\n  10 = TEXT\r\n  10.text.field = nav_title // title\r\n  10.text.override.field = subtitle\r\n  10.text.if.isTrue = {$leftBar.enable}\r\n  10.fontFile = {$file.left_bar_fontFile}\r\n  10.fontSize = {$leftBar.fontSize}\r\n  10.fontColor = {$leftBar.fontColor}\r\n  10.offset = {$leftBar.offset}\r\n  10.align = {$leftBar.align}\r\n  10.niceText = 1\r\n}\r\n\r\n## The textmenu\r\ntemp.tmenu = HMENU\r\ntemp.tmenu.if.isTrue = {$menu.enable}\r\ntemp.tmenu.entryLevel = 0\r\ntemp.tmenu.stdWrap.space = {$menu.spaceBefore} | {$menu.spaceAfter}\r\ntemp.tmenu.1 = TMENU\r\ntemp.tmenu.1.wrap = <table border=\"0\" cellpadding=\"1\" cellspacing=\"0\" width=\"100%\"><tr> | </tr></table>\r\ntemp.tmenu.1.NO {\r\n  ATagBeforeWrap = 1\r\n  allWrap = |*||*|     <td bgcolor=\"{$menu.bgcolor}\" align=\"center\" width=\"10%\">  | </td><td width=\"1%\"><img src=\"clear.gif\" width=\"{$menu.gapwidth}\" height=\"{$menu.itemHeight}\" alt=\"\" /></td>     ||     <td bgcolor=\"{$menu.bgcolor}\" align=\"center\" width=\"10%\">  | </td>\r\n  linkWrap = {$menu.wrap}\r\n}\r\ntemp.tmenu.1.ACT < temp.tmenu.1.NO\r\ntemp.tmenu.1.ACT = 1\r\ntemp.tmenu.1.ACT.stdWrap.wrap = <u> |</u>\r\n\r\n## titlefield\r\ntemp.titlefield = IMAGE\r\ntemp.titlefield.file = {$file.right_subbar}\r\ntemp.titlefield.wrap = | <br />\r\ntemp.titlefield.stdWrap.ifEmpty = {$page.titleValue}\r\ntemp.titlefield.stdWrap.ifEmpty.wrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td bgcolor=\"{$menu.bgcolor}\" align=\"center\">{$page.titleWrap}</td><td bgcolor=\"{$menu.bgcolor}\"><img src=\"clear.gif\" width=\"1\" height=\"{$menu.itemHeight}\" alt=\"\" /></td></tr></table>\r\ntemp.titlefield.stdWrap.space = {$menu.spaceBefore} | {$menu.spaceAfter}\r\n\r\n\r\n## PAGE:\r\npage = PAGE\r\npage.typeNum = 0\r\npage.bodyTag < styles.content.bodyTag\r\npage.noLinkUnderline = 1\r\npage.bodyTagMargins = 0\r\npage.bgImg = {$file.background}\r\npage.wrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"1\"><tr> |</tr></table>\r\npage.stdWrap {\r\n  append < temp.header\r\n  append.wrap = |<br />\r\n  append.if.isTrue = {$page.leftImageExpand}\r\n  append.stdWrap.wrapAlign = {$page.align}\r\n\r\n  offsetWrap = {$page.offset}\r\n  offsetWrap.stdWrap.wrapAlign = {$page.align}\r\n}\r\n\r\npage.10 = COA\r\npage.10.wrap = <td valign=\"top\" bgcolor=\"{$page.contentBgColor}\"> | </td>\r\npage.10 {\r\n  5 < temp.header\r\n  5.wrap = |<br />\r\n  5.if.isFalse = {$page.leftImageExpand}\r\n  10 < temp.tmenu\r\n  12 < temp.pageTitle\r\n  20 = COA\r\n  20.stdWrap.offsetWrap = {$page.contentOffset}\r\n  20.10 = TEXT\r\n  20.10.value = <img src=\"clear.gif\" width=\"{$page.width}\" height=\"1\" alt=\"\" /><br />\r\n  20.15 < styles.content.editPanelPage\r\n  20.20 < styles.content.get\r\n  20.30 < styles.content.lastUpdate\r\n  20.40 < styles.content.typo3_powered\r\n}\r\n\r\npage.20 = TEXT\r\npage.20.value = <td><img src=\"clear.gif\" width=\"{$gap.width.left}\" height=\"1\" alt=\"\" /></td>\r\npage.20.if.isTrue = {$gap.width.left}\r\npage.21 = TEXT\r\npage.21.value = <td bgcolor=\"{$gap.linecolor}\"><img src=\"clear.gif\" width=\"{$gap.width.line}\" height=\"1\" alt=\"\" /></td>\r\npage.21.if.isTrue = {$gap.width.line}\r\npage.22 = TEXT\r\npage.22.value = <td><img src=\"clear.gif\" width=\"{$gap.width.right}\" height=\"1\" alt=\"\" /></td>\r\npage.22.if.isTrue = {$gap.width.right}\r\n\r\npage.30 = COA\r\npage.30.if.isTrue = {$rightCol.enable}\r\npage.30.wrap = <td valign=\"top\" bgcolor=\"{$rightCol.bgColor}\"><img src=\"clear.gif\" width=\"{$rightCol.width}\" height=\"1\" alt=\"\" /><br /> | </td>\r\npage.30 {\r\n  5 = IMAGE\r\n  5.file = {$file.right_bar}\r\n  5.wrap = | <br />\r\n  5.if.isFalse = {$page.leftImageExpand}\r\n  10 < temp.titlefield\r\n\r\n  15 = LOAD_REGISTER\r\n  15.maxImageWidth = {$rightCol.maxImageWidth}\r\n  15.textStyle_face = {$rightCol.textStyle_face}\r\n  15.textStyle_size = {$rightCol.textStyle_size}\r\n  15.textStyle_color = {$rightCol.textStyle_color}\r\n  15.defaultHeaderType = {$rightCol.defaultHeaderType}\r\n  15.pageColor = {$rightCol.bgColor}\r\n\r\n  20 < styles.content.getBorder\r\n  25 = RESTORE_REGISTER\r\n}\r\n\r\n\r\n\r\n{$rightCol.leftComment} page.5 < page.30\r\n{$rightCol.leftComment} page.6 < page.20\r\n{$rightCol.leftComment} page.7 < page.21\r\n{$rightCol.leftComment} page.8 < page.22\r\n{$rightCol.leftComment} page.30 >\r\n{$rightCol.leftComment} page.20 >\r\n{$rightCol.leftComment} page.21 >\r\n{$rightCol.leftComment} page.22 >\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\n\r\n','','');
INSERT INTO `static_template` VALUES (70,0,1054753870,994368694,'template; RE','19,43,68','topFrameHeight = 91\r\nleftFrameWidth = 197\r\n\r\nbackground.file {\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Left frame background image:\r\n  left = media/uploads/re/left_background.gif\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Top frame background image:\r\n  top = media/uploads/re/top_background.gif\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Page frame background image:\r\n  page = \r\n}\r\n\r\n\r\ntopmenu {\r\n    # cat=menu/file; type=int+; label=Background image width: Enter the width of the menu background image (pixels)\r\n  bgImgWidth = 674\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Expanding Background Image: The text of the menu items are printed on this background image which expands horizontally behind the items.\r\n  file.background = media/uploads/re/menuback.gif\r\n    # cat=menu/typo; type=file[ttf]; label=Font file: TrueType (ttf) font for the menu. \r\n  file.font = \r\n    # cat=menu/typo; type=int[1-40]; label=Font size: Font size on menu items\r\n  fontSize = 13\r\n    # cat=menu/typo; type=color; label=Font color: Font color on menu items\r\n  fontColor = #006699\r\n    # cat=menu/typo; type=offset; label=Text offset: Enter the offset of the text from the upper-left corner on the menu items\r\n  offset =  11,12\r\n    # cat=menu/typo; type=int+; label=Font spacing: Letter spacing of the menu items\r\n  spacing = 2\r\n\r\n    # cat=menu/typo/zaa; type=boolean; label=Rollover: Click this option if you want a rollover (mouseover) effect on the menu items.\r\n  RO = 1\r\n    # cat=menu/typo/zab; type=color; label=Rollover, font color: Enter the rollover font color of the text on the menu item.\r\n  RO.fontColor = #DF0029\r\n    # cat=menu/typo/zba; type=boolean; label=Active: Click this option if you want menu items to be active. \'Active\' means that you\'ve clicked the item and are now in that section of the website.\r\n  ACT = 1\r\n    # cat=menu/typo/zbb; type=color; label=Active, font color: Enter the active font color of the text on the menu item.\r\n  ACT.fontColor = #DF0029\r\n\r\n    # cat=menu/dims; type=int+; label=Space between items: \r\n  itemDistance = 25\r\n    # cat=menu//x; type=int[0-256]; label=Reduce colors: Number of indexed colors on menu items. If your menu items end up with weird colors, you can try to enter a higher number of colors. But the graphics-files will also increase their filesize.\r\n  reduceColors = 16\r\n}\r\n\r\n  # cat=top/dims; type=offset; label=Menu offset:\r\ntop.menuOffset = 0,0\r\n  # cat=top/dims; type=offset; label=Logo offset:\r\ntop.logoOffset = 200,0\r\n  # cat=top/file/t; type=file[IMAGE_EXT]; label=Top logo:\r\ntop.file.logo = media/uploads/re/my_logo.gif\r\n  # cat=top/file/t; type=file[IMAGE_EXT]; label=Left-of-menu image:\r\ntop.file.leftOfMenu = media/uploads/re/top_leftofmenu.gif\r\n  # cat=top/dims; type=offset; label=Offset, Left-of-menu image:\r\ntop.leftOfMenuOffset = 0,0\r\n\r\n\r\nleftmenu {\r\n    # cat=leftmenu/file; type=file[IMAGE_EXT]; label=Background image: This is the background image of a normal mode menu item\r\n  file.background = media/uploads/re/leftmenu_no.gif\r\n    # cat=leftmenu/file/z8; type=file[IMAGE_EXT]; label=Background image, Rollover: This is the background image of a rollover mode menu item\r\n  RO.file.background = media/uploads/re/leftmenu_ro.gif\r\n    # cat=leftmenu/file/z9; type=file[IMAGE_EXT]; label=Background image, Active: This is the background image of a active mode menu item\r\n  ACT.file.background = media/uploads/re/leftmenu_act.gif\r\n\r\n    # cat=leftmenu/typo; type=file[ttf]; label=Font file: TrueType (ttf) font for the menu. \r\n  file.font = \r\n    # cat=leftmenu/typo; type=int[1-40]; label=Font size: Font size on menu items\r\n  fontSize = 12\r\n    # cat=leftmenu/typo; type=color; label=Font color: Font color on menu items\r\n  fontColor = #E9F6FB\r\n    # cat=leftmenu/typo; type=int+; label=Font spacing: Letter spacing of the menu items\r\n  spacing = 0\r\n    # cat=leftmenu/typo; type=offset; label=Text offset: Enter the offset of the text from the upper-left corner on the menu items\r\n  offset =  -33,14\r\n    # cat=leftmenu/typo; type=options[left,right,center]; label=Alignment of text: Alignment of text on the menu items\r\n  align = right\r\n\r\n\r\n    # cat=leftmenu/typo/zaa; type=boolean; label=Rollover: Click this option if you want a rollover (mouseover) effect on the menu items.\r\n  RO = 1\r\n    # cat=leftmenu/typo/zab; type=color; label=Rollover, font color: Enter the rollover font color of the text on the menu item.\r\n  RO.fontColor = #E9F6FB\r\n    # cat=leftmenu/typo/zba; type=boolean; label=Active: Click this option if you want menu items to be active. \'Active\' means that you\'ve clicked the item and are now in that section of the website.\r\n  ACT = 1\r\n    # cat=leftmenu/typo/zbb; type=color; label=Active, font color: Enter the active font color of the text on the menu item.\r\n  ACT.fontColor = #E9F6FB\r\n\r\n    # cat=leftmenu//x; type=int[0-256]; label=Reduce colors: Number of indexed colors on menu items. If your menu items end up with weird colors, you can try to enter a higher number of colors. But the graphics-files will also increase their filesize.\r\n  reduceColors = 16\r\n}\r\n\r\n  # cat=leftmenu/dims; type=offset; label=Offset, whole menu: Enter the offset of the whole menu-block from upper-left corner of the left frame.\r\nleft.offset = 0,0\r\n  # cat=leftmenu/file; type=file[IMAGE_EXT]; label=After menu image: This is an image placed after the menu-items. It doesn\'t appear if the menu is empty.\r\nleft.file.afterMenuImage = media/uploads/re/menu_afterimage.gif\r\n\r\nleft.menuWrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"> |</table>\r\nleft.itemWrap = <tr><td>|</td></tr>\r\n\r\n\r\n\r\n  # cat=basic/file/t; type=file[css]; label=Page frame stylesheet:\r\npage.file.stylesheet = \r\n  # cat=basic/dims; type=offset; label= Page offset: Offset of the whole page-table from upper-left corner of the browser-window\r\npage.offset = 0,0\r\n  # cat=basic/dims; type=int+; label=Content width: This value defines the width in pixels of the table cell where the content is displayed\r\npage.contentWidth = 600\r\n\r\n\r\n\r\n  # cat=basic/color/a; type=color; label=Background color: This is the <body>-tag background color of the page.\r\nbgCol = white\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = \r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = \r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = \r\n\r\nPAGE_TARGET = page\r\ncontent.pageFrameObj = page\r\nstyles.content.imgtext.maxW = 600\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"RE\"\r\n  description = This is a frame-based template. There\'s a top frame with a graphical menu, 1. level. There\'s a left frame with a graphical menu, 2. level. And there\'s a page frame for the content. You can define rollover and active states for the menu items.\r\n  bulletlist = 3 frames, top, left and page. // Top logo image. // Background images in all frames (optional). // Select background images and colors for the left menu for normal, rollover and active state. // Select font color for normal, rollover and active state of the top menu. // Set an image below the left menu. \r\n  image = gfx/RE_basic.gif\r\n  1=leftFrameWidth\r\n  2=topFrameHeight\r\n  3=page.offset\r\n  4=page.contentWidth,styles.content.imgtext.maxW\r\n  5=background.file.left\r\n  6=background.file.top\r\n  7=background.file.page,page.file.stylesheet,bgCol\r\n}\r\nTSConstantEditor.menu {\r\n  header = Standard Template \"RE\"\r\n  description = Primary menu in top frame (level 1).\r\n  bulletlist = Rollover and Active state colors. // Background image, which expands continually behind the items on the menu.\r\n  image = gfx/RE_menu.gif\r\n  1=topmenu.file.background,topmenu.bgImgWidth\r\n  2=topmenu.itemDistance\r\n  3=topmenu.RO,topmenu.RO.fontColor\r\n  4=topmenu.file.font,topmenu.fontSize,topmenu.fontColor,topmenu.offset,topmenu.spacing\r\n}\r\nTSConstantEditor.top {\r\n  header = Standard Template \"RE\"\r\n  description = Top frame features\r\n  bulletlist = Menu with horizontally expanding background image. // Logo image // Image to the left of the menu.\r\n  image = gfx/RE_top.gif\r\n  1=top.menuOffset\r\n  2=top.logoOffset\r\n  3=top.leftOfMenuOffset\r\n  4=top.file.logo\r\n  5=top.file.leftOfMenu\r\n}\r\nTSConstantEditor.leftmenu {\r\n  header = Standard Template \"RE\"\r\n  description = Secondary menu in left frame (level 2).\r\n  bulletlist = Rollover and Active state background images. // Image after menu. // Offset in the left frame.\r\n  image = gfx/RE_leftmenu.gif\r\n  1=left.offset\r\n  2=leftmenu.file.background,leftmenu.file.font,leftmenu.fontSize,leftmenu.fontColor,leftmenu.spacing,leftmenu.offset,leftmenu.align\r\n  3=leftmenu.RO.file.background,leftmenu.RO.fontColor,leftmenu.RO\r\n  4=left.file.afterMenuImage\r\n}\r\n\r\n','# Topmenu\r\ntemp.topmenu = HMENU\r\ntemp.topmenu.stdWrap.offsetWrap = {$top.menuOffset}\r\ntemp.topmenu.1 = GMENU\r\ntemp.topmenu.1.target = _top\r\ntemp.topmenu.1.applyTotalW = 5\r\ntemp.topmenu.1.max = {$topmenu.bgImgWidth}\r\ntemp.topmenu.1.min = {$topmenu.bgImgWidth}\r\ntemp.topmenu.1.NO {\r\n  XY = [10.w]+{$topmenu.itemDistance},  [5.h]\r\n  backColor = red\r\n  reduceColors = {$topmenu.reduceColors}\r\n  5 = IMAGE\r\n  5.file = {$topmenu.file.background}\r\n\r\n  10 = TEXT\r\n  10.text.field = nav_title // title\r\n  10.offset ={$topmenu.offset}\r\n  10.fontFile = {$topmenu.file.font}\r\n  10.fontColor = {$topmenu.fontColor}\r\n  10.fontSize = {$topmenu.fontSize}\r\n  10.niceText = 1\r\n  10.spacing = {$topmenu.spacing}\r\n}\r\ntemp.topmenu.1.RO < temp.topmenu.1.NO\r\ntemp.topmenu.1.RO = {$topmenu.RO}\r\ntemp.topmenu.1.RO {\r\n  10.fontColor = {$topmenu.RO.fontColor}\r\n}\r\ntemp.topmenu.1.ACT < temp.topmenu.1.NO\r\ntemp.topmenu.1.ACT = {$topmenu.ACT}\r\ntemp.topmenu.1.ACT {\r\n  10.fontColor = {$topmenu.ACT.fontColor}\r\n}\r\n\r\n\r\n# Leftmenu\r\ntemp.leftmenu = HMENU\r\ntemp.leftmenu.stdWrap.required = 1\r\ntemp.leftmenu.stdWrap.offsetWrap = {$left.offset} \r\ntemp.leftmenu.stdWrap {\r\n  prepend = IMAGE\r\n  prepend.file = {$left.file.afterMenuImage}\r\n  prepend.wrap = {$left.itemWrap}\r\n  wrap3 = {$left.menuWrap}\r\n}\r\ntemp.leftmenu.entryLevel = 1\r\ntemp.leftmenu.1 = GMENU\r\ntemp.leftmenu.1.target = frameset2\r\ntemp.leftmenu.1.NO {\r\n  wrap= {$left.itemWrap}\r\n  XY = [5.w],  [5.h]\r\n  backColor = red\r\n  reduceColors = {$leftmenu.reduceColors}\r\n  5 = IMAGE\r\n  5.file = {$leftmenu.file.background}\r\n\r\n  10 = TEXT\r\n  10.text.field = nav_title // title\r\n  10.offset ={$leftmenu.offset}\r\n  10.fontFile = {$leftmenu.file.font}\r\n  10.fontColor = {$leftmenu.fontColor}\r\n  10.fontSize = {$leftmenu.fontSize}\r\n  10.align = {$leftmenu.align}\r\n  10.niceText = 1\r\n  10.spacing = {$leftmenu.spacing}\r\n}\r\ntemp.leftmenu.1.RO < temp.leftmenu.1.NO\r\ntemp.leftmenu.1.RO = {$leftmenu.RO}\r\ntemp.leftmenu.1.RO {\r\n  5.file = {$leftmenu.RO.file.background}\r\n  10.fontColor = {$leftmenu.RO.fontColor}\r\n}\r\ntemp.leftmenu.1.ACT < temp.leftmenu.1.NO\r\ntemp.leftmenu.1.ACT = {$leftmenu.ACT}\r\ntemp.leftmenu.1.ACT {\r\n  5.file = {$leftmenu.ACT.file.background}\r\n  10.fontColor = {$leftmenu.ACT.fontColor}\r\n}\r\n\r\n\r\n# LEFT FRAME, menu\r\nleft.bgImg = {$background.file.left}\r\nleft.bodyTagMargins = 0\r\nleft.10 < temp.leftmenu\r\n\r\n# TOP FRAME, menu\r\ntop.bgImg = {$background.file.top}\r\ntop.bodyTagMargins = 0\r\ntop.wrap = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"> | </table>\r\ntop.5 = HTML\r\ntop.5.value = <tr><td colspan=\"2\" valign=\"top\">\r\ntop.10 = IMAGE\r\ntop.10.file = {$top.file.logo}\r\ntop.10.stdWrap.offsetWrap = {$top.logoOffset}\r\ntop.10.linkWrap = <a href=\"index.php?{0}\" target=\"_top\"> |</a>\r\ntop.15 = HTML\r\ntop.15.value = </td></tr><tr><td valign=\"top\">\r\ntop.20 = IMAGE\r\ntop.20.file = {$top.file.leftOfMenu}\r\ntop.20.stdWrap.offsetWrap = {$top.leftOfMenuOffset}\r\ntop.25 = HTML\r\ntop.25.value = </td><td valign=\"top\">\r\ntop.30 < temp.topmenu\r\ntop.35 = HTML\r\ntop.35.value = </td></tr>\r\n\r\n# PAGE\r\npage.bgImg = {$background.file.page}\r\npage.stylesheet = {$page.file.stylesheet}\r\npage.bodyTag < styles.content.bodyTag\r\npage.10 = CTABLE\r\npage.10 {\r\n  offset = {$page.offset}\r\n  c.5 < styles.content.editPanelPage\r\n  c.10 < styles.content.get\r\n  c.30 < styles.content.lastUpdate\r\n  c.40 < styles.content.typo3_powered\r\n\r\n  cWidth = {$page.contentWidth}\r\n  tableParams = border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"{$page.contentWidth}\"\r\n}\r\n\r\n\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\nframeset.headerData.999 < plugin.meta\r\n\r\n\r\n','','');
INSERT INTO `static_template` VALUES (71,0,1054753840,994370877,'template; NEWSLETTER','43,68,82','styles.content.imgtext.comment_CSL-LinkList = \r\ncontent.defaultHeaderType = 5\r\n\r\n  # cat=basic/file/t; type=file[css]; label=Page stylesheet:\r\npage.file.css = media/uploads/newsletter/style.css\r\n  # cat=basic/file/t; type=file[html,htm,txt,tmpl]; label=Page template file:\r\npage.file.template = media/uploads/newsletter/template.html\r\n  # cat=basic/file/t; type=file[IMAGE_EXT]; label=Top frame logo image:\r\npage.file.toplogo =  media/uploads/newsletter/toplogo.gif\r\n\r\n\r\n  # cat=basic/color/a; type=color; label=Header frame color, right:\r\nright.frameCol = #90A8BF\r\n  # cat=basic/color/a; type=color; label=Bottom line color:\r\nlineCol = #90A8BF\r\n  # cat=basic//; type=string; label=Copyright email\r\ncopyright = stuff@stuff.dk\r\n\r\n  # cat=basic/color/a; type=color; label=Background color: This is the <body>-tag background color of the page.\r\nbgCol = #eaf6f6\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = #90a8bf\r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = #cccccc\r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = #90a8bf\r\n  # cat=basic/color/l; type=color; label=Text-color: Text color as defined in <body>-tag\r\ntext = #666666\r\n\r\n\r\nPAGE_TARGET = \r\ncontent.pageFrameObj = \r\nstyles.content.imgtext.maxW = 400\r\n  # cat=basic/dims; type=int+; label=Content width: This value defines the width in pixels of the table where the content is displayed in the page-frame\r\ncontentWidth = 400\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"NEWSLETTER\"\r\n  description = This is a single-page template with no menu! It\'s designed to be used as a newsletter template sent as an HTML-email with the internal Direct Mail module. It\'s based on an HTML-template file, so the main layout of the page is depending on the content of that template. One thing excluded from the template is the top logo which is defined directly in TypoScript.\r\n  bulletlist = HTML-template file based. Redesign it with your favourite HTML-editor! // Features content in two columns (optional). // By default headers in the margin column are based on header layout 5, which is an image-header. \r\n  image = gfx/NEWSLETTER_basic.gif\r\n  1=page.file.css,page.file.template\r\n  2=page.file.toplogo\r\n  3=bgCol\r\n}\r\n','config.insertDmailerBoundaries = 1\r\n\r\n\r\n# Redefining header type 5\r\n\r\nlib.stdheader.10.5.file.10.antialias = 0\r\nlib.stdheader.10.5.file.10.fontColor = #666666\r\nlib.stdheader.10.5.file.XY = 400 ,30\r\nlib.stdheader.10.5.file.10.fontSize = 12\r\nlib.stdheader.10.5.file.10.offset = 6,18\r\nlib.stdheader.10.5.file.XY = 400 ,27\r\nlib.stdheader.10.5.file {\r\n  20 = BOX\r\n  20.dimensions = 0,0,400,1\r\n  20.color = {$right.frameCol}\r\n  21 < .20\r\n  21.align = , b\r\n  22 < .20\r\n  22.dimensions = 0,0,1,40\r\n  23 < .22\r\n  23.align = r\r\n}\r\nlib.stdheader.10.4 >\r\nlib.stdheader.10.4 < lib.stdheader.10.5\r\nlib.stdheader.10.4.file.XY = 185,27\r\n\r\n\r\n\r\n# Setting up page\r\n\r\npage = PAGE\r\npage.typeNum = 0\r\npage.stylesheet = {$page.file.css}\r\npage.hoverStyle = COLOR: #cccccc; TEXT-DECORATION: underline\r\npage.bodyTag = <body text=\"{$text}\" vlink=\"{$vlink}\" alink=\"{$alink}\" link=\"{$link}\" bgcolor=\"{$bgCol}\" leftmargin=\"0\" topmargin=\"5\">\r\n\r\npage.stdWrap.offsetWrap = 10,0\r\npage.5 = IMAGE\r\npage.5.wrap = |<br />\r\npage.5.file = {$page.file.toplogo}\r\n\r\npage.10 = TEMPLATE\r\npage.10 {\r\n  template = FILE\r\n  template.file = {$page.file.template}\r\n  marks.CONTENT_NORMAL = COA\r\n  marks.CONTENT_NORMAL {\r\n    5 < styles.content.editPanelPage\r\n    10 < styles.content.get\r\n    30 < styles.content.lastUpdate\r\n    40 < styles.content.typo3_powered\r\n  }\r\n  marks.CONTENT_MARGIN = COA\r\n  marks.CONTENT_MARGIN {\r\n    10 = LOAD_REGISTER\r\n    10.defaultHeaderType = 4\r\n    20 < styles.content.getBorder\r\n    30 = RESTORE_REGISTER\r\n  }\r\n  marks.LINECOLOR = TEXT\r\n  marks.LINECOLOR.value = {$lineCol}\r\n  marks.COPYRIGHT = TEXT\r\n  marks.COPYRIGHT.value = {$copyright}\r\n}\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\n\r\n## HTML mail ping:\r\npage.20 = TEXT\r\npage.20.value = <img src=\"t3lib/gfx/dmailerping.gif\" width=\"1\" height=\"1\" dmailerping=\"1\" alt=\"\" />\r\n\r\n## Plain text setup:\r\nlib.alt_plaintext.renderObj.header.2 {\r\n  preLineChar = \r\n  postLineChar >\r\n  preLineChar >\r\n  preLineLen >\r\n  postLineLen >\r\n  preBlanks = 0\r\n}\r\nalt_plaintext.10.marks.CONTENT >\r\nalt_plaintext.10.marks.CONTENT = COA\r\nalt_plaintext.10.marks.CONTENT {\r\n  10 < styles.content.get\r\n  10.renderObj = < lib.alt_plaintext.renderObj\r\n  20 < styles.content.getBorder\r\n  20.renderObj = < lib.alt_plaintext.renderObj\r\n}\r\n\r\nalt_plaintext_test.10.marks.CONTENT < alt_plaintext.10.marks.CONTENT\r\n','','');
INSERT INTO `static_template` VALUES (72,0,1054753817,994370877,'template; HYPER','13,43,68','\r\nbackground.file {\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Top frame background image:\r\n  top = media/uploads/hyper/background_top.gif\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Page frame background image:\r\n  page = media/uploads/hyper/background_main.gif\r\n}\r\n  # cat=basic/file/t; type=file[IMAGE_EXT]; label=Top frame logo image:\r\ntop.logo = media/uploads/hyper/title.gif\r\n  # cat=basic/file/t; type=file[css]; label=Page frame stylesheet:\r\npage.css = media/uploads/hyper/sprache.css\r\n\r\ntopFrameHeight = 150\r\n\r\ntopmenu1 {\r\n    # cat=menu/dims; type=int+; label=Height of menu items (pixels)\r\n  height = 15\r\n    # cat=menu/dims; type=int+; label=Additional width: The menu items are getting their width from the title. This number is added to that making room for a margin.\r\n  addWidth = 20\r\n    # cat=menu/dims; type=int+; label=Space between items: \r\n  itemSpace = 30\r\n\r\n    # cat=menu/dims; type=int+; label=Y-offset of the pop-up layers: This is the distance in pixels from the top of the browser window to the menu pop-up layers\r\n  yOffset = 38\r\n    # cat=menu/dims; type=int+; label=X-offset of the pop-up layers: This is the distance in pixels from the left of the browser window to the menu pop-up layers\r\n  xOffset = 231\r\n\r\n    # cat=menu/color; type=color; label=Menu background color\r\n  bgCol = black\r\n    # cat=menu/color; type=color; label=Menu transparent color: Setting this to the same as the \'Menu background color\' will render the menu items transparent. This is looking best if you don\'t use antialiasing on the text.\r\n  bgCol_transp = black\r\n\r\n    # cat=menu/typo; type=file[ttf]; label=Font file: TrueType (ttf) font for the menu. Good fonts non-antialiased are Mini-7 (size 7) or verdana (size 10)\r\n  file.fontFile = \r\n    # cat=menu/typo; type=int[1-40]; label=Font size: Font size on menu items\r\n  fontSize = 10\r\n    # cat=menu/typo; type=color; label=Font color: Font color on menu items\r\n  fontColor = white\r\n    # cat=menu/typo; type=offset; label=Text offset: Enter the offset of the text from the upper-left corner on the menu items\r\n  fontOffset = 10,10\r\n    # cat=menu/typo; type=options[,upper,lower]; label=Text case: You can force the text on the menu items to be either lowercase or uppercase.\r\n  case =\r\n    # cat=menu/typo; type=boolean; label= Antialias: If this option is set, the fonts will be rendered antialiased. Default is \'off\' because of the transparent background.\r\n  antialias = 0\r\n\r\n    # cat=menu/color; type=color; label=Box Linecolor: Line color of the box making a border on each item\r\n  boxColor = #60C82F\r\n\r\n    # cat=menu/typo; type=boolean; label=Rollover: Click this option if you want a rollover (mouseover) effect on the menu items.\r\n  RO = 1\r\n    # cat=menu/typo; type=color; label=Rollover, background color:\r\n  RO.bgColor = #60C82F\r\n    # cat=menu/color; type=color; label=Rollover, Box Linecolor: Line color of the box making a border on each item.\r\n  RO.boxColor = white\r\n    # cat=menu/typo; type=color; label=Rollover, font color: Enter the rollover font color of the text on the menu item.\r\n  RO.fontColor = white\r\n}\r\n\r\n\r\n\r\n\r\n\r\ntopmenu2 {\r\n\r\n    # cat=menu2/; type=wrap; label=Wrap of the whole menu: This is by default a table with a white background color\r\n  menuWrap = <table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" bgcolor=\"white\"><tr><td>   <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#2F302F\"><tr><td>|</td></tr></table>  </td></tr></table>\r\n    # cat=menu2/; type=wrap; label=Wrap of each menu item: \r\n  itemWrap = | <br />\r\n\r\n    # cat=menu2/dims; type=int+; label=Height of menu items (pixels)\r\n  height = 12\r\n    # cat=menu2/dims; type=int+; label=Additional width: The menu items are getting their width from the page title. This number is added to that making room for margin.\r\n  addWidth = 5\r\n\r\n    # cat=menu2/color; type=color; label=Menu background color\r\n  bgCol = #2F302F\r\n    # cat=menu2/color; type=color; label=Menu transparent color: Setting this to the same as the \'Menu background color\' will render the menu items transparent. This is looking best if you don\'t use antialiasing on the text.\r\n  bgCol_transp = \r\n\r\n    # cat=menu2/typo; type=file[ttf]; label=Font file: TrueType (ttf) font for the menu. Good fonts non-antialiased are Mini-7 (size 7) or verdana (size 10)\r\n  file.fontFile = \r\n    # cat=menu2/typo; type=int[1-40]; label=Font size: Font size on menu items\r\n  fontSize = 10\r\n    # cat=menu2/typo; type=color; label=Font color: Font color on menu items\r\n  fontColor = #60C82F\r\n    # cat=menu2/typo; type=offset; label=Text offset: Enter the offset of the text from the upper-left corner on the menu items\r\n  fontOffset = 1,8\r\n    # cat=menu2/typo; type=options[,upper,lower]; label=Text case: You can force the text on the menu items to be either lowercase or uppercase.\r\n  case =\r\n    # cat=menu2/typo; type=boolean; label= Antialias: If this option is set, the fonts will be rendered antialiased. Default is \'off\' because of the transparent background.\r\n  antialias = 0\r\n\r\n    # cat=menu2/color; type=color; label=Linecolor: Line color between the items\r\n  lineColor = #606760\r\n\r\n    # cat=menu2/typo; type=boolean; label=Rollover: Click this option if you want a rollover (mouseover) effect on the menu items.\r\n  RO = 1\r\n    # cat=menu2/typo; type=color; label=Rollover, background color:\r\n  RO.bgColor = #60C82F\r\n    # cat=menu2/color; type=color; label=Rollover, Linecolor: Line color between the items\r\n  RO.lineColor = white\r\n    # cat=menu2/typo; type=color; label=Rollover, font color: Enter the rollover font color of the text on the menu item.\r\n  RO.fontColor = white\r\n}\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\ntoptitle{\r\n    # cat=toptitle/enable; type=boolean; label=Show the top title image?: If you unset this option, the top title image is not shown.\r\n  enable = 1\r\n    # cat=toptitle/dims; type=offset; label=Image offset: Enter the offset of the image\r\n  offset = 57,17\r\n    # cat=toptitle/dims; type=int+; label=Height of top title image (pixels)\r\n  height = 13\r\n    # cat=toptitle/dims; type=int+; label=Width of top title image (pixels)\r\n  width = 370\r\n\r\n    # cat=toptitle/color; type=color; label=Background color\r\n  bgCol = white\r\n    # cat=toptitle/color; type=color; label=Transparent color: Setting this to the same as the \'Menu background color\' will render the image transparent. This is looking best if you don\'t use antialiasing on the text.\r\n  bgCol_transp = white\r\n\r\n    # cat=toptitle/typo; type=file[ttf]; label=Font file: TrueType (ttf) font for the image. Good fonts non-antialiased are Mini-7 (size 7) or verdana (size 10)\r\n  file.fontFile = \r\n    # cat=toptitle/typo; type=int[1-40]; label=Font size: Font size on menu items\r\n  fontSize = 14\r\n    # cat=toptitle/typo; type=color; label=Font color: Font color on menu items\r\n  fontColor = #909790\r\n    # cat=toptitle/typo; type=offset; label=Text offset: Enter the offset of the text from the upper-left corner on the image\r\n  fontOffset = 0,9\r\n    # cat=toptitle/typo; type=options[,upper,lower]; label=Text case: You can force the text on the image to be either lowercase or uppercase.\r\n  case =\r\n    # cat=toptitle/typo; type=boolean; label= Antialias: If this option is set, the fonts will be rendered antialiased. Default is \'off\' because of the transparent background.\r\n  antialias = 0\r\n}\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n  # cat=basic/dims; type=int+; label=Content width: This value defines the width in pixels of the table where the content is displayed in the page-frame\r\ncontentWidth = 560\r\nstyles.content.imgtext.maxW = 560\r\n\r\n  # cat=basic/color/a; type=color; label=Background color: This is the <body>-tag background color of the page.\r\nbgCol = #333333\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = \r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = \r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = \r\n\r\n  # cat=page/dims; type=offset; label=Content field offset: Enter the offset of the content cell from the upper-left corner of the page frame\r\npage.offset = 30,40\r\n  # cat=page/color/x; type=color; label=Content cell background color: This is the color of the content cell\r\npage.contentCellBgCol = #333333\r\n\r\n  # cat=page/dims; type=offset; label=Top frame offset: Enter the offset of the content in the top frame. This includes logo and menu\r\ntop.offset = 0,25\r\n  # cat=page/dims; type=offset; label=Distance to menu: Enter the distance in pixels from the rigth edge of the logo to the menu\r\ntop.distFromLogoToMenu = 231\r\n\r\n\r\nPAGE_TARGET = page\r\ncontent.pageFrameObj = page\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"HYPER\"\r\n  description = Hyper is a frame-based template with a top frame containing the navigation and a page frame with the content in one column. The top navigation is based on DHTML layers. In addition the page title is rendered on an image and you can define a top logo.\r\n  bulletlist = DHTML graphical menu in top frame. // Top logo. (5) // Top page title image. // Define background images. (3,4) // Prepared for css stylesheet.\r\n  image = gfx/HYPER_basic.gif\r\n  1=topFrameHeight\r\n  2=contentWidth,styles.content.imgtext.maxW\r\n  3=background.file.top\r\n  4=background.file.page,page.css\r\n  5=top.logo\r\n}\r\nTSConstantEditor.page {\r\n  header = Standard Template \"HYPER\"\r\n  description = \r\n  bulletlist = \r\n  image = gfx/HYPER_page.gif\r\n  1=top.offset\r\n  2=top.distFromLogoToMenu\r\n  3=page.offset\r\n  4=page.contentCellBgCol\r\n}\r\nTSConstantEditor.toptitle {\r\n  header = Standard Template \"HYPER\"\r\n  description = This is a gif/png image with the page title printed on it. A special feature is that this image has a transparent background by default. That means you should use a font like Verdana, Arial or Mini7-series non-antialiased to get the best display.\r\n  bulletlist = Define TrueType font, size and color // Define antialiased / non-antialiased setting // Define letter case to upper- or lowercase\r\n  image = gfx/HYPER_toptitle.gif\r\n  1=toptitle.offset\r\n  2=toptitle.width\r\n  3=toptitle.height\r\n  4=toptitle.file.fontFile,toptitle.fontSize,toptitle.fontColor,toptitle.fontOffset,toptitle.case,toptitle.antialias,toptitle.bgCol,toptitle.bgCol_transp\r\n}\r\nTSConstantEditor.menu {\r\n  header = Standard Template \"HYPER\"\r\n  description = DHTML based graphical menu. This menu is featuring a 1-2 pixels border in selectable colors. It uses no background images. The menu is designed to work transparent on a page background.\r\n  bulletlist = Define border color for normal and rollover state.// Define background color for rollover state. // Define TrueType font, size and color // Define antialiased / non-antialiased setting // Define letter case to upper- or lowercase\r\n  image = gfx/HYPER_menu.gif\r\n  1=topmenu1.height\r\n  2=topmenu1.itemSpace\r\n  3=topmenu1.addWidth\r\n  4=topmenu1.yOffset,topmenu1.xOffset\r\n  5=topmenu1.file.fontFile,topmenu1.fontSize,topmenu1.fontColor,topmenu1.fontOffset,topmenu1.case,topmenu1.antialias,topmenu1.bgCol,topmenu1.bgCol_transp,topmenu1.boxColor\r\n  6=topmenu1.RO,topmenu1.RO.bgColor,topmenu1.RO.fontColor,topmenu1.RO.boxColor\r\n}\r\nTSConstantEditor.menu2 {\r\n  header = Standard Template \"HYPER\"\r\n  description = DHTML based graphical menu layers. This is the second level of the menu.\r\n  bulletlist = Define color of separator line. // Define border color for normal and rollover state.// Define background color for rollover state. // Define TrueType font, size and color // Define antialiased / non-antialiased setting // Define letter case to upper- or lowercase\r\n  image = gfx/HYPER_menu2.gif\r\n  1=topmenu2.height\r\n  2=topmenu2.file.fontFile,topmenu2.fontSize,topmenu2.fontColor,topmenu2.fontOffset,topmenu2.case,topmenu2.antialias,topmenu2.bgCol,topmenu2.bgCol_transp,\r\n  3=topmenu2.RO,topmenu2.RO.bgColor,topmenu2.RO.fontColor\r\n  4=topmenu2.lineColor,topmenu2.RO.lineColor\r\n}\r\n\r\n','includeLibs.gmenu_layers = media/scripts/gmenu_layers.php\r\n\r\n\r\n# Defining\r\n\r\ntemp.topmenu1 = HMENU\r\ntemp.topmenu1.wrap = <nobr> | </nobr>\r\ntemp.topmenu1.1 = GMENU_LAYERS\r\ntemp.topmenu1.1.target = _top\r\ntemp.topmenu1.1.NO {\r\n  wrap =  | <img src=\"clear.gif\" width=\"{$topmenu1.itemSpace}\" height=\"1\" alt=\"\" />\r\n  XY = [10.w]+{$topmenu1.addWidth},{$topmenu1.height}\r\n  transparentColor = {$topmenu1.bgCol_transp}\r\n  backColor = {$topmenu1.bgCol}\r\n\r\n  10 = TEXT\r\n  10.text.field = nav_title // title\r\n  10.text.case = {$topmenu1.case}\r\n  10.fontFile = {$topmenu1.file.fontFile}\r\n  10.fontSize = {$topmenu1.fontSize}\r\n  10.fontColor = {$topmenu1.fontColor}\r\n  10.antiAlias = {$topmenu1.antialias}\r\n  10.offset = {$topmenu1.fontOffset}\r\n\r\n  20 = BOX\r\n  20.color = {$topmenu1.boxColor}\r\n  20.dimensions = 1,1,[10.w]+{$topmenu1.addWidth}-2,1\r\n\r\n  21 = BOX\r\n  21.color = {$topmenu1.boxColor}\r\n  21.dimensions = 1,-1,[10.w]+{$topmenu1.addWidth}-2,1\r\n  21.align = ,b\r\n\r\n  22 = BOX\r\n  22.color = {$topmenu1.boxColor}\r\n  22.dimensions = 1,1,1,{$topmenu1.height}-2\r\n\r\n  23 = BOX\r\n  23.color = {$topmenu1.boxColor}\r\n  23.dimensions = -1,1,1,{$topmenu1.height}-2\r\n  23.align= r\r\n}\r\ntemp.topmenu1.1.RO  < temp.topmenu1.1.NO\r\ntemp.topmenu1.1.RO = {$topmenu1.RO}\r\ntemp.topmenu1.1.RO {\r\n\r\n  7 = BOX\r\n  7.color = {$topmenu1.RO.bgColor}\r\n  7.dimensions = 0,0,[10.w]+{$topmenu1.addWidth},{$topmenu1.height}\r\n\r\n  10.fontColor = {$topmenu1.RO.fontColor}\r\n\r\n  20 = BOX\r\n  20.color = {$topmenu1.RO.boxColor}\r\n  20.dimensions = 0,0,[10.w]+{$topmenu1.addWidth},2\r\n\r\n  21 = BOX\r\n  21.color = {$topmenu1.RO.boxColor}\r\n  21.dimensions = 0,0,[10.w]+{$topmenu1.addWidth},2\r\n  21.align = ,b\r\n\r\n  22 = BOX\r\n  22.color = {$topmenu1.RO.boxColor}\r\n  22.dimensions = 0,0,2,{$topmenu1.height}\r\n\r\n  23 = BOX\r\n  23.color = {$topmenu1.RO.boxColor}\r\n  23.dimensions = 0,0,2,{$topmenu1.height}\r\n  23.align= r\r\n}\r\n\r\ntemp.topmenu1.1 {\r\n  xPosOffset = -{$topmenu1.xOffset}\r\n  lockPosition = x\r\n  expAll = 1\r\n\r\n  topOffset = {$topmenu1.yOffset}\r\n  lockPosition_adjust = {$topmenu1.itemSpace}\r\n  directionLeft = 0\r\n  lockPosition_addSelf=0\r\n}\r\n\r\ntemp.topmenu1.2 = GMENU\r\ntemp.topmenu1.2.target = _top\r\ntemp.topmenu1.2.useLargestItemX = 1\r\ntemp.topmenu1.2.wrap = {$topmenu2.menuWrap}\r\ntemp.topmenu1.2.NO {\r\n wrap = {$topmenu2.itemWrap}\r\n\r\n  transparentColor = {$topmenu2.bgCol_transp}\r\n  backColor = {$topmenu2.bgCol}\r\n\r\n  XY = |*||*| [10.w]+{$topmenu2.addWidth},{$topmenu2.height} || [10.w]+{$topmenu2.addWidth},{$topmenu2.height}-1\r\n\r\n  10 = TEXT\r\n  10.text.field = nav_title // title\r\n  10.text.case = {$topmenu2.case}\r\n  10.fontFile = {$topmenu2.file.fontFile}\r\n  10.fontSize = {$topmenu2.fontSize}\r\n  10.fontColor = {$topmenu2.fontColor}\r\n  10.antiAlias = {$topmenu2.antialias}\r\n  10.offset = {$topmenu2.fontOffset}\r\n\r\n  30 = BOX\r\n  30.color = {$topmenu2.lineColor}\r\n  30.dimensions = 0,{$topmenu2.height}-1,300,1\r\n}\r\ntemp.topmenu1.2.RO < temp.topmenu1.2.NO\r\ntemp.topmenu1.2.RO = {$topmenu2.RO}\r\ntemp.topmenu1.2.RO {\r\n  backColor = {$topmenu2.RO.bgColor}\r\n  10.fontColor = {$topmenu2.RO.fontColor}\r\n  30.color = {$topmenu2.RO.lineColor}\r\n}\r\n\r\n\r\n\r\n\r\n\r\n\r\n# Top frame page\r\n\r\ntop.bgImg = {$background.file.top}\r\ntop.bodyTag = <body bgcolor=\"#FFFFFF\" text=\"#000000\">\r\ntop.bodyTagMargins = 0\r\ntop.10 = CTABLE\r\ntop.10 {\r\n  tableParams = border=\"0\" cellpadding=\"0\" cellspacing=\"0\"\r\n  offset = {$top.offset}\r\n\r\n  lm.1 = IMAGE\r\n  lm.1.file = {$top.logo}\r\n  lm.1.wrap = |<br />\r\n  lm.1.params = vspace=\"4\"\r\n\r\n  lm.3 = CLEARGIF\r\n  lm.3.width={$top.distFromLogoToMenu}\r\n\r\n  c.1 < temp.topmenu1\r\n}\r\n\r\ntop.20 = OTABLE\r\ntop.20.offset = {$toptitle.offset}\r\ntop.20.1 = IMAGE\r\ntop.20.1.if.isTrue = {$toptitle.enable}\r\ntop.20.1.file = GIFBUILDER\r\ntop.20.1.file {\r\n    XY = {$toptitle.width},{$toptitle.height}\r\n    backColor = {$toptitle.bgCol}\r\n    transparentColor = {$toptitle.bgCol_transp}\r\n    10=TEXT\r\n    10.text.field = nav_title // title\r\n    10.text.case = {$toptitle.case}\r\n    10.fontFile = {$toptitle.file.fontFile}\r\n    10.fontSize = {$toptitle.fontSize}\r\n    10.fontColor = {$toptitle.fontColor}\r\n    10.antiAlias = {$toptitle.antialias}\r\n    10.offset = {$toptitle.fontOffset}\r\n  }\r\ntop.20.1.wrap = |<br />\r\n\r\n\r\n# Page object\r\n\r\npage.bgImg = {$background.file.page}\r\npage.bodyTagMargins = 0\r\npage.bodyTag < styles.content.bodyTag\r\npage.stylesheet = {$page.css}\r\n\r\npage.10 = CTABLE\r\npage.10.offset = {$page.offset}\r\npage.10.cWidth={$contentWidth}\r\npage.10.tableParams = border=\"0\" cellpadding=\"10\" cellspacing=\"0\" width=\"{$contentWidth}\"\r\npage.10.c.TDParams = bgcolor=\"{$page.contentCellBgCol}\"\r\npage.10.c {\r\n  5 < styles.content.editPanelPage\r\n  10 < styles.content.get\r\n  30 < styles.content.lastUpdate\r\n  40 < styles.content.typo3_powered\r\n}\r\n\r\ntt_content.textpic.20.textMargin = 90\r\n\r\n\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\nframeset.headerData.999 < plugin.meta\r\n\r\n','','');
INSERT INTO `static_template` VALUES (73,0,1054753694,994370877,'template; CrCPH','43,68','  # cat=basic/file; type=file[html,htm,txt,inc,tmpl]; label=Template file:  This file is very important. It\'s the total template of the website. It\'s working with markers and subparts which define where menus, content and logos go. Two of the headertypes are defined inside as well! You should take a look into the default file and follow the directions inside.\r\npage.file.template = media/uploads/crcph/main.htm\r\n\r\n\r\ncontent.headerSpace >\r\nstyles.content.imgtext.maxW = 400\r\n\r\n\r\nPAGE_TARGET = \r\ncontent.pageFrameObj = \r\n\r\n  # cat=basic/color/a; type=color; label=Background color: This is the <body>-tag background color of the page.\r\nbgCol = #D6D3CE\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = #006699\r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = #00659C\r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = #00659C\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"CrCPH\"\r\n  description = CrCPH is a single-page template based on an HTML-template file. Thus most of the layout is done by redesigning the template file with your favorite HTML-editor! \r\n  bulletlist = Based on an actual HTML-template file and relies less on TypoScript. // Two text based menus defined directly in the HTML-template file. // The default content header is also defined directly in the HTML-template file. // Support for two columns of content.\r\n  image = gfx/CrCPH_basic.gif\r\n  1=page.file.template\r\n  2=styles.content.imgtext.maxW\r\n}\r\n\r\n','# Setting up the main template\r\n\r\ntemp.mainTemplate = TEMPLATE\r\ntemp.mainTemplate {\r\n  template = FILE\r\n  template.file = {$page.file.template} \r\n}\r\n\r\n\r\n# Setting up Level 1 menu, based on template!\r\n\r\ntemp.L1menu = HMENU\r\ntemp.L1menu.1 = TMENU\r\ntemp.L1menu.1.NO {\r\n  before.cObject < temp.mainTemplate\r\n  before.cObject {\r\n    workOnSubpart = SUB_MENU_ITEM\r\n    marks.MENU_TITLE = TEXT\r\n    marks.MENU_TITLE.field = title\r\n    wraps.LINK = TEXT\r\n    wraps.LINK {\r\n      value = |\r\n      typolink.parameter.field = uid\r\n    }\r\n  }\r\n  doNotShowLink = 1\r\n}\r\ntemp.L1menu.1.ACT < temp.L1menu.1.NO\r\ntemp.L1menu.1.ACT = 1\r\ntemp.L1menu.1.ACT.before.cObject.workOnSubpart = SUB_MENU_ITEM_ACT\r\n\r\n\r\n# Setting up Level 2 menu, based on template!\r\n\r\ntemp.L2menuItems = HMENU\r\ntemp.L2menuItems.entryLevel = 1\r\ntemp.L2menuItems.1 = TMENU\r\ntemp.L2menuItems.1.NO {\r\n  before.cObject < temp.mainTemplate\r\n  before.cObject {\r\n    workOnSubpart = SUB_L2MENU_ITEM\r\n    marks.MENU_TITLE = TEXT\r\n    marks.MENU_TITLE.field = title\r\n    wraps.LINK = TEXT\r\n    wraps.LINK {\r\n      value = |\r\n      typolink.parameter.field = uid\r\n    }\r\n  }\r\n  doNotShowLink = 1\r\n}\r\ntemp.L2menuItems.1.ACT < temp.L2menuItems.1.NO\r\ntemp.L2menuItems.1.ACT = 1\r\ntemp.L2menuItems.1.ACT.before.cObject.workOnSubpart = SUB_L2MENU_ITEM_ACT\r\n\r\ntemp.L2menu < temp.mainTemplate\r\ntemp.L2menu {\r\n  \r\n  workOnSubpart = SUB_L2MENU\r\n  subparts.SUB_L2MENU_ALLITEMS < temp.L2menuItems\r\n}\r\n\r\n\r\n\r\n\r\n# Page object\r\n\r\npage = PAGE\r\npage.typeNum = 0\r\npage.bodyTag < styles.content.bodyTag\r\npage.bodyTagMargins=0\r\npage.headerData.20 < temp.mainTemplate\r\npage.headerData.20 {\r\n  workOnSubpart = HEADER_DATA\r\n}\r\n\r\n\r\n\r\npage.10  < temp.mainTemplate\r\npage.10 {\r\n  workOnSubpart = DOCUMENT_BODY\r\n  subparts.SUB_CONTENT = COA\r\n  subparts.SUB_CONTENT {\r\n    5 < styles.content.editPanelPage\r\n    10 < styles.content.get\r\n    30 < styles.content.lastUpdate\r\n    40 < styles.content.typo3_powered\r\n  }\r\n  subparts.SUB_CONTENT_MARGIN = COA\r\n  subparts.SUB_CONTENT_MARGIN {\r\n    5 < temp.L2menu\r\n    10 = LOAD_REGISTER\r\n    10.defaultHeaderType = 2\r\n    10.maxImageWidth = 150\r\n    20 < styles.content.getBorder\r\n    30 = RESTORE_REGISTER\r\n  }\r\n  subparts.SUB_MENU < temp.L1menu\r\n}\r\n\r\n\r\n\r\nlib.stdheader.stdWrap >\r\nlib.stdheader.10.1 >\r\nlib.stdheader.10.1  < temp.mainTemplate\r\nlib.stdheader.10.1 {\r\n  workOnSubpart = SUB_HEADER1\r\n  marks.MARK_HEADER = TEXT\r\n  marks.MARK_HEADER.field = header\r\n}\r\nlib.stdheader.10.2 >\r\nlib.stdheader.10.2 < lib.stdheader.10.1\r\nlib.stdheader.10.2.workOnSubpart = SUB_HEADER2\r\nlib.stdheader.10.stdWrap.wrap >\r\n\r\n\r\ntt_content.menu.20.1 >\r\ntt_content.menu.20.1 < temp.L2menu\r\ntt_content.menu.20.1.subparts.SUB_L2MENU_ALLITEMS {\r\n  special = directory\r\n  special.value.field = pages\r\n}\r\n\r\n\r\n\r\n# Configuration\r\n\r\nconfig.extTarget = _blank\r\nconfig.compensateFieldWidth = 0.7\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\n\r\n','','');
INSERT INTO `static_template` VALUES (74,0,1054753787,997262098,'template; GREEN','75,43,68','page.file {\r\n    # cat=basic/file; type=file[html,htm,txt,inc,tmpl]; label=Template file:  This file is very important. It\'s the total template of the website. It\'s working with markers and subparts which define where menus, content and logos go. Two of the headertypes are defined inside as well! You should take a look into the default file and follow the directions inside.\r\n  template = media/uploads/green/template.tmpl\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Background image: Page background image\r\n  background = media/uploads/green/background_page.png\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Top image: This is the image in the upper right corner of the page. Depends on the existence of the marker, ###TOP_IMAGE###, in the template file.\r\n  topimage =  media/uploads/green/pict_top.jpg\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Top logo: This is the logo in the upper left corner of the page. Depends on the existence of the marker, ###TOP_LOGO###, in the template file.\r\n  toplogo =  media/uploads/green/pict_logo.png\r\n    # cat=basic/file/t; type=file[IMAGE_EXT]; label=Cell Background image: Cell or table background image, inserted as \'background=\"path_to_image\"\'. Depends on the existence of the marker, ###CELL_BACK###, in the template file.\r\n  cellBack = \r\n}\r\n\r\n\r\nsubmenu {\r\n    # cat=menu3/typo; type=wrap; label=Menu element font wrap: Styling wrap for the submenu item\r\n  linkWrap = <font face=\"arial,helvetica,sans-serif\" size=\"1\" color=\"white\">|</font>\r\n    # cat=menu3/typo; type=wrap; label=Menu element wrap: Wrap for the entire submenu item\r\n  allWrap = <tr><td>|</td></tr>\r\n    # cat=menu3/typo; type=wrap; label=All menu wrap: This finally wraps all elements\r\n  wrap = <table border=\"0\" cellpadding=\"4\" cellspacing=\"0\"> | </table>\r\n    # cat=menu3/dims; type=offset; label=Menu offset: Offset of the submenu\r\n  menuOffset = 10,10\r\n    # cat=menu3/dims; type=int+; label=Submenu Cell width: This value defines the width in pixels of the tablecell where the submenu is displayed\r\n  cellWidth = 200\r\n}\r\n\r\n\r\n  # cat=basic/typo; type=wrap; label=Page title wrap: Wrap for the page title displayed above the menu. Depends on the existence of the marker, ###PAGE_TITLE###, in the template file.\r\npage.titleWrap = <font face=\"verdana\" color=\"white\"><b>|</b></font>\r\n  # cat=basic/typo; type=offset; label=Page title offset: Offset of the page title displayed above the menu\r\npage.offset = 10,10\r\n\r\n  # cat=basic/dims; type=offset; label=Content offset: Offset of the page content\r\npage.contentOffset = 0,10\r\n\r\n\r\n  # cat=basic/color/a; type=color; label=Background color: This is the <body>-tag background color of the page.\r\nbgCol = white\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = \r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = \r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = \r\n\r\nPAGE_TARGET = \r\ncontent.pageFrameObj = \r\nstyles.content.imgtext.maxW = 400\r\n  # cat=basic/dims; type=int+; label=Content width: This value defines the width in pixels of the table where the content is displayed in the page-frame\r\ncontentWidth = 400\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"GREEN\"\r\n  description = This is a single-page template based on an HTML-template file. This means the position of elements such as the menu, submenu, page content and logo images are defined by the position of markers in an HTML-file, you may want to edit.\r\n  bulletlist = HTML-template file based: Lets you design your site layout by your favourite HTML-editor! (1)// 1+2 level DHTML based pop-up menu. 1. level is graphical and 2. level is text based. // Rollover state on DHTML-menu. // 3. level optional menu, text based. // Page title inserted in template (optional). (7) // Top logo and top image (basically the same) may be inserted in HTML-template file. (6,5) // Optionally use of a table/tablecell background image defined from TypoScript.  \r\n  image = gfx/GREEN_basic.gif\r\n  1=page.file.template\r\n  2=page.contentOffset\r\n  3=contentWidth,styles.content.imgtext.maxW\r\n  4=page.file.background,bgCol\r\n  5=page.file.topimage\r\n  6=page.file.toplogo\r\n  7=page.titleWrap,page.offset\r\n}\r\nTSConstantEditor.menu3 {\r\n  header = Standard Template \"GREEN\"\r\n  description = Simple Text based menu.\r\n  bulletlist = \r\n  image = gfx/GREEN_menu3.gif\r\n  1=submenu.menuOffset\r\n  2=submenu.cellWidth\r\n  3=submenu.linkWrap,submenu.allWrap\r\n  4=submenu.wrap\r\n}\r\n','#  Submenu (level 3!), text based\r\n\r\ntemp.submenu = HMENU\r\ntemp.submenu.entryLevel = 2\r\ntemp.submenu.1 = TMENU\r\ntemp.submenu.1.wrap = {$submenu.wrap}\r\ntemp.submenu.stdWrap.offsetWrap = {$submenu.menuOffset}\r\ntemp.submenu.1.NO {\r\n  allWrap =  {$submenu.allWrap}\r\n  linkWrap = {$submenu.linkWrap}\r\n  ATagBeforeWrap = 1\r\n}\r\n\r\n\r\n# Page object\r\n\r\npage = PAGE\r\npage.typeNum = 0\r\npage.bodyTag < styles.content.bodyTag\r\npage.bodyTagMargins = 0\r\npage.bgImg = {$page.file.background}\r\npage.noLinkUnderline = 1\r\n\r\npage.10 = TEMPLATE\r\npage.10 {\r\n  template = FILE\r\n  template.file = {$page.file.template}\r\n  workOnSubpart = DOCUMENT_BODY\r\n  marks {\r\n    TOP_LOGO = IMAGE\r\n    TOP_LOGO.file = {$page.file.toplogo}\r\n\r\n    TOP_IMAGE = IMAGE\r\n    TOP_IMAGE.file = {$page.file.topimage}\r\n\r\n    PAGE_TITLE = TEXT\r\n    PAGE_TITLE.field = title\r\n    PAGE_TITLE.wrap = {$page.titleWrap}\r\n    PAGE_TITLE.offsetWrap = {$page.offset}\r\n\r\n    MAIN_MENU < styles.gmenu_layer.green\r\n\r\n    SUB_MENU = COA\r\n    SUB_MENU.10 < temp.submenu\r\n    SUB_MENU.20 = CLEARGIF\r\n    SUB_MENU.20.width = {$submenu.cellWidth}\r\n\r\n    CONTENT = COA\r\n    CONTENT.stdWrap.offsetWrap = {$page.contentOffset}\r\n    CONTENT.5 < styles.content.editPanelPage\r\n    CONTENT.10 < styles.content.get\r\n    CONTENT.20 = CLEARGIF\r\n    CONTENT.20.width = {$contentWidth}\r\n    CONTENT.20.wrap = <br />|\r\n    CONTENT.30 < styles.content.lastUpdate\r\n    CONTENT.40 < styles.content.typo3_powered\r\n\r\n    CELL_BACK = IMG_RESOURCE\r\n    CELL_BACK.file = {$page.file.cellBack}\r\n    CELL_BACK.stdWrap.required = 1\r\n    CELL_BACK.stdWrap.wrap = background=\"|\"\r\n  }\r\n}\r\n\r\n\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\n\r\n','','');
INSERT INTO `static_template` VALUES (75,0,1071666624,997271475,'styles.gmenu_layer.green','','\r\nstyles.gmenu_layer.green >\r\nstyles.gmenu_layer.green {\r\n    # cat=menu/color; type=color; label=Menu background color1: (See below)\r\n  bgCol = #7b8ca5\r\n\r\n    # cat=menu/typo; type=file[ttf]; label=Font file: TrueType (ttf) font for the menu.\r\n  file.fontFile = \r\n    # cat=menu/typo; type=int[1-40]; label=Font size: Font size on menu items\r\n  fontSize = 10\r\n    # cat=menu/typo; type=color; label=Font color: Font color on menu items\r\n  fontColor = white\r\n    # cat=menu/typo; type=offset; label=Text offset: Enter the offset of the text from the upper-left corner on the menu items\r\n  offset = 11,14\r\n    # cat=menu/typo; type=offset; label=Text offset of first item: Enter the offset of the text from the upper-left corner on the first menu item in the menu! You may want to set the x dimensions a few pixels below the general value. Keep the y-dimension the same.\r\n  firstOffset = 11,14\r\n    # cat=menu/typo; type=int[0-20]; label=Letter spacing: Enter the spacing between characters\r\n  spacing=1\r\n    # cat=menu//x; type=boolean; label=NiceText: Disable this for higher speed, but less font rendering quality.\r\n  niceText=1\r\n    # cat=menu//x; type=boolean; label=AntiAlias: Anti Alias enabling. Default is on. Disable this if you\'re using \"pixel-fonts\" like Mini7. (NiceText must be disabled).\r\n  antiAlias=1\r\n\r\n\r\n    # cat=menu/typo; type=boolean; label=Rollover: Click this option if you want a rollover (mouseover) effect on the menu items.\r\n  RO = 0\r\n    # cat=menu/typo; type=color; label=Rollover, font color: Enter the rollover font color of the text on the menu item.\r\n  RO.fontColor =\r\n    # cat=menu/color; type=color; label=Rollover, Menu background color: Background color of the menu-items when the mouse cursor moves over the item.\r\n  RO.bgCol = #608ca5\r\n\r\n    # cat=menu/typo; type=boolean; label=Active: Click this option if you want a \'Active\' effect on the menu items. \'Active\' means how the item looks when you\'re on that page or a subpage to that page.\r\n  ACT = 0\r\n    # cat=menu/typo; type=color; label=Active, font color: Enter the \'Active\' font color of the text on the menu item.\r\n  ACT.fontColor =\r\n    # cat=menu/color; type=color; label=Active, Menu background color:  Background color of the menu-items when \'Active\'.\r\n  ACT.bgCol = #7b7392\r\n\r\n    # cat=menu//x; type=int[1-256]; label=Reduce colors: Number of indexed colors on menu items. If your menu items end up with weird colors, you can try to enter a higher number of colors. But the graphics-files will also increase their filesize.\r\n  reduceColors = 64\r\n    # cat=menu/dims; type=int+; label=Item Height: The height in pixels of the menu items\r\n  height = 19\r\n\r\n    # cat=menu/typo; type=offset; label=Menu offset: Enter the offset of the whole menu\r\n  menuOffset = 20,0\r\n}\r\n\r\n\r\nstyles.gmenu_layer.green.file {\r\n    # cat=menu/file/x1; type=file[IMAGE_EXT]; label=Background image: This image is tiled horizontally on the background of the menu item.\r\n  background = media/uploads/green/menu_back.png\r\n    # cat=menu/file/x1; type=file[IMAGE_EXT]; label=First image: This image is placed to the left on the first menu item\r\n  first = media/uploads/green/menu_first.png\r\n    # cat=menu/file/x1; type=file[IMAGE_EXT]; label=Middle image: This image is placed to the left on all other items than the first\r\n  middle = media/uploads/green/menu_middle.png\r\n    # cat=menu/file/x1; type=file[IMAGE_EXT]; label=Last image: This image is placed to the right on the last menu item.\r\n  last = media/uploads/green/menu_last.png\r\n    # cat=menu/file/x1; type=file[IMAGE_EXT]; label=Sublevel image: This image is placed to the right before the \'Last\' image on the menu items which has a submenu!\r\n  sublevel = media/uploads/green/menu_sublevel.png\r\n}\r\n\r\n\r\nstyles.gmenu_layer.green.layer {\r\n    # cat=menu2/dims; type=int+; label=X-offset of the pop-up layers: This is the distance in pixels from the left of the browser window to the menu pop-up layers\r\n  xPosOffset = 30\r\n    # cat=menu2/dims; type=int+; label=Y-offset of the pop-up layers: This is the distance in pixels from the top of the browser window to the menu pop-up layers\r\n  topOffset = 105\r\n    # cat=menu2/enable; type=boolean; label=Automatic hide: If set, the menu layer hides when mouse roll out of the layer area.\r\n  mouseOutHide = 0\r\n}\r\n\r\n\r\nstyles.gmenu_layer.green.2 {\r\n    # cat=menu2/typo; type=wrap; label=Menu element wrap: Wrap for the entire submenu item\r\n  allWrap = <tr><td>|</td></tr>\r\n    # cat=menu2/typo; type=wrap; label=Menu element font wrap: Styling wrap for the submenu item\r\n  linkWrap = <font face=\"arial,helvetica,sans-serif\" size=\"1\" color=\"white\">|</font>\r\n    # cat=menu2/typo; type=wrap; label=All menu wrap: This finally wraps all elements\r\n  wrap = <table border=\"0\" bgcolor=\"#003300\" cellpadding=\"4\" cellspacing=\"0\"> | </table>\r\n}\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.menu {\r\n  header = GREEN GMENU_LAYER\r\n  description = Graphical level-1 menu with a \'first\', \'middle\' and \'last\' bullet. You can also define a bullet indicating if a menu-item has subitems.\r\n  bulletlist = DHTML-based layers on level 2 (text-based level 2 menu, see \'MENU2\'). // \'first\' bullet: An image which appears in the left side of the first menu item only. (3)// \'middle\' bullet: An image which appears in the right side of all menu items which are not the last item. (4)// \'last\' bullet: An image which appears in the right side of the last item in the menu only. (5)// \'sublevel\' bullet: An image which indicates the existence of sublevels. (6)// Rollover and active state colors. // Menu item background image. (2)\r\n  image = gfx/GREEN_menu.gif\r\n  1=styles.gmenu_layer.green.height\r\n  2=styles.gmenu_layer.green.file.background,styles.gmenu_layer.green.bgCol\r\n  3=styles.gmenu_layer.green.file.first\r\n  4=styles.gmenu_layer.green.file.middle\r\n  5=styles.gmenu_layer.green.file.last\r\n  6=styles.gmenu_layer.green.file.sublevel\r\n  7=styles.gmenu_layer.green.file.fontFile,styles.gmenu_layer.green.fontSize,styles.gmenu_layer.green.fontColor,styles.gmenu_layer.green.offset,styles.gmenu_layer.green.firstOffset,styles.gmenu_layer.green.spacing\r\n}\r\nTSConstantEditor.menu2 {\r\n  header = GREEN GMENU_LAYER\r\n  description = DHTML layers with level 2. Menu is text based.\r\n  bulletlist = \r\n  image = gfx/GREEN_menu2.gif\r\n  1=styles.gmenu_layer.green.layer.xPosOffset,styles.gmenu_layer.green.layer.topOffset\r\n  2=styles.gmenu_layer.green.2.allWrap,styles.gmenu_layer.green.2.linkWrap\r\n  3=styles.gmenu_layer.green.2.wrap\r\n}\r\n\r\n','includeLibs.gmenu_layers = media/scripts/gmenu_layers.php\r\n\r\nstyles.gmenu_layer.green >\r\nstyles.gmenu_layer.green = HMENU\r\nstyles.gmenu_layer.green.stdWrap.offsetWrap = {$styles.gmenu_layer.green.menuOffset}\r\nstyles.gmenu_layer.green.wrap = <span style=\"white-space: nowrap;\"> | </span>\r\nstyles.gmenu_layer.green.1 = GMENU_LAYERS\r\nstyles.gmenu_layer.green.1 {\r\n  target = _top\r\n  xPosOffset = -{$styles.gmenu_layer.green.layer.xPosOffset}\r\n  lockPosition = x\r\n  expAll = 1\r\n  topOffset = {$styles.gmenu_layer.green.layer.topOffset}\r\n  hideMenuWhenNotOver = {$styles.gmenu_layer.green.layer.mouseOutHide}\r\n}\r\nstyles.gmenu_layer.green.1.NO {\r\n  XY = [10.w]+[4.w]+[5.w]+[6.w]+[7.w] , {$styles.gmenu_layer.green.height}\r\n  backColor = {$styles.gmenu_layer.green.bgCol} \r\n  reduceColors = {$styles.gmenu_layer.green.reduceColors}\r\n\r\n  3 = IMAGE\r\n  3.file = {$styles.gmenu_layer.green.file.background}\r\n  3.tile = 10,1\r\n\r\n  4 = IMAGE |*|_x_\r\n  4.file = {$styles.gmenu_layer.green.file.first}\r\n\r\n  5 = _x_ |*| IMAGE \r\n  5.file = {$styles.gmenu_layer.green.file.middle}\r\n\r\n#  6 = IMAGE\r\n  6.file = {$styles.gmenu_layer.green.file.sublevel}\r\n  6.align = r,t\r\n  6.offset = -[7.w]\r\n\r\n  7 = _x_|*|_x_|*| IMAGE\r\n  7.file = {$styles.gmenu_layer.green.file.last}\r\n  7.align = r,t\r\n\r\n  10 = TEXT\r\n  10.text.field = nav_title // title\r\n  10.offset =  {$styles.gmenu_layer.green.firstOffset}||{$styles.gmenu_layer.green.offset}|*||*| \r\n  10.fontColor = {$styles.gmenu_layer.green.fontColor}\r\n  10.niceText = {$styles.gmenu_layer.green.niceText}\r\n  10.antiAlias = {$styles.gmenu_layer.green.antiAlias}\r\n  10.fontSize = {$styles.gmenu_layer.green.fontSize}\r\n  10.spacing = {$styles.gmenu_layer.green.spacing}\r\n  10.fontFile = {$styles.gmenu_layer.green.file.fontFile}\r\n}\r\n\r\nstyles.gmenu_layer.green.1.RO < styles.gmenu_layer.green.1.NO\r\nstyles.gmenu_layer.green.1.RO = {$styles.gmenu_layer.green.RO}\r\nstyles.gmenu_layer.green.1.RO {\r\n  backColor = {$styles.gmenu_layer.green.RO.bgCol}\r\n  10.fontColor = {$styles.gmenu_layer.green.RO.fontColor}\r\n}\r\n\r\nstyles.gmenu_layer.green.1.ACT < styles.gmenu_layer.green.1.NO\r\nstyles.gmenu_layer.green.1.ACT = {$styles.gmenu_layer.green.ACT}\r\nstyles.gmenu_layer.green.1.ACT {\r\n  backColor = {$styles.gmenu_layer.green.ACT.bgCol}\r\n  10.fontColor = {$styles.gmenu_layer.green.ACT.fontColor}\r\n}\r\n\r\nstyles.gmenu_layer.green.1 {\r\n  IFSUB < .NO\r\n  IFSUB = 1\r\n  IFSUB.6 = IMAGE\r\n\r\n  IFSUBRO < .RO\r\n  IFSUBRO.6 = IMAGE\r\n}\r\n\r\n\r\n\r\n# Submenu on layers:\r\n\r\nstyles.gmenu_layer.green.2 = TMENU\r\nstyles.gmenu_layer.green.2.wrap = {$styles.gmenu_layer.green.2.wrap}\r\nstyles.gmenu_layer.green.2.NO {\r\n  allWrap =  {$styles.gmenu_layer.green.2.allWrap}\r\n  linkWrap = {$styles.gmenu_layer.green.2.linkWrap}\r\n  ATagBeforeWrap = 1\r\n}\r\n\r\n','','');
INSERT INTO `static_template` VALUES (77,0,1071668206,999602864,'cSet stylesheet','','content.RTE_compliant.mode = stylesheets\r\n\r\ncontent.wrap {\r\n  header = \r\n  header1 = <h1>|</h1>\r\n  header2 = <h2>|</h2>\r\n  header3 = <h3>|</h3>\r\n  header4 = <h4>|</h4>\r\n  subheader1 = <div class=\"subhead1\">|</div>\r\n  subheader2 = <div class=\"subhead2\">|</div>\r\n  subheader3 = <div class=\"subhead3\">|</div>\r\n  headerDate = <div class=\"headerdate\">|</div>\r\n  bodytext =\r\n}\r\ncontent {\r\n  defaultHeaderType = 2\r\n  defaultSubHeaderType = 3\r\n  menuWrap = <div class=\"celmenu\">|</div>\r\n  subMenuWrap = <div class=\"celsubmenu\">|</div>\r\n  menuAllWrap =\r\n  menuATagBeforeWrap =0\r\n  break.bodytext = \r\n  break.bodytext_parseFunc = <br />\r\n}\r\n\r\nstyles.content {\r\n  imgtext.captionWrap = <div class=\"caption\">|</div>\r\n  bulletlist.altWrap = <div class=\"bulletlist\">|</div>\r\n  table.altWrap = <div class=\"table\">|</div>\r\n  textStyle.altWrap = <p>|</p>\r\n  uploads.wrap = \r\n  uploads.sizeWrap = <div class=\"filelinkssize\">|</div>\r\n  uploads.labelWrap = <div class=\"filelinks\">|</div>\r\n  links.sword = <span class=\"searchmarkup\">|</span>\r\n}\r\nstyles.sitemap.text.totalWrap = \r\n\r\ncontent.headerSpace = 0|0\r\ncontent.space = 0|0\r\n\r\n\r\n# cat=content/file; type=file[css]; label=Style sheet: The default stylesheet is media/scripts/defaultstylesheet.css. Make a copy of this file, edit the copy and upload it as resource here!\r\ncontent.stylesheet.file = media/scripts/defaultstylesheet.css\r\n\r\n\r\n# REMOVING categories for constants:\r\n\r\nstyles.content.textStyle {\r\n    # cat=\r\n  face = \r\n    # cat=\r\n  size = \r\n    # cat=\r\n  color = \r\n}\r\n','# Setting Style sheet\r\npage.headerData.10 = FILE\r\npage.stylesheet = {$content.stylesheet.file}\r\n\r\n\r\n\r\n# REMOVING <br /> wraps for the menu content element and header\r\ntt_content.text.20.parseFunc.tags.typohead.stdWrap.wrap = \r\n\r\ntt_content.menu = COA \r\ntt_content.menu { \r\n  20 { \r\n    3.renderObj { \r\n      wrap2 = \r\n    } \r\n    4.1.NO { \r\n      afterWrap = {$content.subMenuWrap} \r\n    } \r\n    7.1.wrap = \r\n    7.2.wrap = \r\n  } \r\n} \r\n\r\n# Setting stylesheet for Content Element sitemap\r\ntt_content.menu.20.2 {\r\n  1.NO.allWrap = \r\n  1.NO.linkWrap = <div class=\"sitemap1\">|</div>\r\n  2.NO.allWrap = \r\n  2.NO.linkWrap = <div class=\"sitemap2\">|</div>\r\n  3.NO.allWrap = \r\n  3.NO.linkWrap = <div class=\"sitemap3\">|</div>\r\n  4.NO.allWrap = \r\n  4.NO.linkWrap = <div class=\"sitemap4\">|</div>\r\n}\r\n\r\n\r\n# Overriding some Setup values for tt_content elements:\r\ntt_content {\r\n  menu.20.3.renderObj.wrap = \r\n  menu.20.3.renderObj.innerWrap = <div class=\"celmenu\">|</div>\r\n\r\n  mailform.20.labelWrap.wrap = <span class=\"mailform\">|</span>\r\n  mailform.20.commentWrap.wrap = <span class=\"mailformcomment\">|</span>\r\n  mailform.20.COMMENT.layout = <tr><td colspan=\"3\">###COMMENT###</td></tr>\r\n  mailform.20.radioWrap.wrap = <span class=\"mailformradio\">|</span>\r\n  mailform.20.REQ.labelWrap.wrap = <span class=\"mailformrequired\">|</span>\r\n\r\n  search.30.labelWrap.wrap = <div class=\"searchform\">|</div>\r\n\r\n  login.20.labelWrap.wrap = <div class=\"loginform\">|</div>\r\n  login.20.REQ.labelWrap.wrap = <div class=\"loginform\">|</div>\r\n}\r\n\r\n\r\n# Search result:\r\ntt_content.search.20 {\r\n  renderObj.10.textStyle >\r\n  renderObj.10.fontTag >\r\n  renderObj.10.innerWrap = <div class=\"searchresultpagetitle\">|</div>\r\n  renderObj.20.stdWrap.textStyle >\r\n  renderObj.20.stdWrap.innerWrap = <div class=\"searchresultcontent\">|</div>\r\n  layout.10.fontTag = <div class=\"searchresultheader\">|</div>\r\n  layout.20.fontTag = <div class=\"searchresultheader\">|</div>\r\n  noResultObj.10.fontTag  = <div class=\"searchresultpagetitle\">|</div>\r\n}\r\n\r\n\r\n\r\n[globalVar=LIT:0<{$content.RTE_compliant}]\r\n[else]\r\n# Configuration of general text rendering:\r\ntt_content.text.20.parseFunc.nonTypoTagStdWrap {\r\n  trim=1\r\n  required=1\r\n  textStyle < tt_content.text.20.textStyle\r\n}\r\ntt_content.text.20.textStyle >\r\ntt_content.text.20.parseFunc.tags.typolist.breakoutTypoTagContent = 1\r\ntt_content.text.20.parseFunc.tags.typohead.breakoutTypoTagContent = 1\r\n[global]\r\n\r\n\r\n','This static_template should be included as an alternative to the traditional \"cSet (default)\".\r\nMost wraps are substituted with either traditional HTML-tags or <div> tags with class-definitions refering to the default stylesheet in media/scripts/defaultstylesheet.css\r\nBodytext is wrapped in <P>-tags and double-line-breaks are substituted with </p><p> while ordinary linebreaks are substituted with a regular <BR> tag.','');
INSERT INTO `static_template` VALUES (78,0,1054752852,999705238,'plugin.alt.print (98)','','plugin.alt.print >\r\nplugin.alt.print {\r\n    # cat=plugin.print/file; type=file[html,htm,tmpl,txt]; label= Template File for printversion: &type=98 defines a printer friendly design for page content. This template file lets you define the position of page titles and the content.\r\n  file.template = media/scripts/printversion_content.tmpl\r\n    # cat=plugin.print/file; type=file[css]; label= Printerfriendly CSS stylesheet\r\n  file.stylesheet = \r\n}','alt_print >\r\nalt_print = PAGE\r\nalt_print.typeNum=98\r\nalt_print.stylesheet = {$plugin.alt.print.file.stylesheet}\r\n\r\nalt_print.10 = TEMPLATE\r\nalt_print.10 {\r\n  template = FILE\r\n  template.file = {$plugin.alt.print.file.template}\r\n  marks {\r\n    PAGE_TITLE = TEXT\r\n    PAGE_TITLE.field = title\r\n    PAGE_SUBTITLE = TEXT\r\n    PAGE_SUBTITLE.field = subtitle\r\n    PAGE_AUTHOR = TEXT\r\n    PAGE_AUTHOR.field = author\r\n    PAGE_AUTHOR.required=1\r\n    PAGE_AUTHOR.typolink.parameter.field = author_email\r\n    PAGE_UID = TEXT\r\n    PAGE_UID.field = uid\r\n    CONTENT < styles.content.get\r\n  }\r\n  workOnSubpart = DOCUMENT_BODY\r\n}\r\n\r\n','Creates a PAGE object, alt_printversion, with typeNum = 98. This page displays the \'normal\' page content along with the page title and page author in a printer friendly display for printing.\r\n\r\nJust include this static template directly in your template, and you\'re up\'n\'running.\r\n\r\nDepends on \'content (default)\' or similar to be already included.','');
INSERT INTO `static_template` VALUES (79,0,1054753136,999707349,'plugin.tt_news [DEPRECIATED]','','plugin.tt_news {\r\n    # cat=plugin.news/file; type=file[html,htm,tmpl,txt]; label= Template File: HTML-template file for display of news. See media/scripts/news_template.tmpl for an example\r\n  file.templateFile = media/scripts/news_template.tmpl\r\n\r\n    # cat=plugin.news/typo; type=wrap; label= Wrap 1: This wrap is used in the template-file.\r\n  wrap1 = <font face=\"verdana\" size=\"2\" color=\"black\"> | </font>\r\n    # cat=plugin.news/typo; type=wrap; label= Wrap 2: This wrap is used in the template-file.\r\n  wrap2 = <font face=\"verdana\" size=\"1\" color=\"black\"> | </font>\r\n\r\n    # cat=plugin.news/color; type=color; label= Color 1: This bgcolor is used in the template-file.\r\n  color1 = #cccccc\r\n    # cat=plugin.news/color; type=color; label= Color 2: This bgcolor is used in the template-file.\r\n  color2 = #999999\r\n    # cat=plugin.news/color; type=color; label= Color 3: This bgcolor is used in the template-file.\r\n  color3 = #333333\r\n\r\n    # cat=plugin.news//; type=int+; label= \"Single\" pid: The PID of the page on which single news items should be displayed\r\n  PIDitemDisplay = 0\r\n    # cat=plugin.news//; type=int+; label= \"Back\" pid: The PID of the page to go back to from single news item display screen.\r\n  backPid = 0\r\n}\r\n\r\n','## Includes the newsLib:\r\nincludeLibs.ts_news = media/scripts/newsLib.inc\r\n\r\n## This enables the tt_content.list item to display the news:\r\nplugin.tt_news >\r\nplugin.tt_news = USER\r\nplugin.tt_news {\r\n  userFunc = user_news->main_news\r\n\r\n  templateFile = {$plugin.tt_news.file.templateFile}\r\n  pid_list.field = pages\r\n  recursive.field = recursive\r\n  code.field = select_key\r\n\r\n  # Global wraps\r\n  wrap1.wrap = {$plugin.tt_news.wrap1}\r\n  wrap2.wrap = {$plugin.tt_news.wrap2}\r\n  color1.wrap = {$plugin.tt_news.color1}\r\n  color2.wrap = {$plugin.tt_news.color2}\r\n  color3.wrap = {$plugin.tt_news.color3}\r\n\r\n  # Rendering of news items\r\n  general_stdWrap {\r\n    brTag = <br />\r\n    parseFunc < styles.content.parseFunc\r\n  }\r\n\r\n  limit = 10\r\n  latestLimit = 5\r\n  backPid = {$plugin.tt_news.backPid}\r\n  PIDsearch = \r\n  PIDitemDisplay = {$plugin.tt_news.PIDitemDisplay}\r\n  datetimeDaysToArchive = 0\r\n  enableArchiveDate = 1\r\n  pageTypoLink.parameter.current = 1\r\n  archiveTypoLink.parameter = {$plugin.tt_news.backPid}\r\n\r\n  archiveMenuNoEmpty = 1\r\n  archiveTitleCObject = COA\r\n  archiveTitleCObject {\r\n    10 = TEXT\r\n    10.field = start\r\n    10.strftime = %B - %Y\r\n  }\r\n\r\n  getRelatedCObject = COA\r\n  getRelatedCObject {\r\n    10 = TEXT\r\n    10.field = title\r\n    10.typolink.parameter = {$plugin.tt_news.PIDitemDisplay}\r\n    10.typolink.additionalParams.field = uid \r\n    10.typolink.additionalParams.wrap = &tt_news=|\r\n    20 = TEXT\r\n    20.field = datetime\r\n    20.strftime = %e-%m-%y %H:%M\r\n    20.wrap = <font size=\"1\"> - | </font>\r\n  }\r\n\r\n  # SINGLE news\r\n  displaySingle {\r\n    age_stdWrap.age = 1\r\n    date_stdWrap.strftime= %e-%m-%y\r\n    time_stdWrap.strftime= %H:%M\r\n    title_stdWrap.wrap = <b>|</b>\r\n    author_stdWrap.case = upper\r\n    author_stdWrap.typolink.parameter.field = author_email\r\n\r\n    imageCount=2\r\n    imageWrapIfAny = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"right\" width=\"1\"><tr><td><img src=\"clear.gif\" width=\"15\" height=\"1\" alt=\"\" /></td><td>|</td></tr></table>\r\n\r\n    email_stdWrap.setContentToCurrent = 1\r\n    email_stdWrap.typolink.parameter.current = 1\r\n    caption_stdWrap.wrap = <font color=\"navy\" face=\"verdana\" size=\"1\">|</font><br /><br />\r\n    caption_stdWrap.trim=1\r\n    caption_stdWrap.required=1\r\n  }\r\n  displaySingle.image {\r\n    file.maxW = 200\r\n    wrap = | <br />\r\n    imageLinkWrap = 1\r\n    imageLinkWrap {\r\n      enable = 1\r\n      bodyTag = <body bgcolor=\"black\">\r\n      wrap = <a href=\"javascript:close();\"> | </a>\r\n      width = 400m\r\n      height = 400\r\n\r\n      JSwindow = 1\r\n      JSwindow.newWindow = 1\r\n      JSwindow.expand = 17,20\r\n    }\r\n    stdWrap.spaceAfter=10\r\n  }\r\n\r\n  # LATEST news\r\n  displayLatest {\r\n    age_stdWrap.age = 1\r\n    date_stdWrap.strftime= %e-%m-%y\r\n    time_stdWrap.strftime= %H:%M\r\n    caption_stdWrap.if.directReturn = 0\r\n    subheader_stdWrap.crop = 100 | ...\r\n    subheader_stdWrap.ifEmpty.field = bodytext\r\n    imageCount=1\r\n    imageWrapIfAny = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"left\"><tr><td>|</td><td><img src=\"clear.gif\" width=\"5\" height=\"1\" alt=\"\" /></td></tr></table>\r\n  }\r\n  displayLatest.image < displaySingle.image\r\n  displayLatest.image {\r\n    file.maxW = 50\r\n    imageLinkWrap = 0\r\n    stdWrap.spaceAfter=5\r\n  }\r\n\r\n  # LIST news\r\n  displayList {\r\n    age_stdWrap.age = 1\r\n    date_stdWrap.strftime= %A %e. of %B\r\n    time_stdWrap.strftime= %e-%m-%y %H:%M\r\n    caption_stdWrap.wrap = <font face=\"verdana\" size=\"1\" color=\"navy\">|</font><br />\r\n    caption_stdWrap.trim=1\r\n    caption_stdWrap.required=1\r\n    subheader_stdWrap.crop = 300 | ...\r\n    subheader_stdWrap.ifEmpty.field = bodytext\r\n    imageCount=1\r\n    imageWrapIfAny = \r\n  }\r\n  displayList.image < displaySingle.image\r\n  displayList.image {\r\n    file.maxW = 150\r\n    imageLinkWrap = 1\r\n    stdWrap.spaceAfter=5\r\n  }\r\n}\r\n\r\n\r\n\r\n## This enables the tt_content.record item to display news items:\r\ntt_news >\r\ntt_news = < plugin.tt_news\r\ntt_news.displayCurrentRecord = 1\r\n\r\n','PLUGIN: News module\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n','');
INSERT INTO `static_template` VALUES (80,0,1054753073,999707887,'plugin.tt_board_tree [DEPRECIATED]','81','plugin.tt_board_tree{\r\n    # cat=plugin.board/file; type=file[html,htm,tmpl,txt]; label= Template File, tree style: This is a simple textfile where the board is defined with HTML-code. To see an example with explanations, take a look at media/scripts/board_template.tmpl which is the default.\r\n  file.templateFile = media/scripts/board_template2.tmpl\r\n\r\n    # cat=plugin.board/typo; type=wrap; label= Tree-style, Wrap 1: This wrap is used in the template-file.\r\n  wrap1 = <font face=\"verdana\" size=\"2\" color=\"black\"> | </font>\r\n    # cat=plugin.board/typo; type=wrap; label= Tree-style, Wrap 2: This wrap is used in the template-file.\r\n  wrap2 = <font face=\"verdana\" size=\"1\" color=\"black\"> | </font>\r\n    # cat=plugin.board/typo; type=wrap; label= Tree-style, Wrap 3: This wrap is used in the template-file.\r\n  wrap3 = <font face=\"verdana\" size=\"2\" color=\"white\"> | </font>\r\n\r\n    # cat=plugin.board/color; type=color; label= Tree-style, Color 1: This bgcolor is used in the template-file.\r\n  color1 = #cccccc\r\n    # cat=plugin.board/color; type=color; label= Tree-style, Color 2: This bgcolor is used in the template-file.\r\n  color2 = #999999\r\n    # cat=plugin.board/color; type=color; label= Tree-style, Color 3: This bgcolor is used in the template-file.\r\n  color3 = #333333\r\n    # cat=plugin.board/color; type=color; label= Tree-style, Color 4: This bgcolor is used in the template-file.\r\n  color4 = #333366\r\n}\r\n\r\n','\r\n## This enables the tt_content.list item to display the forum, tree style:\r\nplugin.tt_board_tree < temp.tt_board.shared\r\nplugin.tt_board_tree {\r\n  templateFile = {$plugin.tt_board_tree.file.templateFile}\r\n\r\n  # Global wraps\r\n  wrap1.wrap = {$plugin.tt_board_tree.wrap1}\r\n  wrap2.wrap = {$plugin.tt_board_tree.wrap2}\r\n  wrap3.wrap = {$plugin.tt_board_tree.wrap3}\r\n  color1.wrap = {$plugin.tt_board_tree.color1}\r\n  color2.wrap = {$plugin.tt_board_tree.color2}\r\n  color3.wrap = {$plugin.tt_board_tree.color3}\r\n  color4.wrap = {$plugin.tt_board_tree.color4}\r\n\r\n    # Allows for elements to be viewed one at a time and not parent+childs\r\n  view_thread.single = 1\r\n    # Allows for the forum to draw as a tree\r\n  tree=1\r\n\r\n  list_forums.author_stdWrap.wrap = by |\r\n  list_threads.post_content_stdWrap.crop = 200 | ...\r\n  list_forums.post_content_stdWrap.crop = 200 | ...\r\n\r\n  iconCode=1\r\n  iconCode.joinBottom = <img src=\"media/scripts/joinbottom.gif\" width=\"18\" height=\"16\" align=\"top\" alt=\"\" />\r\n  iconCode.join = <img src=\"media/scripts/join.gif\" width=\"18\" height=\"16\" align=\"top\" alt=\"\" />\r\n  iconCode.line = <img src=\"media/scripts/line.gif\" width=\"18\" height=\"16\" align=\"top\" alt=\"\" />\r\n  iconCode.blank = <img src=\"media/scripts/blank.gif\" width=\"18\" height=\"16\" align=\"top\" alt=\"\" />\r\n  iconCode.thread = <img src=\"media/scripts/thread.gif\" width=\"18\" height=\"16\" align=\"top\" alt=\"\" />\r\n  iconCode.end = <img src=\"media/scripts/end.gif\" width=\"18\" height=\"16\" align=\"top\" alt=\"\" />\r\n\r\n  list_threads.post_title_stdWrap.wrap = <font face=\"verdana,arial\" size=\"1\" color=\"black\"> | </font>\r\n  list_threads.post_title_stdWrap.crop = 20 | ...\r\n  list_threads.post_author_stdWrap.wrap = <font face=\"verdana,arial\" size=\"1\" color=\"black\"> | </font>\r\n  list_threads.post_author_stdWrap.crop = 20|...\r\n  list_threads.thread_limit = 30\r\n\r\n  thread_tree < .list_threads\r\n}\r\n\r\n## This enables the record item to display guestbook items\r\ntt_board >\r\ntt_board = < plugin.tt_board_tree\r\ntt_board.displayCurrentRecord = 1\r\n\r\n\r\n','PLUGIN: Board/Forum Tree style\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n','');
INSERT INTO `static_template` VALUES (81,0,1054753561,999708085,'temp.tt_board (shared) [DEPRECIATED]','','plugin.tt_board {\r\n    # cat=plugin.board; type=string; label= Moderator email: This email address will get a mail every time somebody submits a message to the forum.\r\n  moderatorEmail  = \r\n\r\n  numberOfRecentPosts = 0\r\n}','## Includes the boardLib:\r\nincludeLibs.ts_board = media/scripts/boardLib.inc\r\n\r\n## Sets up the fields, that may be submitted in order to create items. Mandatory!\r\nFEData.tt_board >\r\nFEData.tt_board {\r\n  processScript = media/scripts/board_submit.inc\r\n  processScript {\r\n\r\n      # Enable notify\r\n    notify = 1\r\n      # \"From\" email header\r\n    notify_from = TYPO3 forum <no_reply>\r\n      # Notification message template, first line is subject.\r\n    newReply.msg = media/scripts/board_notify.txt\r\n    newReply.didWhat = has just replied to a thread at\r\n    newReply.subjectPrefix = Reply to post at\r\n    newThread.msg = media/scripts/board_notify.txt\r\n    newThread.didWhat = has just created a new thread at\r\n    newThread.subjectPrefix = New thread at\r\n\r\n    debug=0\r\n  }\r\n  default {\r\n    hidden = 0\r\n    parent = 0\r\n  }\r\n  allowNew {\r\n    subject = 1\r\n    message = 1\r\n    author=1\r\n    email=1\r\n    parent=1\r\n    notify_me=1\r\n  }\r\n  autoInsertPID = 1\r\n  doublePostCheck = doublePostCheck\r\n}\r\n\r\n\r\n\r\n\r\n\r\ntemp.tt_board.shared = USER\r\ntemp.tt_board.shared {\r\n  userFunc = user_board->main_board\r\n\r\n  pid_list.field = pages\r\n  code.field = select_key\r\n\r\n  date_stdWrap.strftime= %e-%m-%y\r\n  time_stdWrap.strftime= %H:%M:%S\r\n  age_stdWrap.age = 1\r\n  allowCaching = 1\r\n  \r\n  list_categories {\r\n    cache_timeout = 120\r\n  }\r\n  list_forums {\r\n    author_stdWrap.wrap = by |\r\n    cache_timeout = 300\r\n    post_content_stdWrap.crop = 130 | ...\r\n    numberOfRecentPosts = {$plugin.tt_board.numberOfRecentPosts}\r\n  }\r\n  list_threads {\r\n    post_content_stdWrap.crop = 130 | ...\r\n    thread_limit = 20\r\n  }\r\n\r\n  postform < styles.content.mailform\r\n  postform.data >\r\n  postform.dataArray {\r\n    10.label = Subject:\r\n    10.type = *data[tt_board][NEW][subject]=input,60\r\n    20.label = Message:\r\n    20.type =  *data[tt_board][NEW][message]=textarea,60\r\n    30.label = Name:\r\n    30.type = *data[tt_board][NEW][author]=input,40\r\n    40.label = Email:\r\n    40.type = *data[tt_board][NEW][email]=input,40\r\n    50.label = Notify me<br />by reply: \r\n    50.type = data[tt_board][NEW][notify_me]=check\r\n    60.type = formtype_db=submit\r\n    60.value = Post Reply\r\n  }\r\n  postform.no_cache=1\r\n\r\n  postform_newThread < .postform\r\n  postform_newThread.dataArray.60.value = Post New Thread\r\n\r\n  moderatorEmail_newThread = {$plugin.tt_board.moderatorEmail}\r\n  moderatorEmail = {$plugin.tt_board.moderatorEmail}\r\n}\r\n\r\n','This static template is shared by the plugin.tt_board_tree and plugin.tt_board_list static templates.','');
INSERT INTO `static_template` VALUES (84,0,1054752908,999781309,'plugin.alt.xmlnewsfeed (89)','','plugin.alt.xmlnewsfeed >\r\nplugin.alt.xmlnewsfeed {\r\n    # cat=plugin.tt_news/file; \r\n\r\n}\r\n','\r\n## Set up page/type number:\r\nalt_xmlnewsfeed >\r\nalt_xmlnewsfeed = PAGE\r\nalt_xmlnewsfeed {\r\n  typeNum=89\r\n  config.disableAllHeaderCode = 1\r\n  config.additionalHeaders = Content-type: text/xml\r\n\r\n  ## Includes the newsLib:\r\n  includeLibs.ts_news = media/scripts/newsLib.inc\r\n\r\n  ## This enables the tt_content.list item to display the news:\r\n  10 = USER\r\n  10 {\r\n    userFunc = user_news->main_xmlnewsfeed\r\n  }\r\n}\r\n\r\n','Creates a PAGE object, alt_xmlnewsfeed, with typeNum = 89. \r\nThis delivers the tt_news elements as an XML-feed depending on parameters passed to the script.\r\n\r\nJust include this static template directly in your template, and you\'re up\'n\'running.\r\n\r\nDepends on \'content (default)\' or similar to be already included.','');
INSERT INTO `static_template` VALUES (85,0,1071766055,999782684,'plugin.alt.wap (97)','','plugin.alt.wap >\r\nplugin.alt.wap {\r\n\r\n}\r\n','## Set up page/type:\r\nalt_wap >\r\nalt_wap = PAGE\r\nalt_wap {\r\n  typeNum=97\r\n  config.disableAllHeaderCode = 1\r\n  config.additionalHeaders = Content-type: text/vnd.wap.wml\r\n\r\n  ## Includes the newsLib:\r\n  includeLibs.alt_wap = media/scripts/wapversionLib.inc\r\n\r\n  ## Inserting the USER cObject for WAP/XML rendering\r\n  10 = USER\r\n  10 {\r\n    userFunc = user_wapversion->main_wapversion\r\n    debug=0\r\n    preTitle = T3WAP\r\n    navLabels.prev = Prev\r\n    navLabels.next = Next\r\n    navLabels.up = Up\r\n  }\r\n}\r\n\r\n## Setting up a testpage at type 197\r\nalt_wap_test < alt_wap\r\nalt_wap_test {\r\n  typeNum=197\r\n  config.additionalHeaders = \r\n  10.debug = 1\r\n}\r\n\r\n## If the browser is a WAP-device,\r\n[device=wap]\r\n\r\nalt_wap.typeNum=0\r\n\r\n[global]\r\n\r\n','Creates a PAGE object, alt_wap, with typeNum = 97. This page displays the page in WAP format.\r\n\r\nStill experimental.\r\n\r\nJust include this static template directly in your template, and you\'re up\'n\'running.\r\n\r\nNOTICE: This WAP template pulls a little trick if the client turns out to be a normal WAP device - then the WAP pages are served from \"&type=0\" ! So only when using WAP browsers (like Opera) should you use \"&type=97\".','');
INSERT INTO `static_template` VALUES (88,0,1054753209,1001579560,'plugin.tt_rating [DEPRECIATED]','','plugin.tt_rating >\r\nplugin.tt_rating {\r\n\r\n    # cat=plugin.rating/typo; type=; label= Vote form data.\r\n  formdata = | *data[tt_rating][EDIT][rating]=select |0 - No rating=0, 5 - Excellent=5, 4 - Good=4, 3 - Fair=3, 2 - Needs improvement=2, 1 - Unsatisfactory=1 ||  | formtype_db = submit | Rate this\r\n\r\n# cat=plugin.rating/typo; type=; label= Text to show if not rated yet.\r\n  notRatedMsg = This object is not rated yet.\r\n    # cat=plugin.rating/typo; type=; label= Text to show if just rated.\r\n  submittedRatingMsg = Your submitted rating was ###SUBMITTED_RATING###.\r\n    # cat=plugin.rating/typo; type=; label= Text to show if user try to rate twice.\r\n  doubleRatingMsg = You have already rated this item.\r\n    # cat=plugin.rating/typo; type=; label= Text to show below your rating bar.\r\n  textOutput = &nbsp;&nbsp;<b>###RATING###</b> (###VOTES### votes)\r\n\r\n    # cat=plugin.rating/typo; type=int; label= The highest possible rating. (examples: 5 [best] - 1 [worst], 1 [best] - 6 [worst])\r\n  highestRating = 5\r\n    # cat=plugin.rating/typo; type=int; label= The lowest possible rating.\r\n  lowestRating = 1\r\n    # cat=plugin.rating/typo; type=int; label= For statistics logging. This should match the steps in the form.\r\n  ratingStatSteps = 5\r\n    # cat=plugin.rating/typo; type=int; label= The length of a bar or similiar.\r\n  ratingOutputWidth = 110\r\n\r\n    # cat=plugin.rating/typo; type=; label= Image used to render the \'good\' bar.\r\n  goodImgFile = media/scripts/star.gif\r\n    # cat=plugin.rating/typo; type=; label= Image used to render the \'bad\' bar.\r\n  badImgFile = media/scripts/star_grey.gif\r\n    # cat=plugin.rating/typo; type=; label= Image used to mask both images against the background color.\r\n  maskImgFile = media/scripts/star_mask.gif\r\n    # cat=plugin.rating/typo; type=int[1-20]; label= Should the image be tiled (example: 5 stars). If not set it to 1.\r\n  tileImg = 5\r\n}\r\n','## Includes the ratingLib:\r\nincludeLibs.ts_rating = media/scripts/ratingLib.inc\r\n\r\n## Sets up the fields, that may be submitted in order to create items. Mandatory!\r\nFEData.tt_rating {\r\n  processScript = media/scripts/rating_submit.inc\r\n  allowEdit {\r\n    rating = 1\r\n\r\n    // following items are used to pass configuration to fe_tce.php, They are NOT fields\r\n    // this may change later\r\n    minRating = 1\r\n    maxRating = 1\r\n    ratingStatSteps = 1\r\n  }\r\n}\r\n\r\n\r\n## This enables the tt_content.list item to display rating:\r\nplugin.tt_rating >\r\nplugin.tt_rating = USER\r\nplugin.tt_rating {\r\n  userFunc = user_rating->main_rating\r\n\r\n  pid_list.field = pages\r\n  code.field = select_key\r\n\r\n  allowNew = 1\r\n  defaultCode = RESULT,VOTEFORM\r\n    //used if you allowNew\r\n  defaultTitle = rating\r\n  defaultDescription =\r\n    // the best and the worst rating value\r\n  highestRating = {$plugin.tt_rating.highestRating}\r\n  lowestRating = {$plugin.tt_rating.lowestRating}\r\n    // normally the same as in your voteform\r\n  ratingStatSteps = {$plugin.tt_rating.ratingStatSteps}\r\n    // the length of a bar or similiar\r\n  ratingOutputWidth = {$plugin.tt_rating.ratingOutputWidth}\r\n\r\n  submittedRatingMsg = {$plugin.tt_rating.submittedRatingMsg}\r\n  doubleRatingMsg = {$plugin.tt_rating.doubleRatingMsg}\r\n  wrap =\r\n\r\n  voteform < styles.content.mailform\r\n  voteform.layout = <td>###FIELD###</td><td><img src=\"clear.gif\" width=\"{$styles.content.mailform.border}\" alt=\"\" /></td>\r\n  voteform.stdWrap.wrap = <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>  | </tr></table>\r\n  voteform.data >\r\n  voteform.data = {$plugin.tt_rating.formdata}\r\n  voteform.no_cache=1\r\n  voteform.noValueInsert=1\r\n  voteform.wrap =\r\n\r\n  noRatingObj = TEXT\r\n  noRatingObj.value = {$plugin.tt_rating.notRatedMsg}\r\n  noRatingObj.textStyle < styles.content.textStyle\r\n\r\n\r\n  renderObj = COA\r\n  renderObj.stdWrap.wrap =  | <br />\r\n  renderObj {\r\n\r\n    10 = IMAGE\r\n    10.file = GIFBUILDER\r\n    10.file {\r\n      backColor = {$cSet.pageColor}\r\n      transparentBackground = 1\r\n      XY = [10.w]*{$plugin.tt_rating.tileImg},[10.h]\r\n      10 = IMAGE\r\n      10 {\r\n        file = {$plugin.tt_rating.badImgFile}\r\n        mask = {$plugin.tt_rating.maskImgFile}\r\n        tile = {$plugin.tt_rating.tileImg},1\r\n      }\r\n      15 = WORKAREA\r\n      15.set = 0,0,###RATING_MUL###*[10.w]*{$plugin.tt_rating.tileImg},[10.h]\r\n      20 = IMAGE\r\n      20 {\r\n        file = {$plugin.tt_rating.goodImgFile}\r\n        mask = {$plugin.tt_rating.maskImgFile}\r\n        tile = {$plugin.tt_rating.tileImg},1\r\n      }\r\n    }\r\n    20 = TEXT\r\n    20.value = {$plugin.tt_rating.textOutput}\r\n    20.textStyle < styles.content.textStyle\r\n\r\n    30 = TEXT\r\n    30.value = ###RATING_MSG###\r\n    30.required = 1\r\n    30.wrap =\r\n    30.textStyle < styles.content.textStyle\r\n\r\n  }\r\n}\r\n\r\n\r\n\r\n## This enables the tt_content.record item to display rating items:\r\ntt_rating >\r\ntt_rating = < plugin.tt_rating\r\ntt_rating.displayCurrentRecord = 1\r\n\r\n','Author: Ren Fritz <r.fritz@colorcube.de>','');
INSERT INTO `static_template` VALUES (89,0,1093529398,1001674349,'template; GLUECK','43,68','page.file {\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Background image:  Background image of the page.\r\n  bgImg = media/uploads/back1.png\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Logo Image:  Logo image in the top of the page.\r\n  logoImg = media/uploads/testlogo.png\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Top image:  Image on top of the normal and right column. This image is the default image. The first media file found in the rootline will substitute this!\r\n  topImg = media/uploads/topimage.png\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Margin Logo Image:  Logo image in the top of the margin column.\r\n  marginLogoImg = media/uploads/testlogo2.png\r\n\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Menu column background image:  Background image of the menu column.\r\n  menuBgImg = media/uploads/back2.png\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Normal column background image:  Background image of the normal column.\r\n  normalBgImg = media/uploads/back3.png\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Right column background image:  Background image of the right column.\r\n  rightBgImg = media/uploads/back4.png\r\n    # cat=basic/file; type=file[IMAGE_EXT]; label=Whole table background image:  Background image of the whole main content table.\r\n  wholeTableBgImg = media/uploads/back5.png\r\n}\r\npage.bgColors {\r\n    #cat=basic/color; type=color; label=Menu column bgColor: This is the background color of the table cell where the menu and logo is displayed.\r\n  menuBgColor = \r\n    #cat=basic/color; type=color; label=Content column bgColor: This is the background color of the table cell where the content is displayed. You would normally regard this as being the \"page color\".\r\n  normalBgColor = \r\n    #cat=basic/color; type=color; label=Right column bgColor: This is the background color of the table cell where the right column content is displayed.\r\n  rightBgColor = \r\n    #cat=basic/color; type=color; label=Whole table column bgColor: This is the background color of the whole table.\r\n  wholeTableBgColor = \r\n}\r\n\r\n\r\n// This excludes the constant \"styles.content.imgtext.maxW\" from being displayed in the constant editor. The reason why this is desirable is that the REGISTER is used to override this value in this template.\r\n  # cat=\r\nstyles.content.imgtext.maxW =\r\n\r\npageCol {\r\n    # cat=content,basic/cImage/a_maxw1; type=int+; label=Max Image Width: This indicates that maximum number of pixels (width) a block of images inserted as content is allowed to consume.\r\n  maxImageWidth = 343\r\n    # cat=basic/dims; type=int+; label=Content width: This value defines the width in pixels of the table cell where the content is displayed\r\n  page.width = 343\r\n    # cat=basic/dims; type=int+; label=Page table height: This is the minimum page height.\r\n  page.height = 400\r\n    # cat=basic/dims; type=offset[Left, Top, Right,,Width]; label=Content offset: This value defines the margin in pixels from the left and top of the main content table cell\r\n  page.contentOffset = 10,8,10\r\n}\r\n\r\n  # cat=basic/dims; type=offset[Left, Top, Right, Bottom]; label=Page offset: This value defines the margin in pixels from the left and top of the browser window\r\npage.offset = ,20\r\n  # cat=basic; type=options[left,right,center]; label=Alignment of the page: Alignment of the page-table\r\npage.align = center\r\n\r\n  #cat=basic/dims; type=int+; label=Content margin, left: Set the number of pixels whitespace between the content column and the menu column.\r\npage.contentMarginLeft = 10\r\n  #cat=basic/dims; type=int+; label=Content margin, right: Set the number of pixels whitespace between the content column and the right column.\r\npage.contentMarginRight = 10\r\n  #cat=basic/dims; type=int+; label=Distance Top image to Content: Sets the distance in pixels between the top image and the content columns, normal and right.\r\npage.topImgToContentDist = 10\r\n\r\n\r\n\r\nrightCol {\r\n    #cat=right,basic/enable; type=boolean; label=Enable right column: Click this option to enable the right column in the page table. This column can be used for \"news\" from a certain page, but inserted on all pages. You can also configure the column to hold \"secondary\" content specific for each page. Then content of the column-type \"Border\" is inserted. NOTE: This option is also found in the dedicated category \"RIGHT\" that configures the characteristics of this column.\r\n  enable = 1\r\n    #cat=right/enable; type=options[getNews,getBorder]; label=Column content: Choose \"getNews\" to select content from a specific page (defined below here) or \"getBorder\" to display the \"Border\"-content of the current page.\r\n  borderContent = getBorder\r\n    # cat=right/enable/zz; type=int+; label=News Content PID: If you selected \"getNews\" above, this is where you enter the page-id of the page from which to fetch the \"news\" content for the column.\r\n  getNewsPid = \r\n    #cat=right/dims; type=int+; label=Max Image Width: This defines that maximum number of pixels (width) a block of images inserted as content is allowed to consume. NOTE: This is specific for the right column! The figure should approx. match the width of the image in the top of this column!\r\n  maxImageWidth = 140\r\n    #cat=right/dims; type=offset[Left, Top, Right,,Width]; label=Content offset: This is the offset of the content from the upper-left corner of the table cell.\r\n  offset = 5,8,5\r\n    #cat=right/typo; type=small; label=Bodytext font face\r\n  textStyle_face =\r\n    #cat=right/typo; type=int[1-5]; label=Bodytext font size\r\n  textStyle_size =\r\n    #cat=right/typo; type=color; label=Bodytext font color\r\n  textStyle_color =\r\n    #cat=right/typo; type=int[1-5]; label=Default Header type: Enter the number of the header layout to be used by default. \r\n  defaultHeaderType =\r\n}\r\n\r\n\r\nmenuCol {\r\n    #cat=menucolumn,basic/enable; type=boolean; label=Enable menu column: Click this option to enable the menu column in the page table. This column can be used for \"news\" from a certain page, but inserted on all pages. You can also configure the column to hold \"secondary\" content specific for each page. Then content of the column-type \"Left\" is inserted. \r\n  enable = 1\r\n    #cat=menucolumn/enable; type=options[getNews,getLeft]; label=Column content: Choose \"getNews\" to select content from a specific page (defined below here) or \"getLeft\" to display the \"Left\"-content of the current page.\r\n  borderContent = getNews\r\n    #cat=menucolumn/dims; type=int+; label=Max Image Width: This indicates that maximum number of pixels (width) a block of images inserted as content is allowed to consume. NOTE: This is specific for the menu column! The figure should approx. match the width of the image in the top of this column!\r\n  maxImageWidth = 140\r\n    #cat=menucolumn/dims; type=offset[Left, Top, Right,,Width]; label=Content offset: This is the offset of the content from the upper-left corner of the table cell.\r\n  offset = 5,8,5\r\n    #cat=menucolumn/typo; type=small; label=Bodytext font face\r\n  textStyle_face =\r\n    #cat=menucolumn/typo; type=int[1-5]; label=Bodytext font size\r\n  textStyle_size =\r\n    #cat=menucolumn/typo; type=color; label=Bodytext font color\r\n  textStyle_color =\r\n    #cat=menucolumn/typo; type=int[1-5]; label=Default Header type: Enter the number of the header layout to be used by default. \r\n  defaultHeaderType =\r\n}\r\n  # cat=menucolumn/enable/zz; type=int+; label=News Content PID: If you selected \"getNews\" above, this is where you enter the page-id of the page from which to fetch the \"news\" content for the column.\r\nstyles.content.getNews.newsPid = 0\r\n\r\n\r\n\r\nmenu1 {\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Left Bullet image\r\n  file.bullet_left = media/bullets/bullet1_n.gif\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Left Bullet image, Rollover\r\n  file.bullet_left_RO = media/bullets/bullet1_h.gif\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Right Bullet image\r\n  file.bullet_right = media/bullets/bullet2_n.gif\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Right Bullet image, Rollover\r\n  file.bullet_right_RO = media/bullets/bullet2_h.gif\r\n\r\n    # cat=menu; type=options[,left,right,center]; label=Alignment of the menu item text\r\n  align =\r\n\r\n    #cat=menu/dims; type=int+; label=Separator Line Thickness: Thickness in pixels of the separator line. 0 (zero) disables.\r\n  lineThickness = 2\r\n    #cat=menu/color; type=color; label=Separator Line Color: Color of the separator lines between menu items.\r\n  lineColor = black\r\n    #cat=menu/enable; type=boolean; label=Bottom Separator Line: If set, the separator line will appear in the bottom of the menu as well.\r\n  bottomLine = 1\r\n    #cat=menu/enable; type=boolean; label=Top Separator Line: If set, the separator line will appear in the top of the menu as well.\r\n  topLine = 1\r\n    #cat=menu/color; type=color; label=Item Background Color: Background color of the menu item table rows.\r\n  bgColor = #eeeeff\r\n\r\n    #cat=menu/dims; type=offset[Left, Top, Right,,Width]; label=Menu offset: This is the offset of the menu. \r\n  offset = 5,8,5\r\n    #cat=menu/dims; type=int+; label=Menu item height\r\n  itemHeight = 20\r\n\r\n    #cat=menu/typo; type=string; label=Menu item style\r\n  NO.itemStyle =   font-family: verdana,arial,sans-serif;  font-size: 11px;  font-weight: ;  font-style: italic;\r\n    #cat=menu/color; type=color; label=Normal Link Color\r\n  NO.itemLinkColor = olive\r\n    #cat=menu/color; type=color; label=Normal Link Color, Roll over\r\n  NO.itemLinkColorRO = red\r\n\r\n    #cat=menu/enable; type=boolean; label=Enable Active: If set, the active configuration is enabled. Active menu items are \"the page you\'re at\".\r\n  ACT = 1\r\n    #cat=menu/typo; type=string; label=Active Menu item style\r\n  ACT.itemStyle =   font-family: verdana,arial,sans-serif;  font-size: 11px;  font-weight: bold;  font-style: italic;\r\n    #cat=menu/color; type=color; label=Active Link Color\r\n  ACT.itemLinkColor = navy\r\n    #cat=menu/color; type=color; label=Active Link Color, Roll over\r\n  ACT.itemLinkColorRO = #cc6600\r\n    #cat=menu/color; type=color; label=Active Item Background Color: Background color of the active menu item table rows.\r\n  ACT.bgColor = #ffeeee\r\n\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Active, Left Bullet image\r\n  ACT.file.bullet_left = media/bullets/bullet1_h.gif\r\n    # cat=menu/file; type=file[IMAGE_EXT]; label=Active, Right Bullet image\r\n  ACT.file.bullet_right = media/bullets/bullet2_h.gif\r\n\r\n    #cat=menu/enable; type=options[underline,none]; label=Normal Underline: If set, the menu links will be underlined.\r\n  textDecor = none\r\n    #cat=menu/enable; type=options[underline,none]; label=Roll Over Underline: If set, the menu links will be underlined on roll over.\r\n  hoverTextDecor = underline\r\n}\r\n\r\n\r\n\r\nmenu2 {\r\n    # cat=menu2/file; type=file[IMAGE_EXT]; label=Left Bullet image\r\n  file.bullet_left = media/bullets/bullet1_n.gif\r\n    # cat=menu2/file; type=file[IMAGE_EXT]; label=Left Bullet image, Rollover\r\n  file.bullet_left_RO = media/bullets/bullet1_h.gif\r\n    # cat=menu2/file; type=file[IMAGE_EXT]; label=Right Bullet image\r\n  file.bullet_right = media/bullets/bullet2_n.gif\r\n    # cat=menu2/file; type=file[IMAGE_EXT]; label=Right Bullet image, Rollover\r\n  file.bullet_right_RO = media/bullets/bullet2_h.gif\r\n\r\n    # cat=menu2; type=options[,left,right,center]; label=Alignment of the menu item text\r\n  align =\r\n\r\n    #cat=menu2/dims; type=int+; label=Separator Line Thickness: Thickness in pixels of the separator line. 0 (zero) disables.\r\n  lineThickness = 2\r\n    #cat=menu2/color; type=color; label=Separator Line Color: Color of the separator lines between menu items.\r\n  lineColor = black\r\n    #cat=menu2/enable; type=boolean; label=Bottom Separator Line: If set, the separator line will appear in the bottom of the menu as well.\r\n  bottomLine = 1\r\n    #cat=menu2/enable; type=boolean; label=Top Separator Line: If set, the separator line will appear in the top of the menu as well.\r\n  topLine = 1\r\n    #cat=menu2/color; type=color; label=Item Background Color: Background color of the menu item table rows.\r\n  bgColor = #ee99ff\r\n\r\n    #cat=menu2/dims; type=offset[Left, Top, Right,,Width]; label=Menu offset: This is the offset of the menu. \r\n  offset = 5,8,5\r\n    #cat=menu2/dims; type=int+; label=Menu item height\r\n  itemHeight = 20\r\n\r\n    #cat=menu2/typo; type=string; label=Menu item style\r\n  NO.itemStyle =   font-family: verdana,arial,sans-serif;  font-size: 10px;  font-weight: ;  font-style: ;\r\n    #cat=menu2/color; type=color; label=Normal Link Color\r\n  NO.itemLinkColor = maroon\r\n    #cat=menu2/color; type=color; label=Normal Link Color, Roll over\r\n  NO.itemLinkColorRO = black\r\n\r\n    #cat=menu2/enable; type=boolean; label=Enable Active: If set, the active configuration is enabled. Active menu items are \"the page you\'re at\".\r\n  ACT = 1\r\n    #cat=menu2/typo; type=string; label=Active Menu item style\r\n  ACT.itemStyle =   font-family: verdana,arial,sans-serif;  font-size: 10px;  font-weight: bold;  font-style: ;\r\n    #cat=menu2/color; type=color; label=Active Link Color\r\n  ACT.itemLinkColor = #006600\r\n    #cat=menu2/color; type=color; label=Active Link Color, Roll over\r\n  ACT.itemLinkColorRO = #00cc00\r\n    #cat=menu2/color; type=color; label=Active Item Background Color: Background color of the active menu item table rows.\r\n  ACT.bgColor = #ffeeee\r\n\r\n    # cat=menu2/file; type=file[IMAGE_EXT]; label=Active, Left Bullet image\r\n  ACT.file.bullet_left = media/bullets/bullet1_h.gif\r\n    # cat=menu2/file; type=file[IMAGE_EXT]; label=Active, Right Bullet image\r\n  ACT.file.bullet_right = media/bullets/bullet2_h.gif\r\n\r\n    #cat=menu2/enable; type=options[underline,none]; label=Normal Underline: If set, the menu links will be underlined.\r\n  textDecor = none\r\n    #cat=menu2/enable; type=options[underline,none]; label=Roll Over Underline: If set, the menu links will be underlined on roll over.\r\n  hoverTextDecor = underline\r\n}\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nstyles.content.imgtext.maxW = 400\r\n\r\n\r\nPAGE_TARGET = \r\ncontent.pageFrameObj = \r\n\r\n  # cat=basic/color/a; type=color; label=Background color: This is the <body>-tag background color of the page.\r\nbgCol = #D6D3CE\r\n  # cat=basic/color/l; type=color; label=Link-color: Link color defined in <body>-tag\r\nlink = #006699\r\n  # cat=basic/color/l; type=color; label=Active Link-color: Active link color defined in <body>-tag\r\nalink = #00659C\r\n  # cat=basic/color/l; type=color; label=Visited Link-color: Visited link color defined in <body>-tag\r\nvlink = #00659C\r\n\r\n\r\n\r\n\r\n\r\n\r\n## TSConstantsEditor Config\r\nTSConstantEditor.basic {\r\n  header = Standard Template \"GL�CK\"\r\n  description = Standard template based on three columns in a table. There are first and second level textbased menus, one menu in each column. You can insert logos and content in each column and add background images to the various table cells. The template is fully programmed in TypoScript.\r\n  bulletlist =  Three columns of content each with separate background images or colors (1+14+2) // Menu column (left) and right column are optional (1+2)// 1+2 level text based menu, 1. level in menu column (left)(1) and 2. level in the right column (2) // Optional logos in the top of columns (11+13) // Optional top image (12) // Detailed adjustment of margins, widths and alignment (4+5+6+9+3+16) // Background image and color of page (10)\r\n  image = gfx/GLCK_basic.gif\r\n  1=rightCol.enable,page.file.menuBgImg,page.bgColors.menuBgColor\r\n  2=menuCol.enable,page.file.rightBgImg,page.bgColors.rightBgColor\r\n  3=page.offset\r\n  4=page.contentMarginLeft\r\n  5=page.contentMarginRight\r\n  6=page.topImgToContentDist\r\n  7=pageCol.page.width,pageCol.maxImageWidth\r\n  8=pageCol.page.height\r\n  9=pageCol.page.contentOffset\r\n  10=page.file.bgImg,bgCol\r\n  11=page.file.logoImg\r\n  12=page.file.topImg\r\n  13=page.file.marginLogoImg\r\n  14=page.file.normalBgImg,page.bgColors.normalBgColor\r\n  15=page.bgColors.wholeTableBgColor,page.file.wholeTableBgImg\r\n  16=page.align\r\n}\r\nTSConstantEditor.menu {\r\n  header = MENU, \"GL�CK\"\r\n  description = Text based menu with stylesheet hover color and definition of active state\r\n  image = gfx/GLCK_menu.gif\r\n  1=menu1.bottomLine,menu1.lineColor\r\n  2=menu1.topLine,menu1.lineColor\r\n  3=menu1.ACT,menu1.ACT.itemStyle,menu1.ACT.itemLinkColor,menu1.ACT.itemLinkColorRO,menu1.ACT.bgColor,menu1.align\r\n  4=menu1.textDecor,menu1.NO.itemStyle,menu1.bgColor,menu1.NO.itemLinkColor,menu1.align\r\n  5=menu1.hoverTextDecor,menu1.NO.itemLinkColorRO\r\n  6=menu1.itemHeight\r\n  7=menu1.lineThickness,menu1.lineColor\r\n  8=menu1.offset\r\n  9=menu1.file.bullet_left,menu1.file.bullet_left_RO,menu1.ACT.file.bullet_left\r\n  10=menu1.file.bullet_right,menu1.file.bullet_right_RO,menu1.ACT.file.bullet_right\r\n}\r\nTSConstantEditor.menu2 {\r\n  header = MENU2, \"GL�CK\"\r\n  description = Text based menu with stylesheet hover color and definition of active state\r\n  image = gfx/GLCK_menu.gif\r\n  1=menu2.bottomLine,menu2.lineColor\r\n  2=menu2.topLine,menu2.lineColor\r\n  3=menu2.ACT,menu2.ACT.itemStyle,menu2.ACT.itemLinkColor,menu2.ACT.itemLinkColorRO,menu2.ACT.bgColor,menu2.align\r\n  4=menu2.textDecor,menu2.NO.itemStyle,menu2.bgColor,menu2.NO.itemLinkColor,menu2.align\r\n  5=menu2.hoverTextDecor,menu2.NO.itemLinkColorRO\r\n  6=menu2.itemHeight\r\n  7=menu2.lineThickness,menu2.lineColor\r\n  8=menu2.offset\r\n  9=menu2.file.bullet_left,menu2.file.bullet_left_RO,menu2.ACT.file.bullet_left\r\n  10=menu2.file.bullet_right,menu2.file.bullet_right_RO,menu2.ACT.file.bullet_right\r\n}\r\nTSConstantEditor.right {\r\n  header = RIGHT COLUMN, \"GL�CK\"\r\n  description = Right column content. \r\n  bulletlist = Choose between actual page content marked \"border\" column (getBorder) or define a PID from where to get the content (getNews).\r\n  image = gfx/GLCK_columns.gif\r\n  1=rightCol.maxImageWidth\r\n  2=rightCol.offset\r\n}\r\nTSConstantEditor.menucolumn {\r\n  header = MENU COLUMN, \"GL�CK\"\r\n  description = Menu column content\r\n  bulletlist = Choose between actual page content marked \"left\" column (getLeft) or define a PID from where to get the content (getNews).\r\n  image = gfx/GLCK_columns.gif\r\n  1=menuCol.maxImageWidth\r\n  2=menuCol.offset\r\n}\r\n\r\n\r\n','# Menu objects:\r\ntemp.menu1 = HMENU\r\ntemp.menu1.stdWrap.offsetWrap = {$menu1.offset}\r\ntemp.menu1.wrap =<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">|</table>\r\ntemp.menu1.1 = TMENU\r\ntemp.menu1.1.NO {\r\n  allWrap = <tr>|</tr>\r\n  allWrap {\r\n    addParams.bgColor = {$menu1.bgColor}\r\n    preCObject = TEXT\r\n    preCObject.if.directReturn = {$menu1.topLine} || {$menu1.lineThickness}  |*||*| \r\n    preCObject.value = <tr bgcolor=\"{$menu1.lineColor}\"><td colspan=\"4\"><img src=\"clear.gif\" width=\"1\" height=\"{$menu1.lineThickness}\" alt=\"\" /></td></tr>\r\n    postCObject = TEXT\r\n    postCObject.if.directReturn = 0 |*||*| {$menu1.bottomLine}\r\n    postCObject.value = <tr bgcolor=\"{$menu1.lineColor}\"><td colspan=\"4\"><img src=\"clear.gif\" width=\"1\" height=\"{$menu1.lineThickness}\" alt=\"\" /></td></tr>\r\n  }\r\n\r\n  beforeImg = {$menu1.file.bullet_left}\r\n  beforeROImg = {$menu1.file.bullet_left_RO}\r\n  RO = {$menu1.file.bullet_left_RO}{$menu1.file.bullet_right_RO}\r\n  beforeWrap = <td>|</td><td width=\"99%\">\r\n  ATagParams = class=\"menuitems1\"\r\n  stdWrap2.wrapAlign= {$menu1.align}\r\n  afterImg = {$menu1.file.bullet_right}\r\n  afterROImg = {$menu1.file.bullet_right_RO}\r\n  afterWrap = </td><td>| </td><td><img src=\"clear.gif\" width=\"1\" height=\"{$menu1.itemHeight}\" alt=\"\" /></td>\r\n}\r\ntemp.menu1.1.ACT < temp.menu1.1.NO\r\ntemp.menu1.1.ACT = {$menu1.ACT}\r\ntemp.menu1.1.ACT {\r\n  allWrap.addParams.bgColor = {$menu1.ACT.bgColor}\r\n  beforeImg = {$menu1.ACT.file.bullet_left}\r\n  afterImg = {$menu1.ACT.file.bullet_right}\r\n  ATagParams = class=\"menuitems1ACT\"\r\n}\r\n\r\n\r\n# EXACT(!) copy of menu1; additions: entryLevel = 1, ATagParams = ...\r\ntemp.menu2 = HMENU\r\ntemp.menu2.entryLevel = 1\r\ntemp.menu2.stdWrap.offsetWrap = {$menu2.offset}\r\ntemp.menu2.wrap =<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">|</table>\r\ntemp.menu2.1 = TMENU\r\ntemp.menu2.1.NO {\r\n  allWrap = <tr>|</tr>\r\n  allWrap {\r\n    addParams.bgColor = {$menu2.bgColor}\r\n    preCObject = TEXT\r\n    preCObject.if.directReturn = {$menu2.topLine} || {$menu2.lineThickness}  |*||*| \r\n    preCObject.value = <tr bgcolor=\"{$menu2.lineColor}\"><td colspan=\"4\"><img src=\"clear.gif\" width=\"1\" height=\"{$menu2.lineThickness}\" alt=\"\" /></td></tr>\r\n    postCObject = TEXT\r\n    postCObject.if.directReturn = 0 |*||*| {$menu2.bottomLine}\r\n    postCObject.value = <tr bgcolor=\"{$menu2.lineColor}\"><td colspan=\"4\"><img src=\"clear.gif\" width=\"1\" height=\"{$menu2.lineThickness}\" alt=\"\" /></td></tr>\r\n  }\r\n\r\n  beforeImg = {$menu2.file.bullet_left}\r\n  beforeROImg = {$menu2.file.bullet_left_RO}\r\n  RO = {$menu2.file.bullet_left_RO}{$menu2.file.bullet_right_RO}\r\n  beforeWrap = <td>|</td><td width=\"99%\">\r\n  ATagParams = class=\"menuitems2\"\r\n  stdWrap2.wrapAlign= {$menu2.align}\r\n  afterImg = {$menu2.file.bullet_right}\r\n  afterROImg = {$menu2.file.bullet_right_RO}\r\n  afterWrap = </td><td>| </td><td><img src=\"clear.gif\" width=\"1\" height=\"{$menu2.itemHeight}\" alt=\"\" /></td>\r\n}\r\ntemp.menu2.1.ACT < temp.menu2.1.NO\r\ntemp.menu2.1.ACT = {$menu2.ACT}\r\ntemp.menu2.1.ACT {\r\n  allWrap.addParams.bgColor = {$menu2.ACT.bgColor}\r\n  beforeImg = {$menu2.ACT.file.bullet_left}\r\n  afterImg = {$menu2.ACT.file.bullet_right}\r\n  ATagParams = class=\"menuitems2ACT\"\r\n}\r\n\r\n\r\n\r\n\r\n# Page object\r\n\r\npage = PAGE\r\npage.typeNum = 0\r\npage.bodyTag < styles.content.bodyTag\r\npage.bodyTagMargins=0\r\npage.bgImg = {$page.file.bgImg}\r\npage.headerData.20 = TEXT\r\npage.headerData.20.value (\r\n  <style type=\"text/css\">\r\n  /*<![CDATA[*/\r\n  .menuitems1 {     {$menu1.NO.itemStyle} }\r\n  .menuitems2 {          {$menu2.NO.itemStyle}  }\r\n  .menuitems1ACT {     {$menu1.ACT.itemStyle} }\r\n  .menuitems2ACT {          {$menu2.ACT.itemStyle}  }\r\n\r\n   A.menuitems1:link { text-decoration: {$menu1.textDecor}; color: {$menu1.NO.itemLinkColor};}\r\n   A.menuitems1:visited {text-decoration: {$menu1.textDecor}; color: {$menu1.NO.itemLinkColor};}     \r\n   A.menuitems1:active {text-decoration: {$menu1.hoverTextDecor}; color: {$menu1.NO.itemLinkColorRO};}     \r\n   A.menuitems1:hover {text-decoration: {$menu1.hoverTextDecor}; color: {$menu1.NO.itemLinkColorRO};}\r\n\r\n   A.menuitems1ACT:link {text-decoration: {$menu1.textDecor}; color: {$menu1.ACT.itemLinkColor};}    \r\n   A.menuitems1ACT:visited {text-decoration: {$menu1.textDecor}; color: {$menu1.ACT.itemLinkColor};}     \r\n   A.menuitems1ACT:active {text-decoration: {$menu1.hoverTextDecor}; color: {$menu1.ACT.itemLinkColorRO};}     \r\n   A.menuitems1ACT:hover {text-decoration: {$menu1.hoverTextDecor}; color: {$menu1.ACT.itemLinkColorRO};}\r\n\r\n   A.menuitems2:link { text-decoration: {$menu2.textDecor}; color: {$menu2.NO.itemLinkColor};}\r\n   A.menuitems2:visited {text-decoration: {$menu2.textDecor}; color: {$menu2.NO.itemLinkColor};}     \r\n   A.menuitems2:active {text-decoration: {$menu2.hoverTextDecor}; color: {$menu2.NO.itemLinkColorRO};}     \r\n   A.menuitems2:hover {text-decoration: {$menu2.hoverTextDecor}; color: {$menu2.NO.itemLinkColorRO};}\r\n\r\n   A.menuitems2ACT:link {text-decoration: {$menu2.textDecor}; color: {$menu2.ACT.itemLinkColor};}    \r\n   A.menuitems2ACT:visited {text-decoration: {$menu2.textDecor}; color: {$menu2.ACT.itemLinkColor};}     \r\n   A.menuitems2ACT:active {text-decoration: {$menu2.hoverTextDecor}; color: {$menu2.ACT.itemLinkColorRO};}     \r\n   A.menuitems2ACT:hover {text-decoration: {$menu2.hoverTextDecor}; color: {$menu2.ACT.itemLinkColorRO};}\r\n   /*]]>*/\r\n  </style>\r\n)\r\n\r\npage.stdWrap {\r\n  offsetWrap = {$page.offset}\r\n  offsetWrap.stdWrap.wrapAlign = {$page.align}\r\n  offsetWrap.tdParams = valign=\"top\"\r\n}\r\n\r\n# Starting big table:\r\npage.10 = HTML\r\npage.10.value = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"1\">\r\npage.10.value {\r\n  addParams._offset = -1\r\n  addParams.bgColor = {$page.bgColors.wholeTableBgColor}\r\n  addParams.background = {$page.file.wholeTableBgImg}\r\n}\r\n\r\n# Menu column start:\r\npage.13 = HTML\r\npage.13.value = <tr><td valign=\"top\">\r\npage.13.value {\r\n  if.directReturn = {$menuCol.enable}\r\n  addParams._offset = -1\r\n  addParams.bgColor = {$page.bgColors.menuBgColor}\r\n  addParams.background = {$page.file.menuBgImg}\r\n}\r\n\r\npage.15.stdWrap.if.directReturn = {$menuCol.enable}\r\npage.15 = COA\r\npage.15 {\r\n  10 = IMAGE\r\n  10.file = {$page.file.logoImg}\r\n  10.stdWrap.offsetWrap = 0,0\r\n  10.stdWrap.required=1\r\n  10.stdWrap.typolink.parameter.data = leveluid : 0\r\n\r\n  20 < temp.menu1\r\n\r\n  29 = LOAD_REGISTER\r\n  29.maxImageWidth = {$menuCol.maxImageWidth}\r\n  29.textStyle_face = {$menuCol.textStyle_face}\r\n  29.textStyle_size = {$menuCol.textStyle_size}\r\n  29.textStyle_color = {$menuCol.textStyle_color}\r\n  29.defaultHeaderType = {$menuCol.defaultHeaderType}\r\n  29.pageColor = {$page.bgColors.menuBgColor}\r\n  30 < styles.content.{$menuCol.borderContent}\r\n  30.stdWrap.offsetWrap = {$menuCol.offset}\r\n  31 = RESTORE_REGISTER\r\n}\r\n\r\n\r\n# Main column start:\r\npage.20 = HTML\r\npage.20.value = </td><td valign=\"top\">\r\n\r\npage.25 = COA\r\npage.25 {\r\n  10 = HTML\r\n  10.value = <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n\r\n    # Setting top image, if any\r\n  11 = COA\r\n  11.stdWrap.if.directReturn = {$page.file.topImg}\r\n  11.10=HTML\r\n  11.10.value = <tr><td colspan=\"4\">\r\n  11.15 = IMAGE\r\n  11.15.file = {$page.file.topImg}\r\n  11.15.file.import = uploads/media/\r\n  11.15.file.import.data = levelmedia : -1, slide\r\n  11.15.file.import.listNum=0\r\n  11.20 = HTML\r\n  11.20.value = </td></tr>\r\n\r\n    # Setting topimage to content distance, if any\r\n  13 = COA\r\n  13.stdWrap.if.directReturn = {$page.topImgToContentDist}\r\n  13.10=HTML\r\n  13.10.value = <tr><td colspan=\"4\">\r\n  13.15 = CLEARGIF\r\n  13.15.height = {$page.topImgToContentDist}\r\n  13.20 = HTML\r\n  13.20.value = </td></tr>\r\n\r\n\r\n    # starting row for normal and right content \r\n  14 = HTML\r\n  14.value = <tr><td>\r\n\r\n    # margin\r\n  15 = CLEARGIF\r\n  15.width = {$page.contentMarginLeft}\r\n  15.height = {$pageCol.page.height}\r\n\r\n    # Normal content column\r\n  20 = HTML\r\n  20.value = </td><td valign=\"top\">\r\n  20.value.addParams._offset = -1\r\n  20.value.addParams.bgColor = {$page.bgColors.normalBgColor}\r\n  20.value.addParams.background = {$page.file.normalBgImg}\r\n\r\n  25 = COA \r\n  25.stdWrap.offsetWrap = {$pageCol.page.contentOffset}\r\n  25.5 = CLEARGIF\r\n  25.5.width = {$pageCol.page.width}\r\n  25.7 <  styles.content.editPanelPage\r\n  25.9 = LOAD_REGISTER\r\n  25.9.maxImageWidth = {$pageCol.maxImageWidth}\r\n  25.9.pageColor = {$page.bgColors.normalBgColor}\r\n  25.10 < styles.content.get\r\n  25.11 = RESTORE_REGISTER\r\n  25.20  < styles.content.lastUpdate\r\n  25.30 < styles.content.typo3_powered\r\n\r\n    # right margin\r\n  30 = HTML\r\n  30.value = </td><td valign=\"top\">\r\n\r\n  35 = CLEARGIF\r\n  35.width = {$page.contentMarginRight}\r\n\r\n    # right content column\r\n  40 = HTML\r\n  40.value = </td><td valign=\"top\">\r\n  40.value.addParams._offset = -1\r\n  40.value.addParams.bgColor = {$page.bgColors.rightBgColor}\r\n  40.value.addParams.background = {$page.file.rightBgImg}\r\n\r\n  43 = IMAGE\r\n  43.file = {$page.file.marginLogoImg}\r\n  43.stdWrap.wrap = |<br />\r\n  43.stdWrap.offsetWrap = 0,0\r\n  43.stdWrap.required=1\r\n  43.stdWrap.if.directReturn = {$rightCol.enable}\r\n\r\n  45 = COA \r\n  45.stdWrap.if.directReturn = {$rightCol.enable}\r\n  45.stdWrap.offsetWrap = {$rightCol.offset}\r\n  45.5 = CLEARGIF\r\n  45.5.width = {$rightCol.maxImageWidth}\r\n  45.7 < temp.menu2\r\n  45.9 = LOAD_REGISTER\r\n  45.9.maxImageWidth = {$rightCol.maxImageWidth}\r\n  45.9.textStyle_face = {$rightCol.textStyle_face}\r\n  45.9.textStyle_size = {$rightCol.textStyle_size}\r\n  45.9.textStyle_color = {$rightCol.textStyle_color}\r\n  45.9.defaultHeaderType = {$rightCol.defaultHeaderType}\r\n  45.9.pageColor = {$page.bgColors.rightBgColor}\r\n  45.10 < styles.content.{$rightCol.borderContent}\r\n  45.10.select.pidInList = {$rightCol.getNewsPid}\r\n  45.11 = RESTORE_REGISTER\r\n\r\n    # end\r\n  50 = HTML\r\n  50.value = </td></tr></table>\r\n}\r\n\r\n# end\r\npage.30 = HTML\r\npage.30.value = </td></tr></table><br />\r\n\r\n\r\n\r\n# Configuration\r\nconfig.extTarget = _blank\r\nconfig.compensateFieldWidth = 0.7\r\n\r\npage.config.admPanel = 1\r\nconfig.intTarget = {$PAGE_TARGET}\r\npage.headerData.999 < plugin.meta\r\n\r\n','','');
INSERT INTO `static_template` VALUES (90,0,1054753018,1002209598,'plugin.tipafriend [DEPRECIATED]','','plugin.tipafriend {\r\n    # cat=plugin.tipafriend/file; type=file[html,htm,tmpl,txt]; label= Template File: HTML-template file for display of the Tip-a-Friend form\r\n  file.templateFile = media/scripts/tipafriend_template.tmpl\r\n\r\n    # cat=plugin.tipafriend/typo; type=wrap; label= Wrap 1: This wrap is used in the template-file.\r\n  wrap1 = <font face=\"verdana\" size=\"2\" color=\"black\"> | </font>\r\n    # cat=plugin.tipafriend/typo; type=wrap; label= Wrap 2: This wrap is used in the template-file.\r\n  wrap2 = <font face=\"verdana\" size=\"1\" color=\"black\"> | </font>\r\n\r\n    # cat=plugin.tipafriend/color; type=color; label= Color 1: This bgcolor is used in the template-file.\r\n  color1 = #cccccc\r\n    # cat=plugin.tipafriend/color; type=color; label= Color 2: This bgcolor is used in the template-file.\r\n  color2 = #999999\r\n    # cat=plugin.tipafriend/color; type=color; label= Color 3: This bgcolor is used in the template-file.\r\n  color3 = #333333\r\n\r\n    # cat=plugin.tipafriend//; type=int+; label= PID for the Tip-form page.\r\n  PIDtipForm = 0\r\n    # cat=plugin.tipafriend/enable; type=boolean; label= Send page as HTML: If set, the mail is sent as an HTML mail.\r\n  htmlMail = 0\r\n}\r\n','## Includes the newsLib:\r\nincludeLibs.ts_tipafriend= media/scripts/tipafriendLib.inc\r\n\r\n## This enables the tt_content.list item to display the news:\r\nplugin.tipafriend >\r\nplugin.tipafriend = USER\r\nplugin.tipafriend {\r\n  userFunc = user_tipafriend->main_tipafriend\r\n  code.field = select_key\r\n  templateFile = {$plugin.tipafriend.file.templateFile}\r\n\r\n  # Global wraps\r\n  wrap1.wrap = {$plugin.tipafriend.wrap1}\r\n  wrap2.wrap = {$plugin.tipafriend.wrap2}\r\n  color1.wrap = {$plugin.tipafriend.color1}\r\n  color2.wrap = {$plugin.tipafriend.color2}\r\n  color3.wrap = {$plugin.tipafriend.color3}\r\n\r\n  typolink.parameter = {$plugin.tipafriend.PIDtipForm}\r\n  htmlmail = {$plugin.tipafriend.htmlMail}\r\n\r\n}\r\n','PLUGIN: Tip-a-Friend module\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n','');
INSERT INTO `static_template` VALUES (91,0,1054752935,1002543181,'plugin.feadmin.dmailsubscription [DEPRECIATED]','','plugin.feadmin.dmailsubscription {\r\n    # cat=plugin.feadmin.dmailsubscription/file; type=file[html,htm,tmpl,txt]; label= Template File: HTML-template file\r\n  file.templateFile = media/scripts/fe_admin_dmailsubscrip.tmpl\r\n\r\n    # cat=plugin.feadmin.dmailsubscription//; type=string; label= Administration email: Enter the administration email address here. This email address will be the sender email and also recieve administration notes.\r\n  email = \r\n    # cat=plugin.feadmin.dmailsubscription//; type=string; label= Administration name: Enter the administration name here. If set, this will be used as the email address name in the mails sent.\r\n  emailName = \r\n\r\n    # cat=plugin.feadmin.dmailsubscription//; type=int+; label= Record PID: If the records edited/created is located in another page than the current, enter the PID of that page here.\r\n  pid = \r\n\r\n\r\n    # cat=plugin.feadmin.dmailsubscription/typo; type=wrap; label= Wrap 1: This wrap is used in the template-file.\r\n  wrap1 = <font face=\"verdana\" size=\"2\" color=\"black\"> | </font>\r\n    # cat=plugin.feadmin.dmailsubscription/typo; type=wrap; label= Wrap 2: This wrap is used in the template-file.\r\n  wrap2 = <font face=\"verdana\" size=\"1\" color=\"black\"> | </font>\r\n\r\n    # cat=plugin.feadmin.dmailsubscription/color; type=color; label= Color 1: This bgcolor is used in the template-file.\r\n  color1 = #cccccc\r\n    # cat=plugin.feadmin.dmailsubscription/color; type=color; label= Color 2: This bgcolor is used in the template-file.\r\n  color2 = #999999\r\n    # cat=plugin.feadmin.dmailsubscription/color; type=color; label= Color 3: This bgcolor is used in the template-file.\r\n  color3 = #333333\r\n\r\n}\r\n','plugin.feadmin.dmailsubscription >\r\nplugin.feadmin.dmailsubscription = USER_INT\r\nplugin.feadmin.dmailsubscription {\r\n  userFunc = user_feAdmin->init\r\n  includeLibs = media/scripts/fe_adminLib.inc\r\n  templateFile ={$plugin.feadmin.dmailsubscription.file.templateFile}\r\n\r\n  # Global wraps\r\n  wrap1.wrap = {$plugin.feadmin.dmailsubscription.wrap1}\r\n  wrap2.wrap = {$plugin.feadmin.dmailsubscription.wrap2}\r\n  color1.wrap = {$plugin.feadmin.dmailsubscription.color1}\r\n  color2.wrap = {$plugin.feadmin.dmailsubscription.color2}\r\n  color3.wrap = {$plugin.feadmin.dmailsubscription.color3}\r\n\r\n  // Tables + Commands\r\n  table = tt_address\r\n\r\n    // Info-mail setup\r\n  setfixed=1\r\n  setfixed.approve {\r\n    _FIELDLIST = uid\r\n    hidden = 0\r\n  }\r\n  setfixed.DELETE = 1\r\n  setfixed.DELETE._FIELDLIST = uid\r\n\r\n  delete = 1\r\n  defaultCmd=create\r\n\r\n  // Info-mail setup\r\n  infomail = 1\r\n  infomail.default {\r\n    label = FORGOTPASSWORD\r\n  }\r\n\r\n  // Edit setup\r\n  edit = 1\r\n  edit.fields = name, email, module_sys_dmail_category, module_sys_dmail_html\r\n  edit.required = name, email\r\n  edit.evalValues {\r\n    email = uniqueLocal, email\r\n  }\r\n\r\n  // Create setup\r\n  create = 1\r\n  create.preview = 0\r\n  create.fields = name, hidden, email, module_sys_dmail_category, module_sys_dmail_html\r\n  create.required = name, email\r\n  create.noSpecialLoginForm = 1\r\n    # Initially hide the user until he approves!\r\n  create.overrideValues.hidden = 1\r\n  create.evalValues {\r\n    email = uniqueLocal, email\r\n  }\r\n\r\n  authcodeFields = uid\r\n  authcodeFields.addKey = \r\n  authcodeFields.addDate = \r\n\r\n  evalErrors.email.uniqueLocal = Apparently you\'re already registered with this email address!\r\n  evalErrors.email.email = This is not a proper email address!\r\n\r\n  parseValues.module_sys_dmail_category = checkArray,setEmptyIfAbsent \r\n  parseValues.module_sys_dmail_html = setEmptyIfAbsent \r\n  pid = {$plugin.feadmin.dmailsubscription.pid}\r\n\r\n  email.from = {$plugin.feadmin.dmailsubscription.email}\r\n  email.fromName = {$plugin.feadmin.dmailsubscription.emailName}\r\n  email.admin = {$plugin.feadmin.dmailsubscription.email}\r\n  email.field = email\r\n}\r\n\r\n','PLUGIN: Direct-Mail subscription example\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n','');
INSERT INTO `static_template` VALUES (92,0,1054752963,1002543825,'plugin.feadmin.fe_users [DEPRECIATED]','','plugin.feadmin.fe_users {\r\n    # cat=plugin.feadmin.fe_users/file; type=file[html,htm,tmpl,txt]; label= Template File: HTML-template file \r\n  file.templateFile = media/scripts/fe_admin_fe_users.tmpl\r\n\r\n    # cat=plugin.feadmin.fe_users//; type=string; label= Administration email: Enter the administration email address here. This email address will be the sender email and also recieve administration notes.\r\n  email = \r\n    # cat=plugin.feadmin.fe_users//; type=string; label= Administration name: Enter the administration name here. If set, this will be used as the email address name in the mails sent.\r\n  emailName = \r\n\r\n    # cat=plugin.feadmin.fe_users//; type=int+; label= Record PID: If the records edited/created is located in another page than the current, enter the PID of that page here.\r\n  pid = \r\n    # cat=plugin.feadmin.fe_users//; type=int+; label= Usergroup override: Enter the value of the user group field. Must be a list of integers WITHOUT spaces between the comma separated values! Furthermore these integer MUST point to actual fe_groups records!\r\n  usergroupOverride = \r\n\r\n\r\n    # cat=plugin.feadmin.fe_users/typo; type=wrap; label= Wrap 1: This wrap is used in the template-file.\r\n  wrap1 = <font face=\"verdana\" size=\"2\" color=\"black\"> | </font>\r\n    # cat=plugin.feadmin.fe_users/typo; type=wrap; label= Wrap 2: This wrap is used in the template-file.\r\n  wrap2 = <font face=\"verdana\" size=\"1\" color=\"black\"> | </font>\r\n\r\n    # cat=plugin.feadmin.fe_users/color; type=color; label= Color 1: This bgcolor is used in the template-file.\r\n  color1 = #cccccc\r\n    # cat=plugin.feadmin.fe_users/color; type=color; label= Color 2: This bgcolor is used in the template-file.\r\n  color2 = #999999\r\n    # cat=plugin.feadmin.fe_users/color; type=color; label= Color 3: This bgcolor is used in the template-file.\r\n  color3 = #333333\r\n\r\n}\r\n\r\n\r\n','plugin.feadmin.fe_users >\r\nplugin.feadmin.fe_users = USER_INT\r\nplugin.feadmin.fe_users {\r\n  userFunc = user_feAdmin->init\r\n  includeLibs = media/scripts/fe_adminLib.inc\r\n  templateFile ={$plugin.feadmin.fe_users.file.templateFile}\r\n\r\n  # Global wraps\r\n  wrap1.wrap = {$plugin.feadmin.fe_users.wrap1}\r\n  wrap2.wrap = {$plugin.feadmin.fe_users.wrap2}\r\n  color1.wrap = {$plugin.feadmin.fe_users.color1}\r\n  color2.wrap = {$plugin.feadmin.fe_users.color2}\r\n  color3.wrap = {$plugin.feadmin.fe_users.color3}\r\n\r\n  // Tables + Commands\r\n  table=fe_users\r\n  defaultCmd=create\r\n  debug=0\r\n\r\n  setfixed=0\r\n  delete=1\r\n\r\n    // Info-mail setup\r\n  infomail = 1\r\n  infomail.default {\r\n    label = FORGOTPASSWORD\r\n  }\r\n\r\n    // Creating\r\n  create = 1\r\n  create.preview = 1\r\n  create.fields = username,password,name,email,usergroup,address,telephone,fax,title,company,zip,city,country,www\r\n  create.required = username,password,name,email\r\n  create.overrideValues {\r\n    usergroup = {$plugin.feadmin.fe_users.usergroupOverride}\r\n  }\r\n  create.evalValues {\r\n    password = twice, atLeast[5]\r\n    username = uniqueLocal, atLeast[4]\r\n    email = email\r\n  }\r\n\r\n    // Editing:\r\n  edit < .create\r\n  edit.overrideValues {\r\n    username = \r\n  }\r\n  edit.evalValues {\r\n    username = unsetEmpty\r\n  }\r\n\r\n\r\n    // Field parsing and evaluation error messages:\r\n  parseValues {\r\n    username = lower,nospace,trim\r\n    email < .username\r\n    password = trim\r\n  }\r\n  evalErrors {\r\n    password.twice = You must enter the password twice.\r\n    password.atLeast = There must be at least %s characters in your password!\r\n    email.email = The email address is not validly formed. Must contain @ and a domain\r\n    username.uniqueLocal = The username exists already. Please select another one.\r\n    username.atLeast = There must be at least %s characters in your username!\r\n  }\r\n  pid = {$plugin.feadmin.fe_users.pid}\r\n  fe_userOwnSelf = 1\r\n  fe_userEditSelf = 1\r\n\r\n  cObjects.LOGIN = < tt_content.login.20\r\n\r\n  email.from = {$plugin.feadmin.fe_users.email}\r\n  email.fromName = {$plugin.feadmin.fe_users.emailName}\r\n  email.admin = {$plugin.feadmin.fe_users.email}\r\n  email.field = email\r\n}\r\n\r\n','PLUGIN: FrontEnd user creation / administration\r\nAUTHOR: Kasper Skrhj, kasper@typo3.com\r\n\r\n','');
INSERT INTO `static_template` VALUES (93,0,1054752696,1004049254,'language.de (german) [DEPRECIATED]','','','## Setting the TypoScript language to german:\r\nconfig.language = de\r\n\r\n\r\n# ***********************************\r\n#  Login form as used in \'content (default)\'\r\n# ***********************************\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.de = Benutzername:\r\n    20.label.lang.de = Password:\r\n    40.value.lang.de = Login\r\n}\r\n\r\n[usergroup = *]\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.de = Benutzername: <!--###USERNAME###-->\r\n    20 >\r\n    40.value.lang.de = Logout\r\n}\r\n[global]\r\n\r\n\r\n\r\n\r\n# ***********************\r\n#  Search dialog object\r\n# ***********************\r\n\r\ntt_content.search.30.dataArray {\r\n    10.label.lang.de = Suchen:\r\n    20.label.lang.de = in\r\n    20.valueArray {\r\n      10.label.lang.de = berschriften und Stichworten\r\n      20.label.lang.de = Seiteninhalt\r\n    }\r\n    40.value.lang.de = Suche starten\r\n}\r\n\r\n\r\n\r\n# ***********************\r\n#  Search result page object\r\n# ***********************\r\ntt_content.search.20 {\r\n  layout.10.lang.de = Suchergebnis: ###RANGELOW###-###RANGEHIGH### von \r\n###TOTAL###\r\n  noResultObj.10.lang.de = Die Suche brachte kein Ergebnis!\r\n  next.lang.de = Nchste\r\n  prev.lang.de = Vorherige\r\n}\r\n\r\n\r\n\r\n# ***********************\r\n#  Default Guestbook form\r\n# ***********************\r\nplugin.tt_guest.postform.dataArray {\r\n  10.label.lang.de = berschrift:\r\n  20.label.lang.de = Dein Kommentar:\r\n  30.label.lang.de = Name:\r\n  40.label.lang.de = Email:\r\n  50.label.lang.de = Homepage:\r\n  60.value.lang.de = Eintragen\r\n}\r\n\r\n\r\n# ***********************\r\n#  Default List Board form\r\n# ***********************\r\nplugin.tt_board_list.postform.dataArray {\r\n  10.label.lang.de = Thema:\r\n  20.label.lang.de = Mitteilung:\r\n  30.label.lang.de = Name:\r\n  40.label.lang.de = Email:\r\n  50.label.lang.de = Benachrichtigung<br />bei Antwort(en):\r\n  60.value.lang.de = Antwort absenden\r\n}\r\nplugin.tt_board_list.postform_newThread.dataArray {\r\n  10.label.lang.de = Thema:\r\n  20.label.lang.de = Mitteilung:\r\n  30.label.lang.de = Name:\r\n  40.label.lang.de = Email:\r\n  50.label.lang.de = Benachrichtigung<br />bei Antwort(en):\r\n  60.value.lang.de = Diskussion erffnen\r\n}\r\n\r\n# ***********************\r\n#  Default Tree Board form\r\n# ***********************\r\nplugin.tt_board_tree.postform.dataArray {\r\n  10.label.lang.de = Thema:\r\n  20.label.lang.de = Mitteilung:\r\n  30.label.lang.de = Name:\r\n  40.label.lang.de = Email:\r\n  50.label.lang.de = Benachrichtigung<br />bei Antwort(en):\r\n  60.value.lang.de = Antwort absenden\r\n}\r\nplugin.tt_board_tree.postform_newThread.dataArray {\r\n  10.label.lang.de = Thema:\r\n  20.label.lang.de = Mitteilung:\r\n  30.label.lang.de = Name:\r\n  40.label.lang.de = Email:\r\n  50.label.lang.de = Benachrichtigung<br />bei Antwort(en):\r\n  60.value.lang.de = Diskussion erffnen\r\n}\r\n\r\n','This implements german labels on these standard elements \r\n\r\nFrom \'content (default)\':\r\n\r\n- login form \r\n- search form\r\n- search result\r\n\r\nFrom \'tt_guest\':\r\n\r\n- submit form.\r\n\r\n\r\nFrom \'tt_board\':\r\n\r\n- submit forms.\r\n','');
INSERT INTO `static_template` VALUES (94,0,1054753170,1004097988,'plugin.tt_poll [DEPRECIATED]','','plugin.tt_poll >\r\nplugin.tt_poll {\r\n\r\n    # cat=plugin.poll/typo; type=int; label= The length of a bar or similiar that indicates 100%.\r\n  pollOutputWidth = 250\r\n    # cat=plugin.poll/typo; type=; label= Image used to render the bar begin.\r\n  beginBarImgFile = media/scripts/pollbar-begin.gif\r\n    # cat=plugin.poll/typo; type=; label= Image used to render the bar.\r\n  mainBarImgFile = media/scripts/pollbar-main.gif\r\n    # cat=plugin.poll/typo; type=; label= Image used to render the bar end.\r\n  endBarImgFile = media/scripts/pollbar-end.gif\r\n\r\n}\r\n','## Includes the pollLib:\r\nincludeLibs.ts_poll = media/scripts/pollLib.inc\r\n\r\n## Sets up the fields, that may be submitted in order to create items. Mandatory!\r\nFEData.tt_poll {\r\n  processScript = media/scripts/poll_submit.inc\r\n  allowEdit {\r\n    // following item is used to pass the vote to fe_tce.php, It\'s NOT a fields\r\n    vote = 1\r\n  }\r\n}\r\n\r\n\r\nplugin.tt_poll >\r\nplugin.tt_poll = USER\r\nplugin.tt_poll {\r\n  userFunc = user_poll->main_poll\r\n\r\n  code = VOTEFORM\r\n\r\n  pollOutputWidth = {$plugin.tt_poll.pollOutputWidth}\r\n\r\n  date_stdWrap.strftime= %e-%m-%y\r\n\r\n  voteform < styles.content.mailform\r\n  voteform.layout = <tr><td>###FIELD###</td></tr>\r\n  voteform.stdWrap.wrap = <table border=\"0\" cellspacing=\"0\" cellpadding=\"2\" bgcolor=\"#000000\"><tr><td><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\" bgcolor=\"#ffffff\"> | </table></tr></td></table>\r\n  voteform.stdWrap.innerWrap.cObject = COA\r\n  voteform.stdWrap.innerWrap.cObject {\r\n    10 = TEXT\r\n    10.value = Survey\r\n    10.wrap = <tr><td align=\"center\" bgcolor=\"#CCCCCC\">|</td></tr>\r\n    10.textStyle < styles.content.textStyle\r\n    10.textStyle.altWrap = <span class=\"mailform\">|</span>\r\n\r\n    20 = TEXT\r\n    20.value = <b>###QUESTION###</b>\r\n    20.wrap = <tr><td>|</td></tr>\r\n    20.textStyle < styles.content.textStyle\r\n    20.textStyle.altWrap = <span class=\"mailform\">|</span>\r\n  }\r\n  voteform.data >\r\n    // put only the submit button here!!!\r\n  voteform.dataArray {\r\n    10.type = formtype_db = submit\r\n    10.value = Vote\r\n  }\r\n\r\n  voteform.radioWrap.textStyle < styles.content.textStyle\r\n  voteform.radioWrap.textStyle.altWrap = <span class=\"mailform\">|</span>\r\n  voteform.no_cache=1\r\n  voteform.noValueInsert=1\r\n  voteform.wrap =\r\n\r\n  resultObj = COA\r\n  resultObj.wrap = <table border=\"0\" cellspacing=\"0\" cellpadding=\"2\" bgcolor=\"#000000\"><tr><td><table cellspacing=\"0\" cellpadding=\"3\" border=\"0\" bgcolor=\"#ffffff\">|</table></tr></td></table>\r\n  resultObj {\r\n    10 = TEXT\r\n    10.value = Survey Result\r\n    10.wrap = <tr><td colspan=\"2\" align=\"center\" bgcolor=\"#CCCCCC\">|</td></tr>\r\n    10.textStyle < styles.content.textStyle\r\n    10.textStyle.altWrap = <span class=\"mailform\">|</span>\r\n\r\n    20 = TEXT\r\n    20.value = <b>###QUESTION###</b>\r\n    20.wrap = <tr><td colspan=\"2\" align=\"center\"><br />|<br /><br /></td></tr>\r\n    20.textStyle < styles.content.textStyle\r\n    20.textStyle.altWrap = <span class=\"mailform\">|</span>\r\n\r\n    30 = TEXT\r\n    30.value = ###RESULTITEMS###\r\n\r\n    40 = TEXT\r\n    40.value = ###TOTALVOTES### votes total\r\n    40.wrap = <tr><td colspan=\"2\" align=\"center\"><br />|<br /></td></tr>\r\n    40.textStyle < styles.content.textStyle\r\n    40.textStyle.altWrap = <span class=\"mailform\">|</span>\r\n\r\n    50 = HTML\r\n    50.value = ###PROGRESSMSG######VOTEMSG###\r\n  }\r\n\r\n  resultItemObj = COA\r\n  resultItemObj.wrap =  <tr>|</tr>\r\n  resultItemObj {\r\n\r\n    10 = TEXT\r\n    10.value = ###ANSWER###\r\n    10.wrap = <td nowrap=\"nowrap\">&nbsp;&nbsp;|</td>\r\n    10.textStyle < styles.content.textStyle\r\n    10.textStyle.altWrap = <span class=\"mailform\">|</span>\r\n\r\n    20 = HTML\r\n    20.value = <td nowrap=\"nowrap\"><img src=\"{$plugin.tt_poll.beginBarImgFile}\" height=\"14\" width=\"7\" alt=\"\" /><img src=\"{$plugin.tt_poll.mainBarImgFile}\" height=\"14\" width=\"###POLLWIDTH###\" alt=\"###PERCENT### %\" /><img src=\"{$plugin.tt_poll.endBarImgFile}\" height=\"14\" width=\"7\" alt=\"\" />\r\n\r\n    30 = TEXT\r\n    30.value = &nbsp;###PERCENT### % (###ITEMVOTES### votes)\r\n    30.wrap = |&nbsp;&nbsp;</td>\r\n    30.textStyle < styles.content.textStyle\r\n    30.textStyle.altWrap = <span class=\"mailform\">|</span>\r\n  }\r\n\r\n  inProgressObj = TEXT\r\n  inProgressObj {\r\n    wrap = <tr><td colspan=\"2\" align=\"center\"><br />|<br /></td></tr>\r\n    value = The Survey will end at ###ENDTIME###.\r\n    textStyle < styles.content.textStyle\r\n    textStyle.altWrap = <span class=\"mailform\">|</span>\r\n  }\r\n\r\n  finishedObj = TEXT\r\n  finishedObj {\r\n    wrap = <tr><td colspan=\"2\" align=\"center\"><br />|<br /></td></tr>\r\n    value = The Survey was finished at ###ENDTIME###.\r\n    textStyle < styles.content.textStyle\r\n    textStyle.altWrap = <span class=\"mailform\">|</span>\r\n  }\r\n\r\n  submittedVoteObj = TEXT\r\n  submittedVoteObj {\r\n    wrap = <tr><td colspan=\"2\" align=\"center\"><br />|<br /></td></tr>\r\n    value = Your voting was: <b>\"###SUBMITTEDVOTE###\"</b>.\r\n    textStyle < styles.content.textStyle\r\n    textStyle.altWrap = <span class=\"mailform\">|</span>\r\n  }\r\n}\r\n\r\n\r\n','Author: Ren Fritz <r.fritz@colorcube.de>','');
INSERT INTO `static_template` VALUES (95,0,1054752760,1010109604,'language.nl (dutch) [DEPRECIATED]','','# ***********************\r\n#  Newsletter subscription\r\n# ***********************\r\nplugin.feadmin.dmailsubscription.file.templateFile = media/scripts/fe_admin_dmailsubscrip_dk.tmpl','## Setting the TypoScript language to dutch:\r\nconfig.language = nl\r\n\r\n\r\n# ***********************************\r\n#  Login form as used in \'content (default)\'\r\n# ***********************************\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.nl = Gebruikersnaam:\r\n    20.label.lang.nl = Wachtwoord:\r\n    40.value.lang.nl = Log In\r\n}\r\n\r\n[usergroup = *]\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.nl = Gebruikersnaam: <!--###USERNAME###-->\r\n    20 >\r\n    40.value.lang.nl = Log Uit\r\n}\r\n[global]\r\n\r\n\r\n\r\n\r\n# ***********************\r\n#  Search dialog object\r\n# ***********************\r\n\r\ntt_content.search.30.dataArray {\r\n    10.label.lang.nl = Zoeken:\r\n    20.label.lang.nl = in\r\n    20.valueArray {\r\n      10.label.lang.nl = Titels en kernwoorden\r\n      20.label.lang.nl = Site-inhoud\r\n    }\r\n    40.value.lang.nl = Zoeken\r\n}\r\n\r\n\r\n\r\n# ***********************\r\n#  Search result page object\r\n# ***********************\r\ntt_content.search.20 {\r\n  layout.10.lang.nl = Zoekresultaat: ###RANGELOW###-###RANGEHIGH### van ###TOTAL###\r\n  noResultObj.10.lang.nl = Helaas, Er zijn geen pagina\'s gevonden die voldoen aan de opgegeven criteria. Pas je zoekopdracht aan en probeer het nog eens!\r\n  next.lang.nl = Volgende\r\n  prev.lang.nl = Volgende\r\n}\r\n\r\n\r\n\r\n# ***********************\r\n#  Default Guestbook form\r\n# ***********************\r\nplugin.tt_guest.postform.dataArray {\r\n  10.label.lang.nl = Onderwerp:\r\n  20.label.lang.nl = Jouw commentaar:\r\n  30.label.lang.nl = Naam:\r\n  40.label.lang.nl = Email:\r\n  50.label.lang.nl = Homepage:\r\n  60.value.lang.nl = Verzenden\r\n}\r\n\r\n\r\n# ***********************\r\n#  Default List Board form\r\n# ***********************\r\nplugin.tt_board_list.postform.dataArray {\r\n  10.label.lang.nl = Thema:\r\n  20.label.lang.nl = Mededeling:\r\n  30.label.lang.nl = Naam:\r\n  40.label.lang.nl = Email:\r\n  50.label.lang.nl = Kennisgeving<br />bij antwoord:\r\n  60.value.lang.nl = Antwoord verzenden\r\n}\r\nplugin.tt_board_list.postform_newThread.dataArray {\r\n  10.label.lang.nl = Thema:\r\n  20.label.lang.nl = Mededeling:\r\n  30.label.lang.nl = Naam:\r\n  40.label.lang.nl = Email:\r\n  50.label.lang.nl = Kennisgeving<br />bij antwoord:\r\n  60.value.lang.nl = Discussie openen\r\n}\r\n\r\n    // \"You must fill in these fields:\"\r\nplugin.tt_board_list.postform.badMess = Je moet de volgende velden invullen:\r\nplugin.tt_board_list.postform_newThread.badMess = Je moet de volgende velden invullen:\r\n\r\n# ***********************\r\n#  Default Tree Board form\r\n# ***********************\r\nplugin.tt_board_tree.postform.dataArray {\r\n  10.label.lang.nl = Thema:\r\n  20.label.lang.nl = Mededeling:\r\n  30.label.lang.nl = Naam:\r\n  40.label.lang.nl = Email:\r\n  50.label.lang.nl = Kennisgeving<br />bij antwoord:\r\n  60.value.lang.nl = Antwoord verzenden\r\n}\r\nplugin.tt_board_tree.postform_newThread.dataArray {\r\n  10.label.lang.nl = Thema:\r\n  20.label.lang.nl = Mededeling:\r\n  30.label.lang.nl = Naam:\r\n  40.label.lang.nl = Email:\r\n  50.label.lang.nl = Kennisgeving<br />bij antwoord:\r\n  60.value.lang.nl = Discussie openen\r\n}\r\n\r\n\r\nplugin.tt_board_tree.postform.badMess = Je moet de volgende velden invullen:\r\nplugin.tt_board_tree.postform_newThread.badMess = Je moet de volgende velden invullen:\r\n\r\n\r\n\r\n# ***********************\r\n#  Newsletter subscription\r\n# ***********************\r\nplugin.feadmin.dmailsubscription.evalErrors.email {\r\n     // \"Apparently you\'re already registered with this email address!\r\n  uniqueLocal = Kennelijk ben je al geregistreerd met dit emailadres!\r\n     // This is not a correct email address!\r\n  email = Dit is geen geldig emailadres!\r\n}\r\n\r\n','This implements dutch labels on these standard elements \r\n(Translation by ben van \'t ende / netcreators.nl, <ben@netcreators.nl>\r\n\r\nFrom \'content (default)\':\r\n\r\n- login form \r\n- search form\r\n- search result\r\n\r\nFrom \'tt_guest\':\r\n\r\n- submit form.\r\n\r\n\r\nFrom \'tt_board\':\r\n\r\n- submit forms.\r\n\r\n\r\n','');
INSERT INTO `static_template` VALUES (96,0,1054752741,1010702909,'language.fr (french) [DEPRECIATED]','','# ***********************\r\n#  Newsletter subscription\r\n# ***********************\r\nplugin.feadmin.dmailsubscription.file.templateFile = media/scripts/fe_admin_dmailsubscrip_dk.tmpl','## Setting the TypoScript language to french:\r\nconfig.language = fr\r\n \r\n \r\n# ***********************************\r\n#  Login form as used in \'content (default)\'\r\n# ***********************************\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.de = Nom d\'utilisateur:\r\n    20.label.lang.de = Mot de passe:\r\n    40.value.lang.de = Login\r\n}\r\n \r\n[usergroup = *]\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.de = Nom d\'utilisateur: <!--###USERNAME###-->\r\n    20 >\r\n    40.value.lang.de = Logout\r\n}\r\n[global]\r\n \r\n \r\n \r\n \r\n# ***********************\r\n#  Search dialog object\r\n# ***********************\r\n \r\ntt_content.search.30.dataArray {\r\n    10.label.lang.de = Chercher:\r\n    20.label.lang.de = dans\r\n    20.valueArray {\r\n      10.label.lang.de = Titre et Mots cls\r\n      20.label.lang.de = Contenu de la page\r\n    }\r\n    40.value.lang.de = Dmarrer la recherche\r\n}\r\n \r\n \r\n \r\n# ***********************\r\n#  Search result page object\r\n# ***********************\r\ntt_content.search.20 {\r\n  layout.10.lang.de = Echelle de recherche: ###RANGELOW###-###RANGEHIGH### de ###TOTAL###\r\n  noResultObj.10.lang.de = La recherche ne donne aucun rsultat!\r\n  next.lang.de = Suivant\r\n  prev.lang.de = Prcdent\r\n}\r\n \r\n \r\n \r\n# ***********************\r\n#  Default Guestbook form\r\n# ***********************\r\nplugin.tt_guest.postform.dataArray {\r\n  10.label.lang.de = Titre:\r\n  20.label.lang.de = Ton commentaire:\r\n  30.label.lang.de = Nom:\r\n  40.label.lang.de = E-mail:\r\n  50.label.lang.de = Site Web:\r\n  60.value.lang.de = S\'inscrire\r\n}\r\n \r\n \r\n# ***********************\r\n#  Default List Board form\r\n# ***********************\r\nplugin.tt_board_list.postform.dataArray {\r\n  10.label.lang.de = Thme:\r\n  20.label.lang.de = Message:\r\n  30.label.lang.de = Nom:\r\n  40.label.lang.de = E-mail:\r\n  50.label.lang.de = Notifier<br />en cas de rponse(en):\r\n  60.value.lang.de = Envoyer la rponse\r\n}\r\nplugin.tt_board_list.postform_newThread.dataArray {\r\n  10.label.lang.de = Thme:\r\n  20.label.lang.de = Message:\r\n  30.label.lang.de = Nom:\r\n  40.label.lang.de = E-mail:\r\n  50.label.lang.de = Notifier<br />en cas de rponse (en):\r\n  60.value.lang.de = Ouvrir la discution\r\n}\r\n\r\n    // \"You must fill in these fields:\"\r\nplugin.tt_board_list.postform.badMess = Vous devez remplir ces champs: \r\nplugin.tt_board_list.postform_newThread.badMess = Vous devez remplir ces champs: \r\n\r\n \r\n# ***********************\r\n#  Default Tree Board form\r\n# ***********************\r\nplugin.tt_board_tree.postform.dataArray {\r\n  10.label.lang.de = Thme:\r\n  20.label.lang.de = Message:\r\n  30.label.lang.de = Nom:\r\n  40.label.lang.de = E-mail:\r\n  50.label.lang.de = Notifier<br />en cas de rponse(en):\r\n  60.value.lang.de = Envoyer la rponse\r\n}\r\nplugin.tt_board_tree.postform_newThread.dataArray {\r\n  10.label.lang.de = Thme:\r\n  20.label.lang.de = Message:\r\n  30.label.lang.de = Nom:\r\n  40.label.lang.de = E-mail:\r\n  50.label.lang.de = Notifier<br />en cas de rponse (en):\r\n  60.value.lang.de = Ouvrir la discution\r\n}\r\n\r\n\r\nplugin.tt_board_tree.postform.badMess = Vous devez remplir ces champs: \r\nplugin.tt_board_tree.postform_newThread.badMess =Vous devez remplir ces champs: \r\n\r\n\r\n\r\n# ***********************\r\n#  Newsletter subscription\r\n# ***********************\r\nplugin.feadmin.dmailsubscription.\r\nplugin.feadmin.dmailsubscription.evalErrors.email {\r\n     // \"Apparently you\'re already registered with this email address!\r\n  uniqueLocal = Apparemment, vous tes dj enregistr avec cette adresse!\r\n     // This is not a correct email address!\r\n  email = Ce n\'est pas un adresse e-mail valide!\r\n}\r\n','This implements french labels on these standard elements \r\n(Translation by Dominique Feyer <dfeyer@techhandflesh.ch>)\r\n\r\nFrom \'content (default)\':\r\n\r\n- login form \r\n- search form\r\n- search result\r\n\r\nFrom \'tt_guest\':\r\n\r\n- submit form.\r\n\r\n\r\nFrom \'tt_board\':\r\n\r\n- submit forms.\r\n\r\n\r\n','');
INSERT INTO `static_template` VALUES (97,0,1054752777,1014636622,'language.no (norwegian) [DEPRECIATED]','','# ***********************\r\n#  Newsletter subscription\r\n# ***********************\r\nplugin.feadmin.dmailsubscription.file.templateFile = media/scripts/fe_admin_dmailsubscrip_dk.tmpl','## Setting the TypoScript language to danish:\r\nconfig.language = no\r\n\r\n\r\n# ***********************************\r\n#  Login form as used in \'content (default)\'\r\n# ***********************************\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.no = Brukernavn:\r\n    20.label.lang.no = Passord:\r\n    40.value.lang.no = Logg inn\r\n}\r\n\r\n[usergroup = *]\r\ntt_content.login.20.dataArray {\r\n    10.label.lang.no = Brukernavn: <!--###USERNAME###--> \r\n    20 >\r\n    40.value.lang.no = Logg ut\r\n}\r\n[global]\r\n\r\n\r\n\r\n\r\n# ***********************\r\n#  Search dialog object\r\n# ***********************\r\n\r\ntt_content.search.30.dataArray {\r\n    10.label.lang.no = Skeord:\r\n    20.label.lang.no = Sk i:\r\n    20.valueArray {\r\n      10.label.lang.no = Overskrift og nkkelord\r\n      20.label.lang.no = Sideinnhold\r\n    }\r\n    40.value.lang.no = Start sk!\r\n}\r\n\r\n\r\n\r\n# ***********************\r\n#  Search result page object\r\n# ***********************\r\ntt_content.search.20 {\r\n  layout.10.lang.no = Skeresultat: ###RANGELOW###-###RANGEHIGH### ud af ###TOTAL###\r\n  noResultObj.10.lang.no = Beklager, sket ditt gav ingen treff!\r\n  next.lang.no = Neste\r\n  prev.lang.no = Forrige\r\n}\r\n\r\n\r\n\r\n# ***********************\r\n#  Default Guestbook form\r\n# ***********************\r\nplugin.tt_guest.postform.dataArray {\r\n  10.label.lang.no = Overskrift:\r\n  20.label.lang.no = Din kommentar:\r\n  30.label.lang.no = Navn:\r\n  40.label.lang.no = E-post:\r\n  50.label.lang.no = Hjemmeside:\r\n  60.value.lang.no = Legg inn meldingen\r\n}\r\n\r\n\r\n# ***********************\r\n#  Default List Board form\r\n# ***********************\r\nplugin.tt_board_list.postform.dataArray {\r\n  10.label.lang.no = Emne:\r\n  20.label.lang.no = Melding:\r\n  30.label.lang.no = Navn:\r\n  40.label.lang.no = E-post:\r\n  50.label.lang.no = Send e-post<br />ved svar: \r\n  60.value.lang.no = Send svar\r\n}\r\nplugin.tt_board_list.postform_newThread.dataArray {\r\n  10.label.lang.no = Emne:\r\n  20.label.lang.no = Melding:\r\n  30.label.lang.no = Navn:\r\n  40.label.lang.no = E-post:\r\n  50.label.lang.no = Send e-post<br />ved svar: \r\n  60.value.lang.no = Lag ny trd\r\n}\r\nplugin.tt_board_list.postform.badMess = Du m fylle ut flgende felt:\r\nplugin.tt_board_list.postform_newThread.badMess = Du m fylle ut flgende felt:\r\n\r\n# ***********************\r\n#  Default Tree Board form\r\n# ***********************\r\nplugin.tt_board_tree.postform.dataArray {\r\n  10.label.lang.no = Emne:\r\n  20.label.lang.no = Melding:\r\n  30.label.lang.no = Navn:\r\n  40.label.lang.no = E-post:\r\n  50.label.lang.no = Send e-post<br />ved svar: \r\n  60.value.lang.no = Send svar\r\n}\r\nplugin.tt_board_tree.postform_newThread.dataArray {\r\n  10.label.lang.no = Emne:\r\n  20.label.lang.no = Melding:\r\n  30.label.lang.no = Navn:\r\n  40.label.lang.no = E-post:\r\n  50.label.lang.no = Send e-post<br />ved svar: \r\n  60.value.lang.no = Lag ny trd\r\n}\r\nplugin.tt_board_tree.postform.badMess = Du m fylle ut flgende felt:\r\nplugin.tt_board_tree.postform_newThread.badMess = Du m fylle ut flgende felt:\r\n\r\n\r\n# ***********************\r\n#  Newsletter subscription\r\n# ***********************\r\nplugin.feadmin.dmailsubscription.evalErrors.email {\r\n  uniqueLocal = Du er tilsynelatende allerede registrert med denne e-post adressen!\r\n  email = Dette er ikke en korrekt e-post adresse!\r\n}\r\n\r\n\r\n','This implements norwegian labels on these standard elements \r\n\r\nFrom \'content (default)\':\r\n\r\n- login form \r\n- search form\r\n- search result\r\n\r\nFrom \'tt_guest\':\r\n\r\n- submit form.\r\n\r\n\r\nFrom \'tt_board\':\r\n\r\n- submit forms.\r\n\r\n\r\n','');

--
-- Table structure for table `static_tsconfig_help`
--

CREATE TABLE `static_tsconfig_help` (
  `uid` int(11) NOT NULL auto_increment,
  `guide` int(11) NOT NULL default '0',
  `md5hash` varchar(32) NOT NULL default '',
  `description` text NOT NULL,
  `obj_string` tinytext NOT NULL,
  `appdata` blob NOT NULL,
  `title` tinytext NOT NULL,
  PRIMARY KEY  (`uid`),
  KEY `guide` (`guide`,`md5hash`)
) TYPE=MyISAM;

--
-- Dumping data for table `static_tsconfig_help`
--

INSERT INTO `static_tsconfig_help` VALUES (2,18,'d680f98abf9d8e4ccad6c7fabf6454f9','','tsref:(script).board_submit','a:1:{s:4:\"rows\";a:9:{i:0;a:6:{s:8:\"property\";s:17:\"sendToMailingList\";s:8:\"datatype\";s:19:\"boolean /properties\";s:11:\"description\";s:611:\"If enabled, a copy of the post is sent to the configured email address. This is useful if you want to integrate the forum with a mailing list.\nOn Typo3.com such a link is established. The reply address is set up in the Qmail MTA to pipe the content into a custom PHP shell-script which parses the email and inserts it into the forum.\n<b>&nbsp;</b>\n<b>Example from Typo3.com:</b>\n&nbsp;\nsendToMailingList=1\nsendToMailingList {\n&nbsp;&nbsp;email = typo3@netfielders.de\n&nbsp;&nbsp;reply = [emailaddress which inserts into db]\n&nbsp;&nbsp;namePrefix = Typo3Forum/\n&nbsp;&nbsp;altSubject = Post from www.typo3.com\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:6:\"notify\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:36:\"Enable email notification in forums.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:11:\"notify_from\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:74:\"&quot;From&quot; email header\n<b>Example:</b>\nTYPO3 forum &lt;no_reply&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:12:\"newReply.msg\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:100:\"Notification message template, first line is subject.\n<b>Example:</b>\nmedia/scripts/board_notify.txt\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:16:\"newReply.didWhat\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:47:\"<b>Example:</b>\nhas just replied to a thread at\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:22:\"newReply.subjectPrefix\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:32:\"<b>Example:</b>\nReply to post at\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:11:\"newThread.*\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:69:\"Same as for newReply.\n<b>Properties:</b>\n.msg/.didWhat/.subjectPrefix\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:5:\"debug\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:69:\"Outputs the mail information directly in browser. For debugging only.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:17:\"clearCacheForPids\";s:8:\"datatype\";s:24:\"<i>list of page id\'s</i>\";s:11:\"description\";s:95:\"This list of page id\'s are cleared in addition to the cache for the page of the item submitted.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (1,18,'78485b1c2bc68c0f13637f5bea21716a','','tsref:(script).boardLib','a:1:{s:4:\"rows\";a:47:{i:0;a:6:{s:8:\"property\";s:12:\"templateFile\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:70:\"The template-file.\nSee example in \'media/scripts/board_template1.tmpl\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:8:\"pid_list\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:127:\"The pid\'s from where to fetch categories, forums and so on. Default is the current page. Accepts multiple pid\'s commaseparated!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:4:\"code\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:807:\"Code to define, what the script does. Case sensitive:\n<b>LIST_CATEGORIES:</b> List the first level of pages as categories and the second level as forums.\n<b>LIST_FORUMS:</b> Lists the first level of pages as forums.\n<b>POSTFORM:</b> Creates a form from which to post to the forum. If the GLOBAL-var &quot;tt_board_uid&quot; is set, the post is a reply to that item, else it\'s a new thread.\n<b>POSTFORM_REPLY:</b> as above, but ONLY if &quot;tt_board_uid&quot; is set for a reply!\n<b>POSTFORM_THREAD:</b> as above, but ONLY if &quot;tt_board_uid&quot; is NOT set, which means &quot;New Thread&quot;.\n<b>default :</b> Shows the content of the current forum (the pid(\'s)). If the GLOBAL-var &quot;tt_board_uid&quot; is set with a uid of a board-item, either this item is shown or the thread. Depends on config.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:11:\"defaultCode\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:105:\"The default code (see above) if the value is empty. By default it\'s not set and a help screen will appear\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:18:\"alternatingLayouts\";s:8:\"datatype\";s:7:\"integer\";s:11:\"description\";s:771:\"Defines number of alternatingLayouts to look for.\nThis script has the ability to alternate between the use of template-subparts. It goes like this:\nIf you define a subpart like &quot;&lt;!--###POST###--&gt; ... &lt;!--###POST###--&gt;&quot; this is used all the time.\nIf you define a similar subpart &quot;&lt;!--###POST_1###--&gt; ... &lt;!--###POST_1###--&gt;&quot; which might show another set of colors, this is used every second time instead of the default! This is because &quot;alternateLayouts&quot; is set to 2\nIf you define a similar subpart &quot;&lt;!--###POST_2###--&gt; ... &lt;!--###POST_2###--&gt;&quot; ... this will be used every third time IF (!) &quot;alternateLayouts&quot; is set to 3. If you do now set it to three, the first two will be used only.\";s:7:\"default\";s:1:\"2\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:12:\"date_stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:73:\"stdWrap for display of dates. Suggestion: date_stdWrap.strftime= %e-%m-%y\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:12:\"time_stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:72:\"stdWrap for display of time. Suggestion: time_stdWrap.strftime= %H:%M:%S\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:11:\"age_stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:60:\"stdWrap for display of ages. Suggestion: age_stdWrap.age = 1\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:16:\"dontParseContent\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:97:\"Normally the content which is output it htmlspecialchar\'ed and nl2br\'ed. This flag prevents that.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:8:\"typolink\";s:8:\"datatype\";s:13:\"-&gt;typolink\";s:11:\"description\";s:27:\"Used to generate the links.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:4:\"tree\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:249:\"If set the items in the threads are accepted to be a tree and not just a list to the same parent. This means that replys, will get the current tt_board_uid as parent no matter what. This is only desirable, if your board has a genuine tree-structure.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:8:\"iconCode\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:85:\"Enables the four icons below. The default without this is the examples you see below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:19:\"iconCode.joinBottom\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:85:\"HTML-Code for a &quot;joinBottom&quot; element in a tree-structure.\nEg &quot;\\-&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:13:\"iconCode.join\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:28:\"as above, Eg. &quot;|-&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:13:\"iconCode.line\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:28:\"as above, Eg. &quot;| &quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:14:\"iconCode.blank\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:33:\"as above, Eg. &quot; &nbsp;&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:15:\"iconCode.thread\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:61:\"The icon for an element with reply-elements (called a thread)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:12:\"iconCode.end\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:64:\"The icon for an element without any replys (and &quot;end&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:9:\"emoticons\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:40:\"Enables emotion icons: :-) &nbsp;:) etc.\";s:7:\"default\";s:1:\"1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:12:\"allowCaching\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:89:\"If set, caching of the each page represented with a tt_board_uid is allowed to be cached.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:20:\"displayCurrentRecord\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:110:\"If set, certain settings are manipulated in order to let the script render a single item - the $cObj-&gt;data.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:5:\"wrap1\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:204:\"Global Wrap 1. This will be splitted into the markers ###GW1B### and ###GW1E###. Don\'t change the input value by the settings, only wrap it in something.\n<b>Example:</b>\nwrap1.wrap = &lt;b&gt; |&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:5:\"wrap2\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:25:\"Global Wrap 2 (see above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:6:\"color1\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC1### marker (Global color 1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:6:\"color2\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC2### marker (Global color 2)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:6:\"color3\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC3### marker (Global color 3)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:47:\"code= POSTFORM, POSTFORM_REPLY, POSTFORM_THREAD\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:8:\"postform\";s:8:\"datatype\";s:14:\"(FORM-cObject)\";s:11:\"description\";s:211:\"Configuration of the form for posting replyes and possiply also new threads.\nNote, that two hidden-fields are forcibly added to the form: &quot;parent&quot; and &quot;pid&quot; (using .dataArray keys 9997-9999)!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:18:\"postform_newThread\";s:8:\"datatype\";s:14:\"(FORM-cObject)\";s:11:\"description\";s:104:\"If set, this is alternative configuration of the form for new threads. If not set, defaults to .postform\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:14:\"moderatorEmail\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:81:\"If set, this email-address will receive a mail whenever a new reply is submitted.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:24:\"moderatorEmail_newThread\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:116:\"If set, this email-address will receive a mail when a new thread is created. If not set, defaults to .moderatorEmail\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:31;a:6:{s:8:\"property\";s:82:\"code= LIST_CATEGORIES:\nThe following properties are all prepended list_categories.\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:32;a:6:{s:8:\"property\";s:8:\"noForums\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:72:\"Disables the view of forums. Default is to display forums in categories.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:33;a:6:{s:8:\"property\";s:19:\"numberOfRecentPosts\";s:8:\"datatype\";s:7:\"integer\";s:11:\"description\";s:111:\"Set the number of recent posts in a forum to display together with the categories list. Zero will display none.\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:34;a:6:{s:8:\"property\";s:238:\"title_stdWrap\nsubtitle_stdWrap\ncount_stdWrap\nforum_title_stdWrap\nforum_description_stdWrap\nforum_posts_stdWrap\nforum_threads_stdWrap\nlast_post_author_stdWrap\npost_title_stdWrap\npost_content_stdWrap\npost_replies_stdWrap\npost_author_stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:31:\"stdWrap properties for markers.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:35;a:6:{s:8:\"property\";s:13:\"cache_timeout\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:63:\"The number of seconds the page is cached. Default is 5 minutes.\";s:7:\"default\";s:3:\"300\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:36;a:6:{s:8:\"property\";s:73:\"code= LIST_FORUMS\nThe following properties are all prepended list_forums.\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:37;a:6:{s:8:\"property\";s:19:\"numberOfRecentPosts\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:34:\"(Same as LIST_CATEGORIES equalent)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:38;a:6:{s:8:\"property\";s:193:\"forum_title_stdWrap\nforum_description_stdWrap\nforum_posts_stdWrap\nforum_threads_stdWrap\nlast_post_author_stdWrap\npost_title_stdWrap\npost_content_stdWrap\npost_replies_stdWrap\npost_author_stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:31:\"stdWrap properties for markers.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:39;a:6:{s:8:\"property\";s:13:\"cache_timeout\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:63:\"The number of seconds the page is cached. Default is 5 minutes.\";s:7:\"default\";s:3:\"300\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:40;a:6:{s:8:\"property\";s:69:\"code= default\nThe following properties are all prepended view_thread.\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:41;a:6:{s:8:\"property\";s:6:\"single\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:294:\"If set, the items are displayed for the selves. Else the whole thread is normally displayed on one page. (This flag should probably be set together with the .tree-flag, if you use it, as this basically turns the board into a tree-like forum instead of a flat board-structure!\n(default is false)\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:42;a:6:{s:8:\"property\";s:125:\"post_thread_code_stdWrap\npost_title_stdWrap\npost_content_stdWrap\npost_replies_stdWrap\npost_author_stdWrap\nforum_title_stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:31:\"stdWrap properties for markers.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:43;a:6:{s:8:\"property\";s:171:\"The following properties are all prepended list_threads or thread_tree.\nthread_tree is config for the thread_tree which shows a list of the elements in the current thread.\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:44;a:6:{s:8:\"property\";s:150:\"post_thread_code_stdWrap\npost_title_stdWrap\npost_content_stdWrap\npost_replies_stdWrap\npost_author_stdWrap\nlast_post_author_stdWrap\nforum_title_stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:31:\"stdWrap properties for markers.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:45;a:6:{s:8:\"property\";s:12:\"thread_limit\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:19:\"Max number of items\";s:7:\"default\";s:2:\"50\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:46;a:6:{s:8:\"property\";s:6:\"&nbsp;\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (247,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:31:{i:0;a:6:{s:8:\"property\";s:12:\"templateFile\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:67:\"The template file, see examples in media/scripts/fe_user_admin.tmpl\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:15:\"templateContent\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:78:\"Alternatively you can set this property directly to the value of the template.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:5:\"table\";s:8:\"datatype\";s:9:\"tablename\";s:11:\"description\";s:285:\"The table to edit.\nNotice: The ultimate lsit of fields allowed to be edited for the table is defined in TCA with the key [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] for each table in question. For an example, see the table definition for fe_users which is a good example.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"defaultCmd\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:86:\"Defines which action should be default (if &amp;cmd= is not set when calling the page)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:17:\"clearCacheOfPages\";s:8:\"datatype\";s:25:\"<i>[list of integers]</i>\";s:11:\"description\";s:114:\"This is a list of page-ids for which to clear the cache on any successfull operation be it EDIT, CREATE og DELETE.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"debug\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:86:\"If set, debug information will be output from fe_adminLib which helps to track errors.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"Actions:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:4:\"edit\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:1793:\"If set, editing is basically allowed.\nBut you need to specify:\n&nbsp;\n<b>.fields </b>(list of fieldnames) which determines the fields allowed for editing. Every field in this list must be found as well in the [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] found in the TCA array which ultimately determines which fields can be edited by the fe_adminLib.\n<b>&nbsp;</b>\n<b>.overrideValues.[fieldname]</b> (value string) defines values for specific fields which will override ANY input from the form. Overriding values happens after the outside values has been parsed by the .parseValues-property of fe_adminLib but before the evaluation by .required and .evalValues below. For example this may be useful if you wish to hide a record which is being edited, because you want to preview it first.\n<b>&nbsp;</b>\n<b>.required </b>(list of fieldnames, subset of .fields) which determines which fields are required to return a true value. The valid fields entered here will have the subpart ###SUB_REQUIRED_FIELD_<i>[fieldname]</i>### removed from the templates if they evaluates to being true and thereby OK. See below for information about this subpart.\n<b>&nbsp;</b>\n<b>.evalValues.[fieldname]</b> (list of eval-codes) defines specific evaluation forms for the individual fiels of the form. See below.\n<b>&nbsp;</b>\n<b>.preview</b> (boolean) will enable the form submitted to be previewed first. This requires a template for preview to be found in the template file. See below for subpart marker names.\n<b>&nbsp;</b>\n<b>.menuLockPid</b> (boolean will force the menu of editable items to be locked to the .pid (edit only)\n<b>&nbsp;</b>\n<b>.userFunc_afterSave </b>(function-name) is called after the record is saved. The content passed is an array with the current (and previous) record in.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:6:\"create\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:416:\"The same as .edit above except where otherwise stated.\nPlus there is these additional properties:\n<b>&nbsp;</b>\n<b>.noSpecialLoginForm </b>(boolean) - if set, fe_adminLib does NOT look for the subpart marker TEMPLATE_CREATE_LOGIN but always for TEMPLATE_CREATE\n<b>&nbsp;</b>\n<b>.defaultValues.[fieldname]</b> (value string); Like .overrideValues but this sets the default values the first time the form is displayed.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:6:\"delete\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:214:\"Whether or not records may be deleted. Still regular authentication (ownership or email authCode) is required. Setting the var &quot;preview&quot; lets you make a delete-preview before actually deleting the record.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:8:\"infomail\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:371:\"Infomails are plaintext mails based on templates found in the template file. They may be used for such as sending a forgotten password to a user, but what goes into the infomail is totally up to your design of the template.\nNormally you may have only a default infomail (infomail.default) for instance for sending the password. But you can use other keys also. See below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:14:\"infomail.[key]\";s:8:\"datatype\";s:38:\"(configuration of infomail properties)\";s:11:\"description\";s:550:\"In order to make fe_adminLib send an infomail, you must specify these vars in your GET vars or HTML-form.\n&nbsp;\n<b>fetch</b> - if integer, it searches for the uid being the value of \'fetch\'. If not, it searches for the email-field (defined by a property of fe_adminLib, see below).\n&nbsp;\n<b>key</b> - points to the infomail.[key] configuration to use\n<b>&nbsp;</b>\n<b>Properties:</b>\n<b>.dontLockPid</b> (boolean) - selects only records from the .pid of fe_adminLib.\n<b>.label </b>(string) - The suffix for the markers, see \'Email Markers\' beneath.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:8:\"setfixed\";s:8:\"datatype\";s:19:\"boolean /properties\";s:11:\"description\";s:2645:\"Allows set-fixed input, probably coming from a link in an infomail or notification mail.\n<b>Syntax: </b>\n&nbsp;\n<b>.[fix</b><b><i>key</i></b><b>].[</b><b><i>fieldname</i></b><b>] = </b><b><i>fieldvalue</i></b><i>&nbsp;</i>- is used to setup a setfixed-link insertable in the infomail by the SYS_SETFIXED_*-markers. See above (setfixed-property of fe_adminLib).\nSpecial fixkey \'DELETE\' is just a boolean.\n&nbsp;\n<b>Concept:</b>\nThe \'setfixed\' concept is best explained by describing a typical scenario - in fact the most common situation of its use:\nImagine you have some users submitting information on your website. But before that information enters the database, you would like to moderate it - simply preview it and then either delete it or approve it. In the \'create\' configuration of fe_adminLib, you set up the hidden field of the record to be overridden to 1. Thus the record is hidden by default. Then you configure a setfixed-fixkey to set the hidden field to 0. This set up generates a list of parameters for use in an URL and those parameters are finally inserted by a corresponding marker in the email template. The link includes all necessary authentication to perform the change of values and thus a single click on that link is enough to change the field values. So this will - by a single click of a link in a notification mail sent to an admin - enable the record! Or of course a similar link with a cmd=delete link will delete it...\nThere is a special &quot;fieldname&quot; you can use, which is \'_FIELDLIST&quot; and that lets you specify a list of fields in the record to base the auth-code on. If nothing is specifyed the md5-hash is based on the whole record which means that any changes will disable the setfixed link. If on the other hand, you set _FIELDLIST = uid,pid then that record will be editable as long as the uid and pid values are intact.\n<b>Example:</b>\nThis is a common configuration of the email-properties with a simple setfixed setting:\n&nbsp;&nbsp;email.from = kasper@typo3.com\n&nbsp;&nbsp;email.fromName = Kasper Sk&aring;rh&oslash;j\n&nbsp;&nbsp;email.admin = kasper@typo3.com\n&nbsp;&nbsp;setfixed.approve {\n&nbsp;&nbsp;setfixed.DELETE = 1\n&nbsp;\nNow, if you insert this marker in your email template\n&nbsp;\n&nbsp;&nbsp;###SYS_SETFIXED_approve###\n&nbsp;\nif will get substituted with something like these parameters:\n&nbsp;\n&amp;cmd=setfixed&amp;rU=9&amp;fD[hidden]=0&amp;aC=5c403d90\n&nbsp;\nNow, all you need is to point that to the correct url (where fe_adminLib is invoked!), eg:\n&nbsp;\n###THIS_URL######FORM_URL######SYS_SETFIXED_approve###\n&nbsp;\nand for deletion:\n&nbsp;\n...###SYS_SETFIXED_DELETE###\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:6:\"Others\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:14:\"authcodeFields\";s:8:\"datatype\";s:23:\"<i>[list of fields]</i>\";s:11:\"description\";s:1287:\"Comma separated list of fields to base the authCode generation on. Basically this list would include &quot;uid&quot; only in most cases. If the list includes more fields, you should be aware that the authCode will change when the value of that field changes. And then the user will have to re-send an email to himself with a new code.\n&nbsp;\n<b>.addKey </b>(string) adds the string to the md5-hash of the authCode. Just enter any random string here. Point is that people from outside doesn\'t know this code and therefore are not able to reconstruct the md5-hash solely based on the uid\n&nbsp;\n<b>.addDate</b> (date-config) You can use this to make the code time-disabled. Say if you enter &quot;d-m-Y&quot; here as value, the code will work until midnight and then a new code will be valid.\n&nbsp;\n<b>.codeLength</b> (int) Defines how long the authentication code should be. Default is 8 characters.\nIn any case TYPO3_CONF_VARS[SYS][encryptionKey] is prepended.\n&nbsp;\n<b>Advice:</b>\nIf you want to generate authCodes compatible with the standard authCodes (used by the direct mailer by t3lib_div::stdAuthCode()), please set TYPO3_CONF_VARS[SYS][encryptionKey] to a unique and secret key (like you should in any case) and add &quot;uid&quot; as authcodeField ONLY. This is secure enough.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:5:\"email\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:593:\"<b>.from </b>(string, email) Defines the sender email address of mails sent out\n&nbsp;\n<b>.fromName </b>(string) Defines the name of the sender. If set, this will be used on the form NAME &lt;EMAIL&gt;\n&nbsp;\n<b>.admin &nbsp;Email address of the administrator which is notified of changes.</b>\n&nbsp;\n<b>.field </b>(string/integer) Defines the fieldname of the record where the email address to send to is found. If the field content happens to be an integer, this is assumed to be the uid of the fe_user owning the record and the email address of that user is fetched for the purpose instead.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:3:\"pid\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:42:\"The pid in which to store/get the records.\";s:7:\"default\";s:12:\"Current page\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:14:\"fe_userOwnSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:337:\"If set, fe_users created by this module has their fe_cruser_id-field set to their own uid which means they \'own\' their own record and can thus edit their own data.\nAll other tables which has a fe_cruser_id field configured in the \'ctrl\' section of their $TCA-configuration will automatically get this field set to the current fe_user id.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:15:\"fe_userEditSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:102:\"If set, fe_users - regardless of whether they own themselves or not - will be allowed to edit himself.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:13:\"allowedGroups\";s:8:\"datatype\";s:18:\"[list of integers]\";s:11:\"description\";s:141:\"List of fe_groups uid numbers which are allowed to edit the records through this form. Normally only the owner fe_user is allowed to do that.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:8:\"evalFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:261:\"Function by which you can manipulate the dataArray before it\'s saved.\nThe dataArray is passed to the function as $content and MUST be returned again from the function.\nThe property &quot;parentObj&quot; is a hardcoded reference to the fe_adminLib object.\n&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:8:\"no_cache\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:63:\"If set, &amp;no_cache=1 is sent in the links of the fe_adminLib\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:19:\"parseValues.[field]\";s:8:\"datatype\";s:20:\"[list of parseCodes]\";s:11:\"description\";s:1407:\"<b>ParseCodes:</b>\n<b>int </b>- returns the integer value of the input\n<b>lower</b> - returns lowercase version of the input\n<b>upper </b>- returns uppercase version of the input\n<b>nospace</b> - strips all space\n<b>alpha, num, alphanum, alphanum_x</b> &nbsp;- only alphabetic (a-z) and/or numeric chars. alphanum_x also allows _ and -\n<b>trim </b>- trims whitespace in the ends of the string\n<b>setEmptyIfAbsent </b>- will make sure the field is set to empty if the value is not submitted. This ensures a field to be updated an is handy with checkboxes\n<b>random[x]</b> - Returns a random number between 0 and x\n<b>files[semicolon-list(!) of extensions, none=all][maxsize in kb, none=no limit]</b> - Defining the field to hold files. See below for details!\n<b>multiple </b>- Set this, if the input comes from a multiple-selector box (remember to add ...[] to the fieldname so the values come in an array!)\n<b>checkArray</b> - Set this, if you want several checkboxes to set bits in a single field. In that case you must prepend every checkbox with [x] where x is the bitnumber to set starting with zero. The default values of the checkbox form elements must be false.\n<b>uniqueHashInt[semicolon-list(!) of other fields]</b> - This makes a unique hash (32 bit integer) of the content in the specified fields. The values of those fields are first converted to lowercase and only alphanum chars are preserved.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:20:\"userFunc_updateArray\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:148:\"Points to a user function which will have the value-array passed to it before the value array is used to construct the update-JavaScript statements.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:29:\"evalErrors.[field].[evalCode]\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:162:\"This lets you specify the error messages inserted in the ###EVAL_ERROR_FIELD_[fieldname]### markers upon an evaluation error.\nSee description of evaluation below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:22:\"cObjects.[marker_name]\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:365:\"This is cObjects you can insert by markers in the template.\n&nbsp;\n<b>Example:</b>\nSay, you set up a cObject like this:\n&nbsp;\ncObject.myHeader = TEXT\ncObject.myHeader.value = This is my header\n&nbsp;\nthen you can include this cObject in most of the templates through a marker named ###CE_myHeader### or ###PCE_myHeader### (see below for details on the difference).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:5:\"wrap1\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:211:\"Global Wrap 1. This will be splitted into the markers ###GW1B### and ###GW1E###. Don\'t change the input value by the settings, only wrap it in something.\n&nbsp;\n<b>Example:</b>\nwrap1.wrap = &lt;b&gt; |&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:5:\"wrap2\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:25:\"Global Wrap 2 (see above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:6:\"color1\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC1### marker (Global color 1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:6:\"color2\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC2### marker (Global color 2)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:6:\"color3\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC3### marker (Global color 3)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (246,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:31:{i:0;a:6:{s:8:\"property\";s:12:\"templateFile\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:67:\"The template file, see examples in media/scripts/fe_user_admin.tmpl\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:15:\"templateContent\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:78:\"Alternatively you can set this property directly to the value of the template.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:5:\"table\";s:8:\"datatype\";s:9:\"tablename\";s:11:\"description\";s:285:\"The table to edit.\nNotice: The ultimate lsit of fields allowed to be edited for the table is defined in TCA with the key [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] for each table in question. For an example, see the table definition for fe_users which is a good example.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"defaultCmd\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:86:\"Defines which action should be default (if &amp;cmd= is not set when calling the page)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:17:\"clearCacheOfPages\";s:8:\"datatype\";s:25:\"<i>[list of integers]</i>\";s:11:\"description\";s:114:\"This is a list of page-ids for which to clear the cache on any successfull operation be it EDIT, CREATE og DELETE.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"debug\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:86:\"If set, debug information will be output from fe_adminLib which helps to track errors.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"Actions:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:4:\"edit\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:1793:\"If set, editing is basically allowed.\nBut you need to specify:\n&nbsp;\n<b>.fields </b>(list of fieldnames) which determines the fields allowed for editing. Every field in this list must be found as well in the [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] found in the TCA array which ultimately determines which fields can be edited by the fe_adminLib.\n<b>&nbsp;</b>\n<b>.overrideValues.[fieldname]</b> (value string) defines values for specific fields which will override ANY input from the form. Overriding values happens after the outside values has been parsed by the .parseValues-property of fe_adminLib but before the evaluation by .required and .evalValues below. For example this may be useful if you wish to hide a record which is being edited, because you want to preview it first.\n<b>&nbsp;</b>\n<b>.required </b>(list of fieldnames, subset of .fields) which determines which fields are required to return a true value. The valid fields entered here will have the subpart ###SUB_REQUIRED_FIELD_<i>[fieldname]</i>### removed from the templates if they evaluates to being true and thereby OK. See below for information about this subpart.\n<b>&nbsp;</b>\n<b>.evalValues.[fieldname]</b> (list of eval-codes) defines specific evaluation forms for the individual fiels of the form. See below.\n<b>&nbsp;</b>\n<b>.preview</b> (boolean) will enable the form submitted to be previewed first. This requires a template for preview to be found in the template file. See below for subpart marker names.\n<b>&nbsp;</b>\n<b>.menuLockPid</b> (boolean will force the menu of editable items to be locked to the .pid (edit only)\n<b>&nbsp;</b>\n<b>.userFunc_afterSave </b>(function-name) is called after the record is saved. The content passed is an array with the current (and previous) record in.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:6:\"create\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:416:\"The same as .edit above except where otherwise stated.\nPlus there is these additional properties:\n<b>&nbsp;</b>\n<b>.noSpecialLoginForm </b>(boolean) - if set, fe_adminLib does NOT look for the subpart marker TEMPLATE_CREATE_LOGIN but always for TEMPLATE_CREATE\n<b>&nbsp;</b>\n<b>.defaultValues.[fieldname]</b> (value string); Like .overrideValues but this sets the default values the first time the form is displayed.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:6:\"delete\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:214:\"Whether or not records may be deleted. Still regular authentication (ownership or email authCode) is required. Setting the var &quot;preview&quot; lets you make a delete-preview before actually deleting the record.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:8:\"infomail\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:371:\"Infomails are plaintext mails based on templates found in the template file. They may be used for such as sending a forgotten password to a user, but what goes into the infomail is totally up to your design of the template.\nNormally you may have only a default infomail (infomail.default) for instance for sending the password. But you can use other keys also. See below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:14:\"infomail.[key]\";s:8:\"datatype\";s:38:\"(configuration of infomail properties)\";s:11:\"description\";s:550:\"In order to make fe_adminLib send an infomail, you must specify these vars in your GET vars or HTML-form.\n&nbsp;\n<b>fetch</b> - if integer, it searches for the uid being the value of \'fetch\'. If not, it searches for the email-field (defined by a property of fe_adminLib, see below).\n&nbsp;\n<b>key</b> - points to the infomail.[key] configuration to use\n<b>&nbsp;</b>\n<b>Properties:</b>\n<b>.dontLockPid</b> (boolean) - selects only records from the .pid of fe_adminLib.\n<b>.label </b>(string) - The suffix for the markers, see \'Email Markers\' beneath.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:8:\"setfixed\";s:8:\"datatype\";s:19:\"boolean /properties\";s:11:\"description\";s:2645:\"Allows set-fixed input, probably coming from a link in an infomail or notification mail.\n<b>Syntax: </b>\n&nbsp;\n<b>.[fix</b><b><i>key</i></b><b>].[</b><b><i>fieldname</i></b><b>] = </b><b><i>fieldvalue</i></b><i>&nbsp;</i>- is used to setup a setfixed-link insertable in the infomail by the SYS_SETFIXED_*-markers. See above (setfixed-property of fe_adminLib).\nSpecial fixkey \'DELETE\' is just a boolean.\n&nbsp;\n<b>Concept:</b>\nThe \'setfixed\' concept is best explained by describing a typical scenario - in fact the most common situation of its use:\nImagine you have some users submitting information on your website. But before that information enters the database, you would like to moderate it - simply preview it and then either delete it or approve it. In the \'create\' configuration of fe_adminLib, you set up the hidden field of the record to be overridden to 1. Thus the record is hidden by default. Then you configure a setfixed-fixkey to set the hidden field to 0. This set up generates a list of parameters for use in an URL and those parameters are finally inserted by a corresponding marker in the email template. The link includes all necessary authentication to perform the change of values and thus a single click on that link is enough to change the field values. So this will - by a single click of a link in a notification mail sent to an admin - enable the record! Or of course a similar link with a cmd=delete link will delete it...\nThere is a special &quot;fieldname&quot; you can use, which is \'_FIELDLIST&quot; and that lets you specify a list of fields in the record to base the auth-code on. If nothing is specifyed the md5-hash is based on the whole record which means that any changes will disable the setfixed link. If on the other hand, you set _FIELDLIST = uid,pid then that record will be editable as long as the uid and pid values are intact.\n<b>Example:</b>\nThis is a common configuration of the email-properties with a simple setfixed setting:\n&nbsp;&nbsp;email.from = kasper@typo3.com\n&nbsp;&nbsp;email.fromName = Kasper Sk&aring;rh&oslash;j\n&nbsp;&nbsp;email.admin = kasper@typo3.com\n&nbsp;&nbsp;setfixed.approve {\n&nbsp;&nbsp;setfixed.DELETE = 1\n&nbsp;\nNow, if you insert this marker in your email template\n&nbsp;\n&nbsp;&nbsp;###SYS_SETFIXED_approve###\n&nbsp;\nif will get substituted with something like these parameters:\n&nbsp;\n&amp;cmd=setfixed&amp;rU=9&amp;fD[hidden]=0&amp;aC=5c403d90\n&nbsp;\nNow, all you need is to point that to the correct url (where fe_adminLib is invoked!), eg:\n&nbsp;\n###THIS_URL######FORM_URL######SYS_SETFIXED_approve###\n&nbsp;\nand for deletion:\n&nbsp;\n...###SYS_SETFIXED_DELETE###\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:6:\"Others\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:14:\"authcodeFields\";s:8:\"datatype\";s:23:\"<i>[list of fields]</i>\";s:11:\"description\";s:1287:\"Comma separated list of fields to base the authCode generation on. Basically this list would include &quot;uid&quot; only in most cases. If the list includes more fields, you should be aware that the authCode will change when the value of that field changes. And then the user will have to re-send an email to himself with a new code.\n&nbsp;\n<b>.addKey </b>(string) adds the string to the md5-hash of the authCode. Just enter any random string here. Point is that people from outside doesn\'t know this code and therefore are not able to reconstruct the md5-hash solely based on the uid\n&nbsp;\n<b>.addDate</b> (date-config) You can use this to make the code time-disabled. Say if you enter &quot;d-m-Y&quot; here as value, the code will work until midnight and then a new code will be valid.\n&nbsp;\n<b>.codeLength</b> (int) Defines how long the authentication code should be. Default is 8 characters.\nIn any case TYPO3_CONF_VARS[SYS][encryptionKey] is prepended.\n&nbsp;\n<b>Advice:</b>\nIf you want to generate authCodes compatible with the standard authCodes (used by the direct mailer by t3lib_div::stdAuthCode()), please set TYPO3_CONF_VARS[SYS][encryptionKey] to a unique and secret key (like you should in any case) and add &quot;uid&quot; as authcodeField ONLY. This is secure enough.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:5:\"email\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:593:\"<b>.from </b>(string, email) Defines the sender email address of mails sent out\n&nbsp;\n<b>.fromName </b>(string) Defines the name of the sender. If set, this will be used on the form NAME &lt;EMAIL&gt;\n&nbsp;\n<b>.admin &nbsp;Email address of the administrator which is notified of changes.</b>\n&nbsp;\n<b>.field </b>(string/integer) Defines the fieldname of the record where the email address to send to is found. If the field content happens to be an integer, this is assumed to be the uid of the fe_user owning the record and the email address of that user is fetched for the purpose instead.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:3:\"pid\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:42:\"The pid in which to store/get the records.\";s:7:\"default\";s:12:\"Current page\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:14:\"fe_userOwnSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:337:\"If set, fe_users created by this module has their fe_cruser_id-field set to their own uid which means they \'own\' their own record and can thus edit their own data.\nAll other tables which has a fe_cruser_id field configured in the \'ctrl\' section of their $TCA-configuration will automatically get this field set to the current fe_user id.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:15:\"fe_userEditSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:102:\"If set, fe_users - regardless of whether they own themselves or not - will be allowed to edit himself.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:13:\"allowedGroups\";s:8:\"datatype\";s:18:\"[list of integers]\";s:11:\"description\";s:141:\"List of fe_groups uid numbers which are allowed to edit the records through this form. Normally only the owner fe_user is allowed to do that.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:8:\"evalFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:261:\"Function by which you can manipulate the dataArray before it\'s saved.\nThe dataArray is passed to the function as $content and MUST be returned again from the function.\nThe property &quot;parentObj&quot; is a hardcoded reference to the fe_adminLib object.\n&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:8:\"no_cache\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:63:\"If set, &amp;no_cache=1 is sent in the links of the fe_adminLib\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:19:\"parseValues.[field]\";s:8:\"datatype\";s:20:\"[list of parseCodes]\";s:11:\"description\";s:1407:\"<b>ParseCodes:</b>\n<b>int </b>- returns the integer value of the input\n<b>lower</b> - returns lowercase version of the input\n<b>upper </b>- returns uppercase version of the input\n<b>nospace</b> - strips all space\n<b>alpha, num, alphanum, alphanum_x</b> &nbsp;- only alphabetic (a-z) and/or numeric chars. alphanum_x also allows _ and -\n<b>trim </b>- trims whitespace in the ends of the string\n<b>setEmptyIfAbsent </b>- will make sure the field is set to empty if the value is not submitted. This ensures a field to be updated an is handy with checkboxes\n<b>random[x]</b> - Returns a random number between 0 and x\n<b>files[semicolon-list(!) of extensions, none=all][maxsize in kb, none=no limit]</b> - Defining the field to hold files. See below for details!\n<b>multiple </b>- Set this, if the input comes from a multiple-selector box (remember to add ...[] to the fieldname so the values come in an array!)\n<b>checkArray</b> - Set this, if you want several checkboxes to set bits in a single field. In that case you must prepend every checkbox with [x] where x is the bitnumber to set starting with zero. The default values of the checkbox form elements must be false.\n<b>uniqueHashInt[semicolon-list(!) of other fields]</b> - This makes a unique hash (32 bit integer) of the content in the specified fields. The values of those fields are first converted to lowercase and only alphanum chars are preserved.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:20:\"userFunc_updateArray\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:148:\"Points to a user function which will have the value-array passed to it before the value array is used to construct the update-JavaScript statements.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:29:\"evalErrors.[field].[evalCode]\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:162:\"This lets you specify the error messages inserted in the ###EVAL_ERROR_FIELD_[fieldname]### markers upon an evaluation error.\nSee description of evaluation below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:22:\"cObjects.[marker_name]\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:365:\"This is cObjects you can insert by markers in the template.\n&nbsp;\n<b>Example:</b>\nSay, you set up a cObject like this:\n&nbsp;\ncObject.myHeader = TEXT\ncObject.myHeader.value = This is my header\n&nbsp;\nthen you can include this cObject in most of the templates through a marker named ###CE_myHeader### or ###PCE_myHeader### (see below for details on the difference).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:5:\"wrap1\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:211:\"Global Wrap 1. This will be splitted into the markers ###GW1B### and ###GW1E###. Don\'t change the input value by the settings, only wrap it in something.\n&nbsp;\n<b>Example:</b>\nwrap1.wrap = &lt;b&gt; |&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:5:\"wrap2\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:25:\"Global Wrap 2 (see above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:6:\"color1\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC1### marker (Global color 1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:6:\"color2\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC2### marker (Global color 2)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:6:\"color3\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC3### marker (Global color 3)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (245,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:31:{i:0;a:6:{s:8:\"property\";s:12:\"templateFile\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:67:\"The template file, see examples in media/scripts/fe_user_admin.tmpl\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:15:\"templateContent\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:78:\"Alternatively you can set this property directly to the value of the template.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:5:\"table\";s:8:\"datatype\";s:9:\"tablename\";s:11:\"description\";s:285:\"The table to edit.\nNotice: The ultimate lsit of fields allowed to be edited for the table is defined in TCA with the key [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] for each table in question. For an example, see the table definition for fe_users which is a good example.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"defaultCmd\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:86:\"Defines which action should be default (if &amp;cmd= is not set when calling the page)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:17:\"clearCacheOfPages\";s:8:\"datatype\";s:25:\"<i>[list of integers]</i>\";s:11:\"description\";s:114:\"This is a list of page-ids for which to clear the cache on any successfull operation be it EDIT, CREATE og DELETE.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"debug\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:86:\"If set, debug information will be output from fe_adminLib which helps to track errors.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"Actions:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:4:\"edit\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:1793:\"If set, editing is basically allowed.\nBut you need to specify:\n&nbsp;\n<b>.fields </b>(list of fieldnames) which determines the fields allowed for editing. Every field in this list must be found as well in the [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] found in the TCA array which ultimately determines which fields can be edited by the fe_adminLib.\n<b>&nbsp;</b>\n<b>.overrideValues.[fieldname]</b> (value string) defines values for specific fields which will override ANY input from the form. Overriding values happens after the outside values has been parsed by the .parseValues-property of fe_adminLib but before the evaluation by .required and .evalValues below. For example this may be useful if you wish to hide a record which is being edited, because you want to preview it first.\n<b>&nbsp;</b>\n<b>.required </b>(list of fieldnames, subset of .fields) which determines which fields are required to return a true value. The valid fields entered here will have the subpart ###SUB_REQUIRED_FIELD_<i>[fieldname]</i>### removed from the templates if they evaluates to being true and thereby OK. See below for information about this subpart.\n<b>&nbsp;</b>\n<b>.evalValues.[fieldname]</b> (list of eval-codes) defines specific evaluation forms for the individual fiels of the form. See below.\n<b>&nbsp;</b>\n<b>.preview</b> (boolean) will enable the form submitted to be previewed first. This requires a template for preview to be found in the template file. See below for subpart marker names.\n<b>&nbsp;</b>\n<b>.menuLockPid</b> (boolean will force the menu of editable items to be locked to the .pid (edit only)\n<b>&nbsp;</b>\n<b>.userFunc_afterSave </b>(function-name) is called after the record is saved. The content passed is an array with the current (and previous) record in.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:6:\"create\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:416:\"The same as .edit above except where otherwise stated.\nPlus there is these additional properties:\n<b>&nbsp;</b>\n<b>.noSpecialLoginForm </b>(boolean) - if set, fe_adminLib does NOT look for the subpart marker TEMPLATE_CREATE_LOGIN but always for TEMPLATE_CREATE\n<b>&nbsp;</b>\n<b>.defaultValues.[fieldname]</b> (value string); Like .overrideValues but this sets the default values the first time the form is displayed.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:6:\"delete\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:214:\"Whether or not records may be deleted. Still regular authentication (ownership or email authCode) is required. Setting the var &quot;preview&quot; lets you make a delete-preview before actually deleting the record.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:8:\"infomail\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:371:\"Infomails are plaintext mails based on templates found in the template file. They may be used for such as sending a forgotten password to a user, but what goes into the infomail is totally up to your design of the template.\nNormally you may have only a default infomail (infomail.default) for instance for sending the password. But you can use other keys also. See below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:14:\"infomail.[key]\";s:8:\"datatype\";s:38:\"(configuration of infomail properties)\";s:11:\"description\";s:550:\"In order to make fe_adminLib send an infomail, you must specify these vars in your GET vars or HTML-form.\n&nbsp;\n<b>fetch</b> - if integer, it searches for the uid being the value of \'fetch\'. If not, it searches for the email-field (defined by a property of fe_adminLib, see below).\n&nbsp;\n<b>key</b> - points to the infomail.[key] configuration to use\n<b>&nbsp;</b>\n<b>Properties:</b>\n<b>.dontLockPid</b> (boolean) - selects only records from the .pid of fe_adminLib.\n<b>.label </b>(string) - The suffix for the markers, see \'Email Markers\' beneath.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:8:\"setfixed\";s:8:\"datatype\";s:19:\"boolean /properties\";s:11:\"description\";s:2645:\"Allows set-fixed input, probably coming from a link in an infomail or notification mail.\n<b>Syntax: </b>\n&nbsp;\n<b>.[fix</b><b><i>key</i></b><b>].[</b><b><i>fieldname</i></b><b>] = </b><b><i>fieldvalue</i></b><i>&nbsp;</i>- is used to setup a setfixed-link insertable in the infomail by the SYS_SETFIXED_*-markers. See above (setfixed-property of fe_adminLib).\nSpecial fixkey \'DELETE\' is just a boolean.\n&nbsp;\n<b>Concept:</b>\nThe \'setfixed\' concept is best explained by describing a typical scenario - in fact the most common situation of its use:\nImagine you have some users submitting information on your website. But before that information enters the database, you would like to moderate it - simply preview it and then either delete it or approve it. In the \'create\' configuration of fe_adminLib, you set up the hidden field of the record to be overridden to 1. Thus the record is hidden by default. Then you configure a setfixed-fixkey to set the hidden field to 0. This set up generates a list of parameters for use in an URL and those parameters are finally inserted by a corresponding marker in the email template. The link includes all necessary authentication to perform the change of values and thus a single click on that link is enough to change the field values. So this will - by a single click of a link in a notification mail sent to an admin - enable the record! Or of course a similar link with a cmd=delete link will delete it...\nThere is a special &quot;fieldname&quot; you can use, which is \'_FIELDLIST&quot; and that lets you specify a list of fields in the record to base the auth-code on. If nothing is specifyed the md5-hash is based on the whole record which means that any changes will disable the setfixed link. If on the other hand, you set _FIELDLIST = uid,pid then that record will be editable as long as the uid and pid values are intact.\n<b>Example:</b>\nThis is a common configuration of the email-properties with a simple setfixed setting:\n&nbsp;&nbsp;email.from = kasper@typo3.com\n&nbsp;&nbsp;email.fromName = Kasper Sk&aring;rh&oslash;j\n&nbsp;&nbsp;email.admin = kasper@typo3.com\n&nbsp;&nbsp;setfixed.approve {\n&nbsp;&nbsp;setfixed.DELETE = 1\n&nbsp;\nNow, if you insert this marker in your email template\n&nbsp;\n&nbsp;&nbsp;###SYS_SETFIXED_approve###\n&nbsp;\nif will get substituted with something like these parameters:\n&nbsp;\n&amp;cmd=setfixed&amp;rU=9&amp;fD[hidden]=0&amp;aC=5c403d90\n&nbsp;\nNow, all you need is to point that to the correct url (where fe_adminLib is invoked!), eg:\n&nbsp;\n###THIS_URL######FORM_URL######SYS_SETFIXED_approve###\n&nbsp;\nand for deletion:\n&nbsp;\n...###SYS_SETFIXED_DELETE###\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:6:\"Others\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:14:\"authcodeFields\";s:8:\"datatype\";s:23:\"<i>[list of fields]</i>\";s:11:\"description\";s:1287:\"Comma separated list of fields to base the authCode generation on. Basically this list would include &quot;uid&quot; only in most cases. If the list includes more fields, you should be aware that the authCode will change when the value of that field changes. And then the user will have to re-send an email to himself with a new code.\n&nbsp;\n<b>.addKey </b>(string) adds the string to the md5-hash of the authCode. Just enter any random string here. Point is that people from outside doesn\'t know this code and therefore are not able to reconstruct the md5-hash solely based on the uid\n&nbsp;\n<b>.addDate</b> (date-config) You can use this to make the code time-disabled. Say if you enter &quot;d-m-Y&quot; here as value, the code will work until midnight and then a new code will be valid.\n&nbsp;\n<b>.codeLength</b> (int) Defines how long the authentication code should be. Default is 8 characters.\nIn any case TYPO3_CONF_VARS[SYS][encryptionKey] is prepended.\n&nbsp;\n<b>Advice:</b>\nIf you want to generate authCodes compatible with the standard authCodes (used by the direct mailer by t3lib_div::stdAuthCode()), please set TYPO3_CONF_VARS[SYS][encryptionKey] to a unique and secret key (like you should in any case) and add &quot;uid&quot; as authcodeField ONLY. This is secure enough.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:5:\"email\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:593:\"<b>.from </b>(string, email) Defines the sender email address of mails sent out\n&nbsp;\n<b>.fromName </b>(string) Defines the name of the sender. If set, this will be used on the form NAME &lt;EMAIL&gt;\n&nbsp;\n<b>.admin &nbsp;Email address of the administrator which is notified of changes.</b>\n&nbsp;\n<b>.field </b>(string/integer) Defines the fieldname of the record where the email address to send to is found. If the field content happens to be an integer, this is assumed to be the uid of the fe_user owning the record and the email address of that user is fetched for the purpose instead.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:3:\"pid\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:42:\"The pid in which to store/get the records.\";s:7:\"default\";s:12:\"Current page\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:14:\"fe_userOwnSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:337:\"If set, fe_users created by this module has their fe_cruser_id-field set to their own uid which means they \'own\' their own record and can thus edit their own data.\nAll other tables which has a fe_cruser_id field configured in the \'ctrl\' section of their $TCA-configuration will automatically get this field set to the current fe_user id.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:15:\"fe_userEditSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:102:\"If set, fe_users - regardless of whether they own themselves or not - will be allowed to edit himself.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:13:\"allowedGroups\";s:8:\"datatype\";s:18:\"[list of integers]\";s:11:\"description\";s:141:\"List of fe_groups uid numbers which are allowed to edit the records through this form. Normally only the owner fe_user is allowed to do that.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:8:\"evalFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:261:\"Function by which you can manipulate the dataArray before it\'s saved.\nThe dataArray is passed to the function as $content and MUST be returned again from the function.\nThe property &quot;parentObj&quot; is a hardcoded reference to the fe_adminLib object.\n&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:8:\"no_cache\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:63:\"If set, &amp;no_cache=1 is sent in the links of the fe_adminLib\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:19:\"parseValues.[field]\";s:8:\"datatype\";s:20:\"[list of parseCodes]\";s:11:\"description\";s:1407:\"<b>ParseCodes:</b>\n<b>int </b>- returns the integer value of the input\n<b>lower</b> - returns lowercase version of the input\n<b>upper </b>- returns uppercase version of the input\n<b>nospace</b> - strips all space\n<b>alpha, num, alphanum, alphanum_x</b> &nbsp;- only alphabetic (a-z) and/or numeric chars. alphanum_x also allows _ and -\n<b>trim </b>- trims whitespace in the ends of the string\n<b>setEmptyIfAbsent </b>- will make sure the field is set to empty if the value is not submitted. This ensures a field to be updated an is handy with checkboxes\n<b>random[x]</b> - Returns a random number between 0 and x\n<b>files[semicolon-list(!) of extensions, none=all][maxsize in kb, none=no limit]</b> - Defining the field to hold files. See below for details!\n<b>multiple </b>- Set this, if the input comes from a multiple-selector box (remember to add ...[] to the fieldname so the values come in an array!)\n<b>checkArray</b> - Set this, if you want several checkboxes to set bits in a single field. In that case you must prepend every checkbox with [x] where x is the bitnumber to set starting with zero. The default values of the checkbox form elements must be false.\n<b>uniqueHashInt[semicolon-list(!) of other fields]</b> - This makes a unique hash (32 bit integer) of the content in the specified fields. The values of those fields are first converted to lowercase and only alphanum chars are preserved.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:20:\"userFunc_updateArray\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:148:\"Points to a user function which will have the value-array passed to it before the value array is used to construct the update-JavaScript statements.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:29:\"evalErrors.[field].[evalCode]\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:162:\"This lets you specify the error messages inserted in the ###EVAL_ERROR_FIELD_[fieldname]### markers upon an evaluation error.\nSee description of evaluation below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:22:\"cObjects.[marker_name]\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:365:\"This is cObjects you can insert by markers in the template.\n&nbsp;\n<b>Example:</b>\nSay, you set up a cObject like this:\n&nbsp;\ncObject.myHeader = TEXT\ncObject.myHeader.value = This is my header\n&nbsp;\nthen you can include this cObject in most of the templates through a marker named ###CE_myHeader### or ###PCE_myHeader### (see below for details on the difference).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:5:\"wrap1\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:211:\"Global Wrap 1. This will be splitted into the markers ###GW1B### and ###GW1E###. Don\'t change the input value by the settings, only wrap it in something.\n&nbsp;\n<b>Example:</b>\nwrap1.wrap = &lt;b&gt; |&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:5:\"wrap2\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:25:\"Global Wrap 2 (see above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:6:\"color1\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC1### marker (Global color 1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:6:\"color2\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC2### marker (Global color 2)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:6:\"color3\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC3### marker (Global color 3)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (155,270,'c464b6b329b8ac88da1830fe24282c53','','alues are strings an a match happens if one of these strings is the first part of the system-identification.','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (204,270,'735744d82b01f1ae8ee357b35a445a18','','tsref:(cObject).HRULER','a:1:{s:4:\"rows\";a:5:{i:0;a:6:{s:8:\"property\";s:13:\"lineThickness\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:11:\"Range: 1-50\";s:7:\"default\";s:1:\"1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:9:\"lineColor\";s:8:\"datatype\";s:10:\"HTML-color\";s:11:\"description\";s:23:\"The color of the ruler.\";s:7:\"default\";s:5:\"black\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:9:\"spaceLeft\";s:8:\"datatype\";s:6:\"pixels\";s:11:\"description\";s:35:\"space before the line (to the left)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"spaceRight\";s:8:\"datatype\";s:6:\"pixels\";s:11:\"description\";s:35:\"space after the line (to the right)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (205,270,'99c88493b5fbff11087e84f8b0caf05e','','tsref:(cObject).IMGTEXT','a:1:{s:4:\"rows\";a:35:{i:0;a:6:{s:8:\"property\";s:4:\"text\";s:8:\"datatype\";s:20:\"-&gt;CARRAY /stdWrap\";s:11:\"description\";s:82:\"Use this to import / generate the content, that should flow around the imageblock.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:7:\"textPos\";s:8:\"datatype\";s:13:\"int / stdWrap\";s:11:\"description\";s:313:\"Textposition:\nbit[0-2]: 000 = centre, 001 = right, 010 = left\nbit[3-5]: 000 = over, 001 = under, 010 text\n&nbsp;\n0 - Above: Centre\n1 - Above: Right\n2 - Above: Left\n8 - Below: Centre\n9 - Below: Right\n10 - Below: Left\n17 - In Text: Right\n18 - In Text: Left\n25 - In Text: Right (no wrap)\n26 - In Text: Left (no wrap)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:10:\"textMargin\";s:8:\"datatype\";s:15:\"pixels /stdWrap\";s:11:\"description\";s:40:\"margin between the image and the content\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:20:\"textMargin_outOfText\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:333:\"If set, the textMargin space will still be inserted even if the image is placed above or below the text.\nThis flag is only for a kind of backwards compatibility because this &quot;feature&quot; was recently considered a bug and thus corrected. So if anyone has depended on this way things are done, you can compensate with this flag.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:7:\"imgList\";s:8:\"datatype\";s:28:\"list of imagefiles / stdWrap\";s:11:\"description\";s:159:\"list of images from &quot;.imgPath&quot;\n&nbsp;\n<b>Example:</b>\nThis imports the list of images from tt_content\'s image-field\n&quot;imgList.field = image&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:7:\"imgPath\";s:8:\"datatype\";s:13:\"path /stdWrap\";s:11:\"description\";s:67:\"Path to the images\n&nbsp;\n<b>Example:</b>\n&quot;uploads/pics/&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:6:\"imgMax\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:20:\"max number of images\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:8:\"imgStart\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:45:\"start with image-number &quot;.imgStart&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:9:\"imgObjNum\";s:8:\"datatype\";s:29:\"<i>imgObjNum</i> +optionSplit\";s:11:\"description\";s:395:\"Here you define, which IMAGE-cObjects from the array &quot;1,2,3,4...&quot; in this object that should render the images.\n&quot;current&quot; is set to the image-filename.\n&nbsp;\n<b>Example:</b>\n&quot;imgObjNum = 1 |*||*| 2&quot;:\nThis would render the first two images with &quot;1. ...&quot; and the last image with &quot;2. ...&quot;, provided that the &quot;.imgList&quot; contains 3 images.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:7:\"1,2,3,4\";s:8:\"datatype\";s:20:\"-&gt;IMAGE (cObject)\";s:11:\"description\";s:307:\"Rendering of the images\nThe register &quot;IMAGE_NUM&quot; is set with the number of image being rendered for each rendering of a image-object. Starting with zero.\nThe image-object should not be of type GIFBUILDER!\n&nbsp;\n<b>Important:</b>\n&quot;file.import.current = 1&quot; fetches the name of the images!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:7:\"caption\";s:8:\"datatype\";s:20:\"-&gt;CARRAY /stdWrap\";s:11:\"description\";s:7:\"Caption\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:12:\"captionAlign\";s:8:\"datatype\";s:14:\"align /stdWrap\";s:11:\"description\";s:17:\"Caption alignment\";s:7:\"default\";s:30:\"default = &quot;.textPos&quot;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:12:\"captionSplit\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:369:\"If this is set, the caption text is split by the character (or string) from &quot;.token&quot; , and every item is displayed under an image each in the image block.\n.token = (string/stdWrap) Character to split the caption elements (default is chr(10))\n.cObject = cObject, used to fetch the caption for the split\n.stdWrap = stdWrap properties used to render the caption.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:7:\"altText\";s:8:\"datatype\";s:29:\"&lt;img&gt;-data:alt /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:6:\"border\";s:8:\"datatype\";s:16:\"boolean /stdWrap\";s:11:\"description\";s:48:\"If true, a border i generated around the images.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:9:\"borderCol\";s:8:\"datatype\";s:19:\"HTML-color /stdWrap\";s:11:\"description\";s:50:\"Color of the border, if &quot;.border&quot; is set\";s:7:\"default\";s:5:\"black\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:11:\"borderThick\";s:8:\"datatype\";s:15:\"pixels /stdWrap\";s:11:\"description\";s:39:\"Width of the border around the pictures\";s:7:\"default\";s:1:\"1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:4:\"cols\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:7:\"Columns\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:4:\"rows\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:44:\"Rows (higher priority thab &quot;cols&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:6:\"noRows\";s:8:\"datatype\";s:16:\"boolean /stdWrap\";s:11:\"description\";s:145:\"If set, the rows are not divided by a table-rows. Thus images are more nicely shown if the height differs a lot (normally the width is the same!)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:6:\"noCols\";s:8:\"datatype\";s:16:\"boolean /stdWrap\";s:11:\"description\";s:205:\"If set, the columns are not made in the table. The images are all put in one row separated by a clear giffile to space them apart.\nIf noRows is set, noCols will be unset. They cannot be set simultaneously.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:8:\"colSpace\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:21:\"space between columns\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:8:\"rowSpace\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:18:\"space between rows\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:15:\"spaceBelowAbove\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:101:\"Pixelsspace between content an images when position of image is above or belox text (but not in text)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:12:\"tableStdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:85:\"This passes the final &lt;table&gt; code for the image block to the stdWrap function.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:4:\"maxW\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:179:\"max width of the image-table.\nThis will scale images not in the right size! Takes the number of columns into account!\n&nbsp;\n<b>NOTE: </b>Works ONLY if IMAGE-obj is NOT GIFBUILDER\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:10:\"maxWInText\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:254:\"max width of the image-table, if the text is wrapped around the image-table (on the left or right side).\nThis will scale images not in the right size! Takes the number of columns into account!\n&nbsp;\n<b>NOTE: </b>Works ONLY if IMAGE-obj is NOT GIFBUILDER\";s:7:\"default\";s:11:\"50% of maxW\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:6:\"equalH\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:649:\"If this value is greater than zero, it will secure that images in a row has the same height. The width will be calculated.\nIf the total width of the images raise above the &quot;maxW&quot;-value of the table the height for each image will be scaled down equally so that the images still have the same height but is within the limits of the totalWidth.\nPlease note that this value will override the properties &quot;width&quot;, &quot;maxH&quot;, &quot;maxW&quot;, &quot;minW&quot;, &quot;minH&quot; of the IMAGE-objects generating the images. Furthermore it will override the &quot;noRows&quot;-property and generate a table with no columns instead!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:12:\"colRelations\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:609:\"This value defines the width-relations of the images in the columns of IMGTEXT. The syntax is &quot;[int] : [int] : [int] : ...&quot; for each column. If there are more imagecolumns than figures in this value, it\'s ignored. If the relation between two of these figures exceeds 10, this function is ignore.\nIt works only fully if all images are downscaled by their maxW-definition.\n&nbsp;\n<b>Example:</b>\nIf 6 images are placed in three columns and their width\'s are high enough to be forcibly scaled, this value will scale the images in the to be eg. 100, 200 and 300 &nbsp;pixels from left to right\n1 : 2 : 3\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:17:\"image_compression\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:926:\"Image Compression:\n0= Default\n1= Dont change! (removes all parameters for the image_object!!)\n(adds gif-extension and color-reduction command)\n10= GIF/256\n11= GIF/128\n12= GIF/64\n13= GIF/32\n14= GIF/16\n15= GIF/8\n(adds jpg-extension and quality command)\n20= IM: -quality 100\n21= IM: -quality 90 &lt;=&gt; Photoshop 60 &nbsp;&nbsp;&nbsp;&nbsp;(JPG/Very High)\n22= IM: -quality 80 &nbsp;&nbsp;&nbsp;(JPG/High)\n23= IM: -quality 70\n24= IM: -quality 60 &lt;=&gt; Photoshop 30 &nbsp;&nbsp;(JPG/Medium)\n25= IM: -quality 50\n26= IM: -quality 40 &nbsp;(JPG/Low)\n27= IM: -quality 30 &lt;=&gt; Photoshop 10\n28= IM: -quality 20 &nbsp;&nbsp;(JPG/Very Low)\n&nbsp;\nThe default ImageMagick quality seems to be 75. This equals Photoshop quality 45. Images compressed with ImageMagick with the same visual quality as a Photoshop-compressed image seems to be largely 50% greater in size!!\n&nbsp;\n<b>NOTE: </b>Works ONLY if IMAGE-obj is NOT GIFBUILDER\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:13:\"image_effects\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:506:\"Adds these commands to the parameteres for the scaling. This function has no effect if &quot;image_compression&quot; above is set to 1!!\n&nbsp;\n1 =&gt; &quot;-rotate 90&quot;,\n2 =&gt; &quot;-rotate 270&quot;,\n3 =&gt; &quot;-rotate 180&quot;,\n10 =&gt; &quot;-colorspace GRAY&quot;,\n11 =&gt; &quot;-sharpen 70&quot;,\n20 =&gt; &quot;-normalize&quot;,\n23 =&gt; &quot;-contrast&quot;,\n25 =&gt; &quot;-gamma 1.3&quot;,\n26 =&gt; &quot;-gamma 0.8&quot;\n&nbsp;\n<b>NOTE: </b>Works ONLY if IMAGE-obj is NOT GIFBUILDER\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:31;a:6:{s:8:\"property\";s:12:\"image_frames\";s:8:\"datatype\";s:28:\"Array\n+ .key /stdWrap\n&nbsp;\";s:11:\"description\";s:1019:\"<b>Frames:</b>\n.key points to the frame used.\n&nbsp;\n&quot;.image_frames.x&quot; is imgResource-mask (&quot;.m&quot;)properties which will override to the [imgResource].m properties of the imageObjects. This is used to mask the images into a frame. See how it\'s done in the default configuration and IMGTEXT in the static_template-table.\n&nbsp;\n<b>Example:</b>\n1 {\n&nbsp;&nbsp;mask = media/uploads/darkroom1_mask.jpg\n&nbsp;&nbsp;bgImg = GIFBUILDER\n&nbsp;&nbsp;bgImg {\n&nbsp;&nbsp;&nbsp;&nbsp;XY = 100,100\n&nbsp;&nbsp;&nbsp;&nbsp;backColor = {$bgCol}\n&nbsp;&nbsp;}\n&nbsp;&nbsp;bottomImg = GIFBUILDER\n&nbsp;&nbsp;bottomImg {\n&nbsp;&nbsp;&nbsp;&nbsp;XY = 100,100\n&nbsp;&nbsp;&nbsp;&nbsp;backColor = black\n&nbsp;&nbsp;}\n&nbsp;&nbsp;bottomImg_mask = media/uploads/darkroom1_bottom.jpg\n}\n&nbsp;\n<b>NOTE: </b>This cancels the jpg-quality settings sent as ordinary &quot;.params&quot; to the imgResource. In addition the output of this operation will always be jpg or gif!\n<b>NOTE: </b>Works ONLY if IMAGE-obj is NOT GIFBUILDER\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:32;a:6:{s:8:\"property\";s:23:\"netprintApplicationLink\";s:8:\"datatype\";s:20:\"boolean /+properties\";s:11:\"description\";s:1307:\"Set true, if you would like to enable the netprint feature.\n&quot;Netprint&quot; is a Typo3 application which is still in development. \'Netprint\' allows film development stores to offer online submission of Photos to a Typo3 / Netprint server in-house from which the store offer enlargements of digital photos on eg Kodak Royal paper.\nThe application will be released under GNU/GPL sometime in 2002.\n\'Netprint\' offers a feature to fetch images from peoples online fotoalbums. This property enables links from your site images to a Netprint server.\n&nbsp;\n<b>Properties:</b>\n<b>.url</b> = Url of the Netprint site page, eg. http://netprint.photo.com/?id=999&amp;type=2\n<b>.thisUrl</b> = Url of this site, eg. http://mysite.com/typo3site/ (default is calculated from HTTP_HOST)\n<b>.cObject </b>= (cObject) The link content\n<b>.ATagParams </b>= &lt;A&gt;-tag parameters\n<b>.outerStdWrap </b>= (-&gt;stdWrap) stdWrap of the total linked cObject.\n<b>.before </b>= (boolean) If the link code should be inserted before the image (default is after)\n<b>.linkOnlyPixelsAbove </b>= (int) If set, only images with a total number of pixels greater than this number will be linked. This secures that small images will not be linked. Eg. if images above 640x480 is supposed to be linked, the limit should be approx. 300000\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:33;a:6:{s:8:\"property\";s:9:\"editIcons\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:23:\"(See stdWrap.editIcons)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:34;a:6:{s:8:\"property\";s:23:\"noStretchAndMarginCells\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:270:\"If set (1), the cells used to add left and right margins plus stretch out the table will not be added. You will loose the ability to set margins for the object if entered &quot;in text&quot;. So it\'s not recommended, but it has been requested by some people for reasons.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (244,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:31:{i:0;a:6:{s:8:\"property\";s:12:\"templateFile\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:67:\"The template file, see examples in media/scripts/fe_user_admin.tmpl\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:15:\"templateContent\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:78:\"Alternatively you can set this property directly to the value of the template.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:5:\"table\";s:8:\"datatype\";s:9:\"tablename\";s:11:\"description\";s:285:\"The table to edit.\nNotice: The ultimate lsit of fields allowed to be edited for the table is defined in TCA with the key [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] for each table in question. For an example, see the table definition for fe_users which is a good example.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"defaultCmd\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:86:\"Defines which action should be default (if &amp;cmd= is not set when calling the page)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:17:\"clearCacheOfPages\";s:8:\"datatype\";s:25:\"<i>[list of integers]</i>\";s:11:\"description\";s:114:\"This is a list of page-ids for which to clear the cache on any successfull operation be it EDIT, CREATE og DELETE.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"debug\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:86:\"If set, debug information will be output from fe_adminLib which helps to track errors.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"Actions:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:4:\"edit\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:1793:\"If set, editing is basically allowed.\nBut you need to specify:\n&nbsp;\n<b>.fields </b>(list of fieldnames) which determines the fields allowed for editing. Every field in this list must be found as well in the [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] found in the TCA array which ultimately determines which fields can be edited by the fe_adminLib.\n<b>&nbsp;</b>\n<b>.overrideValues.[fieldname]</b> (value string) defines values for specific fields which will override ANY input from the form. Overriding values happens after the outside values has been parsed by the .parseValues-property of fe_adminLib but before the evaluation by .required and .evalValues below. For example this may be useful if you wish to hide a record which is being edited, because you want to preview it first.\n<b>&nbsp;</b>\n<b>.required </b>(list of fieldnames, subset of .fields) which determines which fields are required to return a true value. The valid fields entered here will have the subpart ###SUB_REQUIRED_FIELD_<i>[fieldname]</i>### removed from the templates if they evaluates to being true and thereby OK. See below for information about this subpart.\n<b>&nbsp;</b>\n<b>.evalValues.[fieldname]</b> (list of eval-codes) defines specific evaluation forms for the individual fiels of the form. See below.\n<b>&nbsp;</b>\n<b>.preview</b> (boolean) will enable the form submitted to be previewed first. This requires a template for preview to be found in the template file. See below for subpart marker names.\n<b>&nbsp;</b>\n<b>.menuLockPid</b> (boolean will force the menu of editable items to be locked to the .pid (edit only)\n<b>&nbsp;</b>\n<b>.userFunc_afterSave </b>(function-name) is called after the record is saved. The content passed is an array with the current (and previous) record in.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:6:\"create\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:416:\"The same as .edit above except where otherwise stated.\nPlus there is these additional properties:\n<b>&nbsp;</b>\n<b>.noSpecialLoginForm </b>(boolean) - if set, fe_adminLib does NOT look for the subpart marker TEMPLATE_CREATE_LOGIN but always for TEMPLATE_CREATE\n<b>&nbsp;</b>\n<b>.defaultValues.[fieldname]</b> (value string); Like .overrideValues but this sets the default values the first time the form is displayed.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:6:\"delete\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:214:\"Whether or not records may be deleted. Still regular authentication (ownership or email authCode) is required. Setting the var &quot;preview&quot; lets you make a delete-preview before actually deleting the record.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:8:\"infomail\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:371:\"Infomails are plaintext mails based on templates found in the template file. They may be used for such as sending a forgotten password to a user, but what goes into the infomail is totally up to your design of the template.\nNormally you may have only a default infomail (infomail.default) for instance for sending the password. But you can use other keys also. See below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:14:\"infomail.[key]\";s:8:\"datatype\";s:38:\"(configuration of infomail properties)\";s:11:\"description\";s:550:\"In order to make fe_adminLib send an infomail, you must specify these vars in your GET vars or HTML-form.\n&nbsp;\n<b>fetch</b> - if integer, it searches for the uid being the value of \'fetch\'. If not, it searches for the email-field (defined by a property of fe_adminLib, see below).\n&nbsp;\n<b>key</b> - points to the infomail.[key] configuration to use\n<b>&nbsp;</b>\n<b>Properties:</b>\n<b>.dontLockPid</b> (boolean) - selects only records from the .pid of fe_adminLib.\n<b>.label </b>(string) - The suffix for the markers, see \'Email Markers\' beneath.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:8:\"setfixed\";s:8:\"datatype\";s:19:\"boolean /properties\";s:11:\"description\";s:2645:\"Allows set-fixed input, probably coming from a link in an infomail or notification mail.\n<b>Syntax: </b>\n&nbsp;\n<b>.[fix</b><b><i>key</i></b><b>].[</b><b><i>fieldname</i></b><b>] = </b><b><i>fieldvalue</i></b><i>&nbsp;</i>- is used to setup a setfixed-link insertable in the infomail by the SYS_SETFIXED_*-markers. See above (setfixed-property of fe_adminLib).\nSpecial fixkey \'DELETE\' is just a boolean.\n&nbsp;\n<b>Concept:</b>\nThe \'setfixed\' concept is best explained by describing a typical scenario - in fact the most common situation of its use:\nImagine you have some users submitting information on your website. But before that information enters the database, you would like to moderate it - simply preview it and then either delete it or approve it. In the \'create\' configuration of fe_adminLib, you set up the hidden field of the record to be overridden to 1. Thus the record is hidden by default. Then you configure a setfixed-fixkey to set the hidden field to 0. This set up generates a list of parameters for use in an URL and those parameters are finally inserted by a corresponding marker in the email template. The link includes all necessary authentication to perform the change of values and thus a single click on that link is enough to change the field values. So this will - by a single click of a link in a notification mail sent to an admin - enable the record! Or of course a similar link with a cmd=delete link will delete it...\nThere is a special &quot;fieldname&quot; you can use, which is \'_FIELDLIST&quot; and that lets you specify a list of fields in the record to base the auth-code on. If nothing is specifyed the md5-hash is based on the whole record which means that any changes will disable the setfixed link. If on the other hand, you set _FIELDLIST = uid,pid then that record will be editable as long as the uid and pid values are intact.\n<b>Example:</b>\nThis is a common configuration of the email-properties with a simple setfixed setting:\n&nbsp;&nbsp;email.from = kasper@typo3.com\n&nbsp;&nbsp;email.fromName = Kasper Sk&aring;rh&oslash;j\n&nbsp;&nbsp;email.admin = kasper@typo3.com\n&nbsp;&nbsp;setfixed.approve {\n&nbsp;&nbsp;setfixed.DELETE = 1\n&nbsp;\nNow, if you insert this marker in your email template\n&nbsp;\n&nbsp;&nbsp;###SYS_SETFIXED_approve###\n&nbsp;\nif will get substituted with something like these parameters:\n&nbsp;\n&amp;cmd=setfixed&amp;rU=9&amp;fD[hidden]=0&amp;aC=5c403d90\n&nbsp;\nNow, all you need is to point that to the correct url (where fe_adminLib is invoked!), eg:\n&nbsp;\n###THIS_URL######FORM_URL######SYS_SETFIXED_approve###\n&nbsp;\nand for deletion:\n&nbsp;\n...###SYS_SETFIXED_DELETE###\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:6:\"Others\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:14:\"authcodeFields\";s:8:\"datatype\";s:23:\"<i>[list of fields]</i>\";s:11:\"description\";s:1287:\"Comma separated list of fields to base the authCode generation on. Basically this list would include &quot;uid&quot; only in most cases. If the list includes more fields, you should be aware that the authCode will change when the value of that field changes. And then the user will have to re-send an email to himself with a new code.\n&nbsp;\n<b>.addKey </b>(string) adds the string to the md5-hash of the authCode. Just enter any random string here. Point is that people from outside doesn\'t know this code and therefore are not able to reconstruct the md5-hash solely based on the uid\n&nbsp;\n<b>.addDate</b> (date-config) You can use this to make the code time-disabled. Say if you enter &quot;d-m-Y&quot; here as value, the code will work until midnight and then a new code will be valid.\n&nbsp;\n<b>.codeLength</b> (int) Defines how long the authentication code should be. Default is 8 characters.\nIn any case TYPO3_CONF_VARS[SYS][encryptionKey] is prepended.\n&nbsp;\n<b>Advice:</b>\nIf you want to generate authCodes compatible with the standard authCodes (used by the direct mailer by t3lib_div::stdAuthCode()), please set TYPO3_CONF_VARS[SYS][encryptionKey] to a unique and secret key (like you should in any case) and add &quot;uid&quot; as authcodeField ONLY. This is secure enough.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:5:\"email\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:593:\"<b>.from </b>(string, email) Defines the sender email address of mails sent out\n&nbsp;\n<b>.fromName </b>(string) Defines the name of the sender. If set, this will be used on the form NAME &lt;EMAIL&gt;\n&nbsp;\n<b>.admin &nbsp;Email address of the administrator which is notified of changes.</b>\n&nbsp;\n<b>.field </b>(string/integer) Defines the fieldname of the record where the email address to send to is found. If the field content happens to be an integer, this is assumed to be the uid of the fe_user owning the record and the email address of that user is fetched for the purpose instead.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:3:\"pid\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:42:\"The pid in which to store/get the records.\";s:7:\"default\";s:12:\"Current page\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:14:\"fe_userOwnSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:337:\"If set, fe_users created by this module has their fe_cruser_id-field set to their own uid which means they \'own\' their own record and can thus edit their own data.\nAll other tables which has a fe_cruser_id field configured in the \'ctrl\' section of their $TCA-configuration will automatically get this field set to the current fe_user id.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:15:\"fe_userEditSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:102:\"If set, fe_users - regardless of whether they own themselves or not - will be allowed to edit himself.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:13:\"allowedGroups\";s:8:\"datatype\";s:18:\"[list of integers]\";s:11:\"description\";s:141:\"List of fe_groups uid numbers which are allowed to edit the records through this form. Normally only the owner fe_user is allowed to do that.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:8:\"evalFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:261:\"Function by which you can manipulate the dataArray before it\'s saved.\nThe dataArray is passed to the function as $content and MUST be returned again from the function.\nThe property &quot;parentObj&quot; is a hardcoded reference to the fe_adminLib object.\n&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:8:\"no_cache\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:63:\"If set, &amp;no_cache=1 is sent in the links of the fe_adminLib\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:19:\"parseValues.[field]\";s:8:\"datatype\";s:20:\"[list of parseCodes]\";s:11:\"description\";s:1407:\"<b>ParseCodes:</b>\n<b>int </b>- returns the integer value of the input\n<b>lower</b> - returns lowercase version of the input\n<b>upper </b>- returns uppercase version of the input\n<b>nospace</b> - strips all space\n<b>alpha, num, alphanum, alphanum_x</b> &nbsp;- only alphabetic (a-z) and/or numeric chars. alphanum_x also allows _ and -\n<b>trim </b>- trims whitespace in the ends of the string\n<b>setEmptyIfAbsent </b>- will make sure the field is set to empty if the value is not submitted. This ensures a field to be updated an is handy with checkboxes\n<b>random[x]</b> - Returns a random number between 0 and x\n<b>files[semicolon-list(!) of extensions, none=all][maxsize in kb, none=no limit]</b> - Defining the field to hold files. See below for details!\n<b>multiple </b>- Set this, if the input comes from a multiple-selector box (remember to add ...[] to the fieldname so the values come in an array!)\n<b>checkArray</b> - Set this, if you want several checkboxes to set bits in a single field. In that case you must prepend every checkbox with [x] where x is the bitnumber to set starting with zero. The default values of the checkbox form elements must be false.\n<b>uniqueHashInt[semicolon-list(!) of other fields]</b> - This makes a unique hash (32 bit integer) of the content in the specified fields. The values of those fields are first converted to lowercase and only alphanum chars are preserved.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:20:\"userFunc_updateArray\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:148:\"Points to a user function which will have the value-array passed to it before the value array is used to construct the update-JavaScript statements.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:29:\"evalErrors.[field].[evalCode]\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:162:\"This lets you specify the error messages inserted in the ###EVAL_ERROR_FIELD_[fieldname]### markers upon an evaluation error.\nSee description of evaluation below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:22:\"cObjects.[marker_name]\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:365:\"This is cObjects you can insert by markers in the template.\n&nbsp;\n<b>Example:</b>\nSay, you set up a cObject like this:\n&nbsp;\ncObject.myHeader = TEXT\ncObject.myHeader.value = This is my header\n&nbsp;\nthen you can include this cObject in most of the templates through a marker named ###CE_myHeader### or ###PCE_myHeader### (see below for details on the difference).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:5:\"wrap1\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:211:\"Global Wrap 1. This will be splitted into the markers ###GW1B### and ###GW1E###. Don\'t change the input value by the settings, only wrap it in something.\n&nbsp;\n<b>Example:</b>\nwrap1.wrap = &lt;b&gt; |&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:5:\"wrap2\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:25:\"Global Wrap 2 (see above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:6:\"color1\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC1### marker (Global color 1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:6:\"color2\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC2### marker (Global color 2)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:6:\"color3\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC3### marker (Global color 3)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (240,270,'52b4fd3e8e7b15fb48cd362b5fc056cd','','tsref:(cObject).HMENU.(mObj).JSMENUITEM','a:1:{s:4:\"rows\";a:9:{i:0;a:6:{s:8:\"property\";s:6:\"noLink\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:403:\"Normally the selection of a menu item in the selector box will update the selector on the next level (if there is a next level) and if there are no items for that selector (because there were no subpages), then the link jumps to the page of itself.\nIf this flag is set, however, no menuitems in the selector box will ever link to anything. Only update the content of the next selector box on next level.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:10:\"alwaysLink\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:100:\"If set an item in the menu selector will always link. This takes precedence over &quot;noLink&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:10:\"showFi rst\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:62:\"if set, the first link will be shown when the menu is updated.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"showActive\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:53:\"if set, the active level will be selected, if present\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:21:\"wraps the selectorbox\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"width\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:61:\"Initial width of the boxes set by a number of _ (underscores)\";s:7:\"default\";s:2:\"14\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"elements\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:104:\"Initial number of elements in the menu. &nbsp;This is of course overruled by the actual menu item texts.\";s:7:\"default\";s:1:\"5\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:16:\"additionalParams\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:142:\"Additional parameters to the &lt;select&gt; box. Eg, you could set the width with a style-parameter like this:\nstyle=&quot;width: 200px;&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:10:\"firstLabel\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:48:\"Firt label in top of the menu (default is blank)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (241,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:9:{i:0;a:6:{s:8:\"property\";s:6:\"noLink\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:403:\"Normally the selection of a menu item in the selector box will update the selector on the next level (if there is a next level) and if there are no items for that selector (because there were no subpages), then the link jumps to the page of itself.\nIf this flag is set, however, no menuitems in the selector box will ever link to anything. Only update the content of the next selector box on next level.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:10:\"alwaysLink\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:100:\"If set an item in the menu selector will always link. This takes precedence over &quot;noLink&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:10:\"showFi rst\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:62:\"if set, the first link will be shown when the menu is updated.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"showActive\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:53:\"if set, the active level will be selected, if present\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:21:\"wraps the selectorbox\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"width\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:61:\"Initial width of the boxes set by a number of _ (underscores)\";s:7:\"default\";s:2:\"14\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"elements\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:104:\"Initial number of elements in the menu. &nbsp;This is of course overruled by the actual menu item texts.\";s:7:\"default\";s:1:\"5\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:16:\"additionalParams\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:142:\"Additional parameters to the &lt;select&gt; box. Eg, you could set the width with a style-parameter like this:\nstyle=&quot;width: 200px;&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:10:\"firstLabel\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:48:\"Firt label in top of the menu (default is blank)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (242,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:9:{i:0;a:6:{s:8:\"property\";s:6:\"noLink\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:403:\"Normally the selection of a menu item in the selector box will update the selector on the next level (if there is a next level) and if there are no items for that selector (because there were no subpages), then the link jumps to the page of itself.\nIf this flag is set, however, no menuitems in the selector box will ever link to anything. Only update the content of the next selector box on next level.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:10:\"alwaysLink\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:100:\"If set an item in the menu selector will always link. This takes precedence over &quot;noLink&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:10:\"showFi rst\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:62:\"if set, the first link will be shown when the menu is updated.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"showActive\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:53:\"if set, the active level will be selected, if present\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:21:\"wraps the selectorbox\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"width\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:61:\"Initial width of the boxes set by a number of _ (underscores)\";s:7:\"default\";s:2:\"14\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"elements\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:104:\"Initial number of elements in the menu. &nbsp;This is of course overruled by the actual menu item texts.\";s:7:\"default\";s:1:\"5\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:16:\"additionalParams\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:142:\"Additional parameters to the &lt;select&gt; box. Eg, you could set the width with a style-parameter like this:\nstyle=&quot;width: 200px;&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:10:\"firstLabel\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:48:\"Firt label in top of the menu (default is blank)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (243,270,'d5d05a1da766c8752918259cd571b75f','','tsref:(script).fe_adminLib','a:1:{s:4:\"rows\";a:31:{i:0;a:6:{s:8:\"property\";s:12:\"templateFile\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:67:\"The template file, see examples in media/scripts/fe_user_admin.tmpl\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:15:\"templateContent\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:78:\"Alternatively you can set this property directly to the value of the template.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:5:\"table\";s:8:\"datatype\";s:9:\"tablename\";s:11:\"description\";s:285:\"The table to edit.\nNotice: The ultimate lsit of fields allowed to be edited for the table is defined in TCA with the key [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] for each table in question. For an example, see the table definition for fe_users which is a good example.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"defaultCmd\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:86:\"Defines which action should be default (if &amp;cmd= is not set when calling the page)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:17:\"clearCacheOfPages\";s:8:\"datatype\";s:25:\"<i>[list of integers]</i>\";s:11:\"description\";s:114:\"This is a list of page-ids for which to clear the cache on any successfull operation be it EDIT, CREATE og DELETE.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"debug\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:86:\"If set, debug information will be output from fe_adminLib which helps to track errors.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"Actions:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:4:\"edit\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:1793:\"If set, editing is basically allowed.\nBut you need to specify:\n&nbsp;\n<b>.fields </b>(list of fieldnames) which determines the fields allowed for editing. Every field in this list must be found as well in the [&quot;feInterface&quot;][&quot;fe_admin_fieldList&quot;] found in the TCA array which ultimately determines which fields can be edited by the fe_adminLib.\n<b>&nbsp;</b>\n<b>.overrideValues.[fieldname]</b> (value string) defines values for specific fields which will override ANY input from the form. Overriding values happens after the outside values has been parsed by the .parseValues-property of fe_adminLib but before the evaluation by .required and .evalValues below. For example this may be useful if you wish to hide a record which is being edited, because you want to preview it first.\n<b>&nbsp;</b>\n<b>.required </b>(list of fieldnames, subset of .fields) which determines which fields are required to return a true value. The valid fields entered here will have the subpart ###SUB_REQUIRED_FIELD_<i>[fieldname]</i>### removed from the templates if they evaluates to being true and thereby OK. See below for information about this subpart.\n<b>&nbsp;</b>\n<b>.evalValues.[fieldname]</b> (list of eval-codes) defines specific evaluation forms for the individual fiels of the form. See below.\n<b>&nbsp;</b>\n<b>.preview</b> (boolean) will enable the form submitted to be previewed first. This requires a template for preview to be found in the template file. See below for subpart marker names.\n<b>&nbsp;</b>\n<b>.menuLockPid</b> (boolean will force the menu of editable items to be locked to the .pid (edit only)\n<b>&nbsp;</b>\n<b>.userFunc_afterSave </b>(function-name) is called after the record is saved. The content passed is an array with the current (and previous) record in.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:6:\"create\";s:8:\"datatype\";s:21:\"boolean /actionObject\";s:11:\"description\";s:416:\"The same as .edit above except where otherwise stated.\nPlus there is these additional properties:\n<b>&nbsp;</b>\n<b>.noSpecialLoginForm </b>(boolean) - if set, fe_adminLib does NOT look for the subpart marker TEMPLATE_CREATE_LOGIN but always for TEMPLATE_CREATE\n<b>&nbsp;</b>\n<b>.defaultValues.[fieldname]</b> (value string); Like .overrideValues but this sets the default values the first time the form is displayed.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:6:\"delete\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:214:\"Whether or not records may be deleted. Still regular authentication (ownership or email authCode) is required. Setting the var &quot;preview&quot; lets you make a delete-preview before actually deleting the record.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:8:\"infomail\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:371:\"Infomails are plaintext mails based on templates found in the template file. They may be used for such as sending a forgotten password to a user, but what goes into the infomail is totally up to your design of the template.\nNormally you may have only a default infomail (infomail.default) for instance for sending the password. But you can use other keys also. See below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:14:\"infomail.[key]\";s:8:\"datatype\";s:38:\"(configuration of infomail properties)\";s:11:\"description\";s:550:\"In order to make fe_adminLib send an infomail, you must specify these vars in your GET vars or HTML-form.\n&nbsp;\n<b>fetch</b> - if integer, it searches for the uid being the value of \'fetch\'. If not, it searches for the email-field (defined by a property of fe_adminLib, see below).\n&nbsp;\n<b>key</b> - points to the infomail.[key] configuration to use\n<b>&nbsp;</b>\n<b>Properties:</b>\n<b>.dontLockPid</b> (boolean) - selects only records from the .pid of fe_adminLib.\n<b>.label </b>(string) - The suffix for the markers, see \'Email Markers\' beneath.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:8:\"setfixed\";s:8:\"datatype\";s:19:\"boolean /properties\";s:11:\"description\";s:2645:\"Allows set-fixed input, probably coming from a link in an infomail or notification mail.\n<b>Syntax: </b>\n&nbsp;\n<b>.[fix</b><b><i>key</i></b><b>].[</b><b><i>fieldname</i></b><b>] = </b><b><i>fieldvalue</i></b><i>&nbsp;</i>- is used to setup a setfixed-link insertable in the infomail by the SYS_SETFIXED_*-markers. See above (setfixed-property of fe_adminLib).\nSpecial fixkey \'DELETE\' is just a boolean.\n&nbsp;\n<b>Concept:</b>\nThe \'setfixed\' concept is best explained by describing a typical scenario - in fact the most common situation of its use:\nImagine you have some users submitting information on your website. But before that information enters the database, you would like to moderate it - simply preview it and then either delete it or approve it. In the \'create\' configuration of fe_adminLib, you set up the hidden field of the record to be overridden to 1. Thus the record is hidden by default. Then you configure a setfixed-fixkey to set the hidden field to 0. This set up generates a list of parameters for use in an URL and those parameters are finally inserted by a corresponding marker in the email template. The link includes all necessary authentication to perform the change of values and thus a single click on that link is enough to change the field values. So this will - by a single click of a link in a notification mail sent to an admin - enable the record! Or of course a similar link with a cmd=delete link will delete it...\nThere is a special &quot;fieldname&quot; you can use, which is \'_FIELDLIST&quot; and that lets you specify a list of fields in the record to base the auth-code on. If nothing is specifyed the md5-hash is based on the whole record which means that any changes will disable the setfixed link. If on the other hand, you set _FIELDLIST = uid,pid then that record will be editable as long as the uid and pid values are intact.\n<b>Example:</b>\nThis is a common configuration of the email-properties with a simple setfixed setting:\n&nbsp;&nbsp;email.from = kasper@typo3.com\n&nbsp;&nbsp;email.fromName = Kasper Sk&aring;rh&oslash;j\n&nbsp;&nbsp;email.admin = kasper@typo3.com\n&nbsp;&nbsp;setfixed.approve {\n&nbsp;&nbsp;setfixed.DELETE = 1\n&nbsp;\nNow, if you insert this marker in your email template\n&nbsp;\n&nbsp;&nbsp;###SYS_SETFIXED_approve###\n&nbsp;\nif will get substituted with something like these parameters:\n&nbsp;\n&amp;cmd=setfixed&amp;rU=9&amp;fD[hidden]=0&amp;aC=5c403d90\n&nbsp;\nNow, all you need is to point that to the correct url (where fe_adminLib is invoked!), eg:\n&nbsp;\n###THIS_URL######FORM_URL######SYS_SETFIXED_approve###\n&nbsp;\nand for deletion:\n&nbsp;\n...###SYS_SETFIXED_DELETE###\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:6:\"Others\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:14:\"authcodeFields\";s:8:\"datatype\";s:23:\"<i>[list of fields]</i>\";s:11:\"description\";s:1287:\"Comma separated list of fields to base the authCode generation on. Basically this list would include &quot;uid&quot; only in most cases. If the list includes more fields, you should be aware that the authCode will change when the value of that field changes. And then the user will have to re-send an email to himself with a new code.\n&nbsp;\n<b>.addKey </b>(string) adds the string to the md5-hash of the authCode. Just enter any random string here. Point is that people from outside doesn\'t know this code and therefore are not able to reconstruct the md5-hash solely based on the uid\n&nbsp;\n<b>.addDate</b> (date-config) You can use this to make the code time-disabled. Say if you enter &quot;d-m-Y&quot; here as value, the code will work until midnight and then a new code will be valid.\n&nbsp;\n<b>.codeLength</b> (int) Defines how long the authentication code should be. Default is 8 characters.\nIn any case TYPO3_CONF_VARS[SYS][encryptionKey] is prepended.\n&nbsp;\n<b>Advice:</b>\nIf you want to generate authCodes compatible with the standard authCodes (used by the direct mailer by t3lib_div::stdAuthCode()), please set TYPO3_CONF_VARS[SYS][encryptionKey] to a unique and secret key (like you should in any case) and add &quot;uid&quot; as authcodeField ONLY. This is secure enough.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:5:\"email\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:593:\"<b>.from </b>(string, email) Defines the sender email address of mails sent out\n&nbsp;\n<b>.fromName </b>(string) Defines the name of the sender. If set, this will be used on the form NAME &lt;EMAIL&gt;\n&nbsp;\n<b>.admin &nbsp;Email address of the administrator which is notified of changes.</b>\n&nbsp;\n<b>.field </b>(string/integer) Defines the fieldname of the record where the email address to send to is found. If the field content happens to be an integer, this is assumed to be the uid of the fe_user owning the record and the email address of that user is fetched for the purpose instead.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:3:\"pid\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:42:\"The pid in which to store/get the records.\";s:7:\"default\";s:12:\"Current page\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:14:\"fe_userOwnSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:337:\"If set, fe_users created by this module has their fe_cruser_id-field set to their own uid which means they \'own\' their own record and can thus edit their own data.\nAll other tables which has a fe_cruser_id field configured in the \'ctrl\' section of their $TCA-configuration will automatically get this field set to the current fe_user id.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:15:\"fe_userEditSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:102:\"If set, fe_users - regardless of whether they own themselves or not - will be allowed to edit himself.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:13:\"allowedGroups\";s:8:\"datatype\";s:18:\"[list of integers]\";s:11:\"description\";s:141:\"List of fe_groups uid numbers which are allowed to edit the records through this form. Normally only the owner fe_user is allowed to do that.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:8:\"evalFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:261:\"Function by which you can manipulate the dataArray before it\'s saved.\nThe dataArray is passed to the function as $content and MUST be returned again from the function.\nThe property &quot;parentObj&quot; is a hardcoded reference to the fe_adminLib object.\n&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:8:\"no_cache\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:63:\"If set, &amp;no_cache=1 is sent in the links of the fe_adminLib\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:19:\"parseValues.[field]\";s:8:\"datatype\";s:20:\"[list of parseCodes]\";s:11:\"description\";s:1407:\"<b>ParseCodes:</b>\n<b>int </b>- returns the integer value of the input\n<b>lower</b> - returns lowercase version of the input\n<b>upper </b>- returns uppercase version of the input\n<b>nospace</b> - strips all space\n<b>alpha, num, alphanum, alphanum_x</b> &nbsp;- only alphabetic (a-z) and/or numeric chars. alphanum_x also allows _ and -\n<b>trim </b>- trims whitespace in the ends of the string\n<b>setEmptyIfAbsent </b>- will make sure the field is set to empty if the value is not submitted. This ensures a field to be updated an is handy with checkboxes\n<b>random[x]</b> - Returns a random number between 0 and x\n<b>files[semicolon-list(!) of extensions, none=all][maxsize in kb, none=no limit]</b> - Defining the field to hold files. See below for details!\n<b>multiple </b>- Set this, if the input comes from a multiple-selector box (remember to add ...[] to the fieldname so the values come in an array!)\n<b>checkArray</b> - Set this, if you want several checkboxes to set bits in a single field. In that case you must prepend every checkbox with [x] where x is the bitnumber to set starting with zero. The default values of the checkbox form elements must be false.\n<b>uniqueHashInt[semicolon-list(!) of other fields]</b> - This makes a unique hash (32 bit integer) of the content in the specified fields. The values of those fields are first converted to lowercase and only alphanum chars are preserved.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:20:\"userFunc_updateArray\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:148:\"Points to a user function which will have the value-array passed to it before the value array is used to construct the update-JavaScript statements.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:29:\"evalErrors.[field].[evalCode]\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:162:\"This lets you specify the error messages inserted in the ###EVAL_ERROR_FIELD_[fieldname]### markers upon an evaluation error.\nSee description of evaluation below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:22:\"cObjects.[marker_name]\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:365:\"This is cObjects you can insert by markers in the template.\n&nbsp;\n<b>Example:</b>\nSay, you set up a cObject like this:\n&nbsp;\ncObject.myHeader = TEXT\ncObject.myHeader.value = This is my header\n&nbsp;\nthen you can include this cObject in most of the templates through a marker named ###CE_myHeader### or ###PCE_myHeader### (see below for details on the difference).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:5:\"wrap1\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:211:\"Global Wrap 1. This will be splitted into the markers ###GW1B### and ###GW1E###. Don\'t change the input value by the settings, only wrap it in something.\n&nbsp;\n<b>Example:</b>\nwrap1.wrap = &lt;b&gt; |&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:5:\"wrap2\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:25:\"Global Wrap 2 (see above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:6:\"color1\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC1### marker (Global color 1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:6:\"color2\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC2### marker (Global color 2)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:6:\"color3\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC3### marker (Global color 3)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (235,270,'bec5811d03462a9bb1c8e461c032d461','','tsref:(cObject).HMENU.(mObj).TMENU','a:1:{s:4:\"rows\";a:8:{i:0;a:6:{s:8:\"property\";s:6:\"expAll\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:252:\"If this is true, the menu will always show the menu on the level underneath the menuitem. This corresponds to a situation where a user has clicked a menuitem and the menu folds out the next level. This can enable that to happen on all items as default.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:8:\"collapse\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:116:\"If set, &quot;active&quot; menuitems that has expanded the next level on the menu will now collapse that menu again.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:6:\"noBlur\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:208:\"Normally links are &quot;blurred&quot; if the browser is MSIE. Blurring removes the ugly box around a clicked link.\nIf this property is set, the link is NOT blurred (browser-default) with &quot;onFocus&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:6:\"target\";s:11:\"description\";s:23:\"Target of the menulinks\";s:7:\"default\";s:4:\"self\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:14:\"forceTypeValue\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:89:\"If set, the &amp;type parameter of the link is forced to this value regardless of target.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:43:\"Wraps only if there were items in the menu!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:9:\"IProcFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:327:\"The internal array &quot;I&quot; is passed to this function and expected returned as well. Subsequent to this function call the menu item is compiled by implode()\'ing the array $I[parts] in the passed array. Thus you may modify this if you need to.\nSee example on the testsite and in media/scripts/example_itemArrayProcFunc.php\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:31:\"[Common Item States, see above]\";s:8:\"datatype\";s:14:\"-&gt;TMENUITEM\";s:11:\"description\";s:212:\"This is the TMENUITEM-options for each category of menuitem that can be generated.\n&nbsp;\n<b>SPECIAL:</b>\nThe -&gt;OptionSplit function is run on the whole GIFBUILDER-configuration before the items are generated.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (236,270,'6741d93da8500fc90e7237a7a0cf9479','','tsref:(cObject).HMENU.(mObj).TMENUITEM','a:1:{s:4:\"rows\";a:20:{i:0;a:6:{s:8:\"property\";s:17:\"allWrap /+stdWrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:20:\"Wraps the whole item\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:14:\"wrapItemAndSub\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:56:\"Wraps the whole item and any submenu concatenated to it.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:16:\"subst_elementUid\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:287:\"If set, all appearances of the string \'{elementUid}\' in the total element html-code (after wrapped in .allWrap} is substituted with the uid number of the menu item.\nThis is useful if you want to insert an identification code in the HTML in order to manipulate properties with JavaScript.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:12:\"RO_chBgColor\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:1323:\"If property RO is set (see below) then you can set this property to a certain set of parameters which will allow you to change the background color of eg. the tablecell when the mouse rolls over you text-link.\n&nbsp;\n<b>Syntax:</b>\n[over-color] | [out-color] | [id-prefix]\n&nbsp;\n<b>Example:</b>\npage = PAGE\npage.typeNum = 0\npage.10 = HMENU\npage.10.wrap = &lt;table border=1&gt;|&lt;/table&gt;\npage.10.1 = TMENU\npage.10.1.NO {\n&nbsp;&nbsp;allWrap = &lt;tr&gt;&lt;td valign=top id=&quot;1tmenu{elementUid}&quot; style=&quot;background:#eeeeee;&quot;&gt;|&lt;/td&gt;&lt;/tr&gt;\n&nbsp;&nbsp;subst_elementUid = 1\n&nbsp;&nbsp;RO_chBgColor = #cccccc | #eeeeee | 1tmenu\n&nbsp;&nbsp;RO = 1\n}\n&nbsp;\nThis example will start out with the table cells in #eeeeee and change them to #cccccc (and back) when rolled over. The &quot;1tmenu&quot; string is a unique id for the menu items. You may not need it (unless the same menu items are more than once on a page), but the important thing is that the id of the table cell has the exact same label before the {elementUid} (red marks). The other important thing is that you DO set a default background color for the cell with the style-attribute (blue marking). If you do not, Mozilla browsers will behave a little strange by not capturing the mouseout event the first time it\'s triggered.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:6:\"before\";s:8:\"datatype\";s:13:\"HTML +stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:9:\"beforeImg\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:18:\"beforeImgTagParams\";s:8:\"datatype\";s:18:\"&lt;img&gt;-params\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:13:\"beforeImgLink\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:68:\"If set, this image is linked with the same &lt;A&gt; tag as the text\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:11:\"beforeROImg\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:98:\"If set, &quot;.beforeImg&quot; and &quot;.beforeROImg&quot; is expected to create a rollOver-pair.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:10:\"beforeWrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:40:\"wrap around the &quot;.before&quot;-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:15:\"stdWrap-options\";s:11:\"description\";s:25:\"stdWrap to the link-text!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:14:\"ATagBeforeWrap\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:10:\"ATagParams\";s:8:\"datatype\";s:14:\"&lt;A&gt;-data\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:11:\"doNotLinkIt\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:43:\"if set, the linktext are not linked at all!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:13:\"doNotShowLink\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:62:\"if set, the text will not be shown at all (smart with spacers)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:8:\"stdWrap2\";s:8:\"datatype\";s:14:\"wrap /+stdWrap\";s:11:\"description\";s:129:\"stdWrap to the total link-text and ATag. &nbsp;(Notice that the plain default value passed to stdWrap function is &quot;|&quot;.)\";s:7:\"default\";s:7:\"&nbsp;|\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:2:\"RO\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:41:\"if set, rollOver is enabled for this link\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:8:\"after...\";s:8:\"datatype\";s:7:\"[mixed]\";s:11:\"description\";s:225:\"The series of &quot;before...&quot; properties are duplicated to &quot;after...&quot; properties as well. The only difference is that the output generated by the .after.... properties are placed after the link and not before.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:9:\"altTarget\";s:8:\"datatype\";s:6:\"target\";s:11:\"description\";s:70:\"Alternative target overriding the target property of the TMENU if set.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (237,270,'0ab0ced808e0b089231bd8b12ab07fca','','tsref:(cObject).HMENU.(mObj).IMGMENU','a:1:{s:4:\"rows\";a:10:{i:0;a:6:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:6:\"target\";s:11:\"description\";s:23:\"Target of the menulinks\";s:7:\"default\";s:4:\"self\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:14:\"forceTypeValue\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:89:\"If set, the &amp;type parameter of the link is forced to this value regardless of target.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:6:\"noBlur\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:218:\"Normally graphical links are &quot;blurred&quot; if the browser is MSIE. Blurring removes the ugly box around a clicked link.\nIf this property is set, the link is NOT blurred (browser-default) with &quot;onFocus&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:6:\"params\";s:8:\"datatype\";s:18:\"&lt;img&gt;-params\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:4:\"main\";s:8:\"datatype\";s:15:\"-&gt;GIFBUILDER\";s:11:\"description\";s:75:\"Main configuration of the image-map! This defines the &quot;underlay&quot;!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:9:\"dWorkArea\";s:8:\"datatype\";s:13:\"offset + calc\";s:11:\"description\";s:78:\"Main offset of the GIFBUILDER-items (also called the &quot;distribution&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:31:\"[Common Item States, see above]\";s:8:\"datatype\";s:27:\"-&gt;IMGMENUITEM\n+ .distrib\";s:11:\"description\";s:1307:\"This is the TMENUITEM-options for each category of menuitem that can be generated.\n&nbsp;\n<b>SPECIAL:</b>\nThe -&gt;OptionSplit function is run on the whole GIFBUILDER-configuration before the items are generated.\n&nbsp;\n<b>.distrib</b> is (x,y,v,h +calc) of the distribution of the menuitems. This provides a way to space each item from the other. The codes &quot;textX&quot; and &quot;textY&quot; can be used for the width (X) and height (Y) dimension of each link.\nThis works by adding a WORKAREA-GifBuilderObj between each of the IMGMENUITEM (&quot;subset&quot; of a GIFBUILDER-object) and this workarea defines where the text should be printed. As such the &quot;x,y&quot; defines the offset <b><i>the next item will have</i></b> (this should be the width of the previous in many cases!) and &quot;v,h&quot; defines the <b><i>dimensions of the current item</i></b>.\nConsider this example taken from the static_template &quot;template: MM&quot;:\n&nbsp;&nbsp;&nbsp;&nbsp;NO.distrib = textX+10, 0, textX+10, textY+5\nIn the future TypoScript may provide better ways to position GIFBUILDER-objects on the image-maps!\n&nbsp;\n<b>ImgMap</b> is automatically used on the links! (that is the &quot;.imgMap&quot; property of the text-objects in the GIFBUILDER-objects is set automatically, unless is allready set.)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:12:\"imgMapExtras\";s:8:\"datatype\";s:20:\"&lt;area...&gt;-tags\";s:11:\"description\";s:43:\"Extra &lt;area...&gt;tags for the image-map\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:21:\"debugRenumberedObject\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:104:\"if set, the final GIFBUILDER object configuration is output in order for you to debug your configuration\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (238,270,'cdccc471d5b78c74bb04998ced50107c','','tsref:(cObject).HMENU.(mObj).IMGMENUITEM','a:1:{s:4:\"rows\";a:1:{i:0;a:6:{s:8:\"property\";s:10:\"1,2,3,4...\";s:8:\"datatype\";s:18:\"-&gt;GifBuilderObj\";s:11:\"description\";s:2039:\"<b>NOTE:</b>\nThe way a imagemap is made is this; All IMGMENUITEMS are included in one big Gifbuilderobj (and renumbered!!). Because of this, Gifbuilderobjects on the next level will not be able to access the data of each menuitem.\nAlso the feature of using [##.w] and [##.h] with +calc is currently not supported by IMGMENUITEMs.\nTherefore all IMAGE-objects on the first level is checked; if &quot;file&quot; or &quot;mask&quot; for any IMAGE-objects are set to &quot;GIFBUILDER&quot;, the Gifbuilder-object is parsed to see if any TEXT-objects are present and if so, the TEXT-object is &quot;checked&quot; - which means, that the stdWrap-function is called at a time where the $cObj-&gt;data-array is set to the actual menuitem.\nIn the example below, the text of each menuitem is rendered by letting the title be rendered on a mask instead of directly on the image. Please observe that the &quot;NO.10&quot;-object is present in order for the image-map coordinates to be generated!!\n&nbsp;\n&nbsp;&nbsp;NO.6 = IMAGE\n&nbsp;&nbsp;NO.6.file = masked_pencolor*.gif\n&nbsp;&nbsp;NO.6.mask = GIFBUILDER\n&nbsp;&nbsp;NO.6.mask {\n&nbsp;&nbsp;&nbsp;&nbsp;XY = 500, 200\n&nbsp;&nbsp;&nbsp;&nbsp;backColor = black\n&nbsp;&nbsp;&nbsp;&nbsp;10 = TEXT\n&nbsp;&nbsp;&nbsp;&nbsp;10 {\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;text.field = title\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;fontFile = fileadmin/fonts/caflisch.ttf\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;fontSize = 34\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;fontColor = white\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;angle = 15\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;offset = 48,110\n&nbsp;&nbsp;&nbsp;&nbsp;}\n&nbsp;&nbsp;&nbsp;&nbsp;20 = EFFECT\n&nbsp;&nbsp;&nbsp;&nbsp;20.value = blur=80\n&nbsp;&nbsp;}\n&nbsp;&nbsp;NO.10 = TEXT\n&nbsp;&nbsp;NO.10 {\n&nbsp;&nbsp;&nbsp;&nbsp;text.field = title\n&nbsp;&nbsp;&nbsp;&nbsp;fontFile = fileadmin/fonts/caflisch.ttf\n&nbsp;&nbsp;&nbsp;&nbsp;fontSize = 34\n&nbsp;&nbsp;&nbsp;&nbsp;angle = 15\n&nbsp;&nbsp;&nbsp;&nbsp;offset = 48,110\n&nbsp;&nbsp;&nbsp;&nbsp;hideButCreateMap = 1\n&nbsp;&nbsp;}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (239,270,'2cdd9060dcb2633b93d2a58448f1323e','','tsref:(cObject).HMENU.(mObj).JSMENU','a:1:{s:4:\"rows\";a:9:{i:0;a:6:{s:8:\"property\";s:6:\"levels\";s:8:\"datatype\";s:8:\"int, 1-5\";s:11:\"description\";s:25:\"How many levels there are\";s:7:\"default\";s:1:\"1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:8:\"menuName\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:107:\"JavaScript menu name.\nIf you have more than one JSMENU on the page, you should set this value for each one.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:6:\"target\";s:11:\"description\";s:32:\"Decides target of the menu-links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:14:\"forceTypeValue\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:89:\"If set, the &amp;type parameter of the link is forced to this value regardless of target.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:10:\"1,2,3,4...\";s:8:\"datatype\";s:10:\"JSMENUITEM\";s:11:\"description\";s:13:\"levels-config\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:30:\"wrap around the selector-boxes\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:13:\"wrapAfterTags\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:66:\"wrap around the selector-boxes with wrap and form-tags og JS-code.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:17:\"firstLabelGeneral\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:71:\"General firstlabel. May be overridden by the one set in each JSMENUITEM\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:3:\"SPC\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:46:\"If set, spacer can go into the menu, else not.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (233,270,'4dc41beb0a0c7f6d2677ea2814984821','','tsref:(cObject).HMENU.(mObj).GMENU_LAYERS, (cObject).HMENU.(mObj).TMENU_LAYERS','a:1:{s:4:\"rows\";a:23:{i:0;a:6:{s:8:\"property\";s:10:\"layerStyle\";s:8:\"datatype\";s:22:\"&lt;DIV&gt;-tag params\";s:11:\"description\";s:166:\"Parameters for the &lt;DIV&gt;-layer-tags in the HTML-document. You might probably not need change this.\n&nbsp;\n<b>Example:</b>\nposition:absolute; VISIBILITY: hidden;\";s:7:\"default\";s:38:\"position:absolute; visibility: hidden;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:12:\"lockPosition\";s:8:\"datatype\";s:44:\"&quot;x&quot; / &quot;y&quot; / &quot;&quot;\";s:11:\"description\";s:435:\"If this is set to &quot;x&quot; or &quot;y&quot; the menu on the layers is locked and does not follow the mouse-cursor (which it does if this is not set).\n&quot;x&quot; or &quot;y&quot; defines respectively that the summed width (x) or height (y) is added to the x or y offset of the menu. That means that you should set this value to &quot;x&quot; if you have a horizontal GMENU_LAYERS and to &quot;y&quot; if you have a verical menu.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:15:\"dontFollowMouse\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:404:\"If set and lockPosition is blank (so that the menu layer follows the mouse) then the menu will NOT follow the mouse but still it will appear where the mouse cursor hit the trigger-element. Usefull if you don\'t know the exact positions of elements.\n&nbsp;\n<b>Warning:</b> You should not set displayActiveOnLoad for menus with this feature enabled (because the absolute position of the layer is not known).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:19:\"lockPosition_adjust\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:159:\"A number which is added to the width/height of the menuitems in order &nbsp;to compensate for eg. hspace or other things between the images in the GMENU_LAYERS\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:20:\"lockPosition_addSelf\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:302:\"Normally the width and height of the items (+lockPosition_adjust) are summed up after the item has been rendered. This is good if the direction of the menulayers is right- og downwards.\nBut if you use directionLeft/directionUp, you might want to add the width of the items before.\nIf so, set this flag.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:10:\"xPosOffset\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:149:\"The offset of the menu from the point where it\'s &quot;activated&quot; (if lockPosition is false) / from topleft page corner (if lockPosition is set)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:10:\"yPosOffset\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:34:\"As above, but for the y-dimension.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:9:\"topOffset\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:207:\"The offset of menuitems from top of browser. Should be set rather than defining it in the .layerStyle property. Must be set in order to use directionUp.\nUsed with either lockPosition=x or xPosOffset defined.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:10:\"leftOffset\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:217:\"The offset of menuitems from left border of browser. Should be set rather than defining it in the .layerStyle property. Must be set in order to use directionLeft.\nUsed with either lockPosition=y or yPosOffset defined.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:15:\"blankStrEqFalse\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:300:\"If set, then the properties topOffset,leftOffset, xPosOffset, yPosOffset are considered &quot;blank&quot; if they are really blank strings - not just &quot;zero&quot;. You should enable this if you wish to be able to work with zero offsets. This is typically the case if you use relative positioning.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:13:\"directionLeft\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:276:\"Set this, if you want the items to be right-aligned (pop\'s out towards the left).\nDoes not work with Opera at this time because I don\'t know how to make Opera read the width of each layer.\nIf you set the width of the menu-layers in .layerStyles this might work no matter what.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:11:\"directionUp\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:94:\"Set this, if you want the items to be bottom-aligned (pop\'s out upwards instead of downwards).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:13:\"setFixedWidth\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:910:\"For GMENU_LAYERS the width and heights of the element is normally known from the graphical item. For TMENU_LAYERS this cannot be known in the same way. Therefore you can use .setFixedWidth and .setFixedHeight to set these values to a number you find reasonable. Of course this may be blasted by the browsers rendering if the font gets out of proportions etc.\nAlternatively you may want to use the property &quot;relativeToTriggerItem&quot; which will position your menu layers relative to the item you roll over. This has some drawbacks though. A middle solution is to use a menu with lockPosition set to blank and dontFollowMouse set to true. Then you need only specify either an x or y coordinate to follow and the item will appear where the mouse hits the element.\n<b>Notice:</b> Active if value is NOT a blank str. Setting this value to zero means that no width is calculated for the items in GMENU_LAYERS.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:14:\"setFixedHeight\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:52:\"See &quot;setFixedWidth&quot;. Same, but for height.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:13:\"bordersWithin\";s:8:\"datatype\";s:11:\"l,t,r,b,l,t\";s:11:\"description\";s:159:\"Keep borders of the layer within these limits in pixels. Zero is \'not set\'\n(Syntax: List of integers, evaluated clockwise: Left, Top, Right, Bottom, Left, Top)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:19:\"displayActiveOnLoad\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:587:\"If set, the submenu-layer of the active menuitem is opened at page-load. If .freezeMouseover is also set and there is RO defined for the main menu items, the menuitem belonging to the displayed submenu is also shown.\n&nbsp;\n<b>Properties:</b>\n.onlyOnLoad (boolean)\nIf set, then the display of the active item will happen only when the page is loaded. The display will not be restored on mouseout of other items.\n&nbsp;\n<b>Warning: If you are cascading GMENU_LAYER objects make sure that all elements before this element (for which you set this attribute) also has this attribute set!</b>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:15:\"freezeMouseover\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:285:\"If set, any mouseout effect of main menuitems is removed not on roll-out but when another element is rolled over (or the layer is hidden/default layer restored)\n&nbsp;\n<b>Properties:</b>\n.alwaysKeep (boolean)\nIf set, the freezed element will always stay, even if the submenu is hidden.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:19:\"hideMenuWhenNotOver\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:267:\"If set (&gt; 1) then the menu will hide it self whenever a user moves the cursor away from the menu. The value of this parameter determines the width (pixels) of the zone around the element until the mousepointer is considered to be far enough away to hide the layer.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:13:\"hideMenuTimer\";s:8:\"datatype\";s:4:\"int+\";s:11:\"description\";s:112:\"This is the number of milliseconds to wait before the submenu will disappear if hideMenuWhenNotOver &nbsp;is set\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:17:\"dontHideOnMouseUp\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:135:\"If set, the menu will not hide it\'s layers when the mouse botton is clicked. Usefull if your menuitems loads the pages in another frame\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:13:\"layer_menu_id\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:187:\"If you want to specifically name a menu on a page. Probably you don\'t need that!\n&nbsp;\n<b>Warning:</b> Don\'t use underscore and special characters in this string. Stick to alpha-numeric.\";s:7:\"default\";s:26:\"[random 6 char hashstring]\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:21:\"relativeToTriggerItem\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:1205:\"This allows you to position the menu layers relative to the item that triggers it. However you should be aware of the following facts:\nThis does not work with Netscape 4 - the position of the trigger layer will be calculated to zero and thus the offset for all menu layers will be 0,0 + your values.\nThis feature will wrap the menu item in some &lt;div&gt;-tags right before the whole item is wrapped by the .wrap code (for GMENU_LAYERS) or .allWrap (for TMENU_LAYERS). The bottom line of this is: 1) If your menu is horizontal, always wrap your menu items in a table so linebreaks does not appear because of the &lt;div&gt;-tags and 2) make sure the wrapping of the table cell is done with the .wrap/.allWrap properties respectively.\nWorks only effectively on the first xMENU_LAYER in a cascade. For succeeding xMENU_LAYERS items please use &quot;relativeToParentLayer&quot;.\n<i>If set, properties xPosOffset, yPosOffset and lockPosition* are not functional (properties directionLeft, directionUp, topOffset and leftOffset are still active)</i>\n<i>&nbsp;</i>\n<b>Additional Properties:</b>\n<b>.addWidth</b> = Adds the width of the trigger element\n<b>.addHeight</b> = Adds the height of the trigger element\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:21:\"relativeToParentLayer\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:519:\"If set, then the layer will be positioned relative to the previous layer (parent) in a cascaded series of xMENU_LAYERS. Basically the relative position of the parent layer is just added to the offset of the current menu.\n&nbsp;\n<b>Warning:</b> This property makes sense only if there really is a previous GMENU_LAYER to get position from! So you must have a cascaded menu!\n&nbsp;\n<b>Additional Properties:</b>\n<b>.addWidth</b> = Adds the width of the parent layer\n<b>.addHeight</b> = Adds the height of the parent layer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (234,270,'cc7479b256282161af55c3137ffe98ec','','tsref:(cObject).HMENU.(mObj).GMENU_FOLDOUT','a:1:{s:4:\"rows\";a:17:{i:0;a:6:{s:8:\"property\";s:17:\"dontLinkIfSubmenu\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:110:\"If set, items that has a submenu is not linked. Items without a submenu are always linked in the regular ways.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:9:\"foldTimer\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:53:\"The timeout in the animation, these are milliseconds.\";s:7:\"default\";s:2:\"40\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:9:\"foldSpeed\";s:8:\"datatype\";s:16:\"int, range 1-100\";s:11:\"description\";s:58:\"How many steps in an animation? Choose 1 for no animation.\";s:7:\"default\";s:1:\"1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"stayFolded\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:49:\"Stay open when you click a new toplink? (Level 1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:12:\"bottomHeight\";s:8:\"datatype\";s:11:\"int, pixels\";s:11:\"description\";s:153:\"Sets the height of the bottom layer. Is important if the bottomlayer &nbsp;contains either content or a background color: Else the layer will be clipped.\";s:7:\"default\";s:3:\"100\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:9:\"menuWidth\";s:8:\"datatype\";s:11:\"int, pixels\";s:11:\"description\";s:174:\"Width of the whole menu main layer. Important to set, especially for the bottomlayer as it is clipped by this value. Always try to set this to the width in pixels of the menu\";s:7:\"default\";s:3:\"170\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:10:\"menuHeight\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:60:\"Height of the whole menulayer. Seems to be not so important.\";s:7:\"default\";s:3:\"400\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:13:\"subMenuOffset\";s:8:\"datatype\";s:3:\"x,y\";s:11:\"description\";s:150:\"Offset of the submenu for each menuitem. This is important because if you don\'t set this value the items will appear ontop of their &quot;parent&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:10:\"menuOffset\";s:8:\"datatype\";s:3:\"x,y\";s:11:\"description\";s:64:\"Offset of the menu main layer on the page. From upperleft corner\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:13:\"menuBackColor\";s:8:\"datatype\";s:10:\"HTML-color\";s:11:\"description\";s:158:\"Background color behind menu. If not set, transparent (which will not work very well in case .foldSpeed is set to something else than 1. But see for yourself)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:15:\"dontWrapInTable\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:461:\"By default every menuitem on the first level is wrapped in a table:\n&lt;TABLE cellSpacing=0 cellPadding=0 width=&quot;100%&quot; border=0&gt;&lt;TR&gt;&lt;TD&gt;\n[menu item HTML here..]\n&lt;/TD&gt;&lt;/TR&gt;&lt;/TABLE&gt;\nDoing this ensures that the layers renders equally in the supported browsers. However you might need to disable that which is what you can do by setting this flag.\n<b>Note:</b> Using &lt;TBODY&gt; in this tables seems to break Netscape 4+\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:13:\"bottomContent\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:61:\"Content for the bottom layer that covers the end of the menu.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:12:\"adjustItemsH\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:192:\"Adjusts the height calculation of the menulayers of the first level (called Top)\n&nbsp;\n<b>Example:</b>\n&nbsp;\nThis value will substract 10 pixels from the height of the layer in calculations.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:15:\"adjustSubItemsH\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:101:\"Adjusts the height calculation of the menulayers of the second level (subitems, called Sub)\nSee above\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:16:\"arrowNO\narrowACT\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:396:\"If both arrowNO and arrowACT is defined and valid imgResources then these images are use as &quot;traditional arrows&quot; that indicates whether an item is expanded (active) or not.\nNO is normal, ACT is expanded\nThe image is inserted just before the menuitem. If you want to change the position, put the marker ###ARROW_IMAGE### into the wrap of the item and the image will be put there instead.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:14:\"arrowImgParams\";s:8:\"datatype\";s:18:\"&lt;img&gt; params\";s:11:\"description\";s:53:\"Parameters to the arrow-image.\n&nbsp;\n<b>Example:</b>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:19:\"displayActiveOnLoad\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:67:\"If set, then the active menu items will fold out &quot;onLoad&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (159,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (196,270,'698298181be68b56fd0361e9da1a114f','','tsref:(cObject).CLEARGIF','a:1:{s:4:\"rows\";a:3:{i:0;a:6:{s:8:\"property\";s:6:\"height\";s:8:\"datatype\";s:33:\"&lt;img&gt;-data:height / stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:1:\"1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:5:\"width\";s:8:\"datatype\";s:32:\"&lt;img&gt;-data:width / stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:1:\"1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:18:\"&nbsp;| &lt;BR&gt;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (197,270,'0f2fee21aca2929d02f2ede163104d2b','','tsref:(cObject).CONTENT','a:1:{s:4:\"rows\";a:5:{i:0;a:6:{s:8:\"property\";s:6:\"select\";s:8:\"datatype\";s:11:\"-&gt;select\";s:11:\"description\";s:30:\"The SQL-statement is set here!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:5:\"table\";s:8:\"datatype\";s:16:\"<i>tableName</i>\";s:11:\"description\";s:283:\"The table, the content should come from.\nIn standard-configurations this will be &quot;tt_content&quot;\n<b>NOTE:</b> Only tables allowed are &quot;pages&quot; or tables prefixed with one of these: &quot;tt_&quot;, &quot;tx_&quot;, &quot;ttx_&quot;, &quot;fe_&quot;, &quot;user_&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:9:\"renderObj\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:16:\"&lt; [tablename]\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:31:\"Wrap the whole content-story...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (198,270,'fda9a1413332096fac6ed5a6f0f8ce90','','tsref:(cObject).RECORDS','a:1:{s:4:\"rows\";a:5:{i:0;a:6:{s:8:\"property\";s:6:\"source\";s:8:\"datatype\";s:29:\"<i>records-list </i>/ stdWrap\";s:11:\"description\";s:112:\"List of record-id\'s, optionally with appended table-names.\n&nbsp;\n<b>Example:</b>\ntt_content_34, 45, tt_links_56\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:6:\"tables\";s:8:\"datatype\";s:6:\"list /\";s:11:\"description\";s:432:\"List of accepted tables. If any items in the &quot;.source&quot;-list is not prepended with a tablename, the first table in this list is assumed to be the table for such records.\nAlso tablenames configured in .conf is allowed.\n&nbsp;\n<b>Example:</b>\ntables = tt_content, tt_address, tt_links\nconf.tx_myexttable = TEXT\nconf.tx_myexttable.value = Hello world\n&nbsp;\nThis adds the tables tt_content, tt_address, tt_links, tx_myexttable\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:16:\"conf.[tablename]\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:62:\"Config-array which renders records from table <i>tablename</i>\";s:7:\"default\";s:131:\"If this is NOT defined, the rendering of the records is done with the toplevel-object [tablename] - just like the cObject, CONTENT!\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:12:\"dontCheckPid\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:136:\"Normally a record cannot be selected, if it\'s parent page (pid) is not accessible for the website user. This option disables that check.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (199,270,'58494541fb84e7f9f04a7222619963cf','','tsref:(cObject).HMENU','a:1:{s:4:\"rows\";a:11:{i:0;a:6:{s:8:\"property\";s:16:\"(1 / 2 / 3 /...)\";s:8:\"datatype\";s:7:\"menuObj\";s:11:\"description\";s:247:\"<b>Required!</b>\nDefines which menuObj that should render the menuitems on the various levels.\n1 is the first level, 2 is the second level, 3 is the third level, 4 is ....\n&nbsp;\n<b>Example:</b>\ntemp.sidemenu = HMENU\ntemp.sidemenu.1 = GMENU &nbsp;\";s:7:\"default\";s:15:\"&nbsp;(no menu)\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:10:\"entryLevel\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:351:\"Defines at which level in the rootLine, the menu should start.\nDefault is &quot;0&quot; which gives us a menu of the very first pages on the site.\nIf the value is &lt; 0, entryLevel is chosen from &quot;behind&quot; in the rootLine. Thus &quot;-1&quot; is a menu with items from the outermost level, &quot;-2&quot; is the level before the outermost...\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:7:\"special\";s:8:\"datatype\";s:136:\"<i>&quot;directory&quot; / &quot;list&quot; / &quot;updated&quot; / &quot;browse&quot; / &quot;rootline&quot; / &quot;keywords&quot;</i>\";s:11:\"description\";s:26:\"(See separate table below)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:13:\"special.value\";s:8:\"datatype\";s:28:\"list of page-uid\'s / stdWrap\";s:11:\"description\";s:9:\"See above\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:8:\"minItems\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:162:\"The minimum items in the menu. If the number of pages does not reach this level, a dummy-page with the title &quot;...&quot; and uid=[currentpage_id] is inserted.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:8:\"maxItems\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:58:\"The maximum items in the menu. More items will be ignored.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:14:\"excludeUidList\";s:8:\"datatype\";s:11:\"list of int\";s:11:\"description\";s:181:\"This is a list of page uid\'s to exclude when the select statement is done. Comma-separated.\n&nbsp;\n<b>Example:</b>\nThe pages with these uid-number will NOT be within the menu!!\n34,2\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:5:\"begin\";s:8:\"datatype\";s:9:\"int +calc\";s:11:\"description\";s:170:\"The first item in the menu.\n&nbsp;\n<b>Example:</b>\nThis results in a menu, where the first two items are skipped starting with item number 3:\n&nbsp;&nbsp;begin = 3 &nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:2:\"if\";s:8:\"datatype\";s:7:\"-&gt;if\";s:11:\"description\";s:58:\"If &quot;if&quot; returns false, the menu is not generated\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (200,270,'cd830eb4ea8346e958afc812a860ed75','','tsref:(cObject).HMENU.special','a:1:{s:4:\"rows\";a:8:{i:0;a:5:{s:8:\"property\";s:9:\"directory\";s:8:\"datatype\";s:390:\"This will generate a menu of all pages with pid = 35 and pid = 56.\n&nbsp;&nbsp;20 = HMENU\n&nbsp;&nbsp;20.special = directory\n&nbsp;&nbsp;20.special.value = 35, 56\n&nbsp;\nIf .value is not set, the default pid is the current page.\n&nbsp;\n<b>Notice:</b>\nIf you specify a pid of a mount-point page, then the mounted pids content will be displayed! So this function here IS aware of mountpoints.\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;}i:1;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:232:\"This will generate a menu with the two pages (uid=35 and uid=36) listed:\n&nbsp;&nbsp;20 = HMENU\n&nbsp;&nbsp;20.special = list\n&nbsp;&nbsp;20.special.value = 35, 56\n&nbsp;\nIf .value is not set, the default uid is the .entryLevel uid.\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;}i:2;a:5:{s:8:\"property\";s:7:\"updated\";s:8:\"datatype\";s:2583:\"This will generate a menu of the most recently updated pages from the branches in the tree starting with the uid\'s (uid=35 and uid=36) listed. Furthermore the field &quot;tstamp&quot; is used (default is SYS_LASTCHANGED) and the treedepth is 2 levels. Also there will be shown a maximum of 8 pages and they must have been updated within the last three days (3600*24*3):\n&nbsp;&nbsp;20 = HMENU\n&nbsp;&nbsp;20.special = updated\n&nbsp;&nbsp;20.special.value = 35, 56\n&nbsp;&nbsp;20.special {\n&nbsp;&nbsp;&nbsp;&nbsp;mode = tstamp\n&nbsp;&nbsp;&nbsp;&nbsp;depth = 2\n&nbsp;&nbsp;&nbsp;&nbsp;maxAge = 3600*24*3\n&nbsp;&nbsp;&nbsp;&nbsp;limit = 8\n&nbsp;&nbsp;}\n&nbsp;\n<b>Ordering </b>is by default done in reverse order (desc) with the field specified by &quot;mode&quot; , but setting &quot;alternativeSortingField&quot; for the menu object (eg GMENU, see later) will override that.\nProperties &quot;mode&quot;, &quot;depth&quot;, &quot;maxAge&quot; and &quot;limit&quot; is only used with special=&quot;updated&quot;.\n<b>mode:</b> Which field in the pages-table to use. Default is &quot;SYS_LASTCHANGED&quot; (which is updated when a page is generated to the youngest tstamp of the records on the page), &quot;<u>manual</u>&quot; or &quot;<u>lastUpdated</u>&quot; will use the field &quot;lastUpdated&quot; (set manually in the page-record) and &quot;<u>tstamp</u>&quot; will use the &quot;tstamp&quot;-field of the pagerecord, which is set automatically when the record is changed. &quot;<u>crdate</u>&quot; will use &quot;crdate&quot;-field of the pagerecord. &quot;<u>starttime</u>&quot; will use the starttime field.\nFields with zero value is not selected anyway.\n<b>depth:</b> By default (if the value is not an integer) the depth is 20 levels. The range is 1-20. A depth of 1 means only the start id, depth of 2 means start-id + first level. NOTE: depth is relative to beginAtLevel.\n<b>beginAtLevel</b>: &nbsp;Integer. Determines starting level for the pagetrees generated based on .value and .depth. Zero is default and includes the start id. 1=starts with the first row of subpages, 2=starts with the second row of subpages. Depth is relative to this starting point.\n<b>maxAge:</b> Seconds+calc. &nbsp;Pages with update-dates older than currenttime minus this number of seconds will not be shown in the menu no matter what. Default is &quot;not used&quot;. You may use +-*/ for calculations.\n<b>limit:</b> Max number of items in the menu. Default is 10, max is 100.\n<b>excludeNoSearchPages:</b> Boolean. If set, pages marked &quot;No search&quot; is not included into special-menus.\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;}i:3;a:5:{s:8:\"property\";s:8:\"rootline\";s:8:\"datatype\";s:775:\"Creates a menu with pages from the &quot;rootline&quot; (see earlier in this reference)\n<b>.range</b> = [begin-level] | [end-level] (same way as you reference the .entryLevel for HMENU)\n<b>.target_[0-x]</b> &nbsp;targets\n&nbsp;\nThis...\n&nbsp;\npage.2 = HMENU\npage.2.special = rootline\npage.2.special.range = 1|-2\npage.2.special.targets.3 = page\npage.2.1 = TMENU\npage.2.1.target = _top\npage.2.1.wrap = &lt;HR&gt; | &lt;HR&gt;\npage.2.1.NO {\n&nbsp;&nbsp;linkWrap = | &gt;\n}\n&nbsp;\n... creates a menu like this:\n<b>Page level 1 &gt; Page level 2 &gt; Page level 3 &gt; Page level 4 &gt;</b>\n(The menu starts at level 1 and does NOT link to the current page (-2 is the level before). Further all pages on level 3 will have &quot;page&quot; as target and all other &quot;_top&quot;)\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;}i:4;a:5:{s:8:\"property\";s:6:\"browse\";s:8:\"datatype\";s:3243:\"This kind of menu is built of items given by a list from the property &quot;.item&quot;. Each element in the list (sep. by &quot;|&quot;) is either a reserved itemname (see list) with a predefined function or a userdefined name which you can assign a link to any page. Note that the current page cannot be the root-page of a site.\n&nbsp;\nMain properties:\n<b>.items </b>&nbsp;( &quot;|&quot; separated list of &quot;itemnames&quot;)\n<b>.[itemnames].target </b>&nbsp;(target) - optional/alternative target of the item\n<b>.[itemnames].uid </b>&nbsp;(uid of page) - optional/alternative page-uid to link to\n<b>.[itemnames].fields.[fieldname]</b> &nbsp;(string) - override field &quot;fieldname&quot; in pagerecord.\n<b>.prevnextToSection (boolean)</b> - if set, the &quot;prev&quot; and &quot;next&quot; navigation will jump to the next section when it reaches the end of pages in the current section\n<b>.value</b> (page-uid) - default is current page id. Seldomly you might want to override this value with another page-uid which will then act as the basepoint for the menu and the predefined items.\n<b>Ordering </b>is by default done in reverse order (desc) with the field specified by &quot;mode&quot; , but setting &quot;alternativeSortingField&quot; for the menu object (eg GMENU, see later) will override that.\n<i>Reserved itemnames:</i>\n<b>next</b> / <b>prev</b> : links to next page / previous page. Next and previous pages are from the same &quot;pid&quot; as the current page id (or &quot;value&quot;) - that is the next item in a menu with the current page. Also referred to as current level. \nIf &quot;.prevnextToSection&quot; is set then next/prev will link to the first page of next section / last page of previous section.\n<b>nextsection</b> / <b>prevsection</b> : links to next section / previous section. A section is defined as the subpages of a page on the same level as the parent (pid) page of the current page. Will not work if parent page of current page is the root page of the site.\n<b>nextsection_last</b> | <b>prevsection_last</b>: Where nextsection/prevsection links to the first page in a section, these links to the last pages. If there is only one page in the section that will be both first and last. Will not work if parent page of current page is the root page of the site.\n<b>first</b> / <b>last </b>: First / Last page on current level. If there is only one page on the current level that page will be both first and last.\n<b>up</b> : Links to the parent (pid) page of the current page. (up 1 level) Will always be available\n<b>index </b>: Links to the parent of the parent page of the current page (up 2 levels). May not be available if that page is out of the rootline.\n&nbsp;\n<b>Examples:</b>\nIf id=20 is current page then:\n21= prev and first, 19 = next, 18 = last, 17 = up, 1=index, 10 = nextsection, 11 = nextsection_last\nprevsection and prevsection_last is not present because id=3 has no subpages!\n&nbsp;\n<b>TypoScript (only &quot;browse&quot;-part, needs also TMENU/GMENU):</b>\nxxx = HMENU\nxxx.special = browse\nxxx.special {\n&nbsp;&nbsp;items = index|up|next|prev\n&nbsp;&nbsp;items.prevnextToSection = 1\n&nbsp;&nbsp;index.target = _blank\n&nbsp;&nbsp;index.fields.title = INDEX\n&nbsp;&nbsp;index.uid = 8\n}\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;}i:5;a:5:{s:8:\"property\";s:8:\"keywords\";s:8:\"datatype\";s:1656:\"Makes a menu of pages with one or more keywords also found on the current page.\n<b>.value </b>= page for which keywords to find similar pages.\n<b>.mode:</b> Which field in the pages-table to use for sorting. Default is &quot;SYS_LASTCHANGED&quot; (which is updated when a page is generated to the youngest tstamp of the records on the page), &quot;<u>manual</u>&quot; or &quot;<u>lastUpdated</u>&quot; will use the field &quot;lastUpdated&quot; (set manually in the page-record) and &quot;<u>tstamp</u>&quot; will use the &quot;tstamp&quot;-field of the pagerecord, which is set automatically when the record is changed. &quot;<u>crdate</u>&quot; will use &quot;crdate&quot;-field of the pagerecord. &quot;<u>starttime</u>&quot; will use the starttime field.\n<b>.entryLevel </b>= where in the rootline the search begins. Standard rootline syntax (-x to x)\n<b>.depth, .limit, .excludeNoSearchPages, .beginAtLevel </b>(like &quot;updated&quot; menu)\n<b>.setKeywords (+stdWrap) = lets you define the keywords manually by defining them as a commaseparated list. If this property is defined, it overrides the default, which is the keywords of the current page.</b>\n<b>.keywordsField</b> = defines the field in the pages-table in which to search for the keywords. Default is the fieldname &quot;keyword&quot;. No check is done to see if the field you enter here exists, so enter an existing field, OK?!\n<b>.keywordsField.sourceField</b> = defines the field from the current page from which to take the keywords being matched. The default is &quot;keyword&quot;. (Notice that &quot;.keywordsField&quot; is only setting the page-record field to <i>search in</i> !)\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;}i:6;a:5:{s:8:\"property\";s:11:\"userdefined\";s:8:\"datatype\";s:1173:\"Lets you write your own little PHP-script that generates the array of menuitems.\n<b>.file</b> &nbsp;[resource] &nbsp;= &nbsp;filename of the php-file to include. (Just like cObject PHP_SCRIPT)\n<b>.[any other key]</b> = your own variables to your script. They are all accessible in the array $conf in your script\n&nbsp;\n<b>Howto:</b>\nYou must populate an array called $menuItemsArray with page-records of the menuitems you want to be in the menu.\nIt goes like this:\n&nbsp;\n$menuItemsArray[] = pageRow1;\n$menuItemsArray[] = pageRow2;\n$menuItemsArray[] = pageRow3;\n...\n&nbsp;\nA &quot;pageRow&quot; is a record from the table &quot;pages&quot; with all fields selected (SELECT * FROM...)\n&nbsp;\n<b>Notice:</b>\nIf you work with mount-points you can set the MP param which should be set for the page by setting the internal field &quot;_MP_PARAM&quot; in the page-record (xxx-xxx).\n&nbsp;\n<b>Presetting element state</b>\nIf you would like to preset an element to be recognized as a SPC, IFSUB, ACT, CUR or USR mode item, you can do so by specifying one of these values in the key &quot;ITEM_STATE&quot; of the page record. This setting will override the natural state-evaluation.\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;}i:7;a:5:{s:8:\"property\";s:12:\"userfunction\";s:8:\"datatype\";s:171:\"Calls a user function/method in class which should (as with &quot;userdefined&quot; above) return an array with page records for the menu.\n<b>.userFunc</b> = function-name\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (252,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:28:{i:0;a:6:{s:8:\"property\";s:7:\"siteUrl\";s:8:\"datatype\";s:3:\"url\";s:11:\"description\";s:16:\"Url of the site.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:13:\"defaultOutput\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:40:\"Default output if CType is not rendered.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:14:\"uploads.header\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:18:\"Header for uploads\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:13:\"images.header\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:17:\"Header for images\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:20:\"images.captionHeader\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:24:\"Header for imagecaptions\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:17:\"images.linkPrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:22:\"Prefix for image-links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:7:\".header\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:11:\"defaultType\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:28:\"Which type to use as default\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:4:\"date\";s:8:\"datatype\";s:11:\"date-config\";s:11:\"description\";s:15:\"For header date\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:10:\"datePrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:22:\"Prefix for header date\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:10:\"linkPrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:23:\"Prefix for header links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:16:\"[1-5].preLineLen\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:28:\"Lenght of line before header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:17:\"[1-5].postLineLen\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:27:\"Lenght of line after header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:15:\"[1-5].preBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:35:\"Number of blank lines before header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:16:\"[1-5].postBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:34:\"Number of blank lines after header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:13:\"[1-5].stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:15:\"for header text\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:17:\"[1-5].preLineChar\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:21:\"Character to pre-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:18:\"[1-5].postLineChar\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:22:\"Character to post-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:19:\"[1-5].preLineBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:49:\"Number of blank lines between header and pre-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:20:\"[1-5].postLineBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:50:\"Number of blank lines between header and post-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:16:\"[1-5].autonumber\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:111:\"If set, a number is prepended every header. The number corresponds to the content element number in the select.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:12:\"[1-5].prefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:20:\"Header string prefix\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:23:\"bulletlist.[0-3].bullet\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:36:\"Bullet for bullet list, layout [0-3]\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:26:\"bulletlist.[0-3].secondRow\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:65:\"If set, this is used for lines on the second row of bullet-lists.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:4:\"menu\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:137:\"cObject to render menu. The output is stripped for tags and the links is extracted. Further all &lt;BR&gt; chars are converted to chr(10)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:8:\"shortcut\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:129:\"cObject to render other elements. See config below which simply uses this object to render more tt_content elements as plaintext.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:16:\"bodytext.stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:48:\"stdWrap for body-text. See config example below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:8:\"userProc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:195:\"Lets you proces the output of each content element before it finally is returned. Property &quot;parentObj&quot; of the conf-array holds a references to the plainText object calling the function.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (158,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (168,270,'b8cdfb94d3ca017302441c76329dc8bb','','tsref:-&gt;typolink','a:1:{s:4:\"rows\";a:11:{i:0;a:6:{s:8:\"property\";s:9:\"extTarget\";s:8:\"datatype\";s:15:\"target /stdWrap\";s:11:\"description\";s:30:\"target used for external links\";s:7:\"default\";s:4:\"_top\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:15:\"target /stdWrap\";s:11:\"description\";s:30:\"target used for internal links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:8:\"no_cache\";s:8:\"datatype\";s:16:\"boolean /stdWrap\";s:11:\"description\";s:56:\"Adds a &quot;&amp;no_cache=1&quot;-parameter to the link\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:12:\"useCacheHash\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:522:\"If set, the additionalParams list is exploded and calculated into a hashstring appended to the url, like &quot;&amp;cHash=ae83fd7s87&quot;. When the caching mechanism sees this value, it calculates the same value on the server based on incoming values in HTTP_GET_VARS, excluding id,type,no_cache,ftu,cHash values. If the incoming cHash value matches the calculated value, the page may be cached based on this.\nThe [SYS][encryptionKey] is included in the hash in order to make it unique for the server and non-predictable.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:16:\"additionalParams\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:499:\"This is parameters that are added to the end of the url. This must be code ready to insert after the last parameter.\n&nbsp;\n<b>Example:</b>\n\'&amp;print=1\'\n\'&amp;sword_list[]=word1&amp;sword_list[]=word2\'\n&nbsp;\n<b>Applications:</b>\nThis is very useful when linking to pages from a searchresult. The searchwords are stored in the register-key SWORD_PARAMS and can be insert directly like this:\n.additionalParams.data = register:SWORD_PARAMS\n&nbsp;\n<b>NOTE:</b> This is only active for internal links!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:16:\"Wraps the links.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:14:\"ATagBeforeWrap\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:91:\"If set, the link is first wrapped with &quot;<i>.wrap&quot;</i> and then the &lt;A&gt;-tag.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:9:\"parameter\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:2777:\"This is the data, that -&gt;typolink uses to create the link. The value is trimmed and if it\'s empty, -&gt;typolink returns the input value untouched.\n&nbsp;\n<b>NOTE:</b> If used from parseFunc, this value should be imported by:\ntypolink.parameter.data = parameters : allParams\n&nbsp;\n<b>Examples:</b>\nInternal links:\nintegers (51): creates a link to page with uid = 51\nfilerefs (fileadmin/somedir/thedoc.html): creates a link to the file on the local server.\nstrings (some_alias): &nbsp;creates a link to the page with alias = &quot;some_alias&quot;\n&nbsp;\nExternal links:\nemail-adresses (name@email.com): creates a link to the email-addr.\ndomains (www.domain.com): creates link to http://-page\n&nbsp;\n<b>The input is parsed like this:</b>\nFirst the parameter is split by character-space. This provides a way to pass more parameters. See &quot;target&quot; below here.\nIf a &quot;@&quot; is in the string, it\'s an email\nIf a period (.) is in the string AND if the period (.) is found before a slash (/) is found OR if a doubleslash is found, then it\'s a URL\nIf a slash (/) is found, it\'s a filereference. If the file/directory does not exist on the server, the link is NOT made!\n&nbsp;\nNow the input can be an alias or page-id. If the input is an integer it\'s a page-id, if it\'s two comma separated integers, it\'s a id/type pair, else it\'s an alias. For page-id\'s or aliases you can prepend a &quot;#&quot; mark with a number indication tt_content record number on the page to jump to! (if .section-property is present, it overrides this).\nIf you insert only &quot;#234&quot; where &quot;234&quot; is the tt_content record number, it links to the current page-id\n<b>&nbsp;</b>\n<b>Target</b>\nTarget is normally defined by the &quot;.extTarget&quot; and &quot;target&quot; properties of typolink. But you may override this target by adding the new target after the parameter separated by whitespace. Thus the target becomes the \'second\' parameter.\nIf the \'Target\' parameter is set to the \'-\' character, then it\'s the same as no target passed to the function. This feature enables you to still pass a class as third parameter without setting the target also.\n&nbsp;\n<b>Class</b>\nIf you specify a \'third parameter\' separated by whitespace in the parameter value this becomes the class-parameter of the link. This class parameter is inserted in the link-tag before any values from .ATagParams which means this class value will override any class value set in ATagParams (at least for MSIE).\n&nbsp;\n<b>Examples of multiparameters:</b>\nConsider this .parameter value passed to this function:\n&nbsp;\n51 &nbsp;_blank &nbsp;blueLink\n&nbsp;\nThis would result in a link approx like this:\n&nbsp;\n&lt;A href=&quot;?id=51&quot; target=&quot;_blank&quot; class=&quot;blueLink&quot;&gt;\n&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:7:\"section\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:213:\"If this value is present, it\'s prepended with a &quot;#&quot; and placed after any internal url to another page in Typo3.\nThis is used create a link, which jumps from one page directly the section on another page.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:10:\"ATagParams\";s:8:\"datatype\";s:16:\"&lt;A&gt;-params\";s:11:\"description\";s:68:\"Additional parameters\n&nbsp;\n<b>Example:</b>\nclass=&quot;board&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:8:\"userFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:733:\"This passes the link-data compiled by the typolink function to a user-defined function for final manipulation.\nThe $content variable passed to the user-function (first parameter) is an array with the keys &quot;TYPE&quot;, &nbsp;&quot;TAG&quot;, &quot;url&quot;, &quot;targetParams&quot; and &quot;aTagParams&quot;.\nTYPE is an indication of link-kind: mailto, url, file, page\nTAG is the full &lt;A&gt;-tag as generated and ready from the typolink function.\nThe latter three is combined into the \'TAG\' value after this formula:\n&nbsp;\n&lt;A HREF=&quot;\'.$finalTagParts[&quot;url&quot;].\'&quot;\'.$finalTagParts[&quot;targetParams&quot;].$finalTagParts[&quot;aTagParams&quot;].\'&gt;\n&nbsp;\nThe userfunction must return an &lt;A&gt;-tag.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (201,270,'51fb0254a54165c4bb95358367ae0aec','','tsref:(cObject).CTABLE','a:1:{s:4:\"rows\";a:9:{i:0;a:6:{s:8:\"property\";s:6:\"offset\";s:8:\"datatype\";s:3:\"x,y\";s:11:\"description\";s:29:\"Offset from upper left corner\";s:7:\"default\";s:11:\"0,0 = intet\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:2:\"tm\";s:8:\"datatype\";s:21:\"-&gt;CARRAY +TDParams\";s:11:\"description\";s:7:\"topMenu\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:2:\"lm\";s:8:\"datatype\";s:21:\"-&gt;CARRAY +TDParams\";s:11:\"description\";s:8:\"leftMenu\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:2:\"rm\";s:8:\"datatype\";s:21:\"-&gt;CARRAY +TDParams\";s:11:\"description\";s:9:\"rightMenu\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:2:\"bm\";s:8:\"datatype\";s:21:\"-&gt;CARRAY +TDParams\";s:11:\"description\";s:10:\"bottomMenu\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:1:\"c\";s:8:\"datatype\";s:21:\"-&gt;CARRAY +TDParams\";s:11:\"description\";s:12:\"content-cell\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"cMargins\";s:8:\"datatype\";s:7:\"margins\";s:11:\"description\";s:46:\"Distance around the content-cell &quot;c&quot;\";s:7:\"default\";s:7:\"0,0,0,0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:6:\"cWidth\";s:8:\"datatype\";s:6:\"pixels\";s:11:\"description\";s:39:\"Width of the content-cell &quot;c&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:11:\"tableParams\";s:8:\"datatype\";s:20:\"&lt;TABLE&gt;-params\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:36:\"border=0 cellspacing=0 cellpadding=0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (202,270,'d15fe4c25a73d14a1233602ae5c00aeb','','tsref:(cObject).OTABLE','a:1:{s:4:\"rows\";a:3:{i:0;a:6:{s:8:\"property\";s:6:\"offset\";s:8:\"datatype\";s:3:\"x,y\";s:11:\"description\";s:303:\"Offset from upper left corner\n&nbsp;\n<b>Note:</b>\nActually the datatype is &quot;x,y,r,b,w,h&quot;:\nx,y is offset from upperleft corner\nr,b is offset (margin) to right and bottom\nw is the required width of the content field\nh is the required height of the content field\n&nbsp;\nAll measures is in pixels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:10:\"1,2,3,4...\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:11:\"tableParams\";s:8:\"datatype\";s:20:\"&lt;TABLE&gt;-params\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:36:\"border=0 cellspacing=0 cellpadding=0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (203,270,'ac73d41309997ef5db797e0ac823c30f','','tsref:(cObject).COLUMNS','a:1:{s:4:\"rows\";a:12:{i:0;a:6:{s:8:\"property\";s:11:\"tableParams\";s:8:\"datatype\";s:20:\"&lt;TABLE&gt;-params\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:36:\"border=0 cellspacing=0 cellpadding=0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:8:\"TDparams\";s:8:\"datatype\";s:17:\"&lt;TD&gt;-params\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:10:\"valign=top\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:4:\"rows\";s:8:\"datatype\";s:17:\"int (Range: 2-20)\";s:11:\"description\";s:40:\"The number of rows &nbsp;in the columns.\";s:7:\"default\";s:1:\"2\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"totalWidth\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:35:\"The total-width of the columns+gaps\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:8:\"gapWidth\";s:8:\"datatype\";s:25:\"int /stdWrap\n+optionSplit\";s:11:\"description\";s:44:\"Width of the gap between columns.\n0 = no gap\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:8:\"gapBgCol\";s:8:\"datatype\";s:32:\"HTML-color /stdWrap\n+optionSplit\";s:11:\"description\";s:39:\"background-color for the gap-tablecells\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:16:\"gapLineThickness\";s:8:\"datatype\";s:25:\"int /stdWrap\n+optionSplit\";s:11:\"description\";s:69:\"lineThickness of the dividerline in the gap between cells\n0 = no line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:10:\"gapLineCol\";s:8:\"datatype\";s:32:\"HTML-color /stdWrap\n+optionSplit\";s:11:\"description\";s:10:\"Line color\";s:7:\"default\";s:5:\"black\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:26:\"[column-number]\n1,2,3,4...\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:44:\"This is the content-object for each column!!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:5:\"after\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:50:\"This is a cObject placed after the columns-table!!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:2:\"if\";s:8:\"datatype\";s:7:\"-&gt;if\";s:11:\"description\";s:61:\"if &quot;if&quot; returns false the columns are not rendered!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (182,270,'61a507730523bd733941819140f8811b','','tsref:constants','a:1:{s:4:\"rows\";a:1:{i:0;a:6:{s:8:\"property\";s:8:\"Array...\";s:8:\"datatype\";s:13:\"<i>string</i>\";s:11:\"description\";s:222:\"Constants.\n&nbsp;\n<b>Examples:</b>\n.EMAIL = &nbsp;<i>email@email.com</i>\nNow if parseFunc anywhere is configured with constants=1 then all cases of the string ###EMAIL### will be substituted in the text.\nsee -&gt;parseFunc\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (183,270,'7032add39bae490a73f4ce839844c001','','tsref:(page)','a:1:{s:4:\"rows\";a:24:{i:0;a:6:{s:8:\"property\";s:7:\"typeNum\";s:8:\"datatype\";s:17:\"<i>typeNumber</i>\";s:11:\"description\";s:98:\"This decides the the typeId of the page.\n&nbsp;\n<b>NOTE:</b> This value MUST be set and be unique!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:10:\"1,2,3,4...\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:42:\"Wraps the content of the the cObject array\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:63:\"Wraps the content of the the cObject array with stdWrap options\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:14:\"bodyTagCObject\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:74:\"This is default bodytag overridden by &quot;.bodyTag&quot; if that is set.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:7:\"bodyTag\";s:8:\"datatype\";s:11:\"&lt;tag&gt;\";s:11:\"description\";s:84:\"Bodytag on the page\n&nbsp;\n<b>Example:</b>\n&lt;body bgcolor=&quot;{$bgCol}&quot;&gt;\";s:7:\"default\";s:40:\"&lt;body bgcolor=&quot;#FFFFFF&quot;&gt;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:14:\"bodyTagMargins\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:197:\"margins in the bodytag.\n&nbsp;\n<b>Example:</b>\nvalue <i>4</i>\nadds <i>leftmargin=&quot;0&quot; topmargin=&quot;0&quot; marginwidth=&quot;0&quot; marginheight=&quot;0&quot;</i> &nbsp;to the bodyTag.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:10:\"bodyTagAdd\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:48:\"This content is added to the end of the bodyTag.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:5:\"bgImg\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:74:\"Background image on the page. This is automatically added to the body-tag.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:8:\"frameSet\";s:8:\"datatype\";s:13:\"-&gt;FRAMESET\";s:11:\"description\";s:76:\"if any properties is set to this property, the page is made into a frameset.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:4:\"meta\";s:8:\"datatype\";s:9:\"-&gt;META\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:12:\"shortcutIcon\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:158:\"MSIE can attach icons to bookmarked pages. &nbsp;Create a reference to an icon here!\n&nbsp;\n<b>Note:</b>\nThis must be a valid &quot;.ico&quot;-file (iconfile)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:10:\"headerData\";s:8:\"datatype\";s:11:\"-&gt;CARRAY\";s:11:\"description\";s:145:\"Inserts content in the header-section. Could be JavaScripts, meta-tags, other stylesheet references.\nIs inserted after all the style-definitions.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:6:\"config\";s:8:\"datatype\";s:11:\"-&gt;CONFIG\";s:11:\"description\";s:108:\"configuration for the page. Any entries override the same entries in the toplevel-object &quot;config&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:11:\"includeLibs\";s:8:\"datatype\";s:23:\"<i>array of strings</i>\";s:11:\"description\";s:871:\"With this you may include php-files. This does the same as &quot;includeLibrary&quot; in -&gt;CONFIG but this can include more than one file. These files are included <i>after</i> the file of includeLibrary.\n&nbsp;\n<b>NOTE:</b>\nThe toplevel object &quot;includeLibs&quot; and the scripts defined with this property is added to each other. Script-keys (that is the &quot;array of strings&quot;-value, like below &quot;ts_address&quot;) from this property of the page overrides any scripts-keys from the toplevel &quot;includeLibs&quot; property!\nThe script-filenames are of the datatype &quot;resource&quot;.\n&nbsp;\n<b>Example:</b>\nincludeLibs.ts_address = lib_filename.php\nincludeLibs.ts_shop = lib_filename.php\n&nbsp;\nPlease do not use the prefix shown above (&quot;ts_&quot;) as this will probably be used by the standard Typo3 libraries that will appear in the future.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:23:\"&nbsp;\nCSS Stylesheets:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:10:\"stylesheet\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:136:\"Inserts a stylesheet in the &lt;HEAD&gt;-section of the page;\n<i>&lt;link rel=&quot;stylesheet&quot; href=&quot;[resource]&quot;&gt;</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:18:\"includeCSS.[array]\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:296:\"Inserts a stylesheet (just like the .stylesheet property) by allows to setting up more than a single stylesheet, because you can enter files in an array.\n&nbsp;\n<b>Example:</b>\nincludeCSS {\n&nbsp;&nbsp;file1 = fileadmin/mystylesheet1.css\n&nbsp;&nbsp;file2 = stylesheet_uploaded_to_template*.css\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:15:\"CSS_inlineStyle\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:95:\"This value is just passed on as inline css (in-document css encapsulated in &lt;style&gt;-tags)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:20:\"insertClassesFromRTE\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:449:\"If set, the classes for the Rich Text Editor configured in Page TSconfig is inserted in as the first thing in the Style-section right after the setting of the stylesheet.\n&nbsp;\n<b>.add_mainStyleOverrideDefs</b> = [* / list of tags ] - will add all the &quot;RTE.default. mainStyleOverride_add&quot; - tags configured as well.\n&nbsp;\n<i>Might be depreciated soon. Most likely the RTE should be configured by the stylesheet instead. Stay tuned...</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:15:\"noLinkUnderline\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:106:\"Disables link-underlining. Uses in-document stylesheet.\n&nbsp;\n<i>Depreciated. Use stylesheet instead.</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:5:\"hover\";s:8:\"datatype\";s:10:\"HTML-color\";s:11:\"description\";s:142:\"The color of a link when the mouse moves over it! (only MSIE). Uses in-document stylesheet.\n&nbsp;\n<i>Depreciated. Use stylesheet instead.</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:10:\"hoverStyle\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:175:\"Additional style information to the hover-color.\n&nbsp;\n<b>Example:</b>\npage.hoverStyle = font: bold; text-decoration: none;\n&nbsp;\n<i>Depreciated. Use stylesheet instead.</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:15:\"smallFormFields\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:384:\"&nbsp;Renders formfields like textarea, input and select-boxes small with &quot;verdana size 1&quot; font.\nUses in-document stylesheet.\n&nbsp;\n<b>Tip:</b>\nUse this together with the config-option &quot;compensateFieldWidth&quot; set to &quot;0.6&quot; for netscape-browsers in order to render the small form fields in the same width!\n&nbsp;\n<i>Depreciated. Use stylesheet instead.</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (163,270,'02fd99ffadd59ec590570aba8a97b91b','','tsref:-&gt;imageLinkWrap','a:1:{s:4:\"rows\";a:15:{i:0;a:6:{s:8:\"property\";s:5:\"width\";s:8:\"datatype\";s:12:\"int (1-1000)\";s:11:\"description\";s:134:\"If you add &quot;m&quot; to either the width or height, the image will be held in proportions and width/height works as max-dimensions\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:6:\"height\";s:8:\"datatype\";s:12:\"int (1-1000)\";s:11:\"description\";s:22:\"see &quot;.width&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:7:\"effects\";s:8:\"datatype\";s:59:\"<i>see GIFBUILDER / effects. (from stdgraphics-library)</i>\";s:11:\"description\";s:52:\"<b>Example:</b>\ngamma=1,3 | sharpen=80 | solarize=70\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:6:\"sample\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:124:\"If set, -sample is used to scale images instead of -geometry. Sample does not use antialiasing and is therefore much faster.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:19:\"alternativeTempPath\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:116:\"Enter an alternative path to use for temp images. Must be found in the list in TYPO3_CONF_VARS[FE][allowedTempPaths]\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"title\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:35:\"page title of the new window (HTML)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:7:\"bodyTag\";s:8:\"datatype\";s:11:\"&lt;tag&gt;\";s:11:\"description\";s:26:\"Body tag of the new window\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:56:\"Wrap of the image, which is output between the body-tags\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:21:\"&lt;A&gt;-data:target\";s:11:\"description\";s:42:\"NOTE: Only if &quot;.JSwindow&quot; is set\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:8:\"JSwindow\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:88:\"The image will be opened in a new window which is fitted to the dimensions of the image!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:15:\"JSwindow.expand\";s:8:\"datatype\";s:3:\"x,y\";s:11:\"description\";s:42:\"x and y is added to the window dimensions.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:18:\"JSwindow.newWindow\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:39:\"Each picture will open in a new window!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:15:\"JSwindow.altUrl\";s:8:\"datatype\";s:14:\"string/stdWrap\";s:11:\"description\";s:99:\"If this returns anything, the URL shown in the JS-window is NOT showpic.php but the url given here!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:8:\"typolink\";s:8:\"datatype\";s:13:\"-&gt;typolink\";s:11:\"description\";s:63:\"NOTE: This overrides the imageLinkWrap if it returns anything!!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:6:\"enable\";s:8:\"datatype\";s:16:\"boolean /stdWrap\";s:11:\"description\";s:49:\"<b>The image is linked ONLY if this is true!!</b>\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (184,270,'abe1a9b50d108f34d9b6348126ca6a7b','','tsref:FEData','a:1:{s:4:\"rows\";a:1:{i:0;a:6:{s:8:\"property\";s:19:\"array of tableNames\";s:8:\"datatype\";s:13:\"-&gt;FE_TABLE\";s:11:\"description\";s:13:\"<b>&nbsp;</b>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (185,270,'47b05fd6ecece442af5ff4b1cac75723','','tsref:FEData.(tablename)/-&gt;FE_TABLE','a:1:{s:4:\"rows\";a:9:{i:0;a:6:{s:8:\"property\";s:15:\"default.[field]\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:404:\"This property is in charge of which default-values is used for the table:\n&nbsp;\n<b>Example:</b>\nThis defines the default values used for new records. These values will be overridden with any value submitted instead (as long as the submitted fields are allowed due to &quot;allowNew&quot;)\ndefault {\n&nbsp;&nbsp;subject = This is the default subject value!\n&nbsp;&nbsp;hidden = 1\n&nbsp;&nbsp;parent = 0\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:16:\"allowNew.[field]\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:596:\"This property is in charge of which fields that may be written from the frontend.\n&nbsp;\n<b>Example:</b>\nThis defines that subject is a field, that may be submitted from the frontend. If a value is not submitted, subject is filled with the default value (see above).\nThe field &quot;hidden&quot; on the other hand cannot be changed from the frontend. &quot;hidden&quot; will gain the value from the default definition (see above). If fields are set to &quot;0&quot; (zero) it\'s the same as if they were not defined in this array.\n&nbsp;\nallowNew {\n&nbsp;&nbsp;subject = 1\n&nbsp;&nbsp;hidden = 0\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:17:\"allowEdit.[field]\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:224:\"Same as above (&quot;allowNew&quot;) but this controls which fields that may be written in case of an update of a record (and not a new submission)\nPlease pay attension to the property below! &nbsp;(&quot;overrideEdit&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:20:\"overrideEdit.[field]\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:452:\"This works like default-values above but is values inserted after the submitted values has beed processed. This means that opposite to default-values overwritten by the submitted values, these values override the submitted values.\n&nbsp;\n<b>Example:</b>\nIn this case overrideEdit secures that if a user updates his record (if he &quot;own&quot; it) the &quot;hidden&quot;-field will be set no matter what.\n&nbsp;\noverrideEdit {\n&nbsp;&nbsp;hidden = 1\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:12:\"userIdColumn\";s:8:\"datatype\";s:14:\"string (field)\";s:11:\"description\";s:197:\"This is a string that points to the column of a record where the user-id of the current fe_user should be inserted. This fe_user-uid is inserted/updated both by &quot;new&quot; and &quot;edit&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:13:\"autoInsertPID\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:195:\"Works with new records: Insert automatically the PID of the page, where the submitted data is sent to. Any &quot;pid&quot; supplied from the submitted data will override. This is for convenience.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:13:\"processScript\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:561:\"Include-script to be used for processing of incoming data to the table. The script is included from a function in the class tslib_fetce\nThis is the really important option, because whether or not you are going to utilize the &quot;cleaning&quot;/&quot;authorization&quot; features of the properties above depend on how you write your script to process data and put it in the database.\nA very good example is to look at &quot;media/scripts/guest_submit.inc&quot;, included from static_template &quot;plugin.tt_guest&quot; (Used for the default guestbook feature)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:9:\"separator\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:94:\"Separator character used when the submitted data is an array from eg. a multiple selector box.\";s:7:\"default\";s:19:\"chr(10) (linebreak)\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:15:\"doublePostCheck\";s:8:\"datatype\";s:18:\"string (fieldname)\";s:11:\"description\";s:335:\"Specifies a fieldname (integer) into which an integer-hash compiled of the submitted data is inserted. If the field is set, then submissions are checked whether another record with this value already exists. If so, the record is NOT inserted, because it\'s expected to be a &quot;double post&quot; (posting the same data more than once)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (186,270,'abd2fe363d816a7e733bf049cba172e7','','tsref:(page).frameSet/-&gt;FRAMESET','a:1:{s:4:\"rows\";a:4:{i:0;a:6:{s:8:\"property\";s:10:\"1,2,3,4...\";s:8:\"datatype\";s:8:\"frameObj\";s:11:\"description\";s:45:\"Configuration of frames and nested framesets.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:4:\"cols\";s:8:\"datatype\";s:26:\"&lt;frameset&gt;-data:cols\";s:11:\"description\";s:4:\"Cols\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:4:\"rows\";s:8:\"datatype\";s:26:\"&lt;frameset&gt;-data:rows\";s:11:\"description\";s:4:\"Rows\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:6:\"params\";s:8:\"datatype\";s:23:\"&lt;frameset&gt;-params\";s:11:\"description\";s:90:\"<b>Example:</b>\nborder=&quot;0&quot; framespacing=&quot;0&quot; frameborder=&quot;NO&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (167,270,'49680c1391fc7fcf4e9f17cae4ca5cea','','tsref:-&gt;if','a:1:{s:4:\"rows\";a:10:{i:0;a:6:{s:8:\"property\";s:6:\"isTrue\";s:8:\"datatype\";s:13:\"str / stdWrap\";s:11:\"description\";s:70:\"If the content is &quot;true&quot;.... (not empty string and not zero)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:7:\"isFalse\";s:8:\"datatype\";s:13:\"str / stdWrap\";s:11:\"description\";s:54:\"If the content is &quot;false&quot;... (empty or zero)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:10:\"isPositive\";s:8:\"datatype\";s:20:\"int / stdWrap\n+ calc\";s:11:\"description\";s:40:\"returns false if content is not positive\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:13:\"isGreaterThan\";s:8:\"datatype\";s:15:\"value / stdWrap\";s:11:\"description\";s:63:\"returns false if content is not greater than &quot;.value&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:10:\"isLessThan\";s:8:\"datatype\";s:15:\"value / stdWrap\";s:11:\"description\";s:60:\"returns false if content is not less than &quot;.value&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:6:\"equals\";s:8:\"datatype\";s:15:\"value / stdWrap\";s:11:\"description\";s:58:\"returns false if content does not equal &quot;.value&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"isInList\";s:8:\"datatype\";s:15:\"value / stdWrap\";s:11:\"description\";s:149:\"returns false if content is not in the comma-separated list &quot;.value&quot;.\nThe list in &quot;.value&quot; may not have spaces between elements!!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:5:\"value\";s:8:\"datatype\";s:15:\"value / stdWrap\";s:11:\"description\";s:56:\"&quot;value&quot; (the comparison value mentioned above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:6:\"negate\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:125:\"This negates the result just before it exits. So if anything above returns true the overall returns ends up returning false!!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:12:\"directReturn\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:120:\"If this property exists the true/false of this value is returned. Could be used to set true/false by TypoScript constant\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (178,270,'981bd1fba45f14fb5d305579018338ec','','page:-&gt;HTMLparser_tags; tsref:-&gt;HTMLparser_tags','a:1:{s:4:\"rows\";a:14:{i:0;a:6:{s:8:\"property\";s:15:\"overrideAttribs\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:59:\"If set, this string is preset as the attributes of the tag.\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:14:\"allowedAttribs\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:136:\"\'0\' (zero) = no attributes allowed, \'[commalist of attributes]\' = only allowed attributes. If blank/not set, all attributes are allowed.\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:29:\"fixAttrib.[attribute].default\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:100:\"If no attribute exists by this name, this value is set as default value (if this value is not blank)\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:28:\"fixAttrib.[attribute].always\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:95:\"If set, the attribute is always processed. Normally an attribute is processed only if it exists\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:111:\"fixAttrib.[attribute].trim\nfixAttrib.[attribute].intval\nfixAttrib.[attribute].upper\nfixAttrib.[attribute].lower\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:87:\"If any of these keys are set, the value is passed through the respective PHP-functions.\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:27:\"fixAttrib.[attribute].range\";s:8:\"datatype\";s:12:\"[low],[high]\";s:11:\"description\";s:22:\"Setting integer range.\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:26:\"fixAttrib.[attribute].list\";s:8:\"datatype\";s:23:\"list of values, trimmed\";s:11:\"description\";s:84:\"Attribute value must be in this list. If not, the value is set to the first element.\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:35:\"fixAttrib.[attribute].removeIfFalse\";s:8:\"datatype\";s:32:\"boolean/&quot;blank&quot; string\";s:11:\"description\";s:203:\"If set, then the attribute is removed if it is &quot;false&quot;. If this value is set to &quot;blank&quot; then the value must be a blank string (that means a &quot;zero&quot; value will not be removed)\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:36:\"fixAttrib.[attribute].removeIfEquals\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:70:\"If the attribute value matches the value set here, then it is removed.\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:39:\"fixAttrib.[attribute].casesensitiveComp\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:108:\"If set, the comparison in .removeIfEquals and .list will be case-sensitive. At this point, it\'s insensitive.\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:7:\"protect\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:62:\"If set, the tag &lt;&gt; is converted to &amp;lt; and &amp;gt;\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:5:\"remap\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:47:\"If set, the tagname is remapped to this tagname\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:15:\"rmTagIfNoAttrib\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:69:\"If set, then the tag is removed if no attributes happend to be there.\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:7:\"nesting\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:580:\"If set true, then this tag must have starting and ending tags in the correct order. Any tags not in this order will be discarded. Thus \'&lt;/B&gt;&lt;B&gt;&lt;I&gt;&lt;/B&gt;&lt;/I&gt;&lt;/B&gt;\' will be converted to \'&lt;B&gt;&lt;I&gt;&lt;/B&gt;&lt;/I&gt;\'.\nIs the value &quot;global&quot; then true nesting in relation to other tags marked for &quot;global&quot; nesting control is preserved. This means that if &lt;B&gt; and &lt;I&gt; are set for global nesting then this string \'&lt;/B&gt;&lt;B&gt;&lt;I&gt;&lt;/B&gt;&lt;/I&gt;&lt;/B&gt;\' is converted to \'&lt;B&gt;&lt;/B&gt;\'\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:3;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (151,270,'562ee021929de249706534bf02f731ff','','tsref:(datatypes)','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (153,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (152,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (164,270,'4f8d4ac364c9c9037abc867a3069db7b','','tsref:-&gt;numRows','a:1:{s:4:\"rows\";a:2:{i:0;a:6:{s:8:\"property\";s:5:\"table\";s:8:\"datatype\";s:9:\"tablename\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:6:\"select\";s:8:\"datatype\";s:11:\"-&gt;select\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (165,270,'2ac5d8690de37a3ef60b48f41d6151bd','','tsref:-&gt;select','a:1:{s:4:\"rows\";a:10:{i:0;a:6:{s:8:\"property\";s:9:\"uidInList\";s:8:\"datatype\";s:22:\"<i>list of </i>page_id\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:9:\"pidInList\";s:8:\"datatype\";s:31:\"<i>list of </i>page_id /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:4:\"this\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:7:\"orderBy\";s:8:\"datatype\";s:18:\"<i>SQL-orderBy</i>\";s:11:\"description\";s:60:\"without &quot;order by&quot;! Eg. &quot;sorting, title&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:7:\"groupBy\";s:8:\"datatype\";s:18:\"<i>SQL-groupBy</i>\";s:11:\"description\";s:51:\"without &quot;group by&quot;! Eg. &quot;CType&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:3:\"max\";s:8:\"datatype\";s:35:\"int\n+calc\n<i>+&quot;total&quot;</i>\";s:11:\"description\";s:89:\"max records\n&nbsp;\n<b>Special keyword: &quot;total&quot; is substituted with count(*)</b>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"begin\";s:8:\"datatype\";s:35:\"int\n+calc\n<i>+&quot;total&quot;</i>\";s:11:\"description\";s:122:\"begin with record number <i>value</i>\n<i>&nbsp;</i>\n<b>Special keyword:</b> &quot;total&quot; is substituted with count(*)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:5:\"where\";s:8:\"datatype\";s:16:\"<i>SQL-where</i>\";s:11:\"description\";s:88:\"without &quot;where&quot;!, Eg. &quot; (title LIKE \'%SOMETHING%\' AND NOT doktype) &quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:8:\"andWhere\";s:8:\"datatype\";s:26:\"<i>SQL-where / stdWrap</i>\";s:11:\"description\";s:54:\"without &quot;AND&quot;!, Eg. &quot;NOT doktype&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:13:\"languageField\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:323:\"If set, this points to the field in the record which holds a reference to a record in sys_language table. And if set, the records returned by the select-function will be selected only if the value of this field matches the $GLOBALS[&quot;TSFE&quot;]-&gt;sys_language_uid (which is set by the config.sys_language_uid option)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:23:\"join\nleftjoin\nrightjoin\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:77:\"Enter tablename for JOIN , LEFT OUTER JOIN and RIGHT OUTER JOIN respectively.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (166,270,'805f50bc159e8bf7767b5938f85b9937','','tsref:-&gt;split','a:1:{s:4:\"rows\";a:6:{i:0;a:6:{s:8:\"property\";s:5:\"token\";s:8:\"datatype\";s:13:\"str / stdWrap\";s:11:\"description\";s:51:\"string or character (token) used to split the value\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:3:\"max\";s:8:\"datatype\";s:13:\"int / stdWrap\";s:11:\"description\";s:20:\"max number of splits\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:3:\"min\";s:8:\"datatype\";s:13:\"int / stdWrap\";s:11:\"description\";s:21:\"min number of splits.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:7:\"cObjNum\";s:8:\"datatype\";s:27:\"<i>cObjNum</i>\n+optionSplit\";s:11:\"description\";s:120:\"This is a pointer the array of this object (&quot;1,2,3,4&quot;), that should treat the items, resulting from the split.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:7:\"1,2,3,4\";s:8:\"datatype\";s:20:\"-&gt;CARRAY /stdWrap\";s:11:\"description\";s:465:\"The object that should treat the value. \n<b>NOTE: The &quot;current&quot;-value is set to the value of current item, when the objects are called. See &quot;stdWrap&quot; / current.</b>\n<b>&nbsp;</b>\n<b>Example (stdWrap used):</b>\n1.current = 1\n1.wrap = &lt;B&gt; | &lt;/B&gt;\n&nbsp;\n<b>Example (CARRAY used):</b>\n1 {\n&nbsp;&nbsp;10 = TEXT\n&nbsp;&nbsp;10.current = 1\n&nbsp;&nbsp;10.wrap = &lt;B&gt; | &lt;/B&gt;\n&nbsp;&nbsp;20 = CLEARGIF\n&nbsp;&nbsp;20.height = 20\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:18:\"wrap \n+optionSplit\";s:11:\"description\";s:29:\"Defines a wrap for each item.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (187,270,'9a205dde5d397a7b49c80254e9e23d2c','','tsref:(page).frameSet.(number)/-&gt;FRAMESET.(number)','a:1:{s:4:\"rows\";a:5:{i:0;a:6:{s:8:\"property\";s:3:\"obj\";s:8:\"datatype\";s:38:\"<i>pointer to toplevel object-name</i>\";s:11:\"description\";s:121:\"toplevel object-name of a PAGE / FRAMESET\n&nbsp;\n<b>Example:</b>\n&quot;left&quot;, &quot;page&quot;, &quot;frameset&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:7:\"options\";s:8:\"datatype\";s:21:\"<i>url-parameters</i>\";s:11:\"description\";s:183:\"<b>Example:</b>\nprint=1&amp;othervar=anotherthing\nwould add \'<i>&amp;print=1&amp;othervar=anotherthing</i>\' to the &quot;.src&quot;-content (if not &quot;.src&quot; is set manually!!)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:6:\"params\";s:8:\"datatype\";s:20:\"&lt;frame&gt;-params\";s:11:\"description\";s:78:\"<b>Example:</b>\nscrolling=&quot;AUTO&quot; noresize frameborder=&quot;NO&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:4:\"name\";s:8:\"datatype\";s:23:\"&lt;frame&gt;-data:name\";s:11:\"description\";s:121:\"Manually set name of frame\n&nbsp;\n<b>NOTE:</b> Is set automatically and should not be overridden under normal conditions!\";s:7:\"default\";s:25:\"value of &quot;.obj&quot;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:3:\"src\";s:8:\"datatype\";s:22:\"&lt;frame&gt;-data:src\";s:11:\"description\";s:128:\"Manually set the src of the frame\n&nbsp;\n<b>NOTE:</b> Is set automatically and should not be overridden under normal conditions!\";s:7:\"default\";s:32:\"could be index.php?$id&amp;$type\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (249,270,'63839135a1a4b8831ae951b0be3e42e0','','tsref:(script).tipafriend','a:1:{s:4:\"rows\";a:10:{i:0;a:6:{s:8:\"property\";s:12:\"templateFile\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:74:\"The template-file.\nSee example in \'media/scripts/tipafriend_template.tmpl\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:4:\"code\";s:8:\"datatype\";s:16:\"string / stdWrap\";s:11:\"description\";s:53:\"Code to define, what the script does. Case sensitive.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:11:\"defaultCode\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:105:\"The default code (see above) if the value is empty. By default it\'s not set and a help screen will appear\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:5:\"wrap1\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:211:\"Global Wrap 1. This will be splitted into the markers ###GW1B### and ###GW1E###. Don\'t change the input value by the settings, only wrap it in something.\n&nbsp;\n<b>Example:</b>\nwrap1.wrap = &lt;B&gt; |&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:5:\"wrap2\";s:8:\"datatype\";s:13:\"-&gt; stdWrap\";s:11:\"description\";s:25:\"Global Wrap 2 (see above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:6:\"color1\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC1### marker (Global color 1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:6:\"color2\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC2### marker (Global color 2)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:6:\"color3\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:43:\"Value for ###GC3### marker (Global color 3)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:8:\"typolink\";s:8:\"datatype\";s:13:\"-&gt;typolink\";s:11:\"description\";s:125:\"TypoLink configuration for the TIPLINK to the TIPFORM page. .additionalParams is added the parameter &quot;&amp;tipUrl=&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:8:\"htmlmail\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:92:\"If set, the page is fetched as HTML and send in HTML (a plain text version is sent as well).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (169,270,'ae86077ab2347d4a7fbf0b05b43e8018','','tsref:-&gt;textStyle','a:1:{s:4:\"rows\";a:11:{i:0;a:6:{s:8:\"property\";s:11:\"align.field\";s:8:\"datatype\";s:5:\"align\";s:11:\"description\";s:46:\"Set to fieldname from the $cObj-&gt;data-array\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:24:\"face.field\n&nbsp;\n&nbsp;\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:188:\"Set to fieldname from the $cObj-&gt;data-array\n&nbsp;\n[1] = &quot;Times New Roman&quot;;\n[2] = &quot;Verdana,Arial,Helvetica,Sans serif&quot;;\n[3] = &quot;Arial,Helvetica,Sans serif&quot;;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:12:\"face.default\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:24:\"[default] = User defined\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:24:\"size.field\n&nbsp;\n&nbsp;\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:126:\"Set to fieldname from the $cObj-&gt;data-array\n&nbsp;\n[1] = 1;\n[2] = 2;\n[3] = 3;\n[10] = &quot;+1&quot;;\n[11] = &quot;-1&quot;;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:12:\"size.default\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:24:\"[default] = User defined\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:32:\"color.field\n&nbsp;\n&nbsp;\n&nbsp;\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:106:\"Set to fieldname from the $cObj-&gt;data-array\n&nbsp;\nSee &quot;content.php&quot; for the colors available\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:13:\"color.default\";s:8:\"datatype\";s:21:\"string &nbsp;/stdWrap\";s:11:\"description\";s:24:\"[default] = User defined\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:15:\"color.1\ncolor.2\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:22:\"[1],[2] = User defined\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:16:\"properties.field\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:225:\"Set to fieldname from the $cObj-&gt;data-array\n&nbsp;\nThe property values goes like this:\nbit 0: &lt;B&gt;\nbit 1: &lt;I&gt;\nbit 2: &lt;U&gt;\nbit 3: (uppercase)\n&nbsp;\nThus a value of 5 would result in bold and underlined text\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:18:\"properties.default\";s:8:\"datatype\";s:18:\"int &nbsp;/stdWrap\";s:11:\"description\";s:88:\"[default] = User defined (This value will be used whenever &quot;.field&quot; is false!)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:7:\"altWrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:255:\"If this value is set, the wrapping with a font-tag based on font,size and color is NOT done. Rather the element is wrapped with this value.\nUse it to assign a stylesheet by setting this value to eg.\n&nbsp;\n&lt;div class=&quot;text&quot;&gt; | &lt;/div&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (170,270,'039f9f0970f132db5add53b2178e6889','','tsref:-&gt;encapsLines','a:1:{s:4:\"rows\";a:9:{i:0;a:6:{s:8:\"property\";s:13:\"encapsTagList\";s:8:\"datatype\";s:15:\"list of strings\";s:11:\"description\";s:279:\"List of tags which qualify as encapsulating tags. Must be lowercase.\n&nbsp;\n<b>Example:</b>\nencapsTagList = div, p\n&nbsp;\nThis setting will recognize the red line below as encapsulated lines:\n&nbsp;\nFirst line of text\nSome &lt;div&gt;text&lt;/div&gt;\n&lt;B&gt;Some text&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:18:\"remapTag.[tagname]\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:387:\"Enter a new tag name here if you wish the tagname of any encapsulation to be unified to a single tag name.\n&nbsp;\nFor instance, setting this value to &quot;remapTags.P=DIV&quot; would convert:\n&nbsp;\n&lt;p&gt;Some text&lt;/p&gt;\n&lt;div&gt;Some text&lt;/div&gt;\n&nbsp;\nto\n&nbsp;\n&lt;div&gt;Some text&lt;/div&gt;\n&lt;div&gt;Some text&lt;/div&gt;\n&nbsp;\n([<i>tagname</i>] is in uppercase.)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:23:\"addAttributes.[tagname]\";s:8:\"datatype\";s:16:\"array of strings\";s:11:\"description\";s:495:\"Attributes to set in the encapsulation tag.\n<b>&nbsp;</b>\n<b>Example:</b>\naddAttributes.P {\n&nbsp;&nbsp;style=padding-bottom:0px; margin-top:1px; margin-bottom:1px;\n&nbsp;&nbsp;align=center\n}\n&nbsp;\n([<i>tagname</i>] is in uppercase.)\n&nbsp;\n.setOnly =\nexists : This will set the value ONLY if the property does not already exist\nblank : This will set the value ONLY if the property does not already exist OR is blank (&quot;&quot;)\n&nbsp;\nDefault is to always override/set the attributes value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:14:\"removeWrapping\";s:8:\"datatype\";s:6:\"boolen\";s:11:\"description\";s:261:\"If set, then all existing wrapping will be removed.\n&nbsp;\nThis:\n&nbsp;\nFirst line of text\nSome &lt;div&gt;text&lt;/div&gt;\n&lt;B&gt;Some text&lt;/B&gt;\n&nbsp;\nbecomes this:\n&nbsp;\nFirst line of text\nSome &lt;div&gt;text&lt;/div&gt;\n&lt;B&gt;Some text&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:19:\"wrapNonWrappedLines\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:208:\"Wrapping for non-encapsulated lines\n&nbsp;\n<b>Example:</b>\n.wrapNonWrappedLines = &lt;P&gt;|&lt;/P&gt;\n&nbsp;\nThis:\n&nbsp;\n&lt;p&gt;Some text&lt;/p&gt;\n&nbsp;\nbecomes this:\n&nbsp;\n&lt;p&gt;Some text&lt;/p&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:16:\"innerStdWrap_all\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:73:\"Wraps the content inside all lines, whether they are encapsulated or not.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:28:\"encapsLinesStdWrap.[tagname]\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:84:\"Wraps the content inside all encapsulated lines.\n([<i>tagname</i>] is in uppercase.)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:12:\"defaultAlign\";s:8:\"datatype\";s:21:\"string / -&gt;stdWrap\";s:11:\"description\";s:152:\"If set, this value is set as the default &quot;align&quot; value of the wrapping tags, both from .encapsTagList, .bypassEncapsTagList and .nonWrappedTag\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:13:\"nonWrappedTag\";s:8:\"datatype\";s:7:\"tagname\";s:11:\"description\";s:334:\"For all non-wrapped lines, you can set here which tag it should be wrapped in. Example would be &quot;P&quot;. This is an alternative to .wrapNonWrappedLines and has the advantage that it\'s attributes are set by .addAttributes as well as defaultAlign. Thus you can easier match the wrapping tags used for nonwrapped and wrapped lines.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (156,270,'bcdcdb0a538a97e2d7d59053ce4f715c','','alues are strings an a match happens if one of these strings equals the type of device','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (188,270,'619d4b1e512edbf3cdbaa540e35299d6','','tsref:-&gt;META','a:1:{s:4:\"rows\";a:1:{i:0;a:6:{s:8:\"property\";s:8:\"Array...\";s:8:\"datatype\";s:22:\"<i>string /stdWrap</i>\";s:11:\"description\";s:480:\"Metatags\nIf value is empty (after trimming) the metatag is not generated.\nIf the &quot;key&quot; (eg. &quot;REFRESH&quot; or &quot;DESCRIPTION&quot;) is &quot;REFRESH&quot; (caseinsensitive), then the &quot;http-equiv&quot;-attribute is used in the metatag instead of &quot;name&quot;.\n&nbsp;\n<b>Examples:</b>\n.REFRESH = &nbsp;<i>[sec]; [url, leave blank for same page]</i>\n.DESCRIPTION = This is the description of the content in this document\n.KEYWORDS = This is the keywords...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (189,270,'f5345556a80f7226b56ba4fdc2f3c476','','tsref:-&gt;CARRAY','a:1:{s:4:\"rows\";a:4:{i:0;a:6:{s:8:\"property\";s:10:\"1,2,3,4...\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:177:\"This is a numerical &quot;array&quot; of content-objects (cObjects). The order by which you specific the objects is not important as the array will be sorted before it\'s parsed!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:22:\"Occational properties:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:23:\"(stdWrap properties...)\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:431:\"<b>NOTE:</b> This applies ONLY if &quot;CARRAY /stdWrap&quot; is set to be data type\nIf you specify any non-integer properties to a CARRAY, stdWrap will be invoked with all properties of the CARRAY.\n&nbsp;\n<b>Example:</b>\nThis will return \'&lt;B&gt;This will be rendered before &quot;10&quot;testing&lt;/B&gt;\'\n10 = TEXT\n10.value = testing\n5 = HTML\n5.value = This will be rendered before &quot;10&quot;\nwrap = &lt;B&gt; |&lt;/B&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"(TDParams)\";s:8:\"datatype\";s:17:\"&lt;TD&gt;-params\";s:11:\"description\";s:208:\"<b>NOTE:</b> This applies ONLY if &quot;CARRAY +TDParams&quot; is set to be data type\nThis property is used only in some cases where CARRAY is used. Please look out for a note about that in the various cases.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (174,270,'ab5cc5b61ca6a63ecb5d99b898d67461','','tsref:-&gt;parseFunc','a:1:{s:4:\"rows\";a:13:{i:0;a:6:{s:8:\"property\";s:14:\"externalBlocks\";s:8:\"datatype\";s:28:\"list of tagnames/+properties\";s:11:\"description\";s:3195:\"This allows you to pre-split the content passed to parseFunc so that only content outside the blocks with the given tags is parsed.\n<b>Extra properties:</b>\n<b>.[tagname]</b> {\n&nbsp;&nbsp;<b>callRecursive</b> = [boolean]; If set, the content of the block is directed into parseFunc again. Otherwise the content is just passed through with no other processing than stdWrap (see below)\n&nbsp;&nbsp;<b>callRecursive.dontWrapSelf </b>= [boolean]; If set, the tags of the block is <i>not</i> wrapped around the content returned from parseFunc.\n&nbsp;&nbsp;<b>callRecursive.tagStdWrap</b> = -&gt;stdWrap processing of the block-tags.\n&nbsp;&nbsp;<b>stdWrap </b>= -&gt;stdWrap processing of the whole block (regardless of whether callRecursive was set.)\n&nbsp;&nbsp;<b>stripNLprev </b>= [boolean]; Strips off last linebreak of the previous outside block\n&nbsp;&nbsp;<b>stripNLnext </b>= [boolean]; Strips off first linebreak of the next outside block\n&nbsp;&nbsp;<b>stripNL </b>= [boolean]: Does both of the above.\n&nbsp;\n<b>&nbsp;&nbsp;&nbsp;HTMLtableCells </b>= [boolean]; If set, then the content is expected to be a table and every table-cell is traversed.\n&nbsp;&nbsp;&nbsp;# Below, default is all cells and 1,2,3... overrides for specific cols.\n<b>&nbsp;&nbsp;&nbsp;HTMLtableCells.[default/1/2/3/...] </b>{\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>callRecursive </b>= [boolean]; The content is parsed through current parseFunc\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>stdWrap </b>= -&gt;stdWrap processing of the content in the cell\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>tagStdWrap</b> = -&gt; The &lt;TD&gt; tag is processed by -&gt;stdWrap\n&nbsp;&nbsp;&nbsp;}\n&nbsp;&nbsp;&nbsp;<b>HTMLtableCells.addChr10BetweenParagraphs </b>= [boolean]; If set, then all &lt;/P&gt;&lt;P&gt; appearances will have a chr(10) inserted between them\n}\n&nbsp;\n<b>Example:</b>\nThis example is used to split regular bodytext content so that tables and blockquotes in the bodytext are processed correctly. The blockquotes are passed into parseFunc again (recursively) and further their top/bottom margins are set to 0 (so no apparent linebreaks are seen)\nThe tables are also displayed with a number of properties of the cells overridden.\ntt_content.text.20.parseFunc.externalBlocks {\n&nbsp;&nbsp;blockquote.callRecursive=1\n&nbsp;&nbsp;blockquote.callRecursive.tagStdWrap.HTMLparser = 1\n&nbsp;&nbsp;blockquote.callRecursive.tagStdWrap.HTMLparser {\n&nbsp;&nbsp;&nbsp;&nbsp;tags.blockquote.fixAttrib.style.list = margin-bottom:0;margin-top:0;\n&nbsp;&nbsp;&nbsp;&nbsp;tags.blockquote.fixAttrib.style.always=1\n&nbsp;&nbsp;}\n&nbsp;&nbsp;blockquote.stripNLprev=1\n&nbsp;&nbsp;blockquote.stripNLnext=1\n&nbsp;\n&nbsp;&nbsp;table.stripNL=1\n&nbsp;&nbsp;table.stdWrap.HTMLparser = 1\n&nbsp;&nbsp;table.stdWrap.HTMLparser {\n&nbsp;&nbsp;&nbsp;&nbsp;tags.table.overrideAttribs = border=0 cellpadding=2 cellspacing=1 style=&quot;margin-top:10px; margin-bottom:10px;&quot;\n&nbsp;&nbsp;&nbsp;&nbsp;tags.tr.allowedAttribs=0\n&nbsp;&nbsp;&nbsp;&nbsp;tags.td.overrideAttribs = valign=top bgcolor=&quot;#eeeeee&quot; style=&quot;font-family : Verdana, Geneva, Arial, Helvetica, sans-serif;&nbsp;&nbsp;&nbsp;&nbsp;font-size : 10px;&quot;\n&nbsp;&nbsp;}\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:9:\"constants\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:336:\"The toplevel-defined constants will be substituted in the text. The constant-name is wrapped in &quot;###&quot;.\n&nbsp;\n<b>Example:</b>\nconstants.EMAIL = &nbsp;<i>email@email.com</i>\n(NOTE: This is toplevel TypoScript!)\nAll cases of the string ###EMAIL### will be substituted in the text. The constants are defined as a toplevel object.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:5:\"short\";s:8:\"datatype\";s:23:\"<i>array of strings</i>\";s:11:\"description\";s:297:\"Like constants above, but local.\n&nbsp;\n<b>Example:</b>\nThis substitutes all occurencies of &quot;T3&quot; with &quot;Typo3 CMS&quot; and &quot;T3web&quot; with a link to typo3.com.\nshort {\n&nbsp;&nbsp;T3 = Typo3 CMS\n&nbsp;&nbsp;T3web = &lt;a href=&quot;http://typo3.com&quot;&gt;typo3&lt;/a&gt;\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:16:\"plainTextStdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:51:\"This is stdWrap properties for all non-tag content.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:8:\"userFunc\";s:8:\"datatype\";s:13:\"function name\";s:11:\"description\";s:178:\"This passes the non-tag content to a function of your own choice. Similar to eg. .postUserFunc in stdWrap.\nRemember the function name must possibly be prepended &quot;user_&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:17:\"nonTypoTagStdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:246:\"Like .plainTextStdWrap. Difference:\n.plainTextStdWrap works an ALL non-tag pieces in the text. .nonTypoTagStdWrap is post processing of all text (including tags) between special TypoTags (unless .breakoutTypoTagContent is not set for the TypoTag)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:18:\"nonTypoTagUserFunc\";s:8:\"datatype\";s:13:\"function name\";s:11:\"description\";s:271:\"Like .userFunc. Differences is (like nonTypoTagStdWrap) that this is post processing of all content pieces around TypoTags while .userFunc processes all non-tag content. (Notice: .breakoutTypoTagContent must be set for the TypoTag if it\'s excluded from nonTypoTagContent)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:5:\"sword\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:194:\"Marks up any words from the GET-method send array sword_list[] in the text. The word MUST be at least two characters long!\n<b>NOTE:</b> works only with $GLOBALS[&quot;TSFE&quot;]-&gt;no_cache==1\";s:7:\"default\";s:48:\"&lt;font color=&quot;red&quot;&gt;|&lt;/font&gt;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:9:\"makelinks\";s:8:\"datatype\";s:24:\"boolean / -&gt;makelinks\";s:11:\"description\";s:115:\"Convert webadresses prefixed with &quot;http://&quot; and mail-adresses prefixed with &quot;mailto:&quot; to links.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:4:\"tags\";s:8:\"datatype\";s:16:\"<i>-&gt;tags</i>\";s:11:\"description\";s:80:\"Here you can define <b>custom tags</b> that will parse the content to something.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:9:\"allowTags\";s:8:\"datatype\";s:15:\"list of strings\";s:11:\"description\";s:121:\"List of tags, which are allowed to exist in code!\nHighest priority: If a tag is found in allowTags, denyTags is ignored!!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:8:\"denyTags\";s:8:\"datatype\";s:15:\"list of strings\";s:11:\"description\";s:370:\"List of tags, which may NOT exist in code! (use &quot;*&quot; for all.)\nLowest priority: If a tag is NOT found in allowTags, denyTags is checked. If denyTags is not &quot;*&quot; and the tag is not found in the list, the tag may exist!\n&nbsp;\n<b>Example:</b>\nThis allows &lt;B&gt;, &lt;I&gt;, &lt;A&gt; and &lt;IMG&gt; -tags to exist\n.allowTags = b,i,a,img\n.denyTags = *\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:2:\"if\";s:8:\"datatype\";s:7:\"-&gt;if\";s:11:\"description\";s:85:\"if &quot;if&quot; returns false the input value is not parsed, but returned directly.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (190,270,'90abbeca518fabd3ec8944e62fd200b7','','tsref:(cObject).HTML','a:1:{s:4:\"rows\";a:1:{i:0;a:6:{s:8:\"property\";s:5:\"value\";s:8:\"datatype\";s:14:\"HTML / stdWrap\";s:11:\"description\";s:14:\"Raw HTML-code.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (191,270,'03fe46bb8628f60fec5859bf75fa5f75','','tsref:(cObject).TEXT','a:1:{s:4:\"rows\";a:2:{i:0;a:6:{s:8:\"property\";s:5:\"value\";s:8:\"datatype\";s:5:\"value\";s:11:\"description\";s:34:\"text, wrap with stdWrap properties\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:23:\"(stdWrap properties...)\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (192,270,'571d18366e15bc9b1ce2cd4ef7da8ff5','','tsref:(cObject).COA/(cObject).COA_INT/(cObject).COBJ_ARRAY','a:1:{s:4:\"rows\";a:5:{i:0;a:6:{s:8:\"property\";s:10:\"1,2,3,4...\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:2:\"if\";s:8:\"datatype\";s:7:\"-&gt;if\";s:11:\"description\";s:55:\"if &quot;if&quot; returns false the COA is NOT rendered\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:11:\"includeLibs\";s:8:\"datatype\";s:23:\"<i>list of </i>resource\";s:11:\"description\";s:369:\"<b>(This property is used only if the object is COA_INT!, See introduction.)</b>\nThis is a comma-separated list of resources that are included as PHP-scripts (with include_once() function) if this script is included.\nThis is possible to do because any include-files will be known before the scripts are included. That\'s not the case with the regular PHP_SCRIPT cObject.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (193,270,'3918801c03952a7fde07c4afd3faa80a','','tsref:(cObject).FILE','a:1:{s:4:\"rows\";a:3:{i:0;a:6:{s:8:\"property\";s:4:\"file\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:214:\"If the resource is <b>jpg,gif,jpeg,png </b>the image is inserted as an image-tag. Al other formats is read and inserted into the HTML-code.\nThe maximum filesize of documents to be read is set to 1024 kb internally!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:8:\"linkWrap\";s:11:\"description\";s:26:\"(before &quot;.wrap&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (194,270,'45effe326c7d351875eb76178430f63f','','tsref:(cObject).IMAGE','a:1:{s:4:\"rows\";a:8:{i:0;a:6:{s:8:\"property\";s:4:\"file\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:6:\"params\";s:8:\"datatype\";s:18:\"&lt;IMG&gt;-params\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:7:\"alttext\";s:8:\"datatype\";s:16:\"string / stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:8:\"linkWrap\";s:11:\"description\";s:26:\"(before &quot;.wrap&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:13:\"imageLinkWrap\";s:8:\"datatype\";s:27:\"boolean/\n-&gt;imageLinkWrap\";s:11:\"description\";s:116:\"<b>NOTE:</b> ONLY active if linkWrap is NOT set and file is NOT GIFBUILDER (as it works with the original imagefile)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:2:\"if\";s:8:\"datatype\";s:7:\"-&gt;if\";s:11:\"description\";s:55:\"if &quot;if&quot; returns false the image is not shown!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (195,270,'a2140130f94da8de59d956354896d9bf','','tsref:(cObject).IMG_RESOURCE','a:1:{s:4:\"rows\";a:2:{i:0;a:6:{s:8:\"property\";s:4:\"file\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (251,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:28:{i:0;a:6:{s:8:\"property\";s:7:\"siteUrl\";s:8:\"datatype\";s:3:\"url\";s:11:\"description\";s:16:\"Url of the site.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:13:\"defaultOutput\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:40:\"Default output if CType is not rendered.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:14:\"uploads.header\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:18:\"Header for uploads\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:13:\"images.header\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:17:\"Header for images\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:20:\"images.captionHeader\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:24:\"Header for imagecaptions\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:17:\"images.linkPrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:22:\"Prefix for image-links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:7:\".header\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:11:\"defaultType\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:28:\"Which type to use as default\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:4:\"date\";s:8:\"datatype\";s:11:\"date-config\";s:11:\"description\";s:15:\"For header date\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:10:\"datePrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:22:\"Prefix for header date\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:10:\"linkPrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:23:\"Prefix for header links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:16:\"[1-5].preLineLen\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:28:\"Lenght of line before header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:17:\"[1-5].postLineLen\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:27:\"Lenght of line after header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:15:\"[1-5].preBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:35:\"Number of blank lines before header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:16:\"[1-5].postBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:34:\"Number of blank lines after header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:13:\"[1-5].stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:15:\"for header text\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:17:\"[1-5].preLineChar\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:21:\"Character to pre-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:18:\"[1-5].postLineChar\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:22:\"Character to post-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:19:\"[1-5].preLineBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:49:\"Number of blank lines between header and pre-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:20:\"[1-5].postLineBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:50:\"Number of blank lines between header and post-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:16:\"[1-5].autonumber\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:111:\"If set, a number is prepended every header. The number corresponds to the content element number in the select.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:12:\"[1-5].prefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:20:\"Header string prefix\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:23:\"bulletlist.[0-3].bullet\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:36:\"Bullet for bullet list, layout [0-3]\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:26:\"bulletlist.[0-3].secondRow\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:65:\"If set, this is used for lines on the second row of bullet-lists.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:4:\"menu\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:137:\"cObject to render menu. The output is stripped for tags and the links is extracted. Further all &lt;BR&gt; chars are converted to chr(10)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:8:\"shortcut\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:129:\"cObject to render other elements. See config below which simply uses this object to render more tt_content elements as plaintext.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:16:\"bodytext.stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:48:\"stdWrap for body-text. See config example below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:8:\"userProc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:195:\"Lets you proces the output of each content element before it finally is returned. Property &quot;parentObj&quot; of the conf-array holds a references to the plainText object calling the function.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (161,270,'d72042b5e8a0ae76f869cba1a179363d','','tsref:-&gt;stdWrap','a:1:{s:4:\"rows\";a:71:{i:0;a:6:{s:8:\"property\";s:9:\"Get data:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:19:\"setContentToCurrent\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:63:\"Sets the current value to the incoming content of the function.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:10:\"setCurrent\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:141:\"Sets the &quot;current&quot;-value. This is normally set from some outside routine, so be careful with this. But it might be handy to do this\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:4:\"lang\";s:8:\"datatype\";s:29:\"<i>array of language-keys</i>\";s:11:\"description\";s:429:\"This is used to define optional language specific values.\nIf the global language key set by the -&gt;config property .language is found in this array, then this value is used instead of the default input value to stdWrap.\n&nbsp;\n<b>Example:</b>\nconfig.language = de\npage.10 = TEXT\npage.10.value = I am a Berliner!\npage.10.lang.de = Ich bin ein Berliner!\n&nbsp;\nOutput will be &quot;Ich bin...&quot; instead of &quot;I am...&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:4:\"data\";s:8:\"datatype\";s:7:\"getText\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:5:\"field\";s:8:\"datatype\";s:16:\"<i>fieldname</i>\";s:11:\"description\";s:524:\"Sets the content to the value $cObj-&gt;data[<i>field</i>]\n&nbsp;\n<b>Example:</b> Set content to the value of field &quot;title&quot;: &quot;.field = title&quot;\n$cObj-&gt;data changes. See the description for the data type &quot;getText&quot;/field!\n<b>&nbsp;</b>\n<b>Note:</b> You can also divide fieldnames by &quot;//&quot;. Say, you set &quot;nav_title // title&quot; as the value, then the content from the field nav_title will be returned unless it is a blank string, in which case the title-field\'s value is returned.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:7:\"current\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:66:\"Sets the content to the &quot;current&quot;-value (see -&gt;split)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:7:\"cObject\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:35:\"Loads content from a content-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:7:\"numRows\";s:8:\"datatype\";s:12:\"-&gt;numRows\";s:11:\"description\";s:52:\"Returns the number of rows resulting from the select\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:8:\"filelist\";s:8:\"datatype\";s:13:\"dir / stdWrap\";s:11:\"description\";s:397:\"Reads a directory and returns a list of files.\nThe value is exploded by &quot;|&quot; into parameters:\n1: The path\n2: comma-list of allowed extensions (no spaces between); if empty all extensions goes.\n3: sorting: name, size, ext, date\n4: reverse: Set to &quot;r&quot; if you want a reversed sorting\n5: fullpath_flag: If set, the filelist if returned with complete paths, and not just the filename\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:11:\"preUserFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:165:\"Calling a PHP-function or method in a class, passing the current content to the function as first parameter and any properties as second parameter.\nSee .postUserFunc\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:22:\"Override / Conditions:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:8:\"override\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:116:\"if &quot;override&quot; returns something else than &quot;&quot; or zero (trimmed), the content is loaded with this!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:17:\"preIfEmptyListNum\";s:8:\"datatype\";s:30:\"(as &quot;listNum&quot; below)\";s:11:\"description\";s:30:\"(as &quot;listNum&quot; below)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:7:\"ifEmpty\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:123:\"if the content is empty (trimmed) at this point, the content is loaded with &quot;ifEmpty&quot;.\nZero\'s are an empty value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:7:\"listNum\";s:8:\"datatype\";s:27:\"int\n+calc\n+&quot;last&quot;\";s:11:\"description\";s:635:\"Explodes the content with &quot;,&quot; (comma) and the content is set to the item[<i>value</i>].\n<b>&nbsp;</b>\n<b>Special keyword:</b> &quot;last&quot; is set to the last element of the array!\n<b>&nbsp;</b>\n<b>Property:</b>\n.splitChar = string; &nbsp;Defines the string used to explode the value. If splitChar is an integer, the character with that number is used (eg. &quot;10&quot; to split lines...)\n.stdWrap = stdWrap properties of the listNum...\nDefault = &quot;,&quot; (comma)\n<b>&nbsp;</b>\n<b>Examples:</b>\nWe have a value of &quot;item 1, item 2, item 3, item 4&quot;:\nThis would return &quot;item 3&quot;:\n.listNum = last - 1\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:4:\"trim\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:52:\"PHP-function trim(); Removes whitespace around value\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:8:\"required\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:283:\"This flag requires the content to be set to some value after any content-import and treatment that might have happend now (data, field, current, listNum, trim). Zero\'s is NOT regarded as empty! Use &quot;if&quot; instead!\nIf the content i empty, &quot;&quot; is returned immediately.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:2:\"if\";s:8:\"datatype\";s:7:\"-&gt;if\";s:11:\"description\";s:72:\"If the if-object returns false, stdWrap returns &quot;&quot; immediately\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:13:\"fieldRequired\";s:8:\"datatype\";s:16:\"<i>fieldname</i>\";s:11:\"description\";s:31:\"value in this field MUST be set\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:11:\"Parse data:\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:9:\"parseFunc\";s:8:\"datatype\";s:14:\"-&gt;parseFunc\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:10:\"HTMLparser\";s:8:\"datatype\";s:25:\"boolean / -&gt;HTMLparser\";s:11:\"description\";s:214:\"This object allows you to parse the HTML-content and make all kinds of advanced filterings on the content.\nValue must be set and properties are those of -&gt;HTMLparser.\n(See adminguide for -&gt;HTMLparser options)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:5:\"split\";s:8:\"datatype\";s:10:\"-&gt;split\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:10:\"prioriCalc\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:622:\"Calculation of the value using operators -+*/%^ plus respects priority to + and - operators and parenthesis levels ().\n. (period) is decimal delimiter.\nReturns a doublevalue.\nIf .prioriCalc is set to &quot;intval&quot; an integer is returned.\nThere is no errorchecking and division by zero or other invalid values may generate strange results. Also you use a proper syntax because future modifications to the function used may allow for more operators and features.\n&nbsp;\n<b>Examples:</b>\n100%7 = 2\n-5*-4 = 20\n+6^2 = 36\n6 ^(1+1) = 36\n-5*-4+6^2-100%7 &nbsp;= 54\n-5 * (-4+6) ^ 2 - 100%7 = 98\n-5 * ((-4+6) ^ 2) - 100%7 = -22\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:4:\"char\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:91:\"Content is set to the chr(<i>value</i>).\nPHP: $content=chr(intval($conf[&quot;char&quot;]);\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:6:\"intval\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:74:\"PHP function intval(); Returns an integer.\nPHP: $content=intval($content);\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:4:\"date\";s:8:\"datatype\";s:9:\"date-conf\";s:11:\"description\";s:234:\"The content should be data-type &quot;UNIX-time&quot;. Returns the content formatted as a date.\n$content=Date($conf[&quot;date&quot;], $content);\n&nbsp;\n<b>Example</b> where a timestamp is imported:\n.value.field = tstamp\n.value.date =\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:8:\"strftime\";s:8:\"datatype\";s:20:\"<i>strftime-conf</i>\";s:11:\"description\";s:210:\"Exactly like &quot;date&quot; above. See the PHP-manual (strftime) for the codes, or datatype &quot;strftime-conf&quot;.\nThis formatting is useful if the locale is set in advance in the CONFIG-object. See this.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:3:\"age\";s:8:\"datatype\";s:24:\"<i>boolean or string</i>\";s:11:\"description\";s:636:\"If enabled with a &quot;1&quot; (number, integer) the content is seen as a date (UNIX-time) and the difference from present time and the content-time is returned as one of these four variations:\n&quot;xx min&quot; or &quot;xx hrs&quot; or &quot;xx days&quot; or &quot;xx yrs&quot;\nThe limits between which layout is used are 60 minutes, 24 hours, 365 days,\n&nbsp;\n<b>NOTE: </b>\nIf you set this property with a non-integer, it\'s used to format the four units. This is the default value:\n&quot; min| hrs| days| yrs&quot;\n&nbsp;\nSet another string if you want to change the units. You may include the &quot;-signs. They are removed anyway.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:4:\"case\";s:11:\"description\";s:13:\"Converts case\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:31;a:6:{s:8:\"property\";s:5:\"bytes\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:58:\"Will format the input (an integer) as bytes: bytes, kb, mb\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:32;a:6:{s:8:\"property\";s:9:\"substring\";s:8:\"datatype\";s:16:\"[p1], &nbsp;[p2]\";s:11:\"description\";s:105:\"Returns the substring with [p1] and [p2] send as the 2nd and 3rd parameter to the PHP substring function.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:33;a:6:{s:8:\"property\";s:4:\"crop\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:459:\"Crops the content to a certain length\nSyntax: +/- (chars) = from left / from right | [string]\n&nbsp;\n<b>Examples:</b> &nbsp;\n<b>20 | ... </b>&nbsp;&nbsp;&nbsp;<i>=&gt; max 20 characters. If more, the value will be truncated to </i><b><i>first</i></b><i> 20 chars and prepended with &quot;...&quot;</i>\n<b>-20 | ...</b> <i>=&gt; max 20 characters. If more, the value will be truncated to </i><b><i>last</i></b><i> 20 chars and appended with &quot;...&quot;</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:34;a:6:{s:8:\"property\";s:9:\"stripHtml\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:21:\"Strips all html-tags.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:35;a:6:{s:8:\"property\";s:16:\"htmlSpecialChars\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:58:\"Parses the content through htmlspecialchars()-PHP-function\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:36;a:6:{s:8:\"property\";s:11:\"doubleBrTag\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:55:\"All double-line-breaks are substituted with this value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:37;a:6:{s:8:\"property\";s:2:\"br\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:60:\"PHP function nl2br(); Converts linebreaks to &lt;BR&gt;-tags\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:38;a:6:{s:8:\"property\";s:5:\"brTag\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:71:\"All ASCII-codes of &quot;10&quot; (CR) is substituted with <i>value</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:39;a:6:{s:8:\"property\";s:11:\"encapsLines\";s:8:\"datatype\";s:16:\"-&gt;encapsLines\";s:11:\"description\";s:115:\"Lets you split the content by chr(10) and proces each line independently. Used to format content made with the RTE.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:40;a:6:{s:8:\"property\";s:8:\"keywords\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:149:\"splits the content by characters &quot;,&quot; &quot;;&quot; and chr(10) (return), trims each value and returns a comma-separated list of the values.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:41;a:6:{s:8:\"property\";s:9:\"innerWrap\";s:8:\"datatype\";s:13:\"wrap /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:42;a:6:{s:8:\"property\";s:10:\"innerWrap2\";s:8:\"datatype\";s:13:\"wrap /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:43;a:6:{s:8:\"property\";s:7:\"fontTag\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:44;a:6:{s:8:\"property\";s:9:\"addParams\";s:8:\"datatype\";s:14:\"-&gt;addParams\";s:11:\"description\";s:74:\"Lets you add tag-parameters to the content <i>if </i>the content is a tag!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:45;a:6:{s:8:\"property\";s:9:\"textStyle\";s:8:\"datatype\";s:14:\"-&gt;textStyle\";s:11:\"description\";s:26:\"Wraps content in font-tags\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:46;a:6:{s:8:\"property\";s:10:\"tableStyle\";s:8:\"datatype\";s:15:\"-&gt;tableStyle\";s:11:\"description\";s:29:\"Wraps content with table-tags\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:47;a:6:{s:8:\"property\";s:8:\"filelink\";s:8:\"datatype\";s:13:\"-&gt;filelink\";s:11:\"description\";s:37:\"Used to make lists of links to files.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:48;a:6:{s:8:\"property\";s:10:\"preCObject\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:29:\"cObject prepended the content\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:49;a:6:{s:8:\"property\";s:11:\"postCObject\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:28:\"cObject appended the content\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:50;a:6:{s:8:\"property\";s:9:\"wrapAlign\";s:8:\"datatype\";s:14:\"align /stdWrap\";s:11:\"description\";s:89:\"Wraps content with &lt;DIV align=[<i>value</i>]&gt; | &lt;/DIV&gt; <i>if </i>align is set\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:51;a:6:{s:8:\"property\";s:8:\"typolink\";s:8:\"datatype\";s:13:\"-&gt;typolink\";s:11:\"description\";s:33:\"Wraps the content with a link-tag\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:52;a:6:{s:8:\"property\";s:11:\"spaceBefore\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:69:\"Pixels space before. Done with a clear-gif; &lt;img ...&gt;&lt;BR&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:53;a:6:{s:8:\"property\";s:10:\"spaceAfter\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:68:\"Pixels space after. Done with a clear-gif; &lt;img ...&gt;&lt;BR&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:54;a:6:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:5:\"space\";s:11:\"description\";s:52:\"[spaceBefore] &nbsp;&nbsp;| &nbsp;&nbsp;[spaceAfter]\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:55;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:17:\"wrap /+.splitChar\";s:11:\"description\";s:100:\".splitChar defines an alternative splitting character (default is &quot;|&quot; - the vertical line)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:56;a:6:{s:8:\"property\";s:10:\"noTrimWrap\";s:8:\"datatype\";s:24:\"&quot;special&quot; wrap\";s:11:\"description\";s:289:\"This wraps the content with the values val1 and val2 in the example below - including surrounding whitespace! - without trimming the values. Note that this kind of wrap requires a &quot;|&quot; &nbsp;character to begin and end the wrap.\n&nbsp;\n<b>Example:</b>\n| <b>val1</b> | <b>val2</b> |\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:57;a:6:{s:8:\"property\";s:5:\"wrap2\";s:8:\"datatype\";s:17:\"wrap /+.splitChar\";s:11:\"description\";s:16:\"<i>see .wrap</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:58;a:6:{s:8:\"property\";s:8:\"dataWrap\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:324:\"The content is parsed for sections of {...} and the content of {...} is of the type getText and substituted with the result of getText.\n&nbsp;\n<b>Example:</b>\nThis should result in a font-tag where the fontsize is decided by the global variable &quot;size&quot;:\n&lt;font size=&quot;{global : size}&quot;&gt; | &lt;/font&gt;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:59;a:6:{s:8:\"property\";s:7:\"prepend\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:37:\"cObject prepended to content (before)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:60;a:6:{s:8:\"property\";s:6:\"append\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:35:\"cObject appended to content (after)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:61;a:6:{s:8:\"property\";s:5:\"wrap3\";s:8:\"datatype\";s:17:\"wrap /+.splitChar\";s:11:\"description\";s:16:\"<i>see .wrap</i>\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:62;a:6:{s:8:\"property\";s:9:\"outerWrap\";s:8:\"datatype\";s:13:\"wrap /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:63;a:6:{s:8:\"property\";s:10:\"insertData\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:187:\"If set, then the content string is parsed like .dataWrap above.\n&nbsp;\n<b>Example:</b>\nDisplays the page title:\n10 = TEXT\n10.value = This is the page title: {page:title}\n10.insertData = 1\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:64;a:6:{s:8:\"property\";s:10:\"offsetWrap\";s:8:\"datatype\";s:3:\"x,y\";s:11:\"description\";s:370:\"This wraps the input in a table with columns to the left and top that offsets the content by the values of x,y. Based on the cObject OTABLE.\n&nbsp;\n<b>.tableParams / .tdParams +stdWrap</b>\n- used to manipulate tableParams/tdParams (default width=99%) &nbsp;of the offset. Default: See OTABLE.\n&nbsp;\n<b>.stdWrap</b>\n- stdWrap properties wrapping the offsetWrap\'ed output\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:65;a:6:{s:8:\"property\";s:12:\"postUserFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:757:\"Calling a PHP-function or method in a class, passing the current content to the function as first parameter and any properties as second parameter. Please see the description of the cObject USER for in-depth information.\n&nbsp;\n<b>Example:</b>\nYou can paste this example directly into a new template record.\n&nbsp;\npage = PAGE\npage.typeNum=0\nincludeLibs.something = media/scripts/example_callfunction.php\n&nbsp;\npage.10 = TEXT\npage.10 {\n&nbsp;&nbsp;value = Hello World\n&nbsp;&nbsp;postUserFunc = user_reverseString\n&nbsp;&nbsp;postUserFunc.uppercase = 1\n}\n&nbsp;\npage.20 = TEXT\npage.20 {\n&nbsp;&nbsp;value = Hello World\n&nbsp;&nbsp;postUserFunc = user_various-&gt;reverseString\n&nbsp;&nbsp;postUserFunc.uppercase = 1\n&nbsp;&nbsp;postUserFunc.typolink = 11\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:66;a:6:{s:8:\"property\";s:9:\"editIcons\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:1069:\"If not empty, then insert an icon linking to the typo3/alt_doc.php with some parameters to build and backend user edit form for certain fields.\nThe value of this property is a list of fields from a table to edit. It\'s assumed that the current record of the cObj is the record to be edited.\nSyntax: <i>optional tablename</i> : <i>comma list of fieldnames[list of pallette-field names separated by | ]</i>\n<i>&nbsp;</i>\n<b>.beforeLastTag</b> (boolean): If set, the icon will be inserted before the last HTML tag in the content.\n&nbsp;\n<b>.iconTitle (string): The title attribute of the image tag.</b>\n&nbsp;\n<b>Example:</b>\nThis will insert an edit icon which links to a form where the header and bodytext fields are displayed and made available for editing (provided the user has access!).\neditIcons = tt_content : header, bodytext\n&nbsp;\nOr this line that puts the header_align and date field into a &quot;palette&quot; which means they are displayed on a single line below the header field. This saves some space.\neditIcons = header[header_align|date], bodytext\n&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:67;a:6:{s:8:\"property\";s:9:\"editPanel\";s:8:\"datatype\";s:19:\"boolean / editPanel\";s:11:\"description\";s:22:\"See cObject EDITPANEL.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:68;a:6:{s:8:\"property\";s:5:\"debug\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:222:\"Prints content with HTMLSpecialChars() and &lt;PRE&gt;&lt;/PRE&gt;: Usefull for debugging which value stdWrap actually ends up with, if you\'re constructing a website with TypoScript.\nShould be used under construction only.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:69;a:6:{s:8:\"property\";s:9:\"debugFunc\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:186:\"Prints the content directly to browser with the debug() function.\nShould be used under construction only.\nSet to value &quot;2&quot; the content will be printed in a table - looks nicer.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:70;a:6:{s:8:\"property\";s:9:\"debugData\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:156:\"Prints the current data-array, $cObj-&gt;data, directly to browser. This is where &quot;.field&quot; gets data from.\nShould be used under construction only.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (160,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (248,270,'63743e1b082d6f7bcb449ddeb484466e','','tsref:(script).fe_adminLib.evalErrors.(field).(evalCode)','a:1:{s:4:\"rows\";a:8:{i:0;a:5:{s:8:\"property\";s:12:\"uniqueGlobal\";s:8:\"datatype\";s:149:\"This requires the value of the field to be globally unique, which means it must not exist in the same field of any other record in the current table.\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:2;}i:1;a:5:{s:8:\"property\";s:11:\"uniqueLocal\";s:8:\"datatype\";s:193:\"This is like uniqueGlobal, but the value is required to be unique <i>only</i> in the PID of the record. Thus if two records has different pid values, they may have the same value of this field.\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:2;}i:2;a:5:{s:8:\"property\";s:5:\"twice\";s:8:\"datatype\";s:330:\"This requires the value of the field to match the value of a secondary field name [fieldname]_again sent in the incoming formdata. THis is useful for entering password. Then if your password field is name &quot;user_pass&quot; then you simple add a second field name &quot;user_pass_again&quot; and then set the \'twice\' eval code.\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:2;}i:3;a:5:{s:8:\"property\";s:5:\"email\";s:8:\"datatype\";s:91:\"Requires the field value to be an email address at least on the form [name]@*[domain].[tld]\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:2;}i:4;a:5:{s:8:\"property\";s:8:\"required\";s:8:\"datatype\";s:70:\"Just simple required (trimmed value). 0 (zero) will evaluate to false!\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:2;}i:5;a:5:{s:8:\"property\";s:14:\"atLeast\natMost\";s:8:\"datatype\";s:145:\"Specifies a minimum / maximum of characters to enter in the fields.\n<b>Example</b>, that requires at least 5 characters: &nbsp;atleast [5] &nbsp;\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:2;}i:6;a:5:{s:8:\"property\";s:8:\"inBranch\";s:8:\"datatype\";s:301:\"inBranch requires the value (typically of a pid-field) to be among a list of page-id\'s (pid\'s) specified with the inBranch parameters. The parameters are given like <i>[root_pid; depth; beginAt]</i>\n<b>Example</b>, which will return a list of pids one level deep from page 4 (included): inBranch [4;1]\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:2;}i:7;a:5:{s:8:\"property\";s:10:\"unsetEmpty\";s:8:\"datatype\";s:191:\"This evaluation does not result in any error code. Only it simply unsets the field if the value of the field is empty. Thus it\'ll not override any current value if the field value is not set.\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:2;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (206,270,'7831f428e4ab5909c05af00f0f34071e','','tsref:(cObject).CASE','a:1:{s:4:\"rows\";a:6:{i:0;a:6:{s:8:\"property\";s:10:\"setCurrent\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:35:\"Sets the &quot;current&quot;-value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:3:\"key\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:11:\"This is the\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:7:\"default\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:8:\"Array...\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:7:\"stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:2:\"if\";s:8:\"datatype\";s:7:\"-&gt;if\";s:11:\"description\";s:51:\"if &quot;if&quot; returns false nothing is returned\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (207,270,'11559da8560e5a25a5d94dc2ababdc78','','tsref:(cObject).LOAD_REGISTER','a:1:{s:4:\"rows\";a:1:{i:0;a:6:{s:8:\"property\";s:27:\"Array... &nbsp;\n[fieldname]\";s:8:\"datatype\";s:15:\"string /stdWrap\";s:11:\"description\";s:289:\"<b>Example:</b>\n(This sets &quot;contentWidth&quot;, &quot;label&quot; and &quot;head&quot;)\n&nbsp;\npage.27 = LOAD_REGISTER\npage.27 {\n&nbsp;&nbsp;contentWidth = 500\n&nbsp;\n&nbsp;&nbsp;label.field = header\n&nbsp;\n&nbsp;&nbsp;head = some text\n&nbsp;&nbsp;head.wrap = &lt;B&gt; | &lt;/B&gt;\n}\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (162,270,'55c26a687f8d1b0129528eebb292efae','','tsref:-&gt;imgResource','a:1:{s:4:\"rows\";a:17:{i:0;a:6:{s:8:\"property\";s:3:\"ext\";s:8:\"datatype\";s:24:\"imageExtension /\nstdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:3:\"web\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:5:\"width\";s:8:\"datatype\";s:16:\"pixels / stdWrap\";s:11:\"description\";s:188:\"If both the width and heigth is set and one of the numbers has an &quot;m&quot; after it, the proportions will be preserved and thus width/height will work as max-dimensions for the image.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:6:\"height\";s:8:\"datatype\";s:16:\"pixels / stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:6:\"params\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:75:\"ImageMagick command-line:\nfx. &quot;-rotate 90&quot; or &quot;-negate&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:6:\"sample\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:124:\"If set, -sample is used to scale images instead of -geometry. Sample does not use antialiasing and is therefore much faster.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:19:\"alternativeTempPath\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:116:\"Enter an alternative path to use for temp images. Must be found in the list in TYPO3_CONF_VARS[FE][allowedTempPaths]\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:5:\"frame\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:86:\"Chooses which frame in an gif-animation or pdf-file.\n&quot;&quot; = first frame (zero)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:6:\"import\";s:8:\"datatype\";s:14:\"path / stdWrap\";s:11:\"description\";s:274:\"<i>value</i> should be set to the path of the file\nwith stdWrap you get the filename from the data-array\n&nbsp;\n<b>Example:</b>\nThis returns the first image in the field &quot;image&quot; from the data-array:\n.import = uploads/pics/\n.import.field = image\n.import.listNum = 0\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:4:\"maxW\";s:8:\"datatype\";s:16:\"pixels / stdWrap\";s:11:\"description\";s:9:\"Max width\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:4:\"maxH\";s:8:\"datatype\";s:16:\"pixels / stdWrap\";s:11:\"description\";s:10:\"Max height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:4:\"minW\";s:8:\"datatype\";s:6:\"pixels\";s:11:\"description\";s:31:\"Min width (overrules maxW/maxH)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:4:\"minH\";s:8:\"datatype\";s:6:\"pixels\";s:11:\"description\";s:32:\"Min height (overrules maxW/maxH)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:35:\"Masking:\n(Black hides, white shows)\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:6:\"m.mask\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:253:\"The mask by which the image is masked onto &quot;m.bgImg&quot;. Both &quot;m.mask&quot; and &quot;m.bgImg&quot; <b>is scaled to fit</b> the size of the imgResource image!\n<b>NOTE:</b> Both &quot;m.mask&quot; and &quot;m.bgImg&quot; must be valid images.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:7:\"m.bgImg\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:82:\"<b>NOTE:</b> Both &quot;m.mask&quot; and &quot;m.bgImg&quot; must be valid images.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:11:\"m.bottomImg\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:415:\"An image masked by &quot;m.bottomImg_mask&quot; onto &quot;m.bgImg&quot; before the imgResources is masked by &quot;m.mask&quot;. \nBoth &quot;m.bottomImg&quot; and &quot;m.bottomImg_mask&quot; <b>is scaled to fit</b> the size of the imgResource image!\nThis is most often used to create an underlay for the imgResource.\n<b>NOTE:</b> Both &quot;m.bottomImg&quot; and &quot;m.bottomImg_mask&quot; must be valid images.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:16:\"m.bottomImg_mask\";s:8:\"datatype\";s:11:\"imgResource\";s:11:\"description\";s:107:\"(optional)\n<b>NOTE:</b> Both &quot;m.bottomImg&quot; and &quot;m.bottomImg_mask&quot; must be valid images.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (154,270,'255d01ae1b0d5003500f17aeccc21a14','','nbsp;','a:1:{s:4:\"rows\";a:34:{i:0;a:5:{s:8:\"property\";s:11:\"&lt;tag&gt;\";s:8:\"datatype\";s:43:\"<b>&lt;BODY bgcolor=&quot;red&quot;&gt;</b>\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:1;a:5:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:12:\"<b>right</b>\";s:11:\"description\";s:70:\"<b>right / left / center</b>\nDecides alignment, typically in HTML-tags\";s:7:\"default\";s:4:\"left\";s:12:\"column_count\";i:4;}i:2;a:5:{s:8:\"property\";s:7:\"VHalign\";s:8:\"datatype\";s:70:\"<i>Hori.align = right and Vert.align = center:</i>\n<b>r , c &nbsp;</b>\";s:11:\"description\";s:94:\"<b>r/c/l , t/c/b</b>\nHorizontal (right, center, left) , Vertical align (top / center / bottom)\";s:7:\"default\";s:5:\"l , t\";s:12:\"column_count\";i:4;}i:3;a:5:{s:8:\"property\";s:8:\"resource\";s:8:\"datatype\";s:104:\"<i>From the resourcefield:</i>\ntoplogo*.gif\n&nbsp;\n<i>Reference to filesystem:</i>\nfileadmin/picture.gif\";s:11:\"description\";s:572:\"1) A reference to a file from the resource-field in the template.\nYou can write the exact filename or you can include an asterisk (*) as wildcard.\nIt\'s recommended to include a &quot;*&quot; before the fileextension (see example to the left). This will ensure that the file is still referenced correct even if the template is copied and the file will have it\'s name prepended with numbers!!\n2) If the value contains a &quot;/&quot; it\'s expected to be a reference (absolute or relative) to a file on the file-system instead of the resource-field. No support for wildcards.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:4;a:5:{s:8:\"property\";s:11:\"imgResource\";s:8:\"datatype\";s:173:\"Here &quot;file&quot; is a imgResource:\nfile = toplogo*.gif\nfile.width = 200\n&nbsp;\nGIFBUILDER:\nfile = GIFBUILDER\nfile {\n&nbsp;&nbsp;&nbsp;... (GIFBUILDER-properties here)\n}\";s:11:\"description\";s:362:\"1) A &quot;resource&quot; (see above) + imgResource-properties (see example to the left and object-reference below)\nFiletypes can be anything among the allowed types defined in the configuration variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n&nbsp;\n2) GIFBUILDER-object\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:5;a:5:{s:8:\"property\";s:9:\"HTML-code\";s:8:\"datatype\";s:43:\"<b>&lt;B&gt;Some text in bold&lt;/B&gt;</b>\";s:11:\"description\";s:14:\"pure HTML-code\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:6;a:5:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:40:\"<b>_top</b>\n<b>_blank</b>\n<b>content</b>\";s:11:\"description\";s:117:\"target in &lt;A&gt;-tag.\nThis is normally the same value as the name of the root-level object that defines the frame.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:7;a:5:{s:8:\"property\";s:14:\"imageExtension\";s:8:\"datatype\";s:67:\"<b>jpg</b>\n<b>web&nbsp;&nbsp;&nbsp;&nbsp;<i>(gif or jpg ..)</i></b>\";s:11:\"description\";s:379:\"Image extensions can be anything among the allowed types defined in the global variable $TYPO3_CONF_VARS[&quot;GFX&quot;][&quot;imagefile_ext&quot;] (localconf.php). Standard is pdf,gif,jpg,jpeg,tif,bmp,ai,pcx,tga,png.\n<b>The value &quot;web&quot;</b> is special. This will just ensure that an image is converted to a web imageformat (gif or jpg) if it happens not to be already!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:8;a:5:{s:8:\"property\";s:6:\"degree\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:19:\"-90 to 90, integers\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:9;a:5:{s:8:\"property\";s:13:\"posint / int+\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:16:\"Positive integer\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:10;a:5:{s:8:\"property\";s:3:\"int\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:112:\"integer\n(sometimes used generally though another type would have been more appropriate, like &quot;pixels&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:11;a:5:{s:8:\"property\";s:20:\"str / string / value\";s:8:\"datatype\";s:13:\"<b>&nbsp;</b>\";s:11:\"description\";s:111:\"string.\n(sometimes used generally though another type would have been more appropriate, like &quot;align&quot;)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:12;a:5:{s:8:\"property\";s:7:\"boolean\";s:8:\"datatype\";s:8:\"<b>1</b>\";s:11:\"description\";s:61:\"boolean\nnon-empty strings (but not zero) are &quot;true&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:13;a:5:{s:8:\"property\";s:8:\"rotation\";s:8:\"datatype\";s:6:\"&nbsp;\";s:11:\"description\";s:29:\"integer, degrees from 0 - 360\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:14;a:5:{s:8:\"property\";s:7:\"x,y,w,h\";s:8:\"datatype\";s:16:\"<b>10,10,5,5</b>\";s:11:\"description\";s:73:\"x,y is the offset from the upper left corner.\nw,h is the width and height\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:15;a:5:{s:8:\"property\";s:10:\"HTML-color\";s:8:\"datatype\";s:26:\"<b>red</b>\n<b>#ffeecc </b>\";s:11:\"description\";s:581:\"<b>HTML-color codes:</b>\n&nbsp;\nBlack = &quot;#000000&quot; &nbsp;&nbsp;\nSilver = &quot;#C0C0C0&quot; &nbsp;&nbsp;\nGray = &quot;#808080&quot; &nbsp;&nbsp;\nWhite = &quot;#FFFFFF&quot; &nbsp;&nbsp;\nMaroon = &quot;#800000&quot; &nbsp;&nbsp;\nRed = &quot;#FF0000&quot; &nbsp;&nbsp;\nPurple = &quot;#800080&quot; &nbsp;&nbsp;\nFuchsia = &quot;#FF00FF&quot; &nbsp;&nbsp;\nGreen = &quot;#008000&quot;\nLime = &quot;#00FF00&quot;\nOlive = &quot;#808000&quot;\nYellow = &quot;#FFFF00&quot;\nNavy = &quot;#000080&quot;\nBlue = &quot;#0000FF&quot;\nTeal = &quot;#008080&quot;\nAqua = &quot;#00FFFF&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:16;a:5:{s:8:\"property\";s:12:\"GraphicColor\";s:8:\"datatype\";s:440:\"<b>red<i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>#ffeecc <i>&nbsp;&nbsp;&nbsp;&nbsp;(HTML-color)</i></b>\n<b>255,0,255<i>&nbsp;&nbsp;&nbsp;&nbsp;(RGB-integers)</i></b>\n<i>&nbsp;</i>\n<i>Extra:</i>\n<b>red<i> : *0.8</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;red&quot; is darkend by factor 0.8)</i></b>\n<b>#ffeecc <i>: +16</i><i>&nbsp;&nbsp;&nbsp;&nbsp;(&quot;ffeecc&quot; is going to #fffedc because 16 is added)</i></b>\n<b><i>&nbsp;</i></b>\";s:11:\"description\";s:393:\"The color can be given as HTML-colors or as a comma-seperated list of RGB-values (integers)\nYou can add an extra parameter that will modify the color mathematically:\nSyntax: &nbsp;\n[colordef] : [modifier]\nwhere modifier can be and integer which is added/subtracted to the three RGB-channels or a floatingpoint with an &quot;*&quot; before, which will then multiply the values with that factor.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:17;a:5:{s:8:\"property\";s:7:\"page_id\";s:8:\"datatype\";s:21:\"<b>this</b>\n<b>34</b>\";s:11:\"description\";s:54:\"A page id (int) or &quot;this&quot; (=current page id)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:18;a:5:{s:8:\"property\";s:6:\"pixels\";s:8:\"datatype\";s:10:\"<b>345</b>\";s:11:\"description\";s:14:\"pixel-distance\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:19;a:5:{s:8:\"property\";s:4:\"list\";s:8:\"datatype\";s:23:\"<b>item,item2,item3</b>\";s:11:\"description\";s:14:\"list of values\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:20;a:5:{s:8:\"property\";s:7:\"margins\";s:8:\"datatype\";s:105:\"<i>This sets leftmargin to 10 and bottom-margin to 5. Top and right is not set (zero)</i>\n<b>10,0,0,5</b>\";s:11:\"description\";s:32:\"l,t,r,b\nleft, top, right, bottom\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:21;a:5:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:142:\"<i>This will cause the value to be wrapped in a font-tag coloring the value red:</i>\n<b>&lt;font color=&quot;red&quot;&gt; | &lt;/font&gt;</b>\";s:11:\"description\";s:153:\"&lt;...&gt; | &lt;/...&gt;\nUsed to wrap something. The part on the left and right of the vertical line is placed on the left and right side of the value.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:22;a:5:{s:8:\"property\";s:8:\"linkWrap\";s:8:\"datatype\";s:115:\"<i>This will make a link to the root-level of a website:</i>\n<b>&lt;A HREF=&quot;?id={0}&quot;&gt; | &lt;/A&gt;</b>\";s:11:\"description\";s:342:\"&lt;.. {x}.&gt; | &lt;/...&gt;\n{x}; x is an integer (0-9) and points to a key in the PHP-array rootLine. The key is equal to the level the current page is on measured relatively to the root of the website.\nIf the key exists the uid of the level that key pointed to is inserted instead of {x}.\nThus we can insert page_ids from previous levels.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:23;a:5:{s:8:\"property\";s:4:\"case\";s:8:\"datatype\";s:12:\"<b>upper</b>\";s:11:\"description\";s:53:\"&quot;upper&quot; / &quot;lower&quot;\nCase-conversion\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:24;a:5:{s:8:\"property\";s:5:\"space\";s:8:\"datatype\";s:12:\"<b>5 | 5</b>\";s:11:\"description\";s:86:\"&quot;before | after&quot;\nUsed for content and sets space &quot;before | after&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:25;a:5:{s:8:\"property\";s:9:\"date-conf\";s:8:\"datatype\";s:60:\"<b>d-m-y&nbsp;&nbsp;&nbsp;&nbsp;<i>(dd-mm-yy format)</i></b>\";s:11:\"description\";s:861:\"See PHP function Date()!\n&nbsp;\na - &quot;am&quot; or &quot;pm&quot;\nA - &quot;AM&quot; or &quot;PM&quot;\nd - day of the month, numeric, 2 digits (with leading zeros)\nD - day of the week, textual, 3 letters; i.e. &quot;Fri&quot;\nF - month, textual, long; i.e. &quot;January&quot;\nh - hour, numeric, 12 hour format\nH - hour, numeric, 24 hour format\ni - minutes, numeric\nj - day of the month, numeric, without leading zeros\nl (lowercase \'L\') - day of the week, textual, long; i.e. &quot;Friday&quot;\nm - month, numeric\nM - month, textual, 3 letters; i.e. &quot;Jan&quot;\ns - seconds, numeric\nS - English ordinal suffix, textual, 2 characters; i.e. &quot;th&quot;, &quot;nd&quot;\nU - seconds since the epoch\nY - year, numeric, 4 digits\nw - day of the week, numeric, 0 represents Sunday\ny - year, numeric, 2 digits\nz - day of the year, numeric; i.e. &quot;299&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:26;a:5:{s:8:\"property\";s:13:\"strftime-conf\";s:8:\"datatype\";s:113:\"Date &quot;DD-MM-YY&quot; = \n<b>%e:%m:%y</b>\nTime &quot;HH:MM:SS&quot; = \n<b>%H:%M:%S</b>\nor &nbsp;just\n<b>%T</b>\";s:11:\"description\";s:2115:\"%a - abbreviated weekday name according to the current locale\n%A - full weekday name according to the current locale\n%b - abbreviated month name according to the current locale\n%B - full month name according to the current locale\n%c - preferred date and time representation for the current locale\n%C - century number (the year divided by 100 and truncated to an integer, range 00 to 99)\n%d - day of the month as a decimal number (range 00 to 31)\n%D - same as %m/%d/%y\n<b>%e - day of the month as a decimal number, a single digit is preceded by a space (range \' 1\' to \'31\') </b>\n%h - same as %b\n<b>%H - hour as a decimal number using a 24-hour clock (range 00 to 23) </b>\n%I - hour as a decimal number using a 12-hour clock (range 01 to 12)\n%j - day of the year as a decimal number (range 001 to 366)\n<b>%m - month as a decimal number (range 01 to 12) </b>\n<b>%M - minute as a decimal number </b>\n%n - newline character\n%p - either `am\' or `pm\' according to the given time value, or the corresponding strings for the current locale\n%r - time in a.m. and p.m. notation\n%R - time in 24 hour notation\n<b>%S - second as a decimal number </b>\n%t - tab character\n%T - current time, equal to %H:%M:%S\n%u - weekday as a decimal number [1,7], with 1 representing Monday\n%U - week number of the current year as a decimal number, starting with the first Sunday as the first day of the first week\n%V - The ISO 8601:1988 week number of the current year as a decimal number, range 01 to 53, where week 1 is the first week that has at least 4 days in the current year, and with Monday as the first day of the week.\n%W - week number of the current year as a decimal number, starting with the first Monday as the first day of the first week\n%w - day of the week as a decimal, Sunday being 0\n%x - preferred date representation for the current locale without the time\n%X - preferred time representation for the current locale without the date\n<b>%y - year as a decimal number without a century (range 00 to 99) </b>\n%Y - year as a decimal number including the century\n%Z - time zone or name or abbreviation\n%% - a literal `%\' character\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:27;a:5:{s:8:\"property\";s:9:\"UNIX-time\";s:8:\"datatype\";s:52:\"<i>Seconds to 07/04 2000 23:58:</i>\n<b>955144722</b>\";s:11:\"description\";s:25:\"Seconds since 1/1 1970...\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:28;a:5:{s:8:\"property\";s:4:\"path\";s:8:\"datatype\";s:23:\"<i>fileadmin/stuff/</i>\";s:11:\"description\";s:53:\"path relative to the directory from which we operate.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:29;a:5:{s:8:\"property\";s:16:\"&lt;tag&gt;-data\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:73:\"<b>Example:</b>\n<i>&lt;frameset&gt;-data: row</i>\ncould be \'<i>150,*</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:30;a:5:{s:8:\"property\";s:18:\"&lt;tag&gt;-params\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:112:\"<b>Example:</b>\n<i>&lt;frameset&gt;-params</i>\ncould be \'<i>border=&quot;0&quot; framespacing=&quot;0&quot;</i>\'\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:31;a:5:{s:8:\"property\";s:7:\"getText\";s:8:\"datatype\";s:1830:\"<i>get content from the $cObj-&gt;data-array[<b>header</b>]:</i>\n<b>= field : header</b>\n<i>get content from the $cObj-&gt;parameters-array[<b>color</b>]:</i>\n<b>= parameter : color</b>\n<i>get content from the $GLOBALS[&quot;TSFE&quot;]-&gt;register[<b>color</b>]:</i>\n<b>= register : color</b>\n<i>get the title of the page on the first level of the rootline:</i>\n<b>= leveltitle : 1</b>\n<i>get the title of the page on the level right below the current page AND if that is not present, walt to the bottom of the rootline until there\'s a title:</i>\n<b>= leveltitle : -2 , slide</b>\n<i>get the id of the root-page of the website (level zero)</i>\n<b>= leveluid : 0</b>\n<i>get the env var HTTP_REFERER:</i>\n<b>= getenv : HTTP_REFERER</b>\n<i>get the env variable $HTTP_COOKIE_VARS[some_cookie]:</i>\n<b>= global : HTTP_COOKIE_VARS | some_cookie</b>\n<i>get the current time formatted dd-mm-yy:</i>\n<b>= date : d-m-y</b>\n<i>get the current page-title:</i>\n<b>= page : title</b>\n<i>get the current value:</i>\n<b>= current : 1</b>\nget input value from query string, (&amp;stuff=)\n<b>= GPvar : stuff</b>\nget the current id\n<b>= TSFE : id</b>\nget the value of the header of record with uid 234 from table tt_content:\n<b>= DB : tt_content:234:header</b>\n<b>= fullRootLine : -1, title</b>\nThis gets the title &quot;1. page before&quot; in a page tree like the one below provided we are are the page &quot;Here you are!&quot; (or &quot;Site root&quot;) and this TypoScript is in the template with root at &quot;Site root&quot;. Red numbers indicate what values of <i>keynumber</i> would point to:\n- Page tree root &nbsp;&nbsp;-2\n&nbsp;&nbsp;&nbsp;|- 1. page before &nbsp;&nbsp;-1 \n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Site root (root template here!) &nbsp;&nbsp;0\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|- Here you are! &nbsp;1\";s:11:\"description\";s:2493:\"This returns a value from somewhere in PHP-array, defined by the type. The syntax is &quot;type : pointer&quot;\n&nbsp;\n<b>field :</b> [fieldname from the current <i>$cObj</i>-&gt;data-array in the cObj.]\nAs default the <i>$cObj</i>-&gt;data-array is $GLOBALS[&quot;TSFE&quot;]-&gt;page (record of the current page!)\nIn TMENU: <i>$cObj</i>-&gt;data is set to the page-record for each menuitem.\nIn CONTENT/RECORDS <i>$cObj</i>-&gt;data is set to the actual record\nIn GIFBUILDER <i>$cObj</i>-&gt;data is set to the data GIFBUILDER is supplied with.\n<b>parameter :</b> [fieldname from the current <i>$cObj</i>-&gt;parameters-array in the cObj.]\nSee &nbsp;-&gt;parseFunc!\n<b>register :</b> [fieldname from the $GLOBALS[&quot;TSFE&quot;]-&gt;register]\nSee cObject &quot;LOAD_REGISTER&quot;\n<b>leveltitle, leveluid, levelmedia:</b> [levelTitle, uid or media in rootLine, 0- , negative = from behind, &quot; , slide&quot; parameter forces a walk to the bottom of the rootline until there\'s a &quot;true&quot; value to return. Useful with levelmedia.]\n<b>global :</b> [GLOBAL-var, split with | if you want to get from an array! DEPRECIATED, use GPvar, TSFE or getenv]\n<b>date :</b> [date-conf]\n<b>page :</b> [current page record]\n<b>current : 1</b> (gets \'current\' value)\n<b>level : 1 &nbsp;(gets the rootline level of the current page)</b>\n<b>GPvar:</b> Value from GET or POST method. Use this instead of global\n<b>TSFE: </b>Value from TSFE global main object\n<b>getenv:</b> Value from environment vars\n<b>DB:</b> Value from database, syntax is [tablename] : [uid] : [field]. Any record from a table in TCA can be selected here. Only marked-deleted records does not return a value here.\n<b>--------------------</b>\n<b>Getting more values.</b>\nBy separating the value of getText with &quot;//&quot; (double slash) you let getText fetch the first value. If it appears empty (&quot;&quot; or zero) the next value is fetched and so on. Example:\n= field:header // field:title // field:uid\nThis gets &quot;title&quot; if &quot;header&quot; is empty. If &quot;title&quot; is also empty it gets field &quot;uid&quot;\n<b>fullRootLine </b>:\nGetting a value from the rootline (TSFE-&gt;rootLine) going all the way to the root of the page tree.\n<i>[keynumber, fieldname, &quot;slide&quot;]</i>\nKeynumber is relative to the current site root, so negative numbers refer to subsequent levels below the site root. Fieldname is the name of the datafield to get. For &quot;slide&quot;, see <i>levelmedia</i> type above.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:32;a:5:{s:8:\"property\";s:3:\"dir\";s:8:\"datatype\";s:236:\"<i>returns a list of all pdf, gif and jpf-filer from fileadmin/files/ sorted by their name</i> reversely and with the full path (with &quot;<i>fileadmin/files/&quot; prepended)</i>\n<b>fileadmin/files/ | pdf,gif,jpg | name</b> | r | true\";s:11:\"description\";s:383:\"[path relative to the webroot of the site] | [list of valid extensions] | [sorting: name, size, ext, date] | &nbsp;[reverse: &quot;r&quot;] &nbsp;| &nbsp;[return full path: boolean\nFiles matching is returned in a comma-separated string.\n<b>Note:</b>\nThe value of config-option &quot;lockFilePath&quot; must equal the first part of the path. Thereby the path is locked to that folder.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;}i:33;a:5:{s:8:\"property\";s:13:\"function-name\";s:8:\"datatype\";s:98:\"Function:\n<b>user_reverseString</b>\nMethod in class:\n<b>user_stringReversing-&gt;reverseString</b>\";s:11:\"description\";s:741:\"Indicates a function or method in a class to call. See more information at the USER cObject.\nDepending on implementation the class or function name (but not the method name) should probably be prefixed with &quot;user_&quot;. This can be changed in the TYPO3_CONF_VARS config though. Also the function / method is normally called with 2 parameters, typ. $conf (TS config) and $content (some content to be processed and returned)\nAlso if you call a method in a class, it is checked (when using the USER/USER_INT objects) whether a class with the same name, but prefixed with &quot;ux_&quot; is present and if so, this class is instantiated instead. See &quot;Inside Typo3&quot; document for more information on extending the classes in Typo3!\";s:7:\"default\";s:13:\"<b>&nbsp;</b>\";s:12:\"column_count\";i:4;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (250,270,'824b1ba31d52dfeb00b9afbcb7790c9b','','tsref:(script).plaintextLib','a:1:{s:4:\"rows\";a:28:{i:0;a:6:{s:8:\"property\";s:7:\"siteUrl\";s:8:\"datatype\";s:3:\"url\";s:11:\"description\";s:16:\"Url of the site.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:13:\"defaultOutput\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:40:\"Default output if CType is not rendered.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:14:\"uploads.header\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:18:\"Header for uploads\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:13:\"images.header\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:17:\"Header for images\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:20:\"images.captionHeader\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:24:\"Header for imagecaptions\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:17:\"images.linkPrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:22:\"Prefix for image-links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:7:\".header\";s:8:\"datatype\";s:0:\"\";s:11:\"description\";s:0:\"\";s:7:\"default\";s:0:\"\";s:12:\"column_count\";i:1;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:11:\"defaultType\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:28:\"Which type to use as default\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:4:\"date\";s:8:\"datatype\";s:11:\"date-config\";s:11:\"description\";s:15:\"For header date\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:10:\"datePrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:22:\"Prefix for header date\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:10:\"linkPrefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:23:\"Prefix for header links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:16:\"[1-5].preLineLen\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:28:\"Lenght of line before header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:17:\"[1-5].postLineLen\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:27:\"Lenght of line after header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:15:\"[1-5].preBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:35:\"Number of blank lines before header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:16:\"[1-5].postBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:34:\"Number of blank lines after header\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:13:\"[1-5].stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:15:\"for header text\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:17:\"[1-5].preLineChar\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:21:\"Character to pre-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:18:\"[1-5].postLineChar\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:22:\"Character to post-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:19:\"[1-5].preLineBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:49:\"Number of blank lines between header and pre-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:20:\"[1-5].postLineBlanks\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:50:\"Number of blank lines between header and post-line\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:16:\"[1-5].autonumber\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:111:\"If set, a number is prepended every header. The number corresponds to the content element number in the select.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:12:\"[1-5].prefix\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:20:\"Header string prefix\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:23:\"bulletlist.[0-3].bullet\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:36:\"Bullet for bullet list, layout [0-3]\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:26:\"bulletlist.[0-3].secondRow\";s:8:\"datatype\";s:16:\"untrimmed string\";s:11:\"description\";s:65:\"If set, this is used for lines on the second row of bullet-lists.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:4:\"menu\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:137:\"cObject to render menu. The output is stripped for tags and the links is extracted. Further all &lt;BR&gt; chars are converted to chr(10)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:8:\"shortcut\";s:8:\"datatype\";s:7:\"cObject\";s:11:\"description\";s:129:\"cObject to render other elements. See config below which simply uses this object to render more tt_content elements as plaintext.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:16:\"bodytext.stdWrap\";s:8:\"datatype\";s:12:\"-&gt;stdWrap\";s:11:\"description\";s:48:\"stdWrap for body-text. See config example below.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:8:\"userProc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:195:\"Lets you proces the output of each content element before it finally is returned. Property &quot;parentObj&quot; of the conf-array holds a references to the plainText object calling the function.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (171,270,'9a0c31e828f7b074a48c5e5a788dfa6c','','tsref:-&gt;tableStyle','a:1:{s:4:\"rows\";a:7:{i:0;a:6:{s:8:\"property\";s:5:\"align\";s:8:\"datatype\";s:14:\"align /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:6:\"border\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:11:\"cellspacing\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:11:\"cellpadding\";s:8:\"datatype\";s:12:\"int /stdWrap\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:11:\"color.field\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:46:\"Set to fieldname from the $cObj-&gt;data-array\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:29:\"color.default\ncolor.1\ncolor.2\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:39:\"[default],[1],[2] = User defined\n&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:6:\"params\";s:8:\"datatype\";s:20:\"&lt;TABLE&gt;-params\";s:11:\"description\";s:6:\"&nbsp;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (232,270,'397a0804fc8ada0e121f0a17e8bf8dd4','','tsref:(cObject).HMENU.(mObj).GMENU','a:1:{s:4:\"rows\";a:18:{i:0;a:6:{s:8:\"property\";s:2:\"RO\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:155:\"RollOver configuration enabled / disabled.\nIf this is true, RO becomes a GIFBUILDER-object defining the layout of the menuitem when the mouse rolls over it\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:6:\"expAll\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:252:\"If this is true, the menu will always show the menu on the level underneath the menuitem. This corresponds to a situation where a user has clicked a menuitem and the menu folds out the next level. This can enable that to happen on all items as default.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:8:\"collapse\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:116:\"If set, &quot;active&quot; menuitems that has expanded the next level on the menu will now collapse that menu again.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:9:\"accessKey\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:44:\"If set access-keys are set on the menu-links\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:6:\"noBlur\";s:8:\"datatype\";s:7:\"Boolean\";s:11:\"description\";s:218:\"Normally graphical links are &quot;blurred&quot; if the browser is MSIE. Blurring removes the ugly box around a clicked link.\nIf this property is set, the link is NOT blurred (browser-default) with &quot;onFocus&quot;.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:6:\"target\";s:8:\"datatype\";s:6:\"target\";s:11:\"description\";s:23:\"Target of the menulinks\";s:7:\"default\";s:4:\"self\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:14:\"forceTypeValue\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:141:\"If set, the &amp;type parameter of the link is forced to this value regardless of target. Overrides the global equivalent in \'config\' if set.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:4:\"wrap\";s:8:\"datatype\";s:4:\"wrap\";s:11:\"description\";s:43:\"Wraps only if there were items in the menu!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:11:\"applyTotalH\";s:8:\"datatype\";s:20:\"objNumsList (offset)\";s:11:\"description\";s:480:\"This adds the total height of the previously generated menuitems to the offset of the GifBuilderObj\'s mentioned in this list.\n&nbsp;\n<b>Example:</b>\nThis is useful it you want to create a menu with individual items but a common background image that extends to the whole area behind the menu. Then you should setup the background image in each GIFBUILDER-object and include the object-number in this list.\nLook at the implementation in static_template &quot;styles.gmenu.bug&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:11:\"applyTotalW\";s:8:\"datatype\";s:20:\"objNumsList (offset)\";s:11:\"description\";s:124:\"This adds the total width of the previously generated menuitems to the offset of the GifBuilderObj\'s mentioned in this list.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:3:\"min\";s:8:\"datatype\";s:13:\"x,y (calcInt)\";s:11:\"description\";s:54:\"Forces the menu as a whole to these minimum dimensions\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:3:\"max\";s:8:\"datatype\";s:13:\"x,y (calcInt)\";s:11:\"description\";s:54:\"Forces the menu as a whole to these maximum dimensions\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:15:\"useLargestItemX\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:81:\"If set, then the width of all menuitems will be equal to the largest of them all.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:15:\"useLargestItemY\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:82:\"If set, then the height of all menuitems will be equal to the largest of them all.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:20:\"removeObjectsOfDummy\";s:8:\"datatype\";s:11:\"objNumsList\";s:11:\"description\";s:259:\"If the menu is forced to a certain minimum dimension, this is a list of objects in the gifbuilder-object that is removed for this last item. This is important to do if the menuitems has elements that should only be applied if the item is actually a menuitem!!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:14:\"disableAltText\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:112:\"If set, the alt-parameter of the images are not set. You can do it manually by &quot;imgParams&quot; (see below)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:9:\"IProcFunc\";s:8:\"datatype\";s:13:\"function-name\";s:11:\"description\";s:327:\"The internal array &quot;I&quot; is passed to this function and expected returned as well. Subsequent to this function call the menu item is compiled by implode()\'ing the array $I[parts] in the passed array. Thus you may modify this if you need to.\nSee example on the testsite and in media/scripts/example_itemArrayProcFunc.php\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:70:\"[Common Item States, see above]\n+ rollover version for all, except SPC\";s:8:\"datatype\";s:364:\"-&gt;GIFBUILDER\n+ .wrap (= wrap)\n+ .noLink (boolean, if set, the item is NOT linked!)\n+.imgParams (params: parameters for the &lt;img&gt;-tag)\n+ .altTarget which overrides the target defined for the GMENU.\n+ .altImgResource (datatype = imgResource) which defines an alternative image to use. If an image returns here, it will override any GIFBUILDER configuration.\";s:11:\"description\";s:528:\"This is the GIFBUILDER-options for each category of menuitem that can be generated.\n&nbsp;\n<b>NOTE:</b> For the GMENU series you can also define the RollOver configuration for the item states. This means that you define the GIFBUILDER object for the \'Active\' state by ACT and the RollOver GIFBUILDER object for the \'Active\' state by ACTRO.\nThis pattern goes for ALL the states except the SPC state.\n&nbsp;\n<b>SPECIAL:</b>\nThe -&gt;OptionSplit function is run on the whole GIFBUILDER-configuration before the items are generated.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (231,270,'2c8d1fb6db707d441cd5769786710a19','','tsref:(cObject).HMENU.(mObj_itemStates)','a:1:{s:4:\"rows\";a:8:{i:0;a:6:{s:8:\"property\";s:5:\"IFSUB\";s:8:\"datatype\";s:18:\"Boolean / (config)\";s:11:\"description\";s:54:\"Enable/Configuration for menu items which has subpages\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:3:\"ACT\";s:8:\"datatype\";s:18:\"Boolean / (config)\";s:11:\"description\";s:67:\"Enable/Configuration for menu items which are found in the rootLine\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:8:\"ACTIFSUB\";s:8:\"datatype\";s:18:\"Boolean / (config)\";s:11:\"description\";s:84:\"Enable/Configuration for menu items which are found in the rootLine and has subpages\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:3:\"CUR\";s:8:\"datatype\";s:18:\"Boolean / (config)\";s:11:\"description\";s:69:\"Enable/Configuration for a menu item if the item is the current page.\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:3:\"USR\";s:8:\"datatype\";s:18:\"Boolean / (config)\";s:11:\"description\";s:96:\"Enable/Configuration for menu items which are access restricted pages that a user has access to.\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:3:\"SPC\";s:8:\"datatype\";s:18:\"Boolean / (config)\";s:11:\"description\";s:265:\"Enable/Configuration for \'Spacer\' pages.\nSpacers are pages of the doktype &quot;Spacer&quot;. These are not viewable pages but &quot;placeholders&quot; which can be used to devide menuitems.\n&nbsp;\n<b>Note:</b> Rollovers doesn\'t work with spacers, if you use GMENU!\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:8:\"USERDEF1\";s:8:\"datatype\";s:18:\"Boolean / (config)\";s:11:\"description\";s:277:\"Userdefined, see .itemArrayProcFunc for details on how to use this.\nYou can set the ITEM_STATE values USERDEF1 and USERDEF2 (+...RO) from a script/userfunction processing the menu item array. See HMENU/special=userdefined or the property .itemArrayProcFunc of the menu objects.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:8:\"USERDEF2\";s:8:\"datatype\";s:18:\"Boolean / (config)\";s:11:\"description\";s:11:\"(See above)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (179,270,'2bcf41f3a27a1da90a09ebdf3a40f315','','tsref:(TLO)','a:1:{s:4:\"rows\";a:10:{i:0;a:6:{s:8:\"property\";s:5:\"types\";s:8:\"datatype\";s:8:\"readonly\";s:11:\"description\";s:55:\"Types (internal)\ntype=99 reserved for plaintext display\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:9:\"resources\";s:8:\"datatype\";s:8:\"readonly\";s:11:\"description\";s:28:\"Resources in list (internal)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:9:\"sitetitle\";s:8:\"datatype\";s:8:\"readonly\";s:11:\"description\";s:20:\"SiteTitle (internal)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:6:\"config\";s:8:\"datatype\";s:11:\"-&gt;CONFIG\";s:11:\"description\";s:131:\"Global configuration.\nThese values are stored with cached pages which means they are also accessible when retrieving a cached page.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:9:\"constants\";s:8:\"datatype\";s:14:\"-&gt;CONSTANTS\";s:11:\"description\";s:183:\"Site-specific constants, eg. a general email-adresse. These constants may be substituted in the text throughout the pages. The substitution is done by parseFunc. (Option: constants=1)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:6:\"FEData\";s:8:\"datatype\";s:19:\"<i>-&gt;FE_DATA</i>\";s:11:\"description\";s:105:\"Here you can configure how data submitted from the front-end should be processed, which script and so on.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:11:\"includeLibs\";s:8:\"datatype\";s:23:\"<i>array of strings</i>\";s:11:\"description\";s:156:\"With this you can include php-files with function libraries for use in your includescript in Typo3.\nPlease see the PAGE-object, which has the same property.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:56:\"Other reserved TLO\'s:\n&nbsp;\nplugin\ntt_*\ntemp\nstyles\nlib\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:828:\"These toplevel object names are reserved. That means you can risk static_templates to use them:\n&quot;plugin&quot; is used for rendering of special content like boards, ecommerce solutions, guestbooks and so on. Normally set from static_templates. <i>Please see separate description below!</i>\n&quot;tt_*&quot;, eg tt_content (from &quot;content (default)&quot;) is used to render content from tables.\n&quot;temp&quot; and &quot;styles&quot; are used for conde-libraries you can copy during parse-time, but they are not saved with the template in cache. <b>&quot;temp&quot; / &quot;styles&quot; are unset</b> before the template is cached! Therefore use these names to store temporary data.\n&quot;lib&quot; can be used for a &quot;library&quot; of code, you can reference in TypoScript (unlike &quot;styles&quot; which is unset)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:3:\"...\";s:8:\"datatype\";s:4:\"PAGE\";s:11:\"description\";s:379:\"Start a new page\n&nbsp;\n<b>Example:</b>\n&nbsp;\n<b>Guidelines:</b>\nGood, general PAGE object names to use are such as:\n<i>page </i>for the main page with content\n<i>frameset, frameset2 </i>for framesets.\n<i>top, left, menu, right, bottom, border </i>for top and menu frames etc.\nThis is just recommandations. Especially the name \'page\' for the content bearing page is very common.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:3:\"...\";s:8:\"datatype\";s:17:\"<i>(whatever)</i>\";s:11:\"description\";s:365:\"If a toplevel-object is not a PAGE-object it could be used as a temporary repository for setup. In this case you should use the &quot;temp&quot; or &quot;styles&quot; objects.\n&quot;tt_...&quot; is normally used to define the setup of content-records. Eg. &quot;tt_content&quot; would be used for the tt_content-table as default. See the &quot;CONTENT&quot;-cObject\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (180,270,'270df189982a4482d7b570baa95cba05','','tsref:plugin','a:1:{s:4:\"rows\";a:5:{i:0;a:6:{s:8:\"property\";s:8:\"userFunc\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:67:\"<i>Property setting up the USER / USER_INT object of the plugin</i>\";s:7:\"default\";s:13:\"<i>&nbsp;</i>\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:11:\"includeLibs\";s:8:\"datatype\";s:13:\"<i>&nbsp;</i>\";s:11:\"description\";s:67:\"<i>Property setting up the USER / USER_INT object of the plugin</i>\";s:7:\"default\";s:13:\"<i>&nbsp;</i>\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:18:\"_CSS_DEFAULT_STYLE\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:328:\"Use this to have some default CSS styles inserted in the header section of the document. Most likely this will provide a default acceptable display from the plugin, but should ideally be cleared and moved to an external stylesheet.\nThis value is for all plugins read by the pagegen script when making the header of the document.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:28:\"_DEFAULT_PI_VARS.[piVar-key]\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:202:\"Allows you to set default values of the piVars array which most plugins are using (and should use) for data exchange with themselves.\nThis works only if the plugin calls $this-&gt;pi_setPiVarDefaults().\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:34:\"_LOCAL_LANG.[lang-key].[label-key]\";s:8:\"datatype\";s:6:\"String\";s:11:\"description\";s:68:\"Can be used to override the default locallang labels for the plugin.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}}}','');
INSERT INTO `static_tsconfig_help` VALUES (181,270,'2a74eafe437239f6dfa39d7289a1e6d9','','tsref:config/-&gt;CONFIG','a:1:{s:4:\"rows\";a:72:{i:0;a:6:{s:8:\"property\";s:8:\"linkVars\";s:8:\"datatype\";s:4:\"list\";s:11:\"description\";s:312:\"HTTP_GET_VARS, which should be passed on with links in Typo. This is compiled into a string stored in $GLOBALS[&quot;TSFE&quot;]-&gt;linkVars\n&nbsp;\n<b>Example:</b>\n&nbsp;\nThis will add &quot;&amp;noframes=[noframes-value]&amp;print=[print-value]&quot; to all links in Typo3.\nThe values are rawurlencoded in PHP.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:1;a:6:{s:8:\"property\";s:11:\"MP_defaults\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:322:\"Allows you to set a list of page id numbers which will always have a certain &quot;&amp;MP=...&quot; parameter added.\n&nbsp;\n<b>Syntax:</b>\n[id],[id],... : [MP-var] | [id],[id],... : [MP-var] | ...\n&nbsp;\n<b>Example:</b>\n&nbsp;\nThis will by default add &quot;&amp;MP=2-207&quot; to all links pointing to pages 36,37 and 48\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:2;a:6:{s:8:\"property\";s:11:\"metaCharset\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:115:\"Charset used in the meta-tag:\n&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=...&gt;\";s:7:\"default\";s:10:\"iso-8859-1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:3;a:6:{s:8:\"property\";s:10:\"ATagParams\";s:8:\"datatype\";s:16:\"&lt;A&gt;-params\";s:11:\"description\";s:112:\"Additional parameters to all links in Typo3 (excluding menu-links)\n&nbsp;\n<b>Example:</b>\nTo blur links, insert:\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:4;a:6:{s:8:\"property\";s:13:\"setJS_openPic\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:64:\"If set, the openPic JavaScript function is forced to be included\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:5;a:6:{s:8:\"property\";s:15:\"setJS_mouseOver\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:75:\"If set, the over() and out() JavaScript functions are forced to be included\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:6;a:6:{s:8:\"property\";s:3:\"ftu\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:856:\"If set, the &quot;&amp;ftu=....&quot; GET-fallback identification is inserted.\n&quot;&amp;ftu=[hash]&quot; is always inserted in the links on the first page a user hits. If it turns out in the next hit that the user has cookies enabled, this variable is not set anymore as the cookies does the job. If no cookies is accepted the &quot;ftu&quot; remains set for all links on the site and thereby we can still track the user.\n&nbsp;\n<b>You should not set this feature if grabber-spiders like Teleport are going to grab your site!</b>\n<b>You should not set this feature if you want search-engines to index your site (in conjunction with the simulateStaticDocuments feature!)</b>\n<b>&nbsp;</b>\nYou can also ignore this feature if you\'re certain, website users will use cookies.\n&nbsp;&quot;ftu&quot; means fe_typo_user (&quot;fe&quot; is &quot;frontend&quot;).\";s:7:\"default\";s:5:\"false\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:7;a:6:{s:8:\"property\";s:10:\"mainScript\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:240:\"This lets you specify an alternative &quot;mainScript&quot; which is the document that Typo3 expects to be the default doc. This is used in form-tags and other places where Typo3 needs to refer directly to the main-script of the application\";s:7:\"default\";s:9:\"index.php\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:8;a:6:{s:8:\"property\";s:13:\"pageGenScript\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:569:\"Alternative page generation script for applications using index_ts.php for initialization, caching, stating and so on. This script is included in the global scope of index_ts.php-script and thus you may include libraries here. Always use include_once for libraries.\nRemember not to output anything from such an included script. <b>All content must be set into $TSFE-&gt;content. </b>Take a look at tslib/pagegen.php\n&nbsp;\n<b>NOTE:</b> This option is ignored if \n&nbsp;\n$TYPO3_CONF_VARS[&quot;FE&quot;][&quot;noPHPscriptInclude&quot;]=1;\n&nbsp;\nis set in localconf.php.\";s:7:\"default\";s:17:\"tslib/pagegen.php\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:9;a:6:{s:8:\"property\";s:5:\"debug\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:110:\"If set any debug-information in the TypoScript code is output. Currently this applies only to the menu-objects\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:10;a:6:{s:8:\"property\";s:31:\"message_page_is_being_generated\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:191:\"Alternative message in HTML that appears if a page is being generated.\nNormally when a page is being generated a temporary copy is stored in the cache-table with an expire-time of 30 seconds.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:11;a:6:{s:8:\"property\";s:15:\"message_preview\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:77:\"Alternative message in HTML that appears when the preview function is active!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:12;a:6:{s:8:\"property\";s:10:\"locale_all\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:312:\"PHP: setlocale(&quot;LC_ALL&quot;, [value]);\nvalue-examples: deutsch, de_DE, danish, portuguese, spanish, french, norwegian, italian. See www.php.net for other value. Also on linux, look at /usr/share/locale/\n&nbsp;\n<b>Example:</b>\nThis will render dates in danish made with stdWrap/strftime:\nlocale_all = danish\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:13;a:6:{s:8:\"property\";s:16:\"sword_standAlone\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:136:\"Used by the parseFunc-substitution of search Words (sword):\nIf set, the words MUST be surrounded by whitespace in order to be marked up.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:14;a:6:{s:8:\"property\";s:17:\"sword_noMixedCase\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:129:\"Used by the parseFunc-substitution of search Words (sword):\nIf set, the words MUST be the exact same case as the search word was.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:15;a:6:{s:8:\"property\";s:9:\"intTarget\";s:8:\"datatype\";s:6:\"target\";s:11:\"description\";s:61:\"default internal target. Used by typolink if no target is set\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:16;a:6:{s:8:\"property\";s:9:\"extTarget\";s:8:\"datatype\";s:6:\"target\";s:11:\"description\";s:64:\"default external target. Used by typolink if no extTarget is set\";s:7:\"default\";s:4:\"_top\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:17;a:6:{s:8:\"property\";s:25:\"spamProtectEmailAddresses\";s:8:\"datatype\";s:17:\"boolean / -5 to 5\";s:11:\"description\";s:388:\"If set, then all email addresses in typolinks will be encrypted so spam bots cannot detect them. Encryption is a simply offset of character values. If you set this value to &quot;3&quot; then all characters will have their ASCII value offset by &quot;3&quot;. The reason for supplying this is... well just a way you can choose another offset than everyone else... Hmm. Does it make sense?\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:18;a:6:{s:8:\"property\";s:33:\"spamProtectEmailAddresses_atSubst\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:37:\"Substitute label for the at-sign (@).\";s:7:\"default\";s:4:\"(at)\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:19;a:6:{s:8:\"property\";s:14:\"forceTypeValue\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:326:\"Force the &amp;type value of all Typo3 generated links to a specific value (except if overruled by local forceTypeValue values).\nUseful if you run a template with special content at - say &amp;type=95 - but still wants to keep your targets neutral. Then you set your targets to blank and this value to the type value you wish.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:20;a:6:{s:8:\"property\";s:26:\"frameReloadIfNotInFrameset\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:372:\"If set, then the current page will check if the page object name (eg. &quot;page&quot; or &quot;frameset&quot;) exists as &quot;parent.[name]&quot; (eg. &quot;parent.page&quot;) and if not the page will be reloaded in top frame. This secures that links from search engines to pages inside a frameset will load the frameset.\nWorks only with type-values different from zero.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:21;a:6:{s:8:\"property\";s:14:\"jumpurl_enable\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:217:\"Jumpurl is a concept where external links are redirected from the index_ts.php script, which first logs which url it was. This logging of external links is only interesting if you use the internal stat-table in Typo3.\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:22;a:6:{s:8:\"property\";s:22:\"jumpurl_mailto_disable\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:59:\"Disables the use of jumpUrl when linking to email-adresses.\";s:7:\"default\";s:1:\"0\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:23;a:6:{s:8:\"property\";s:20:\"compensateFieldWidth\";s:8:\"datatype\";s:6:\"double\";s:11:\"description\";s:544:\"this floating point value will be used by the FORMS cObject to compensate the length of the formfields text and input.\nThis feature is useful, if the page-option &quot;smallFormFields&quot; is set. In that case Netscape renders formfields much longer than IE. If you want the two browsers to display the same size formfields, use a value of approx &quot;0.6&quot; for netscape-browsers.\n&nbsp;\n<b>Example:</b>\n[browser = netscape]\n&nbsp;&nbsp;config.compensateFieldWidth = 0.6\n[global]\n&nbsp;\nThis option may be overridden in the FORMS-cObject.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:24;a:6:{s:8:\"property\";s:14:\"includeLibrary\";s:8:\"datatype\";s:8:\"resource\";s:11:\"description\";s:24:\"This includes a phpfile.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:25;a:6:{s:8:\"property\";s:17:\"incT3Lib_htmlmail\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:38:\"Include t3lib/class.t3lib_htmlmail.php\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:26;a:6:{s:8:\"property\";s:12:\"lockFilePath\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:102:\"This is used to lock paths to be &quot;inside&quot; this path.\nUsed by &quot;filelist&quot; in stdWrap\";s:7:\"default\";s:10:\"fileadmin/\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:27;a:6:{s:8:\"property\";s:9:\"noScaleUp\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:352:\"Normally images are scaled to the size specified via TypoScript. This also forces small images to be scaled to a larger size. This is not always a good thing.\nIf this property is set, images are <b>not</b> allowed to be scaled up in size. This parameter clears the $this-&gt;mayScaleUp var of the class t3lib_stdgraphics (often &quot;gifbuilder&quot;).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:28;a:6:{s:8:\"property\";s:19:\"USERNAME_substToken\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:169:\"The is the token used on the page, which should be substituted with the current username IF a front-end user is logged in! If no login, the substitution will not happen.\";s:7:\"default\";s:27:\"&lt;!--###USERNAME###--&gt;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:29;a:6:{s:8:\"property\";s:12:\"cache_period\";s:8:\"datatype\";s:12:\"int, seconds\";s:11:\"description\";s:179:\"The number of second a page may remain in cache.\nThis value is overridden by the value set in the page-record (field=&quot;cache_timeout&quot;) if this value is greater than zero.\";s:7:\"default\";s:12:\"86400 (=24H)\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:30;a:6:{s:8:\"property\";s:21:\"cache_clearAtMidnight\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:99:\"With this setting the cache always expires at midnight of the day, the page is scheduled to expire.\";s:7:\"default\";s:5:\"false\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:31;a:6:{s:8:\"property\";s:8:\"no_cache\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:142:\"If this is set to true, the page will not be cached. If set to false, it\'s ignored. Other parameters may have set it to true of other reasons.\";s:7:\"default\";s:1:\"-\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:32;a:6:{s:8:\"property\";s:20:\"disableAllHeaderCode\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:407:\"If this is set, none of the features of the PAGE-object is processed and the content of the page will be the result of the cObject array (1,2,3,4...) of the PAGE-object. &nbsp;This means that the result of the cObject should include everything from the &lt;HTML&gt; .... to the &lt;/HTML&gt; tag !!\nUse this feature in templates supplying other content-types than HTML. That could be an image or a WAP-page!\";s:7:\"default\";s:5:\"false\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:33;a:6:{s:8:\"property\";s:17:\"additionalHeaders\";s:8:\"datatype\";s:32:\"strings divided by &quot;|&quot;\";s:11:\"description\";s:495:\"This is additional headers. You separate each header by a vertical line &quot;|&quot;. &nbsp;Normally Typo3 does <i>not</i> send any headers with the Header()-function in PHP.\n&nbsp;\n<b>Examples:</b>\nContent-type: text/vnd.wap.wml\n(this will sent a content-header for a WAP-site)\n&nbsp;\nContent-type: image/gif | Expires: Mon, 26 Jul 1997 05:00:00 GMT\n(this will sent a content-header for a GIF-file and a Expires header)\n&nbsp;\nLocation: www.typo3.com\n(This redirects the page to www.typo3.com)\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:34;a:6:{s:8:\"property\";s:22:\"disablePageExternalUrl\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:152:\"If set, pages with doktype &quot;External Url&quot; will not trigger jumpUrl in TSFE. This may help you to have external urls open inside you framesets.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:35;a:6:{s:8:\"property\";s:4:\"stat\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:27:\"Enable stat logging at all.\";s:7:\"default\";s:4:\"true\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:36;a:6:{s:8:\"property\";s:16:\"stat_typeNumList\";s:8:\"datatype\";s:8:\"int/list\";s:11:\"description\";s:275:\"List of pagetypes that should be registered in the statistics table, sys_stat.\nIf no types are listed, all types are logged.\nDefault is &quot;0,1&quot; which normally logs all hits on framesets and hits on content keeping pages. Of course this depends on the template design.\";s:7:\"default\";s:3:\"0,1\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:37;a:6:{s:8:\"property\";s:22:\"stat_excludeBEuserHits\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:65:\"If set a pagehit is not logged if a user is logged in into Typo3.\";s:7:\"default\";s:5:\"false\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:38;a:6:{s:8:\"property\";s:18:\"stat_excludeIPList\";s:8:\"datatype\";s:15:\"list of strings\";s:11:\"description\";s:72:\"If the REMOTE_ADDR is in the list of IP-addresses, it\'s also not logget.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:39;a:6:{s:8:\"property\";s:10:\"stat_mysql\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:43:\"Enable logging to the MySQL table sys_stat.\";s:7:\"default\";s:5:\"false\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:40;a:6:{s:8:\"property\";s:11:\"stat_apache\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:61:\"Enable logging to the logfile &quot;stat_apache_logfile&quot;\";s:7:\"default\";s:5:\"false\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:41;a:6:{s:8:\"property\";s:19:\"stat_apache_logfile\";s:8:\"datatype\";s:8:\"filename\";s:11:\"description\";s:326:\"This the filename of the logfile in the directory $TYPO3_CONF_VARS[&quot;FE&quot;][&quot;logfile_dir&quot;] (localconf) on the server where Typo3 writes to the apachelogfile. The directory defined by &nbsp;$TYPO3_CONF_VARS[&quot;FE&quot;][&quot;logfile_dir&quot;] &nbsp;must exist and be writable. The logfile also must exist.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:42;a:6:{s:8:\"property\";s:21:\"stat_apache_pagenames\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:285:\"The &quot;pagename&quot; simulated for apache.\nDefault: &nbsp;&nbsp;&nbsp;&quot;[path][title]--[uid].html&quot;\nCodes:\n[title] = inserts title, no special characters and shortend to 30 chars.\n[uid] = the id\n[alias] = any alias\n[type] = the type (typeNum)\n[path] = the path of the page.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:43;a:6:{s:8:\"property\";s:23:\"stat_apache_notExtended\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:60:\"If true the logfile is NOT written in Apache extended format\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:44;a:6:{s:8:\"property\";s:18:\"stat_apache_noHost\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:80:\"If true the HTTP_HOST is - if available - NOT inserted instead of the IP-address\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:45;a:6:{s:8:\"property\";s:13:\"stat_titleLen\";s:8:\"datatype\";s:9:\"int 1-100\";s:11:\"description\";s:68:\"The lenght of the page names in the path written to logfile/database\";s:7:\"default\";s:2:\"20\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:46;a:6:{s:8:\"property\";s:23:\"simulateStaticDocuments\";s:8:\"datatype\";s:39:\"boolean /\nstring: &quot;PATH_INFO&quot;\";s:11:\"description\";s:1470:\"If set Typo3 makes all links in another way than usual. This can be used with <b>Apache compiled with mod_rewrite and configured in httpd.conf for use of this in the &quot;.htaccess&quot;-files.</b>\nInclude this in the .htaccess file\n&nbsp;&nbsp;&nbsp;&nbsp;RewriteEngine On\n&nbsp;&nbsp;&nbsp;&nbsp;RewriteRule &nbsp;&nbsp;^[^/]*\\.html$ &nbsp;index.php\n&nbsp;\nThis means that any &quot;*.html&quot;-documents should be handled by index.php.\nNow if is done, Typo3 will interprete the url of the html-document like this:\n&nbsp;&nbsp;&nbsp;&nbsp;[title].[id].[type].html\nTitle is optional and only usefull for the entries in the apache log-files. You may omit both [title] and [type] but if title is present, type must also be there!.\n&nbsp;\n<b>Example:</b>\nTypo3 will interprete this as page with uid=23 and type=1 :\n&nbsp;&nbsp;&nbsp;&nbsp;Startpage.23.1.html\n&nbsp;\nTypo3 will interprete this as the page with alias = &quot;start&quot; and the type is zero (default):\n&nbsp;&nbsp;&nbsp;&nbsp;start.html\n<b>_____________________________________________</b>\n<b>Alternative option (PATH_INFO):</b>\nInstead of using the rewrite-module in apache (eg. if you\'re running Windows!) you can use the PATH_INFO variable from PHP.\nIt\'s very simple. Just set simulateStaticDocuments to &quot;PATH_INFO&quot; and you\'re up and running!\n&nbsp;\n<b>Also:</b> See below, .absRefPrefix\n&nbsp;\n<b>Example (put in Setup-field of your template):</b>\nconfig.simulateStaticDocuments = PATH_INFO\";s:7:\"default\";s:252:\"default is defined by a configuration option in localconf.php. It\'s\n$TYPO3_CONF_VARS[&quot;FE&quot;][&quot;simulateStaticDocuments&quot;] = 1;\nThis affects all sites in the database.\nYou can also set this value to the string &nbsp;&quot;PATH_INFO&quot;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:47;a:6:{s:8:\"property\";s:32:\"simulateStaticDocuments_addTitle\";s:8:\"datatype\";s:3:\"int\";s:11:\"description\";s:258:\"If not zero, Typo3 generates urls with the title in, limited to the first [simulateStaticDocuments_addTitle] number of chars.\n&nbsp;\n<b>Example:</b>\n&nbsp;&nbsp;&nbsp;&nbsp;Startpage.23.1.html\ninstead of the default, &quot;23.1.html&quot;, without the title.\";s:7:\"default\";s:13:\"&nbsp;\n&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:48;a:6:{s:8:\"property\";s:39:\"simulateStaticDocuments_noTypeIfNoTitle\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:403:\"If set, then the type-value will not be set in the simulated filename if the type value is zero anyways. However the filename must be without a title.\n&nbsp;\n<b>Example:</b>\n&quot;Startpage.23.0.html&quot; would <i>still </i>be &quot;Startpage.23.0.html&quot;\n&quot;23.0.html&quot; would be &quot;23.html&quot; (that is without the zero)\n&quot;23.1.html&quot; would <i>still</i> be &quot;23.1.html&quot;\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:49;a:6:{s:8:\"property\";s:49:\"simulateStaticDocuments_dontRedirectPathInfoError\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:309:\"Regarding PATH_INFO mode:\nWhen a page is requested by &quot;PATH_INFO&quot; method it must be configured in order to work properly. If PATH_INFO is not configured, the index_ts.php script sends a location header to the correct page. However if you better like an error message outputted, just set this option.\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:50;a:6:{s:8:\"property\";s:28:\"simulateStaticDocuments_pEnc\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:1815:\"Allows you to also encode additional parameters into the simulated filename.\n&nbsp;\n<b>Example: </b>\nYou have a news-plugin. The main page has the url &quot;Page_1.228.0.html&quot; but when one clicks on a news item the url will be &quot;Page_1.228.0.html?&amp;tx_mininews_pi1[showUid]=2&amp;cHash=b8d239c224&quot; instead.\nNow, this URL will not be indexed by external search-engines because of the query-string (everything after the &quot;?&quot; mark). This property avoids this problem by encoding the parameters. These are the options:\n&nbsp;\n<b>Value set to &quot;base64&quot;:</b>\nThis will transform the filename used to this value: &quot;Page_1.228+B6JnR4X21pbmluZXdzX3BpMVtzaG93VWlkXT0yJmNIYXNoPWI4ZDIzOWMyMjQ_.0.html&quot;. The querystring has simply been base64-encoded (and some more...) and added to the HTML-filename (so now external search-engines will find this!). The really great thing about this that the filename is self-reliant because the filename contains the parameters. The downside to it is the very very long filename.\n&nbsp;\n<b>Value set to &quot;md5&quot;:</b>\nThis will transform the filename used to this value:\n&quot;Page_1.228+M57867201f4a.0.html&quot;. Now, what a lovely, short filename! Now all the parameters has been hashed into a 10-char string inserted into the filename. At the same time an entry has been added to a cache table in the database so when a request for this filename reaches the frontend, then the REAL parameter string is found in the database! The really great thing about this is that the filename is very short (opposite to the base64-method). The downside to this is that IF you clear the database cache table at any time, the URL here does NOT work until a page with the link has been generated again (re-inserting the parameter list into the database).\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:51;a:6:{s:8:\"property\";s:35:\"content_from_pid_allowOutsideDomain\";s:8:\"datatype\";s:7:\"boolean\";s:11:\"description\";s:204:\"Using the &quot;Show content from this page instead&quot; feature allows you to insert content from the current domain only. Setting this option will allow content included from anywhere in the page tree!\";s:7:\"default\";s:6:\"&nbsp;\";s:12:\"column_count\";i:4;s:16:\"is_propertyTable\";i:1;}i:52;a:6:{s:8:\"property\";s:12:\"absRefPrefix\";s:8:\"datatype\";s:6:\"string\";s:11:\"description\";s:662:\"If this value is set, then all relative links in 