<?php
/***************************************************************
*  Copyright notice
*  
*  (c) 1999-2001 Kasper Skaarhoj (kasper@curbysoft.dk)
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is 
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
* 
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*  A copy is found in the textfile GPL.txt and important notices to the license 
*  from the author is found in LICENSE.txt distributed with these scripts.
*
* 
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/** 
 * Module: EXAMPLE Photo Marathon
 *
 * This is an example of how to write Typo3 Backend modules. 
 * Use this module as a dummy for creating your own!
 *
 * @author	Kasper Skaarhoj <kasper@typo3.com>
 */
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 *
 *
 *  122: class user_photomarathon_index 
 *  143:     function init()	
 *  159:     function menuConfig()	
 *  188:     function main()	
 *  275:     function printContent()	
 *  288:     function printOverview()	
 *  328:     function printList()	
 *
 * TOTAL FUNCTIONS: 6
 * (This index is automatically created/updated by the extension "extdeveval")
 *
 */
 
 
 
 
 
 
 
 
 
 
 

 
// ***************************************
// ***         W A R N I N G           ***
// ***************************************
//  This script includes Typo3 libraries and 
//  functions and is therefore covered by GPL
//  because only GPL licensed code
//  may depend on other GPL code.
//    This is a warning, because 
//  anything you may code that does the 
//  same (eg. makes calls to Typo3
//  functions) will also be legal only
//  under GPL! Just keep that in mind!
//  ... but please go ahead then and
//  share your work with us!
// ***************************************
 
 
 
 


 
 
 
 
 
 
 
 
 
 
 

// **********************************************
// Basic initialization, don't tamper with this!
// **********************************************
unset($MCONF);
include ('conf.php');
include ($BACK_PATH.'init.php');
include ($BACK_PATH.'template.php');
include ('locallang.php');
include_once(PATH_t3lib.'class.t3lib_page.php');

$BE_USER->modAccess($MCONF,1);




 
/**
 * Script class: Photomarathon backend module
 * 
 * @author	Kasper Skaarhoj <kasper@typo3.com>
 * @package TYPO3
 * @subpackage user_photomarathon
 * @internal
 */
class user_photomarathon_index {
	var $MCONF=array();
	var $MOD_MENU=array();
	var $MOD_SETTINGS=array();
	var $doc;

	var $content;
	var $modTSconfig;
	var $perms_clause;
	var $pageinfo;
	var $access;
	var $id;
	





	/**
	 * @return	[type]		...
	 */
	function init()	{
		global $AB,$BE_USER,$LANG,$BACK_PATH,$TCA_DESCR,$TCA,$HTTP_GET_VARS,$HTTP_POST_VARS,$CLIENT,$TYPO3_CONF_VARS;
		$this->MCONF = $GLOBALS['MCONF'];
		$this->id = intval(t3lib_div::GPvar('id'));
		
			// If there is no id sent, show the overview
		if (!$this->id)	$SET['mode']='overview';
		$this->perms_clause = $BE_USER->getPagePermsClause(1);	// where-clause part which you should use for selecting records so you can be sure, the BE-user (backend user) has read access.
		$this->menuConfig();
	}

	/**
	 * Menu initializing
	 * 
	 * @return	[type]		...
	 */
	function menuConfig()	{
		global $AB,$BE_USER,$LANG,$BACK_PATH,$TCA_DESCR,$TCA,$HTTP_GET_VARS,$HTTP_POST_VARS,$CLIENT,$TYPO3_CONF_VARS;

			// MENU-ITEMS:
			// If array, then it's a selector box menu
			// If empty string it's just a variable, that'll be saved. 
		$this->MOD_MENU = array(
			'mode' => array(	// variable
				'overview' => $LANG->getLL('menu_overview'),		// Menu value/item
				'list' => $LANG->getLL('menu_list')					// Menu value/item
			)
		);
		
			// page/be_user TSconfig settings:
		$this->modTSconfig = t3lib_BEfunc::getModTSconfig($this->id,"mod.".$this->MCONF['name']);
		
			// ... and blinding of menu-items:
		$this->MOD_MENU['mode'] = 
			t3lib_BEfunc::unsetMenuItems($this->modTSconfig['properties'],$this->MOD_MENU['mode'],'menu.mode');
			
			// Settings cleansed:
		$this->MOD_SETTINGS = t3lib_BEfunc::getModuleData($this->MOD_MENU, t3lib_div::GPvar('SET'), $this->MCONF['name']);
	}

	/**
	 * Main code, making the content of the module:
	 * 
	 * @return	[type]		...
	 */
	function main()	{
		global $AB,$BE_USER,$LANG,$BACK_PATH,$TCA_DESCR,$TCA,$HTTP_GET_VARS,$HTTP_POST_VARS,$CLIENT,$TYPO3_CONF_VARS;

		$this->id = intval($this->id);	// integer id value
		$this->pageinfo = t3lib_BEfunc::readPageAccess($this->id,$this->perms_clause);	// the page record of the current page (set by $this->id). $this->perms_clause ensures that the BE user has read access to this module.
		$this->access = is_array($this->pageinfo) ? 1 : 0;
		
		if (($this->id && $this->access) || $this->MOD_SETTINGS['mode']=='overview')	{
				// Getting rootline array (not used in this module, only example...)
			$rootLine = t3lib_BEfunc::BEgetRootLine($this->id,"AND ".$this->perms_clause);	
		
				// Initializing the layout object.
			$this->doc = new mediumDoc;
			$this->doc->backPath = $BACK_PATH;
			$this->doc->JScode = $this->doc->wrapScriptTags('
				script_ended = 0;
				function jumpToUrl(URL)	{	//
					document.location = URL;
				}
			');
			$this->doc->postCode=$this->doc->wrapScriptTags('
				script_ended = 1;
				top.theMenu.recentuid = '.intval($this->id).';
			');
			$this->doc->form='<form action="index.php" method="post">';
		
				// Setting the header of the module
			$headerSection = $this->doc->getHeader('pages',$this->pageinfo,$this->pageinfo['_thePath']).'<br />'.$LANG->php3Lang['labels']['path'].': '.t3lib_div::fixed_lgd_pre($this->pageinfo['_thePath'],50);
		
				// Render the main menu (&mode)
				// Good thing about this menu is that it saves the state automatically for the backend user.
			$menuHTML = t3lib_BEfunc::getFuncMenu($this->id,'SET[mode]',$this->MOD_SETTINGS['mode'],$this->MOD_MENU['mode']);
		
				// Draw the header.
			$this->content.=$this->doc->startPage($LANG->getLL('title'));
			$this->content.=$this->doc->header($LANG->getLL('title'));
			$this->content.=$this->doc->spacer(5);
			$this->content.='<input type="hidden" name="id" value="'.$this->id.'">';
			$this->content.=$this->doc->section('',$this->doc->funcMenu($headerSection,$menuHTML));
		//	$this->content.=$this->doc->divider(5);
		//	$this->content.=$this->doc->section($LANG->getLL('menu'),$menuHTML);
		
		
				// *********************************
				// MAIN functions in module
				// *********************************
		
			switch((string)$this->MOD_SETTINGS['mode'])	{
				case 'overview':
					$this->printOverview();
				break;
				case 'list':
					$this->printList();
				break;
			}
		
			
		
				// Finish of module layout.
			$this->content.=$this->doc->spacer(10);
			$this->content.=$this->doc->middle();
		
			$this->content.=$this->doc->section('NOTICE!','<font color="#660000"><strong>This is just an example submodule working ONLY in conjunction with the Typo3 testsite! This serves you as a dummy for creating your own modules! If you want to investigate how it works, the module is found in typo3conf/web/uphotomarathon.</strong></font>');
		
			// ****************
			// END of module
			// ****************
		} else {	// If no access or if ID == zero
			$this->doc = new smallDoc;
			$this->doc->backPath = $BACK_PATH;
		
			$this->content.=$this->doc->startPage($LANG->getLL('title'));
			$this->content.=$this->doc->header($LANG->getLL('title'));
			$this->content.=$this->doc->spacer(5);
			$this->content.=$this->doc->spacer(10);
		}
	}

	/**
	 * Menu initializing
	 * 
	 * @return	[type]		...
	 */
	function printContent()	{
		global $AB,$BE_USER,$LANG,$BACK_PATH,$TCA_DESCR,$TCA,$HTTP_GET_VARS,$HTTP_POST_VARS,$CLIENT,$TYPO3_CONF_VARS;

		$this->content.=$this->doc->middle();
		$this->content.=$this->doc->endPage();
		echo $this->content;
	}
	
	/**
	 * OVERVIEW: This lists the pages which contains user_photomarathon records
	 * 
	 * @return	[type]		...
	 */
	function printOverview()	{
		global $BACK_PATH,$LANG;
			// Select all pages with user_photomarathon records on
		$theCode='';
			// Make query
		$query = 'SELECT count(*) as PMcount,pages.uid,pages.title from pages,user_photomarathon 
			WHERE pages.uid=user_photomarathon.pid 
			AND '.$this->perms_clause
			.t3lib_BEfunc::deleteClause('pages')
			.t3lib_BEfunc::deleteClause('user_photomarathon')
			.' GROUP BY pages.uid';
		//debug($query);
			// Select records
		$res = mysql(TYPO3_db,$query);
		echo mysql_error();
			// Initialize the array used to accumulate the output
		$lines=array();
			// Traverse the result
		while($row=mysql_fetch_assoc($res))	{
			//debug($row);
				// Make links to the pages with user_photomarathon records on
			$lines[] = t3lib_iconworks::getIconImage('pages',array(),$BACK_PATH,' class="absmiddle"')
				.'<a href="'.htmlspecialchars('index.php?id='.$row['uid'].'&SET[mode]=list').'">'.htmlspecialchars($row['title']).' ('.$row['PMcount'].' marathon records)</a>';
		}
			// Compile the lines array...
		if (count($lines))	{
			$theCode = '<br /><strong>Select a page to go to:</strong><br /><br />'.implode('<br />',$lines);
		} else {	// ... but if it's empty, display a message
			$theCode = 'There were no pages with Photo Marathon records on yet!';
		}
			// Insert the content of the module
		$this->content.=$this->doc->spacer(10);
		$this->content.=$this->doc->section($LANG->getLL('menu_overview'),$theCode,0,1);
	}

	/**
	 * OVERVIEW: This lists all user_photomarathon records on the current page
	 * 
	 * @return	[type]		...
	 */
	function printList()	{
		global $BACK_PATH,$LANG;
			// Select all pages with user_photomarathon records on
		$theCode='';
			// Make query
		$query = 'SELECT * FROM user_photomarathon WHERE pid='.$this->id.t3lib_BEfunc::deleteClause('user_photomarathon');
			// Select records
		$res = mysql(TYPO3_db,$query);
		echo mysql_error();
			// Initialize the array used to accumulate the output
		$lines=array();
			// Traverse the result
		while($row=mysql_fetch_assoc($res))	{
				// Make links to the pages with user_photomarathon records on
			$TDparams = 'valign="top" bgcolor="'.$this->doc->bgColor4.'"';
			$rTitle = '<b>'.htmlspecialchars($row['title']).'</b>';
			$rDescr = htmlspecialchars(t3lib_div::fixed_lgd($row['description'],250));
			$rEdit = '<a href="#" onclick="'.htmlspecialchars(t3lib_BEfunc::editOnClick('&edit[user_photomarathon]['.$row['uid'].']=edit',$BACK_PATH,'',1)).'">'.
						'<img src="'.$BACK_PATH.'gfx/edit2.gif" width=11 height=12 hspace=2 border=0 title="Edit" align="top">'.
						'</a>';
			$rUnhide = $row['hidden'] ? '<a href="'.htmlspecialchars($this->doc->issueCommand('&data[user_photomarathon]['.$row['uid'].'][hidden]=0',getenv('REQUEST_URI'))).');">'.
										'<img src="'.$BACK_PATH.'gfx/button_unhide.gif" width=11 height=10 hspace=2 border=0 title="Un-hide" align="top">'.
										'</a>' : '';
			$rDelete = '<a href="'.htmlspecialchars($this->doc->issueCommand('&cmd[user_photomarathon]['.$row['uid'].'][delete]=1',getenv('REQUEST_URI'))).');">'.
						'<img src="'.$BACK_PATH.'gfx/delete_record.gif" width=12 height=12 hspace=2 border=0 title="Delete" align="top">'.
						'</a>';
			$lines[] = '
				<tr>
					<td '.$TDparams.'>'.t3lib_iconworks::getIconImage('user_photomarathon',$row,$BACK_PATH,' class="absmiddle"').'</td>
					<td '.$TDparams.'>'.$rTitle.'<br />'.$rDescr.'<br />'.$rEdit.$rUnhide.$rDelete.'</td>
					<td '.$TDparams.'>'.t3lib_BEfunc::thumbCode($row,'user_photomarathon',"images",$BACK_PATH).'</td>
				</tr>';
		}
			// Compile the lines array...
		if (count($lines))	{
			$theCode = '
			<table border="0" cellpadding="1" cellspacing="1">'.
				implode('',$lines).'
			</table>';
		} else {	// ... but if it's empty, display a message
			$theCode = 'There were no Photo Marathon records on this page!';
		}
		$this->content.=$this->doc->spacer(10);
		$this->content.=$this->doc->section($LANG->getLL('menu_list'),$theCode,0,1);
	}
}

// Include extension?
if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/user_photomarathon/modsub/index.php'])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/user_photomarathon/modsub/index.php']);
}












// Make instance:
$SOBE = t3lib_div::makeInstance('user_photomarathon_index');
$SOBE->init();
$SOBE->main();
$SOBE->printContent();
?>