/** Copyright (c) 1995-1999 Ohio Board of Regents and the University of
    Cincinnati.  All Rights Reserved.

    You may modify, distribute, and use the software contained in this
    package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
    version 2, June 1991. A copy of this license agreement can be found
    in the file "LGPL", distributed with this archive. */

#ifndef SOURCEDATA_HH
#define SOURCEDATA_HH

#include "tyvis/SourceBase.hh"
#include "tyvis/VHDLType.hh"
#include "tyvis/VHDLData.hh"

class VHDLKernel;

class SourceData : public SourceBase {
public:
  SourceData();

  SourceData(VHDLKernel *sourceProcessPtr);
  
  virtual ~SourceData() {}

  SourceKind get_kind(void) const { return SOURCE_DATA; }

  void disConnect() { connected = false; }

  VHDLKernel* getSourceId() const;
  void setSourceId(VHDLKernel *);

  VHDLType* getData() const;
  void setData(VHDLType *);
  void setData(VHDLData *);
  int addChild(VHDLType*, VHDLKernel *);
  int addChild(SourceBase *);

  void updateData(const VHDLType&);
  void updateData(const VHDLData&);

  bool _is_child_present(VHDLKernel *);
  bool _is_driver_connected() { return connected; }
  bool _is_anonymous_driver();
  
  SourceData *getDriver( VHDLKernel * );
  SourceData *getDriver( int processId );


  SourceData* getDriveratIndex(int);

  VHDLType *resolve( VHDLKernel *, SigType type = EXPLICIT );

  void print(ostream&) const;
  
private:
  VHDLKernel *sourceProcess;
  VHDLType   *sourceObject;
  bool       connected;  
};
  
#endif
