#include "Transaction.hh"
#include <clutils/AllocatorStack.h>

Transaction::Transaction(const Transaction &src) :
  sourceProcess( src.getSourceProcess() ),
  value(src.getValue()),  
  transactionTime(src.getTime()),
  sequenceNumber(src.getSequenceNumber()){}


Transaction::Transaction( VHDLKernel *initSourceProcess,
			  const VHDLVTime &time, 
			  const unsigned int sNo,
			  const VHDLData *val) :
  sourceProcess( initSourceProcess ),
  value(val),  
  transactionTime(time),
  sequenceNumber(sNo){}

void *
Transaction::operator new( size_t ){
  return AllocatorStack<sizeof(Transaction)>::pop(); 
}
void 
Transaction::operator delete( void *toDelete ){
  AllocatorStack<sizeof(Transaction)>::push(toDelete); 
}

