//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef TYPEINFO_HH
#define TYPEINFO_HH

#include "tyvis/ArrayInfo.hh"
#include "tyvis/Types.hh"
#include "tyvis/ObjectBase.hh"

class IntegerType;
class RealType;

enum TypeInfoKind {RANGE_INFO, ENUM_INFO, REAL_INFO, PHY_INFO,
		   ARRAY_TYPE_INFO, RECORD_TYPE_INFO, ACCESS_TYPE_INFO, UNKNOWN};

// The mother of all type info's

class TypeInfo {
public:
  TypeInfo() {}
  virtual ~TypeInfo() {}
  
  virtual TypeInfoKind getKind() const {
    // cerr << "Warning: TypeInfo::getKind() called.\n";
    return UNKNOWN;
  }

  virtual TypeInfo& operator=(const TypeInfo &) {
    cerr << "Error - TypeInfo::operator=() called.\n";
    return *this;
  }

  virtual int get_range() const {
    cerr << "Error - TypeInfo::get_range() const called.\n";
    return -1;
  }

  virtual ArrayInfo::ArrayDirn_t get_direction() const {
    cerr << "Error - TypeInfo::get_direction() const called.\n";
    return ArrayInfo::to;
  }
  
  virtual VHDLType* createObject(ObjectBase::ObjectType) const;
  virtual int getCharacterOffset() const;

  /**
     Returns true if this is an enumeration type whose elements all belong
     to the character enumeration.
  */
  virtual bool is_character_type() const;
  
  /**
     If this is an EnumerationTypeInfo, this will return the image map.
     Else it returns 0.
  */
  virtual char **get_imageMap() const { return 0; }

  static char** createImageMap(int, ...);
  
  static TypeInfo &getNullTypeInfo();
  
protected:
  
private:
};

class IntegerTypeInfo : public TypeInfo {
public:
  IntegerTypeInfo();
  IntegerTypeInfo(int, ArrayInfo::ArrayDirn_t, int);
  IntegerTypeInfo(const IntegerTypeInfo &ri);
  IntegerTypeInfo(IntegerType&, ArrayInfo::ArrayDirn_t, IntegerType&);
  ~IntegerTypeInfo() {}
  int get_left() const;
  ArrayInfo::ArrayDirn_t get_direction() const;
  int get_right() const;
  IntegerTypeInfo& operator=(const IntegerTypeInfo& ri);
  TypeInfo& operator=(const TypeInfo& ti) {
    return operator=((const IntegerTypeInfo &) ti);
  }

  TypeInfoKind getKind() const {
    return RANGE_INFO;
  }

  int get_range() const;
  VHDLType* createObject(ObjectBase::ObjectType) const;
  
protected:
  int left;
  ArrayInfo::ArrayDirn_t dirn;
  int right;
  
private:
};

#include "tyvis/EnumerationTypeInfo.hh"

class RealTypeInfo : public TypeInfo {
public:
  RealTypeInfo();
  RealTypeInfo(const RealTypeInfo &ri);
  RealTypeInfo(double, ArrayInfo::ArrayDirn_t, double);
  RealTypeInfo(RealType&, ArrayInfo::ArrayDirn_t, RealType&);
  ~RealTypeInfo() {}
  
  double get_left() const;
  ArrayInfo::ArrayDirn_t get_direction() const;
  double get_right() const;
  
  RealTypeInfo& operator=(const RealTypeInfo &ri);
  TypeInfo& operator=(const TypeInfo& ti) {
    return operator=((const RealTypeInfo &) ti);
  }

  TypeInfoKind getKind() const {
    return REAL_INFO;
  }

  VHDLType* createObject(ObjectBase::ObjectType) const;

protected:
  double left;
  ArrayInfo::ArrayDirn_t dirn;
  double right;

private:
};

class PhysicalTypeInfo : public TypeInfo {
public:
  PhysicalTypeInfo();
  PhysicalTypeInfo(const PhysicalTypeInfo &pi);
  PhysicalTypeInfo(int , LONG, ArrayInfo::ArrayDirn_t, LONG, LONG *, char**);
  ~PhysicalTypeInfo(){}
  
  PhysicalTypeInfo& operator=(const PhysicalTypeInfo &);
  TypeInfo& operator=(const TypeInfo &ti) {
    return operator=((const PhysicalTypeInfo &) ti);
  }
  int get_no_of_elements() const;
  LONG get_left() const;
  LONG get_right() const;
  ArrayInfo::ArrayDirn_t get_direction() const;
  LONG* get_scale_info() const;
  char ** get_unit_info() const;
  char* get_unit(int) const;
  LONG get_scale(int) const;

  TypeInfoKind getKind() const {
    return PHY_INFO;
  }

  VHDLType* createObject(ObjectBase::ObjectType) const;
  
  static LONG* createScaleMap(int, ...);
  
protected:
  char **unitInfo;
  LONG* scaleInfo;
  int no_of_elements;
  LONG left;
  ArrayInfo::ArrayDirn_t dirn;
  LONG right;

private:
};

#include "tyvis/ArrayTypeInfo.hh"

//This holds info about record type
class RecordTypeInfo : public TypeInfo {
public:
  RecordTypeInfo();
  RecordTypeInfo(int, bool, ResolutionFnId_t, ...);
  RecordTypeInfo(const RecordTypeInfo&);
  ~RecordTypeInfo()  {}
  
  TypeInfo* get_field_info(const int) const;
  int get_number_of_fields() const;
  
  RecordTypeInfo& operator=(const RecordTypeInfo&);

  TypeInfoKind getKind() const {
    return RECORD_TYPE_INFO;
  }

  bool isCompositeResolvedType() const {
    return compositeResolvedType;
  }

  ResolutionFnId_t getResolutionFunctionId() const {
    return resolutionFunctionId;
  }

  VHDLType* createObject(ObjectBase::ObjectType) const;
  
protected:
  TypeInfo **fields;
  int noOfFields;

  bool   compositeResolvedType;

  ResolutionFnId_t resolutionFunctionId;
  
private:
};
  

// This holds information about AccessTypes.  This class is the "final" class
// in the class hiearchy.  It is a convinience class that is used to provide a
// uniform method of handling types in the system.

class AccessTypeInfo : public TypeInfo {
public:
  AccessTypeInfo() {}
  ~AccessTypeInfo() {}

  TypeInfoKind getKind() const {
    return ACCESS_TYPE_INFO;
  }

  VHDLType* createObject(ObjectBase::ObjectType) const;

protected:

private:
};

#endif
