//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 2002
// 
// EHM7.cc -- 
// 
// Author           : Roy Krischer
// Created On       : Sun Nov 24 12:42:34 2002
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jan  2 11:27:12 2004
// Update Count     : 11
// 

#include <uC++.h>
#include <uIOStream.h>


uThrowEvent fred {
  public:
    int k;
    fred ( int k ) : k(k) {}
};
uInitEvent( fred );

uTask mary {
  public:
    void main();
};

uTask john {
  public:
    void main();
};

mary m;
john j;

void mary :: main() {
    uThrow fred( 42 ) uAt j;
    try {
		uEnable {
			for ( int i = 0; i < 200; i+= 1 ) uYield();
		} // uEnable
    } catch ( j.fred f ) {
		uAssert( &j == f.getOriginalThrower() );
		uAssert( &j == &f.source() );
		uAssert( f.k == 84 ); 
		uCerr << uAcquire << "mary catches event from john: " << f.k << endl << uRelease;
	    for ( int i = 0; i < 200; i+= 1 )
			uYield();
    } // try
}
    
void john :: main() {
    uThrow fred( 84 ) uAt m;
    try {
		uEnable {
			for ( int i = 0; i < 200; i+= 1 ) uYield();
		} // uEnable
    } catch ( m.fred f ) {
		uAssert( &m == f.getOriginalThrower() );
		uAssert( &m == &f.source() );
		uAssert( f.k == 42 ); 
		uCerr << uAcquire << "john catches event from mary: " << f.k << endl
			  << "mary m's address: " << (void *)&m << " event binding: " << f.getOriginalThrower()
			  << " event Src: " << (void *)&f.source() << endl << uRelease;
	 
	    for ( int i = 0; i < 200; i+= 1 ) uYield();
    } // try
}

void uMain::main() {
	for ( int i = 0; i < 200; i+= 1 ) uYield();
}

// Local Variables: //
// tab-width: 4 //
// End: //
