//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// File.cc -- Print multiple copies of the same file to standard output
// 
// Author           : Peter A. Buhr
// Created On       : Tue Jan  7 08:44:56 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 22 08:41:44 2003
// Update Count     : 34
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uFile.h>

uTask Copier {
	uFile &input;

	void main() {
		uFileAccess in( input, O_RDONLY );
		int count;
		char buf[1];

		for ( int i = 0;; i += 1 ) {					// copy in-file to out-file
			count = in.read( buf, sizeof( buf ) );
		  if ( count == 0 ) break;						// eof ?
			uCout << buf[0];
			if ( i % 20 == 0 ) uYield();
		} // for
	} // Copier::main
  public:
	Copier( uFile &in ) : input( in ) {
	} // Copier::Copier
}; // Copier

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		uCerr << "Usage: " << argv[0] << " input-file" << endl;
		uExit( -1 );
	} // switch

	uFile input( argv[1] );								// connect with UNIX files
	{
		Copier c1( input ), c2( input );
	}
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ File.cc" //
// End: //
