//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// Inheritance.cc -- test inheritance of tasks
// 
// Author           : Peter A. Buhr
// Created On       : Thu Mar 22 20:20:04 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 22 08:39:16 2003
// Update Count     : 52
// 

/*
   Correct output:

   super::main
   sub::main
   super::fred: 3
   super::mary: 3
   sub::fred: 5
   sub::mary: 7
   sub::jane: a
   sub::main terminating
   sub::~sub
   super::~super
   super::main terminating
   super::~super
   */

#include <uC++.h>
#include <uIOStream.h>

uTask super {
    void main();
  public:
    virtual ~super();
    int fred( int );
    virtual float mary( float );
}; // super

void super::main() {
    uCout << uAcquire << "super::main" << endl << uRelease;
    for ( ;; ) {
	uAccept ( ~super ) {
	    break;
	} uOr uAccept ( fred ) {
	} uOr uAccept ( mary ) {
	} // accept
    } // for
    uCout << uAcquire << "super::main terminating" << endl << uRelease;
} // super::main

super::~super() {
    uCout << uAcquire << "super::~super" << endl << uRelease;
} // super::~super

int super::fred( int n ) {
    uCout << uAcquire << "super::fred: " << n << endl << uRelease;
    return n;
} // super::fred

float super::mary( float f ) {
    uCout << uAcquire << "super::mary: " << f << endl << uRelease;
    return f;
} // super::mary

uTask sub : public super {
    void main();
  public:
    virtual ~sub();
    int fred( int );
    virtual float mary( float );
    char jane( char );
}; // sub

void sub::main() {
    uCout << uAcquire << "sub::main" << endl << uRelease;
    for ( ;; ) {
	uAccept ( ~sub ) {
	    break;
	} uOr uAccept ( fred ) {
	} uOr uAccept ( mary ) {
	} uOr uAccept ( jane ) {
	} // accept
    } // for
    uCout << uAcquire << "sub::main terminating" << endl << uRelease;
} // sub::main

sub::~sub() {
    uCout << uAcquire << "sub::~sub" << endl << uRelease;
} // sub::~sub

int sub::fred( int n ) {
    uCout << uAcquire << "sub::fred: " << n << endl << uRelease;
    return n;
} // sub::fred

float sub::mary( float f ) {
    uCout << uAcquire << "sub::mary: " << f << endl << uRelease;
    return f;
} // sub::mary

char sub::jane( char c ) {
    uCout << uAcquire << "sub::jane: " << c << endl << uRelease;
    return c;
} // sub::jane

void uMain::main() {
    super S;
    sub s;

    S.fred( 3 );
    S.mary( 3.0 );
    s.fred( 5 );
    s.mary( 7.0 );
    s.jane( 'a' );
} // uMain::main

// Local Variables: //
// compile-command: "u++ Inheritance.cc" //
// End: //
