//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 2003
// 
// uSemaphore.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Thu Nov 20 17:17:52 2003
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Nov 21 17:46:42 2003
// Update Count     : 19
// 
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#include <uC++.h>
#include <uSemaphore.h>


uSemaphore::uSemaphore( unsigned int count ) : count( count ) {
} // uSemaphore::uSemaphore


void uSemaphore::P() {					// wait on a semaphore
    spin.acquire();
    count -= 1;
    if ( count < 0 ) {
	waiting.uAddTail( &(uThisTask().uEntryRef) );	// block current task
	THREAD_GETMEM( uSelf)->uDisableInterrupts();
	uActiveProcessorKernel->uSchedule( &spin );	// atomically release spin lock and block
	THREAD_GETMEM( uSelf)->uEnableInterrupts();
    } else {
	spin.release();
    } // if
} // uSemaphore::P


void uSemaphore::P( uSemaphore &s ) {			// wait on a semaphore and release another
    spin.acquire();
    if ( &s == this ) {					// perform operation on self ?
	if ( count < 0 ) {				// V my semaphore
	    waiting.uDropHead()->uGet().uWake();	// remove task at head of waiting list
	} // if
	count += 1;
    } else {
	s.V();						// V other semaphore
    } // if

    count -= 1;						// now P my semaphore
    if ( count < 0 ) {
	waiting.uAddTail( &(uThisTask().uEntryRef) );	// block current task
	THREAD_GETMEM( uSelf)->uDisableInterrupts();
	uActiveProcessorKernel->uSchedule( &spin );	// atomically release spin lock and block
	THREAD_GETMEM( uSelf)->uEnableInterrupts();
    } else {
	spin.release();
    } // if
} // uSemaphore::P


bool uSemaphore::TryP() {				// conditionally wait on a semaphore
    spin.acquire();
  if ( count <= 0 ) {
	spin.release();
	return false;
    } // if
    count -= 1;
    spin.release();
    return true;
} // uSemaphore::TryP


void uSemaphore::V( unsigned int times ) {		// signal a semaphore
    spin.acquire();
    for ( int i = times; i > 0; i -= 1 ) {
      if ( count >= 0 ) {
	    count += i;
	    break;
	} // if
	count += 1;
	waiting.uDropHead()->uGet().uWake();		// remove task at head of waiting list and make new owner
    } // for
    spin.release();
} // uSemaphore::V


int uSemaphore::counter() const {			// semaphore counter
    return count;
} // uSemaphore::counter


bool uSemaphore::empty() const {			// no tasks waiting on semaphore ?
    return count >= 0;
} // uSemaphore::empty


void *uSemaphore::operator new( size_t, void *storage ) {
    return storage;
} // uSemaphore::operator new


void *uSemaphore::operator new( size_t size ) {
    return ::operator new( size );
} // uSemaphore::operator new


// Local Variables: //
// compile-command: "gmake install" //
// End: //

