//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 2003
// 
// Allocation.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Oct  3 22:58:11 2003
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Jul 31 13:54:58 2005
// Update Count     : 15
// 

#include <uC++.h>
#include <unistd.h>					// sbrk
#if defined( __linux__ )
#include <malloc.h>					// TEMPORARY: memalign missing from stdlib.h
#endif
#include <iostream>
using std::cout;
using std::endl;

static const int NoOfAllocs = 10000;
char *locns[NoOfAllocs];

void uMain::main() {
    int i;
    char *start = (char *)sbrk( 0 );

    for ( int j = 0; j < 40; j += 1 ) {
	for ( i = 0; i < NoOfAllocs; i += 1 ) {
	    locns[i] = new char[i];
	    //cout << setw(6) << (void *)locns[i] << endl;
	} // for
	for ( i = 0; i < NoOfAllocs; i += 1 ) {
	    //cout << setw(6) << (void *)locns[i] << endl;
	    delete [] locns[i];
	} // for

	//cout << (char *)sbrk(0) - start << " bytes" << endl;

	for ( i = 0; i < NoOfAllocs; i += 1 ) {
	    locns[i] = new char[i];
	    //cout << setw(6) << (void *)locns[i] << endl;
	} // for
	for ( i = NoOfAllocs - 1; i >=0 ; i -= 1 ) {
	    //cout << setw(6) << (void *)locns[i] << endl;
	    delete [] locns[i];
	} // for
    } // for

    cout << (char *)sbrk(0) - start << " bytes" << endl;

    // check memalign

    size_t alignments[] = { 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 0 };
    for ( int a = 0; alignments[a] != 0; a += 1 ) {
	//cout << setw(6) << alignments[a] << endl;
	for ( int i = 0; i < 32 * 1024; i += 1 ) {
	    void *area = memalign( alignments[a], i );
	  if ( area == NULL ) uAbort( "out of memory" );
	    //cout << setw(6) << i << " " << area << endl;
	    if ( (size_t)area % alignments[a] != 0 ) {	// must always be correctly aligned
		uAbort( "bad alignment 0x%p", area );
	    } // if
	    free( area );
	} // for
    } // for

    cout << (char *)sbrk(0) - start << " bytes" << endl;

    // check memalign in conjunction with realloc

    for ( int a = 0; alignments[a] != 0; a += 1 ) {
	// initial N byte allocation
	void *area = memalign( alignments[a], 8 );
      if ( area == NULL ) uAbort( "out of memory" );
	//cout << setw(6) << alignments[a] << " " << area << endl;

	// Do not start this loop index at 0 because realloc of 0 bytes frees
	// the storage.
	for ( int i = 1; i < 32 * 1024; i += 1 ) {
	    area = realloc( area, i );
	  if ( area == NULL ) uAbort( "out of memory" );
	    //cout << setw(6) << i << " " << area << endl;
	    if ( (size_t)area % alignments[a] != 0 ) {	// must always be correctly aligned
		uAbort( "bad alignment 0x%p", area );
	    } // if
	} // for
	free( area );
    } // for

    cout << (char *)sbrk(0) - start << " bytes" << endl;
    cout << "successful completion" << endl;
} // uMain::main
