/* ==================================================== ======== ======= *
 *
 *  uuchoice.cpp
 *  Ubit Project [Elc::03]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuchoice.cpp	ubit:03.06.01"
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <uctrl.hpp>
#include <ubox.hpp>
#include <uevent.hpp>
#include <uchoice.hpp>
#include <update.hpp>
#include <ucall.hpp>


UChoice::UChoice(UBox* ct) :
  index(0),
  can_unselect_mode(false),
  // select_callback(ucall(this, &UChoice::itemChanged))
  container(ct){
}

UChoice::~UChoice() {
  destructs();
}

void UChoice::addingTo(ULink *selflink, UGroup *parent) {
  UProp::addingTo(selflink, parent);

  /// the parent can select its ARMable children
  parent->setCmodes(UMode::CAN_SELECT_CHILDREN, true);
}

//NB: removingFrom() requires a destructor to be defined
void UChoice::removingFrom(ULink *selflink, UGroup *parent) {
  UProp::removingFrom(selflink, parent);
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

void UChoice::setCanUnselectMode(bool state) {
  can_unselect_mode = state;
} 

bool UChoice::isCanUnselectMode() const {
  return can_unselect_mode;
} 

void UChoice::update() {
  //if (container) container->update(UUpdate::paint);
}

void UChoice::putProp(UContext *props, UCtrl *state) {
}

void UChoice::changed(bool update_now, UBox* target) {
  //if (update_now && (bmodes & UMode::NO_AUTO_UPDATE) == 0) update();

  if (cache) {
    UEvent e(UEvent::change, null, null, NULL);
    e.setAux(this);            // DEBILE: pas de target et risque de confusion!!
    fire(e, UOn::change);
    //inutile: impossible d'ajouter un tel CB a UChoice
    //fire(e, UOn::select);
  } 

  UEvent e2(UEvent::select, null, null, NULL);
  e2.setAux(target);
  // ensuite on lance les callbacks des parents
  if (target)
    parents.fireParents(e2, UOn::select);   // devrait etre change!!!
  else
    parents.fireParents(e2, UOn::unselect);
 }

/* ==================================================== ======== ======= */

UBox* UChoice::itemChanged(UEvent& e) {
  UBox* new_item = e.getBoxSource();
  if (!new_item) return null;

  UBox* old_item = getItem();
  UBox* found = null;

  // distinguer cas on et cas off;
  // rien a faire dans cas off sauf si c'est celui qui etait selectionne

  if (new_item->isSelected()) {	    // new_item est selectionne

    // pas de changement si cet item etait deja selectionne
    //if (new_item != old_item) found = setItem(new_item, false);
 
    // NORMALEMENT il ne faut faire que cela...
    if (new_item != old_item) 
      found = setItem(new_item, false);
    else {
      // .. et pas cela, mais le pbm c'est que du coup on ne sait
      // pas dectected qd qq'un reclique un item deja selectionne
      // ce qui oose pbms pour les lites et combo ==> A REVOIR!!!
      // (ie. UOn::action et UOn::change devraient etre differncies)
      found = new_item;
      changed(false, found);   // !!!TST
    }
  }
  
  else {			    // new_item est deselectionne
    // mise a jour seulement si cet item etait precedemment selectionne
    if (new_item == old_item){

      // si le UChoice impose qu'un item soit toujours selectionne
      // => reselectionner cet objet (cas ou on clique 2 fois sur l'item)
      //    mais sans rappeler les callbacks du UChoice
      if (!can_unselect_mode) {
	new_item->select(true, true);
	// MEME CHOSE ..................!!!!
	found = new_item;
      changed(false, found);   // !!!TST
      }

      // sinon, un 2e click deselectionne effectivement l'item
      else found = setItem(null, false);
    }
  }
  
  return found;
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

int UChoice::getIndex() const {
  return index;   // NB: index est mis a jour par getSelected()
}

// !! POSE PBM SI ON RAJOUTE OU ENLEVE DES ELEMENTS !!
// voir aussi note ci dessous

UBox* UChoice::getItem() const {
  if (!container) return null;
  int k = 0;
  UBrick* b;
  UListPos lpos;

  while ((b = container->getChild(lpos))) {
    UBox* item = b->boxCast();
    if (item) {       // && item->isSelectable())  !!
      // !ATT: l'utilisation de l'index (plutot que du test isSelected()
      // est necessaire pour l'appel de getSelected() dans itemChanged()
      // (car l'index continue a pointer sur l'ancien item selectionne)
      if (k == index) return item;
      k++;
    }
  }
  return null;			// pas trouve
}

UBox* UChoice::getLastItem() const {
  if (!container) return null;
  int k = 0;
  UBrick* b;
  UListPos lpos;
  UBox* last = null;

  while ((b = container->getChild(lpos))) {
    UBox* item = b->boxCast();
    if (item) {       // && item->isSelectable())  !!
      last = item;
      k++;
    }
  }
  return last;
}

int UChoice::getLastIndex() const {
  if (!container) return null;
  int k = 0;
  UBrick* b;
  UListPos lpos;

  while ((b = container->getChild(lpos))) {
    UBox* item = b->boxCast();
    if (item) {       // && item->isSelectable())  !!
      k++;
    }
  }
  return k-1;  // -1!!
}

/* ==================================================== ======== ======= */

UBox* UChoice::setItem(UBox* selection, bool upd) {
  if (!container) return null;
  index = -1;
  int k = 0;
  UBrick* b;
  UListPos lpos;
  UBox* found = null;
  
  while ((b = container->getChild(lpos))) {
    UBox* item = b->boxCast();
    if (item) {       // && item->isSelectable())   !!

      if (item == selection) {
	index = k;
	if (!item->isSelected()) item->select(true, true);
        found = item;
      }
      else {           // item != selection
	if (item->isSelected()) item->select(false, true);
      }
      k++;
    }
  }

  changed(false, found);
  if (upd) selection->update();
  return found;
}

UBox* UChoice::setItem(UBox& selection, bool upd) {
  return setItem(&selection, upd);
}

void UChoice::select(UBox& g) {
  setItem(g, true);
}

void UChoice::unselect() {
  setItem(null, true);
}

/* ==================================================== ======== ======= */

UBox* UChoice::setIndex(int new_index, bool upd) {
  if (!container) return null;

  if (new_index == -1) {		// means last item
    int k = 0;
    UBrick* b;
    UListPos lpos;
    while ((b = container->getChild(lpos))) {
      UBox* item = b->boxCast();
      if (item) {       // && item->isSelectable())  !!
	k++;
      }
    }
    new_index = k-1;
  }

  index = -1; // not found
  int k = 0;
  UBrick* b;
  UListPos lpos;
  UBox* found = null;

  while ((b = container->getChild(lpos))) {
    UBox* item = b->boxCast();
    if (item) {       // && item->isSelectable())   !!

      if (k == new_index) {
	index = new_index;
	if (!item->isSelected()) item->select(true, true);
        found = item;
      }
      else {        // k != new_index
	if (item->isSelected()) item->select(false, true);
      }
      k++;
    }
  }

  changed(false, found); 
  //if (upd) selection->update();
  return found;
}

void UChoice::select(int new_index) {setIndex(new_index, true);}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

URadioSelect::URadioSelect() :
  can_unselect_mode(false),
  pindex(new UIntg(-1)),
  pselect_callback(ucall(this, &URadioSelect::itemChanged)) {
  pindex->onChange(ucall(this, &URadioSelect::setIndexImpl));
}

URadioSelect::URadioSelect(UIntg& idx) :
  can_unselect_mode(false),
  pindex(idx),
  pselect_callback(ucall(this, &URadioSelect::itemChanged)) {
  pindex->onChange(ucall(this, &URadioSelect::setIndexImpl));
}

URadioSelect::~URadioSelect() {
  destructs();
}

/* ==================================================== ======== ======= */

void URadioSelect::addingTo(ULink *selflink, UGroup *parent) {
  UProp::addingTo(selflink, parent);
  // ajouter handlers au parent
  // corr:3may03: si on clique un item deja selectionne, il faut que
  // les callbacks du client soient appeles 2 fois et dans le bon ordre:
  // - d'abord: pour unselect provoque' par click sur item
  // - ensuite: pour select provoque par radioSelect => son callback
  //   doit etre execute *ensuite*. pour garantir l'ordre on utilise
  //   Uon::action qui est tjrs declenche apres Uon::change (meme si
  //   place dans la attrlist plutot que ds la childlist)

  parent->addAttr(UOn::action / *pselect_callback);  // dans cache
  // doit etre remis ou pas ???
  // parent->addAttr(UOn::select   / *pselect_callback);
  // parent->addAttr(UOn::unselect / *pselect_callback);

  // rend le parent selectable (indispansable!)
  parent->setCmodes(UMode::CAN_SELECT, true);
}

/* ==================================================== ======== ======= */
//NB: removingFrom() requires a destructor to be defined

void URadioSelect::removingFrom(ULink *selflink, UGroup *parent) {
  // enlever les callbacks (2 occurences!)
  // false -> ne PAS detruire les ucall (qui sont partages!)

  parent->removeAttr(*pselect_callback, false);
  // parent->removeAttr(*pselect_callback, false);
  parent->setCmodes(UMode::CAN_SELECT, false);
  UProp::removingFrom(selflink, parent);
}

void URadioSelect::setCanUnselectMode(bool state) {
  can_unselect_mode = state;
} 
bool URadioSelect::isCanUnselectMode() const {
  return can_unselect_mode;
} 

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void URadioSelect::update() {
  parents.updateParents(UUpdate::paint);
}

void URadioSelect::putProp(UContext *props, UCtrl *state) {}

void URadioSelect::changed(bool update_now) {
  if (update_now && (bmodes & UMode::NO_AUTO_UPDATE) == 0)
    update();
  
  if (cache) {
    UEvent e(UEvent::change,  null, null, NULL);
    e.setAux(this);
    fire(e, UOn::change);
    //inutile: impossible d'ajouter un tel CB a USelect
    //fire(e, UOn::select);
  } 

  /* FAUX: agirait sur les parents du radioSelect !
     UEvent e2(UEvent::select.., null, NULL);
     e2.setChildSource(getSelected());
     parents.fireParents(e2, UOn::select);     // !! objet !!
  */
}

/* ==================================================== ======== ======= */

void URadioSelect::itemChanged(UEvent& e) {
  UGroup* new_item = e.getSource();
  if (!new_item) return;

  UGroup* old_item = getItem();

  // distinguer cas on et cas off;
  // rien a faire dans cas off sauf si c'est celui qui etait selectionne

  if (new_item->isSelected()) {	    // new_item vient d'etre selectionne
    // pas de changement si cet item etait deja selectionne
    if (new_item != old_item) setItem(new_item);
  }

  else {			    // new_item vient d'etre deselectionne
    // mise a jour seulement si cet item etait precedemment selectionne
    if (new_item == old_item) {

      // si le USelect impose qu'un item soit toujours selectionne
      // => reselectionner cet objet (cas ou on clique 2 fois sur l'item)
      //    mais sans rappeler les callbacks du USelect
      if (!can_unselect_mode) new_item->select(true, true);

      // sinon, un 2e click deselectionne effectivement l'item
      else setItem(null);
    }
  }
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

UGroup* URadioSelect::getItem() const {
  if (pindex->getValue() < 0) return null;
  int k = 0;
  for (ULinkLink *l = parents.first(); l; l = l->getNext(), k++) {
    if (k == pindex->getValue()) return l->link()->getParent();
  }
  return null;	    // pas trouve
}

/* ==================================================== ======== ======= */

void URadioSelect::setItem(UGroup* selection) {
  int k = 0;
  for (ULinkLink *l = parents.first(); l; l = l->getNext(), k++) {
    if (l->link()->getParent() == selection) {
      *pindex = k;
      return;
    }
  }
  *pindex = -1; // not found
}

void URadioSelect::setItem(UGroup& selection) {
  setItem(&selection);
}

void URadioSelect::select(UGroup& selection) {
  setItem(&selection);
}

void URadioSelect::unselect() {
  setItem(null);
}

/* ==================================================== ======== ======= */
/*
 * le probleme ici est que les indices sont qq peu ...
 */

int URadioSelect::getIndex() const {
  return pindex->getValue();
}

void URadioSelect::select(int new_index) {setIndex(new_index);}

void URadioSelect::setIndex(int new_index) {
  if (new_index == -1)		// means last item
    *pindex = getParentCount() - 1;
  else *pindex = new_index;
}

void URadioSelect::setIndex(const UIntg& new_index) {
  if (new_index.getValue() == -1)		// means last item
    *pindex = getParentCount() - 1;
  else *pindex = new_index;
}

void URadioSelect::setIndexImpl() {
  int k = 0;

  for (ULinkLink *l = parents.first(); l; l = l->getNext(), k++) {
    UGroup *obj = l->link()->getParent();
    if (obj) { 
      if (k == pindex->getValue()) {
	if (!obj->isSelected()) obj->select(true, true);
      }
      else { // k != new_index
	if (obj->isSelected()) obj->select(false, true);
      }
    }
  }

  changed(false);     // update();  deja fait objet par objet
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
