/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Zsombor Egri <zsombor.egri@canonical.com>
 */

#ifndef THEMEENGINE_P_H
#define THEMEENGINE_P_H

#include <QtCore/QHash>
#include <QtCore/QStringList>
#include <QtCore/QObject>
#include <QtCore/QCoreApplication>
#include "themeengine.h"
#include "themesettings_p.h"
#include "stylecache_p.h"

#include <QDebug>

class QQuickItem;
class QQmlComponent;
class ThemeLoader;

typedef QHash<QString, QQuickItem*> InstanceHash;

// Private functionality of the theme engine
class ThemeEnginePrivate
{
    Q_DECLARE_PUBLIC(ThemeEngine)
public:
    ThemeEnginePrivate(ThemeEngine *qq);
    ~ThemeEnginePrivate();

public: //members
    ThemeEngine *q_ptr;
    static ThemeEngine *themeEngine;

    QQmlEngine *m_engine;
    // suffix tree for the styles
    StyleCache m_styleCache;
    InstanceHash m_instanceCache;
    QStringList importPaths;
    QMap<QString, ThemeLoader*> themeLoaders;
    ThemeSettings themeSettings;
    QFileSystemWatcher themeWatcher;
    // needed for theme loading
    QString errorString;
    QUrl currentTheme;
    bool firstThemeLoaded;

    // public functions on instance
public:
    void removeWatchedFiles();
    void addWatchedFiles(const QStringList &watchedThemeFiles);
    void loadTheme(const QUrl &themeFile);

    // utility functions that are independent from the instance
    static StyleCache::StyleData *styleRuleForPath(const Selector &path);
    static bool registerName(QQuickItem *item, const QString &newName);
    static void setError(const QString &error);
    static ItemStyleAttached *attachedStyle(QObject *obj);
    static QList<Selector> parseSelector(const QString &selectorString);

// private slots
    void _q_updateTheme();
    void _q_reloadTheme();
};

inline QString themeFolder()
{
    QString env = QLatin1String(getenv("UITK_THEME_PATH"));
    env = env.isEmpty() ? QString("/usr/share/themes") : env + "/themes";
    return env;
}

// returns the theme file set through UITK_THEME_FILE env. variable
inline QString localThemeFile()
{
    QString env = QLatin1String(getenv("UITK_THEME_FILE"));
    return env;
}

#endif // THEMEENGINE_P_H
