#include <config.h>
#include "ucarp.h"
#include "spawn.h"
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

int spawn_handler(const int dev_desc_fd, const char * const script)
{
    pid_t pid;
    
    if (script == NULL || *script == 0) {
        return 0;
    }
    pid = fork();
    if (pid == (pid_t) 0) {
        (void) close(dev_desc_fd);
        execl(script, script, interface, (char *) NULL);
        _exit(EXIT_FAILURE);
    } else if (pid != (pid_t) -1) {
        printf("Spawning [%s %s]\n", script, interface);
#ifdef HAVE_WAITPID
        (void) waitpid(pid, NULL, 0);
#else
        {
            pid_t foundpid;
            
            while ((foundpid = wait3(NULL, 0, NULL)) != (pid_t) -1 &&
                   foundpid != pid);
        }
#endif
    } else {
        perror("Unable to spawn the script");
        return -1;
    }
    return 0;
}

