#include "cs_mex.h"
/* cs_sqr: symbolic sparse QR factorization */
void mexFunction
(
    int nargout,
    mxArray *pargout [ ],
    int nargin,
    const mxArray *pargin [ ]
)
{
    css *S ;
    csn *N ;
    cs Amatrix, *A ;
    int m, n, order, *leftmost, *P ;
    if (nargout > 6 || nargin != 1)
    {
	mexErrMsgTxt ("Usage: [pinv,leftmost,q,parent,vnz,rnz] = cs_sqr(A)") ;
    }
    A = cs_get_sparse (&Amatrix, 0, 1, pargin [0]) ;	/* get A */
    m = A->m ;
    n = A->n ;

    order = (nargout == 5) ? 2 : -1 ;	    /* determine ordering */
    S = cs_sqr (A, order, 1) ;		    /* symbolic QR ordering & analysis*/

    if (!S) mexErrMsgTxt ("symbolic QR failed") ;

    leftmost = S->Pinv + m + n ;

    pargout [0] = cs_put_int (S->Pinv, S->m2, 1, 0) ;	/* return Pinv */
    pargout [1] = cs_put_int (leftmost, m, 1, 0) ;	/* return leftmost */
    pargout [2] = cs_put_int (S->Q, n, 1, 0) ;		/* return Q */
    pargout [3] = cs_put_int (S->parent, n, 1, 0) ;	/* return parent */
    pargout [4] = mxCreateDoubleScalar (S->lnz) ;	/* return nnz(V) */
    pargout [5] = mxCreateDoubleScalar (S->unz) ;	/* return nnz(R) */

    cs_sfree (S) ;
}
