/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATION_SETTINGS_H_
#define _GB2_ANNOTATION_SETTINGS_H_

#include <core_api/core_api.h>
#include <QtGui/QColor>

namespace GB2 {

class Settings;

class GB2_COREAPI_EXPORT AnnotationSettings {
public:
    AnnotationSettings();
    AnnotationSettings(const AnnotationSettings* as);
    AnnotationSettings(const QString& name, bool amino, const QColor& color, bool visible);

    bool equals(const AnnotationSettings* as) const;

    QString name;
    bool    amino;
    QColor  color;
    bool    visible;
};

class GB2_COREAPI_EXPORT AnnotationSettingsRegistry : public QObject {
Q_OBJECT
public:
    AnnotationSettingsRegistry(Settings* s);
    ~AnnotationSettingsRegistry();

    QStringList getAllSettings() {return persistentMap.keys();}
    const AnnotationSettings* getSettings(const QString& name);
    
    void changeSettings(const QList<AnnotationSettings*>& settings);

signals:
    void si_annotationSettingsChanged(const QStringList& changedSettings);

private:
    void read();
    void addPredefined();
    void save();

    Settings* s;
    QMap<QString, AnnotationSettings*> persistentMap;
    QMap<QString, AnnotationSettings*> transientMap;
};


}//namespace

#endif

