/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ADVAnnotationCreation.h"

#include "AnnotatedDNAView.h"
#include "ADVSequenceObjectContext.h"

#include <util_gui/CreateAnnotationDialog.h>
#include <util_gui/CreateAnnotationWidgetController.h>//for CreateAnnotationModel
#include <util_tasks/CreateAnnotationTask.h>
#include <gobjects/GObjectUtils.h>
#include <selection/AnnotationSelection.h>
#include <selection/DNASequenceSelection.h>
#include <gobjects/DNASequenceObject.h>
#include <gobjects/AnnotationTableObject.h>
#include <core_api/AppContext.h>
#include <core_api/Task.h>

#include <QtCore/QFileInfo>

namespace GB2 {

ADVCreateAnnotationsTask::ADVCreateAnnotationsTask(AnnotatedDNAView* _ctx, AnnotationTableObject* o, const QString& group, const QList<SharedAnnotationData>& data)  
: Task(tr("adv_create_annotation_task"), TaskFlags_NR_DWF), ctx(_ctx)
{
    t  = new CreateAnnotationsTask(o, group, data);
    addSubTask(t);
}
	
Task::ReportResult ADVCreateAnnotationsTask::report() {
    if (!t->getStateInfo().hasErrors() && !ctx.isNull()) {
        Annotation* a = t->getAnnotations().first();	
        assert(a);

        AnnotationTableObject* ao = a->getGObject();
        if (!ctx->getAnnotationObjects().contains(ao)) { 
            //for documents loaded during annotation creation object is added here
            stateInfo.error = ctx->addObject(ao);
        }
        if (stateInfo.error.isEmpty()) {
            ctx->getAnnotationsSelection()->clear();
            ctx->getAnnotationsSelection()->addToSelection(a);
        }
    }
    return ReportResult_Finished;
}

//////////////////////////////////////////////////////////////////////////
/// ADVAnnotationCreation

ADVAnnotationCreation::ADVAnnotationCreation(AnnotatedDNAView* c) : QObject(c) {
	ctx = c;
    createAction = new QAction(QIcon(":core/images/create_annotation_icon.png"), tr("create_annotation"), this);
	createAction->setShortcut(QKeySequence(Qt::CTRL | Qt::Key_A));
	createAction->setShortcutContext(Qt::WindowShortcut);
	connect(createAction, SIGNAL(triggered()), SLOT(sl_createAnnotation()));
}

void ADVAnnotationCreation::sl_createAnnotation() {
    ADVSequenceObjectContext* seqCtx = ctx->getSequenceInFocus();
    assert(seqCtx!=NULL);
    CreateAnnotationModel m;
    m.sequenceObjectRef = GObjectReference(seqCtx->getSequenceObject());
    if (!seqCtx->getSequenceSelection()->isEmpty()) {
        m.data->location = seqCtx->getSequenceSelection()->getSelectedRegions();
    }
    CreateAnnotationDialog d(&m);
	int rc = d.exec();
	if (rc != QDialog::Accepted) {
		return;
	}

	assert(m.annotationObject!=NULL);
	
	QList<SharedAnnotationData> data;
    data << m.data;
	ADVCreateAnnotationsTask* t = new ADVCreateAnnotationsTask(ctx, m.annotationObject, m.groupName, data);
	AppContext::getTaskScheduler()->registerTopLevelTask(t);
}

} // namespace
