/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef  _GB2_PAN_VIEW_ROWS_H_
#define  _GB2_PAN_VIEW_ROWS_H_

#include <core_api/LRegion.h>

#include <QtCore/QString>
#include <QtCore/QMap>
#include <QtCore/QList>

namespace GB2 {

class Annotation;

class PVRowData {
public:
	PVRowData(const QString& _key) : key(_key), rowNum(-1), uptodate(true){}

	QString key;
    int rowNum;
    QList<LRegion> ranges;
    QList<Annotation*> annotations;
    bool uptodate;
};

class PVRowsManager {
public:    
	PVRowsManager() {}
    ~PVRowsManager();

    int addAnnotation(Annotation* f, const QString& key);
    void removeAnnotation(Annotation* f);
    
	int getNumRows() const;
    int getAnnotationRow(Annotation* f);

    bool contains(const QString& key) const;

    void resort();
    void clear();
    
	const QString& getRowKey(int rowNum) const;
	int getNumAnnotationsInRow(int rowNum) const;

private:
    bool isUpToDate() const;
    bool addToRow(Annotation* f, PVRowData* row);
    bool fitToRow(PVRowData* row, const LRegion& region);

    QList<PVRowData*> rows;
    QMap<Annotation*, PVRowData*> rowByAnnotaion;
};


} // namespace

#endif
