/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "MSAEditor.h"
#include "MSAEditorTasks.h"
#include "MSAEditorFactory.h"
#include "MSAEditorState.h"
#include "MSAEditorConsensusArea.h"
#include "MSAEditorSequenceArea.h"
#include "MSAEditorNameList.h"

#include <gobjects/MAlignmentObject.h>
#include <util_gui/GUIUtils.h>

#include <QtCore/QEvent>

#include <QtGui/QVBoxLayout>
#include <QtGui/QGridLayout>
#include <QtGui/QPainter>


namespace GB2 {

/* TRANSLATOR GB2::MSAEditor */ 

MSAEditor::MSAEditor(const QString& viewName, MAlignmentObject* obj) : GObjectView(MSAEditorFactory::ID, viewName),  msaObject(obj), ui(NULL) 
{
    objects.append(msaObject);
    requiredObjects.append(msaObject);
}

MSAEditor::~MSAEditor() {

}

void MSAEditor::buildStaticToolbar(QToolBar* tb) {
    GObjectView::buildStaticToolbar(tb);
}

void MSAEditor::buildStaticMenu(QMenu* m) {
    addCopyMenu(m);
    addEditMenu(m);
    addAlignMenu(m);
    addAdvancedMenu(m);

    GObjectView::buildStaticMenu(m);

    GUIUtils::disableEmptySubmenus(m);
}


void MSAEditor::addCopyMenu(QMenu* m) {
    QMenu* cm = m->addMenu(tr("copy_menu"));
    cm->menuAction()->setObjectName(MSAE_MENU_COPY);
}

void MSAEditor::addEditMenu(QMenu* m) {
    QMenu* em = m->addMenu(tr("edit_menu"));
    em->menuAction()->setObjectName(MSAE_MENU_EDIT);
}


void MSAEditor::addAlignMenu(QMenu* m) {
    QMenu* em = m->addMenu(tr("align_menu"));
    em->menuAction()->setObjectName(MSAE_MENU_ALIGN);
}

void MSAEditor::addAdvancedMenu(QMenu* m) {
    QMenu* em = m->addMenu(tr("advanced_menu"));
    em->menuAction()->setObjectName(MSAE_MENU_ADVANCED);
}


Task* MSAEditor::updateViewTask(const QString& stateName, const QVariantMap& stateData) {
    return new UpdateMSAEditorTask(this, stateName, stateData);
}

QVariantMap MSAEditor::saveState() {
    return MSAEditorState::saveState(this);
}

QWidget* MSAEditor::createWidget() {
    assert(ui == NULL);
    ui = new MSAEditorUI(this);
    connect(ui , SIGNAL(customContextMenuRequested(const QPoint &)), SLOT(sl_onContextMenuRequested(const QPoint &)));
    return ui;
}

int MSAEditor::getAlignmentLen() const {
    return msaObject->getMAlignment().getLength();
}

int MSAEditor::getNumSequences() const {
    return msaObject->getMAlignment().getNumSequences();
}


void MSAEditor::sl_onContextMenuRequested(const QPoint & pos) {
    Q_UNUSED(pos);

    QMenu m;

    addCopyMenu(&m);
    addEditMenu(&m);
    addAlignMenu(&m);
    addAdvancedMenu(&m);

    emit si_buildPopupMenu(this, &m);

    GUIUtils::disableEmptySubmenus(&m);

    m.exec(QCursor::pos());
}


//////////////////////////////////////////////////////////////////////////
MSAEditorUI::MSAEditorUI(MSAEditor* _editor) : editor(_editor) {

    setContextMenuPolicy(Qt::CustomContextMenu);

    //setup layout
    QVBoxLayout* mainLayout = new QVBoxLayout(this);
    mainSplitter = new QSplitter(Qt::Horizontal, this);
    mainLayout->addWidget(mainSplitter);
    mainLayout->setMargin(0);
    setLayout(mainLayout);

    QWidget* nameArea = new QWidget(this);
    QWidget* drawArea = new QWidget(this);
    mainSplitter->addWidget(nameArea);
    mainSplitter->addWidget(drawArea);

    QVBoxLayout* nameAreaLayout= new QVBoxLayout(nameArea);
    nameAreaLayout->setSpacing(0);
    nameAreaLayout->setMargin(0);
    consList = new QListWidget(this);
    nameList = new MSAEditorNameList(this);
    nameAreaLayout->addWidget(consList);
    nameAreaLayout->addWidget(nameList);
    nameArea->setLayout(nameAreaLayout);

    QGridLayout* drawAreaLayout = new QGridLayout(drawArea);
    drawAreaLayout->setSpacing(0);
    drawAreaLayout->setMargin(0);
    shBar = new QScrollBar(Qt::Horizontal, drawArea);
    svBar = new QScrollBar(Qt::Vertical, drawArea);
    seqArea = new MSAEditorSequenceArea(this);
    consArea = new MSAEditorConsensusArea(this);
    drawAreaLayout->addWidget(consArea, 0, 0, 1, 2);
    drawAreaLayout->addWidget(seqArea,  1, 0, 1, 1);
    drawAreaLayout->addWidget(svBar,    1, 1, 1, 1);
    drawAreaLayout->addWidget(shBar,    2, 0, 1, 1);
    drawArea->setLayout(drawAreaLayout);

    //tune geometry
    mainSplitter->setChildrenCollapsible(false);
    mainSplitter->setSizes(QList<int>()<<100<<400);
    mainSplitter->setHandleWidth(4);
    mainSplitter->setFrameShadow(QFrame::Sunken);
    
    int h = consList->visualItemRect(consList->item(consList->count()-1)).bottom() + consList->spacing();
    consList->setFixedHeight(h);
    consArea->setFixedHeight(h);
    nameArea->setMinimumSize(200, 2*h);
}




}//namespace

