/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_CONSENSUS_AREA_H_
#define _GB2_MSA_EDITOR_CONSENSUS_AREA_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtGui/QWidget>
#include <QtGui/QMenu>

namespace GB2 {

class MSAEditor;
class MSAEditorUI;
class GObjectView;

class GB2_COREAPI_EXPORT MSASymStatItem {
public:
    MSASymStatItem() : c('\0'), count(0){}
    MSASymStatItem(char _c, int _count) : c(_c), count(_count){}

    char c;
    int  count;
};

class GB2_COREAPI_EXPORT MSAEditorConsensusArea : public QWidget {
    Q_OBJECT
public:
    MSAEditorConsensusArea(MSAEditorUI* ui);

    LRegion getRullerLineYRange() const;

    const QVector<MSASymStatItem>& getTopSymsStat() const {return topSyms;}

protected:
    void paintEvent(QPaintEvent *);

private slots:
    void sl_startPosChanged(int pos);
    void sl_alignmentModified();
    void sl_cursorPosChanged(const QPoint& pos, const QPoint& prev);

    void sl_buildStaticMenu(GObjectView* v, QMenu* m);
    void sl_buildContextMenu(GObjectView* v, QMenu* m);
    void sl_copyConsensusSequence();

private:
    void buildMenu(QMenu* m);
    void updateConsensus();
    void updateStats();

    void drawConsensus(QPainter& p);
    void drawCursor(QPainter& p);
    void drawRuler(QPainter& p);
    void drawHistogram(QPainter& p);

    LRegion getLineYRange(int l) const;

    MSAEditor*          editor;
    const MSAEditorUI*  ui;
    QFont               rulerFont;
    
    QByteArray          consensusLine;
        
    QAction*            copyConsensusAction;

    QVector<MSASymStatItem> topSyms;
};


}//namespace
#endif

