/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_NAME_LIST_H_
#define _GB2_MSA_EDITOR_NAME_LIST_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtGui/QListWidget>
#include <QtGui/QMenu>

namespace  GB2 {

class MSAEditor;
class MSAEditorUI;
class GObjectView;

class MSAEditorNameList: public QListWidget {
    Q_OBJECT
public:
    MSAEditorNameList(MSAEditorUI* ui);

    int getFirstVisibleSequence() const;

    int getLastVisibleSequence(bool countClipped) const;

    int getNumVisibleSequences(bool countClipped) const {return getLastVisibleSequence(countClipped) - getFirstVisibleSequence() + 1;}

    bool isSequenceVisible(int n, bool countClipped) const;

    void setFirstVisibleSequence(int n);

    LRegion getSequenceYRange(int n, bool useVirtualCoords) const;

private slots:
    void sl_onItemSelectionChanged();
    void sl_consCurrentItemChanged(QListWidgetItem* current, QListWidgetItem* previous );

    void sl_buildStaticMenu(GObjectView* v, QMenu* m);
    void sl_buildContextMenu(GObjectView* v, QMenu* m);
    void sl_copyCurrentSequence();
    void sl_removeCurrentSequence();
    void sl_sequenceListModified();
    void sl_lockedStateChanged();

private:
    void updateActions();
    void buildMenu(QMenu* m);
    void populateList();
    void updateStateLockInfo();

    MSAEditor*          editor;
    MSAEditorUI*        ui;

    QAction*            copyCurrentSequenceAction;
    QAction*            removeCurrentSequenceAction;
};

}//namespace
#endif
