/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <core_api/DocumentModel.h>
#include <core_api/ProjectModel.h>
#include <core_api/AppContext.h>
#include "AddDocumentTask.h"

namespace GB2
{

AddDocumentTask::AddDocumentTask( Document * _d ) :
Task( tr("add_document_task"), TaskFlags(TaskFlag_DeleteWhenFinished) ), d(_d)
{

}

Task::ReportResult AddDocumentTask::report()
{
    Project * p = AppContext::getProject();
    if( p->isStateLocked() ) {
        return ReportResult_CallMeAgain;
    } else if(d) {
        p->addDocument( d );
    } else {
        stateInfo.error += tr("document_removed");
    }
    return ReportResult_Finished;
}

}//namespace
