/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TASK_MAPPER_H_
#define _GB2_TASK_MAPPER_H_

#include <core_api/Task.h>

#include <QtCore/QList>
#include <QtCore/QString>

namespace GB2
{

class GB2_COREAPI_EXPORT TaskSignalMapper : public QObject {
    Q_OBJECT
public:
    TaskSignalMapper(QObject* parent = NULL) : QObject(parent) {}
    TaskSignalMapper(Task* t) : QObject(t) {
        connect(t, SIGNAL(si_stateChanged()), SLOT(sl_taskStateChanged()));
    }
public slots:
    void sl_taskStateChanged();
signals:
    void si_taskPrepared();
    void si_taskRunning();
    void si_taskFinished();
    void si_taskSucceeded();
    void si_taskFailed();
};

} //namespace

#endif 
