/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_LOCAL_DOMAIN_H_
#define _GB2_WORKFLOW_LOCAL_DOMAIN_H_

#include <workflow/IntegralBus.h>
#include <workflow/IntegralBusModel.h>
#include <workflow/WorkflowTransport.h>
#include <workflow/WorkflowManager.h>

#include <QtCore/QQueue>
#include <limits.h>

namespace GB2 {
namespace LocalWorkflow {
using namespace Workflow;

class WCOREAPI_EXPORT BaseWorker : public QObject, public Worker, public CommunicationSubject {
    Q_OBJECT
public:
    BaseWorker(Actor* a, bool autoTransitBus = true);
    virtual ~BaseWorker();
    virtual bool addCommunication(const QString& name, CommunicationChannel* _ch);
    virtual CommunicationChannel* getCommunication(const QString& name) {return ports.value(name);}
protected:
    Actor* actor;
    QMap<QString, IntegralBus*> ports;
}; 

class WCOREAPI_EXPORT SimplestSequentialScheduler : public Scheduler {
public:
    SimplestSequentialScheduler(Schema* sh) : schema(sh) {}
    virtual ~SimplestSequentialScheduler();
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() ;
private:
    Schema* schema;
};

class WCOREAPI_EXPORT SimpleQueue : public CommunicationChannel {
public:
    SimpleQueue() : ended(false) {
    }
    virtual ~SimpleQueue(){}
    virtual Message get() {assert(hasMessage()); return que.dequeue();}
    virtual void put(const Message& m) {que.enqueue(m);}
    virtual int hasMessage() const {return !que.isEmpty();}
    virtual int hasRoom(const DataType* t = NULL) const {Q_UNUSED(t); return true;}
    virtual bool isEnded() const {return ended && que.isEmpty();}
    virtual void setEnded() {ended = true;}

    virtual int capacity() const {return INT_MAX;}
    virtual void setCapacity(int) {}

protected:
    QQueue<Message> que;
    bool ended;
};

class WCOREAPI_EXPORT LocalDomainFactory : public DomainFactory {
public:
    static const QString ID;
    LocalDomainFactory() : DomainFactory(ID) {}
    virtual ~LocalDomainFactory(){}
    virtual Worker* createWorker(Actor*);
    virtual CommunicationChannel* createConnection(Link*);
    virtual Scheduler* createScheduler(Schema*, Configuration*);
    virtual void destroy(Scheduler*, Schema*);
};

}//Workflow namespace
}//GB2 namespace

#endif
