/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "BioStruct3DGLRender.h"
#include "BallAndStickGLRenderer.h"
#include "TubeGLRenderer.h"
#include "WormsGLRenderer.h"

namespace GB2 { 

#define REGISTER_FACTORY(c) \
    map.insert(c::ID, new c::Factory)

QMap<QString,BioStruct3DGLRendererFactory*> BioStruct3DGLRendererFactory::createFactories()
{
    QMap<QString,BioStruct3DGLRendererFactory*> map;
    REGISTER_FACTORY(BallAndStickGLRenderer);
    REGISTER_FACTORY(TubeGLRenderer);
    REGISTER_FACTORY(WormsGLRenderer);
    return map;
}

const QString BioStruct3DGLRendererFactory::defaultFactoryName()
{
    return WormsGLRenderer::ID;
}



void BioStruct3DGLRenderer::updateColorScheme( const BioStruct3DColorScheme* s )
{
    Q_ASSERT(s != NULL);
    colorScheme = s;
}
} //namespace
