/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REPEAT_SARRAY_H_
#define _GB2_REPEAT_SARRAY_H_

#include "SArrayIndex.h"
#include "RepeatFinder.h"

#include <QThread>
#include <QLinkedList>
#include <QVector>

namespace GB2 {

class RepeatFinderSArrayW : public RepeatFinder {
	class WorkerThread;
public:
	RepeatFinderSArrayW(const char* seqX, quint32 sizeX, const char* seqY, quint32 sizeY, DNAAlphabet* al,  quint32 w,  quint32 threads = 1);
	virtual ~RepeatFinderSArrayW();
	
	RepeatResult* getResult(quint32 num);
	quint32 getNumResults();

	void startCalculation();
	/** oldest one, slowest(2 times slower reflective), 8x mem usage*/
	void calculate(WorkerThread* t);
	/** oldest and fastest for seq < 3Mb. 8x mem usage, reflective only*/
	void calculateReflective(WorkerThread* t);
	/** current mainstream, the best for W>30, size > 5Mb, 8x/GAP mem usage (GAP~=W/2)*/
	void calculateProgressive(WorkerThread* t);
	/** reserved for future use, 20-30% slower than progressive version for large seqs, 16x/GAP mem usage (GAP~=W/2)*/
	void calculateDoubleIndex(WorkerThread* t);
	void terminateCalculation();
    bool isRunning() const {return active;}

private:
	const char *arraySeq;
	const char *searchSeq;
	quint32 ARRAY_SIZE;
	quint32 SEARCH_SIZE;
	bool arrayIsX;

	quint32 nThreads;
//	QMutex resultMutex;
	QMutex boundaryMutex;
	QMutex indexMutex;

	char unknownChar;
	quint32 bitMaskCharBitsNum;
	//const quint32* bitMask;
	
	inline void addToResults(quint32 a, quint32 s, quint32 l, WorkerThread* t);
	inline void addToResults2(quint32 a, quint32 s, quint32 l);

	/** final results*/
	QVector<RepeatResult> results;

	/** boundary results */
	QVector<quint32> bresultsA;
	QVector<quint32> bresultsS;
	QVector<quint32> bresultsL;
	QVector<quint32> bresultsD;

	quint32 arrayPercent;
	quint32 reportCounter;
	quint32 percentDone;
	
	/**each thread reports that percent done using this method*/
	inline void report();

	/*number of running threads */
	quint32 nRunning;
	void waitThreadsStop();

	quint32 getWGap(quint32 w);

	/*active flag*/
	bool active;

	/** used to avoid instantiations to return values*/
	RepeatResult tmpEdge;

	class WorkerThread : public SArrayIndex::SAISearchContext, public QThread {
	public:
		WorkerThread(RepeatFinderSArrayW* owner, quint32 sStart, quint32 sEnd, quint32 _tid);
		virtual ~WorkerThread(){}
		void run();
	
		RepeatFinderSArrayW* owner;
		const quint32 sStart;
		const quint32 sEnd;
		const quint32 tid;
	};


	friend class WorkerThread;
	
	QLinkedList<WorkerThread*> workers;
	void onFinished(WorkerThread* t);

	SArrayIndex *index;

	
	class CheckingEdge {
	public:
		qint32 diag;
		const char* s;
		const char* lastS;
		CheckingEdge* next;
		CheckingEdge* prev;
		
                CheckingEdge(const char* _s, qint32 _diag, const char* _lastS) : diag(_diag), s(_s), lastS(_lastS), next(NULL), prev(NULL) {}
		~CheckingEdge(){}

		void fromChain() {
			prev->next=next;
			next->prev=prev;
		};

		void toChain(CheckingEdge* chain) {
			next = chain;
			prev = chain->prev;
			chain->prev->next = this;
			chain->prev = this;
		}

	};

};

}//namespace
#endif
