/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SARRAY_INDEX_H_
#define _GB2_SARRAY_INDEX_H_

#include <QtCore/QBitArray>
#include <QtCore/QtGlobal>

namespace GB2 {

class SArrayIndex {

public:
	static int getBitLen(int n) {int i=0;while(n>>=1)i++; return i;}

	class SAISearchContext {
	public:
		SAISearchContext() : currSample(NULL), currPos(0xFFFFFFFF), bitValue(0xFFFFFFFF) {}
		virtual ~SAISearchContext(){}
		const char* currSample;
		quint32 currPos;
		quint32 bitValue;
	};


	const quint32 w, w4, wRest, skipGap, gapOffset;
	quint32 size, size_1;
	quint32* sArray;
	quint32* bitMask;
	quint32 bitFilter;
	quint32 wCharsInMask;
	quint32 wAfterBits;

	//qlt - quick lookup table, size = 0 disable it's usage
	SArrayIndex(const char* seq, quint32 size,  quint32 w, bool& activeFlag, char unknownChar=0, const QBitArray& = QBitArray(), quint32 skipGap = 0, quint32 _gapOffset=0);
	~SArrayIndex();

	bool find(SAISearchContext* c, const char* seq);
	bool findBit(SAISearchContext* c, quint32 bitValue, const char* seq);
	quint32 nextArrSeqPos(SAISearchContext* c); //0xFFFFFFFF on end

	/** compares subsequence with offsets x1 and x2, returns -1;0;1 */
	qint32 compare(quint32 x1, quint32 x2) const ;
	inline qint32 compare(const char* seq1,  const char* seq2) const ;

	/** x1 and x2 is bitMask*/
	inline qint32 compareBit(const quint32* x1, const quint32* x2) const;
	/** x1 and x2 is sArray*/
	qint32 compareBitByPos(const quint32* x1, const quint32* x2) const;
	/**compares only after bits chars*/
        qint32 compareAfterBits(quint32 bitMaskPos, const char* afterBitsSeq) const;

	private:
//		quint32 currPos;
//		char* sample;
        bool& activeFlag;
		const char* seqStart;
		SArrayIndex* index;
		qint32 L1_SIZE;
		qint32 L1_SIZE_1;

		quint32* l1bitMask;
		int l1Step;
		
		void sort(quint32* x, qint32 off, qint32 len);
		void sortBitClassic(quint32* x, qint32 off, qint32 len);
		void sortBit(quint32* x, qint32 off, qint32 len);

		qint32  partition(quint32* x, qint32 p, qint32 r);
		
		/** Swaps x[a] with x[b]*/
		inline void swap(quint32* x, quint32 a, quint32 b) const;
		inline void swapBit(quint32* x1, quint32* x2) const;
		
		/** Swaps x[a .. (a+n-1)] with x[b .. (b+n-1)]. */
		inline void vecswap(quint32* x, quint32 a, quint32 b, quint32 n);
		inline int vecswapBit(quint32* x1, quint32* x2,  quint32 n);
		
		/** Returns the index of the median of the three indexed x[] values.*/
		inline quint32 med3(quint32* x, quint32 a, quint32 b, quint32 c);
		inline quint32 med3Bit(quint32* x, quint32 a, quint32 b, quint32 c);
	
		void debugCheck(char c);
};

}//namespace

#endif
