/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_FLOWCHART_H_
#define _GB2_FLOWCHART_H_

#include <core_api/PluginModel.h>
#include <core_api/ServiceModel.h>
#include <core_api/Task.h>

class QAction;
class QEvent;

namespace GB2 {

class WorkflowDocFormat;
class WorkflowViewFactory;

class WorkflowDesignerPlugin : public Plugin {
	Q_OBJECT
public:
    WorkflowDesignerPlugin ();
	//~WorkflowDesignerPlugin ();
};

class WorkflowDesignerService : public Service {
    Q_OBJECT
public:
    WorkflowDesignerService(Plugin* p);
    bool closeViews();
protected:
    //virtual Task* createServiceEnablingTask();

    virtual Task* createServiceDisablingTask();

    virtual void serviceStateChangedCallback(ServiceState oldState, bool enabledStateChanged);

private slots:
        void sl_showDesignerWindow();
        void sl_showManagerWindow();

private:
    QAction*        designerAction;
    QAction*        managerAction;
    WorkflowDocFormat* df;
    WorkflowViewFactory* vf;
};


} //namespace

#endif
