/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_IO_TASK_H_
#define _GB2_WORKFLOW_IO_TASK_H_

#include <core_api/Task.h>
#include <workflow/WorkflowModel.h>
#include <workflow/Schema.h>

class QDomDocument;

namespace GB2 {
class WorkflowScene;
using namespace Workflow;

class ExportWorkflowSchemaTask : public Task {
    Q_OBJECT
public:
    ExportWorkflowSchemaTask(WorkflowScene* scene, const QString& url);
    virtual void run(){
        assert( false );
    };
private:
    const QString url;
    WorkflowScene* scene;
};

class SaveWorkflowSchemaTask : public Task {
    Q_OBJECT
public:
    SaveWorkflowSchemaTask(WorkflowScene* scene, const Metadata& meta);
    virtual void run();
private:
    Metadata meta;
    WorkflowScene* scene;
};

class LoadWorkflowSchemaTask : public Task {
    Q_OBJECT
public:
    LoadWorkflowSchemaTask(WorkflowScene* scene, Metadata* meta, const QString& url);
    virtual void run();
    Task::ReportResult report();
private:
    const QString url;
    WorkflowScene* scene;
    Metadata* meta;
    QDomDocument* xml;
};

} //namespace
#endif
