##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

# include (uhmmer.pri)
include( ../../ugene_globals.pri )
UGENE_RELATIVE_DESTDIR = 'plugins'

TEMPLATE = lib
CONFIG +=qt dll thread debug_and_release
QT += network xml script
DEFINES+= QT_DLL
INCLUDEPATH += src _tmp ../../core/src  ../../core/_tmp

!debug_and_release|build_pass {

    CONFIG(debug, debug|release) {
        TARGET = uhmmerd
        DEFINES+=_DEBUG
        CONFIG +=console
        DESTDIR=../../_debug/plugins
        MOC_DIR=_tmp/moc/debug
        OBJECTS_DIR=_tmp/obj/debug
        LIBS += -L../../_debug -lcored
    }

    CONFIG(release, debug|release) {
        TARGET = uhmmer
        DEFINES+=NDEBUG
        DESTDIR=../../_release/plugins
        MOC_DIR=_tmp/moc/release
        OBJECTS_DIR=_tmp/obj/release
        LIBS += -L../../_release -lcore
    }
}


UI_DIR=_tmp/ui
RCC_DIR=_tmp/rcc

win32 {
    QMAKE_CXXFLAGS_WARN_ON = -W3
    QMAKE_CFLAGS_WARN_ON = -W3

    QMAKE_CXXFLAGS+=/wd4244 /wd4305


    QMAKE_LFLAGS_WINDOWS += /MANIFEST:NO

    QMAKE_MSVC_PROJECT_NAME=plugin_3rd_uhmmer
}


unix {
    contains( UGENE_CELL, 1 ) {
#    	message( "building for Cell BE..." )
	    INCLUDEPATH += $(CELL_TOP)/usr/include
    	DEFINES += ALTIVEC USE_SDK30 UGENE_CELL
    	LIBS += -m32 -lspe2 -lsync src/u_spu/hmmercell_spu.a -lm
    	QMAKE_LIBDIR += $(CELL_TOP)/usr/lib
    	QMAKE_CXXFLAGS += -maltivec
	

        QMAKE_CLEAN += src/u_spu/*.d src/u_spu/*.o src/u_spu/*.a src/u_spu/hmmercell_spu
        target.depends = spe
    	spe.target = src/u_spu/hmmercell_spu.a
    	spe.commands = cd src/u_spu && make -f makefile USE_SDK30=1

    	QMAKE_EXTRA_TARGETS = spe
    	PRE_TARGETDEPS = src/u_spu/hmmercell_spu.a
    }

    target.path = $$UGENE_INSTALL_DIR/$$UGENE_RELATIVE_DESTDIR
    INSTALLS += target
}
