/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_APPCONTEXT_IMPL_
#define _GB2_APPCONTEXT_IMPL_

#include <core_api/AppContext.h>

namespace GB2 {

class CorePlugin;

class AppContextImpl : public AppContext {
public:
    AppContextImpl()  {
        ps = NULL;
        pl = NULL;
        prj = NULL;
        prs = NULL;
        mw = NULL;
        pv = NULL;
        plv = NULL;
        ss = NULL;
	    gs = NULL;
	    dfr = NULL;
	    io = NULL;
	    dtr = NULL;
	    dal = NULL;
	    ovfr = NULL;
        ts = NULL;
	    cp = NULL;
        rt = NULL;
        dfc = NULL;
        asr = NULL;
        as = NULL;
        tf = NULL;
		dbxr = NULL;
        asg = NULL;
    	
        instance = this;
	}

    void setPluginSupport(PluginSupport* _ps) {assert(ps == NULL || _ps == NULL); ps = _ps;}

    void setProjectLoader(ProjectLoader* _pl) {assert(pl == NULL || _pl == NULL); pl = _pl;}

    void setProject(Project* _prj) {assert(prj == NULL || _prj == NULL); prj = _prj;}

	void setProjectService(ProjectService* _prs) {assert(prs == NULL || _prs == NULL); prs = _prs;}

    void setMainWindow(MainWindow* _mw) {assert(mw == NULL || _mw == NULL); mw = _mw;}

    void setProjectView(ProjectView* _pv) {assert(pv == NULL || _pv == NULL); pv = _pv;}

    void setPluginViewer(PluginViewer* _plv) {assert(plv == NULL || _plv == NULL); plv = _plv;}

    void setSettings(Settings* _ss) {assert(ss == NULL || _ss == NULL); ss= _ss;}

	void setGlobalSettings(Settings* _gs) {assert(gs == NULL || _gs == NULL); gs= _gs;}

    void setAppSettings( AppSettings* _as) { assert( as|| _as); as= _as; }

    void setAppSettingsGUI( AppSettingsGUI* _asg) { assert( asg == NULL || _asg == NULL ); asg= _asg; }

	void setDocumentFormatRegistry(DocumentFormatRegistry* _dfr) {assert(dfr == NULL || _dfr == NULL); dfr = _dfr;}

	void setIOAdapterRegistry(IOAdapterRegistry* _io) {assert(io == NULL || _io == NULL); io = _io;}

	void setDNATranslationRegistry(DNATranslationRegistry* _dtr) {assert(dtr == NULL || _dtr == NULL);dtr = _dtr;}
	
	void setDNAAlphabetRegistry(DNAAlphabetRegistry* _dal) {assert(dal == NULL || _dal == NULL);dal = _dal;}

	void setObjectViewFactoryRegistry(GObjectViewFactoryRegistry* _ovfr) {assert(ovfr == NULL || _ovfr == NULL); ovfr = _ovfr;}

	void setTaskScheduler(TaskScheduler* _ts) {assert(ts == NULL || _ts == NULL); ts = _ts;}

	void setCorePlugin(CorePlugin* _cp) {assert(cp == NULL || _cp == NULL); cp = _cp;}

    void setResourceTracker(ResourceTracker* _rt) {assert(rt == NULL || _rt == NULL); rt = _rt;}
    
    void setDocumentFormatConfigurators(DocumentFormatConfigurators* _dfc)  {assert(dfc == NULL || _dfc == NULL); dfc = _dfc;}

    void setAnnotationSettingsRegistry(AnnotationSettingsRegistry* _asr)  {assert(asr == NULL || _asr == NULL); asr = _asr;}

    void setTestFramework( TestFramework* _tf) { assert( tf || _tf ); tf = _tf; }

	void setDBXRefRegistry( DBXRefRegistry* _dbxr) { assert( dbxr == NULL || _dbxr == NULL ); dbxr = _dbxr; }

	CorePlugin* getCorePlugin() const {return cp;}

	static AppContextImpl* getApplicationContext();

protected:
	virtual PluginSupport*  _getPluginSupport() const {return ps;}
	virtual ProjectLoader*	_getProjectLoader() const {return pl;}
	virtual Project*		_getProject() const {return prj;}
	virtual ProjectService* _getProjectService() const {return prs;}
	virtual MainWindow*		_getMainWindow() const {return mw;}
	virtual ProjectView*	_getProjectView() const {return pv;}
	virtual PluginViewer*	_getPluginViewer() const {return plv;}
	virtual Settings*		_getSettings() const {return ss;}
	virtual Settings*		_getGlobalSettings() const {return gs;}
    virtual AppSettings*    _getAppSettings() const{return as;};
    virtual AppSettingsGUI* _getAppSettingsGUI() const{return asg;};

    virtual DocumentFormatRegistry*		_getDocumentFormatRegistry() const {return dfr;}
	virtual IOAdapterRegistry*			_getIOAdapterRegistry() const  {return io;}
	virtual DNATranslationRegistry*		_getDNATranslationRegistry() const  {return dtr;}
	virtual DNAAlphabetRegistry*		_getDNAAlphabetRegistry() const {return dal;}
	virtual GObjectViewFactoryRegistry* _getObjectViewFactoryRegistry() const  {return ovfr;}
	virtual TaskScheduler*				_getTaskScheduler() const  {return ts;}
    virtual ResourceTracker*            _getResourceTracker() const {return rt;}
    virtual AnnotationSettingsRegistry* _getAnnotationsSettingsRegistry() const {return asr;}
    virtual TestFramework*              _getTestFramework() const {return tf;}
	virtual DBXRefRegistry*             _getDBXRefRegistry() const{return dbxr;};

    virtual DocumentFormatConfigurators*    _getDocumentFormatConfigurators() const {return dfc;}
    
private:
    PluginSupport* ps;
    ProjectLoader* pl;
    Project*    prj;
    ProjectService* prs;
    MainWindow* mw;
    ProjectView* pv;
    PluginViewer* plv;
    Settings* ss;
	Settings* gs;
	DocumentFormatRegistry* dfr;
	IOAdapterRegistry* io;
	DNATranslationRegistry* dtr;
	DNAAlphabetRegistry* dal;
	GObjectViewFactoryRegistry* ovfr;
    TaskScheduler* ts;
	CorePlugin* cp;
    ResourceTracker* rt;
    DocumentFormatConfigurators* dfc;
    AnnotationSettingsRegistry* asr;
    AppSettings * as;
    TestFramework* tf;
	DBXRefRegistry* dbxr;
    AppSettingsGUI* asg;
};

}//namespace

#endif 

