/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CORE_PLUGIN_H_
#define _GB2_CORE_PLUGIN_H_

#include <core_api/PluginModel.h>
namespace GB2 {

class CorePlugin : public Plugin {
    Q_OBJECT
public:
	CorePlugin() : Plugin(tr("core_plugin_name"), tr("core_plugin_desc")), shutdown(false){}
    ~CorePlugin() {shutdown = true;}
	
	//todo: signals? redesign model of runtime service->plugin binding

	void addService(Service* s) {
        services.push_back(s);
    }

	void removeService(Service* s) {
        services.removeOne(s);
    }

    bool shutdown;
};


}//namespace
#endif

