/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "AppSettingsGUIImpl.h"
#include "AppSettingsDialogController.h"

#include "network_settings/NetworkSettingsGUIController.h"
#include "user_apps_settings/UserApplicationsSettingsGUIController.h"

#include <core_api/AppContext.h>
#include <core_api/MainWindow.h>

#include <QtGui/QMenu>

namespace GB2 {
AppSettingsGUIImpl::AppSettingsGUIImpl(QObject* p) : AppSettingsGUI(p)
{
    registerBuiltinPages();
    QMenu* m = AppContext::getMainWindow()->getMenuManager()->getTopLevelMenu(MWMENU_SETTINGS);
    m->addAction(tr("app_settings"), this, SLOT(sl_showSettingsDialog()));
}

AppSettingsGUIImpl::~AppSettingsGUIImpl() {
    foreach(AppSettingsGUIPageController* page, pages) {
        delete page;
    }
}

bool AppSettingsGUIImpl::registerPage(AppSettingsGUIPageController* page, const QString& beforePage) {
    AppSettingsGUIPageController* c = findPageById(page->getPageId());
    if (c != NULL) {
        return false;
    }
    if (!beforePage.isEmpty()) {
        AppSettingsGUIPageController* before = findPageById(beforePage);        
        if (before!=NULL) {
            int i = pages.indexOf(before);
            pages.insert(i, page);
            return true;
        }
    }
    pages.append(page);
    return true;
}

bool AppSettingsGUIImpl::unregisterPage(AppSettingsGUIPageController* page) {
    AppSettingsGUIPageController* c = findPageById(page->getPageId());
    if (c == NULL) {
        return false;
    }
    pages.removeOne(page);
    return true;
}

void AppSettingsGUIImpl::showSettingsDialog(const QString& pageId) const {
    AppSettingsDialogController c(pageId);
    c.exec();
}

AppSettingsGUIPageController* AppSettingsGUIImpl::findPageById(const QString& pageId) const {
    foreach(AppSettingsGUIPageController* page, pages) {
        if (page->getPageId() == pageId) {
            return page;
        }
    }
    return NULL;
}

void AppSettingsGUIImpl::registerBuiltinPages() {
    registerPage(new NetworkSettingsPageController());
    registerPage(new UserApplicationsSettingsPageController());
}

}//namespace
