/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LOGVIEW_IMPL_
#define _GB2_LOGVIEW_IMPL_

#include "LogSettings.h"


#include <core_api/AppContext.h>

#include <QtCore/QHash>
#include <QtGui/QPlainTextEdit>

namespace GB2 {

class LogCache;
class LogMessage;

class LogViewDockWidget : public QWidget {
    Q_OBJECT
public:
    LogViewDockWidget(LogCache* c);

    void resetView();
    
    bool isShown(const LogMessage& msg);

    const LogSettings& getSettings() const {return settings;}

    void setSettings(const LogSettings& s); 

    const QString getLocalizedLevelName(LogLevel l) const {return localizedLevelNames[l];}


protected:
    void addMessage(const LogMessage& msg);
    void showEvent(QShowEvent *e);
    void hideEvent(QHideEvent *e);

private slots:

    void sl_onMessage(const LogMessage& msg);
	void popupMenu(const QPoint &pos);
    void sl_openSettingsDialog();
    void sl_logSettingsChanged();

private:
    
    QString prepareText(const LogMessage& msg) const;

    QPlainTextEdit*          edit;
	int                 messageCounter;
    LogCache*           cache;
    QAction*            showViewAction;
    QAction*            showSettingsAction;

    QString localizedLevelNames[LogLevel_NumLevels];
    LogSettings settings;

    bool connected; //for debug only
};

} //namespace

#endif
