/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CHECK_UPDATES_TASKS_H_
#define _GB2_CHECK_UPDATES_TASKS_H_

#include <QtCore/QEventLoop>
#include <QtCore/QBuffer>
#include <QtNetwork/QHttp>

#include <core_api/Task.h>

namespace GB2 {

class CheckUpdatesTask : public Task {
    Q_OBJECT

public:
    CheckUpdatesTask();
    void run();
    ReportResult report();

    QString siteVersion;
};

class SyncHTTP: public QHttp {
    Q_OBJECT
public:
    SyncHTTP(const QString& hostName, quint16 port=80, QObject* parent=0);
    QString syncGet(const QString& path);

protected slots:
    virtual void finished(int idx, bool err);

private:
    int requestID;
    QEventLoop loop;
};


}//namespace

#endif
