/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SERVICE_REGISTRY_IMPL_
#define _GB2_SERVICE_REGISTRY_IMPL_

#include <core_api/ServiceModel.h>
#include <core_api/Task.h>

#include <QtCore/QMap>

namespace GB2 {

class RegisterServiceTask;
class EnableServiceTask;
class UnregisterServiceTask;
class DisableServiceTask;


class ServiceRegistryImpl : public ServiceRegistry {
    Q_OBJECT

	friend class RegisterServiceTask;
	friend class EnableServiceTask;
	friend class UnregisterServiceTask;
	friend class DisableServiceTask;

public:
    ServiceRegistryImpl() {timerIsActive = false;}
	~ServiceRegistryImpl();

	/// Returns list of all registered services
	virtual const QList<Service*>& getServices() const {return services;}

	/// Finds service with the specified ServiceType
	virtual QList<Service*> findServices(ServiceType t) const;

	virtual Task* registerServiceTask(Service* s);

	virtual Task* unregisterServiceTask(Service* s);

	virtual Task* enableServiceTask(Service* s);

	virtual Task* disableServiceTask(Service* s);

	void unregisterPluginServices(Plugin* p);

private:
	void initiateServicesCheckTask();

	Service* findServiceReadyToEnable() const;

	void setServiceState(Service* s, ServiceState state);
	Task* createServiceEnablingTask(Service* s) {return _createServiceEnablingTask(s);}
	Task* createServiceDisablingTask(Service* s) {return _createServiceDisablingTask(s);}

protected:
	void timerEvent(QTimerEvent *event);

private:
    QList<Service*> services;
	bool			timerIsActive;
	QList<Task*> activeServiceTasks;
};

class RegisterServiceTask : public Task {
    Q_OBJECT
public:
	RegisterServiceTask(ServiceRegistryImpl* sr, Service* s);

	virtual void prepare();

private:
	ServiceRegistryImpl* sr;
	Service* s;
};

class EnableServiceTask : public Task {
    Q_OBJECT
public:
	EnableServiceTask(ServiceRegistryImpl* sr, Service* s);

	virtual void prepare();

	virtual ReportResult report();

private:
	ServiceRegistryImpl* sr;
	Service* s;
};

class UnregisterServiceTask : public Task {
    Q_OBJECT
public:
	UnregisterServiceTask(ServiceRegistryImpl* sr, Service* s);

	virtual void prepare();

	virtual ReportResult report();

private:
	ServiceRegistryImpl* sr;
	Service* s;
};


class DisableServiceTask : public Task {
    Q_OBJECT
public:
	DisableServiceTask(ServiceRegistryImpl* sr, Service* s, bool manual);

	virtual void prepare();

	virtual ReportResult report();

private:
	ServiceRegistryImpl* sr;
	Service* s;
	bool manual;
};


}//namespace


#endif


