/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ScriptManagerView.h"
#include "ScriptManagerWidgetImpl.h"

#include <core_api/AppContext.h>
#include <core_api/MainWindow.h>
#include <core_api/ScriptRegistry.h>
#include <core_api/ServiceTypes.h>

#include <QtGui/QMenu>
#include <QtGui/QPushButton>


namespace GB2 
{

ScriptManagerDialog::ScriptManagerDialog( ScriptRegistryService * sr ) {
    setWindowTitle(tr("script_registry_title"));
    w = new ScriptManagerWidgetImpl( this, sr );
    connect(w->closeButton, SIGNAL(clicked()), SLOT(reject()));
    QVBoxLayout * l = new QVBoxLayout();
    l->addWidget( w );
    setLayout( l );
    resize( w->size() );
}


ScriptManagerView::ScriptManagerView() {
    QMenu * m = AppContext::getMainWindow()->getMenuManager()->getTopLevelMenu( MWMENU_SETTINGS );
    QAction * a = new QAction( QIcon(":ugene/images/script_registry.png"), tr("script_manager"), this );
    m->addAction( a );
    connect( a, SIGNAL(triggered()), SLOT(sl_showWidget()) );

}

void ScriptManagerView::sl_showWidget() {
    QList<Service *> ls = AppContext::getPluginSupport()->getServiceRegistry()->findServices( Service_ScriptRegistry );
    ScriptRegistryService * sr = qobject_cast<ScriptRegistryService *>( ls.at(0) );
    assert( sr );

    ScriptManagerDialog dlg( sr );
    dlg.exec();
}

} //namespace
