/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "AppContext.h"
#include "ProjectModel.h"
#include "DBXRefRegistry.h"
#include "MainWindow.h"

namespace GB2 {

AppContext* AppContext::instance = NULL;
void AppContext::_setupToEngine(QScriptEngine *engine){
    Project::setupToEngine(engine);
    DBXRefRegistry::setupToEngine(engine);
    MainWindow::setupToEngine(engine);
    QScriptValue scriptAppContext = engine->newQObject(getInstance());
    engine->globalObject().setProperty("AppContext", scriptAppContext);
}

}//namespace
