/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Counter.h"

namespace GB2 {

QList<GCounter*>& GCounter::getCounters() {
    static QList<GCounter*> counters;
    return counters;
}

GCounter::GCounter(const QString& _name, const QString& s, double scale) : name(_name), suffix(s), totalCount(0), counterScale(scale) {
    assert(counterScale > 0);
    getCounters().append(this);
    dynamicCounter = false;
}

GCounter::~GCounter() {
    if (dynamicCounter) {
        getCounters().removeOne(this);
    }
}

} //namespace

