/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DOC_FORMAT_CONFIG_H_
#define _GB2_DOC_FORMAT_CONFIG_H_

#include "core_api.h"

namespace GB2 {

class GB2_COREAPI_EXPORT DocumentFormatConfigurator : public QObject {
    Q_OBJECT
public:
    DocumentFormatConfigurator(const DocumentFormatId& _formatId, QObject* p = NULL): QObject(p), formatId(_formatId){}
    
    DocumentFormatId getFormatId() const {return formatId;}

    virtual void configure(QVariantMap& info) = 0;

protected:
    DocumentFormatId formatId;
};


class GB2_COREAPI_EXPORT DocumentFormatConfigurators : public QObject {
    Q_OBJECT
public:
    DocumentFormatConfigurators(QObject* p = NULL): QObject(p){}
    virtual ~DocumentFormatConfigurators();


    void registerConfigurator(DocumentFormatConfigurator* c);
    
    void unregisterConfigurator(const DocumentFormatId& id);

    DocumentFormatConfigurator* findConfigurator(const DocumentFormatId& id) const;

private:
    QMap<DocumentFormatId, DocumentFormatConfigurator*> configs;
};


}//namespace

#endif
