/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_APPCONTEXT_IMPL_
#define _GB2_APPCONTEXT_IMPL_

#include <core_api/AppContext.h>
#include <QtScript>

namespace GB2 {

class GB2_COREAPI_EXPORT AppContextImpl : public AppContext {
    Q_OBJECT
public:
    AppContextImpl()  {
        ps = NULL;
        sr = NULL;
        pl = NULL;
        prj = NULL;
        prs = NULL;
        mw = NULL;
        pv = NULL;
        plv = NULL;
        ss = NULL;
        gs = NULL;
        dfr = NULL;
        io = NULL;
        dtr = NULL;
        dal = NULL;
        ovfr = NULL;
        ts = NULL;
        rt = NULL;
        dfc = NULL;
        asr = NULL;
        as = NULL;
        tf = NULL;
        dbxr = NULL;
        asg = NULL;
        smr = NULL;
        swar = NULL;
        msfr = NULL;
        swrfr = NULL;
        gsr = NULL;
        mcsr = NULL;
        smreg = NULL;
        sspar = NULL;
        cgr = NULL;
        rdc = NULL;
        instance = this;
    }

    void setPluginSupport(PluginSupport* _ps) {assert(ps == NULL || _ps == NULL); ps = _ps;}

    void setServiceRegistry(ServiceRegistry* _sr) {assert(sr == NULL || _sr == NULL); sr = _sr;}

    void setProjectLoader(ProjectLoader* _pl) {assert(pl == NULL || _pl == NULL); pl = _pl;}

    void setProject(Project* _prj) {assert(prj == NULL || _prj == NULL); prj = _prj;}

    void setProjectService(ProjectService* _prs) {assert(prs == NULL || _prs == NULL); prs = _prs;}

    void setMainWindow(MainWindow* _mw) {assert(mw == NULL || _mw == NULL); mw = _mw;}

    void setProjectView(ProjectView* _pv) {assert(pv == NULL || _pv == NULL); pv = _pv;}

    void setPluginViewer(PluginViewer* _plv) {assert(plv == NULL || _plv == NULL); plv = _plv;}

    void setSettings(Settings* _ss) {assert(ss == NULL || _ss == NULL); ss= _ss;}

    void setGlobalSettings(Settings* _gs) {assert(gs == NULL || _gs == NULL); gs= _gs;}

    void setAppSettings( AppSettings* _as) { assert( as|| _as); as= _as; }

    void setAppSettingsGUI( AppSettingsGUI* _asg) { assert( asg == NULL || _asg == NULL ); asg= _asg; }

    void setDocumentFormatRegistry(DocumentFormatRegistry* _dfr) {assert(dfr == NULL || _dfr == NULL); dfr = _dfr;}

    void setIOAdapterRegistry(IOAdapterRegistry* _io) {assert(io == NULL || _io == NULL); io = _io;}

    void setDNATranslationRegistry(DNATranslationRegistry* _dtr) {assert(dtr == NULL || _dtr == NULL);dtr = _dtr;}
    
    void setDNAAlphabetRegistry(DNAAlphabetRegistry* _dal) {assert(dal == NULL || _dal == NULL);dal = _dal;}

    void setObjectViewFactoryRegistry(GObjectViewFactoryRegistry* _ovfr) {assert(ovfr == NULL || _ovfr == NULL); ovfr = _ovfr;}

    void setTaskScheduler(TaskScheduler* _ts) {assert(ts == NULL || _ts == NULL); ts = _ts;}

    void setResourceTracker(ResourceTracker* _rt) {assert(rt == NULL || _rt == NULL); rt = _rt;}
    
    void setDocumentFormatConfigurators(DocumentFormatConfigurators* _dfc)  {assert(dfc == NULL || _dfc == NULL); dfc = _dfc;}

    void setAnnotationSettingsRegistry(AnnotationSettingsRegistry* _asr)  {assert(asr == NULL || _asr == NULL); asr = _asr;}

    void setTestFramework( TestFramework* _tf) { assert( tf || _tf ); tf = _tf; }

    void setDBXRefRegistry( DBXRefRegistry* _dbxr) { assert( dbxr == NULL || _dbxr == NULL ); dbxr = _dbxr; }

    void setSubstMatrixRegistry(SubstMatrixRegistry* _smr) { assert( smr == NULL || _smr == NULL ); smr = _smr; }

    void setSmithWatermanTaskFactoryRegistry (SmithWatermanTaskFactoryRegistry* _swar) { assert( swar == NULL || _swar == NULL ); swar = _swar; }
    
    void setMolecularSurfaceFactoryRegistry (MolecularSurfaceFactoryRegistry* _msfr) { assert( msfr == NULL || _msfr == NULL ); msfr = _msfr; }

    void setSWResultFilterRegistry (SWResultFilterRegistry* _swrfr) { assert( swrfr == NULL || _swrfr == NULL ); swrfr = _swrfr; }

    void setScriptRunner (GScriptRunner* _gsr) { assert( gsr == NULL || _gsr == NULL ); gsr = _gsr; }
    
    void setMSAColorSchemeRegistry(MSAColorSchemeRegistry* _mcsr) {assert( mcsr == NULL || _mcsr == NULL ); mcsr = _mcsr;}
    
    void setSecStructPedictAlgRegistry(SecStructPredcitAlgRegistry* _sspar) {assert( sspar == NULL || _sspar == NULL ); sspar = _sspar;}

    void setCudaGpuRegistry( CudaGpuRegistry * _cgr ) { assert( cgr == NULL || _cgr == NULL ); cgr = _cgr; }

    void setRecentlyDownloadedCache( RecentlyDownloadedCache* _rdc) { assert( rdc == NULL || _rdc == NULL ); rdc = _rdc;}

    void setScriptModuleRegistry (GScriptModuleRegistry* _smreg) { assert( smreg == NULL || _smreg == NULL ); smreg = _smreg; }

    static AppContextImpl* getApplicationContext();

protected:
    virtual PluginSupport*  _getPluginSupport() const {return ps;}
    virtual ServiceRegistry*  _getServiceRegistry() const {return sr;}
    virtual ProjectLoader*  _getProjectLoader() const {return pl;}
    virtual Project*        _getProject() const {return prj;}
    virtual ProjectService* _getProjectService() const {return prs;}
    virtual MainWindow*     _getMainWindow() const {return mw;}
    virtual ProjectView*    _getProjectView() const {return pv;}
    virtual PluginViewer*   _getPluginViewer() const {return plv;}
    virtual Settings*       _getSettings() const {return ss;}
    virtual Settings*       _getGlobalSettings() const {return gs;}
    virtual AppSettings*    _getAppSettings() const{return as;};
    virtual AppSettingsGUI* _getAppSettingsGUI() const{return asg;};

    virtual DocumentFormatRegistry*     _getDocumentFormatRegistry() const {return dfr;}
    virtual IOAdapterRegistry*          _getIOAdapterRegistry() const  {return io;}
    virtual DNATranslationRegistry*     _getDNATranslationRegistry() const  {return dtr;}
    virtual DNAAlphabetRegistry*        _getDNAAlphabetRegistry() const {return dal;}
    virtual GObjectViewFactoryRegistry* _getObjectViewFactoryRegistry() const  {return ovfr;}
    virtual TaskScheduler*              _getTaskScheduler() const  {return ts;}
    virtual ResourceTracker*            _getResourceTracker() const {return rt;}
    virtual AnnotationSettingsRegistry* _getAnnotationsSettingsRegistry() const {return asr;}
    virtual TestFramework*              _getTestFramework() const {return tf;}
    virtual DBXRefRegistry*             _getDBXRefRegistry() const {return dbxr;}
    virtual SubstMatrixRegistry*        _getSubstMatrixRegistry() const {return smr;}
    virtual SmithWatermanTaskFactoryRegistry*   _getSmithWatermanTaskFactoryRegistry() const {return swar;}
    virtual MolecularSurfaceFactoryRegistry*   _getMolecularSurfaceFactoryRegistry() const {return msfr;}
    virtual SWResultFilterRegistry*     _getSWResultFilterRegistry() const {return swrfr;}
    virtual GScriptRunner*              _getScriptRunner() const {return gsr;}
    virtual MSAColorSchemeRegistry*     _getMSAColorSchemeRegistry() const {return mcsr;}
    virtual GScriptModuleRegistry*      _getScriptModuleRegistry() const {return smreg;};
    virtual SecStructPredcitAlgRegistry* _getSecStructPredictAlgRegistry() const {return sspar;}
    virtual CudaGpuRegistry *            _getCudaGpuRegistry() const { return cgr; }
    virtual RecentlyDownloadedCache*     _getRecentlyDownloadedCache() const {return rdc;}
    virtual DocumentFormatConfigurators*    _getDocumentFormatConfigurators() const {return dfc;}
    
private:
    PluginSupport* ps;
    ServiceRegistry* sr;
    ProjectLoader* pl;
    Project*    prj;
    ProjectService* prs;
    MainWindow* mw;
    ProjectView* pv;
    PluginViewer* plv;
    Settings* ss;
    Settings* gs;
    DocumentFormatRegistry* dfr;
    IOAdapterRegistry* io;
    DNATranslationRegistry* dtr;
    DNAAlphabetRegistry* dal;
    GObjectViewFactoryRegistry* ovfr;
    TaskScheduler* ts;
    ResourceTracker* rt;
    DocumentFormatConfigurators* dfc;
    AnnotationSettingsRegistry* asr;
    AppSettings * as;
    TestFramework* tf;
    DBXRefRegistry* dbxr;
    SubstMatrixRegistry* smr;
    SmithWatermanTaskFactoryRegistry* swar;
    MolecularSurfaceFactoryRegistry* msfr;
    SWResultFilterRegistry*  swrfr;
    GScriptRunner* gsr;
    GScriptModuleRegistry* smreg;
    AppSettingsGUI* asg;
    MSAColorSchemeRegistry* mcsr;
    SecStructPredcitAlgRegistry* sspar;
    CudaGpuRegistry * cgr;
    RecentlyDownloadedCache* rdc;
};

}//namespace

#endif 

