/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIOSTRUCT3D_OBJECT_H_
#define _GB2_BIOSTRUCT3D_OBJECT_H_

#include <core_api/GObject.h>
#include <core_api/LRegion.h>
#include <datatype/BioStruct3D.h>

namespace GB2 {

class  GB2_COREAPI_EXPORT BioStruct3DObject: public GObject {
    Q_OBJECT
public:
    BioStruct3DObject(const BioStruct3D& bioStruct, const QString& objectName, const QVariantMap& hintsMap = QVariantMap());
    const BioStruct3D& getBioStruct3D() const { return bioStruct3D;}
    virtual GObject* clone() const;

protected:
    BioStruct3D     bioStruct3D;

};

} //namespace


#endif //_GB2_BIOSTRUCT3D_OBJECT_H_
