/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PHYTREE_OBJECT_H_
#define _GB2_PHYTREE_OBJECT_H_

#include "GObjectTypes.h"

#include <core_api/GObject.h>
#include <datatype/PhyTree.h>

namespace GB2 {

class GB2_COREAPI_EXPORT PhyTreeObject : public GObject {
    Q_OBJECT
public:
    PhyTreeObject(const PhyTree& _tree, const QString& objectName, const QVariantMap& hintsMap = QVariantMap()) 
        : GObject(GObjectTypes::PHYLOGENETIC_TREE, objectName, hintsMap), tree(_tree){};

    virtual const PhyTree& getTree() const {return tree;}

    virtual GObject* clone() const;

protected:
    PhyTree tree;
};

}//namespace


#endif
