/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "MemBufAdapter.h"

namespace GB2 {

MemBufAdapterFactory::MemBufAdapterFactory(QObject* o) : IOAdapterFactory(o) {
    name = tr("Memory buffer");
}		

IOAdapter* MemBufAdapterFactory::createIOAdapter() {
    return new MemBufAdapter(this);
}

MemBufAdapter::MemBufAdapter(MemBufAdapterFactory* factory, QObject* o) : IOAdapter(factory, o), byteArray(NULL), buffer(NULL) {
}		


bool MemBufAdapter::open(const QString& data, IOAdapterMode m) {
    assert(!isOpen());
    assert(byteArray == NULL);
    assert(buffer == NULL);
    
    if (data.isEmpty()) {
        return false;
    }
    
    byteArray = new QByteArray(data.toAscii());
    QIODevice::OpenMode iomode = m == IOAdapterMode_Read ? QIODevice::ReadOnly : QIODevice::WriteOnly | QIODevice::Truncate;
    buffer = new QBuffer(byteArray);
    if (!buffer->open(iomode)) {
        return false;
    }

    return true;
}

void MemBufAdapter::close() {
    assert(isOpen());
    if (!isOpen()) {
        return;
    }
    delete buffer;
    delete byteArray;
    buffer = NULL;
    byteArray = NULL;
}

qint64 MemBufAdapter::readBlock(char* data, qint64 size) {
    qint64 l = buffer->read(data, size);
    return l;
}

qint64 MemBufAdapter::writeBlock(const char* data, qint64 size) {
    qint64 l = buffer->write(data, size);
    return l;
}

bool MemBufAdapter::skip(qint64 nBytes) {
    assert(isOpen());
    if (!isOpen()) {
        return false;
    }
    qint64 p = buffer->pos();
    return buffer->seek(p+nBytes);
}

qint64 MemBufAdapter::left() const {
    assert(isOpen());
    qint64 p = buffer->pos();
    qint64 len = buffer->size();
    return len - p;
}

int MemBufAdapter::getProgress() const {
    assert(isOpen());
    return int(100 * float(buffer->pos()) / buffer->size());
}

qint64 MemBufAdapter::bytesRead() const {
    return buffer->pos();
}

QString MemBufAdapter::getUrl() const {
    return "";
}

};//namespace
